# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'OtsBackupPlanOtsDetail',
    'OtsBackupPlanRule',
    'RestoreJobOtsDetail',
    'ServerBackupPlanDetail',
    'GetBackupJobsFilterResult',
    'GetBackupJobsJobResult',
    'GetBackupJobsJobOtsDetailResult',
    'GetEcsBackupClientsClientResult',
    'GetEcsBackupPlansPlanResult',
    'GetHanaBackupClientsHanaBackupClientResult',
    'GetHanaBackupPlansPlanResult',
    'GetHanaInstancesInstanceResult',
    'GetNasBackupPlansPlanResult',
    'GetOssBackupPlansPlanResult',
    'GetOtsBackupPlansPlanResult',
    'GetOtsBackupPlansPlanOtsDetailResult',
    'GetOtsSnapshotsSnapshotResult',
    'GetReplicationVaultRegionsRegionResult',
    'GetRestoreJobsJobResult',
    'GetServerBackupPlansFilterResult',
    'GetServerBackupPlansPlanResult',
    'GetServerBackupPlansPlanDetailResult',
    'GetSnapshotsSnapshotResult',
    'GetVaultsVaultResult',
]

@pulumi.output_type
class OtsBackupPlanOtsDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableNames":
            suggest = "table_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OtsBackupPlanOtsDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OtsBackupPlanOtsDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OtsBackupPlanOtsDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table_names: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] table_names: The names of the destination tables in the Tablestore instance. **Note:** Required while source_type equals `OTS_TABLE`.
        """
        if table_names is not None:
            pulumi.set(__self__, "table_names", table_names)

    @property
    @pulumi.getter(name="tableNames")
    def table_names(self) -> Optional[Sequence[str]]:
        """
        The names of the destination tables in the Tablestore instance. **Note:** Required while source_type equals `OTS_TABLE`.
        """
        return pulumi.get(self, "table_names")


@pulumi.output_type
class OtsBackupPlanRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupType":
            suggest = "backup_type"
        elif key == "ruleName":
            suggest = "rule_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OtsBackupPlanRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OtsBackupPlanRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OtsBackupPlanRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_type: Optional[str] = None,
                 disabled: Optional[bool] = None,
                 retention: Optional[str] = None,
                 rule_name: Optional[str] = None,
                 schedule: Optional[str] = None):
        """
        :param str backup_type: Backup type. Valid values: `COMPLETE`.
        :param bool disabled: Whether to disable the backup task. Valid values: `true`, `false`. Default values: `false`.
        :param str retention: Backup retention days, the minimum is 1.
        :param str rule_name: The name of the backup rule.**Note:** Required while source_type equals `OTS_TABLE`. `rule_name` should be unique for the specific user.
        :param str schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        """
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[str]:
        """
        Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Whether to disable the backup task. Valid values: `true`, `false`. Default values: `false`.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def retention(self) -> Optional[str]:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[str]:
        """
        The name of the backup rule.**Note:** Required while source_type equals `OTS_TABLE`. `rule_name` should be unique for the specific user.
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter
    def schedule(self) -> Optional[str]:
        """
        Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class RestoreJobOtsDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "overwriteExisting":
            suggest = "overwrite_existing"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestoreJobOtsDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestoreJobOtsDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestoreJobOtsDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 overwrite_existing: Optional[bool] = None):
        """
        :param bool overwrite_existing: Whether to overwrite the existing table storage recovery task. Valid values: `true`, `false`.
        """
        if overwrite_existing is not None:
            pulumi.set(__self__, "overwrite_existing", overwrite_existing)

    @property
    @pulumi.getter(name="overwriteExisting")
    def overwrite_existing(self) -> Optional[bool]:
        """
        Whether to overwrite the existing table storage recovery task. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "overwrite_existing")


@pulumi.output_type
class ServerBackupPlanDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appConsistent":
            suggest = "app_consistent"
        elif key == "snapshotGroup":
            suggest = "snapshot_group"
        elif key == "destinationRegionId":
            suggest = "destination_region_id"
        elif key == "destinationRetention":
            suggest = "destination_retention"
        elif key == "diskIdLists":
            suggest = "disk_id_lists"
        elif key == "doCopy":
            suggest = "do_copy"
        elif key == "enableFsFreeze":
            suggest = "enable_fs_freeze"
        elif key == "postScriptPath":
            suggest = "post_script_path"
        elif key == "preScriptPath":
            suggest = "pre_script_path"
        elif key == "timeoutInSeconds":
            suggest = "timeout_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerBackupPlanDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerBackupPlanDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerBackupPlanDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_consistent: bool,
                 snapshot_group: bool,
                 destination_region_id: Optional[str] = None,
                 destination_retention: Optional[int] = None,
                 disk_id_lists: Optional[Sequence[str]] = None,
                 do_copy: Optional[bool] = None,
                 enable_fs_freeze: Optional[bool] = None,
                 post_script_path: Optional[str] = None,
                 pre_script_path: Optional[str] = None,
                 timeout_in_seconds: Optional[int] = None):
        """
        :param bool app_consistent: Whether to turn on application consistency. The application consistency snapshot backs up memory data and ongoing database transactions at the time of snapshot creation to ensure the consistency of application system data and database transactions. By applying consistent snapshots, there is no data damage or loss, so as to avoid log rollback during database startup and ensure that the application is in a consistent startup state. Valid values: `true`, `false`.
        :param bool snapshot_group: Whether to turn on file system consistency. If SnapshotGroup is true, when AppConsistent is true but the relevant conditions are not met or AppConsistent is false, the resulting snapshot will be a file system consistency snapshot. The file system consistency ensures that the file system memory and disk information are synchronized at the time of snapshot creation, and the file system write operation is frozen to make the file system in a consistent state. The file system consistency snapshot can prevent the operating system from performing disk inspection and repair operations such as CHKDSK or fsck after restart. Valid values: `true`, `false`.
        :param str destination_region_id: Only vaild when DoCopy is true. The destination region ID when replicating to another region. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param int destination_retention: Only vaild when DoCopy is true. The retention days of the destination backup. When not specified, the destination backup will be saved permanently. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param Sequence[str] disk_id_lists: The list of cloud disks to be backed up in the ECS instance. When not specified, a snapshot is executed for all the disks on the ECS instance.
        :param bool do_copy: Whether replicate to another region. Valid values: `true`, `false`.
        :param bool enable_fs_freeze: Only the Linux system is valid. Whether to use the Linux FsFreeze mechanism to ensure that the file system is read-only consistent before creating a storage snapshot. The default is True. Valid values: `true`, `false`.
        :param str post_script_path: Only vaild for the linux system when AppConsistent is true. The application thaw script path (e.g. /tmp/postscript.sh). The postscript.sh script must meet the following conditions: in terms of permissions, only the root user as the owner has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        :param str pre_script_path: Only vaild for the linux system when AppConsistent is true. Apply the freeze script path (e.g. /tmp/prescript.sh). prescript.sh scripts must meet the following conditions: in terms of permissions, only root, as the owner, has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        :param int timeout_in_seconds: Only the Linux system is valid, and the IO freeze timeout period. The default is 30 seconds.
        """
        pulumi.set(__self__, "app_consistent", app_consistent)
        pulumi.set(__self__, "snapshot_group", snapshot_group)
        if destination_region_id is not None:
            pulumi.set(__self__, "destination_region_id", destination_region_id)
        if destination_retention is not None:
            pulumi.set(__self__, "destination_retention", destination_retention)
        if disk_id_lists is not None:
            pulumi.set(__self__, "disk_id_lists", disk_id_lists)
        if do_copy is not None:
            pulumi.set(__self__, "do_copy", do_copy)
        if enable_fs_freeze is not None:
            pulumi.set(__self__, "enable_fs_freeze", enable_fs_freeze)
        if post_script_path is not None:
            pulumi.set(__self__, "post_script_path", post_script_path)
        if pre_script_path is not None:
            pulumi.set(__self__, "pre_script_path", pre_script_path)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @property
    @pulumi.getter(name="appConsistent")
    def app_consistent(self) -> bool:
        """
        Whether to turn on application consistency. The application consistency snapshot backs up memory data and ongoing database transactions at the time of snapshot creation to ensure the consistency of application system data and database transactions. By applying consistent snapshots, there is no data damage or loss, so as to avoid log rollback during database startup and ensure that the application is in a consistent startup state. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "app_consistent")

    @property
    @pulumi.getter(name="snapshotGroup")
    def snapshot_group(self) -> bool:
        """
        Whether to turn on file system consistency. If SnapshotGroup is true, when AppConsistent is true but the relevant conditions are not met or AppConsistent is false, the resulting snapshot will be a file system consistency snapshot. The file system consistency ensures that the file system memory and disk information are synchronized at the time of snapshot creation, and the file system write operation is frozen to make the file system in a consistent state. The file system consistency snapshot can prevent the operating system from performing disk inspection and repair operations such as CHKDSK or fsck after restart. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "snapshot_group")

    @property
    @pulumi.getter(name="destinationRegionId")
    def destination_region_id(self) -> Optional[str]:
        """
        Only vaild when DoCopy is true. The destination region ID when replicating to another region. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "destination_region_id")

    @property
    @pulumi.getter(name="destinationRetention")
    def destination_retention(self) -> Optional[int]:
        """
        Only vaild when DoCopy is true. The retention days of the destination backup. When not specified, the destination backup will be saved permanently. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "destination_retention")

    @property
    @pulumi.getter(name="diskIdLists")
    def disk_id_lists(self) -> Optional[Sequence[str]]:
        """
        The list of cloud disks to be backed up in the ECS instance. When not specified, a snapshot is executed for all the disks on the ECS instance.
        """
        return pulumi.get(self, "disk_id_lists")

    @property
    @pulumi.getter(name="doCopy")
    def do_copy(self) -> Optional[bool]:
        """
        Whether replicate to another region. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "do_copy")

    @property
    @pulumi.getter(name="enableFsFreeze")
    def enable_fs_freeze(self) -> Optional[bool]:
        """
        Only the Linux system is valid. Whether to use the Linux FsFreeze mechanism to ensure that the file system is read-only consistent before creating a storage snapshot. The default is True. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_fs_freeze")

    @property
    @pulumi.getter(name="postScriptPath")
    def post_script_path(self) -> Optional[str]:
        """
        Only vaild for the linux system when AppConsistent is true. The application thaw script path (e.g. /tmp/postscript.sh). The postscript.sh script must meet the following conditions: in terms of permissions, only the root user as the owner has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        """
        return pulumi.get(self, "post_script_path")

    @property
    @pulumi.getter(name="preScriptPath")
    def pre_script_path(self) -> Optional[str]:
        """
        Only vaild for the linux system when AppConsistent is true. Apply the freeze script path (e.g. /tmp/prescript.sh). prescript.sh scripts must meet the following conditions: in terms of permissions, only root, as the owner, has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        """
        return pulumi.get(self, "pre_script_path")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[int]:
        """
        Only the Linux system is valid, and the IO freeze timeout period. The default is 30 seconds.
        """
        return pulumi.get(self, "timeout_in_seconds")


@pulumi.output_type
class GetBackupJobsFilterResult(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 operator: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        :param str key: The key of the field to filter. Valid values: `PlanId`, `VaultId`, `InstanceId`, `Bucket`, `FileSystemId`, `CompleteTime`.
        :param str operator: The operator of the field to filter. Valid values: `EQUAL`, `NOT_EQUAL`, `GREATER_THAN`, `GREATER_THAN_OR_EQUAL`, `LESS_THAN`, `LESS_THAN_OR_EQUAL`, `BETWEEN`, `IN`.
        :param Sequence[str] values: Set of values that are accepted for the given field.
               
               > **NOTE:** Numeric types such as `CompleteTime` do not support `IN` operations for the time being.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The key of the field to filter. Valid values: `PlanId`, `VaultId`, `InstanceId`, `Bucket`, `FileSystemId`, `CompleteTime`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        """
        The operator of the field to filter. Valid values: `EQUAL`, `NOT_EQUAL`, `GREATER_THAN`, `GREATER_THAN_OR_EQUAL`, `LESS_THAN`, `LESS_THAN_OR_EQUAL`, `BETWEEN`, `IN`.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        Set of values that are accepted for the given field.

        > **NOTE:** Numeric types such as `CompleteTime` do not support `IN` operations for the time being.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetBackupJobsJobResult(dict):
    def __init__(__self__, *,
                 actual_bytes: str,
                 actual_items: str,
                 back_job_name: str,
                 backup_job_id: str,
                 backup_type: str,
                 bucket: str,
                 bytes_done: str,
                 bytes_total: str,
                 complete_time: str,
                 create_time: str,
                 cross_account_role_name: str,
                 cross_account_type: str,
                 cross_account_user_id: int,
                 error_message: str,
                 exclude: str,
                 file_system_id: str,
                 id: str,
                 include: str,
                 instance_id: str,
                 items_done: str,
                 items_total: str,
                 nas_create_time: str,
                 ots_details: Sequence['outputs.GetBackupJobsJobOtsDetailResult'],
                 paths: Sequence[str],
                 plan_id: str,
                 prefix: str,
                 progress: str,
                 source_type: str,
                 start_time: str,
                 status: str,
                 updated_time: str,
                 vault_id: str):
        """
        :param str actual_bytes: The actual data volume of the backup task (After deduplication) . Unit byte.
        :param str actual_items: The actual number of items in the backup task. (Currently only file backup is available).
        :param str back_job_name: The name of backup job.
        :param str backup_job_id: The ID of the backup job.
        :param str backup_type: Backup type. Valid values: `COMPLETE`(full backup).
        :param str bucket: The name of target OSS bucket.
        :param str bytes_done: The amount of backup data (Incremental). Unit byte.
        :param str bytes_total: The total amount of data sources. Unit byte.
        :param str complete_time: The completion time of backup job. UNIX time seconds.
        :param str create_time: The creation time of backup job. UNIX time seconds.
        :param str cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account. It is valid only when `source_type` is `ECS_FILE`, `NAS`, `OSS` or `OTS`.
        :param str cross_account_type: The type of the cross account backup. It is valid only when `source_type` is `ECS_FILE`, `NAS`, `OSS` or `OTS`.
        :param int cross_account_user_id: The original account ID of the cross account backup managed by the current account. It is valid only when `source_type` is `ECS_FILE`, `NAS`, `OSS` or `OTS`.
        :param str error_message: Error message.
        :param str exclude: Exclude path. String of Json list. Up to 255 characters. e.g. `"[\\"/home/work\\"]"`
        :param str file_system_id: The ID of destination file system.
        :param str id: The ID of the backup job.
        :param str include: Include path. String of Json list. Up to 255 characters. e.g. `"[\\"/var\\"]"`
        :param str instance_id: The ID of target ECS instance.
        :param str items_done: The number of items restore job recovered.
        :param str items_total: The total number of items restore job recovered.
        :param str nas_create_time: File system creation time. UNIX time in seconds.
        :param Sequence[str] paths: List of backup path. e.g. `["/home", "/var"]`.
        :param str plan_id: The ID of a backup plan.
        :param str prefix: The prefix of Oss bucket files.
        :param str progress: Backup progress. The value is 100%*100.
        :param str source_type: The type of data source. Valid Values: `ECS_FILE`, `OSS`, `NAS`, `UDM_DISK`.
        :param str start_time: The scheduled backup start time. UNIX time seconds.
        :param str status: The status of restore job. Valid values: `COMPLETE` , `PARTIAL_COMPLETE`, `FAILED`.
        :param str updated_time: The update time of backup job. UNIX time seconds.
        :param str vault_id: The ID of backup vault.
        """
        pulumi.set(__self__, "actual_bytes", actual_bytes)
        pulumi.set(__self__, "actual_items", actual_items)
        pulumi.set(__self__, "back_job_name", back_job_name)
        pulumi.set(__self__, "backup_job_id", backup_job_id)
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "bytes_done", bytes_done)
        pulumi.set(__self__, "bytes_total", bytes_total)
        pulumi.set(__self__, "complete_time", complete_time)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "cross_account_role_name", cross_account_role_name)
        pulumi.set(__self__, "cross_account_type", cross_account_type)
        pulumi.set(__self__, "cross_account_user_id", cross_account_user_id)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "exclude", exclude)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "include", include)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "items_done", items_done)
        pulumi.set(__self__, "items_total", items_total)
        pulumi.set(__self__, "nas_create_time", nas_create_time)
        pulumi.set(__self__, "ots_details", ots_details)
        pulumi.set(__self__, "paths", paths)
        pulumi.set(__self__, "plan_id", plan_id)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "progress", progress)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_time", updated_time)
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="actualBytes")
    def actual_bytes(self) -> str:
        """
        The actual data volume of the backup task (After deduplication) . Unit byte.
        """
        return pulumi.get(self, "actual_bytes")

    @property
    @pulumi.getter(name="actualItems")
    def actual_items(self) -> str:
        """
        The actual number of items in the backup task. (Currently only file backup is available).
        """
        return pulumi.get(self, "actual_items")

    @property
    @pulumi.getter(name="backJobName")
    def back_job_name(self) -> str:
        """
        The name of backup job.
        """
        return pulumi.get(self, "back_job_name")

    @property
    @pulumi.getter(name="backupJobId")
    def backup_job_id(self) -> str:
        """
        The ID of the backup job.
        """
        return pulumi.get(self, "backup_job_id")

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> str:
        """
        Backup type. Valid values: `COMPLETE`(full backup).
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of target OSS bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="bytesDone")
    def bytes_done(self) -> str:
        """
        The amount of backup data (Incremental). Unit byte.
        """
        return pulumi.get(self, "bytes_done")

    @property
    @pulumi.getter(name="bytesTotal")
    def bytes_total(self) -> str:
        """
        The total amount of data sources. Unit byte.
        """
        return pulumi.get(self, "bytes_total")

    @property
    @pulumi.getter(name="completeTime")
    def complete_time(self) -> str:
        """
        The completion time of backup job. UNIX time seconds.
        """
        return pulumi.get(self, "complete_time")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of backup job. UNIX time seconds.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> str:
        """
        The role name created in the original account RAM backup by the cross account managed by the current account. It is valid only when `source_type` is `ECS_FILE`, `NAS`, `OSS` or `OTS`.
        """
        return pulumi.get(self, "cross_account_role_name")

    @property
    @pulumi.getter(name="crossAccountType")
    def cross_account_type(self) -> str:
        """
        The type of the cross account backup. It is valid only when `source_type` is `ECS_FILE`, `NAS`, `OSS` or `OTS`.
        """
        return pulumi.get(self, "cross_account_type")

    @property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> int:
        """
        The original account ID of the cross account backup managed by the current account. It is valid only when `source_type` is `ECS_FILE`, `NAS`, `OSS` or `OTS`.
        """
        return pulumi.get(self, "cross_account_user_id")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        Error message.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter
    def exclude(self) -> str:
        """
        Exclude path. String of Json list. Up to 255 characters. e.g. `"[\\"/home/work\\"]"`
        """
        return pulumi.get(self, "exclude")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> str:
        """
        The ID of destination file system.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the backup job.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def include(self) -> str:
        """
        Include path. String of Json list. Up to 255 characters. e.g. `"[\\"/var\\"]"`
        """
        return pulumi.get(self, "include")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of target ECS instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="itemsDone")
    def items_done(self) -> str:
        """
        The number of items restore job recovered.
        """
        return pulumi.get(self, "items_done")

    @property
    @pulumi.getter(name="itemsTotal")
    def items_total(self) -> str:
        """
        The total number of items restore job recovered.
        """
        return pulumi.get(self, "items_total")

    @property
    @pulumi.getter(name="nasCreateTime")
    def nas_create_time(self) -> str:
        """
        File system creation time. UNIX time in seconds.
        """
        return pulumi.get(self, "nas_create_time")

    @property
    @pulumi.getter(name="otsDetails")
    def ots_details(self) -> Sequence['outputs.GetBackupJobsJobOtsDetailResult']:
        return pulumi.get(self, "ots_details")

    @property
    @pulumi.getter
    def paths(self) -> Sequence[str]:
        """
        List of backup path. e.g. `["/home", "/var"]`.
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> str:
        """
        The ID of a backup plan.
        """
        return pulumi.get(self, "plan_id")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        The prefix of Oss bucket files.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def progress(self) -> str:
        """
        Backup progress. The value is 100%*100.
        """
        return pulumi.get(self, "progress")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The type of data source. Valid Values: `ECS_FILE`, `OSS`, `NAS`, `UDM_DISK`.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The scheduled backup start time. UNIX time seconds.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of restore job. Valid values: `COMPLETE` , `PARTIAL_COMPLETE`, `FAILED`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> str:
        """
        The update time of backup job. UNIX time seconds.
        """
        return pulumi.get(self, "updated_time")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The ID of backup vault.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetBackupJobsJobOtsDetailResult(dict):
    def __init__(__self__, *,
                 table_names: Sequence[str]):
        pulumi.set(__self__, "table_names", table_names)

    @property
    @pulumi.getter(name="tableNames")
    def table_names(self) -> Sequence[str]:
        return pulumi.get(self, "table_names")


@pulumi.output_type
class GetEcsBackupClientsClientResult(dict):
    def __init__(__self__, *,
                 arch_type: str,
                 backup_status: str,
                 client_type: str,
                 client_version: str,
                 create_time: str,
                 data_network_type: str,
                 data_proxy_setting: str,
                 ecs_backup_client_id: str,
                 hostname: str,
                 id: str,
                 instance_id: str,
                 instance_name: str,
                 last_heart_beat_time: str,
                 max_client_version: str,
                 max_cpu_core: str,
                 max_worker: str,
                 os_type: str,
                 private_ipv4: str,
                 proxy_host: str,
                 proxy_password: str,
                 proxy_port: str,
                 proxy_user: str,
                 status: str,
                 updated_time: str,
                 use_https: bool,
                 zone_id: str):
        """
        :param str arch_type: The system architecture of client, only the ECS File Backup Client is available. Valid values: `AMD64` , `386`.
        :param str backup_status: Client protected status. Valid values: `UNPROTECTED`, `PROTECTED`.
        :param str client_type: The type of client. Valid values: `ECS_CLIENT` (ECS File Backup Client).
        :param str client_version: The version of client.
        :param str create_time: The creation time of client. Unix time in seconds.
        :param str data_network_type: The data plane access point type. Valid Values: `PUBLIC`, `VPC`, `CLASSIC`.
        :param str data_proxy_setting: The data plane proxy settings. Valid Values: `DISABLE`, `USE_CONTROL_PROXY`, `CUSTOM`.
        :param str ecs_backup_client_id: The first ID of the resource.
        :param str hostname: The hostname of ECS instance.
        :param str id: The ID of the Ecs Backup Client.
        :param str instance_id: The ID of ECS instance. When the client type is ECS file backup client, it indicates the ID of ECS instance. When the client type is a local file backup client, it is a hardware fingerprint generated based on system information.
        :param str instance_name: The name of ECS instance.
        :param str last_heart_beat_time: The last heartbeat time of client. Unix Time Seconds.
        :param str max_client_version: The latest version of client.
        :param str max_cpu_core: The number of CPU cores used by a single backup task, 0 means no restrictions.
        :param str max_worker: The number of concurrent jobs for a single backup task, 0 means no restrictions.
        :param str os_type: The operating system type of client, only the ECS File Backup Client is available. Valid values: `windows`, `linux`.
        :param str private_ipv4: Intranet IP address of the instance, only available for ECS file backup client.
        :param str proxy_host: Custom data plane proxy server host address.
        :param str proxy_password: The password of custom data plane proxy server.
        :param str proxy_port: Custom data plane proxy server host port.
        :param str proxy_user: The username of custom data plane proxy server.
        :param str status: The status of the resource.
        :param str updated_time: The update time of client. Unix Time Seconds.
        :param bool use_https: Indicates whether to use the HTTPS protocol. Valid values: `true`, `false`.
        :param str zone_id: The ID of Zone.
        """
        pulumi.set(__self__, "arch_type", arch_type)
        pulumi.set(__self__, "backup_status", backup_status)
        pulumi.set(__self__, "client_type", client_type)
        pulumi.set(__self__, "client_version", client_version)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "data_network_type", data_network_type)
        pulumi.set(__self__, "data_proxy_setting", data_proxy_setting)
        pulumi.set(__self__, "ecs_backup_client_id", ecs_backup_client_id)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "last_heart_beat_time", last_heart_beat_time)
        pulumi.set(__self__, "max_client_version", max_client_version)
        pulumi.set(__self__, "max_cpu_core", max_cpu_core)
        pulumi.set(__self__, "max_worker", max_worker)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "private_ipv4", private_ipv4)
        pulumi.set(__self__, "proxy_host", proxy_host)
        pulumi.set(__self__, "proxy_password", proxy_password)
        pulumi.set(__self__, "proxy_port", proxy_port)
        pulumi.set(__self__, "proxy_user", proxy_user)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_time", updated_time)
        pulumi.set(__self__, "use_https", use_https)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> str:
        """
        The system architecture of client, only the ECS File Backup Client is available. Valid values: `AMD64` , `386`.
        """
        return pulumi.get(self, "arch_type")

    @property
    @pulumi.getter(name="backupStatus")
    def backup_status(self) -> str:
        """
        Client protected status. Valid values: `UNPROTECTED`, `PROTECTED`.
        """
        return pulumi.get(self, "backup_status")

    @property
    @pulumi.getter(name="clientType")
    def client_type(self) -> str:
        """
        The type of client. Valid values: `ECS_CLIENT` (ECS File Backup Client).
        """
        return pulumi.get(self, "client_type")

    @property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> str:
        """
        The version of client.
        """
        return pulumi.get(self, "client_version")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of client. Unix time in seconds.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataNetworkType")
    def data_network_type(self) -> str:
        """
        The data plane access point type. Valid Values: `PUBLIC`, `VPC`, `CLASSIC`.
        """
        return pulumi.get(self, "data_network_type")

    @property
    @pulumi.getter(name="dataProxySetting")
    def data_proxy_setting(self) -> str:
        """
        The data plane proxy settings. Valid Values: `DISABLE`, `USE_CONTROL_PROXY`, `CUSTOM`.
        """
        return pulumi.get(self, "data_proxy_setting")

    @property
    @pulumi.getter(name="ecsBackupClientId")
    def ecs_backup_client_id(self) -> str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "ecs_backup_client_id")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        The hostname of ECS instance.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Ecs Backup Client.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of ECS instance. When the client type is ECS file backup client, it indicates the ID of ECS instance. When the client type is a local file backup client, it is a hardware fingerprint generated based on system information.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The name of ECS instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="lastHeartBeatTime")
    def last_heart_beat_time(self) -> str:
        """
        The last heartbeat time of client. Unix Time Seconds.
        """
        return pulumi.get(self, "last_heart_beat_time")

    @property
    @pulumi.getter(name="maxClientVersion")
    def max_client_version(self) -> str:
        """
        The latest version of client.
        """
        return pulumi.get(self, "max_client_version")

    @property
    @pulumi.getter(name="maxCpuCore")
    def max_cpu_core(self) -> str:
        """
        The number of CPU cores used by a single backup task, 0 means no restrictions.
        """
        return pulumi.get(self, "max_cpu_core")

    @property
    @pulumi.getter(name="maxWorker")
    def max_worker(self) -> str:
        """
        The number of concurrent jobs for a single backup task, 0 means no restrictions.
        """
        return pulumi.get(self, "max_worker")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The operating system type of client, only the ECS File Backup Client is available. Valid values: `windows`, `linux`.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="privateIpv4")
    def private_ipv4(self) -> str:
        """
        Intranet IP address of the instance, only available for ECS file backup client.
        """
        return pulumi.get(self, "private_ipv4")

    @property
    @pulumi.getter(name="proxyHost")
    def proxy_host(self) -> str:
        """
        Custom data plane proxy server host address.
        """
        return pulumi.get(self, "proxy_host")

    @property
    @pulumi.getter(name="proxyPassword")
    def proxy_password(self) -> str:
        """
        The password of custom data plane proxy server.
        """
        return pulumi.get(self, "proxy_password")

    @property
    @pulumi.getter(name="proxyPort")
    def proxy_port(self) -> str:
        """
        Custom data plane proxy server host port.
        """
        return pulumi.get(self, "proxy_port")

    @property
    @pulumi.getter(name="proxyUser")
    def proxy_user(self) -> str:
        """
        The username of custom data plane proxy server.
        """
        return pulumi.get(self, "proxy_user")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> str:
        """
        The update time of client. Unix Time Seconds.
        """
        return pulumi.get(self, "updated_time")

    @property
    @pulumi.getter(name="useHttps")
    def use_https(self) -> bool:
        """
        Indicates whether to use the HTTPS protocol. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "use_https")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The ID of Zone.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetEcsBackupPlansPlanResult(dict):
    def __init__(__self__, *,
                 backup_type: str,
                 create_time: str,
                 created_time: str,
                 detail: str,
                 disabled: bool,
                 ecs_backup_plan_id: str,
                 ecs_backup_plan_name: str,
                 exclude: str,
                 id: str,
                 include: str,
                 instance_id: str,
                 options: str,
                 paths: Sequence[str],
                 retention: str,
                 schedule: str,
                 source_type: str,
                 speed_limit: str,
                 updated_time: str,
                 vault_id: str):
        """
        :param str backup_type: Backup type. Valid values: `COMPLETE`.
        :param str created_time: The creation time of the backup plan. UNIX time in seconds.
        :param bool disabled: Whether to be suspended. Valid values: `true`, `false`.
        :param str ecs_backup_plan_id: The ID of ecs backup plan.
        :param str ecs_backup_plan_name: The name of the backup plan.
        :param str exclude: Exclude path. String of Json list. Up to 255 characters. e.g. `"[\\"/home/work\\"]"`
        :param str id: The ID of ecs backup plan.
        :param str include: Include path. String of Json list. Up to 255 characters. e.g. `"[\\"/var\\"]"`
        :param str instance_id: The ID of ECS instance.
        :param str options: Windows operating system with application consistency using VSS. eg: {`UseVSS`:false}.
        :param Sequence[str] paths: Backup path. e.g. `["/home", "/var"]`
        :param str retention: Backup retention days, the minimum is 1.
        :param str schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        :param str source_type: The type of backup source.
        :param str speed_limit: Flow control. The format is: {start}|{end}|{bandwidth}. Use `|` to separate multiple flow control configurations, multiple flow control configurations not allowed to have overlapping times.
        :param str updated_time: The update time of the backup plan. UNIX time in seconds.
        :param str vault_id: The ID of Backup vault.
        """
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "detail", detail)
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "ecs_backup_plan_id", ecs_backup_plan_id)
        pulumi.set(__self__, "ecs_backup_plan_name", ecs_backup_plan_name)
        pulumi.set(__self__, "exclude", exclude)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "include", include)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "paths", paths)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "speed_limit", speed_limit)
        pulumi.set(__self__, "updated_time", updated_time)
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> str:
        """
        Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        The creation time of the backup plan. UNIX time in seconds.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def detail(self) -> str:
        return pulumi.get(self, "detail")

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Whether to be suspended. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="ecsBackupPlanId")
    def ecs_backup_plan_id(self) -> str:
        """
        The ID of ecs backup plan.
        """
        return pulumi.get(self, "ecs_backup_plan_id")

    @property
    @pulumi.getter(name="ecsBackupPlanName")
    def ecs_backup_plan_name(self) -> str:
        """
        The name of the backup plan.
        """
        return pulumi.get(self, "ecs_backup_plan_name")

    @property
    @pulumi.getter
    def exclude(self) -> str:
        """
        Exclude path. String of Json list. Up to 255 characters. e.g. `"[\\"/home/work\\"]"`
        """
        return pulumi.get(self, "exclude")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of ecs backup plan.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def include(self) -> str:
        """
        Include path. String of Json list. Up to 255 characters. e.g. `"[\\"/var\\"]"`
        """
        return pulumi.get(self, "include")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of ECS instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def options(self) -> str:
        """
        Windows operating system with application consistency using VSS. eg: {`UseVSS`:false}.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def paths(self) -> Sequence[str]:
        """
        Backup path. e.g. `["/home", "/var"]`
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter
    def retention(self) -> str:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @property
    @pulumi.getter
    def schedule(self) -> str:
        """
        Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The type of backup source.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter(name="speedLimit")
    def speed_limit(self) -> str:
        """
        Flow control. The format is: {start}|{end}|{bandwidth}. Use `|` to separate multiple flow control configurations, multiple flow control configurations not allowed to have overlapping times.
        """
        return pulumi.get(self, "speed_limit")

    @property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> str:
        """
        The update time of the backup plan. UNIX time in seconds.
        """
        return pulumi.get(self, "updated_time")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The ID of Backup vault.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetHanaBackupClientsHanaBackupClientResult(dict):
    def __init__(__self__, *,
                 alert_setting: str,
                 client_id: str,
                 client_name: str,
                 client_type: str,
                 client_version: str,
                 cluster_id: str,
                 id: str,
                 instance_id: str,
                 instance_name: str,
                 max_version: str,
                 network_type: str,
                 status: str,
                 status_message: str,
                 use_https: bool,
                 vault_id: str):
        """
        :param str alert_setting: The alert settings.
        :param str client_id: The ID of the backup client.
        :param str client_name: The name of the backup client.
        :param str client_type: The type of the backup client.
        :param str client_version: The version number of the backup client.
        :param str cluster_id: The ID of the SAP HANA instance.
        :param str id: The id of the Hana Backup Client. It formats as `<vault_id>:<client_id>`.
        :param str instance_id: The ID of the instance.
        :param str instance_name: The name of the ECS instance.
        :param str max_version: The maximum version number of the backup client.
        :param str network_type: The network type.
        :param str status: The status of the Hana Backup Client. Valid Values: `REGISTERED`, `ACTIVATED`, `DEACTIVATED`, `INSTALLING`, `INSTALL_FAILED`, `NOT_INSTALLED`, `UPGRADING`, `UPGRADE_FAILED`, `UNINSTALLING`, `UNINSTALL_FAILED`, `STOPPED`, `UNKNOWN`.
        :param str status_message: The status information.
        :param bool use_https: Indicates whether data is transmitted over HTTPS.
        :param str vault_id: The ID of the backup vault.
        """
        pulumi.set(__self__, "alert_setting", alert_setting)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_name", client_name)
        pulumi.set(__self__, "client_type", client_type)
        pulumi.set(__self__, "client_version", client_version)
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "max_version", max_version)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_message", status_message)
        pulumi.set(__self__, "use_https", use_https)
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="alertSetting")
    def alert_setting(self) -> str:
        """
        The alert settings.
        """
        return pulumi.get(self, "alert_setting")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The ID of the backup client.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientName")
    def client_name(self) -> str:
        """
        The name of the backup client.
        """
        return pulumi.get(self, "client_name")

    @property
    @pulumi.getter(name="clientType")
    def client_type(self) -> str:
        """
        The type of the backup client.
        """
        return pulumi.get(self, "client_type")

    @property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> str:
        """
        The version number of the backup client.
        """
        return pulumi.get(self, "client_version")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        The ID of the SAP HANA instance.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the Hana Backup Client. It formats as `<vault_id>:<client_id>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The name of the ECS instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="maxVersion")
    def max_version(self) -> str:
        """
        The maximum version number of the backup client.
        """
        return pulumi.get(self, "max_version")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        The network type.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the Hana Backup Client. Valid Values: `REGISTERED`, `ACTIVATED`, `DEACTIVATED`, `INSTALLING`, `INSTALL_FAILED`, `NOT_INSTALLED`, `UPGRADING`, `UPGRADE_FAILED`, `UNINSTALLING`, `UNINSTALL_FAILED`, `STOPPED`, `UNKNOWN`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> str:
        """
        The status information.
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter(name="useHttps")
    def use_https(self) -> bool:
        """
        Indicates whether data is transmitted over HTTPS.
        """
        return pulumi.get(self, "use_https")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The ID of the backup vault.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetHanaBackupPlansPlanResult(dict):
    def __init__(__self__, *,
                 backup_prefix: str,
                 backup_type: str,
                 cluster_id: str,
                 database_name: str,
                 id: str,
                 page_total: str,
                 plan_id: str,
                 plan_name: str,
                 schedule: str,
                 status: str,
                 vault_id: str):
        """
        :param str backup_prefix: The backup prefix.
        :param str backup_type: The backup type.
        :param str cluster_id: The ID of the SAP HANA instance.
        :param str database_name: The name of the database.
        :param str id: The ID of the resource.
        :param str plan_id: The ID of the backup plan.
        :param str plan_name: The name of the backup plan.
        :param str schedule: The backup policy.
        :param str status: The status of the resource.
        :param str vault_id: The ID of the backup vault.
        """
        pulumi.set(__self__, "backup_prefix", backup_prefix)
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "page_total", page_total)
        pulumi.set(__self__, "plan_id", plan_id)
        pulumi.set(__self__, "plan_name", plan_name)
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="backupPrefix")
    def backup_prefix(self) -> str:
        """
        The backup prefix.
        """
        return pulumi.get(self, "backup_prefix")

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> str:
        """
        The backup type.
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        The ID of the SAP HANA instance.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        The name of the database.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="pageTotal")
    def page_total(self) -> str:
        return pulumi.get(self, "page_total")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> str:
        """
        The ID of the backup plan.
        """
        return pulumi.get(self, "plan_id")

    @property
    @pulumi.getter(name="planName")
    def plan_name(self) -> str:
        """
        The name of the backup plan.
        """
        return pulumi.get(self, "plan_name")

    @property
    @pulumi.getter
    def schedule(self) -> str:
        """
        The backup policy.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The ID of the backup vault.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetHanaInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 alert_setting: str,
                 hana_instance_id: str,
                 hana_name: str,
                 host: str,
                 id: str,
                 instance_number: int,
                 resource_group_id: str,
                 status: str,
                 status_message: str,
                 use_ssl: bool,
                 user_name: str,
                 validate_certificate: bool,
                 vault_id: str):
        """
        :param str alert_setting: The alert settings. Valid value: `INHERITED`, which indicates that the backup client sends alert notifications in the same way as the backup vault.
        :param str hana_instance_id: The ID of the SAP HANA instance.
        :param str hana_name: The name of the SAP HANA instance.
        :param str host: The private or internal IP address of the host where the primary node of the SAP HANA instance resides.
        :param str id: The ID of the Hana Instance. The value formats as `<vault_id>:<hana_instance_id>`.
        :param int instance_number: The instance number of the SAP HANA system.
        :param str resource_group_id: The ID of the resource group.
        :param str status: The status of the SAP HANA instance.
        :param str status_message: The status information.
        :param bool use_ssl: Indicates whether the SAP HANA instance is connected over Secure Sockets Layer (SSL).
        :param str user_name: The username of the SYSTEMDB database.
        :param bool validate_certificate: Indicates whether the SSL certificate of the SAP HANA instance is verified.
        :param str vault_id: The ID of the backup vault.
        """
        pulumi.set(__self__, "alert_setting", alert_setting)
        pulumi.set(__self__, "hana_instance_id", hana_instance_id)
        pulumi.set(__self__, "hana_name", hana_name)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_number", instance_number)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_message", status_message)
        pulumi.set(__self__, "use_ssl", use_ssl)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "validate_certificate", validate_certificate)
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="alertSetting")
    def alert_setting(self) -> str:
        """
        The alert settings. Valid value: `INHERITED`, which indicates that the backup client sends alert notifications in the same way as the backup vault.
        """
        return pulumi.get(self, "alert_setting")

    @property
    @pulumi.getter(name="hanaInstanceId")
    def hana_instance_id(self) -> str:
        """
        The ID of the SAP HANA instance.
        """
        return pulumi.get(self, "hana_instance_id")

    @property
    @pulumi.getter(name="hanaName")
    def hana_name(self) -> str:
        """
        The name of the SAP HANA instance.
        """
        return pulumi.get(self, "hana_name")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The private or internal IP address of the host where the primary node of the SAP HANA instance resides.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Hana Instance. The value formats as `<vault_id>:<hana_instance_id>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceNumber")
    def instance_number(self) -> int:
        """
        The instance number of the SAP HANA system.
        """
        return pulumi.get(self, "instance_number")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the SAP HANA instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> str:
        """
        The status information.
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> bool:
        """
        Indicates whether the SAP HANA instance is connected over Secure Sockets Layer (SSL).
        """
        return pulumi.get(self, "use_ssl")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        The username of the SYSTEMDB database.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="validateCertificate")
    def validate_certificate(self) -> bool:
        """
        Indicates whether the SSL certificate of the SAP HANA instance is verified.
        """
        return pulumi.get(self, "validate_certificate")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The ID of the backup vault.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetNasBackupPlansPlanResult(dict):
    def __init__(__self__, *,
                 backup_type: str,
                 create_time: str,
                 created_time: str,
                 disabled: bool,
                 file_system_id: str,
                 id: str,
                 nas_backup_plan_id: str,
                 nas_backup_plan_name: str,
                 options: str,
                 paths: Sequence[str],
                 retention: str,
                 schedule: str,
                 updated_time: str,
                 vault_id: str):
        """
        :param str backup_type: Backup type. Valid values: `COMPLETE`.
        :param str create_time: File System Creation Time. **Note** The time format of the API adopts the ISO 8601 format, such as `2021-07-09T15:45:30CST`.
        :param str created_time: The creation time of the backup plan. UNIX time in seconds.
        :param bool disabled: Whether to be suspended. Valid values: `true`, `false`.
        :param str file_system_id: The File System ID of Nas.
        :param str id: The ID of Nas backup plan.
        :param str nas_backup_plan_id: The ID of Nas backup plan.
        :param str nas_backup_plan_name: The name of the resource.
        :param str options: Options field of Nas backup plan.
        :param Sequence[str] paths: List of backup path. Up to 65536 Characters. e.g.`["/home", "/var"]`
        :param str retention: Backup retention days, the minimum is 1.
        :param str schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        :param str updated_time: The update time of the backup plan. UNIX time in seconds.
        :param str vault_id: The ID of backup vault.
        """
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "nas_backup_plan_id", nas_backup_plan_id)
        pulumi.set(__self__, "nas_backup_plan_name", nas_backup_plan_name)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "paths", paths)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "updated_time", updated_time)
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> str:
        """
        Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        File System Creation Time. **Note** The time format of the API adopts the ISO 8601 format, such as `2021-07-09T15:45:30CST`.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        The creation time of the backup plan. UNIX time in seconds.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Whether to be suspended. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> str:
        """
        The File System ID of Nas.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of Nas backup plan.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nasBackupPlanId")
    def nas_backup_plan_id(self) -> str:
        """
        The ID of Nas backup plan.
        """
        return pulumi.get(self, "nas_backup_plan_id")

    @property
    @pulumi.getter(name="nasBackupPlanName")
    def nas_backup_plan_name(self) -> str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "nas_backup_plan_name")

    @property
    @pulumi.getter
    def options(self) -> str:
        """
        Options field of Nas backup plan.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def paths(self) -> Sequence[str]:
        """
        List of backup path. Up to 65536 Characters. e.g.`["/home", "/var"]`
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter
    def retention(self) -> str:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @property
    @pulumi.getter
    def schedule(self) -> str:
        """
        Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> str:
        """
        The update time of the backup plan. UNIX time in seconds.
        """
        return pulumi.get(self, "updated_time")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The ID of backup vault.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetOssBackupPlansPlanResult(dict):
    def __init__(__self__, *,
                 backup_type: str,
                 bucket: str,
                 created_time: str,
                 disabled: bool,
                 id: str,
                 oss_backup_plan_id: str,
                 oss_backup_plan_name: str,
                 prefix: str,
                 retention: str,
                 schedule: str,
                 updated_time: str,
                 vault_id: str):
        """
        :param str backup_type: Backup type. Valid values: `COMPLETE`.
        :param str bucket: The name of OSS bucket.
        :param str created_time: The creation time of the backup plan. UNIX time in seconds.
        :param bool disabled: Whether to be suspended. Valid values: `true`, `false`.
        :param str id: The ID of Oss backup plan.
        :param str oss_backup_plan_id: The ID of Oss backup plan.
        :param str oss_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param str prefix: Backup prefix.
        :param str retention: Backup retention days, the minimum is 1.
        :param str schedule: Backup strategy. Optional format: I|{startTime}|{interval}. It means to execute a backup task every {interval} starting from {startTime}. The backup task for the elapsed time will not be compensated. If the last backup task is not completed yet, the next backup task will not be triggered.
        :param str updated_time: The update time of the backup plan. UNIX time in seconds.
        :param str vault_id: The ID of backup vault.
        """
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "oss_backup_plan_id", oss_backup_plan_id)
        pulumi.set(__self__, "oss_backup_plan_name", oss_backup_plan_name)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "updated_time", updated_time)
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> str:
        """
        Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of OSS bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        The creation time of the backup plan. UNIX time in seconds.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Whether to be suspended. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of Oss backup plan.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ossBackupPlanId")
    def oss_backup_plan_id(self) -> str:
        """
        The ID of Oss backup plan.
        """
        return pulumi.get(self, "oss_backup_plan_id")

    @property
    @pulumi.getter(name="ossBackupPlanName")
    def oss_backup_plan_name(self) -> str:
        """
        The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        """
        return pulumi.get(self, "oss_backup_plan_name")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        Backup prefix.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def retention(self) -> str:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @property
    @pulumi.getter
    def schedule(self) -> str:
        """
        Backup strategy. Optional format: I|{startTime}|{interval}. It means to execute a backup task every {interval} starting from {startTime}. The backup task for the elapsed time will not be compensated. If the last backup task is not completed yet, the next backup task will not be triggered.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> str:
        """
        The update time of the backup plan. UNIX time in seconds.
        """
        return pulumi.get(self, "updated_time")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The ID of backup vault.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetOtsBackupPlansPlanResult(dict):
    def __init__(__self__, *,
                 backup_type: str,
                 created_time: str,
                 disabled: bool,
                 id: str,
                 ots_backup_plan_id: str,
                 ots_backup_plan_name: str,
                 ots_details: Sequence['outputs.GetOtsBackupPlansPlanOtsDetailResult'],
                 retention: str,
                 schedule: str,
                 source_type: str,
                 updated_time: str,
                 vault_id: str):
        """
        :param str backup_type: The Backup type. Valid values: `COMPLETE`.
        :param str created_time: The creation time of the backup plan. UNIX time in seconds.
        :param bool disabled: Whether to be suspended. Valid values: `true`, `false`.
        :param str id: The ID of ots backup plan.
        :param str ots_backup_plan_id: The ID of ots backup plan.
        :param str ots_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param str retention: The Backup retention days, the minimum is 1.
        :param str schedule: The Backup strategy. Optional format: I|{startTime}|{interval}. It means to execute a backup task every {interval} starting from {startTime}. The backup task for the elapsed time will not be compensated. If the last backup task is not completed yet, the next backup task will not be triggered.
        :param str source_type: The type of the data source.
        :param str updated_time: The update time of the backup plan. UNIX time in seconds.
               *ots_detail - The details about the Tablestore instance.
        :param str vault_id: The ID of backup vault.
        """
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ots_backup_plan_id", ots_backup_plan_id)
        pulumi.set(__self__, "ots_backup_plan_name", ots_backup_plan_name)
        pulumi.set(__self__, "ots_details", ots_details)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "updated_time", updated_time)
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> str:
        """
        The Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        The creation time of the backup plan. UNIX time in seconds.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Whether to be suspended. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of ots backup plan.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="otsBackupPlanId")
    def ots_backup_plan_id(self) -> str:
        """
        The ID of ots backup plan.
        """
        return pulumi.get(self, "ots_backup_plan_id")

    @property
    @pulumi.getter(name="otsBackupPlanName")
    def ots_backup_plan_name(self) -> str:
        """
        The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        """
        return pulumi.get(self, "ots_backup_plan_name")

    @property
    @pulumi.getter(name="otsDetails")
    def ots_details(self) -> Sequence['outputs.GetOtsBackupPlansPlanOtsDetailResult']:
        return pulumi.get(self, "ots_details")

    @property
    @pulumi.getter
    def retention(self) -> str:
        """
        The Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @property
    @pulumi.getter
    def schedule(self) -> str:
        """
        The Backup strategy. Optional format: I|{startTime}|{interval}. It means to execute a backup task every {interval} starting from {startTime}. The backup task for the elapsed time will not be compensated. If the last backup task is not completed yet, the next backup task will not be triggered.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The type of the data source.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> str:
        """
        The update time of the backup plan. UNIX time in seconds.
        *ots_detail - The details about the Tablestore instance.
        """
        return pulumi.get(self, "updated_time")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The ID of backup vault.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetOtsBackupPlansPlanOtsDetailResult(dict):
    def __init__(__self__, *,
                 table_names: Sequence[str]):
        pulumi.set(__self__, "table_names", table_names)

    @property
    @pulumi.getter(name="tableNames")
    def table_names(self) -> Sequence[str]:
        return pulumi.get(self, "table_names")


@pulumi.output_type
class GetOtsSnapshotsSnapshotResult(dict):
    def __init__(__self__, *,
                 actual_bytes: str,
                 backup_type: str,
                 bytes_total: str,
                 complete_time: str,
                 create_time: str,
                 created_time: str,
                 id: str,
                 instance_name: str,
                 job_id: str,
                 parent_snapshot_hash: str,
                 range_end: str,
                 range_start: str,
                 retention: str,
                 snapshot_hash: str,
                 snapshot_id: str,
                 source_type: str,
                 start_time: str,
                 status: str,
                 table_name: str,
                 updated_time: str,
                 vault_id: str):
        """
        :param str actual_bytes: The actual amount of backup snapshots after duplicates are removed. Unit: bytes.
        :param str backup_type: The backup type. Valid value: `COMPLETE`, which indicates full backup.
        :param str bytes_total: The total amount of data. Unit: bytes.
        :param str complete_time: The time when the backup snapshot was completed. This value is a UNIX timestamp. Unit: seconds.
        :param str create_time: The time when the Table store instance was created. This value is a UNIX timestamp. Unit: seconds.
        :param str created_time: The time when the backup snapshot was created. This value is a UNIX timestamp. Unit: seconds.
        :param str id: The ID of the backup snapshot.
        :param str instance_name: The name of the Table store instance.
        :param str job_id: The ID of the backup job.
        :param str parent_snapshot_hash: The hash value of the parent backup snapshot.
        :param str range_end: The time when the backup job ended. This value is a UNIX timestamp. Unit: milliseconds.
        :param str range_start: The time when the backup job started. This value is a UNIX timestamp. Unit: milliseconds.
        :param str retention: The retention period of the backup snapshot.
        :param str snapshot_hash: The hash value of the backup snapshot.
        :param str snapshot_id: The ID of the backup snapshot.
        :param str source_type: The type of the data source. Valid values: `ECS_FILE`,`PARTIAL_COMPLETE`,`FAILED`
        :param str start_time: The start time of the backup snapshot. This value is a UNIX timestamp. Unit: seconds.
        :param str status: The status of the backup job. Valid values: `COMPLETE`,`PARTIAL_COMPLETE`,`FAILED`.
        :param str table_name: The name of the table in the Table store instance.
        :param str updated_time: The time when the backup snapshot was updated. This value is a UNIX timestamp. Unit: seconds.
        :param str vault_id: The ID of the backup vault that stores the backup snapshot.
        """
        pulumi.set(__self__, "actual_bytes", actual_bytes)
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "bytes_total", bytes_total)
        pulumi.set(__self__, "complete_time", complete_time)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "job_id", job_id)
        pulumi.set(__self__, "parent_snapshot_hash", parent_snapshot_hash)
        pulumi.set(__self__, "range_end", range_end)
        pulumi.set(__self__, "range_start", range_start)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "snapshot_hash", snapshot_hash)
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "updated_time", updated_time)
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="actualBytes")
    def actual_bytes(self) -> str:
        """
        The actual amount of backup snapshots after duplicates are removed. Unit: bytes.
        """
        return pulumi.get(self, "actual_bytes")

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> str:
        """
        The backup type. Valid value: `COMPLETE`, which indicates full backup.
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter(name="bytesTotal")
    def bytes_total(self) -> str:
        """
        The total amount of data. Unit: bytes.
        """
        return pulumi.get(self, "bytes_total")

    @property
    @pulumi.getter(name="completeTime")
    def complete_time(self) -> str:
        """
        The time when the backup snapshot was completed. This value is a UNIX timestamp. Unit: seconds.
        """
        return pulumi.get(self, "complete_time")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the Table store instance was created. This value is a UNIX timestamp. Unit: seconds.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        The time when the backup snapshot was created. This value is a UNIX timestamp. Unit: seconds.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the backup snapshot.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The name of the Table store instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> str:
        """
        The ID of the backup job.
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter(name="parentSnapshotHash")
    def parent_snapshot_hash(self) -> str:
        """
        The hash value of the parent backup snapshot.
        """
        return pulumi.get(self, "parent_snapshot_hash")

    @property
    @pulumi.getter(name="rangeEnd")
    def range_end(self) -> str:
        """
        The time when the backup job ended. This value is a UNIX timestamp. Unit: milliseconds.
        """
        return pulumi.get(self, "range_end")

    @property
    @pulumi.getter(name="rangeStart")
    def range_start(self) -> str:
        """
        The time when the backup job started. This value is a UNIX timestamp. Unit: milliseconds.
        """
        return pulumi.get(self, "range_start")

    @property
    @pulumi.getter
    def retention(self) -> str:
        """
        The retention period of the backup snapshot.
        """
        return pulumi.get(self, "retention")

    @property
    @pulumi.getter(name="snapshotHash")
    def snapshot_hash(self) -> str:
        """
        The hash value of the backup snapshot.
        """
        return pulumi.get(self, "snapshot_hash")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> str:
        """
        The ID of the backup snapshot.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The type of the data source. Valid values: `ECS_FILE`,`PARTIAL_COMPLETE`,`FAILED`
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The start time of the backup snapshot. This value is a UNIX timestamp. Unit: seconds.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the backup job. Valid values: `COMPLETE`,`PARTIAL_COMPLETE`,`FAILED`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        """
        The name of the table in the Table store instance.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> str:
        """
        The time when the backup snapshot was updated. This value is a UNIX timestamp. Unit: seconds.
        """
        return pulumi.get(self, "updated_time")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The ID of the backup vault that stores the backup snapshot.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetReplicationVaultRegionsRegionResult(dict):
    def __init__(__self__, *,
                 replication_region_id: str):
        """
        :param str replication_region_id: The ID of the replication region.
        """
        pulumi.set(__self__, "replication_region_id", replication_region_id)

    @property
    @pulumi.getter(name="replicationRegionId")
    def replication_region_id(self) -> str:
        """
        The ID of the replication region.
        """
        return pulumi.get(self, "replication_region_id")


@pulumi.output_type
class GetRestoreJobsJobResult(dict):
    def __init__(__self__, *,
                 actual_bytes: str,
                 actual_items: str,
                 bytes_done: str,
                 bytes_total: str,
                 complete_time: str,
                 create_time: str,
                 error_file: str,
                 error_message: str,
                 expire_time: str,
                 id: str,
                 items_done: str,
                 items_total: str,
                 options: str,
                 parent_id: str,
                 progress: int,
                 restore_job_id: str,
                 restore_type: str,
                 snapshot_hash: str,
                 snapshot_id: str,
                 source_type: str,
                 start_time: str,
                 status: str,
                 target_bucket: str,
                 target_client_id: str,
                 target_create_time: str,
                 target_data_source_id: str,
                 target_file_system_id: str,
                 target_instance_id: str,
                 target_path: str,
                 target_prefix: str,
                 updated_time: str,
                 vault_id: str):
        """
        :param str actual_bytes: The actual size of Snapshot.
        :param str actual_items: The actual number of files.
        :param str bytes_done: The size of restore job recovered.
        :param str bytes_total: The total size of restore job recovered.
        :param str complete_time: The completion time of restore Job.
        :param str create_time: The creation time of restore job.
        :param str error_message: The error message of recovery task execution.
        :param str expire_time: The expiration time of restore job. Unix Time in seconds.
        :param str id: The ID of the restore job.
        :param str items_done: The number of items restore job recovered.
        :param str items_total: The total number of items restore job recovered.
        :param str options: Recovery Options.
        :param int progress: The recovery progress.
        :param str restore_job_id: The ID of restore job.
        :param str restore_type: The type of recovery destination. Valid Values: `ECS_FILE`, `OSS`, `NAS`.
        :param str snapshot_hash: The hashcode of Snapshot.
        :param str snapshot_id: The ID of Snapshot.
        :param str source_type: The list of data source types. Valid values: `ECS_FILE`, `NAS`, `OSS`, `OTS_TABLE`,`UDM_ECS_ROLLBACK`.
        :param str start_time: The start time of restore job. Unix Time in Seconds.
        :param str status: The status of restore job.
        :param str target_bucket: The name of target ofo OSS bucket.
        :param str target_create_time: The creation time of destination file system.
        :param str target_file_system_id: The ID of destination file system.
        :param str target_instance_id: The ID of target ECS instance.
        :param str target_path: The target file path of ECS instance.
        :param str target_prefix: The file prefix of target OSS object.
        :param str updated_time: The update Time of restore job. Unix Time in Seconds.
        :param str vault_id: The ID of backup vault.
        """
        pulumi.set(__self__, "actual_bytes", actual_bytes)
        pulumi.set(__self__, "actual_items", actual_items)
        pulumi.set(__self__, "bytes_done", bytes_done)
        pulumi.set(__self__, "bytes_total", bytes_total)
        pulumi.set(__self__, "complete_time", complete_time)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "error_file", error_file)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "items_done", items_done)
        pulumi.set(__self__, "items_total", items_total)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "parent_id", parent_id)
        pulumi.set(__self__, "progress", progress)
        pulumi.set(__self__, "restore_job_id", restore_job_id)
        pulumi.set(__self__, "restore_type", restore_type)
        pulumi.set(__self__, "snapshot_hash", snapshot_hash)
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "target_bucket", target_bucket)
        pulumi.set(__self__, "target_client_id", target_client_id)
        pulumi.set(__self__, "target_create_time", target_create_time)
        pulumi.set(__self__, "target_data_source_id", target_data_source_id)
        pulumi.set(__self__, "target_file_system_id", target_file_system_id)
        pulumi.set(__self__, "target_instance_id", target_instance_id)
        pulumi.set(__self__, "target_path", target_path)
        pulumi.set(__self__, "target_prefix", target_prefix)
        pulumi.set(__self__, "updated_time", updated_time)
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="actualBytes")
    def actual_bytes(self) -> str:
        """
        The actual size of Snapshot.
        """
        return pulumi.get(self, "actual_bytes")

    @property
    @pulumi.getter(name="actualItems")
    def actual_items(self) -> str:
        """
        The actual number of files.
        """
        return pulumi.get(self, "actual_items")

    @property
    @pulumi.getter(name="bytesDone")
    def bytes_done(self) -> str:
        """
        The size of restore job recovered.
        """
        return pulumi.get(self, "bytes_done")

    @property
    @pulumi.getter(name="bytesTotal")
    def bytes_total(self) -> str:
        """
        The total size of restore job recovered.
        """
        return pulumi.get(self, "bytes_total")

    @property
    @pulumi.getter(name="completeTime")
    def complete_time(self) -> str:
        """
        The completion time of restore Job.
        """
        return pulumi.get(self, "complete_time")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of restore job.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="errorFile")
    def error_file(self) -> str:
        return pulumi.get(self, "error_file")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        The error message of recovery task execution.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        The expiration time of restore job. Unix Time in seconds.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the restore job.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="itemsDone")
    def items_done(self) -> str:
        """
        The number of items restore job recovered.
        """
        return pulumi.get(self, "items_done")

    @property
    @pulumi.getter(name="itemsTotal")
    def items_total(self) -> str:
        """
        The total number of items restore job recovered.
        """
        return pulumi.get(self, "items_total")

    @property
    @pulumi.getter
    def options(self) -> str:
        """
        Recovery Options.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> str:
        return pulumi.get(self, "parent_id")

    @property
    @pulumi.getter
    def progress(self) -> int:
        """
        The recovery progress.
        """
        return pulumi.get(self, "progress")

    @property
    @pulumi.getter(name="restoreJobId")
    def restore_job_id(self) -> str:
        """
        The ID of restore job.
        """
        return pulumi.get(self, "restore_job_id")

    @property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> str:
        """
        The type of recovery destination. Valid Values: `ECS_FILE`, `OSS`, `NAS`.
        """
        return pulumi.get(self, "restore_type")

    @property
    @pulumi.getter(name="snapshotHash")
    def snapshot_hash(self) -> str:
        """
        The hashcode of Snapshot.
        """
        return pulumi.get(self, "snapshot_hash")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> str:
        """
        The ID of Snapshot.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The list of data source types. Valid values: `ECS_FILE`, `NAS`, `OSS`, `OTS_TABLE`,`UDM_ECS_ROLLBACK`.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The start time of restore job. Unix Time in Seconds.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of restore job.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> str:
        """
        The name of target ofo OSS bucket.
        """
        return pulumi.get(self, "target_bucket")

    @property
    @pulumi.getter(name="targetClientId")
    def target_client_id(self) -> str:
        return pulumi.get(self, "target_client_id")

    @property
    @pulumi.getter(name="targetCreateTime")
    def target_create_time(self) -> str:
        """
        The creation time of destination file system.
        """
        return pulumi.get(self, "target_create_time")

    @property
    @pulumi.getter(name="targetDataSourceId")
    def target_data_source_id(self) -> str:
        return pulumi.get(self, "target_data_source_id")

    @property
    @pulumi.getter(name="targetFileSystemId")
    def target_file_system_id(self) -> str:
        """
        The ID of destination file system.
        """
        return pulumi.get(self, "target_file_system_id")

    @property
    @pulumi.getter(name="targetInstanceId")
    def target_instance_id(self) -> str:
        """
        The ID of target ECS instance.
        """
        return pulumi.get(self, "target_instance_id")

    @property
    @pulumi.getter(name="targetPath")
    def target_path(self) -> str:
        """
        The target file path of ECS instance.
        """
        return pulumi.get(self, "target_path")

    @property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> str:
        """
        The file prefix of target OSS object.
        """
        return pulumi.get(self, "target_prefix")

    @property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> str:
        """
        The update Time of restore job. Unix Time in Seconds.
        """
        return pulumi.get(self, "updated_time")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The ID of backup vault.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetServerBackupPlansFilterResult(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        :param str key: The key of the field to filter. Valid values: `planId`, `instanceId`, `planName`.
        :param Sequence[str] values: Set of values that are accepted for the given field.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The key of the field to filter. Valid values: `planId`, `instanceId`, `planName`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        Set of values that are accepted for the given field.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetServerBackupPlansPlanResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 details: Sequence['outputs.GetServerBackupPlansPlanDetailResult'],
                 disabled: bool,
                 ecs_server_backup_plan_id: str,
                 ecs_server_backup_plan_name: str,
                 id: str,
                 instance_id: str,
                 retention: str,
                 schedule: str):
        """
        :param str create_time: The creation time of backup plan.
        :param Sequence['GetServerBackupPlansPlanDetailArgs'] details: ECS server backup plan details.
        :param bool disabled: Whether to disable the backup task. Valid values: `true`, `false`.
        :param str ecs_server_backup_plan_id: The ID of the server backup plan.
        :param str ecs_server_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param str id: The ID of the server backup plan.
        :param str instance_id: The ID of ECS Instance.
        :param str retention: Backup retention days, the minimum is 1.
        :param str schedule: Backup strategy.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "ecs_server_backup_plan_id", ecs_server_backup_plan_id)
        pulumi.set(__self__, "ecs_server_backup_plan_name", ecs_server_backup_plan_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of backup plan.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.GetServerBackupPlansPlanDetailResult']:
        """
        ECS server backup plan details.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Whether to disable the backup task. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="ecsServerBackupPlanId")
    def ecs_server_backup_plan_id(self) -> str:
        """
        The ID of the server backup plan.
        """
        return pulumi.get(self, "ecs_server_backup_plan_id")

    @property
    @pulumi.getter(name="ecsServerBackupPlanName")
    def ecs_server_backup_plan_name(self) -> str:
        """
        The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        """
        return pulumi.get(self, "ecs_server_backup_plan_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the server backup plan.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of ECS Instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def retention(self) -> str:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @property
    @pulumi.getter
    def schedule(self) -> str:
        """
        Backup strategy.
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class GetServerBackupPlansPlanDetailResult(dict):
    def __init__(__self__, *,
                 app_consistent: bool,
                 destination_region_id: str,
                 destination_retention: int,
                 disk_id_lists: Sequence[str],
                 do_copy: bool,
                 enable_fs_freeze: bool,
                 post_script_path: str,
                 pre_script_path: str,
                 snapshot_group: bool,
                 timeout_in_seconds: int):
        """
        :param bool app_consistent: Whether to turn on application consistency. The application consistency snapshot backs up memory data and ongoing database transactions at the time of snapshot creation to ensure the consistency of application system data and database transactions. By applying consistent snapshots, there is no data damage or loss, so as to avoid log rollback during database startup and ensure that the application is in a consistent startup state. Valid values: `true`, `false`.
        :param str destination_region_id: Only vaild when DoCopy is true. The destination region ID when replicating to another region. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param int destination_retention: Only vaild when DoCopy is true. The retention days of the destination backup. When not specified, the destination backup will be saved permanently. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param Sequence[str] disk_id_lists: The list of cloud disks to be backed up in the ECS instance. When not specified, a snapshot is executed for all the disks on the ECS instance.
        :param bool do_copy: Whether replicate to another region. Valid values: `true`, `false`.
        :param bool enable_fs_freeze: Only the Linux system is valid. Whether to use the Linux FsFreeze mechanism to ensure that the file system is read-only consistent before creating a storage snapshot. The default is True. Valid values: `true`, `false`.
        :param str post_script_path: Only vaild for the linux system when AppConsistent is true. The application thaw script path (e.g. /tmp/postscript.sh). The postscript.sh script must meet the following conditions: in terms of permissions, only the root user as the owner has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        :param str pre_script_path: Only vaild for the linux system when AppConsistent is true. Apply the freeze script path (e.g. /tmp/prescript.sh). prescript.sh scripts must meet the following conditions: in terms of permissions, only root, as the owner, has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        :param bool snapshot_group: Whether to turn on file system consistency. If SnapshotGroup is true, when AppConsistent is true but the relevant conditions are not met or AppConsistent is false, the resulting snapshot will be a file system consistency snapshot. The file system consistency ensures that the file system memory and disk information are synchronized at the time of snapshot creation, and the file system write operation is frozen to make the file system in a consistent state. The file system consistency snapshot can prevent the operating system from performing disk inspection and repair operations such as CHKDSK or fsck after restart. Valid values: `true`, `false`.
        :param int timeout_in_seconds: Only the Linux system is valid, and the IO freeze timeout period. The default is 30 seconds.
        """
        pulumi.set(__self__, "app_consistent", app_consistent)
        pulumi.set(__self__, "destination_region_id", destination_region_id)
        pulumi.set(__self__, "destination_retention", destination_retention)
        pulumi.set(__self__, "disk_id_lists", disk_id_lists)
        pulumi.set(__self__, "do_copy", do_copy)
        pulumi.set(__self__, "enable_fs_freeze", enable_fs_freeze)
        pulumi.set(__self__, "post_script_path", post_script_path)
        pulumi.set(__self__, "pre_script_path", pre_script_path)
        pulumi.set(__self__, "snapshot_group", snapshot_group)
        pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @property
    @pulumi.getter(name="appConsistent")
    def app_consistent(self) -> bool:
        """
        Whether to turn on application consistency. The application consistency snapshot backs up memory data and ongoing database transactions at the time of snapshot creation to ensure the consistency of application system data and database transactions. By applying consistent snapshots, there is no data damage or loss, so as to avoid log rollback during database startup and ensure that the application is in a consistent startup state. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "app_consistent")

    @property
    @pulumi.getter(name="destinationRegionId")
    def destination_region_id(self) -> str:
        """
        Only vaild when DoCopy is true. The destination region ID when replicating to another region. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "destination_region_id")

    @property
    @pulumi.getter(name="destinationRetention")
    def destination_retention(self) -> int:
        """
        Only vaild when DoCopy is true. The retention days of the destination backup. When not specified, the destination backup will be saved permanently. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "destination_retention")

    @property
    @pulumi.getter(name="diskIdLists")
    def disk_id_lists(self) -> Sequence[str]:
        """
        The list of cloud disks to be backed up in the ECS instance. When not specified, a snapshot is executed for all the disks on the ECS instance.
        """
        return pulumi.get(self, "disk_id_lists")

    @property
    @pulumi.getter(name="doCopy")
    def do_copy(self) -> bool:
        """
        Whether replicate to another region. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "do_copy")

    @property
    @pulumi.getter(name="enableFsFreeze")
    def enable_fs_freeze(self) -> bool:
        """
        Only the Linux system is valid. Whether to use the Linux FsFreeze mechanism to ensure that the file system is read-only consistent before creating a storage snapshot. The default is True. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_fs_freeze")

    @property
    @pulumi.getter(name="postScriptPath")
    def post_script_path(self) -> str:
        """
        Only vaild for the linux system when AppConsistent is true. The application thaw script path (e.g. /tmp/postscript.sh). The postscript.sh script must meet the following conditions: in terms of permissions, only the root user as the owner has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        """
        return pulumi.get(self, "post_script_path")

    @property
    @pulumi.getter(name="preScriptPath")
    def pre_script_path(self) -> str:
        """
        Only vaild for the linux system when AppConsistent is true. Apply the freeze script path (e.g. /tmp/prescript.sh). prescript.sh scripts must meet the following conditions: in terms of permissions, only root, as the owner, has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        """
        return pulumi.get(self, "pre_script_path")

    @property
    @pulumi.getter(name="snapshotGroup")
    def snapshot_group(self) -> bool:
        """
        Whether to turn on file system consistency. If SnapshotGroup is true, when AppConsistent is true but the relevant conditions are not met or AppConsistent is false, the resulting snapshot will be a file system consistency snapshot. The file system consistency ensures that the file system memory and disk information are synchronized at the time of snapshot creation, and the file system write operation is frozen to make the file system in a consistent state. The file system consistency snapshot can prevent the operating system from performing disk inspection and repair operations such as CHKDSK or fsck after restart. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "snapshot_group")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> int:
        """
        Only the Linux system is valid, and the IO freeze timeout period. The default is 30 seconds.
        """
        return pulumi.get(self, "timeout_in_seconds")


@pulumi.output_type
class GetSnapshotsSnapshotResult(dict):
    def __init__(__self__, *,
                 actual_bytes: str,
                 actual_items: str,
                 backup_type: str,
                 bucket: str,
                 bytes_done: str,
                 bytes_total: str,
                 client_id: str,
                 complete_time: str,
                 create_time: str,
                 created_time: str,
                 error_file: str,
                 file_system_id: str,
                 id: str,
                 instance_id: str,
                 items_done: str,
                 items_total: str,
                 job_id: str,
                 parent_snapshot_hash: str,
                 path: str,
                 prefix: str,
                 retention: str,
                 snapshot_hash: str,
                 snapshot_id: str,
                 source_type: str,
                 start_time: str,
                 status: str,
                 updated_time: str):
        """
        :param str actual_bytes: The actual data volume of the snapshot. Unit byte.
        :param str actual_items: The actual number of items in the snapshot. (Currently only file backup is available).
        :param str backup_type: Backup type. Possible values: `COMPLETE` (full backup).
        :param str bucket: The name of OSS bucket.
        :param str bytes_done: The incremental amount of backup data. Unit byte.
        :param str bytes_total: The total amount of data sources. Unit byte.
        :param str client_id: The ID of ECS backup client.
        :param str complete_time: The time when the snapshot completed. UNIX time in seconds.
        :param str create_time: File System Creation Time of Nas. Unix Time Seconds.
        :param str created_time: Snapshot creation time. UNIX time in seconds.
        :param str file_system_id: The ID of NAS File system.
        :param str id: The ID of the Snapshot.
        :param str instance_id: The ID of ECS instance.
        :param str items_done: The number of backup items. (Currently only file backup is available).
        :param str items_total: The total number of data source items. (Currently only file backup is available).
        :param str job_id: The job ID of backup task.
        :param str parent_snapshot_hash: The hashcode of parent backup snapshot.
        :param str path: Backup Path.
        :param str prefix: Backup file prefix.
        :param str retention: The number of days to keep.
        :param str snapshot_hash: The hashcode of Snapshot.
        :param str snapshot_id: The ID of the Snapshot.
        :param str source_type: Data source type, optional values: `ECS_FILE`, `OSS`, `NAS`.
        :param str start_time: The start time of the snapshot. UNIX time in seconds.
        :param str status: The status of snapshot execution. Possible values: `COMPLETE`, `PARTIAL_COMPLETE`, `FAILED`.
        :param str updated_time: The update time of snapshot. UNIX time in seconds.
        """
        pulumi.set(__self__, "actual_bytes", actual_bytes)
        pulumi.set(__self__, "actual_items", actual_items)
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "bytes_done", bytes_done)
        pulumi.set(__self__, "bytes_total", bytes_total)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "complete_time", complete_time)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "error_file", error_file)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "items_done", items_done)
        pulumi.set(__self__, "items_total", items_total)
        pulumi.set(__self__, "job_id", job_id)
        pulumi.set(__self__, "parent_snapshot_hash", parent_snapshot_hash)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "snapshot_hash", snapshot_hash)
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_time", updated_time)

    @property
    @pulumi.getter(name="actualBytes")
    def actual_bytes(self) -> str:
        """
        The actual data volume of the snapshot. Unit byte.
        """
        return pulumi.get(self, "actual_bytes")

    @property
    @pulumi.getter(name="actualItems")
    def actual_items(self) -> str:
        """
        The actual number of items in the snapshot. (Currently only file backup is available).
        """
        return pulumi.get(self, "actual_items")

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> str:
        """
        Backup type. Possible values: `COMPLETE` (full backup).
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of OSS bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="bytesDone")
    def bytes_done(self) -> str:
        """
        The incremental amount of backup data. Unit byte.
        """
        return pulumi.get(self, "bytes_done")

    @property
    @pulumi.getter(name="bytesTotal")
    def bytes_total(self) -> str:
        """
        The total amount of data sources. Unit byte.
        """
        return pulumi.get(self, "bytes_total")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The ID of ECS backup client.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="completeTime")
    def complete_time(self) -> str:
        """
        The time when the snapshot completed. UNIX time in seconds.
        """
        return pulumi.get(self, "complete_time")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        File System Creation Time of Nas. Unix Time Seconds.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        Snapshot creation time. UNIX time in seconds.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="errorFile")
    def error_file(self) -> str:
        return pulumi.get(self, "error_file")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> str:
        """
        The ID of NAS File system.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Snapshot.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of ECS instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="itemsDone")
    def items_done(self) -> str:
        """
        The number of backup items. (Currently only file backup is available).
        """
        return pulumi.get(self, "items_done")

    @property
    @pulumi.getter(name="itemsTotal")
    def items_total(self) -> str:
        """
        The total number of data source items. (Currently only file backup is available).
        """
        return pulumi.get(self, "items_total")

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> str:
        """
        The job ID of backup task.
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter(name="parentSnapshotHash")
    def parent_snapshot_hash(self) -> str:
        """
        The hashcode of parent backup snapshot.
        """
        return pulumi.get(self, "parent_snapshot_hash")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Backup Path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        Backup file prefix.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def retention(self) -> str:
        """
        The number of days to keep.
        """
        return pulumi.get(self, "retention")

    @property
    @pulumi.getter(name="snapshotHash")
    def snapshot_hash(self) -> str:
        """
        The hashcode of Snapshot.
        """
        return pulumi.get(self, "snapshot_hash")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> str:
        """
        The ID of the Snapshot.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        Data source type, optional values: `ECS_FILE`, `OSS`, `NAS`.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The start time of the snapshot. UNIX time in seconds.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of snapshot execution. Possible values: `COMPLETE`, `PARTIAL_COMPLETE`, `FAILED`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> str:
        """
        The update time of snapshot. UNIX time in seconds.
        """
        return pulumi.get(self, "updated_time")


@pulumi.output_type
class GetVaultsVaultResult(dict):
    def __init__(__self__, *,
                 bucket_name: str,
                 bytes_done: str,
                 created_time: str,
                 dedup: bool,
                 description: str,
                 id: str,
                 index_available: bool,
                 index_level: str,
                 index_update_time: str,
                 latest_replication_time: str,
                 payment_type: str,
                 replication: bool,
                 replication_source_region_id: str,
                 replication_source_vault_id: str,
                 retention: str,
                 search_enabled: bool,
                 source_types: Sequence[str],
                 status: str,
                 storage_size: str,
                 updated_time: str,
                 vault_id: str,
                 vault_name: str,
                 vault_status_message: str,
                 vault_storage_class: str,
                 vault_type: str):
        """
        :param str bucket_name: The name of the OSS bucket of the Vault.
        :param str bytes_done: The amount of backup data. The unit is Byte.
        :param str created_time: The creation time of the Vault. UNIX time in seconds.
        :param bool dedup: Whether to enable the deduplication function for the database backup Vault.
        :param str description: The description of the vault.
        :param str id: The ID of vault.
        :param bool index_available: Index available.
        :param str index_level: Index level.
        :param str index_update_time: Index update time.
        :param str latest_replication_time: The time of the last remote backup synchronization.
        :param str payment_type: Billing model, possible values:
        :param bool replication: Whether it is a remote backup warehouse. It's a boolean value.
        :param str replication_source_region_id: The region ID to which the remote backup Vault belongs.
        :param str replication_source_vault_id: The source vault ID of the remote backup Vault.
        :param str retention: Warehouse-level data retention days, only valid for archive libraries.
        :param bool search_enabled: Whether to enable the backup search function.
        :param str status: The status of Vault. Valid values: `CREATED`, `ERROR`, `UNKNOWN`.
        :param str storage_size: Backup vault storage usage. The unit is Byte.
        :param str updated_time: The update time of the Vault. UNIX time in seconds.
        :param str vault_id: The ID of vault, same as `id`.
        :param str vault_name: The name of vault.
        :param str vault_status_message: Error status information of Vault. Only valid for remote backup warehouses. Only the remote backup warehouse is valid.
        :param str vault_storage_class: The storage class of vault. Valid values: `STANDARD`.
        :param str vault_type: The type of Vault. Valid values: `STANDARD`,`OTS_BACKUP`.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "bytes_done", bytes_done)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "dedup", dedup)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "index_available", index_available)
        pulumi.set(__self__, "index_level", index_level)
        pulumi.set(__self__, "index_update_time", index_update_time)
        pulumi.set(__self__, "latest_replication_time", latest_replication_time)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "replication", replication)
        pulumi.set(__self__, "replication_source_region_id", replication_source_region_id)
        pulumi.set(__self__, "replication_source_vault_id", replication_source_vault_id)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "search_enabled", search_enabled)
        pulumi.set(__self__, "source_types", source_types)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "storage_size", storage_size)
        pulumi.set(__self__, "updated_time", updated_time)
        pulumi.set(__self__, "vault_id", vault_id)
        pulumi.set(__self__, "vault_name", vault_name)
        pulumi.set(__self__, "vault_status_message", vault_status_message)
        pulumi.set(__self__, "vault_storage_class", vault_storage_class)
        pulumi.set(__self__, "vault_type", vault_type)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of the OSS bucket of the Vault.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="bytesDone")
    def bytes_done(self) -> str:
        """
        The amount of backup data. The unit is Byte.
        """
        return pulumi.get(self, "bytes_done")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        The creation time of the Vault. UNIX time in seconds.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def dedup(self) -> bool:
        """
        Whether to enable the deduplication function for the database backup Vault.
        """
        return pulumi.get(self, "dedup")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the vault.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of vault.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="indexAvailable")
    def index_available(self) -> bool:
        """
        Index available.
        """
        return pulumi.get(self, "index_available")

    @property
    @pulumi.getter(name="indexLevel")
    def index_level(self) -> str:
        """
        Index level.
        """
        return pulumi.get(self, "index_level")

    @property
    @pulumi.getter(name="indexUpdateTime")
    def index_update_time(self) -> str:
        """
        Index update time.
        """
        return pulumi.get(self, "index_update_time")

    @property
    @pulumi.getter(name="latestReplicationTime")
    def latest_replication_time(self) -> str:
        """
        The time of the last remote backup synchronization.
        """
        return pulumi.get(self, "latest_replication_time")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        Billing model, possible values:
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def replication(self) -> bool:
        """
        Whether it is a remote backup warehouse. It's a boolean value.
        """
        return pulumi.get(self, "replication")

    @property
    @pulumi.getter(name="replicationSourceRegionId")
    def replication_source_region_id(self) -> str:
        """
        The region ID to which the remote backup Vault belongs.
        """
        return pulumi.get(self, "replication_source_region_id")

    @property
    @pulumi.getter(name="replicationSourceVaultId")
    def replication_source_vault_id(self) -> str:
        """
        The source vault ID of the remote backup Vault.
        """
        return pulumi.get(self, "replication_source_vault_id")

    @property
    @pulumi.getter
    def retention(self) -> str:
        """
        Warehouse-level data retention days, only valid for archive libraries.
        """
        return pulumi.get(self, "retention")

    @property
    @pulumi.getter(name="searchEnabled")
    def search_enabled(self) -> bool:
        """
        Whether to enable the backup search function.
        """
        return pulumi.get(self, "search_enabled")

    @property
    @pulumi.getter(name="sourceTypes")
    def source_types(self) -> Sequence[str]:
        return pulumi.get(self, "source_types")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of Vault. Valid values: `CREATED`, `ERROR`, `UNKNOWN`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> str:
        """
        Backup vault storage usage. The unit is Byte.
        """
        return pulumi.get(self, "storage_size")

    @property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> str:
        """
        The update time of the Vault. UNIX time in seconds.
        """
        return pulumi.get(self, "updated_time")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The ID of vault, same as `id`.
        """
        return pulumi.get(self, "vault_id")

    @property
    @pulumi.getter(name="vaultName")
    def vault_name(self) -> str:
        """
        The name of vault.
        """
        return pulumi.get(self, "vault_name")

    @property
    @pulumi.getter(name="vaultStatusMessage")
    def vault_status_message(self) -> str:
        """
        Error status information of Vault. Only valid for remote backup warehouses. Only the remote backup warehouse is valid.
        """
        return pulumi.get(self, "vault_status_message")

    @property
    @pulumi.getter(name="vaultStorageClass")
    def vault_storage_class(self) -> str:
        """
        The storage class of vault. Valid values: `STANDARD`.
        """
        return pulumi.get(self, "vault_storage_class")

    @property
    @pulumi.getter(name="vaultType")
    def vault_type(self) -> str:
        """
        The type of Vault. Valid values: `STANDARD`,`OTS_BACKUP`.
        """
        return pulumi.get(self, "vault_type")


