# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 instance_name: pulumi.Input[str],
                 instance_type: pulumi.Input[str],
                 payment_type: pulumi.Input[str],
                 zone_id: pulumi.Input[str],
                 auto_pay: Optional[pulumi.Input[bool]] = None,
                 cold_storage_size: Optional[pulumi.Input[int]] = None,
                 cpu: Optional[pulumi.Input[int]] = None,
                 duration: Optional[pulumi.Input[int]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]]] = None,
                 gateway_count: Optional[pulumi.Input[int]] = None,
                 initial_databases: Optional[pulumi.Input[str]] = None,
                 leader_instance_id: Optional[pulumi.Input[str]] = None,
                 pricing_cycle: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 scale_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 storage_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[str] instance_name: The name of the resource.
        :param pulumi.Input[str] instance_type: The instance type. Value:
               - Standard: Universal.
               - Follower: Read-only slave instance.
               - Warehouse: calculation group type.
               - Shared: Shared.
        :param pulumi.Input[str] payment_type: The payment type of the resource.
        :param pulumi.Input[str] zone_id: The zone Id. Refer to "Instructions for Use".
        :param pulumi.Input[bool] auto_pay: Whether to pay automatically. The default value is true. Value:
               - true: automatic payment
               - false: only generate orders, not pay
               > **NOTE:**  The default value is true. If the balance of your payment method is insufficient, you can set the parameter AutoPay to false, and an unpaid order will be generated. You can log in to the user Center to pay by yourself.
        :param pulumi.Input[int] cold_storage_size: Instance low-frequency storage space. Unit: GB.
               > **NOTE:**  PayAsYouGo (PostPaid) instances ignore this parameter.
        :param pulumi.Input[int] cpu: Instance specifications. Value:
               - 8 cores 32 GB (number of compute nodes: 1)
               - 16 cores 64 GB (number of compute nodes: 1)
               - 32 core 128 GB (number of compute nodes: 2)
               - 64 core 256 GB (number of compute nodes: 4)
               - 96 core 384 GB (number of computing nodes: 6)
               - 128 core 512 GB (number of compute nodes: 8)
               > **NOTE:** Just fill in the audit number. Please submit a work order application for purchasing 1024 or above specifications. Shared instance types do not need to specify specifications. The specification of - 8 core 32GB (number of computing nodes: 1) is only for experience use and cannot be used for production.
        :param pulumi.Input[int] duration: The buying cycle. Buy for 2 months. If the Payment type is PayAsYouGo (PostPaid), you do not need to specify it.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]] endpoints: List of domain names. See `endpoints` below.
        :param pulumi.Input[int] gateway_count: Number of gateway nodes.
        :param pulumi.Input[str] initial_databases: Initialize the database and split multiple database names ",".
        :param pulumi.Input[str] leader_instance_id: The ID of the primary instance.
        :param pulumi.Input[str] pricing_cycle: Billing cycle. Value:
               - Month: monthly billing
               - Hour: hourly billing
               > **NOTE:**  Subscription instances (PrePaid) only supports Month. PayAsYouGo instances (PostPaid) only supports Hour. The Shared type is automatically set to Hour without specifying it.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] scale_type: Change matching type. Value:
               - UPGRADE: UPGRADE
               - DOWNGRADE: Downgrading
               > **NOTE:** The upgrade specification cannot be less than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is larger than the original specification. The downgrading specification cannot be greater than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is smaller than the original specification.
        :param pulumi.Input[str] status: The status of the resource.
        :param pulumi.Input[int] storage_size: The standard storage space of the instance. Unit: GB.
               > **NOTE:**  PayAsYouGo instances (PostPaid) ignore this parameter.
        :param pulumi.Input[Mapping[str, Any]] tags: Instance tag.
        """
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "zone_id", zone_id)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if cold_storage_size is not None:
            pulumi.set(__self__, "cold_storage_size", cold_storage_size)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if gateway_count is not None:
            pulumi.set(__self__, "gateway_count", gateway_count)
        if initial_databases is not None:
            pulumi.set(__self__, "initial_databases", initial_databases)
        if leader_instance_id is not None:
            pulumi.set(__self__, "leader_instance_id", leader_instance_id)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if scale_type is not None:
            pulumi.set(__self__, "scale_type", scale_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_size is not None:
            pulumi.set(__self__, "storage_size", storage_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Input[str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        The instance type. Value:
        - Standard: Universal.
        - Follower: Read-only slave instance.
        - Warehouse: calculation group type.
        - Shared: Shared.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[str]:
        """
        The payment type of the resource.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[str]:
        """
        The zone Id. Refer to "Instructions for Use".
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to pay automatically. The default value is true. Value:
        - true: automatic payment
        - false: only generate orders, not pay
        > **NOTE:**  The default value is true. If the balance of your payment method is insufficient, you can set the parameter AutoPay to false, and an unpaid order will be generated. You can log in to the user Center to pay by yourself.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="coldStorageSize")
    def cold_storage_size(self) -> Optional[pulumi.Input[int]]:
        """
        Instance low-frequency storage space. Unit: GB.
        > **NOTE:**  PayAsYouGo (PostPaid) instances ignore this parameter.
        """
        return pulumi.get(self, "cold_storage_size")

    @cold_storage_size.setter
    def cold_storage_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cold_storage_size", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[int]]:
        """
        Instance specifications. Value:
        - 8 cores 32 GB (number of compute nodes: 1)
        - 16 cores 64 GB (number of compute nodes: 1)
        - 32 core 128 GB (number of compute nodes: 2)
        - 64 core 256 GB (number of compute nodes: 4)
        - 96 core 384 GB (number of computing nodes: 6)
        - 128 core 512 GB (number of compute nodes: 8)
        > **NOTE:** Just fill in the audit number. Please submit a work order application for purchasing 1024 or above specifications. Shared instance types do not need to specify specifications. The specification of - 8 core 32GB (number of computing nodes: 1) is only for experience use and cannot be used for production.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[int]]:
        """
        The buying cycle. Buy for 2 months. If the Payment type is PayAsYouGo (PostPaid), you do not need to specify it.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]]]:
        """
        List of domain names. See `endpoints` below.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="gatewayCount")
    def gateway_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of gateway nodes.
        """
        return pulumi.get(self, "gateway_count")

    @gateway_count.setter
    def gateway_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gateway_count", value)

    @property
    @pulumi.getter(name="initialDatabases")
    def initial_databases(self) -> Optional[pulumi.Input[str]]:
        """
        Initialize the database and split multiple database names ",".
        """
        return pulumi.get(self, "initial_databases")

    @initial_databases.setter
    def initial_databases(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initial_databases", value)

    @property
    @pulumi.getter(name="leaderInstanceId")
    def leader_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the primary instance.
        """
        return pulumi.get(self, "leader_instance_id")

    @leader_instance_id.setter
    def leader_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "leader_instance_id", value)

    @property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[str]]:
        """
        Billing cycle. Value:
        - Month: monthly billing
        - Hour: hourly billing
        > **NOTE:**  Subscription instances (PrePaid) only supports Month. PayAsYouGo instances (PostPaid) only supports Hour. The Shared type is automatically set to Hour without specifying it.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pricing_cycle", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="scaleType")
    def scale_type(self) -> Optional[pulumi.Input[str]]:
        """
        Change matching type. Value:
        - UPGRADE: UPGRADE
        - DOWNGRADE: Downgrading
        > **NOTE:** The upgrade specification cannot be less than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is larger than the original specification. The downgrading specification cannot be greater than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is smaller than the original specification.
        """
        return pulumi.get(self, "scale_type")

    @scale_type.setter
    def scale_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> Optional[pulumi.Input[int]]:
        """
        The standard storage space of the instance. Unit: GB.
        > **NOTE:**  PayAsYouGo instances (PostPaid) ignore this parameter.
        """
        return pulumi.get(self, "storage_size")

    @storage_size.setter
    def storage_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_size", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Instance tag.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 auto_pay: Optional[pulumi.Input[bool]] = None,
                 cold_storage_size: Optional[pulumi.Input[int]] = None,
                 cpu: Optional[pulumi.Input[int]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 duration: Optional[pulumi.Input[int]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]]] = None,
                 gateway_count: Optional[pulumi.Input[int]] = None,
                 initial_databases: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 leader_instance_id: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 pricing_cycle: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 scale_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 storage_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[bool] auto_pay: Whether to pay automatically. The default value is true. Value:
               - true: automatic payment
               - false: only generate orders, not pay
               > **NOTE:**  The default value is true. If the balance of your payment method is insufficient, you can set the parameter AutoPay to false, and an unpaid order will be generated. You can log in to the user Center to pay by yourself.
        :param pulumi.Input[int] cold_storage_size: Instance low-frequency storage space. Unit: GB.
               > **NOTE:**  PayAsYouGo (PostPaid) instances ignore this parameter.
        :param pulumi.Input[int] cpu: Instance specifications. Value:
               - 8 cores 32 GB (number of compute nodes: 1)
               - 16 cores 64 GB (number of compute nodes: 1)
               - 32 core 128 GB (number of compute nodes: 2)
               - 64 core 256 GB (number of compute nodes: 4)
               - 96 core 384 GB (number of computing nodes: 6)
               - 128 core 512 GB (number of compute nodes: 8)
               > **NOTE:** Just fill in the audit number. Please submit a work order application for purchasing 1024 or above specifications. Shared instance types do not need to specify specifications. The specification of - 8 core 32GB (number of computing nodes: 1) is only for experience use and cannot be used for production.
        :param pulumi.Input[str] create_time: The creation time of the resource.
        :param pulumi.Input[int] duration: The buying cycle. Buy for 2 months. If the Payment type is PayAsYouGo (PostPaid), you do not need to specify it.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]] endpoints: List of domain names. See `endpoints` below.
        :param pulumi.Input[int] gateway_count: Number of gateway nodes.
        :param pulumi.Input[str] initial_databases: Initialize the database and split multiple database names ",".
        :param pulumi.Input[str] instance_name: The name of the resource.
        :param pulumi.Input[str] instance_type: The instance type. Value:
               - Standard: Universal.
               - Follower: Read-only slave instance.
               - Warehouse: calculation group type.
               - Shared: Shared.
        :param pulumi.Input[str] leader_instance_id: The ID of the primary instance.
        :param pulumi.Input[str] payment_type: The payment type of the resource.
        :param pulumi.Input[str] pricing_cycle: Billing cycle. Value:
               - Month: monthly billing
               - Hour: hourly billing
               > **NOTE:**  Subscription instances (PrePaid) only supports Month. PayAsYouGo instances (PostPaid) only supports Hour. The Shared type is automatically set to Hour without specifying it.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] scale_type: Change matching type. Value:
               - UPGRADE: UPGRADE
               - DOWNGRADE: Downgrading
               > **NOTE:** The upgrade specification cannot be less than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is larger than the original specification. The downgrading specification cannot be greater than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is smaller than the original specification.
        :param pulumi.Input[str] status: The status of the resource.
        :param pulumi.Input[int] storage_size: The standard storage space of the instance. Unit: GB.
               > **NOTE:**  PayAsYouGo instances (PostPaid) ignore this parameter.
        :param pulumi.Input[Mapping[str, Any]] tags: Instance tag.
        :param pulumi.Input[str] zone_id: The zone Id. Refer to "Instructions for Use".
        """
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if cold_storage_size is not None:
            pulumi.set(__self__, "cold_storage_size", cold_storage_size)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if gateway_count is not None:
            pulumi.set(__self__, "gateway_count", gateway_count)
        if initial_databases is not None:
            pulumi.set(__self__, "initial_databases", initial_databases)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if leader_instance_id is not None:
            pulumi.set(__self__, "leader_instance_id", leader_instance_id)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if scale_type is not None:
            pulumi.set(__self__, "scale_type", scale_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_size is not None:
            pulumi.set(__self__, "storage_size", storage_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to pay automatically. The default value is true. Value:
        - true: automatic payment
        - false: only generate orders, not pay
        > **NOTE:**  The default value is true. If the balance of your payment method is insufficient, you can set the parameter AutoPay to false, and an unpaid order will be generated. You can log in to the user Center to pay by yourself.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="coldStorageSize")
    def cold_storage_size(self) -> Optional[pulumi.Input[int]]:
        """
        Instance low-frequency storage space. Unit: GB.
        > **NOTE:**  PayAsYouGo (PostPaid) instances ignore this parameter.
        """
        return pulumi.get(self, "cold_storage_size")

    @cold_storage_size.setter
    def cold_storage_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cold_storage_size", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[int]]:
        """
        Instance specifications. Value:
        - 8 cores 32 GB (number of compute nodes: 1)
        - 16 cores 64 GB (number of compute nodes: 1)
        - 32 core 128 GB (number of compute nodes: 2)
        - 64 core 256 GB (number of compute nodes: 4)
        - 96 core 384 GB (number of computing nodes: 6)
        - 128 core 512 GB (number of compute nodes: 8)
        > **NOTE:** Just fill in the audit number. Please submit a work order application for purchasing 1024 or above specifications. Shared instance types do not need to specify specifications. The specification of - 8 core 32GB (number of computing nodes: 1) is only for experience use and cannot be used for production.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[int]]:
        """
        The buying cycle. Buy for 2 months. If the Payment type is PayAsYouGo (PostPaid), you do not need to specify it.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]]]:
        """
        List of domain names. See `endpoints` below.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="gatewayCount")
    def gateway_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of gateway nodes.
        """
        return pulumi.get(self, "gateway_count")

    @gateway_count.setter
    def gateway_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gateway_count", value)

    @property
    @pulumi.getter(name="initialDatabases")
    def initial_databases(self) -> Optional[pulumi.Input[str]]:
        """
        Initialize the database and split multiple database names ",".
        """
        return pulumi.get(self, "initial_databases")

    @initial_databases.setter
    def initial_databases(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initial_databases", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type. Value:
        - Standard: Universal.
        - Follower: Read-only slave instance.
        - Warehouse: calculation group type.
        - Shared: Shared.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="leaderInstanceId")
    def leader_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the primary instance.
        """
        return pulumi.get(self, "leader_instance_id")

    @leader_instance_id.setter
    def leader_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "leader_instance_id", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The payment type of the resource.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[str]]:
        """
        Billing cycle. Value:
        - Month: monthly billing
        - Hour: hourly billing
        > **NOTE:**  Subscription instances (PrePaid) only supports Month. PayAsYouGo instances (PostPaid) only supports Hour. The Shared type is automatically set to Hour without specifying it.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pricing_cycle", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="scaleType")
    def scale_type(self) -> Optional[pulumi.Input[str]]:
        """
        Change matching type. Value:
        - UPGRADE: UPGRADE
        - DOWNGRADE: Downgrading
        > **NOTE:** The upgrade specification cannot be less than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is larger than the original specification. The downgrading specification cannot be greater than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is smaller than the original specification.
        """
        return pulumi.get(self, "scale_type")

    @scale_type.setter
    def scale_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> Optional[pulumi.Input[int]]:
        """
        The standard storage space of the instance. Unit: GB.
        > **NOTE:**  PayAsYouGo instances (PostPaid) ignore this parameter.
        """
        return pulumi.get(self, "storage_size")

    @storage_size.setter
    def storage_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_size", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Instance tag.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone Id. Refer to "Instructions for Use".
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[bool]] = None,
                 cold_storage_size: Optional[pulumi.Input[int]] = None,
                 cpu: Optional[pulumi.Input[int]] = None,
                 duration: Optional[pulumi.Input[int]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceEndpointArgs']]]]] = None,
                 gateway_count: Optional[pulumi.Input[int]] = None,
                 initial_databases: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 leader_instance_id: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 pricing_cycle: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 scale_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 storage_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        Hologram Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:hologram/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_pay: Whether to pay automatically. The default value is true. Value:
               - true: automatic payment
               - false: only generate orders, not pay
               > **NOTE:**  The default value is true. If the balance of your payment method is insufficient, you can set the parameter AutoPay to false, and an unpaid order will be generated. You can log in to the user Center to pay by yourself.
        :param pulumi.Input[int] cold_storage_size: Instance low-frequency storage space. Unit: GB.
               > **NOTE:**  PayAsYouGo (PostPaid) instances ignore this parameter.
        :param pulumi.Input[int] cpu: Instance specifications. Value:
               - 8 cores 32 GB (number of compute nodes: 1)
               - 16 cores 64 GB (number of compute nodes: 1)
               - 32 core 128 GB (number of compute nodes: 2)
               - 64 core 256 GB (number of compute nodes: 4)
               - 96 core 384 GB (number of computing nodes: 6)
               - 128 core 512 GB (number of compute nodes: 8)
               > **NOTE:** Just fill in the audit number. Please submit a work order application for purchasing 1024 or above specifications. Shared instance types do not need to specify specifications. The specification of - 8 core 32GB (number of computing nodes: 1) is only for experience use and cannot be used for production.
        :param pulumi.Input[int] duration: The buying cycle. Buy for 2 months. If the Payment type is PayAsYouGo (PostPaid), you do not need to specify it.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceEndpointArgs']]]] endpoints: List of domain names. See `endpoints` below.
        :param pulumi.Input[int] gateway_count: Number of gateway nodes.
        :param pulumi.Input[str] initial_databases: Initialize the database and split multiple database names ",".
        :param pulumi.Input[str] instance_name: The name of the resource.
        :param pulumi.Input[str] instance_type: The instance type. Value:
               - Standard: Universal.
               - Follower: Read-only slave instance.
               - Warehouse: calculation group type.
               - Shared: Shared.
        :param pulumi.Input[str] leader_instance_id: The ID of the primary instance.
        :param pulumi.Input[str] payment_type: The payment type of the resource.
        :param pulumi.Input[str] pricing_cycle: Billing cycle. Value:
               - Month: monthly billing
               - Hour: hourly billing
               > **NOTE:**  Subscription instances (PrePaid) only supports Month. PayAsYouGo instances (PostPaid) only supports Hour. The Shared type is automatically set to Hour without specifying it.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] scale_type: Change matching type. Value:
               - UPGRADE: UPGRADE
               - DOWNGRADE: Downgrading
               > **NOTE:** The upgrade specification cannot be less than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is larger than the original specification. The downgrading specification cannot be greater than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is smaller than the original specification.
        :param pulumi.Input[str] status: The status of the resource.
        :param pulumi.Input[int] storage_size: The standard storage space of the instance. Unit: GB.
               > **NOTE:**  PayAsYouGo instances (PostPaid) ignore this parameter.
        :param pulumi.Input[Mapping[str, Any]] tags: Instance tag.
        :param pulumi.Input[str] zone_id: The zone Id. Refer to "Instructions for Use".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Hologram Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:hologram/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[bool]] = None,
                 cold_storage_size: Optional[pulumi.Input[int]] = None,
                 cpu: Optional[pulumi.Input[int]] = None,
                 duration: Optional[pulumi.Input[int]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceEndpointArgs']]]]] = None,
                 gateway_count: Optional[pulumi.Input[int]] = None,
                 initial_databases: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 leader_instance_id: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 pricing_cycle: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 scale_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 storage_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["cold_storage_size"] = cold_storage_size
            __props__.__dict__["cpu"] = cpu
            __props__.__dict__["duration"] = duration
            __props__.__dict__["endpoints"] = endpoints
            __props__.__dict__["gateway_count"] = gateway_count
            __props__.__dict__["initial_databases"] = initial_databases
            if instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_name'")
            __props__.__dict__["instance_name"] = instance_name
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["leader_instance_id"] = leader_instance_id
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["pricing_cycle"] = pricing_cycle
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["scale_type"] = scale_type
            __props__.__dict__["status"] = status
            __props__.__dict__["storage_size"] = storage_size
            __props__.__dict__["tags"] = tags
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["create_time"] = None
        super(Instance, __self__).__init__(
            'alicloud:hologram/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_pay: Optional[pulumi.Input[bool]] = None,
            cold_storage_size: Optional[pulumi.Input[int]] = None,
            cpu: Optional[pulumi.Input[int]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            duration: Optional[pulumi.Input[int]] = None,
            endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceEndpointArgs']]]]] = None,
            gateway_count: Optional[pulumi.Input[int]] = None,
            initial_databases: Optional[pulumi.Input[str]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            leader_instance_id: Optional[pulumi.Input[str]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            pricing_cycle: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            scale_type: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            storage_size: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_pay: Whether to pay automatically. The default value is true. Value:
               - true: automatic payment
               - false: only generate orders, not pay
               > **NOTE:**  The default value is true. If the balance of your payment method is insufficient, you can set the parameter AutoPay to false, and an unpaid order will be generated. You can log in to the user Center to pay by yourself.
        :param pulumi.Input[int] cold_storage_size: Instance low-frequency storage space. Unit: GB.
               > **NOTE:**  PayAsYouGo (PostPaid) instances ignore this parameter.
        :param pulumi.Input[int] cpu: Instance specifications. Value:
               - 8 cores 32 GB (number of compute nodes: 1)
               - 16 cores 64 GB (number of compute nodes: 1)
               - 32 core 128 GB (number of compute nodes: 2)
               - 64 core 256 GB (number of compute nodes: 4)
               - 96 core 384 GB (number of computing nodes: 6)
               - 128 core 512 GB (number of compute nodes: 8)
               > **NOTE:** Just fill in the audit number. Please submit a work order application for purchasing 1024 or above specifications. Shared instance types do not need to specify specifications. The specification of - 8 core 32GB (number of computing nodes: 1) is only for experience use and cannot be used for production.
        :param pulumi.Input[str] create_time: The creation time of the resource.
        :param pulumi.Input[int] duration: The buying cycle. Buy for 2 months. If the Payment type is PayAsYouGo (PostPaid), you do not need to specify it.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceEndpointArgs']]]] endpoints: List of domain names. See `endpoints` below.
        :param pulumi.Input[int] gateway_count: Number of gateway nodes.
        :param pulumi.Input[str] initial_databases: Initialize the database and split multiple database names ",".
        :param pulumi.Input[str] instance_name: The name of the resource.
        :param pulumi.Input[str] instance_type: The instance type. Value:
               - Standard: Universal.
               - Follower: Read-only slave instance.
               - Warehouse: calculation group type.
               - Shared: Shared.
        :param pulumi.Input[str] leader_instance_id: The ID of the primary instance.
        :param pulumi.Input[str] payment_type: The payment type of the resource.
        :param pulumi.Input[str] pricing_cycle: Billing cycle. Value:
               - Month: monthly billing
               - Hour: hourly billing
               > **NOTE:**  Subscription instances (PrePaid) only supports Month. PayAsYouGo instances (PostPaid) only supports Hour. The Shared type is automatically set to Hour without specifying it.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] scale_type: Change matching type. Value:
               - UPGRADE: UPGRADE
               - DOWNGRADE: Downgrading
               > **NOTE:** The upgrade specification cannot be less than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is larger than the original specification. The downgrading specification cannot be greater than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is smaller than the original specification.
        :param pulumi.Input[str] status: The status of the resource.
        :param pulumi.Input[int] storage_size: The standard storage space of the instance. Unit: GB.
               > **NOTE:**  PayAsYouGo instances (PostPaid) ignore this parameter.
        :param pulumi.Input[Mapping[str, Any]] tags: Instance tag.
        :param pulumi.Input[str] zone_id: The zone Id. Refer to "Instructions for Use".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["cold_storage_size"] = cold_storage_size
        __props__.__dict__["cpu"] = cpu
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["duration"] = duration
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["gateway_count"] = gateway_count
        __props__.__dict__["initial_databases"] = initial_databases
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["leader_instance_id"] = leader_instance_id
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["pricing_cycle"] = pricing_cycle
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["scale_type"] = scale_type
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_size"] = storage_size
        __props__.__dict__["tags"] = tags
        __props__.__dict__["zone_id"] = zone_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to pay automatically. The default value is true. Value:
        - true: automatic payment
        - false: only generate orders, not pay
        > **NOTE:**  The default value is true. If the balance of your payment method is insufficient, you can set the parameter AutoPay to false, and an unpaid order will be generated. You can log in to the user Center to pay by yourself.
        """
        return pulumi.get(self, "auto_pay")

    @property
    @pulumi.getter(name="coldStorageSize")
    def cold_storage_size(self) -> pulumi.Output[Optional[int]]:
        """
        Instance low-frequency storage space. Unit: GB.
        > **NOTE:**  PayAsYouGo (PostPaid) instances ignore this parameter.
        """
        return pulumi.get(self, "cold_storage_size")

    @property
    @pulumi.getter
    def cpu(self) -> pulumi.Output[int]:
        """
        Instance specifications. Value:
        - 8 cores 32 GB (number of compute nodes: 1)
        - 16 cores 64 GB (number of compute nodes: 1)
        - 32 core 128 GB (number of compute nodes: 2)
        - 64 core 256 GB (number of compute nodes: 4)
        - 96 core 384 GB (number of computing nodes: 6)
        - 128 core 512 GB (number of compute nodes: 8)
        > **NOTE:** Just fill in the audit number. Please submit a work order application for purchasing 1024 or above specifications. Shared instance types do not need to specify specifications. The specification of - 8 core 32GB (number of computing nodes: 1) is only for experience use and cannot be used for production.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Output[Optional[int]]:
        """
        The buying cycle. Buy for 2 months. If the Payment type is PayAsYouGo (PostPaid), you do not need to specify it.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence['outputs.InstanceEndpoint']]:
        """
        List of domain names. See `endpoints` below.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="gatewayCount")
    def gateway_count(self) -> pulumi.Output[Optional[int]]:
        """
        Number of gateway nodes.
        """
        return pulumi.get(self, "gateway_count")

    @property
    @pulumi.getter(name="initialDatabases")
    def initial_databases(self) -> pulumi.Output[Optional[str]]:
        """
        Initialize the database and split multiple database names ",".
        """
        return pulumi.get(self, "initial_databases")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        The instance type. Value:
        - Standard: Universal.
        - Follower: Read-only slave instance.
        - Warehouse: calculation group type.
        - Shared: Shared.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="leaderInstanceId")
    def leader_instance_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the primary instance.
        """
        return pulumi.get(self, "leader_instance_id")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        The payment type of the resource.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> pulumi.Output[Optional[str]]:
        """
        Billing cycle. Value:
        - Month: monthly billing
        - Hour: hourly billing
        > **NOTE:**  Subscription instances (PrePaid) only supports Month. PayAsYouGo instances (PostPaid) only supports Hour. The Shared type is automatically set to Hour without specifying it.
        """
        return pulumi.get(self, "pricing_cycle")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="scaleType")
    def scale_type(self) -> pulumi.Output[Optional[str]]:
        """
        Change matching type. Value:
        - UPGRADE: UPGRADE
        - DOWNGRADE: Downgrading
        > **NOTE:** The upgrade specification cannot be less than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is larger than the original specification. The downgrading specification cannot be greater than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is smaller than the original specification.
        """
        return pulumi.get(self, "scale_type")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> pulumi.Output[Optional[int]]:
        """
        The standard storage space of the instance. Unit: GB.
        > **NOTE:**  PayAsYouGo instances (PostPaid) ignore this parameter.
        """
        return pulumi.get(self, "storage_size")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Instance tag.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone Id. Refer to "Instructions for Use".
        """
        return pulumi.get(self, "zone_id")

