# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DeviceGroupArgs', 'DeviceGroup']

@pulumi.input_type
class DeviceGroupArgs:
    def __init__(__self__, *,
                 group_name: pulumi.Input[str],
                 group_desc: Optional[pulumi.Input[str]] = None,
                 iot_instance_id: Optional[pulumi.Input[str]] = None,
                 super_group_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DeviceGroup resource.
        :param pulumi.Input[str] group_name: The GroupName of the device group.
        :param pulumi.Input[str] group_desc: The GroupDesc of the device group.
        :param pulumi.Input[str] iot_instance_id: The id of the Iot Instance.
        :param pulumi.Input[str] super_group_id: The id of the SuperGroup.
        """
        pulumi.set(__self__, "group_name", group_name)
        if group_desc is not None:
            pulumi.set(__self__, "group_desc", group_desc)
        if iot_instance_id is not None:
            pulumi.set(__self__, "iot_instance_id", iot_instance_id)
        if super_group_id is not None:
            pulumi.set(__self__, "super_group_id", super_group_id)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Input[str]:
        """
        The GroupName of the device group.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="groupDesc")
    def group_desc(self) -> Optional[pulumi.Input[str]]:
        """
        The GroupDesc of the device group.
        """
        return pulumi.get(self, "group_desc")

    @group_desc.setter
    def group_desc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_desc", value)

    @property
    @pulumi.getter(name="iotInstanceId")
    def iot_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the Iot Instance.
        """
        return pulumi.get(self, "iot_instance_id")

    @iot_instance_id.setter
    def iot_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iot_instance_id", value)

    @property
    @pulumi.getter(name="superGroupId")
    def super_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the SuperGroup.
        """
        return pulumi.get(self, "super_group_id")

    @super_group_id.setter
    def super_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "super_group_id", value)


@pulumi.input_type
class _DeviceGroupState:
    def __init__(__self__, *,
                 group_desc: Optional[pulumi.Input[str]] = None,
                 group_name: Optional[pulumi.Input[str]] = None,
                 iot_instance_id: Optional[pulumi.Input[str]] = None,
                 super_group_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DeviceGroup resources.
        :param pulumi.Input[str] group_desc: The GroupDesc of the device group.
        :param pulumi.Input[str] group_name: The GroupName of the device group.
        :param pulumi.Input[str] iot_instance_id: The id of the Iot Instance.
        :param pulumi.Input[str] super_group_id: The id of the SuperGroup.
        """
        if group_desc is not None:
            pulumi.set(__self__, "group_desc", group_desc)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if iot_instance_id is not None:
            pulumi.set(__self__, "iot_instance_id", iot_instance_id)
        if super_group_id is not None:
            pulumi.set(__self__, "super_group_id", super_group_id)

    @property
    @pulumi.getter(name="groupDesc")
    def group_desc(self) -> Optional[pulumi.Input[str]]:
        """
        The GroupDesc of the device group.
        """
        return pulumi.get(self, "group_desc")

    @group_desc.setter
    def group_desc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_desc", value)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The GroupName of the device group.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="iotInstanceId")
    def iot_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the Iot Instance.
        """
        return pulumi.get(self, "iot_instance_id")

    @iot_instance_id.setter
    def iot_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iot_instance_id", value)

    @property
    @pulumi.getter(name="superGroupId")
    def super_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the SuperGroup.
        """
        return pulumi.get(self, "super_group_id")

    @super_group_id.setter
    def super_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "super_group_id", value)


class DeviceGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_desc: Optional[pulumi.Input[str]] = None,
                 group_name: Optional[pulumi.Input[str]] = None,
                 iot_instance_id: Optional[pulumi.Input[str]] = None,
                 super_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Iot Device Group resource.

        For information about Iot Device Group and how to use it, see [What is Device Group](https://www.alibabacloud.com/help/product/30520.htm).

        > **NOTE:** Available since v1.134.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tfexample"
        example = alicloud.iot.DeviceGroup("example", group_name=name)
        ```

        ## Import

        Iot Device Group can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:iot/deviceGroup:DeviceGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group_desc: The GroupDesc of the device group.
        :param pulumi.Input[str] group_name: The GroupName of the device group.
        :param pulumi.Input[str] iot_instance_id: The id of the Iot Instance.
        :param pulumi.Input[str] super_group_id: The id of the SuperGroup.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeviceGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Iot Device Group resource.

        For information about Iot Device Group and how to use it, see [What is Device Group](https://www.alibabacloud.com/help/product/30520.htm).

        > **NOTE:** Available since v1.134.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tfexample"
        example = alicloud.iot.DeviceGroup("example", group_name=name)
        ```

        ## Import

        Iot Device Group can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:iot/deviceGroup:DeviceGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DeviceGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeviceGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_desc: Optional[pulumi.Input[str]] = None,
                 group_name: Optional[pulumi.Input[str]] = None,
                 iot_instance_id: Optional[pulumi.Input[str]] = None,
                 super_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeviceGroupArgs.__new__(DeviceGroupArgs)

            __props__.__dict__["group_desc"] = group_desc
            if group_name is None and not opts.urn:
                raise TypeError("Missing required property 'group_name'")
            __props__.__dict__["group_name"] = group_name
            __props__.__dict__["iot_instance_id"] = iot_instance_id
            __props__.__dict__["super_group_id"] = super_group_id
        super(DeviceGroup, __self__).__init__(
            'alicloud:iot/deviceGroup:DeviceGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_desc: Optional[pulumi.Input[str]] = None,
            group_name: Optional[pulumi.Input[str]] = None,
            iot_instance_id: Optional[pulumi.Input[str]] = None,
            super_group_id: Optional[pulumi.Input[str]] = None) -> 'DeviceGroup':
        """
        Get an existing DeviceGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group_desc: The GroupDesc of the device group.
        :param pulumi.Input[str] group_name: The GroupName of the device group.
        :param pulumi.Input[str] iot_instance_id: The id of the Iot Instance.
        :param pulumi.Input[str] super_group_id: The id of the SuperGroup.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeviceGroupState.__new__(_DeviceGroupState)

        __props__.__dict__["group_desc"] = group_desc
        __props__.__dict__["group_name"] = group_name
        __props__.__dict__["iot_instance_id"] = iot_instance_id
        __props__.__dict__["super_group_id"] = super_group_id
        return DeviceGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="groupDesc")
    def group_desc(self) -> pulumi.Output[Optional[str]]:
        """
        The GroupDesc of the device group.
        """
        return pulumi.get(self, "group_desc")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[str]:
        """
        The GroupName of the device group.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="iotInstanceId")
    def iot_instance_id(self) -> pulumi.Output[Optional[str]]:
        """
        The id of the Iot Instance.
        """
        return pulumi.get(self, "iot_instance_id")

    @property
    @pulumi.getter(name="superGroupId")
    def super_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        The id of the SuperGroup.
        """
        return pulumi.get(self, "super_group_id")

