# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SecretArgs', 'Secret']

@pulumi.input_type
class SecretArgs:
    def __init__(__self__, *,
                 secret_data: pulumi.Input[str],
                 secret_name: pulumi.Input[str],
                 version_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 dkms_instance_id: Optional[pulumi.Input[str]] = None,
                 enable_automatic_rotation: Optional[pulumi.Input[bool]] = None,
                 encryption_key_id: Optional[pulumi.Input[str]] = None,
                 extended_config: Optional[pulumi.Input[str]] = None,
                 force_delete_without_recovery: Optional[pulumi.Input[bool]] = None,
                 recovery_window_in_days: Optional[pulumi.Input[int]] = None,
                 rotation_interval: Optional[pulumi.Input[str]] = None,
                 secret_data_type: Optional[pulumi.Input[str]] = None,
                 secret_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 version_stages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Secret resource.
        :param pulumi.Input[str] secret_data: The value of the secret that you want to create. Secrets Manager encrypts the secret value and stores it in the initial version. **NOTE:** From version 1.204.1, attribute `secret_data` updating diff will be ignored when `secret_type` is not Generic.
        :param pulumi.Input[str] secret_name: The name of the secret.
        :param pulumi.Input[str] version_id: The version number of the initial version. Version numbers are unique in each secret object.
        :param pulumi.Input[str] description: The description of the secret.
        :param pulumi.Input[str] dkms_instance_id: The instance ID of the exclusive KMS instance.
        :param pulumi.Input[bool] enable_automatic_rotation: Whether to enable automatic key rotation.
        :param pulumi.Input[str] encryption_key_id: The ID of the KMS CMK that is used to encrypt the secret value. If you do not specify this parameter, Secrets Manager automatically creates an encryption key to encrypt the secret.
        :param pulumi.Input[str] extended_config: The extended configuration of the secret. This parameter specifies the properties of the secret of the specific type. The description can be up to 1,024 characters in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        :param pulumi.Input[bool] force_delete_without_recovery: Specifies whether to forcibly delete the secret. If this parameter is set to true, the secret cannot be recovered. Valid values: true, false. Default to: false.
        :param pulumi.Input[int] recovery_window_in_days: Specifies the recovery period of the secret if you do not forcibly delete it. Default value: 30. It will be ignored when `force_delete_without_recovery` is true.
        :param pulumi.Input[str] rotation_interval: The time period of automatic rotation. The format is integer[unit], where integer represents the length of time, and unit represents the unit of time. The legal unit units are: d (day), h (hour), m (minute), s (second). 7d or 604800s both indicate a 7-day cycle.
        :param pulumi.Input[str] secret_data_type: The type of the secret value. Valid values: text, binary. Default to "text".
        :param pulumi.Input[str] secret_type: The type of the secret. Valid values:
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] version_stages: ) The stage labels that mark the new secret version. If you do not specify this parameter, Secrets Manager marks it with "ACSCurrent".
        """
        pulumi.set(__self__, "secret_data", secret_data)
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "version_id", version_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dkms_instance_id is not None:
            pulumi.set(__self__, "dkms_instance_id", dkms_instance_id)
        if enable_automatic_rotation is not None:
            pulumi.set(__self__, "enable_automatic_rotation", enable_automatic_rotation)
        if encryption_key_id is not None:
            pulumi.set(__self__, "encryption_key_id", encryption_key_id)
        if extended_config is not None:
            pulumi.set(__self__, "extended_config", extended_config)
        if force_delete_without_recovery is not None:
            pulumi.set(__self__, "force_delete_without_recovery", force_delete_without_recovery)
        if recovery_window_in_days is not None:
            pulumi.set(__self__, "recovery_window_in_days", recovery_window_in_days)
        if rotation_interval is not None:
            pulumi.set(__self__, "rotation_interval", rotation_interval)
        if secret_data_type is not None:
            pulumi.set(__self__, "secret_data_type", secret_data_type)
        if secret_type is not None:
            pulumi.set(__self__, "secret_type", secret_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version_stages is not None:
            pulumi.set(__self__, "version_stages", version_stages)

    @property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> pulumi.Input[str]:
        """
        The value of the secret that you want to create. Secrets Manager encrypts the secret value and stores it in the initial version. **NOTE:** From version 1.204.1, attribute `secret_data` updating diff will be ignored when `secret_type` is not Generic.
        """
        return pulumi.get(self, "secret_data")

    @secret_data.setter
    def secret_data(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_data", value)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Input[str]:
        """
        The name of the secret.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_name", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Input[str]:
        """
        The version number of the initial version. Version numbers are unique in each secret object.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "version_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the secret.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dkmsInstanceId")
    def dkms_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The instance ID of the exclusive KMS instance.
        """
        return pulumi.get(self, "dkms_instance_id")

    @dkms_instance_id.setter
    def dkms_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dkms_instance_id", value)

    @property
    @pulumi.getter(name="enableAutomaticRotation")
    def enable_automatic_rotation(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable automatic key rotation.
        """
        return pulumi.get(self, "enable_automatic_rotation")

    @enable_automatic_rotation.setter
    def enable_automatic_rotation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_automatic_rotation", value)

    @property
    @pulumi.getter(name="encryptionKeyId")
    def encryption_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the KMS CMK that is used to encrypt the secret value. If you do not specify this parameter, Secrets Manager automatically creates an encryption key to encrypt the secret.
        """
        return pulumi.get(self, "encryption_key_id")

    @encryption_key_id.setter
    def encryption_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_key_id", value)

    @property
    @pulumi.getter(name="extendedConfig")
    def extended_config(self) -> Optional[pulumi.Input[str]]:
        """
        The extended configuration of the secret. This parameter specifies the properties of the secret of the specific type. The description can be up to 1,024 characters in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        """
        return pulumi.get(self, "extended_config")

    @extended_config.setter
    def extended_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extended_config", value)

    @property
    @pulumi.getter(name="forceDeleteWithoutRecovery")
    def force_delete_without_recovery(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to forcibly delete the secret. If this parameter is set to true, the secret cannot be recovered. Valid values: true, false. Default to: false.
        """
        return pulumi.get(self, "force_delete_without_recovery")

    @force_delete_without_recovery.setter
    def force_delete_without_recovery(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete_without_recovery", value)

    @property
    @pulumi.getter(name="recoveryWindowInDays")
    def recovery_window_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the recovery period of the secret if you do not forcibly delete it. Default value: 30. It will be ignored when `force_delete_without_recovery` is true.
        """
        return pulumi.get(self, "recovery_window_in_days")

    @recovery_window_in_days.setter
    def recovery_window_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_window_in_days", value)

    @property
    @pulumi.getter(name="rotationInterval")
    def rotation_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The time period of automatic rotation. The format is integer[unit], where integer represents the length of time, and unit represents the unit of time. The legal unit units are: d (day), h (hour), m (minute), s (second). 7d or 604800s both indicate a 7-day cycle.
        """
        return pulumi.get(self, "rotation_interval")

    @rotation_interval.setter
    def rotation_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rotation_interval", value)

    @property
    @pulumi.getter(name="secretDataType")
    def secret_data_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the secret value. Valid values: text, binary. Default to "text".
        """
        return pulumi.get(self, "secret_data_type")

    @secret_data_type.setter
    def secret_data_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_data_type", value)

    @property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the secret. Valid values:
        """
        return pulumi.get(self, "secret_type")

    @secret_type.setter
    def secret_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="versionStages")
    def version_stages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        ) The stage labels that mark the new secret version. If you do not specify this parameter, Secrets Manager marks it with "ACSCurrent".
        """
        return pulumi.get(self, "version_stages")

    @version_stages.setter
    def version_stages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "version_stages", value)


@pulumi.input_type
class _SecretState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dkms_instance_id: Optional[pulumi.Input[str]] = None,
                 enable_automatic_rotation: Optional[pulumi.Input[bool]] = None,
                 encryption_key_id: Optional[pulumi.Input[str]] = None,
                 extended_config: Optional[pulumi.Input[str]] = None,
                 force_delete_without_recovery: Optional[pulumi.Input[bool]] = None,
                 planned_delete_time: Optional[pulumi.Input[str]] = None,
                 recovery_window_in_days: Optional[pulumi.Input[int]] = None,
                 rotation_interval: Optional[pulumi.Input[str]] = None,
                 secret_data: Optional[pulumi.Input[str]] = None,
                 secret_data_type: Optional[pulumi.Input[str]] = None,
                 secret_name: Optional[pulumi.Input[str]] = None,
                 secret_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 version_id: Optional[pulumi.Input[str]] = None,
                 version_stages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Secret resources.
        :param pulumi.Input[str] arn: The Alicloud Resource Name (ARN) of the secret.
        :param pulumi.Input[str] description: The description of the secret.
        :param pulumi.Input[str] dkms_instance_id: The instance ID of the exclusive KMS instance.
        :param pulumi.Input[bool] enable_automatic_rotation: Whether to enable automatic key rotation.
        :param pulumi.Input[str] encryption_key_id: The ID of the KMS CMK that is used to encrypt the secret value. If you do not specify this parameter, Secrets Manager automatically creates an encryption key to encrypt the secret.
        :param pulumi.Input[str] extended_config: The extended configuration of the secret. This parameter specifies the properties of the secret of the specific type. The description can be up to 1,024 characters in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        :param pulumi.Input[bool] force_delete_without_recovery: Specifies whether to forcibly delete the secret. If this parameter is set to true, the secret cannot be recovered. Valid values: true, false. Default to: false.
        :param pulumi.Input[str] planned_delete_time: The time when the secret is scheduled to be deleted.
        :param pulumi.Input[int] recovery_window_in_days: Specifies the recovery period of the secret if you do not forcibly delete it. Default value: 30. It will be ignored when `force_delete_without_recovery` is true.
        :param pulumi.Input[str] rotation_interval: The time period of automatic rotation. The format is integer[unit], where integer represents the length of time, and unit represents the unit of time. The legal unit units are: d (day), h (hour), m (minute), s (second). 7d or 604800s both indicate a 7-day cycle.
        :param pulumi.Input[str] secret_data: The value of the secret that you want to create. Secrets Manager encrypts the secret value and stores it in the initial version. **NOTE:** From version 1.204.1, attribute `secret_data` updating diff will be ignored when `secret_type` is not Generic.
        :param pulumi.Input[str] secret_data_type: The type of the secret value. Valid values: text, binary. Default to "text".
        :param pulumi.Input[str] secret_name: The name of the secret.
        :param pulumi.Input[str] secret_type: The type of the secret. Valid values:
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] version_id: The version number of the initial version. Version numbers are unique in each secret object.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] version_stages: ) The stage labels that mark the new secret version. If you do not specify this parameter, Secrets Manager marks it with "ACSCurrent".
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dkms_instance_id is not None:
            pulumi.set(__self__, "dkms_instance_id", dkms_instance_id)
        if enable_automatic_rotation is not None:
            pulumi.set(__self__, "enable_automatic_rotation", enable_automatic_rotation)
        if encryption_key_id is not None:
            pulumi.set(__self__, "encryption_key_id", encryption_key_id)
        if extended_config is not None:
            pulumi.set(__self__, "extended_config", extended_config)
        if force_delete_without_recovery is not None:
            pulumi.set(__self__, "force_delete_without_recovery", force_delete_without_recovery)
        if planned_delete_time is not None:
            pulumi.set(__self__, "planned_delete_time", planned_delete_time)
        if recovery_window_in_days is not None:
            pulumi.set(__self__, "recovery_window_in_days", recovery_window_in_days)
        if rotation_interval is not None:
            pulumi.set(__self__, "rotation_interval", rotation_interval)
        if secret_data is not None:
            pulumi.set(__self__, "secret_data", secret_data)
        if secret_data_type is not None:
            pulumi.set(__self__, "secret_data_type", secret_data_type)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if secret_type is not None:
            pulumi.set(__self__, "secret_type", secret_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)
        if version_stages is not None:
            pulumi.set(__self__, "version_stages", version_stages)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Alicloud Resource Name (ARN) of the secret.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the secret.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dkmsInstanceId")
    def dkms_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The instance ID of the exclusive KMS instance.
        """
        return pulumi.get(self, "dkms_instance_id")

    @dkms_instance_id.setter
    def dkms_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dkms_instance_id", value)

    @property
    @pulumi.getter(name="enableAutomaticRotation")
    def enable_automatic_rotation(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable automatic key rotation.
        """
        return pulumi.get(self, "enable_automatic_rotation")

    @enable_automatic_rotation.setter
    def enable_automatic_rotation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_automatic_rotation", value)

    @property
    @pulumi.getter(name="encryptionKeyId")
    def encryption_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the KMS CMK that is used to encrypt the secret value. If you do not specify this parameter, Secrets Manager automatically creates an encryption key to encrypt the secret.
        """
        return pulumi.get(self, "encryption_key_id")

    @encryption_key_id.setter
    def encryption_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_key_id", value)

    @property
    @pulumi.getter(name="extendedConfig")
    def extended_config(self) -> Optional[pulumi.Input[str]]:
        """
        The extended configuration of the secret. This parameter specifies the properties of the secret of the specific type. The description can be up to 1,024 characters in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        """
        return pulumi.get(self, "extended_config")

    @extended_config.setter
    def extended_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extended_config", value)

    @property
    @pulumi.getter(name="forceDeleteWithoutRecovery")
    def force_delete_without_recovery(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to forcibly delete the secret. If this parameter is set to true, the secret cannot be recovered. Valid values: true, false. Default to: false.
        """
        return pulumi.get(self, "force_delete_without_recovery")

    @force_delete_without_recovery.setter
    def force_delete_without_recovery(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete_without_recovery", value)

    @property
    @pulumi.getter(name="plannedDeleteTime")
    def planned_delete_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the secret is scheduled to be deleted.
        """
        return pulumi.get(self, "planned_delete_time")

    @planned_delete_time.setter
    def planned_delete_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "planned_delete_time", value)

    @property
    @pulumi.getter(name="recoveryWindowInDays")
    def recovery_window_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the recovery period of the secret if you do not forcibly delete it. Default value: 30. It will be ignored when `force_delete_without_recovery` is true.
        """
        return pulumi.get(self, "recovery_window_in_days")

    @recovery_window_in_days.setter
    def recovery_window_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_window_in_days", value)

    @property
    @pulumi.getter(name="rotationInterval")
    def rotation_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The time period of automatic rotation. The format is integer[unit], where integer represents the length of time, and unit represents the unit of time. The legal unit units are: d (day), h (hour), m (minute), s (second). 7d or 604800s both indicate a 7-day cycle.
        """
        return pulumi.get(self, "rotation_interval")

    @rotation_interval.setter
    def rotation_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rotation_interval", value)

    @property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the secret that you want to create. Secrets Manager encrypts the secret value and stores it in the initial version. **NOTE:** From version 1.204.1, attribute `secret_data` updating diff will be ignored when `secret_type` is not Generic.
        """
        return pulumi.get(self, "secret_data")

    @secret_data.setter
    def secret_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_data", value)

    @property
    @pulumi.getter(name="secretDataType")
    def secret_data_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the secret value. Valid values: text, binary. Default to "text".
        """
        return pulumi.get(self, "secret_data_type")

    @secret_data_type.setter
    def secret_data_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_data_type", value)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the secret.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_name", value)

    @property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the secret. Valid values:
        """
        return pulumi.get(self, "secret_type")

    @secret_type.setter
    def secret_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The version number of the initial version. Version numbers are unique in each secret object.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_id", value)

    @property
    @pulumi.getter(name="versionStages")
    def version_stages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        ) The stage labels that mark the new secret version. If you do not specify this parameter, Secrets Manager marks it with "ACSCurrent".
        """
        return pulumi.get(self, "version_stages")

    @version_stages.setter
    def version_stages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "version_stages", value)


class Secret(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dkms_instance_id: Optional[pulumi.Input[str]] = None,
                 enable_automatic_rotation: Optional[pulumi.Input[bool]] = None,
                 encryption_key_id: Optional[pulumi.Input[str]] = None,
                 extended_config: Optional[pulumi.Input[str]] = None,
                 force_delete_without_recovery: Optional[pulumi.Input[bool]] = None,
                 recovery_window_in_days: Optional[pulumi.Input[int]] = None,
                 rotation_interval: Optional[pulumi.Input[str]] = None,
                 secret_data: Optional[pulumi.Input[str]] = None,
                 secret_data_type: Optional[pulumi.Input[str]] = None,
                 secret_name: Optional[pulumi.Input[str]] = None,
                 secret_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 version_id: Optional[pulumi.Input[str]] = None,
                 version_stages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        This resouce used to create a secret and store its initial version.

        > **NOTE:** Available in 1.76.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.kms.Secret("default",
            description="from terraform",
            force_delete_without_recovery=True,
            secret_data="Secret data.",
            secret_name="secret-foo",
            version_id="000000000001")
        ```

        ## Import

        KMS secret can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:kms/secret:Secret default <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the secret.
        :param pulumi.Input[str] dkms_instance_id: The instance ID of the exclusive KMS instance.
        :param pulumi.Input[bool] enable_automatic_rotation: Whether to enable automatic key rotation.
        :param pulumi.Input[str] encryption_key_id: The ID of the KMS CMK that is used to encrypt the secret value. If you do not specify this parameter, Secrets Manager automatically creates an encryption key to encrypt the secret.
        :param pulumi.Input[str] extended_config: The extended configuration of the secret. This parameter specifies the properties of the secret of the specific type. The description can be up to 1,024 characters in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        :param pulumi.Input[bool] force_delete_without_recovery: Specifies whether to forcibly delete the secret. If this parameter is set to true, the secret cannot be recovered. Valid values: true, false. Default to: false.
        :param pulumi.Input[int] recovery_window_in_days: Specifies the recovery period of the secret if you do not forcibly delete it. Default value: 30. It will be ignored when `force_delete_without_recovery` is true.
        :param pulumi.Input[str] rotation_interval: The time period of automatic rotation. The format is integer[unit], where integer represents the length of time, and unit represents the unit of time. The legal unit units are: d (day), h (hour), m (minute), s (second). 7d or 604800s both indicate a 7-day cycle.
        :param pulumi.Input[str] secret_data: The value of the secret that you want to create. Secrets Manager encrypts the secret value and stores it in the initial version. **NOTE:** From version 1.204.1, attribute `secret_data` updating diff will be ignored when `secret_type` is not Generic.
        :param pulumi.Input[str] secret_data_type: The type of the secret value. Valid values: text, binary. Default to "text".
        :param pulumi.Input[str] secret_name: The name of the secret.
        :param pulumi.Input[str] secret_type: The type of the secret. Valid values:
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] version_id: The version number of the initial version. Version numbers are unique in each secret object.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] version_stages: ) The stage labels that mark the new secret version. If you do not specify this parameter, Secrets Manager marks it with "ACSCurrent".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resouce used to create a secret and store its initial version.

        > **NOTE:** Available in 1.76.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.kms.Secret("default",
            description="from terraform",
            force_delete_without_recovery=True,
            secret_data="Secret data.",
            secret_name="secret-foo",
            version_id="000000000001")
        ```

        ## Import

        KMS secret can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:kms/secret:Secret default <id>
        ```

        :param str resource_name: The name of the resource.
        :param SecretArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dkms_instance_id: Optional[pulumi.Input[str]] = None,
                 enable_automatic_rotation: Optional[pulumi.Input[bool]] = None,
                 encryption_key_id: Optional[pulumi.Input[str]] = None,
                 extended_config: Optional[pulumi.Input[str]] = None,
                 force_delete_without_recovery: Optional[pulumi.Input[bool]] = None,
                 recovery_window_in_days: Optional[pulumi.Input[int]] = None,
                 rotation_interval: Optional[pulumi.Input[str]] = None,
                 secret_data: Optional[pulumi.Input[str]] = None,
                 secret_data_type: Optional[pulumi.Input[str]] = None,
                 secret_name: Optional[pulumi.Input[str]] = None,
                 secret_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 version_id: Optional[pulumi.Input[str]] = None,
                 version_stages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretArgs.__new__(SecretArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["dkms_instance_id"] = dkms_instance_id
            __props__.__dict__["enable_automatic_rotation"] = enable_automatic_rotation
            __props__.__dict__["encryption_key_id"] = encryption_key_id
            __props__.__dict__["extended_config"] = extended_config
            __props__.__dict__["force_delete_without_recovery"] = force_delete_without_recovery
            __props__.__dict__["recovery_window_in_days"] = recovery_window_in_days
            __props__.__dict__["rotation_interval"] = rotation_interval
            if secret_data is None and not opts.urn:
                raise TypeError("Missing required property 'secret_data'")
            __props__.__dict__["secret_data"] = None if secret_data is None else pulumi.Output.secret(secret_data)
            __props__.__dict__["secret_data_type"] = secret_data_type
            if secret_name is None and not opts.urn:
                raise TypeError("Missing required property 'secret_name'")
            __props__.__dict__["secret_name"] = secret_name
            __props__.__dict__["secret_type"] = secret_type
            __props__.__dict__["tags"] = tags
            if version_id is None and not opts.urn:
                raise TypeError("Missing required property 'version_id'")
            __props__.__dict__["version_id"] = version_id
            __props__.__dict__["version_stages"] = version_stages
            __props__.__dict__["arn"] = None
            __props__.__dict__["planned_delete_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secretData"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Secret, __self__).__init__(
            'alicloud:kms/secret:Secret',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dkms_instance_id: Optional[pulumi.Input[str]] = None,
            enable_automatic_rotation: Optional[pulumi.Input[bool]] = None,
            encryption_key_id: Optional[pulumi.Input[str]] = None,
            extended_config: Optional[pulumi.Input[str]] = None,
            force_delete_without_recovery: Optional[pulumi.Input[bool]] = None,
            planned_delete_time: Optional[pulumi.Input[str]] = None,
            recovery_window_in_days: Optional[pulumi.Input[int]] = None,
            rotation_interval: Optional[pulumi.Input[str]] = None,
            secret_data: Optional[pulumi.Input[str]] = None,
            secret_data_type: Optional[pulumi.Input[str]] = None,
            secret_name: Optional[pulumi.Input[str]] = None,
            secret_type: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            version_id: Optional[pulumi.Input[str]] = None,
            version_stages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Secret':
        """
        Get an existing Secret resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The Alicloud Resource Name (ARN) of the secret.
        :param pulumi.Input[str] description: The description of the secret.
        :param pulumi.Input[str] dkms_instance_id: The instance ID of the exclusive KMS instance.
        :param pulumi.Input[bool] enable_automatic_rotation: Whether to enable automatic key rotation.
        :param pulumi.Input[str] encryption_key_id: The ID of the KMS CMK that is used to encrypt the secret value. If you do not specify this parameter, Secrets Manager automatically creates an encryption key to encrypt the secret.
        :param pulumi.Input[str] extended_config: The extended configuration of the secret. This parameter specifies the properties of the secret of the specific type. The description can be up to 1,024 characters in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        :param pulumi.Input[bool] force_delete_without_recovery: Specifies whether to forcibly delete the secret. If this parameter is set to true, the secret cannot be recovered. Valid values: true, false. Default to: false.
        :param pulumi.Input[str] planned_delete_time: The time when the secret is scheduled to be deleted.
        :param pulumi.Input[int] recovery_window_in_days: Specifies the recovery period of the secret if you do not forcibly delete it. Default value: 30. It will be ignored when `force_delete_without_recovery` is true.
        :param pulumi.Input[str] rotation_interval: The time period of automatic rotation. The format is integer[unit], where integer represents the length of time, and unit represents the unit of time. The legal unit units are: d (day), h (hour), m (minute), s (second). 7d or 604800s both indicate a 7-day cycle.
        :param pulumi.Input[str] secret_data: The value of the secret that you want to create. Secrets Manager encrypts the secret value and stores it in the initial version. **NOTE:** From version 1.204.1, attribute `secret_data` updating diff will be ignored when `secret_type` is not Generic.
        :param pulumi.Input[str] secret_data_type: The type of the secret value. Valid values: text, binary. Default to "text".
        :param pulumi.Input[str] secret_name: The name of the secret.
        :param pulumi.Input[str] secret_type: The type of the secret. Valid values:
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] version_id: The version number of the initial version. Version numbers are unique in each secret object.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] version_stages: ) The stage labels that mark the new secret version. If you do not specify this parameter, Secrets Manager marks it with "ACSCurrent".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretState.__new__(_SecretState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["description"] = description
        __props__.__dict__["dkms_instance_id"] = dkms_instance_id
        __props__.__dict__["enable_automatic_rotation"] = enable_automatic_rotation
        __props__.__dict__["encryption_key_id"] = encryption_key_id
        __props__.__dict__["extended_config"] = extended_config
        __props__.__dict__["force_delete_without_recovery"] = force_delete_without_recovery
        __props__.__dict__["planned_delete_time"] = planned_delete_time
        __props__.__dict__["recovery_window_in_days"] = recovery_window_in_days
        __props__.__dict__["rotation_interval"] = rotation_interval
        __props__.__dict__["secret_data"] = secret_data
        __props__.__dict__["secret_data_type"] = secret_data_type
        __props__.__dict__["secret_name"] = secret_name
        __props__.__dict__["secret_type"] = secret_type
        __props__.__dict__["tags"] = tags
        __props__.__dict__["version_id"] = version_id
        __props__.__dict__["version_stages"] = version_stages
        return Secret(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Alicloud Resource Name (ARN) of the secret.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the secret.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dkmsInstanceId")
    def dkms_instance_id(self) -> pulumi.Output[Optional[str]]:
        """
        The instance ID of the exclusive KMS instance.
        """
        return pulumi.get(self, "dkms_instance_id")

    @property
    @pulumi.getter(name="enableAutomaticRotation")
    def enable_automatic_rotation(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable automatic key rotation.
        """
        return pulumi.get(self, "enable_automatic_rotation")

    @property
    @pulumi.getter(name="encryptionKeyId")
    def encryption_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the KMS CMK that is used to encrypt the secret value. If you do not specify this parameter, Secrets Manager automatically creates an encryption key to encrypt the secret.
        """
        return pulumi.get(self, "encryption_key_id")

    @property
    @pulumi.getter(name="extendedConfig")
    def extended_config(self) -> pulumi.Output[Optional[str]]:
        """
        The extended configuration of the secret. This parameter specifies the properties of the secret of the specific type. The description can be up to 1,024 characters in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
        """
        return pulumi.get(self, "extended_config")

    @property
    @pulumi.getter(name="forceDeleteWithoutRecovery")
    def force_delete_without_recovery(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to forcibly delete the secret. If this parameter is set to true, the secret cannot be recovered. Valid values: true, false. Default to: false.
        """
        return pulumi.get(self, "force_delete_without_recovery")

    @property
    @pulumi.getter(name="plannedDeleteTime")
    def planned_delete_time(self) -> pulumi.Output[str]:
        """
        The time when the secret is scheduled to be deleted.
        """
        return pulumi.get(self, "planned_delete_time")

    @property
    @pulumi.getter(name="recoveryWindowInDays")
    def recovery_window_in_days(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the recovery period of the secret if you do not forcibly delete it. Default value: 30. It will be ignored when `force_delete_without_recovery` is true.
        """
        return pulumi.get(self, "recovery_window_in_days")

    @property
    @pulumi.getter(name="rotationInterval")
    def rotation_interval(self) -> pulumi.Output[Optional[str]]:
        """
        The time period of automatic rotation. The format is integer[unit], where integer represents the length of time, and unit represents the unit of time. The legal unit units are: d (day), h (hour), m (minute), s (second). 7d or 604800s both indicate a 7-day cycle.
        """
        return pulumi.get(self, "rotation_interval")

    @property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> pulumi.Output[str]:
        """
        The value of the secret that you want to create. Secrets Manager encrypts the secret value and stores it in the initial version. **NOTE:** From version 1.204.1, attribute `secret_data` updating diff will be ignored when `secret_type` is not Generic.
        """
        return pulumi.get(self, "secret_data")

    @property
    @pulumi.getter(name="secretDataType")
    def secret_data_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of the secret value. Valid values: text, binary. Default to "text".
        """
        return pulumi.get(self, "secret_data_type")

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Output[str]:
        """
        The name of the secret.
        """
        return pulumi.get(self, "secret_name")

    @property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> pulumi.Output[str]:
        """
        The type of the secret. Valid values:
        """
        return pulumi.get(self, "secret_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[str]:
        """
        The version number of the initial version. Version numbers are unique in each secret object.
        """
        return pulumi.get(self, "version_id")

    @property
    @pulumi.getter(name="versionStages")
    def version_stages(self) -> pulumi.Output[Sequence[str]]:
        """
        ) The stage labels that mark the new secret version. If you do not specify this parameter, Secrets Manager marks it with "ACSCurrent".
        """
        return pulumi.get(self, "version_stages")

