# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 disk_category: pulumi.Input[str],
                 payment_type: pulumi.Input[str],
                 vswitch_id: pulumi.Input[str],
                 arbiter_vswitch_id: Optional[pulumi.Input[str]] = None,
                 arbiter_zone_id: Optional[pulumi.Input[str]] = None,
                 arch_version: Optional[pulumi.Input[str]] = None,
                 cold_storage: Optional[pulumi.Input[int]] = None,
                 core_single_storage: Optional[pulumi.Input[int]] = None,
                 core_spec: Optional[pulumi.Input[str]] = None,
                 deletion_proection: Optional[pulumi.Input[bool]] = None,
                 duration: Optional[pulumi.Input[str]] = None,
                 file_engine_node_count: Optional[pulumi.Input[int]] = None,
                 file_engine_specification: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_storage: Optional[pulumi.Input[str]] = None,
                 ip_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_disk_category: Optional[pulumi.Input[str]] = None,
                 log_num: Optional[pulumi.Input[int]] = None,
                 log_single_storage: Optional[pulumi.Input[int]] = None,
                 log_spec: Optional[pulumi.Input[str]] = None,
                 lts_node_count: Optional[pulumi.Input[int]] = None,
                 lts_node_specification: Optional[pulumi.Input[str]] = None,
                 multi_zone_combination: Optional[pulumi.Input[str]] = None,
                 pricing_cycle: Optional[pulumi.Input[str]] = None,
                 primary_vswitch_id: Optional[pulumi.Input[str]] = None,
                 primary_zone_id: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 search_engine_node_count: Optional[pulumi.Input[int]] = None,
                 search_engine_specification: Optional[pulumi.Input[str]] = None,
                 standby_vswitch_id: Optional[pulumi.Input[str]] = None,
                 standby_zone_id: Optional[pulumi.Input[str]] = None,
                 stream_engine_node_count: Optional[pulumi.Input[int]] = None,
                 stream_engine_specification: Optional[pulumi.Input[str]] = None,
                 table_engine_node_count: Optional[pulumi.Input[int]] = None,
                 table_engine_specification: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_series_engine_node_count: Optional[pulumi.Input[int]] = None,
                 time_series_engine_specification: Optional[pulumi.Input[str]] = None,
                 time_serires_engine_specification: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[str] disk_category: The disk type of instance. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_essd_pl0`, `capacity_cloud_storage`, `local_ssd_pro`, `local_hdd_pro`. **NOTE:** From version 1.207.0, `disk_category` can be set to `cloud_essd_pl0`.
        :param pulumi.Input[str] payment_type: The billing method. Valid values: `PayAsYouGo` and `Subscription`.
        :param pulumi.Input[str] vswitch_id: The vswitch id.
        :param pulumi.Input[str] arbiter_vswitch_id: The multi-availability zone instance, coordinating the virtual switch ID of the availability zone, the switch must be located under the availability zone corresponding to the ArbiterZoneId. This parameter is required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] arbiter_zone_id: The multiple Availability Zone Instance, the availability zone ID of the coordinating availability zone. required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] arch_version: The deployment architecture. If you do not fill in this parameter, the default is 1.0. to create multiple availability instances, fill in 2.0. if you need to create multiple availability instances, this parameter is required. Valid values: `1.0` to `2.0`.
        :param pulumi.Input[int] cold_storage: The cold storage capacity of the instance. Unit: GB. Valid values: [800, 1000000].
        :param pulumi.Input[int] core_single_storage: The multiple availability zone instances, CORE single node capacity. required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
        :param pulumi.Input[str] core_spec: The core spec. When `disk_category` is `local_ssd_pro` or `local_hdd_pro`, this filed is valid.
               - When `disk_category` is `local_ssd_pro`, the valid values is `lindorm.i2.xlarge`, `lindorm.i2.2xlarge`, `lindorm.i2.4xlarge`, `lindorm.i2.8xlarge`.
               - When `disk_category` is `local_hdd_pro`, the valid values is `lindorm.d2c.6xlarge`, `lindorm.d2c.12xlarge`, `lindorm.d2c.24xlarge`, `lindorm.d2s.5xlarge`, `lindorm.d2s.10xlarge`, `lindorm.d1.2xlarge`, `lindorm.d1.4xlarge`, `lindorm.d1.6xlarge`.
        :param pulumi.Input[bool] deletion_proection: The deletion protection of instance.
        :param pulumi.Input[str] duration: The duration of paid. Valid when the `payment_type` is `Subscription`.  When `pricing_cycle` set to `Month`, the valid value id `1` to `9`.  When `pricing_cycle` set to `Year`, the valid value id `1` to `3`.
        :param pulumi.Input[int] file_engine_node_count: The count of file engine.
        :param pulumi.Input[str] file_engine_specification: The specification of file engine. Valid values: `lindorm.c.xlarge`.
        :param pulumi.Input[str] instance_name: The name of the instance.
        :param pulumi.Input[str] instance_storage: The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_white_lists: The ip white list of instance.
        :param pulumi.Input[str] log_disk_category: The multi-available zone instance, log node disk type. required if you need to create multiple availability zone instances. Valid values: `cloud_efficiency`, `cloud_ssd`.
        :param pulumi.Input[int] log_num: The multiple Availability Zone Instance, number of log nodes. this parameter is required if you want to create multiple availability zone instances. Valid values: `4` to `400`.
        :param pulumi.Input[int] log_single_storage: The multi-availability instance, log single-node disk capacity. This parameter is required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
        :param pulumi.Input[str] log_spec: The multiple availability zone instances, log node specification. required if you need to create multiple availability zone instances. Valid values: `lindorm.sn1.large`, `lindorm.sn1.2xlarge`.
        :param pulumi.Input[int] lts_node_count: The count of lindorm tunnel service.
        :param pulumi.Input[str] lts_node_specification: The specification of lindorm tunnel service. Valid values: `lindorm.g.2xlarge`, `lindorm.g.xlarge`.
        :param pulumi.Input[str] multi_zone_combination: The multi-zone combinations. Availability zone combinations are supported on the sale page. required if you need to create multiple availability zone instances. Valid values: `ap-southeast-5abc-aliyun`, `cn-hangzhou-ehi-aliyun`, `cn-beijing-acd-aliyun`, `ap-southeast-1-abc-aliyun`, `cn-zhangjiakou-abc-aliyun`, `cn-shanghai-efg-aliyun`, `cn-shanghai-abd-aliyun`, `cn-hangzhou-bef-aliyun`, `cn-hangzhou-bce-aliyun`, `cn-beijing-fgh-aliyun`, `cn-shenzhen-abc-aliyun`.
        :param pulumi.Input[str] pricing_cycle: The pricing cycle. Valid when the `payment_type` is `Subscription`. Valid values: `Month` and `Year`.
        :param pulumi.Input[str] primary_vswitch_id: Multi-available zone instances, the virtual switch ID of the primary available zone, must be under the available zone corresponding to the PrimaryZoneId. required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] primary_zone_id: Multi-availability zone instance with the availability zone ID of the main availability zone. required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[int] search_engine_node_count: The count of search engine.
        :param pulumi.Input[str] search_engine_specification: The specification of search engine. Valid values: `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.g.xlarge`.
        :param pulumi.Input[str] standby_vswitch_id: The multiple availability zone instances, the virtual switch ID of the ready availability zone must be under the availability zone corresponding to the StandbyZoneId. required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] standby_zone_id: The multiple availability zone instances with availability zone IDs for the prepared availability zones. required if you need to create multiple availability zone instances.
        :param pulumi.Input[int] stream_engine_node_count: The number of LindormStream nodes in the instance.
        :param pulumi.Input[str] stream_engine_specification: The specification of the LindormStream nodes in the instance. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
        :param pulumi.Input[int] table_engine_node_count: The count of table engine.
        :param pulumi.Input[str] table_engine_specification: The specification of  table engine. Valid values: `lindorm.c.2xlarge`, `lindorm.c.4xlarge`, `lindorm.c.8xlarge`, `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[int] time_series_engine_node_count: The count of time series engine.
        :param pulumi.Input[str] time_series_engine_specification: The specification of time series engine. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.r.8xlarge`.
        :param pulumi.Input[str] time_serires_engine_specification: Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New field `time_series_engine_specification` instead.
        :param pulumi.Input[str] vpc_id: The VPC ID of the instance.
        :param pulumi.Input[str] zone_id: The zone ID of the instance.
        """
        pulumi.set(__self__, "disk_category", disk_category)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if arbiter_vswitch_id is not None:
            pulumi.set(__self__, "arbiter_vswitch_id", arbiter_vswitch_id)
        if arbiter_zone_id is not None:
            pulumi.set(__self__, "arbiter_zone_id", arbiter_zone_id)
        if arch_version is not None:
            pulumi.set(__self__, "arch_version", arch_version)
        if cold_storage is not None:
            pulumi.set(__self__, "cold_storage", cold_storage)
        if core_single_storage is not None:
            pulumi.set(__self__, "core_single_storage", core_single_storage)
        if core_spec is not None:
            pulumi.set(__self__, "core_spec", core_spec)
        if deletion_proection is not None:
            pulumi.set(__self__, "deletion_proection", deletion_proection)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if file_engine_node_count is not None:
            pulumi.set(__self__, "file_engine_node_count", file_engine_node_count)
        if file_engine_specification is not None:
            pulumi.set(__self__, "file_engine_specification", file_engine_specification)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_storage is not None:
            pulumi.set(__self__, "instance_storage", instance_storage)
        if ip_white_lists is not None:
            pulumi.set(__self__, "ip_white_lists", ip_white_lists)
        if log_disk_category is not None:
            pulumi.set(__self__, "log_disk_category", log_disk_category)
        if log_num is not None:
            pulumi.set(__self__, "log_num", log_num)
        if log_single_storage is not None:
            pulumi.set(__self__, "log_single_storage", log_single_storage)
        if log_spec is not None:
            pulumi.set(__self__, "log_spec", log_spec)
        if lts_node_count is not None:
            pulumi.set(__self__, "lts_node_count", lts_node_count)
        if lts_node_specification is not None:
            pulumi.set(__self__, "lts_node_specification", lts_node_specification)
        if multi_zone_combination is not None:
            pulumi.set(__self__, "multi_zone_combination", multi_zone_combination)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if primary_vswitch_id is not None:
            pulumi.set(__self__, "primary_vswitch_id", primary_vswitch_id)
        if primary_zone_id is not None:
            pulumi.set(__self__, "primary_zone_id", primary_zone_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if search_engine_node_count is not None:
            pulumi.set(__self__, "search_engine_node_count", search_engine_node_count)
        if search_engine_specification is not None:
            pulumi.set(__self__, "search_engine_specification", search_engine_specification)
        if standby_vswitch_id is not None:
            pulumi.set(__self__, "standby_vswitch_id", standby_vswitch_id)
        if standby_zone_id is not None:
            pulumi.set(__self__, "standby_zone_id", standby_zone_id)
        if stream_engine_node_count is not None:
            pulumi.set(__self__, "stream_engine_node_count", stream_engine_node_count)
        if stream_engine_specification is not None:
            pulumi.set(__self__, "stream_engine_specification", stream_engine_specification)
        if table_engine_node_count is not None:
            pulumi.set(__self__, "table_engine_node_count", table_engine_node_count)
        if table_engine_specification is not None:
            pulumi.set(__self__, "table_engine_specification", table_engine_specification)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_series_engine_node_count is not None:
            pulumi.set(__self__, "time_series_engine_node_count", time_series_engine_node_count)
        if time_series_engine_specification is not None:
            pulumi.set(__self__, "time_series_engine_specification", time_series_engine_specification)
        if time_serires_engine_specification is not None:
            warnings.warn("""Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New field `time_series_engine_specification` instead.""", DeprecationWarning)
            pulumi.log.warn("""time_serires_engine_specification is deprecated: Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New field `time_series_engine_specification` instead.""")
        if time_serires_engine_specification is not None:
            pulumi.set(__self__, "time_serires_engine_specification", time_serires_engine_specification)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="diskCategory")
    def disk_category(self) -> pulumi.Input[str]:
        """
        The disk type of instance. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_essd_pl0`, `capacity_cloud_storage`, `local_ssd_pro`, `local_hdd_pro`. **NOTE:** From version 1.207.0, `disk_category` can be set to `cloud_essd_pl0`.
        """
        return pulumi.get(self, "disk_category")

    @disk_category.setter
    def disk_category(self, value: pulumi.Input[str]):
        pulumi.set(self, "disk_category", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[str]:
        """
        The billing method. Valid values: `PayAsYouGo` and `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[str]:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="arbiterVswitchId")
    def arbiter_vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The multi-availability zone instance, coordinating the virtual switch ID of the availability zone, the switch must be located under the availability zone corresponding to the ArbiterZoneId. This parameter is required if you need to create multiple availability zone instances.
        """
        return pulumi.get(self, "arbiter_vswitch_id")

    @arbiter_vswitch_id.setter
    def arbiter_vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arbiter_vswitch_id", value)

    @property
    @pulumi.getter(name="arbiterZoneId")
    def arbiter_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The multiple Availability Zone Instance, the availability zone ID of the coordinating availability zone. required if you need to create multiple availability zone instances.
        """
        return pulumi.get(self, "arbiter_zone_id")

    @arbiter_zone_id.setter
    def arbiter_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arbiter_zone_id", value)

    @property
    @pulumi.getter(name="archVersion")
    def arch_version(self) -> Optional[pulumi.Input[str]]:
        """
        The deployment architecture. If you do not fill in this parameter, the default is 1.0. to create multiple availability instances, fill in 2.0. if you need to create multiple availability instances, this parameter is required. Valid values: `1.0` to `2.0`.
        """
        return pulumi.get(self, "arch_version")

    @arch_version.setter
    def arch_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arch_version", value)

    @property
    @pulumi.getter(name="coldStorage")
    def cold_storage(self) -> Optional[pulumi.Input[int]]:
        """
        The cold storage capacity of the instance. Unit: GB. Valid values: [800, 1000000].
        """
        return pulumi.get(self, "cold_storage")

    @cold_storage.setter
    def cold_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cold_storage", value)

    @property
    @pulumi.getter(name="coreSingleStorage")
    def core_single_storage(self) -> Optional[pulumi.Input[int]]:
        """
        The multiple availability zone instances, CORE single node capacity. required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
        """
        return pulumi.get(self, "core_single_storage")

    @core_single_storage.setter
    def core_single_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "core_single_storage", value)

    @property
    @pulumi.getter(name="coreSpec")
    def core_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The core spec. When `disk_category` is `local_ssd_pro` or `local_hdd_pro`, this filed is valid.
        - When `disk_category` is `local_ssd_pro`, the valid values is `lindorm.i2.xlarge`, `lindorm.i2.2xlarge`, `lindorm.i2.4xlarge`, `lindorm.i2.8xlarge`.
        - When `disk_category` is `local_hdd_pro`, the valid values is `lindorm.d2c.6xlarge`, `lindorm.d2c.12xlarge`, `lindorm.d2c.24xlarge`, `lindorm.d2s.5xlarge`, `lindorm.d2s.10xlarge`, `lindorm.d1.2xlarge`, `lindorm.d1.4xlarge`, `lindorm.d1.6xlarge`.
        """
        return pulumi.get(self, "core_spec")

    @core_spec.setter
    def core_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "core_spec", value)

    @property
    @pulumi.getter(name="deletionProection")
    def deletion_proection(self) -> Optional[pulumi.Input[bool]]:
        """
        The deletion protection of instance.
        """
        return pulumi.get(self, "deletion_proection")

    @deletion_proection.setter
    def deletion_proection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_proection", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[str]]:
        """
        The duration of paid. Valid when the `payment_type` is `Subscription`.  When `pricing_cycle` set to `Month`, the valid value id `1` to `9`.  When `pricing_cycle` set to `Year`, the valid value id `1` to `3`.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="fileEngineNodeCount")
    def file_engine_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The count of file engine.
        """
        return pulumi.get(self, "file_engine_node_count")

    @file_engine_node_count.setter
    def file_engine_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "file_engine_node_count", value)

    @property
    @pulumi.getter(name="fileEngineSpecification")
    def file_engine_specification(self) -> Optional[pulumi.Input[str]]:
        """
        The specification of file engine. Valid values: `lindorm.c.xlarge`.
        """
        return pulumi.get(self, "file_engine_specification")

    @file_engine_specification.setter
    def file_engine_specification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_engine_specification", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceStorage")
    def instance_storage(self) -> Optional[pulumi.Input[str]]:
        """
        The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB.
        """
        return pulumi.get(self, "instance_storage")

    @instance_storage.setter
    def instance_storage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_storage", value)

    @property
    @pulumi.getter(name="ipWhiteLists")
    def ip_white_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ip white list of instance.
        """
        return pulumi.get(self, "ip_white_lists")

    @ip_white_lists.setter
    def ip_white_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_white_lists", value)

    @property
    @pulumi.getter(name="logDiskCategory")
    def log_disk_category(self) -> Optional[pulumi.Input[str]]:
        """
        The multi-available zone instance, log node disk type. required if you need to create multiple availability zone instances. Valid values: `cloud_efficiency`, `cloud_ssd`.
        """
        return pulumi.get(self, "log_disk_category")

    @log_disk_category.setter
    def log_disk_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_disk_category", value)

    @property
    @pulumi.getter(name="logNum")
    def log_num(self) -> Optional[pulumi.Input[int]]:
        """
        The multiple Availability Zone Instance, number of log nodes. this parameter is required if you want to create multiple availability zone instances. Valid values: `4` to `400`.
        """
        return pulumi.get(self, "log_num")

    @log_num.setter
    def log_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "log_num", value)

    @property
    @pulumi.getter(name="logSingleStorage")
    def log_single_storage(self) -> Optional[pulumi.Input[int]]:
        """
        The multi-availability instance, log single-node disk capacity. This parameter is required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
        """
        return pulumi.get(self, "log_single_storage")

    @log_single_storage.setter
    def log_single_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "log_single_storage", value)

    @property
    @pulumi.getter(name="logSpec")
    def log_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The multiple availability zone instances, log node specification. required if you need to create multiple availability zone instances. Valid values: `lindorm.sn1.large`, `lindorm.sn1.2xlarge`.
        """
        return pulumi.get(self, "log_spec")

    @log_spec.setter
    def log_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_spec", value)

    @property
    @pulumi.getter(name="ltsNodeCount")
    def lts_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The count of lindorm tunnel service.
        """
        return pulumi.get(self, "lts_node_count")

    @lts_node_count.setter
    def lts_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lts_node_count", value)

    @property
    @pulumi.getter(name="ltsNodeSpecification")
    def lts_node_specification(self) -> Optional[pulumi.Input[str]]:
        """
        The specification of lindorm tunnel service. Valid values: `lindorm.g.2xlarge`, `lindorm.g.xlarge`.
        """
        return pulumi.get(self, "lts_node_specification")

    @lts_node_specification.setter
    def lts_node_specification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lts_node_specification", value)

    @property
    @pulumi.getter(name="multiZoneCombination")
    def multi_zone_combination(self) -> Optional[pulumi.Input[str]]:
        """
        The multi-zone combinations. Availability zone combinations are supported on the sale page. required if you need to create multiple availability zone instances. Valid values: `ap-southeast-5abc-aliyun`, `cn-hangzhou-ehi-aliyun`, `cn-beijing-acd-aliyun`, `ap-southeast-1-abc-aliyun`, `cn-zhangjiakou-abc-aliyun`, `cn-shanghai-efg-aliyun`, `cn-shanghai-abd-aliyun`, `cn-hangzhou-bef-aliyun`, `cn-hangzhou-bce-aliyun`, `cn-beijing-fgh-aliyun`, `cn-shenzhen-abc-aliyun`.
        """
        return pulumi.get(self, "multi_zone_combination")

    @multi_zone_combination.setter
    def multi_zone_combination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multi_zone_combination", value)

    @property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[str]]:
        """
        The pricing cycle. Valid when the `payment_type` is `Subscription`. Valid values: `Month` and `Year`.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pricing_cycle", value)

    @property
    @pulumi.getter(name="primaryVswitchId")
    def primary_vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        Multi-available zone instances, the virtual switch ID of the primary available zone, must be under the available zone corresponding to the PrimaryZoneId. required if you need to create multiple availability zone instances.
        """
        return pulumi.get(self, "primary_vswitch_id")

    @primary_vswitch_id.setter
    def primary_vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_vswitch_id", value)

    @property
    @pulumi.getter(name="primaryZoneId")
    def primary_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        Multi-availability zone instance with the availability zone ID of the main availability zone. required if you need to create multiple availability zone instances.
        """
        return pulumi.get(self, "primary_zone_id")

    @primary_zone_id.setter
    def primary_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_zone_id", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="searchEngineNodeCount")
    def search_engine_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The count of search engine.
        """
        return pulumi.get(self, "search_engine_node_count")

    @search_engine_node_count.setter
    def search_engine_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "search_engine_node_count", value)

    @property
    @pulumi.getter(name="searchEngineSpecification")
    def search_engine_specification(self) -> Optional[pulumi.Input[str]]:
        """
        The specification of search engine. Valid values: `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.g.xlarge`.
        """
        return pulumi.get(self, "search_engine_specification")

    @search_engine_specification.setter
    def search_engine_specification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_engine_specification", value)

    @property
    @pulumi.getter(name="standbyVswitchId")
    def standby_vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The multiple availability zone instances, the virtual switch ID of the ready availability zone must be under the availability zone corresponding to the StandbyZoneId. required if you need to create multiple availability zone instances.
        """
        return pulumi.get(self, "standby_vswitch_id")

    @standby_vswitch_id.setter
    def standby_vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "standby_vswitch_id", value)

    @property
    @pulumi.getter(name="standbyZoneId")
    def standby_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The multiple availability zone instances with availability zone IDs for the prepared availability zones. required if you need to create multiple availability zone instances.
        """
        return pulumi.get(self, "standby_zone_id")

    @standby_zone_id.setter
    def standby_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "standby_zone_id", value)

    @property
    @pulumi.getter(name="streamEngineNodeCount")
    def stream_engine_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of LindormStream nodes in the instance.
        """
        return pulumi.get(self, "stream_engine_node_count")

    @stream_engine_node_count.setter
    def stream_engine_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stream_engine_node_count", value)

    @property
    @pulumi.getter(name="streamEngineSpecification")
    def stream_engine_specification(self) -> Optional[pulumi.Input[str]]:
        """
        The specification of the LindormStream nodes in the instance. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
        """
        return pulumi.get(self, "stream_engine_specification")

    @stream_engine_specification.setter
    def stream_engine_specification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_engine_specification", value)

    @property
    @pulumi.getter(name="tableEngineNodeCount")
    def table_engine_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The count of table engine.
        """
        return pulumi.get(self, "table_engine_node_count")

    @table_engine_node_count.setter
    def table_engine_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "table_engine_node_count", value)

    @property
    @pulumi.getter(name="tableEngineSpecification")
    def table_engine_specification(self) -> Optional[pulumi.Input[str]]:
        """
        The specification of  table engine. Valid values: `lindorm.c.2xlarge`, `lindorm.c.4xlarge`, `lindorm.c.8xlarge`, `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
        """
        return pulumi.get(self, "table_engine_specification")

    @table_engine_specification.setter
    def table_engine_specification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_engine_specification", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="timeSeriesEngineNodeCount")
    def time_series_engine_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The count of time series engine.
        """
        return pulumi.get(self, "time_series_engine_node_count")

    @time_series_engine_node_count.setter
    def time_series_engine_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "time_series_engine_node_count", value)

    @property
    @pulumi.getter(name="timeSeriesEngineSpecification")
    def time_series_engine_specification(self) -> Optional[pulumi.Input[str]]:
        """
        The specification of time series engine. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.r.8xlarge`.
        """
        return pulumi.get(self, "time_series_engine_specification")

    @time_series_engine_specification.setter
    def time_series_engine_specification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_series_engine_specification", value)

    @property
    @pulumi.getter(name="timeSeriresEngineSpecification")
    def time_serires_engine_specification(self) -> Optional[pulumi.Input[str]]:
        """
        Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New field `time_series_engine_specification` instead.
        """
        warnings.warn("""Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New field `time_series_engine_specification` instead.""", DeprecationWarning)
        pulumi.log.warn("""time_serires_engine_specification is deprecated: Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New field `time_series_engine_specification` instead.""")

        return pulumi.get(self, "time_serires_engine_specification")

    @time_serires_engine_specification.setter
    def time_serires_engine_specification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_serires_engine_specification", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC ID of the instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 arbiter_vswitch_id: Optional[pulumi.Input[str]] = None,
                 arbiter_zone_id: Optional[pulumi.Input[str]] = None,
                 arch_version: Optional[pulumi.Input[str]] = None,
                 cold_storage: Optional[pulumi.Input[int]] = None,
                 core_single_storage: Optional[pulumi.Input[int]] = None,
                 core_spec: Optional[pulumi.Input[str]] = None,
                 deletion_proection: Optional[pulumi.Input[bool]] = None,
                 disk_category: Optional[pulumi.Input[str]] = None,
                 duration: Optional[pulumi.Input[str]] = None,
                 enabled_file_engine: Optional[pulumi.Input[bool]] = None,
                 enabled_lts_engine: Optional[pulumi.Input[bool]] = None,
                 enabled_search_engine: Optional[pulumi.Input[bool]] = None,
                 enabled_stream_engine: Optional[pulumi.Input[bool]] = None,
                 enabled_table_engine: Optional[pulumi.Input[bool]] = None,
                 enabled_time_serires_engine: Optional[pulumi.Input[bool]] = None,
                 file_engine_node_count: Optional[pulumi.Input[int]] = None,
                 file_engine_specification: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_storage: Optional[pulumi.Input[str]] = None,
                 ip_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_disk_category: Optional[pulumi.Input[str]] = None,
                 log_num: Optional[pulumi.Input[int]] = None,
                 log_single_storage: Optional[pulumi.Input[int]] = None,
                 log_spec: Optional[pulumi.Input[str]] = None,
                 lts_node_count: Optional[pulumi.Input[int]] = None,
                 lts_node_specification: Optional[pulumi.Input[str]] = None,
                 multi_zone_combination: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 pricing_cycle: Optional[pulumi.Input[str]] = None,
                 primary_vswitch_id: Optional[pulumi.Input[str]] = None,
                 primary_zone_id: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 search_engine_node_count: Optional[pulumi.Input[int]] = None,
                 search_engine_specification: Optional[pulumi.Input[str]] = None,
                 service_type: Optional[pulumi.Input[str]] = None,
                 standby_vswitch_id: Optional[pulumi.Input[str]] = None,
                 standby_zone_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 stream_engine_node_count: Optional[pulumi.Input[int]] = None,
                 stream_engine_specification: Optional[pulumi.Input[str]] = None,
                 table_engine_node_count: Optional[pulumi.Input[int]] = None,
                 table_engine_specification: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_series_engine_node_count: Optional[pulumi.Input[int]] = None,
                 time_series_engine_specification: Optional[pulumi.Input[str]] = None,
                 time_serires_engine_specification: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[str] arbiter_vswitch_id: The multi-availability zone instance, coordinating the virtual switch ID of the availability zone, the switch must be located under the availability zone corresponding to the ArbiterZoneId. This parameter is required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] arbiter_zone_id: The multiple Availability Zone Instance, the availability zone ID of the coordinating availability zone. required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] arch_version: The deployment architecture. If you do not fill in this parameter, the default is 1.0. to create multiple availability instances, fill in 2.0. if you need to create multiple availability instances, this parameter is required. Valid values: `1.0` to `2.0`.
        :param pulumi.Input[int] cold_storage: The cold storage capacity of the instance. Unit: GB. Valid values: [800, 1000000].
        :param pulumi.Input[int] core_single_storage: The multiple availability zone instances, CORE single node capacity. required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
        :param pulumi.Input[str] core_spec: The core spec. When `disk_category` is `local_ssd_pro` or `local_hdd_pro`, this filed is valid.
               - When `disk_category` is `local_ssd_pro`, the valid values is `lindorm.i2.xlarge`, `lindorm.i2.2xlarge`, `lindorm.i2.4xlarge`, `lindorm.i2.8xlarge`.
               - When `disk_category` is `local_hdd_pro`, the valid values is `lindorm.d2c.6xlarge`, `lindorm.d2c.12xlarge`, `lindorm.d2c.24xlarge`, `lindorm.d2s.5xlarge`, `lindorm.d2s.10xlarge`, `lindorm.d1.2xlarge`, `lindorm.d1.4xlarge`, `lindorm.d1.6xlarge`.
        :param pulumi.Input[bool] deletion_proection: The deletion protection of instance.
        :param pulumi.Input[str] disk_category: The disk type of instance. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_essd_pl0`, `capacity_cloud_storage`, `local_ssd_pro`, `local_hdd_pro`. **NOTE:** From version 1.207.0, `disk_category` can be set to `cloud_essd_pl0`.
        :param pulumi.Input[str] duration: The duration of paid. Valid when the `payment_type` is `Subscription`.  When `pricing_cycle` set to `Month`, the valid value id `1` to `9`.  When `pricing_cycle` set to `Year`, the valid value id `1` to `3`.
        :param pulumi.Input[bool] enabled_file_engine: (Available since v1.163.0) Whether to enable file engine.
        :param pulumi.Input[bool] enabled_lts_engine: (Available since v1.163.0) Whether to enable lts engine.
        :param pulumi.Input[bool] enabled_search_engine: (Available since v1.163.0) Whether to enable search engine.
        :param pulumi.Input[bool] enabled_stream_engine: (Available since v1.211.0) Whether to enable streaming engine.
        :param pulumi.Input[bool] enabled_table_engine: (Available since v1.163.0) Whether to enable table engine.
        :param pulumi.Input[bool] enabled_time_serires_engine: (Available since v1.163.0) Whether to enable time serires engine.
        :param pulumi.Input[int] file_engine_node_count: The count of file engine.
        :param pulumi.Input[str] file_engine_specification: The specification of file engine. Valid values: `lindorm.c.xlarge`.
        :param pulumi.Input[str] instance_name: The name of the instance.
        :param pulumi.Input[str] instance_storage: The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_white_lists: The ip white list of instance.
        :param pulumi.Input[str] log_disk_category: The multi-available zone instance, log node disk type. required if you need to create multiple availability zone instances. Valid values: `cloud_efficiency`, `cloud_ssd`.
        :param pulumi.Input[int] log_num: The multiple Availability Zone Instance, number of log nodes. this parameter is required if you want to create multiple availability zone instances. Valid values: `4` to `400`.
        :param pulumi.Input[int] log_single_storage: The multi-availability instance, log single-node disk capacity. This parameter is required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
        :param pulumi.Input[str] log_spec: The multiple availability zone instances, log node specification. required if you need to create multiple availability zone instances. Valid values: `lindorm.sn1.large`, `lindorm.sn1.2xlarge`.
        :param pulumi.Input[int] lts_node_count: The count of lindorm tunnel service.
        :param pulumi.Input[str] lts_node_specification: The specification of lindorm tunnel service. Valid values: `lindorm.g.2xlarge`, `lindorm.g.xlarge`.
        :param pulumi.Input[str] multi_zone_combination: The multi-zone combinations. Availability zone combinations are supported on the sale page. required if you need to create multiple availability zone instances. Valid values: `ap-southeast-5abc-aliyun`, `cn-hangzhou-ehi-aliyun`, `cn-beijing-acd-aliyun`, `ap-southeast-1-abc-aliyun`, `cn-zhangjiakou-abc-aliyun`, `cn-shanghai-efg-aliyun`, `cn-shanghai-abd-aliyun`, `cn-hangzhou-bef-aliyun`, `cn-hangzhou-bce-aliyun`, `cn-beijing-fgh-aliyun`, `cn-shenzhen-abc-aliyun`.
        :param pulumi.Input[str] payment_type: The billing method. Valid values: `PayAsYouGo` and `Subscription`.
        :param pulumi.Input[str] pricing_cycle: The pricing cycle. Valid when the `payment_type` is `Subscription`. Valid values: `Month` and `Year`.
        :param pulumi.Input[str] primary_vswitch_id: Multi-available zone instances, the virtual switch ID of the primary available zone, must be under the available zone corresponding to the PrimaryZoneId. required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] primary_zone_id: Multi-availability zone instance with the availability zone ID of the main availability zone. required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[int] search_engine_node_count: The count of search engine.
        :param pulumi.Input[str] search_engine_specification: The specification of search engine. Valid values: `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.g.xlarge`.
        :param pulumi.Input[str] service_type: (Available since v1.196.0) The instance type.
        :param pulumi.Input[str] standby_vswitch_id: The multiple availability zone instances, the virtual switch ID of the ready availability zone must be under the availability zone corresponding to the StandbyZoneId. required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] standby_zone_id: The multiple availability zone instances with availability zone IDs for the prepared availability zones. required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] status: The status of Instance.
        :param pulumi.Input[int] stream_engine_node_count: The number of LindormStream nodes in the instance.
        :param pulumi.Input[str] stream_engine_specification: The specification of the LindormStream nodes in the instance. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
        :param pulumi.Input[int] table_engine_node_count: The count of table engine.
        :param pulumi.Input[str] table_engine_specification: The specification of  table engine. Valid values: `lindorm.c.2xlarge`, `lindorm.c.4xlarge`, `lindorm.c.8xlarge`, `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[int] time_series_engine_node_count: The count of time series engine.
        :param pulumi.Input[str] time_series_engine_specification: The specification of time series engine. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.r.8xlarge`.
        :param pulumi.Input[str] time_serires_engine_specification: Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New field `time_series_engine_specification` instead.
        :param pulumi.Input[str] vpc_id: The VPC ID of the instance.
        :param pulumi.Input[str] vswitch_id: The vswitch id.
        :param pulumi.Input[str] zone_id: The zone ID of the instance.
        """
        if arbiter_vswitch_id is not None:
            pulumi.set(__self__, "arbiter_vswitch_id", arbiter_vswitch_id)
        if arbiter_zone_id is not None:
            pulumi.set(__self__, "arbiter_zone_id", arbiter_zone_id)
        if arch_version is not None:
            pulumi.set(__self__, "arch_version", arch_version)
        if cold_storage is not None:
            pulumi.set(__self__, "cold_storage", cold_storage)
        if core_single_storage is not None:
            pulumi.set(__self__, "core_single_storage", core_single_storage)
        if core_spec is not None:
            pulumi.set(__self__, "core_spec", core_spec)
        if deletion_proection is not None:
            pulumi.set(__self__, "deletion_proection", deletion_proection)
        if disk_category is not None:
            pulumi.set(__self__, "disk_category", disk_category)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if enabled_file_engine is not None:
            pulumi.set(__self__, "enabled_file_engine", enabled_file_engine)
        if enabled_lts_engine is not None:
            pulumi.set(__self__, "enabled_lts_engine", enabled_lts_engine)
        if enabled_search_engine is not None:
            pulumi.set(__self__, "enabled_search_engine", enabled_search_engine)
        if enabled_stream_engine is not None:
            pulumi.set(__self__, "enabled_stream_engine", enabled_stream_engine)
        if enabled_table_engine is not None:
            pulumi.set(__self__, "enabled_table_engine", enabled_table_engine)
        if enabled_time_serires_engine is not None:
            pulumi.set(__self__, "enabled_time_serires_engine", enabled_time_serires_engine)
        if file_engine_node_count is not None:
            pulumi.set(__self__, "file_engine_node_count", file_engine_node_count)
        if file_engine_specification is not None:
            pulumi.set(__self__, "file_engine_specification", file_engine_specification)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_storage is not None:
            pulumi.set(__self__, "instance_storage", instance_storage)
        if ip_white_lists is not None:
            pulumi.set(__self__, "ip_white_lists", ip_white_lists)
        if log_disk_category is not None:
            pulumi.set(__self__, "log_disk_category", log_disk_category)
        if log_num is not None:
            pulumi.set(__self__, "log_num", log_num)
        if log_single_storage is not None:
            pulumi.set(__self__, "log_single_storage", log_single_storage)
        if log_spec is not None:
            pulumi.set(__self__, "log_spec", log_spec)
        if lts_node_count is not None:
            pulumi.set(__self__, "lts_node_count", lts_node_count)
        if lts_node_specification is not None:
            pulumi.set(__self__, "lts_node_specification", lts_node_specification)
        if multi_zone_combination is not None:
            pulumi.set(__self__, "multi_zone_combination", multi_zone_combination)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if primary_vswitch_id is not None:
            pulumi.set(__self__, "primary_vswitch_id", primary_vswitch_id)
        if primary_zone_id is not None:
            pulumi.set(__self__, "primary_zone_id", primary_zone_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if search_engine_node_count is not None:
            pulumi.set(__self__, "search_engine_node_count", search_engine_node_count)
        if search_engine_specification is not None:
            pulumi.set(__self__, "search_engine_specification", search_engine_specification)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if standby_vswitch_id is not None:
            pulumi.set(__self__, "standby_vswitch_id", standby_vswitch_id)
        if standby_zone_id is not None:
            pulumi.set(__self__, "standby_zone_id", standby_zone_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if stream_engine_node_count is not None:
            pulumi.set(__self__, "stream_engine_node_count", stream_engine_node_count)
        if stream_engine_specification is not None:
            pulumi.set(__self__, "stream_engine_specification", stream_engine_specification)
        if table_engine_node_count is not None:
            pulumi.set(__self__, "table_engine_node_count", table_engine_node_count)
        if table_engine_specification is not None:
            pulumi.set(__self__, "table_engine_specification", table_engine_specification)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_series_engine_node_count is not None:
            pulumi.set(__self__, "time_series_engine_node_count", time_series_engine_node_count)
        if time_series_engine_specification is not None:
            pulumi.set(__self__, "time_series_engine_specification", time_series_engine_specification)
        if time_serires_engine_specification is not None:
            warnings.warn("""Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New field `time_series_engine_specification` instead.""", DeprecationWarning)
            pulumi.log.warn("""time_serires_engine_specification is deprecated: Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New field `time_series_engine_specification` instead.""")
        if time_serires_engine_specification is not None:
            pulumi.set(__self__, "time_serires_engine_specification", time_serires_engine_specification)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="arbiterVswitchId")
    def arbiter_vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The multi-availability zone instance, coordinating the virtual switch ID of the availability zone, the switch must be located under the availability zone corresponding to the ArbiterZoneId. This parameter is required if you need to create multiple availability zone instances.
        """
        return pulumi.get(self, "arbiter_vswitch_id")

    @arbiter_vswitch_id.setter
    def arbiter_vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arbiter_vswitch_id", value)

    @property
    @pulumi.getter(name="arbiterZoneId")
    def arbiter_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The multiple Availability Zone Instance, the availability zone ID of the coordinating availability zone. required if you need to create multiple availability zone instances.
        """
        return pulumi.get(self, "arbiter_zone_id")

    @arbiter_zone_id.setter
    def arbiter_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arbiter_zone_id", value)

    @property
    @pulumi.getter(name="archVersion")
    def arch_version(self) -> Optional[pulumi.Input[str]]:
        """
        The deployment architecture. If you do not fill in this parameter, the default is 1.0. to create multiple availability instances, fill in 2.0. if you need to create multiple availability instances, this parameter is required. Valid values: `1.0` to `2.0`.
        """
        return pulumi.get(self, "arch_version")

    @arch_version.setter
    def arch_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arch_version", value)

    @property
    @pulumi.getter(name="coldStorage")
    def cold_storage(self) -> Optional[pulumi.Input[int]]:
        """
        The cold storage capacity of the instance. Unit: GB. Valid values: [800, 1000000].
        """
        return pulumi.get(self, "cold_storage")

    @cold_storage.setter
    def cold_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cold_storage", value)

    @property
    @pulumi.getter(name="coreSingleStorage")
    def core_single_storage(self) -> Optional[pulumi.Input[int]]:
        """
        The multiple availability zone instances, CORE single node capacity. required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
        """
        return pulumi.get(self, "core_single_storage")

    @core_single_storage.setter
    def core_single_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "core_single_storage", value)

    @property
    @pulumi.getter(name="coreSpec")
    def core_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The core spec. When `disk_category` is `local_ssd_pro` or `local_hdd_pro`, this filed is valid.
        - When `disk_category` is `local_ssd_pro`, the valid values is `lindorm.i2.xlarge`, `lindorm.i2.2xlarge`, `lindorm.i2.4xlarge`, `lindorm.i2.8xlarge`.
        - When `disk_category` is `local_hdd_pro`, the valid values is `lindorm.d2c.6xlarge`, `lindorm.d2c.12xlarge`, `lindorm.d2c.24xlarge`, `lindorm.d2s.5xlarge`, `lindorm.d2s.10xlarge`, `lindorm.d1.2xlarge`, `lindorm.d1.4xlarge`, `lindorm.d1.6xlarge`.
        """
        return pulumi.get(self, "core_spec")

    @core_spec.setter
    def core_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "core_spec", value)

    @property
    @pulumi.getter(name="deletionProection")
    def deletion_proection(self) -> Optional[pulumi.Input[bool]]:
        """
        The deletion protection of instance.
        """
        return pulumi.get(self, "deletion_proection")

    @deletion_proection.setter
    def deletion_proection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_proection", value)

    @property
    @pulumi.getter(name="diskCategory")
    def disk_category(self) -> Optional[pulumi.Input[str]]:
        """
        The disk type of instance. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_essd_pl0`, `capacity_cloud_storage`, `local_ssd_pro`, `local_hdd_pro`. **NOTE:** From version 1.207.0, `disk_category` can be set to `cloud_essd_pl0`.
        """
        return pulumi.get(self, "disk_category")

    @disk_category.setter
    def disk_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_category", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[str]]:
        """
        The duration of paid. Valid when the `payment_type` is `Subscription`.  When `pricing_cycle` set to `Month`, the valid value id `1` to `9`.  When `pricing_cycle` set to `Year`, the valid value id `1` to `3`.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="enabledFileEngine")
    def enabled_file_engine(self) -> Optional[pulumi.Input[bool]]:
        """
        (Available since v1.163.0) Whether to enable file engine.
        """
        return pulumi.get(self, "enabled_file_engine")

    @enabled_file_engine.setter
    def enabled_file_engine(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled_file_engine", value)

    @property
    @pulumi.getter(name="enabledLtsEngine")
    def enabled_lts_engine(self) -> Optional[pulumi.Input[bool]]:
        """
        (Available since v1.163.0) Whether to enable lts engine.
        """
        return pulumi.get(self, "enabled_lts_engine")

    @enabled_lts_engine.setter
    def enabled_lts_engine(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled_lts_engine", value)

    @property
    @pulumi.getter(name="enabledSearchEngine")
    def enabled_search_engine(self) -> Optional[pulumi.Input[bool]]:
        """
        (Available since v1.163.0) Whether to enable search engine.
        """
        return pulumi.get(self, "enabled_search_engine")

    @enabled_search_engine.setter
    def enabled_search_engine(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled_search_engine", value)

    @property
    @pulumi.getter(name="enabledStreamEngine")
    def enabled_stream_engine(self) -> Optional[pulumi.Input[bool]]:
        """
        (Available since v1.211.0) Whether to enable streaming engine.
        """
        return pulumi.get(self, "enabled_stream_engine")

    @enabled_stream_engine.setter
    def enabled_stream_engine(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled_stream_engine", value)

    @property
    @pulumi.getter(name="enabledTableEngine")
    def enabled_table_engine(self) -> Optional[pulumi.Input[bool]]:
        """
        (Available since v1.163.0) Whether to enable table engine.
        """
        return pulumi.get(self, "enabled_table_engine")

    @enabled_table_engine.setter
    def enabled_table_engine(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled_table_engine", value)

    @property
    @pulumi.getter(name="enabledTimeSeriresEngine")
    def enabled_time_serires_engine(self) -> Optional[pulumi.Input[bool]]:
        """
        (Available since v1.163.0) Whether to enable time serires engine.
        """
        return pulumi.get(self, "enabled_time_serires_engine")

    @enabled_time_serires_engine.setter
    def enabled_time_serires_engine(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled_time_serires_engine", value)

    @property
    @pulumi.getter(name="fileEngineNodeCount")
    def file_engine_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The count of file engine.
        """
        return pulumi.get(self, "file_engine_node_count")

    @file_engine_node_count.setter
    def file_engine_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "file_engine_node_count", value)

    @property
    @pulumi.getter(name="fileEngineSpecification")
    def file_engine_specification(self) -> Optional[pulumi.Input[str]]:
        """
        The specification of file engine. Valid values: `lindorm.c.xlarge`.
        """
        return pulumi.get(self, "file_engine_specification")

    @file_engine_specification.setter
    def file_engine_specification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_engine_specification", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceStorage")
    def instance_storage(self) -> Optional[pulumi.Input[str]]:
        """
        The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB.
        """
        return pulumi.get(self, "instance_storage")

    @instance_storage.setter
    def instance_storage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_storage", value)

    @property
    @pulumi.getter(name="ipWhiteLists")
    def ip_white_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ip white list of instance.
        """
        return pulumi.get(self, "ip_white_lists")

    @ip_white_lists.setter
    def ip_white_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_white_lists", value)

    @property
    @pulumi.getter(name="logDiskCategory")
    def log_disk_category(self) -> Optional[pulumi.Input[str]]:
        """
        The multi-available zone instance, log node disk type. required if you need to create multiple availability zone instances. Valid values: `cloud_efficiency`, `cloud_ssd`.
        """
        return pulumi.get(self, "log_disk_category")

    @log_disk_category.setter
    def log_disk_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_disk_category", value)

    @property
    @pulumi.getter(name="logNum")
    def log_num(self) -> Optional[pulumi.Input[int]]:
        """
        The multiple Availability Zone Instance, number of log nodes. this parameter is required if you want to create multiple availability zone instances. Valid values: `4` to `400`.
        """
        return pulumi.get(self, "log_num")

    @log_num.setter
    def log_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "log_num", value)

    @property
    @pulumi.getter(name="logSingleStorage")
    def log_single_storage(self) -> Optional[pulumi.Input[int]]:
        """
        The multi-availability instance, log single-node disk capacity. This parameter is required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
        """
        return pulumi.get(self, "log_single_storage")

    @log_single_storage.setter
    def log_single_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "log_single_storage", value)

    @property
    @pulumi.getter(name="logSpec")
    def log_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The multiple availability zone instances, log node specification. required if you need to create multiple availability zone instances. Valid values: `lindorm.sn1.large`, `lindorm.sn1.2xlarge`.
        """
        return pulumi.get(self, "log_spec")

    @log_spec.setter
    def log_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_spec", value)

    @property
    @pulumi.getter(name="ltsNodeCount")
    def lts_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The count of lindorm tunnel service.
        """
        return pulumi.get(self, "lts_node_count")

    @lts_node_count.setter
    def lts_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lts_node_count", value)

    @property
    @pulumi.getter(name="ltsNodeSpecification")
    def lts_node_specification(self) -> Optional[pulumi.Input[str]]:
        """
        The specification of lindorm tunnel service. Valid values: `lindorm.g.2xlarge`, `lindorm.g.xlarge`.
        """
        return pulumi.get(self, "lts_node_specification")

    @lts_node_specification.setter
    def lts_node_specification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lts_node_specification", value)

    @property
    @pulumi.getter(name="multiZoneCombination")
    def multi_zone_combination(self) -> Optional[pulumi.Input[str]]:
        """
        The multi-zone combinations. Availability zone combinations are supported on the sale page. required if you need to create multiple availability zone instances. Valid values: `ap-southeast-5abc-aliyun`, `cn-hangzhou-ehi-aliyun`, `cn-beijing-acd-aliyun`, `ap-southeast-1-abc-aliyun`, `cn-zhangjiakou-abc-aliyun`, `cn-shanghai-efg-aliyun`, `cn-shanghai-abd-aliyun`, `cn-hangzhou-bef-aliyun`, `cn-hangzhou-bce-aliyun`, `cn-beijing-fgh-aliyun`, `cn-shenzhen-abc-aliyun`.
        """
        return pulumi.get(self, "multi_zone_combination")

    @multi_zone_combination.setter
    def multi_zone_combination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multi_zone_combination", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The billing method. Valid values: `PayAsYouGo` and `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[str]]:
        """
        The pricing cycle. Valid when the `payment_type` is `Subscription`. Valid values: `Month` and `Year`.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pricing_cycle", value)

    @property
    @pulumi.getter(name="primaryVswitchId")
    def primary_vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        Multi-available zone instances, the virtual switch ID of the primary available zone, must be under the available zone corresponding to the PrimaryZoneId. required if you need to create multiple availability zone instances.
        """
        return pulumi.get(self, "primary_vswitch_id")

    @primary_vswitch_id.setter
    def primary_vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_vswitch_id", value)

    @property
    @pulumi.getter(name="primaryZoneId")
    def primary_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        Multi-availability zone instance with the availability zone ID of the main availability zone. required if you need to create multiple availability zone instances.
        """
        return pulumi.get(self, "primary_zone_id")

    @primary_zone_id.setter
    def primary_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_zone_id", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="searchEngineNodeCount")
    def search_engine_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The count of search engine.
        """
        return pulumi.get(self, "search_engine_node_count")

    @search_engine_node_count.setter
    def search_engine_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "search_engine_node_count", value)

    @property
    @pulumi.getter(name="searchEngineSpecification")
    def search_engine_specification(self) -> Optional[pulumi.Input[str]]:
        """
        The specification of search engine. Valid values: `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.g.xlarge`.
        """
        return pulumi.get(self, "search_engine_specification")

    @search_engine_specification.setter
    def search_engine_specification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_engine_specification", value)

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Available since v1.196.0) The instance type.
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_type", value)

    @property
    @pulumi.getter(name="standbyVswitchId")
    def standby_vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The multiple availability zone instances, the virtual switch ID of the ready availability zone must be under the availability zone corresponding to the StandbyZoneId. required if you need to create multiple availability zone instances.
        """
        return pulumi.get(self, "standby_vswitch_id")

    @standby_vswitch_id.setter
    def standby_vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "standby_vswitch_id", value)

    @property
    @pulumi.getter(name="standbyZoneId")
    def standby_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The multiple availability zone instances with availability zone IDs for the prepared availability zones. required if you need to create multiple availability zone instances.
        """
        return pulumi.get(self, "standby_zone_id")

    @standby_zone_id.setter
    def standby_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "standby_zone_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of Instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="streamEngineNodeCount")
    def stream_engine_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of LindormStream nodes in the instance.
        """
        return pulumi.get(self, "stream_engine_node_count")

    @stream_engine_node_count.setter
    def stream_engine_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stream_engine_node_count", value)

    @property
    @pulumi.getter(name="streamEngineSpecification")
    def stream_engine_specification(self) -> Optional[pulumi.Input[str]]:
        """
        The specification of the LindormStream nodes in the instance. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
        """
        return pulumi.get(self, "stream_engine_specification")

    @stream_engine_specification.setter
    def stream_engine_specification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_engine_specification", value)

    @property
    @pulumi.getter(name="tableEngineNodeCount")
    def table_engine_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The count of table engine.
        """
        return pulumi.get(self, "table_engine_node_count")

    @table_engine_node_count.setter
    def table_engine_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "table_engine_node_count", value)

    @property
    @pulumi.getter(name="tableEngineSpecification")
    def table_engine_specification(self) -> Optional[pulumi.Input[str]]:
        """
        The specification of  table engine. Valid values: `lindorm.c.2xlarge`, `lindorm.c.4xlarge`, `lindorm.c.8xlarge`, `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
        """
        return pulumi.get(self, "table_engine_specification")

    @table_engine_specification.setter
    def table_engine_specification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_engine_specification", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="timeSeriesEngineNodeCount")
    def time_series_engine_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The count of time series engine.
        """
        return pulumi.get(self, "time_series_engine_node_count")

    @time_series_engine_node_count.setter
    def time_series_engine_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "time_series_engine_node_count", value)

    @property
    @pulumi.getter(name="timeSeriesEngineSpecification")
    def time_series_engine_specification(self) -> Optional[pulumi.Input[str]]:
        """
        The specification of time series engine. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.r.8xlarge`.
        """
        return pulumi.get(self, "time_series_engine_specification")

    @time_series_engine_specification.setter
    def time_series_engine_specification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_series_engine_specification", value)

    @property
    @pulumi.getter(name="timeSeriresEngineSpecification")
    def time_serires_engine_specification(self) -> Optional[pulumi.Input[str]]:
        """
        Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New field `time_series_engine_specification` instead.
        """
        warnings.warn("""Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New field `time_series_engine_specification` instead.""", DeprecationWarning)
        pulumi.log.warn("""time_serires_engine_specification is deprecated: Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New field `time_series_engine_specification` instead.""")

        return pulumi.get(self, "time_serires_engine_specification")

    @time_serires_engine_specification.setter
    def time_serires_engine_specification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_serires_engine_specification", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC ID of the instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arbiter_vswitch_id: Optional[pulumi.Input[str]] = None,
                 arbiter_zone_id: Optional[pulumi.Input[str]] = None,
                 arch_version: Optional[pulumi.Input[str]] = None,
                 cold_storage: Optional[pulumi.Input[int]] = None,
                 core_single_storage: Optional[pulumi.Input[int]] = None,
                 core_spec: Optional[pulumi.Input[str]] = None,
                 deletion_proection: Optional[pulumi.Input[bool]] = None,
                 disk_category: Optional[pulumi.Input[str]] = None,
                 duration: Optional[pulumi.Input[str]] = None,
                 file_engine_node_count: Optional[pulumi.Input[int]] = None,
                 file_engine_specification: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_storage: Optional[pulumi.Input[str]] = None,
                 ip_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_disk_category: Optional[pulumi.Input[str]] = None,
                 log_num: Optional[pulumi.Input[int]] = None,
                 log_single_storage: Optional[pulumi.Input[int]] = None,
                 log_spec: Optional[pulumi.Input[str]] = None,
                 lts_node_count: Optional[pulumi.Input[int]] = None,
                 lts_node_specification: Optional[pulumi.Input[str]] = None,
                 multi_zone_combination: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 pricing_cycle: Optional[pulumi.Input[str]] = None,
                 primary_vswitch_id: Optional[pulumi.Input[str]] = None,
                 primary_zone_id: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 search_engine_node_count: Optional[pulumi.Input[int]] = None,
                 search_engine_specification: Optional[pulumi.Input[str]] = None,
                 standby_vswitch_id: Optional[pulumi.Input[str]] = None,
                 standby_zone_id: Optional[pulumi.Input[str]] = None,
                 stream_engine_node_count: Optional[pulumi.Input[int]] = None,
                 stream_engine_specification: Optional[pulumi.Input[str]] = None,
                 table_engine_node_count: Optional[pulumi.Input[int]] = None,
                 table_engine_specification: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_series_engine_node_count: Optional[pulumi.Input[int]] = None,
                 time_series_engine_specification: Optional[pulumi.Input[str]] = None,
                 time_serires_engine_specification: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Lindorm Instance resource.

        For information about Lindorm Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/lindorm/latest/product-introduction-overview).

        > **NOTE:** Available since v1.132.0.

        > **NOTE:**  The Lindorm Instance does not support updating the specifications of multiple different engines, or the number of nodes at the same time.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        region = "cn-hangzhou"
        zone_id = "cn-hangzhou-h"
        default_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_switches = alicloud.vpc.get_switches(vpc_id=default_networks.ids[0],
            zone_id=zone_id)
        default_instance = alicloud.lindorm.Instance("defaultInstance",
            disk_category="cloud_efficiency",
            payment_type="PayAsYouGo",
            zone_id=zone_id,
            vswitch_id=default_switches.ids[0],
            vpc_id=default_networks.ids[0],
            instance_name=name,
            table_engine_specification="lindorm.g.4xlarge",
            table_engine_node_count=2,
            instance_storage="1920")
        ```

        ## Import

        Lindorm Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:lindorm/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arbiter_vswitch_id: The multi-availability zone instance, coordinating the virtual switch ID of the availability zone, the switch must be located under the availability zone corresponding to the ArbiterZoneId. This parameter is required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] arbiter_zone_id: The multiple Availability Zone Instance, the availability zone ID of the coordinating availability zone. required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] arch_version: The deployment architecture. If you do not fill in this parameter, the default is 1.0. to create multiple availability instances, fill in 2.0. if you need to create multiple availability instances, this parameter is required. Valid values: `1.0` to `2.0`.
        :param pulumi.Input[int] cold_storage: The cold storage capacity of the instance. Unit: GB. Valid values: [800, 1000000].
        :param pulumi.Input[int] core_single_storage: The multiple availability zone instances, CORE single node capacity. required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
        :param pulumi.Input[str] core_spec: The core spec. When `disk_category` is `local_ssd_pro` or `local_hdd_pro`, this filed is valid.
               - When `disk_category` is `local_ssd_pro`, the valid values is `lindorm.i2.xlarge`, `lindorm.i2.2xlarge`, `lindorm.i2.4xlarge`, `lindorm.i2.8xlarge`.
               - When `disk_category` is `local_hdd_pro`, the valid values is `lindorm.d2c.6xlarge`, `lindorm.d2c.12xlarge`, `lindorm.d2c.24xlarge`, `lindorm.d2s.5xlarge`, `lindorm.d2s.10xlarge`, `lindorm.d1.2xlarge`, `lindorm.d1.4xlarge`, `lindorm.d1.6xlarge`.
        :param pulumi.Input[bool] deletion_proection: The deletion protection of instance.
        :param pulumi.Input[str] disk_category: The disk type of instance. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_essd_pl0`, `capacity_cloud_storage`, `local_ssd_pro`, `local_hdd_pro`. **NOTE:** From version 1.207.0, `disk_category` can be set to `cloud_essd_pl0`.
        :param pulumi.Input[str] duration: The duration of paid. Valid when the `payment_type` is `Subscription`.  When `pricing_cycle` set to `Month`, the valid value id `1` to `9`.  When `pricing_cycle` set to `Year`, the valid value id `1` to `3`.
        :param pulumi.Input[int] file_engine_node_count: The count of file engine.
        :param pulumi.Input[str] file_engine_specification: The specification of file engine. Valid values: `lindorm.c.xlarge`.
        :param pulumi.Input[str] instance_name: The name of the instance.
        :param pulumi.Input[str] instance_storage: The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_white_lists: The ip white list of instance.
        :param pulumi.Input[str] log_disk_category: The multi-available zone instance, log node disk type. required if you need to create multiple availability zone instances. Valid values: `cloud_efficiency`, `cloud_ssd`.
        :param pulumi.Input[int] log_num: The multiple Availability Zone Instance, number of log nodes. this parameter is required if you want to create multiple availability zone instances. Valid values: `4` to `400`.
        :param pulumi.Input[int] log_single_storage: The multi-availability instance, log single-node disk capacity. This parameter is required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
        :param pulumi.Input[str] log_spec: The multiple availability zone instances, log node specification. required if you need to create multiple availability zone instances. Valid values: `lindorm.sn1.large`, `lindorm.sn1.2xlarge`.
        :param pulumi.Input[int] lts_node_count: The count of lindorm tunnel service.
        :param pulumi.Input[str] lts_node_specification: The specification of lindorm tunnel service. Valid values: `lindorm.g.2xlarge`, `lindorm.g.xlarge`.
        :param pulumi.Input[str] multi_zone_combination: The multi-zone combinations. Availability zone combinations are supported on the sale page. required if you need to create multiple availability zone instances. Valid values: `ap-southeast-5abc-aliyun`, `cn-hangzhou-ehi-aliyun`, `cn-beijing-acd-aliyun`, `ap-southeast-1-abc-aliyun`, `cn-zhangjiakou-abc-aliyun`, `cn-shanghai-efg-aliyun`, `cn-shanghai-abd-aliyun`, `cn-hangzhou-bef-aliyun`, `cn-hangzhou-bce-aliyun`, `cn-beijing-fgh-aliyun`, `cn-shenzhen-abc-aliyun`.
        :param pulumi.Input[str] payment_type: The billing method. Valid values: `PayAsYouGo` and `Subscription`.
        :param pulumi.Input[str] pricing_cycle: The pricing cycle. Valid when the `payment_type` is `Subscription`. Valid values: `Month` and `Year`.
        :param pulumi.Input[str] primary_vswitch_id: Multi-available zone instances, the virtual switch ID of the primary available zone, must be under the available zone corresponding to the PrimaryZoneId. required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] primary_zone_id: Multi-availability zone instance with the availability zone ID of the main availability zone. required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[int] search_engine_node_count: The count of search engine.
        :param pulumi.Input[str] search_engine_specification: The specification of search engine. Valid values: `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.g.xlarge`.
        :param pulumi.Input[str] standby_vswitch_id: The multiple availability zone instances, the virtual switch ID of the ready availability zone must be under the availability zone corresponding to the StandbyZoneId. required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] standby_zone_id: The multiple availability zone instances with availability zone IDs for the prepared availability zones. required if you need to create multiple availability zone instances.
        :param pulumi.Input[int] stream_engine_node_count: The number of LindormStream nodes in the instance.
        :param pulumi.Input[str] stream_engine_specification: The specification of the LindormStream nodes in the instance. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
        :param pulumi.Input[int] table_engine_node_count: The count of table engine.
        :param pulumi.Input[str] table_engine_specification: The specification of  table engine. Valid values: `lindorm.c.2xlarge`, `lindorm.c.4xlarge`, `lindorm.c.8xlarge`, `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[int] time_series_engine_node_count: The count of time series engine.
        :param pulumi.Input[str] time_series_engine_specification: The specification of time series engine. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.r.8xlarge`.
        :param pulumi.Input[str] time_serires_engine_specification: Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New field `time_series_engine_specification` instead.
        :param pulumi.Input[str] vpc_id: The VPC ID of the instance.
        :param pulumi.Input[str] vswitch_id: The vswitch id.
        :param pulumi.Input[str] zone_id: The zone ID of the instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Lindorm Instance resource.

        For information about Lindorm Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/lindorm/latest/product-introduction-overview).

        > **NOTE:** Available since v1.132.0.

        > **NOTE:**  The Lindorm Instance does not support updating the specifications of multiple different engines, or the number of nodes at the same time.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        region = "cn-hangzhou"
        zone_id = "cn-hangzhou-h"
        default_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_switches = alicloud.vpc.get_switches(vpc_id=default_networks.ids[0],
            zone_id=zone_id)
        default_instance = alicloud.lindorm.Instance("defaultInstance",
            disk_category="cloud_efficiency",
            payment_type="PayAsYouGo",
            zone_id=zone_id,
            vswitch_id=default_switches.ids[0],
            vpc_id=default_networks.ids[0],
            instance_name=name,
            table_engine_specification="lindorm.g.4xlarge",
            table_engine_node_count=2,
            instance_storage="1920")
        ```

        ## Import

        Lindorm Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:lindorm/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arbiter_vswitch_id: Optional[pulumi.Input[str]] = None,
                 arbiter_zone_id: Optional[pulumi.Input[str]] = None,
                 arch_version: Optional[pulumi.Input[str]] = None,
                 cold_storage: Optional[pulumi.Input[int]] = None,
                 core_single_storage: Optional[pulumi.Input[int]] = None,
                 core_spec: Optional[pulumi.Input[str]] = None,
                 deletion_proection: Optional[pulumi.Input[bool]] = None,
                 disk_category: Optional[pulumi.Input[str]] = None,
                 duration: Optional[pulumi.Input[str]] = None,
                 file_engine_node_count: Optional[pulumi.Input[int]] = None,
                 file_engine_specification: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_storage: Optional[pulumi.Input[str]] = None,
                 ip_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_disk_category: Optional[pulumi.Input[str]] = None,
                 log_num: Optional[pulumi.Input[int]] = None,
                 log_single_storage: Optional[pulumi.Input[int]] = None,
                 log_spec: Optional[pulumi.Input[str]] = None,
                 lts_node_count: Optional[pulumi.Input[int]] = None,
                 lts_node_specification: Optional[pulumi.Input[str]] = None,
                 multi_zone_combination: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 pricing_cycle: Optional[pulumi.Input[str]] = None,
                 primary_vswitch_id: Optional[pulumi.Input[str]] = None,
                 primary_zone_id: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 search_engine_node_count: Optional[pulumi.Input[int]] = None,
                 search_engine_specification: Optional[pulumi.Input[str]] = None,
                 standby_vswitch_id: Optional[pulumi.Input[str]] = None,
                 standby_zone_id: Optional[pulumi.Input[str]] = None,
                 stream_engine_node_count: Optional[pulumi.Input[int]] = None,
                 stream_engine_specification: Optional[pulumi.Input[str]] = None,
                 table_engine_node_count: Optional[pulumi.Input[int]] = None,
                 table_engine_specification: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_series_engine_node_count: Optional[pulumi.Input[int]] = None,
                 time_series_engine_specification: Optional[pulumi.Input[str]] = None,
                 time_serires_engine_specification: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["arbiter_vswitch_id"] = arbiter_vswitch_id
            __props__.__dict__["arbiter_zone_id"] = arbiter_zone_id
            __props__.__dict__["arch_version"] = arch_version
            __props__.__dict__["cold_storage"] = cold_storage
            __props__.__dict__["core_single_storage"] = core_single_storage
            __props__.__dict__["core_spec"] = core_spec
            __props__.__dict__["deletion_proection"] = deletion_proection
            if disk_category is None and not opts.urn:
                raise TypeError("Missing required property 'disk_category'")
            __props__.__dict__["disk_category"] = disk_category
            __props__.__dict__["duration"] = duration
            __props__.__dict__["file_engine_node_count"] = file_engine_node_count
            __props__.__dict__["file_engine_specification"] = file_engine_specification
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["instance_storage"] = instance_storage
            __props__.__dict__["ip_white_lists"] = ip_white_lists
            __props__.__dict__["log_disk_category"] = log_disk_category
            __props__.__dict__["log_num"] = log_num
            __props__.__dict__["log_single_storage"] = log_single_storage
            __props__.__dict__["log_spec"] = log_spec
            __props__.__dict__["lts_node_count"] = lts_node_count
            __props__.__dict__["lts_node_specification"] = lts_node_specification
            __props__.__dict__["multi_zone_combination"] = multi_zone_combination
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["pricing_cycle"] = pricing_cycle
            __props__.__dict__["primary_vswitch_id"] = primary_vswitch_id
            __props__.__dict__["primary_zone_id"] = primary_zone_id
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["search_engine_node_count"] = search_engine_node_count
            __props__.__dict__["search_engine_specification"] = search_engine_specification
            __props__.__dict__["standby_vswitch_id"] = standby_vswitch_id
            __props__.__dict__["standby_zone_id"] = standby_zone_id
            __props__.__dict__["stream_engine_node_count"] = stream_engine_node_count
            __props__.__dict__["stream_engine_specification"] = stream_engine_specification
            __props__.__dict__["table_engine_node_count"] = table_engine_node_count
            __props__.__dict__["table_engine_specification"] = table_engine_specification
            __props__.__dict__["tags"] = tags
            __props__.__dict__["time_series_engine_node_count"] = time_series_engine_node_count
            __props__.__dict__["time_series_engine_specification"] = time_series_engine_specification
            __props__.__dict__["time_serires_engine_specification"] = time_serires_engine_specification
            __props__.__dict__["vpc_id"] = vpc_id
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["enabled_file_engine"] = None
            __props__.__dict__["enabled_lts_engine"] = None
            __props__.__dict__["enabled_search_engine"] = None
            __props__.__dict__["enabled_stream_engine"] = None
            __props__.__dict__["enabled_table_engine"] = None
            __props__.__dict__["enabled_time_serires_engine"] = None
            __props__.__dict__["service_type"] = None
            __props__.__dict__["status"] = None
        super(Instance, __self__).__init__(
            'alicloud:lindorm/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arbiter_vswitch_id: Optional[pulumi.Input[str]] = None,
            arbiter_zone_id: Optional[pulumi.Input[str]] = None,
            arch_version: Optional[pulumi.Input[str]] = None,
            cold_storage: Optional[pulumi.Input[int]] = None,
            core_single_storage: Optional[pulumi.Input[int]] = None,
            core_spec: Optional[pulumi.Input[str]] = None,
            deletion_proection: Optional[pulumi.Input[bool]] = None,
            disk_category: Optional[pulumi.Input[str]] = None,
            duration: Optional[pulumi.Input[str]] = None,
            enabled_file_engine: Optional[pulumi.Input[bool]] = None,
            enabled_lts_engine: Optional[pulumi.Input[bool]] = None,
            enabled_search_engine: Optional[pulumi.Input[bool]] = None,
            enabled_stream_engine: Optional[pulumi.Input[bool]] = None,
            enabled_table_engine: Optional[pulumi.Input[bool]] = None,
            enabled_time_serires_engine: Optional[pulumi.Input[bool]] = None,
            file_engine_node_count: Optional[pulumi.Input[int]] = None,
            file_engine_specification: Optional[pulumi.Input[str]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            instance_storage: Optional[pulumi.Input[str]] = None,
            ip_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            log_disk_category: Optional[pulumi.Input[str]] = None,
            log_num: Optional[pulumi.Input[int]] = None,
            log_single_storage: Optional[pulumi.Input[int]] = None,
            log_spec: Optional[pulumi.Input[str]] = None,
            lts_node_count: Optional[pulumi.Input[int]] = None,
            lts_node_specification: Optional[pulumi.Input[str]] = None,
            multi_zone_combination: Optional[pulumi.Input[str]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            pricing_cycle: Optional[pulumi.Input[str]] = None,
            primary_vswitch_id: Optional[pulumi.Input[str]] = None,
            primary_zone_id: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            search_engine_node_count: Optional[pulumi.Input[int]] = None,
            search_engine_specification: Optional[pulumi.Input[str]] = None,
            service_type: Optional[pulumi.Input[str]] = None,
            standby_vswitch_id: Optional[pulumi.Input[str]] = None,
            standby_zone_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            stream_engine_node_count: Optional[pulumi.Input[int]] = None,
            stream_engine_specification: Optional[pulumi.Input[str]] = None,
            table_engine_node_count: Optional[pulumi.Input[int]] = None,
            table_engine_specification: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_series_engine_node_count: Optional[pulumi.Input[int]] = None,
            time_series_engine_specification: Optional[pulumi.Input[str]] = None,
            time_serires_engine_specification: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vswitch_id: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arbiter_vswitch_id: The multi-availability zone instance, coordinating the virtual switch ID of the availability zone, the switch must be located under the availability zone corresponding to the ArbiterZoneId. This parameter is required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] arbiter_zone_id: The multiple Availability Zone Instance, the availability zone ID of the coordinating availability zone. required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] arch_version: The deployment architecture. If you do not fill in this parameter, the default is 1.0. to create multiple availability instances, fill in 2.0. if you need to create multiple availability instances, this parameter is required. Valid values: `1.0` to `2.0`.
        :param pulumi.Input[int] cold_storage: The cold storage capacity of the instance. Unit: GB. Valid values: [800, 1000000].
        :param pulumi.Input[int] core_single_storage: The multiple availability zone instances, CORE single node capacity. required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
        :param pulumi.Input[str] core_spec: The core spec. When `disk_category` is `local_ssd_pro` or `local_hdd_pro`, this filed is valid.
               - When `disk_category` is `local_ssd_pro`, the valid values is `lindorm.i2.xlarge`, `lindorm.i2.2xlarge`, `lindorm.i2.4xlarge`, `lindorm.i2.8xlarge`.
               - When `disk_category` is `local_hdd_pro`, the valid values is `lindorm.d2c.6xlarge`, `lindorm.d2c.12xlarge`, `lindorm.d2c.24xlarge`, `lindorm.d2s.5xlarge`, `lindorm.d2s.10xlarge`, `lindorm.d1.2xlarge`, `lindorm.d1.4xlarge`, `lindorm.d1.6xlarge`.
        :param pulumi.Input[bool] deletion_proection: The deletion protection of instance.
        :param pulumi.Input[str] disk_category: The disk type of instance. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_essd_pl0`, `capacity_cloud_storage`, `local_ssd_pro`, `local_hdd_pro`. **NOTE:** From version 1.207.0, `disk_category` can be set to `cloud_essd_pl0`.
        :param pulumi.Input[str] duration: The duration of paid. Valid when the `payment_type` is `Subscription`.  When `pricing_cycle` set to `Month`, the valid value id `1` to `9`.  When `pricing_cycle` set to `Year`, the valid value id `1` to `3`.
        :param pulumi.Input[bool] enabled_file_engine: (Available since v1.163.0) Whether to enable file engine.
        :param pulumi.Input[bool] enabled_lts_engine: (Available since v1.163.0) Whether to enable lts engine.
        :param pulumi.Input[bool] enabled_search_engine: (Available since v1.163.0) Whether to enable search engine.
        :param pulumi.Input[bool] enabled_stream_engine: (Available since v1.211.0) Whether to enable streaming engine.
        :param pulumi.Input[bool] enabled_table_engine: (Available since v1.163.0) Whether to enable table engine.
        :param pulumi.Input[bool] enabled_time_serires_engine: (Available since v1.163.0) Whether to enable time serires engine.
        :param pulumi.Input[int] file_engine_node_count: The count of file engine.
        :param pulumi.Input[str] file_engine_specification: The specification of file engine. Valid values: `lindorm.c.xlarge`.
        :param pulumi.Input[str] instance_name: The name of the instance.
        :param pulumi.Input[str] instance_storage: The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_white_lists: The ip white list of instance.
        :param pulumi.Input[str] log_disk_category: The multi-available zone instance, log node disk type. required if you need to create multiple availability zone instances. Valid values: `cloud_efficiency`, `cloud_ssd`.
        :param pulumi.Input[int] log_num: The multiple Availability Zone Instance, number of log nodes. this parameter is required if you want to create multiple availability zone instances. Valid values: `4` to `400`.
        :param pulumi.Input[int] log_single_storage: The multi-availability instance, log single-node disk capacity. This parameter is required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
        :param pulumi.Input[str] log_spec: The multiple availability zone instances, log node specification. required if you need to create multiple availability zone instances. Valid values: `lindorm.sn1.large`, `lindorm.sn1.2xlarge`.
        :param pulumi.Input[int] lts_node_count: The count of lindorm tunnel service.
        :param pulumi.Input[str] lts_node_specification: The specification of lindorm tunnel service. Valid values: `lindorm.g.2xlarge`, `lindorm.g.xlarge`.
        :param pulumi.Input[str] multi_zone_combination: The multi-zone combinations. Availability zone combinations are supported on the sale page. required if you need to create multiple availability zone instances. Valid values: `ap-southeast-5abc-aliyun`, `cn-hangzhou-ehi-aliyun`, `cn-beijing-acd-aliyun`, `ap-southeast-1-abc-aliyun`, `cn-zhangjiakou-abc-aliyun`, `cn-shanghai-efg-aliyun`, `cn-shanghai-abd-aliyun`, `cn-hangzhou-bef-aliyun`, `cn-hangzhou-bce-aliyun`, `cn-beijing-fgh-aliyun`, `cn-shenzhen-abc-aliyun`.
        :param pulumi.Input[str] payment_type: The billing method. Valid values: `PayAsYouGo` and `Subscription`.
        :param pulumi.Input[str] pricing_cycle: The pricing cycle. Valid when the `payment_type` is `Subscription`. Valid values: `Month` and `Year`.
        :param pulumi.Input[str] primary_vswitch_id: Multi-available zone instances, the virtual switch ID of the primary available zone, must be under the available zone corresponding to the PrimaryZoneId. required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] primary_zone_id: Multi-availability zone instance with the availability zone ID of the main availability zone. required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[int] search_engine_node_count: The count of search engine.
        :param pulumi.Input[str] search_engine_specification: The specification of search engine. Valid values: `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.g.xlarge`.
        :param pulumi.Input[str] service_type: (Available since v1.196.0) The instance type.
        :param pulumi.Input[str] standby_vswitch_id: The multiple availability zone instances, the virtual switch ID of the ready availability zone must be under the availability zone corresponding to the StandbyZoneId. required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] standby_zone_id: The multiple availability zone instances with availability zone IDs for the prepared availability zones. required if you need to create multiple availability zone instances.
        :param pulumi.Input[str] status: The status of Instance.
        :param pulumi.Input[int] stream_engine_node_count: The number of LindormStream nodes in the instance.
        :param pulumi.Input[str] stream_engine_specification: The specification of the LindormStream nodes in the instance. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
        :param pulumi.Input[int] table_engine_node_count: The count of table engine.
        :param pulumi.Input[str] table_engine_specification: The specification of  table engine. Valid values: `lindorm.c.2xlarge`, `lindorm.c.4xlarge`, `lindorm.c.8xlarge`, `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[int] time_series_engine_node_count: The count of time series engine.
        :param pulumi.Input[str] time_series_engine_specification: The specification of time series engine. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.r.8xlarge`.
        :param pulumi.Input[str] time_serires_engine_specification: Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New field `time_series_engine_specification` instead.
        :param pulumi.Input[str] vpc_id: The VPC ID of the instance.
        :param pulumi.Input[str] vswitch_id: The vswitch id.
        :param pulumi.Input[str] zone_id: The zone ID of the instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["arbiter_vswitch_id"] = arbiter_vswitch_id
        __props__.__dict__["arbiter_zone_id"] = arbiter_zone_id
        __props__.__dict__["arch_version"] = arch_version
        __props__.__dict__["cold_storage"] = cold_storage
        __props__.__dict__["core_single_storage"] = core_single_storage
        __props__.__dict__["core_spec"] = core_spec
        __props__.__dict__["deletion_proection"] = deletion_proection
        __props__.__dict__["disk_category"] = disk_category
        __props__.__dict__["duration"] = duration
        __props__.__dict__["enabled_file_engine"] = enabled_file_engine
        __props__.__dict__["enabled_lts_engine"] = enabled_lts_engine
        __props__.__dict__["enabled_search_engine"] = enabled_search_engine
        __props__.__dict__["enabled_stream_engine"] = enabled_stream_engine
        __props__.__dict__["enabled_table_engine"] = enabled_table_engine
        __props__.__dict__["enabled_time_serires_engine"] = enabled_time_serires_engine
        __props__.__dict__["file_engine_node_count"] = file_engine_node_count
        __props__.__dict__["file_engine_specification"] = file_engine_specification
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_storage"] = instance_storage
        __props__.__dict__["ip_white_lists"] = ip_white_lists
        __props__.__dict__["log_disk_category"] = log_disk_category
        __props__.__dict__["log_num"] = log_num
        __props__.__dict__["log_single_storage"] = log_single_storage
        __props__.__dict__["log_spec"] = log_spec
        __props__.__dict__["lts_node_count"] = lts_node_count
        __props__.__dict__["lts_node_specification"] = lts_node_specification
        __props__.__dict__["multi_zone_combination"] = multi_zone_combination
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["pricing_cycle"] = pricing_cycle
        __props__.__dict__["primary_vswitch_id"] = primary_vswitch_id
        __props__.__dict__["primary_zone_id"] = primary_zone_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["search_engine_node_count"] = search_engine_node_count
        __props__.__dict__["search_engine_specification"] = search_engine_specification
        __props__.__dict__["service_type"] = service_type
        __props__.__dict__["standby_vswitch_id"] = standby_vswitch_id
        __props__.__dict__["standby_zone_id"] = standby_zone_id
        __props__.__dict__["status"] = status
        __props__.__dict__["stream_engine_node_count"] = stream_engine_node_count
        __props__.__dict__["stream_engine_specification"] = stream_engine_specification
        __props__.__dict__["table_engine_node_count"] = table_engine_node_count
        __props__.__dict__["table_engine_specification"] = table_engine_specification
        __props__.__dict__["tags"] = tags
        __props__.__dict__["time_series_engine_node_count"] = time_series_engine_node_count
        __props__.__dict__["time_series_engine_specification"] = time_series_engine_specification
        __props__.__dict__["time_serires_engine_specification"] = time_serires_engine_specification
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="arbiterVswitchId")
    def arbiter_vswitch_id(self) -> pulumi.Output[Optional[str]]:
        """
        The multi-availability zone instance, coordinating the virtual switch ID of the availability zone, the switch must be located under the availability zone corresponding to the ArbiterZoneId. This parameter is required if you need to create multiple availability zone instances.
        """
        return pulumi.get(self, "arbiter_vswitch_id")

    @property
    @pulumi.getter(name="arbiterZoneId")
    def arbiter_zone_id(self) -> pulumi.Output[Optional[str]]:
        """
        The multiple Availability Zone Instance, the availability zone ID of the coordinating availability zone. required if you need to create multiple availability zone instances.
        """
        return pulumi.get(self, "arbiter_zone_id")

    @property
    @pulumi.getter(name="archVersion")
    def arch_version(self) -> pulumi.Output[str]:
        """
        The deployment architecture. If you do not fill in this parameter, the default is 1.0. to create multiple availability instances, fill in 2.0. if you need to create multiple availability instances, this parameter is required. Valid values: `1.0` to `2.0`.
        """
        return pulumi.get(self, "arch_version")

    @property
    @pulumi.getter(name="coldStorage")
    def cold_storage(self) -> pulumi.Output[int]:
        """
        The cold storage capacity of the instance. Unit: GB. Valid values: [800, 1000000].
        """
        return pulumi.get(self, "cold_storage")

    @property
    @pulumi.getter(name="coreSingleStorage")
    def core_single_storage(self) -> pulumi.Output[Optional[int]]:
        """
        The multiple availability zone instances, CORE single node capacity. required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
        """
        return pulumi.get(self, "core_single_storage")

    @property
    @pulumi.getter(name="coreSpec")
    def core_spec(self) -> pulumi.Output[str]:
        """
        The core spec. When `disk_category` is `local_ssd_pro` or `local_hdd_pro`, this filed is valid.
        - When `disk_category` is `local_ssd_pro`, the valid values is `lindorm.i2.xlarge`, `lindorm.i2.2xlarge`, `lindorm.i2.4xlarge`, `lindorm.i2.8xlarge`.
        - When `disk_category` is `local_hdd_pro`, the valid values is `lindorm.d2c.6xlarge`, `lindorm.d2c.12xlarge`, `lindorm.d2c.24xlarge`, `lindorm.d2s.5xlarge`, `lindorm.d2s.10xlarge`, `lindorm.d1.2xlarge`, `lindorm.d1.4xlarge`, `lindorm.d1.6xlarge`.
        """
        return pulumi.get(self, "core_spec")

    @property
    @pulumi.getter(name="deletionProection")
    def deletion_proection(self) -> pulumi.Output[bool]:
        """
        The deletion protection of instance.
        """
        return pulumi.get(self, "deletion_proection")

    @property
    @pulumi.getter(name="diskCategory")
    def disk_category(self) -> pulumi.Output[str]:
        """
        The disk type of instance. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_essd_pl0`, `capacity_cloud_storage`, `local_ssd_pro`, `local_hdd_pro`. **NOTE:** From version 1.207.0, `disk_category` can be set to `cloud_essd_pl0`.
        """
        return pulumi.get(self, "disk_category")

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Output[Optional[str]]:
        """
        The duration of paid. Valid when the `payment_type` is `Subscription`.  When `pricing_cycle` set to `Month`, the valid value id `1` to `9`.  When `pricing_cycle` set to `Year`, the valid value id `1` to `3`.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="enabledFileEngine")
    def enabled_file_engine(self) -> pulumi.Output[bool]:
        """
        (Available since v1.163.0) Whether to enable file engine.
        """
        return pulumi.get(self, "enabled_file_engine")

    @property
    @pulumi.getter(name="enabledLtsEngine")
    def enabled_lts_engine(self) -> pulumi.Output[bool]:
        """
        (Available since v1.163.0) Whether to enable lts engine.
        """
        return pulumi.get(self, "enabled_lts_engine")

    @property
    @pulumi.getter(name="enabledSearchEngine")
    def enabled_search_engine(self) -> pulumi.Output[bool]:
        """
        (Available since v1.163.0) Whether to enable search engine.
        """
        return pulumi.get(self, "enabled_search_engine")

    @property
    @pulumi.getter(name="enabledStreamEngine")
    def enabled_stream_engine(self) -> pulumi.Output[bool]:
        """
        (Available since v1.211.0) Whether to enable streaming engine.
        """
        return pulumi.get(self, "enabled_stream_engine")

    @property
    @pulumi.getter(name="enabledTableEngine")
    def enabled_table_engine(self) -> pulumi.Output[bool]:
        """
        (Available since v1.163.0) Whether to enable table engine.
        """
        return pulumi.get(self, "enabled_table_engine")

    @property
    @pulumi.getter(name="enabledTimeSeriresEngine")
    def enabled_time_serires_engine(self) -> pulumi.Output[bool]:
        """
        (Available since v1.163.0) Whether to enable time serires engine.
        """
        return pulumi.get(self, "enabled_time_serires_engine")

    @property
    @pulumi.getter(name="fileEngineNodeCount")
    def file_engine_node_count(self) -> pulumi.Output[int]:
        """
        The count of file engine.
        """
        return pulumi.get(self, "file_engine_node_count")

    @property
    @pulumi.getter(name="fileEngineSpecification")
    def file_engine_specification(self) -> pulumi.Output[str]:
        """
        The specification of file engine. Valid values: `lindorm.c.xlarge`.
        """
        return pulumi.get(self, "file_engine_specification")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceStorage")
    def instance_storage(self) -> pulumi.Output[str]:
        """
        The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB.
        """
        return pulumi.get(self, "instance_storage")

    @property
    @pulumi.getter(name="ipWhiteLists")
    def ip_white_lists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The ip white list of instance.
        """
        return pulumi.get(self, "ip_white_lists")

    @property
    @pulumi.getter(name="logDiskCategory")
    def log_disk_category(self) -> pulumi.Output[Optional[str]]:
        """
        The multi-available zone instance, log node disk type. required if you need to create multiple availability zone instances. Valid values: `cloud_efficiency`, `cloud_ssd`.
        """
        return pulumi.get(self, "log_disk_category")

    @property
    @pulumi.getter(name="logNum")
    def log_num(self) -> pulumi.Output[Optional[int]]:
        """
        The multiple Availability Zone Instance, number of log nodes. this parameter is required if you want to create multiple availability zone instances. Valid values: `4` to `400`.
        """
        return pulumi.get(self, "log_num")

    @property
    @pulumi.getter(name="logSingleStorage")
    def log_single_storage(self) -> pulumi.Output[Optional[int]]:
        """
        The multi-availability instance, log single-node disk capacity. This parameter is required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
        """
        return pulumi.get(self, "log_single_storage")

    @property
    @pulumi.getter(name="logSpec")
    def log_spec(self) -> pulumi.Output[Optional[str]]:
        """
        The multiple availability zone instances, log node specification. required if you need to create multiple availability zone instances. Valid values: `lindorm.sn1.large`, `lindorm.sn1.2xlarge`.
        """
        return pulumi.get(self, "log_spec")

    @property
    @pulumi.getter(name="ltsNodeCount")
    def lts_node_count(self) -> pulumi.Output[int]:
        """
        The count of lindorm tunnel service.
        """
        return pulumi.get(self, "lts_node_count")

    @property
    @pulumi.getter(name="ltsNodeSpecification")
    def lts_node_specification(self) -> pulumi.Output[str]:
        """
        The specification of lindorm tunnel service. Valid values: `lindorm.g.2xlarge`, `lindorm.g.xlarge`.
        """
        return pulumi.get(self, "lts_node_specification")

    @property
    @pulumi.getter(name="multiZoneCombination")
    def multi_zone_combination(self) -> pulumi.Output[Optional[str]]:
        """
        The multi-zone combinations. Availability zone combinations are supported on the sale page. required if you need to create multiple availability zone instances. Valid values: `ap-southeast-5abc-aliyun`, `cn-hangzhou-ehi-aliyun`, `cn-beijing-acd-aliyun`, `ap-southeast-1-abc-aliyun`, `cn-zhangjiakou-abc-aliyun`, `cn-shanghai-efg-aliyun`, `cn-shanghai-abd-aliyun`, `cn-hangzhou-bef-aliyun`, `cn-hangzhou-bce-aliyun`, `cn-beijing-fgh-aliyun`, `cn-shenzhen-abc-aliyun`.
        """
        return pulumi.get(self, "multi_zone_combination")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        The billing method. Valid values: `PayAsYouGo` and `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> pulumi.Output[Optional[str]]:
        """
        The pricing cycle. Valid when the `payment_type` is `Subscription`. Valid values: `Month` and `Year`.
        """
        return pulumi.get(self, "pricing_cycle")

    @property
    @pulumi.getter(name="primaryVswitchId")
    def primary_vswitch_id(self) -> pulumi.Output[Optional[str]]:
        """
        Multi-available zone instances, the virtual switch ID of the primary available zone, must be under the available zone corresponding to the PrimaryZoneId. required if you need to create multiple availability zone instances.
        """
        return pulumi.get(self, "primary_vswitch_id")

    @property
    @pulumi.getter(name="primaryZoneId")
    def primary_zone_id(self) -> pulumi.Output[Optional[str]]:
        """
        Multi-availability zone instance with the availability zone ID of the main availability zone. required if you need to create multiple availability zone instances.
        """
        return pulumi.get(self, "primary_zone_id")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="searchEngineNodeCount")
    def search_engine_node_count(self) -> pulumi.Output[int]:
        """
        The count of search engine.
        """
        return pulumi.get(self, "search_engine_node_count")

    @property
    @pulumi.getter(name="searchEngineSpecification")
    def search_engine_specification(self) -> pulumi.Output[str]:
        """
        The specification of search engine. Valid values: `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.g.xlarge`.
        """
        return pulumi.get(self, "search_engine_specification")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Output[str]:
        """
        (Available since v1.196.0) The instance type.
        """
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter(name="standbyVswitchId")
    def standby_vswitch_id(self) -> pulumi.Output[Optional[str]]:
        """
        The multiple availability zone instances, the virtual switch ID of the ready availability zone must be under the availability zone corresponding to the StandbyZoneId. required if you need to create multiple availability zone instances.
        """
        return pulumi.get(self, "standby_vswitch_id")

    @property
    @pulumi.getter(name="standbyZoneId")
    def standby_zone_id(self) -> pulumi.Output[Optional[str]]:
        """
        The multiple availability zone instances with availability zone IDs for the prepared availability zones. required if you need to create multiple availability zone instances.
        """
        return pulumi.get(self, "standby_zone_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of Instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="streamEngineNodeCount")
    def stream_engine_node_count(self) -> pulumi.Output[int]:
        """
        The number of LindormStream nodes in the instance.
        """
        return pulumi.get(self, "stream_engine_node_count")

    @property
    @pulumi.getter(name="streamEngineSpecification")
    def stream_engine_specification(self) -> pulumi.Output[str]:
        """
        The specification of the LindormStream nodes in the instance. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
        """
        return pulumi.get(self, "stream_engine_specification")

    @property
    @pulumi.getter(name="tableEngineNodeCount")
    def table_engine_node_count(self) -> pulumi.Output[int]:
        """
        The count of table engine.
        """
        return pulumi.get(self, "table_engine_node_count")

    @property
    @pulumi.getter(name="tableEngineSpecification")
    def table_engine_specification(self) -> pulumi.Output[str]:
        """
        The specification of  table engine. Valid values: `lindorm.c.2xlarge`, `lindorm.c.4xlarge`, `lindorm.c.8xlarge`, `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
        """
        return pulumi.get(self, "table_engine_specification")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="timeSeriesEngineNodeCount")
    def time_series_engine_node_count(self) -> pulumi.Output[int]:
        """
        The count of time series engine.
        """
        return pulumi.get(self, "time_series_engine_node_count")

    @property
    @pulumi.getter(name="timeSeriesEngineSpecification")
    def time_series_engine_specification(self) -> pulumi.Output[str]:
        """
        The specification of time series engine. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.r.8xlarge`.
        """
        return pulumi.get(self, "time_series_engine_specification")

    @property
    @pulumi.getter(name="timeSeriresEngineSpecification")
    def time_serires_engine_specification(self) -> pulumi.Output[str]:
        """
        Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New field `time_series_engine_specification` instead.
        """
        warnings.warn("""Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New field `time_series_engine_specification` instead.""", DeprecationWarning)
        pulumi.log.warn("""time_serires_engine_specification is deprecated: Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New field `time_series_engine_specification` instead.""")

        return pulumi.get(self, "time_serires_engine_specification")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The VPC ID of the instance.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[str]:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")

