# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'AlertAnnotationArgs',
    'AlertGroupConfigurationArgs',
    'AlertJoinConfigurationArgs',
    'AlertLabelArgs',
    'AlertNotificationListArgs',
    'AlertPolicyConfigurationArgs',
    'AlertQueryListArgs',
    'AlertScheduleArgs',
    'AlertSeverityConfigurationArgs',
    'AlertTemplateConfigurationArgs',
    'EtlEtlSinkArgs',
    'OssExportConfigColumnArgs',
    'OssShipperParquetConfigArgs',
    'StoreEncryptConfArgs',
    'StoreEncryptConfUserCmkInfoArgs',
    'StoreIndexFieldSearchArgs',
    'StoreIndexFieldSearchJsonKeyArgs',
    'StoreIndexFullTextArgs',
    'StoreShardArgs',
]

@pulumi.input_type
class AlertAnnotationArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: Annotations's key for new alert.
        :param pulumi.Input[str] value: Annotations's value for new alert.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Annotations's key for new alert.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Annotations's value for new alert.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class AlertGroupConfigurationArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] type: including FixedRate,Hourly,Daily,Weekly,Cron.
        """
        pulumi.set(__self__, "type", type)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        including FixedRate,Hourly,Daily,Weekly,Cron.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fields", value)


@pulumi.input_type
class AlertJoinConfigurationArgs:
    def __init__(__self__, *,
                 condition: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] condition: Join condition.
        :param pulumi.Input[str] type: including FixedRate,Hourly,Daily,Weekly,Cron.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Input[str]:
        """
        Join condition.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input[str]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        including FixedRate,Hourly,Daily,Weekly,Cron.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class AlertLabelArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: Annotations's key for new alert.
        :param pulumi.Input[str] value: Annotations's value for new alert.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Annotations's key for new alert.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Annotations's value for new alert.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class AlertNotificationListArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[str],
                 type: pulumi.Input[str],
                 email_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mobile_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] content: Notice content of alarm.
        :param pulumi.Input[str] type: including FixedRate,Hourly,Daily,Weekly,Cron.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] email_lists: Email address list.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mobile_lists: SMS sending mobile number.
        :param pulumi.Input[str] service_uri: Request address.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "type", type)
        if email_lists is not None:
            pulumi.set(__self__, "email_lists", email_lists)
        if mobile_lists is not None:
            pulumi.set(__self__, "mobile_lists", mobile_lists)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input[str]:
        """
        Notice content of alarm.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[str]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        including FixedRate,Hourly,Daily,Weekly,Cron.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="emailLists")
    def email_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Email address list.
        """
        return pulumi.get(self, "email_lists")

    @email_lists.setter
    def email_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "email_lists", value)

    @property
    @pulumi.getter(name="mobileLists")
    def mobile_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        SMS sending mobile number.
        """
        return pulumi.get(self, "mobile_lists")

    @mobile_lists.setter
    def mobile_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "mobile_lists", value)

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Request address.
        """
        return pulumi.get(self, "service_uri")

    @service_uri.setter
    def service_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_uri", value)


@pulumi.input_type
class AlertPolicyConfigurationArgs:
    def __init__(__self__, *,
                 alert_policy_id: pulumi.Input[str],
                 repeat_interval: pulumi.Input[str],
                 action_policy_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] alert_policy_id: Alert Policy Id.
        :param pulumi.Input[str] repeat_interval: Repeat interval used by alert policy, 1h, 1m.e.g.
        :param pulumi.Input[str] action_policy_id: Action Policy Id.
        """
        pulumi.set(__self__, "alert_policy_id", alert_policy_id)
        pulumi.set(__self__, "repeat_interval", repeat_interval)
        if action_policy_id is not None:
            pulumi.set(__self__, "action_policy_id", action_policy_id)

    @property
    @pulumi.getter(name="alertPolicyId")
    def alert_policy_id(self) -> pulumi.Input[str]:
        """
        Alert Policy Id.
        """
        return pulumi.get(self, "alert_policy_id")

    @alert_policy_id.setter
    def alert_policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "alert_policy_id", value)

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> pulumi.Input[str]:
        """
        Repeat interval used by alert policy, 1h, 1m.e.g.
        """
        return pulumi.get(self, "repeat_interval")

    @repeat_interval.setter
    def repeat_interval(self, value: pulumi.Input[str]):
        pulumi.set(self, "repeat_interval", value)

    @property
    @pulumi.getter(name="actionPolicyId")
    def action_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Action Policy Id.
        """
        return pulumi.get(self, "action_policy_id")

    @action_policy_id.setter
    def action_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_policy_id", value)


@pulumi.input_type
class AlertQueryListArgs:
    def __init__(__self__, *,
                 end: pulumi.Input[str],
                 query: pulumi.Input[str],
                 start: pulumi.Input[str],
                 chart_title: Optional[pulumi.Input[str]] = None,
                 dashboard_id: Optional[pulumi.Input[str]] = None,
                 logstore: Optional[pulumi.Input[str]] = None,
                 power_sql_mode: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 store: Optional[pulumi.Input[str]] = None,
                 store_type: Optional[pulumi.Input[str]] = None,
                 time_span_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] end: End time. example: 20s.
        :param pulumi.Input[str] query: Query corresponding to chart. example: * AND aliyun.
        :param pulumi.Input[str] start: Begin time. example: -60s.
        :param pulumi.Input[str] chart_title: Chart title, optional from 1.161.0+.
        :param pulumi.Input[str] dashboard_id: Query dashboard id.
        :param pulumi.Input[str] logstore: Query logstore, use store for new alert, Deprecated from 1.161.0+.
        :param pulumi.Input[str] power_sql_mode: default disable, whether to use power sql. support auto, enable, disable.
        :param pulumi.Input[str] project: Query project.
        :param pulumi.Input[str] region: Query project region.
        :param pulumi.Input[str] role_arn: Query project store's ARN.
        :param pulumi.Input[str] store: Query store for new alert.
        :param pulumi.Input[str] store_type: Query store type for new alert, including log,metric,meta.
        :param pulumi.Input[str] time_span_type: default Custom. No need to configure this parameter.
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "start", start)
        if chart_title is not None:
            pulumi.set(__self__, "chart_title", chart_title)
        if dashboard_id is not None:
            pulumi.set(__self__, "dashboard_id", dashboard_id)
        if logstore is not None:
            warnings.warn("""Deprecated from 1.161.0+, use store""", DeprecationWarning)
            pulumi.log.warn("""logstore is deprecated: Deprecated from 1.161.0+, use store""")
        if logstore is not None:
            pulumi.set(__self__, "logstore", logstore)
        if power_sql_mode is not None:
            pulumi.set(__self__, "power_sql_mode", power_sql_mode)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if store is not None:
            pulumi.set(__self__, "store", store)
        if store_type is not None:
            pulumi.set(__self__, "store_type", store_type)
        if time_span_type is not None:
            pulumi.set(__self__, "time_span_type", time_span_type)

    @property
    @pulumi.getter
    def end(self) -> pulumi.Input[str]:
        """
        End time. example: 20s.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: pulumi.Input[str]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[str]:
        """
        Query corresponding to chart. example: * AND aliyun.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[str]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter
    def start(self) -> pulumi.Input[str]:
        """
        Begin time. example: -60s.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[str]):
        pulumi.set(self, "start", value)

    @property
    @pulumi.getter(name="chartTitle")
    def chart_title(self) -> Optional[pulumi.Input[str]]:
        """
        Chart title, optional from 1.161.0+.
        """
        return pulumi.get(self, "chart_title")

    @chart_title.setter
    def chart_title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "chart_title", value)

    @property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> Optional[pulumi.Input[str]]:
        """
        Query dashboard id.
        """
        return pulumi.get(self, "dashboard_id")

    @dashboard_id.setter
    def dashboard_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dashboard_id", value)

    @property
    @pulumi.getter
    def logstore(self) -> Optional[pulumi.Input[str]]:
        """
        Query logstore, use store for new alert, Deprecated from 1.161.0+.
        """
        warnings.warn("""Deprecated from 1.161.0+, use store""", DeprecationWarning)
        pulumi.log.warn("""logstore is deprecated: Deprecated from 1.161.0+, use store""")

        return pulumi.get(self, "logstore")

    @logstore.setter
    def logstore(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logstore", value)

    @property
    @pulumi.getter(name="powerSqlMode")
    def power_sql_mode(self) -> Optional[pulumi.Input[str]]:
        """
        default disable, whether to use power sql. support auto, enable, disable.
        """
        return pulumi.get(self, "power_sql_mode")

    @power_sql_mode.setter
    def power_sql_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "power_sql_mode", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Query project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Query project region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Query project store's ARN.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def store(self) -> Optional[pulumi.Input[str]]:
        """
        Query store for new alert.
        """
        return pulumi.get(self, "store")

    @store.setter
    def store(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "store", value)

    @property
    @pulumi.getter(name="storeType")
    def store_type(self) -> Optional[pulumi.Input[str]]:
        """
        Query store type for new alert, including log,metric,meta.
        """
        return pulumi.get(self, "store_type")

    @store_type.setter
    def store_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "store_type", value)

    @property
    @pulumi.getter(name="timeSpanType")
    def time_span_type(self) -> Optional[pulumi.Input[str]]:
        """
        default Custom. No need to configure this parameter.
        """
        return pulumi.get(self, "time_span_type")

    @time_span_type.setter
    def time_span_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_span_type", value)


@pulumi.input_type
class AlertScheduleArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 cron_expression: Optional[pulumi.Input[str]] = None,
                 day_of_week: Optional[pulumi.Input[int]] = None,
                 delay: Optional[pulumi.Input[int]] = None,
                 hour: Optional[pulumi.Input[int]] = None,
                 interval: Optional[pulumi.Input[str]] = None,
                 run_immediately: Optional[pulumi.Input[bool]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: including FixedRate,Hourly,Daily,Weekly,Cron.
        :param pulumi.Input[str] cron_expression: Cron expression when type is Cron.
        :param pulumi.Input[int] day_of_week: Day of week when type is Weekly, including 0,1,2,3,4,5,6, 0 for Sunday, 1 for Monday
        :param pulumi.Input[int] hour: Hour of day when type is Weekly/Daily.
        :param pulumi.Input[str] interval: Execution interval. 60 seconds minimum, such as 60s, 1h. used when type is FixedRate.
        :param pulumi.Input[str] time_zone: Time zone for schedule.
        """
        pulumi.set(__self__, "type", type)
        if cron_expression is not None:
            pulumi.set(__self__, "cron_expression", cron_expression)
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if run_immediately is not None:
            pulumi.set(__self__, "run_immediately", run_immediately)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        including FixedRate,Hourly,Daily,Weekly,Cron.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> Optional[pulumi.Input[str]]:
        """
        Cron expression when type is Cron.
        """
        return pulumi.get(self, "cron_expression")

    @cron_expression.setter
    def cron_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cron_expression", value)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[pulumi.Input[int]]:
        """
        Day of week when type is Weekly, including 0,1,2,3,4,5,6, 0 for Sunday, 1 for Monday
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "day_of_week", value)

    @property
    @pulumi.getter
    def delay(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "delay")

    @delay.setter
    def delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay", value)

    @property
    @pulumi.getter
    def hour(self) -> Optional[pulumi.Input[int]]:
        """
        Hour of day when type is Weekly/Daily.
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hour", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[str]]:
        """
        Execution interval. 60 seconds minimum, such as 60s, 1h. used when type is FixedRate.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="runImmediately")
    def run_immediately(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "run_immediately")

    @run_immediately.setter
    def run_immediately(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "run_immediately", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Time zone for schedule.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class AlertSeverityConfigurationArgs:
    def __init__(__self__, *,
                 eval_condition: pulumi.Input[Mapping[str, pulumi.Input[str]]],
                 severity: pulumi.Input[int]):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] eval_condition: Severity when this condition is met.
        :param pulumi.Input[int] severity: Severity for new alert, including 2,4,6,8,10 for Report,Low,Medium,High,Critical.
        """
        pulumi.set(__self__, "eval_condition", eval_condition)
        pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter(name="evalCondition")
    def eval_condition(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        """
        Severity when this condition is met.
        """
        return pulumi.get(self, "eval_condition")

    @eval_condition.setter
    def eval_condition(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "eval_condition", value)

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Input[int]:
        """
        Severity for new alert, including 2,4,6,8,10 for Report,Low,Medium,High,Critical.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: pulumi.Input[int]):
        pulumi.set(self, "severity", value)


@pulumi.input_type
class AlertTemplateConfigurationArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lang: Optional[pulumi.Input[str]] = None,
                 tokens: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] id: Alert template id.
        :param pulumi.Input[str] type: including FixedRate,Hourly,Daily,Weekly,Cron.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Alert template annotations.
        :param pulumi.Input[str] lang: Alert template language including `cn`, `en`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tokens: Alert template tokens.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if tokens is not None:
            pulumi.set(__self__, "tokens", tokens)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Alert template id.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        including FixedRate,Hourly,Daily,Weekly,Cron.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Alert template annotations.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[str]]:
        """
        Alert template language including `cn`, `en`.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lang", value)

    @property
    @pulumi.getter
    def tokens(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Alert template tokens.
        """
        return pulumi.get(self, "tokens")

    @tokens.setter
    def tokens(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tokens", value)


@pulumi.input_type
class EtlEtlSinkArgs:
    def __init__(__self__, *,
                 endpoint: pulumi.Input[str],
                 logstore: pulumi.Input[str],
                 name: pulumi.Input[str],
                 project: pulumi.Input[str],
                 access_key_id: Optional[pulumi.Input[str]] = None,
                 access_key_secret: Optional[pulumi.Input[str]] = None,
                 kms_encrypted_access_key_id: Optional[pulumi.Input[str]] = None,
                 kms_encrypted_access_key_secret: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] endpoint: Delivery target logstore region.
        :param pulumi.Input[str] logstore: Delivery target logstore.
        :param pulumi.Input[str] name: Delivery target name.
        :param pulumi.Input[str] project: The project where the target logstore is delivered.
        :param pulumi.Input[str] access_key_id: Delivery target logstore access key id.
        :param pulumi.Input[str] access_key_secret: Delivery target logstore access key secret.
        :param pulumi.Input[str] kms_encrypted_access_key_id: An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
        :param pulumi.Input[str] kms_encrypted_access_key_secret: An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
        :param pulumi.Input[str] role_arn: Sts role info under delivery target logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
        :param pulumi.Input[str] type: ETL sinks type, the default value is AliyunLOG.
               
               > **Note:** `from_time` and `to_time` no modification allowed after successful creation.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "logstore", logstore)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project", project)
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if access_key_secret is not None:
            pulumi.set(__self__, "access_key_secret", access_key_secret)
        if kms_encrypted_access_key_id is not None:
            pulumi.set(__self__, "kms_encrypted_access_key_id", kms_encrypted_access_key_id)
        if kms_encrypted_access_key_secret is not None:
            pulumi.set(__self__, "kms_encrypted_access_key_secret", kms_encrypted_access_key_secret)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[str]:
        """
        Delivery target logstore region.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def logstore(self) -> pulumi.Input[str]:
        """
        Delivery target logstore.
        """
        return pulumi.get(self, "logstore")

    @logstore.setter
    def logstore(self, value: pulumi.Input[str]):
        pulumi.set(self, "logstore", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Delivery target name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The project where the target logstore is delivered.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Delivery target logstore access key id.
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key_id", value)

    @property
    @pulumi.getter(name="accessKeySecret")
    def access_key_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Delivery target logstore access key secret.
        """
        return pulumi.get(self, "access_key_secret")

    @access_key_secret.setter
    def access_key_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key_secret", value)

    @property
    @pulumi.getter(name="kmsEncryptedAccessKeyId")
    def kms_encrypted_access_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_access_key_id")

    @kms_encrypted_access_key_id.setter
    def kms_encrypted_access_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_encrypted_access_key_id", value)

    @property
    @pulumi.getter(name="kmsEncryptedAccessKeySecret")
    def kms_encrypted_access_key_secret(self) -> Optional[pulumi.Input[str]]:
        """
        An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_access_key_secret")

    @kms_encrypted_access_key_secret.setter
    def kms_encrypted_access_key_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_encrypted_access_key_secret", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Sts role info under delivery target logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        ETL sinks type, the default value is AliyunLOG.

        > **Note:** `from_time` and `to_time` no modification allowed after successful creation.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class OssExportConfigColumnArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The name of the key.
        :param pulumi.Input[str] type: Type of configuration name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of configuration name.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class OssShipperParquetConfigArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str]):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class StoreEncryptConfArgs:
    def __init__(__self__, *,
                 enable: Optional[pulumi.Input[bool]] = None,
                 encrypt_type: Optional[pulumi.Input[str]] = None,
                 user_cmk_info: Optional[pulumi.Input['StoreEncryptConfUserCmkInfoArgs']] = None):
        """
        :param pulumi.Input[bool] enable: enable encryption. Default `false`
        :param pulumi.Input[str] encrypt_type: Supported encryption type, only supports `default(AES)`,` m4`
        :param pulumi.Input['StoreEncryptConfUserCmkInfoArgs'] user_cmk_info: User bring your own key (BYOK) encryption [Refer to details](https://www.alibabacloud.com/help/zh/doc-detail/187853.htm), the format is as follows. See `user_cmk_info` below.
               ```python
               import pulumi
               ```
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if encrypt_type is not None:
            pulumi.set(__self__, "encrypt_type", encrypt_type)
        if user_cmk_info is not None:
            pulumi.set(__self__, "user_cmk_info", user_cmk_info)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        enable encryption. Default `false`
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="encryptType")
    def encrypt_type(self) -> Optional[pulumi.Input[str]]:
        """
        Supported encryption type, only supports `default(AES)`,` m4`
        """
        return pulumi.get(self, "encrypt_type")

    @encrypt_type.setter
    def encrypt_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encrypt_type", value)

    @property
    @pulumi.getter(name="userCmkInfo")
    def user_cmk_info(self) -> Optional[pulumi.Input['StoreEncryptConfUserCmkInfoArgs']]:
        """
        User bring your own key (BYOK) encryption [Refer to details](https://www.alibabacloud.com/help/zh/doc-detail/187853.htm), the format is as follows. See `user_cmk_info` below.
        ```python
        import pulumi
        ```
        """
        return pulumi.get(self, "user_cmk_info")

    @user_cmk_info.setter
    def user_cmk_info(self, value: Optional[pulumi.Input['StoreEncryptConfUserCmkInfoArgs']]):
        pulumi.set(self, "user_cmk_info", value)


@pulumi.input_type
class StoreEncryptConfUserCmkInfoArgs:
    def __init__(__self__, *,
                 arn: pulumi.Input[str],
                 cmk_key_id: pulumi.Input[str],
                 region_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] arn: role arn.
        :param pulumi.Input[str] cmk_key_id: User master key id.
        :param pulumi.Input[str] region_id: Region id where the  user master key id is located.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "cmk_key_id", cmk_key_id)
        pulumi.set(__self__, "region_id", region_id)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Input[str]:
        """
        role arn.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="cmkKeyId")
    def cmk_key_id(self) -> pulumi.Input[str]:
        """
        User master key id.
        """
        return pulumi.get(self, "cmk_key_id")

    @cmk_key_id.setter
    def cmk_key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cmk_key_id", value)

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Input[str]:
        """
        Region id where the  user master key id is located.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "region_id", value)


@pulumi.input_type
class StoreIndexFieldSearchArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 alias: Optional[pulumi.Input[str]] = None,
                 case_sensitive: Optional[pulumi.Input[bool]] = None,
                 enable_analytics: Optional[pulumi.Input[bool]] = None,
                 include_chinese: Optional[pulumi.Input[bool]] = None,
                 json_keys: Optional[pulumi.Input[Sequence[pulumi.Input['StoreIndexFieldSearchJsonKeyArgs']]]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: When using the json_keys field, this field is required.
        :param pulumi.Input[str] alias: The alias of one field.
        :param pulumi.Input[bool] case_sensitive: Whether the case sensitive for the field. Default to false. It is valid when "type" is "text" or "json".
        :param pulumi.Input[bool] enable_analytics: Whether to enable field analytics. Default to true.
        :param pulumi.Input[bool] include_chinese: Whether includes the chinese for the field. Default to false. It is valid when "type" is "text" or "json".
        :param pulumi.Input[Sequence[pulumi.Input['StoreIndexFieldSearchJsonKeyArgs']]] json_keys: Use nested index when type is json
        :param pulumi.Input[str] token: The string of several split words, like "\\r", "#". It is valid when "type" is "text" or "json".
        :param pulumi.Input[str] type: The type of one field. Valid values: ["long", "text", "double"]. Default to "long"
        """
        pulumi.set(__self__, "name", name)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)
        if enable_analytics is not None:
            pulumi.set(__self__, "enable_analytics", enable_analytics)
        if include_chinese is not None:
            pulumi.set(__self__, "include_chinese", include_chinese)
        if json_keys is not None:
            pulumi.set(__self__, "json_keys", json_keys)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        When using the json_keys field, this field is required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        The alias of one field.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the case sensitive for the field. Default to false. It is valid when "type" is "text" or "json".
        """
        return pulumi.get(self, "case_sensitive")

    @case_sensitive.setter
    def case_sensitive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "case_sensitive", value)

    @property
    @pulumi.getter(name="enableAnalytics")
    def enable_analytics(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable field analytics. Default to true.
        """
        return pulumi.get(self, "enable_analytics")

    @enable_analytics.setter
    def enable_analytics(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_analytics", value)

    @property
    @pulumi.getter(name="includeChinese")
    def include_chinese(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether includes the chinese for the field. Default to false. It is valid when "type" is "text" or "json".
        """
        return pulumi.get(self, "include_chinese")

    @include_chinese.setter
    def include_chinese(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_chinese", value)

    @property
    @pulumi.getter(name="jsonKeys")
    def json_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StoreIndexFieldSearchJsonKeyArgs']]]]:
        """
        Use nested index when type is json
        """
        return pulumi.get(self, "json_keys")

    @json_keys.setter
    def json_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StoreIndexFieldSearchJsonKeyArgs']]]]):
        pulumi.set(self, "json_keys", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        The string of several split words, like "\\r", "#". It is valid when "type" is "text" or "json".
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of one field. Valid values: ["long", "text", "double"]. Default to "long"
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class StoreIndexFieldSearchJsonKeyArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 alias: Optional[pulumi.Input[str]] = None,
                 doc_value: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: When using the json_keys field, this field is required.
        :param pulumi.Input[str] alias: The alias of one field.
        :param pulumi.Input[bool] doc_value: Whether to enable statistics. default to true.
               
               > **Note:** At least one of the "full_text" and "field_search" should be specified.
        :param pulumi.Input[str] type: The type of one field. Valid values: ["long", "text", "double"]. Default to "long"
        """
        pulumi.set(__self__, "name", name)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if doc_value is not None:
            pulumi.set(__self__, "doc_value", doc_value)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        When using the json_keys field, this field is required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        The alias of one field.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter(name="docValue")
    def doc_value(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable statistics. default to true.

        > **Note:** At least one of the "full_text" and "field_search" should be specified.
        """
        return pulumi.get(self, "doc_value")

    @doc_value.setter
    def doc_value(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "doc_value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of one field. Valid values: ["long", "text", "double"]. Default to "long"
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class StoreIndexFullTextArgs:
    def __init__(__self__, *,
                 case_sensitive: Optional[pulumi.Input[bool]] = None,
                 include_chinese: Optional[pulumi.Input[bool]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] case_sensitive: Whether the case sensitive for the field. Default to false. It is valid when "type" is "text" or "json".
        :param pulumi.Input[bool] include_chinese: Whether includes the chinese for the field. Default to false. It is valid when "type" is "text" or "json".
        :param pulumi.Input[str] token: The string of several split words, like "\\r", "#". It is valid when "type" is "text" or "json".
        """
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)
        if include_chinese is not None:
            pulumi.set(__self__, "include_chinese", include_chinese)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the case sensitive for the field. Default to false. It is valid when "type" is "text" or "json".
        """
        return pulumi.get(self, "case_sensitive")

    @case_sensitive.setter
    def case_sensitive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "case_sensitive", value)

    @property
    @pulumi.getter(name="includeChinese")
    def include_chinese(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether includes the chinese for the field. Default to false. It is valid when "type" is "text" or "json".
        """
        return pulumi.get(self, "include_chinese")

    @include_chinese.setter
    def include_chinese(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_chinese", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        The string of several split words, like "\\r", "#". It is valid when "type" is "text" or "json".
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


@pulumi.input_type
class StoreShardArgs:
    def __init__(__self__, *,
                 begin_key: Optional[pulumi.Input[str]] = None,
                 end_key: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] begin_key: The begin value of the shard range(MD5), included in the shard range.
        :param pulumi.Input[str] end_key: The end value of the shard range(MD5), not included in shard range.
        :param pulumi.Input[int] id: The ID of the shard.
        :param pulumi.Input[str] status: Shard status, only two status of `readwrite` and `readonly`.
        """
        if begin_key is not None:
            pulumi.set(__self__, "begin_key", begin_key)
        if end_key is not None:
            pulumi.set(__self__, "end_key", end_key)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="beginKey")
    def begin_key(self) -> Optional[pulumi.Input[str]]:
        """
        The begin value of the shard range(MD5), included in the shard range.
        """
        return pulumi.get(self, "begin_key")

    @begin_key.setter
    def begin_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "begin_key", value)

    @property
    @pulumi.getter(name="endKey")
    def end_key(self) -> Optional[pulumi.Input[str]]:
        """
        The end value of the shard range(MD5), not included in shard range.
        """
        return pulumi.get(self, "end_key")

    @end_key.setter
    def end_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_key", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the shard.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Shard status, only two status of `readwrite` and `readonly`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


