# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertArgs', 'Alert']

@pulumi.input_type
class AlertArgs:
    def __init__(__self__, *,
                 alert_displayname: pulumi.Input[str],
                 alert_name: pulumi.Input[str],
                 project_name: pulumi.Input[str],
                 alert_description: Optional[pulumi.Input[str]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input['AlertAnnotationArgs']]]] = None,
                 auto_annotation: Optional[pulumi.Input[bool]] = None,
                 condition: Optional[pulumi.Input[str]] = None,
                 dashboard: Optional[pulumi.Input[str]] = None,
                 group_configuration: Optional[pulumi.Input['AlertGroupConfigurationArgs']] = None,
                 join_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AlertJoinConfigurationArgs']]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['AlertLabelArgs']]]] = None,
                 mute_until: Optional[pulumi.Input[int]] = None,
                 no_data_fire: Optional[pulumi.Input[bool]] = None,
                 no_data_severity: Optional[pulumi.Input[int]] = None,
                 notification_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AlertNotificationListArgs']]]] = None,
                 notify_threshold: Optional[pulumi.Input[int]] = None,
                 policy_configuration: Optional[pulumi.Input['AlertPolicyConfigurationArgs']] = None,
                 query_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AlertQueryListArgs']]]] = None,
                 schedule: Optional[pulumi.Input['AlertScheduleArgs']] = None,
                 schedule_interval: Optional[pulumi.Input[str]] = None,
                 schedule_type: Optional[pulumi.Input[str]] = None,
                 send_resolved: Optional[pulumi.Input[bool]] = None,
                 severity_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AlertSeverityConfigurationArgs']]]] = None,
                 template_configuration: Optional[pulumi.Input['AlertTemplateConfigurationArgs']] = None,
                 threshold: Optional[pulumi.Input[int]] = None,
                 throttling: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Alert resource.
        :param pulumi.Input[str] alert_displayname: Alert displayname.
        :param pulumi.Input[str] alert_name: Name of logstore for configuring alarm service.
        :param pulumi.Input[str] project_name: The project name.
        :param pulumi.Input[str] alert_description: Alert description.
        :param pulumi.Input[Sequence[pulumi.Input['AlertAnnotationArgs']]] annotations: Alert template annotations.
        :param pulumi.Input[bool] auto_annotation: whether to add automatic annotation, default is false.
        :param pulumi.Input[str] condition: Join condition.
        :param pulumi.Input['AlertGroupConfigurationArgs'] group_configuration: Group configuration for new alert.
        :param pulumi.Input[Sequence[pulumi.Input['AlertJoinConfigurationArgs']]] join_configurations: Join configuration for different queries.
        :param pulumi.Input[Sequence[pulumi.Input['AlertLabelArgs']]] labels: Labels for new alert.
        :param pulumi.Input[int] mute_until: Timestamp, notifications before closing again.
        :param pulumi.Input[bool] no_data_fire: Switch for whether new alert fires when no data happens, default is false.
        :param pulumi.Input[int] no_data_severity: when no data happens, the severity of new alert.
        :param pulumi.Input[Sequence[pulumi.Input['AlertNotificationListArgs']]] notification_lists: Alarm information notification list, Deprecated from 1.161.0+.
        :param pulumi.Input[int] notify_threshold: Notification threshold, which is not notified until the number of triggers is reached. The default is 1, Deprecated from 1.161.0+.
        :param pulumi.Input['AlertPolicyConfigurationArgs'] policy_configuration: Policy configuration for new alert.
        :param pulumi.Input[Sequence[pulumi.Input['AlertQueryListArgs']]] query_lists: Multiple conditions for configured alarm query.
        :param pulumi.Input['AlertScheduleArgs'] schedule: schedule for alert.
        :param pulumi.Input[str] schedule_interval: Execution interval. 60 seconds minimum, such as 60s, 1h. Deprecated from 1.176.0+. use interval in schedule.
        :param pulumi.Input[str] schedule_type: Default FixedRate. No need to configure this parameter. Deprecated from 1.176.0+. use type in schedule.
        :param pulumi.Input[bool] send_resolved: when new alert is resolved, whether to notify, default is false.
        :param pulumi.Input[Sequence[pulumi.Input['AlertSeverityConfigurationArgs']]] severity_configurations: Severity configuration for new alert.
        :param pulumi.Input['AlertTemplateConfigurationArgs'] template_configuration: Template configuration for alert, when `type` is `tpl`.
        :param pulumi.Input[int] threshold: Evaluation threshold, alert will not fire until the number of triggers is reached. The default is 1.
        :param pulumi.Input[str] throttling: Notification interval, default is no interval. Support number + unit type, for example 60s, 1h, Deprecated from 1.161.0+.
        :param pulumi.Input[str] type: including FixedRate,Hourly,Daily,Weekly,Cron.
        :param pulumi.Input[str] version: The version of alert, new alert is 2.0.
        """
        pulumi.set(__self__, "alert_displayname", alert_displayname)
        pulumi.set(__self__, "alert_name", alert_name)
        pulumi.set(__self__, "project_name", project_name)
        if alert_description is not None:
            pulumi.set(__self__, "alert_description", alert_description)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if auto_annotation is not None:
            pulumi.set(__self__, "auto_annotation", auto_annotation)
        if condition is not None:
            warnings.warn("""Deprecated from 1.161.0+, use eval_condition in severity_configurations""", DeprecationWarning)
            pulumi.log.warn("""condition is deprecated: Deprecated from 1.161.0+, use eval_condition in severity_configurations""")
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if dashboard is not None:
            warnings.warn("""Deprecated from 1.161.0+, use dashboardId in query_list""", DeprecationWarning)
            pulumi.log.warn("""dashboard is deprecated: Deprecated from 1.161.0+, use dashboardId in query_list""")
        if dashboard is not None:
            pulumi.set(__self__, "dashboard", dashboard)
        if group_configuration is not None:
            pulumi.set(__self__, "group_configuration", group_configuration)
        if join_configurations is not None:
            pulumi.set(__self__, "join_configurations", join_configurations)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if mute_until is not None:
            pulumi.set(__self__, "mute_until", mute_until)
        if no_data_fire is not None:
            pulumi.set(__self__, "no_data_fire", no_data_fire)
        if no_data_severity is not None:
            pulumi.set(__self__, "no_data_severity", no_data_severity)
        if notification_lists is not None:
            warnings.warn("""Deprecated from 1.161.0+, use policy_configuration for notification""", DeprecationWarning)
            pulumi.log.warn("""notification_lists is deprecated: Deprecated from 1.161.0+, use policy_configuration for notification""")
        if notification_lists is not None:
            pulumi.set(__self__, "notification_lists", notification_lists)
        if notify_threshold is not None:
            warnings.warn("""Deprecated from 1.161.0+, use threshold""", DeprecationWarning)
            pulumi.log.warn("""notify_threshold is deprecated: Deprecated from 1.161.0+, use threshold""")
        if notify_threshold is not None:
            pulumi.set(__self__, "notify_threshold", notify_threshold)
        if policy_configuration is not None:
            pulumi.set(__self__, "policy_configuration", policy_configuration)
        if query_lists is not None:
            pulumi.set(__self__, "query_lists", query_lists)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if schedule_interval is not None:
            warnings.warn("""Field 'schedule_interval' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""", DeprecationWarning)
            pulumi.log.warn("""schedule_interval is deprecated: Field 'schedule_interval' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""")
        if schedule_interval is not None:
            pulumi.set(__self__, "schedule_interval", schedule_interval)
        if schedule_type is not None:
            warnings.warn("""Field 'schedule_type' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""", DeprecationWarning)
            pulumi.log.warn("""schedule_type is deprecated: Field 'schedule_type' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""")
        if schedule_type is not None:
            pulumi.set(__self__, "schedule_type", schedule_type)
        if send_resolved is not None:
            pulumi.set(__self__, "send_resolved", send_resolved)
        if severity_configurations is not None:
            pulumi.set(__self__, "severity_configurations", severity_configurations)
        if template_configuration is not None:
            pulumi.set(__self__, "template_configuration", template_configuration)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if throttling is not None:
            warnings.warn("""Deprecated from 1.161.0+, use repeat_interval in policy_configuration""", DeprecationWarning)
            pulumi.log.warn("""throttling is deprecated: Deprecated from 1.161.0+, use repeat_interval in policy_configuration""")
        if throttling is not None:
            pulumi.set(__self__, "throttling", throttling)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="alertDisplayname")
    def alert_displayname(self) -> pulumi.Input[str]:
        """
        Alert displayname.
        """
        return pulumi.get(self, "alert_displayname")

    @alert_displayname.setter
    def alert_displayname(self, value: pulumi.Input[str]):
        pulumi.set(self, "alert_displayname", value)

    @property
    @pulumi.getter(name="alertName")
    def alert_name(self) -> pulumi.Input[str]:
        """
        Name of logstore for configuring alarm service.
        """
        return pulumi.get(self, "alert_name")

    @alert_name.setter
    def alert_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "alert_name", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Input[str]:
        """
        The project name.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="alertDescription")
    def alert_description(self) -> Optional[pulumi.Input[str]]:
        """
        Alert description.
        """
        return pulumi.get(self, "alert_description")

    @alert_description.setter
    def alert_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alert_description", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertAnnotationArgs']]]]:
        """
        Alert template annotations.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertAnnotationArgs']]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="autoAnnotation")
    def auto_annotation(self) -> Optional[pulumi.Input[bool]]:
        """
        whether to add automatic annotation, default is false.
        """
        return pulumi.get(self, "auto_annotation")

    @auto_annotation.setter
    def auto_annotation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_annotation", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[str]]:
        """
        Join condition.
        """
        warnings.warn("""Deprecated from 1.161.0+, use eval_condition in severity_configurations""", DeprecationWarning)
        pulumi.log.warn("""condition is deprecated: Deprecated from 1.161.0+, use eval_condition in severity_configurations""")

        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def dashboard(self) -> Optional[pulumi.Input[str]]:
        warnings.warn("""Deprecated from 1.161.0+, use dashboardId in query_list""", DeprecationWarning)
        pulumi.log.warn("""dashboard is deprecated: Deprecated from 1.161.0+, use dashboardId in query_list""")

        return pulumi.get(self, "dashboard")

    @dashboard.setter
    def dashboard(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dashboard", value)

    @property
    @pulumi.getter(name="groupConfiguration")
    def group_configuration(self) -> Optional[pulumi.Input['AlertGroupConfigurationArgs']]:
        """
        Group configuration for new alert.
        """
        return pulumi.get(self, "group_configuration")

    @group_configuration.setter
    def group_configuration(self, value: Optional[pulumi.Input['AlertGroupConfigurationArgs']]):
        pulumi.set(self, "group_configuration", value)

    @property
    @pulumi.getter(name="joinConfigurations")
    def join_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertJoinConfigurationArgs']]]]:
        """
        Join configuration for different queries.
        """
        return pulumi.get(self, "join_configurations")

    @join_configurations.setter
    def join_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertJoinConfigurationArgs']]]]):
        pulumi.set(self, "join_configurations", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertLabelArgs']]]]:
        """
        Labels for new alert.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="muteUntil")
    def mute_until(self) -> Optional[pulumi.Input[int]]:
        """
        Timestamp, notifications before closing again.
        """
        return pulumi.get(self, "mute_until")

    @mute_until.setter
    def mute_until(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mute_until", value)

    @property
    @pulumi.getter(name="noDataFire")
    def no_data_fire(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch for whether new alert fires when no data happens, default is false.
        """
        return pulumi.get(self, "no_data_fire")

    @no_data_fire.setter
    def no_data_fire(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_data_fire", value)

    @property
    @pulumi.getter(name="noDataSeverity")
    def no_data_severity(self) -> Optional[pulumi.Input[int]]:
        """
        when no data happens, the severity of new alert.
        """
        return pulumi.get(self, "no_data_severity")

    @no_data_severity.setter
    def no_data_severity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "no_data_severity", value)

    @property
    @pulumi.getter(name="notificationLists")
    def notification_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertNotificationListArgs']]]]:
        """
        Alarm information notification list, Deprecated from 1.161.0+.
        """
        warnings.warn("""Deprecated from 1.161.0+, use policy_configuration for notification""", DeprecationWarning)
        pulumi.log.warn("""notification_lists is deprecated: Deprecated from 1.161.0+, use policy_configuration for notification""")

        return pulumi.get(self, "notification_lists")

    @notification_lists.setter
    def notification_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertNotificationListArgs']]]]):
        pulumi.set(self, "notification_lists", value)

    @property
    @pulumi.getter(name="notifyThreshold")
    def notify_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Notification threshold, which is not notified until the number of triggers is reached. The default is 1, Deprecated from 1.161.0+.
        """
        warnings.warn("""Deprecated from 1.161.0+, use threshold""", DeprecationWarning)
        pulumi.log.warn("""notify_threshold is deprecated: Deprecated from 1.161.0+, use threshold""")

        return pulumi.get(self, "notify_threshold")

    @notify_threshold.setter
    def notify_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "notify_threshold", value)

    @property
    @pulumi.getter(name="policyConfiguration")
    def policy_configuration(self) -> Optional[pulumi.Input['AlertPolicyConfigurationArgs']]:
        """
        Policy configuration for new alert.
        """
        return pulumi.get(self, "policy_configuration")

    @policy_configuration.setter
    def policy_configuration(self, value: Optional[pulumi.Input['AlertPolicyConfigurationArgs']]):
        pulumi.set(self, "policy_configuration", value)

    @property
    @pulumi.getter(name="queryLists")
    def query_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertQueryListArgs']]]]:
        """
        Multiple conditions for configured alarm query.
        """
        return pulumi.get(self, "query_lists")

    @query_lists.setter
    def query_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertQueryListArgs']]]]):
        pulumi.set(self, "query_lists", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['AlertScheduleArgs']]:
        """
        schedule for alert.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['AlertScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="scheduleInterval")
    def schedule_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Execution interval. 60 seconds minimum, such as 60s, 1h. Deprecated from 1.176.0+. use interval in schedule.
        """
        warnings.warn("""Field 'schedule_interval' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""", DeprecationWarning)
        pulumi.log.warn("""schedule_interval is deprecated: Field 'schedule_interval' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""")

        return pulumi.get(self, "schedule_interval")

    @schedule_interval.setter
    def schedule_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_interval", value)

    @property
    @pulumi.getter(name="scheduleType")
    def schedule_type(self) -> Optional[pulumi.Input[str]]:
        """
        Default FixedRate. No need to configure this parameter. Deprecated from 1.176.0+. use type in schedule.
        """
        warnings.warn("""Field 'schedule_type' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""", DeprecationWarning)
        pulumi.log.warn("""schedule_type is deprecated: Field 'schedule_type' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""")

        return pulumi.get(self, "schedule_type")

    @schedule_type.setter
    def schedule_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_type", value)

    @property
    @pulumi.getter(name="sendResolved")
    def send_resolved(self) -> Optional[pulumi.Input[bool]]:
        """
        when new alert is resolved, whether to notify, default is false.
        """
        return pulumi.get(self, "send_resolved")

    @send_resolved.setter
    def send_resolved(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_resolved", value)

    @property
    @pulumi.getter(name="severityConfigurations")
    def severity_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertSeverityConfigurationArgs']]]]:
        """
        Severity configuration for new alert.
        """
        return pulumi.get(self, "severity_configurations")

    @severity_configurations.setter
    def severity_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertSeverityConfigurationArgs']]]]):
        pulumi.set(self, "severity_configurations", value)

    @property
    @pulumi.getter(name="templateConfiguration")
    def template_configuration(self) -> Optional[pulumi.Input['AlertTemplateConfigurationArgs']]:
        """
        Template configuration for alert, when `type` is `tpl`.
        """
        return pulumi.get(self, "template_configuration")

    @template_configuration.setter
    def template_configuration(self, value: Optional[pulumi.Input['AlertTemplateConfigurationArgs']]):
        pulumi.set(self, "template_configuration", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Evaluation threshold, alert will not fire until the number of triggers is reached. The default is 1.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter
    def throttling(self) -> Optional[pulumi.Input[str]]:
        """
        Notification interval, default is no interval. Support number + unit type, for example 60s, 1h, Deprecated from 1.161.0+.
        """
        warnings.warn("""Deprecated from 1.161.0+, use repeat_interval in policy_configuration""", DeprecationWarning)
        pulumi.log.warn("""throttling is deprecated: Deprecated from 1.161.0+, use repeat_interval in policy_configuration""")

        return pulumi.get(self, "throttling")

    @throttling.setter
    def throttling(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "throttling", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        including FixedRate,Hourly,Daily,Weekly,Cron.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of alert, new alert is 2.0.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _AlertState:
    def __init__(__self__, *,
                 alert_description: Optional[pulumi.Input[str]] = None,
                 alert_displayname: Optional[pulumi.Input[str]] = None,
                 alert_name: Optional[pulumi.Input[str]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input['AlertAnnotationArgs']]]] = None,
                 auto_annotation: Optional[pulumi.Input[bool]] = None,
                 condition: Optional[pulumi.Input[str]] = None,
                 dashboard: Optional[pulumi.Input[str]] = None,
                 group_configuration: Optional[pulumi.Input['AlertGroupConfigurationArgs']] = None,
                 join_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AlertJoinConfigurationArgs']]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['AlertLabelArgs']]]] = None,
                 mute_until: Optional[pulumi.Input[int]] = None,
                 no_data_fire: Optional[pulumi.Input[bool]] = None,
                 no_data_severity: Optional[pulumi.Input[int]] = None,
                 notification_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AlertNotificationListArgs']]]] = None,
                 notify_threshold: Optional[pulumi.Input[int]] = None,
                 policy_configuration: Optional[pulumi.Input['AlertPolicyConfigurationArgs']] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 query_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AlertQueryListArgs']]]] = None,
                 schedule: Optional[pulumi.Input['AlertScheduleArgs']] = None,
                 schedule_interval: Optional[pulumi.Input[str]] = None,
                 schedule_type: Optional[pulumi.Input[str]] = None,
                 send_resolved: Optional[pulumi.Input[bool]] = None,
                 severity_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AlertSeverityConfigurationArgs']]]] = None,
                 template_configuration: Optional[pulumi.Input['AlertTemplateConfigurationArgs']] = None,
                 threshold: Optional[pulumi.Input[int]] = None,
                 throttling: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Alert resources.
        :param pulumi.Input[str] alert_description: Alert description.
        :param pulumi.Input[str] alert_displayname: Alert displayname.
        :param pulumi.Input[str] alert_name: Name of logstore for configuring alarm service.
        :param pulumi.Input[Sequence[pulumi.Input['AlertAnnotationArgs']]] annotations: Alert template annotations.
        :param pulumi.Input[bool] auto_annotation: whether to add automatic annotation, default is false.
        :param pulumi.Input[str] condition: Join condition.
        :param pulumi.Input['AlertGroupConfigurationArgs'] group_configuration: Group configuration for new alert.
        :param pulumi.Input[Sequence[pulumi.Input['AlertJoinConfigurationArgs']]] join_configurations: Join configuration for different queries.
        :param pulumi.Input[Sequence[pulumi.Input['AlertLabelArgs']]] labels: Labels for new alert.
        :param pulumi.Input[int] mute_until: Timestamp, notifications before closing again.
        :param pulumi.Input[bool] no_data_fire: Switch for whether new alert fires when no data happens, default is false.
        :param pulumi.Input[int] no_data_severity: when no data happens, the severity of new alert.
        :param pulumi.Input[Sequence[pulumi.Input['AlertNotificationListArgs']]] notification_lists: Alarm information notification list, Deprecated from 1.161.0+.
        :param pulumi.Input[int] notify_threshold: Notification threshold, which is not notified until the number of triggers is reached. The default is 1, Deprecated from 1.161.0+.
        :param pulumi.Input['AlertPolicyConfigurationArgs'] policy_configuration: Policy configuration for new alert.
        :param pulumi.Input[str] project_name: The project name.
        :param pulumi.Input[Sequence[pulumi.Input['AlertQueryListArgs']]] query_lists: Multiple conditions for configured alarm query.
        :param pulumi.Input['AlertScheduleArgs'] schedule: schedule for alert.
        :param pulumi.Input[str] schedule_interval: Execution interval. 60 seconds minimum, such as 60s, 1h. Deprecated from 1.176.0+. use interval in schedule.
        :param pulumi.Input[str] schedule_type: Default FixedRate. No need to configure this parameter. Deprecated from 1.176.0+. use type in schedule.
        :param pulumi.Input[bool] send_resolved: when new alert is resolved, whether to notify, default is false.
        :param pulumi.Input[Sequence[pulumi.Input['AlertSeverityConfigurationArgs']]] severity_configurations: Severity configuration for new alert.
        :param pulumi.Input['AlertTemplateConfigurationArgs'] template_configuration: Template configuration for alert, when `type` is `tpl`.
        :param pulumi.Input[int] threshold: Evaluation threshold, alert will not fire until the number of triggers is reached. The default is 1.
        :param pulumi.Input[str] throttling: Notification interval, default is no interval. Support number + unit type, for example 60s, 1h, Deprecated from 1.161.0+.
        :param pulumi.Input[str] type: including FixedRate,Hourly,Daily,Weekly,Cron.
        :param pulumi.Input[str] version: The version of alert, new alert is 2.0.
        """
        if alert_description is not None:
            pulumi.set(__self__, "alert_description", alert_description)
        if alert_displayname is not None:
            pulumi.set(__self__, "alert_displayname", alert_displayname)
        if alert_name is not None:
            pulumi.set(__self__, "alert_name", alert_name)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if auto_annotation is not None:
            pulumi.set(__self__, "auto_annotation", auto_annotation)
        if condition is not None:
            warnings.warn("""Deprecated from 1.161.0+, use eval_condition in severity_configurations""", DeprecationWarning)
            pulumi.log.warn("""condition is deprecated: Deprecated from 1.161.0+, use eval_condition in severity_configurations""")
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if dashboard is not None:
            warnings.warn("""Deprecated from 1.161.0+, use dashboardId in query_list""", DeprecationWarning)
            pulumi.log.warn("""dashboard is deprecated: Deprecated from 1.161.0+, use dashboardId in query_list""")
        if dashboard is not None:
            pulumi.set(__self__, "dashboard", dashboard)
        if group_configuration is not None:
            pulumi.set(__self__, "group_configuration", group_configuration)
        if join_configurations is not None:
            pulumi.set(__self__, "join_configurations", join_configurations)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if mute_until is not None:
            pulumi.set(__self__, "mute_until", mute_until)
        if no_data_fire is not None:
            pulumi.set(__self__, "no_data_fire", no_data_fire)
        if no_data_severity is not None:
            pulumi.set(__self__, "no_data_severity", no_data_severity)
        if notification_lists is not None:
            warnings.warn("""Deprecated from 1.161.0+, use policy_configuration for notification""", DeprecationWarning)
            pulumi.log.warn("""notification_lists is deprecated: Deprecated from 1.161.0+, use policy_configuration for notification""")
        if notification_lists is not None:
            pulumi.set(__self__, "notification_lists", notification_lists)
        if notify_threshold is not None:
            warnings.warn("""Deprecated from 1.161.0+, use threshold""", DeprecationWarning)
            pulumi.log.warn("""notify_threshold is deprecated: Deprecated from 1.161.0+, use threshold""")
        if notify_threshold is not None:
            pulumi.set(__self__, "notify_threshold", notify_threshold)
        if policy_configuration is not None:
            pulumi.set(__self__, "policy_configuration", policy_configuration)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if query_lists is not None:
            pulumi.set(__self__, "query_lists", query_lists)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if schedule_interval is not None:
            warnings.warn("""Field 'schedule_interval' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""", DeprecationWarning)
            pulumi.log.warn("""schedule_interval is deprecated: Field 'schedule_interval' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""")
        if schedule_interval is not None:
            pulumi.set(__self__, "schedule_interval", schedule_interval)
        if schedule_type is not None:
            warnings.warn("""Field 'schedule_type' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""", DeprecationWarning)
            pulumi.log.warn("""schedule_type is deprecated: Field 'schedule_type' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""")
        if schedule_type is not None:
            pulumi.set(__self__, "schedule_type", schedule_type)
        if send_resolved is not None:
            pulumi.set(__self__, "send_resolved", send_resolved)
        if severity_configurations is not None:
            pulumi.set(__self__, "severity_configurations", severity_configurations)
        if template_configuration is not None:
            pulumi.set(__self__, "template_configuration", template_configuration)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if throttling is not None:
            warnings.warn("""Deprecated from 1.161.0+, use repeat_interval in policy_configuration""", DeprecationWarning)
            pulumi.log.warn("""throttling is deprecated: Deprecated from 1.161.0+, use repeat_interval in policy_configuration""")
        if throttling is not None:
            pulumi.set(__self__, "throttling", throttling)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="alertDescription")
    def alert_description(self) -> Optional[pulumi.Input[str]]:
        """
        Alert description.
        """
        return pulumi.get(self, "alert_description")

    @alert_description.setter
    def alert_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alert_description", value)

    @property
    @pulumi.getter(name="alertDisplayname")
    def alert_displayname(self) -> Optional[pulumi.Input[str]]:
        """
        Alert displayname.
        """
        return pulumi.get(self, "alert_displayname")

    @alert_displayname.setter
    def alert_displayname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alert_displayname", value)

    @property
    @pulumi.getter(name="alertName")
    def alert_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of logstore for configuring alarm service.
        """
        return pulumi.get(self, "alert_name")

    @alert_name.setter
    def alert_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alert_name", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertAnnotationArgs']]]]:
        """
        Alert template annotations.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertAnnotationArgs']]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="autoAnnotation")
    def auto_annotation(self) -> Optional[pulumi.Input[bool]]:
        """
        whether to add automatic annotation, default is false.
        """
        return pulumi.get(self, "auto_annotation")

    @auto_annotation.setter
    def auto_annotation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_annotation", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[str]]:
        """
        Join condition.
        """
        warnings.warn("""Deprecated from 1.161.0+, use eval_condition in severity_configurations""", DeprecationWarning)
        pulumi.log.warn("""condition is deprecated: Deprecated from 1.161.0+, use eval_condition in severity_configurations""")

        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def dashboard(self) -> Optional[pulumi.Input[str]]:
        warnings.warn("""Deprecated from 1.161.0+, use dashboardId in query_list""", DeprecationWarning)
        pulumi.log.warn("""dashboard is deprecated: Deprecated from 1.161.0+, use dashboardId in query_list""")

        return pulumi.get(self, "dashboard")

    @dashboard.setter
    def dashboard(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dashboard", value)

    @property
    @pulumi.getter(name="groupConfiguration")
    def group_configuration(self) -> Optional[pulumi.Input['AlertGroupConfigurationArgs']]:
        """
        Group configuration for new alert.
        """
        return pulumi.get(self, "group_configuration")

    @group_configuration.setter
    def group_configuration(self, value: Optional[pulumi.Input['AlertGroupConfigurationArgs']]):
        pulumi.set(self, "group_configuration", value)

    @property
    @pulumi.getter(name="joinConfigurations")
    def join_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertJoinConfigurationArgs']]]]:
        """
        Join configuration for different queries.
        """
        return pulumi.get(self, "join_configurations")

    @join_configurations.setter
    def join_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertJoinConfigurationArgs']]]]):
        pulumi.set(self, "join_configurations", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertLabelArgs']]]]:
        """
        Labels for new alert.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="muteUntil")
    def mute_until(self) -> Optional[pulumi.Input[int]]:
        """
        Timestamp, notifications before closing again.
        """
        return pulumi.get(self, "mute_until")

    @mute_until.setter
    def mute_until(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mute_until", value)

    @property
    @pulumi.getter(name="noDataFire")
    def no_data_fire(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch for whether new alert fires when no data happens, default is false.
        """
        return pulumi.get(self, "no_data_fire")

    @no_data_fire.setter
    def no_data_fire(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_data_fire", value)

    @property
    @pulumi.getter(name="noDataSeverity")
    def no_data_severity(self) -> Optional[pulumi.Input[int]]:
        """
        when no data happens, the severity of new alert.
        """
        return pulumi.get(self, "no_data_severity")

    @no_data_severity.setter
    def no_data_severity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "no_data_severity", value)

    @property
    @pulumi.getter(name="notificationLists")
    def notification_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertNotificationListArgs']]]]:
        """
        Alarm information notification list, Deprecated from 1.161.0+.
        """
        warnings.warn("""Deprecated from 1.161.0+, use policy_configuration for notification""", DeprecationWarning)
        pulumi.log.warn("""notification_lists is deprecated: Deprecated from 1.161.0+, use policy_configuration for notification""")

        return pulumi.get(self, "notification_lists")

    @notification_lists.setter
    def notification_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertNotificationListArgs']]]]):
        pulumi.set(self, "notification_lists", value)

    @property
    @pulumi.getter(name="notifyThreshold")
    def notify_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Notification threshold, which is not notified until the number of triggers is reached. The default is 1, Deprecated from 1.161.0+.
        """
        warnings.warn("""Deprecated from 1.161.0+, use threshold""", DeprecationWarning)
        pulumi.log.warn("""notify_threshold is deprecated: Deprecated from 1.161.0+, use threshold""")

        return pulumi.get(self, "notify_threshold")

    @notify_threshold.setter
    def notify_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "notify_threshold", value)

    @property
    @pulumi.getter(name="policyConfiguration")
    def policy_configuration(self) -> Optional[pulumi.Input['AlertPolicyConfigurationArgs']]:
        """
        Policy configuration for new alert.
        """
        return pulumi.get(self, "policy_configuration")

    @policy_configuration.setter
    def policy_configuration(self, value: Optional[pulumi.Input['AlertPolicyConfigurationArgs']]):
        pulumi.set(self, "policy_configuration", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="queryLists")
    def query_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertQueryListArgs']]]]:
        """
        Multiple conditions for configured alarm query.
        """
        return pulumi.get(self, "query_lists")

    @query_lists.setter
    def query_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertQueryListArgs']]]]):
        pulumi.set(self, "query_lists", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['AlertScheduleArgs']]:
        """
        schedule for alert.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['AlertScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="scheduleInterval")
    def schedule_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Execution interval. 60 seconds minimum, such as 60s, 1h. Deprecated from 1.176.0+. use interval in schedule.
        """
        warnings.warn("""Field 'schedule_interval' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""", DeprecationWarning)
        pulumi.log.warn("""schedule_interval is deprecated: Field 'schedule_interval' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""")

        return pulumi.get(self, "schedule_interval")

    @schedule_interval.setter
    def schedule_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_interval", value)

    @property
    @pulumi.getter(name="scheduleType")
    def schedule_type(self) -> Optional[pulumi.Input[str]]:
        """
        Default FixedRate. No need to configure this parameter. Deprecated from 1.176.0+. use type in schedule.
        """
        warnings.warn("""Field 'schedule_type' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""", DeprecationWarning)
        pulumi.log.warn("""schedule_type is deprecated: Field 'schedule_type' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""")

        return pulumi.get(self, "schedule_type")

    @schedule_type.setter
    def schedule_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_type", value)

    @property
    @pulumi.getter(name="sendResolved")
    def send_resolved(self) -> Optional[pulumi.Input[bool]]:
        """
        when new alert is resolved, whether to notify, default is false.
        """
        return pulumi.get(self, "send_resolved")

    @send_resolved.setter
    def send_resolved(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_resolved", value)

    @property
    @pulumi.getter(name="severityConfigurations")
    def severity_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertSeverityConfigurationArgs']]]]:
        """
        Severity configuration for new alert.
        """
        return pulumi.get(self, "severity_configurations")

    @severity_configurations.setter
    def severity_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertSeverityConfigurationArgs']]]]):
        pulumi.set(self, "severity_configurations", value)

    @property
    @pulumi.getter(name="templateConfiguration")
    def template_configuration(self) -> Optional[pulumi.Input['AlertTemplateConfigurationArgs']]:
        """
        Template configuration for alert, when `type` is `tpl`.
        """
        return pulumi.get(self, "template_configuration")

    @template_configuration.setter
    def template_configuration(self, value: Optional[pulumi.Input['AlertTemplateConfigurationArgs']]):
        pulumi.set(self, "template_configuration", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Evaluation threshold, alert will not fire until the number of triggers is reached. The default is 1.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter
    def throttling(self) -> Optional[pulumi.Input[str]]:
        """
        Notification interval, default is no interval. Support number + unit type, for example 60s, 1h, Deprecated from 1.161.0+.
        """
        warnings.warn("""Deprecated from 1.161.0+, use repeat_interval in policy_configuration""", DeprecationWarning)
        pulumi.log.warn("""throttling is deprecated: Deprecated from 1.161.0+, use repeat_interval in policy_configuration""")

        return pulumi.get(self, "throttling")

    @throttling.setter
    def throttling(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "throttling", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        including FixedRate,Hourly,Daily,Weekly,Cron.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of alert, new alert is 2.0.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class Alert(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_description: Optional[pulumi.Input[str]] = None,
                 alert_displayname: Optional[pulumi.Input[str]] = None,
                 alert_name: Optional[pulumi.Input[str]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertAnnotationArgs']]]]] = None,
                 auto_annotation: Optional[pulumi.Input[bool]] = None,
                 condition: Optional[pulumi.Input[str]] = None,
                 dashboard: Optional[pulumi.Input[str]] = None,
                 group_configuration: Optional[pulumi.Input[pulumi.InputType['AlertGroupConfigurationArgs']]] = None,
                 join_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertJoinConfigurationArgs']]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertLabelArgs']]]]] = None,
                 mute_until: Optional[pulumi.Input[int]] = None,
                 no_data_fire: Optional[pulumi.Input[bool]] = None,
                 no_data_severity: Optional[pulumi.Input[int]] = None,
                 notification_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertNotificationListArgs']]]]] = None,
                 notify_threshold: Optional[pulumi.Input[int]] = None,
                 policy_configuration: Optional[pulumi.Input[pulumi.InputType['AlertPolicyConfigurationArgs']]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 query_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertQueryListArgs']]]]] = None,
                 schedule: Optional[pulumi.Input[pulumi.InputType['AlertScheduleArgs']]] = None,
                 schedule_interval: Optional[pulumi.Input[str]] = None,
                 schedule_type: Optional[pulumi.Input[str]] = None,
                 send_resolved: Optional[pulumi.Input[bool]] = None,
                 severity_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertSeverityConfigurationArgs']]]]] = None,
                 template_configuration: Optional[pulumi.Input[pulumi.InputType['AlertTemplateConfigurationArgs']]] = None,
                 threshold: Optional[pulumi.Input[int]] = None,
                 throttling: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Log alert is a unit of log service, which is used to monitor and alert the user's logstore status information.
        Log Service enables you to configure alerts based on the charts in a dashboard to monitor the service status in real time.

        For information about SLS Alert and how to use it, see [SLS Alert Overview](https://www.alibabacloud.com/help/en/doc-detail/209202.html)

        > **NOTE:** Available in 1.78.0

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.RandomInteger("default",
            max=99999,
            min=10000)
        example_project = alicloud.log.Project("exampleProject", description="terraform-example")
        example_store = alicloud.log.Store("exampleStore",
            project=example_project.name,
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example_alert = alicloud.log.Alert("exampleAlert",
            project_name=example_project.name,
            alert_name="example-alert",
            alert_displayname="example-alert",
            condition="count> 100",
            dashboard="example-dashboard",
            schedule=alicloud.log.AlertScheduleArgs(
                type="FixedRate",
                interval="5m",
                hour=0,
                day_of_week=0,
                delay=0,
                run_immediately=False,
            ),
            query_lists=[alicloud.log.AlertQueryListArgs(
                logstore=example_store.name,
                chart_title="chart_title",
                start="-60s",
                end="20s",
                query="* AND aliyun",
            )],
            notification_lists=[
                alicloud.log.AlertNotificationListArgs(
                    type="SMS",
                    mobile_lists=[
                        "12345678",
                        "87654321",
                    ],
                    content="alert content",
                ),
                alicloud.log.AlertNotificationListArgs(
                    type="Email",
                    email_lists=[
                        "aliyun@alibaba-inc.com",
                        "tf-example@123.com",
                    ],
                    content="alert content",
                ),
                alicloud.log.AlertNotificationListArgs(
                    type="DingTalk",
                    service_uri="www.aliyun.com",
                    content="alert content",
                ),
            ])
        ```

        Basic Usage for new alert

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.RandomInteger("default",
            max=99999,
            min=10000)
        example_project = alicloud.log.Project("exampleProject", description="terraform-example")
        example_store = alicloud.log.Store("exampleStore",
            project=example_project.name,
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example_2 = alicloud.log.Alert("example-2",
            version="2.0",
            type="default",
            project_name=example_project.name,
            alert_name="example-alert",
            alert_displayname="example-alert",
            mute_until=1632486684,
            no_data_fire=False,
            no_data_severity=8,
            send_resolved=True,
            auto_annotation=True,
            dashboard="example-dashboard",
            schedule=alicloud.log.AlertScheduleArgs(
                type="FixedRate",
                interval="5m",
                hour=0,
                day_of_week=0,
                delay=0,
                run_immediately=False,
            ),
            query_lists=[
                alicloud.log.AlertQueryListArgs(
                    store=example_store.name,
                    store_type="log",
                    project=example_project.name,
                    region="cn-heyuan",
                    chart_title="chart_title",
                    start="-60s",
                    end="20s",
                    query="* AND aliyun | select count(1) as cnt",
                    power_sql_mode="auto",
                ),
                alicloud.log.AlertQueryListArgs(
                    store=example_store.name,
                    store_type="log",
                    project=example_project.name,
                    region="cn-heyuan",
                    chart_title="chart_title",
                    start="-60s",
                    end="20s",
                    query="error | select count(1) as error_cnt",
                    power_sql_mode="enable",
                ),
            ],
            labels=[alicloud.log.AlertLabelArgs(
                key="env",
                value="test",
            )],
            annotations=[
                alicloud.log.AlertAnnotationArgs(
                    key="title",
                    value="alert title",
                ),
                alicloud.log.AlertAnnotationArgs(
                    key="desc",
                    value="alert desc",
                ),
                alicloud.log.AlertAnnotationArgs(
                    key="test_key",
                    value="test value",
                ),
            ],
            group_configuration=alicloud.log.AlertGroupConfigurationArgs(
                type="custom",
                fields=["cnt"],
            ),
            policy_configuration=alicloud.log.AlertPolicyConfigurationArgs(
                alert_policy_id="sls.bultin",
                action_policy_id="sls_test_action",
                repeat_interval="4h",
            ),
            severity_configurations=[
                alicloud.log.AlertSeverityConfigurationArgs(
                    severity=8,
                    eval_condition={
                        "condition": "cnt > 3",
                        "count_condition": "__count__ > 3",
                    },
                ),
                alicloud.log.AlertSeverityConfigurationArgs(
                    severity=6,
                    eval_condition={
                        "condition": "",
                        "count_condition": "__count__ > 0",
                    },
                ),
                alicloud.log.AlertSeverityConfigurationArgs(
                    severity=2,
                    eval_condition={
                        "condition": "",
                        "count_condition": "",
                    },
                ),
            ],
            join_configurations=[alicloud.log.AlertJoinConfigurationArgs(
                type="cross_join",
                condition="",
            )])
        ```

        Basic Usage for alert template

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.RandomInteger("default",
            max=99999,
            min=10000)
        example_project = alicloud.log.Project("exampleProject", description="terraform-example")
        example_store = alicloud.log.Store("exampleStore",
            project=example_project.name,
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example_3 = alicloud.log.Alert("example-3",
            version="2.0",
            type="tpl",
            project_name=example_project.name,
            alert_name="example-alert",
            alert_displayname="example-alert",
            mute_until=1632486684,
            schedule=alicloud.log.AlertScheduleArgs(
                type="FixedRate",
                interval="5m",
                hour=0,
                day_of_week=0,
                delay=0,
                run_immediately=False,
            ),
            template_configuration=alicloud.log.AlertTemplateConfigurationArgs(
                id="sls.app.sls_ack.node.down",
                type="sys",
                lang="cn",
                annotations={},
                tokens={
                    "interval_minute": "5",
                    "default.action_policy": "sls.app.ack.builtin",
                    "default.severity": "6",
                    "sendResolved": "false",
                    "default.project": example_project.name,
                    "default.logstore": "k8s-event",
                    "default.repeatInterval": "4h",
                    "trigger_threshold": "1",
                    "default.clusterId": "example-cluster-id",
                },
            ))
        ```

        ## Import

        Log alert can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:log/alert:Alert example tf-log:tf-log-alert
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alert_description: Alert description.
        :param pulumi.Input[str] alert_displayname: Alert displayname.
        :param pulumi.Input[str] alert_name: Name of logstore for configuring alarm service.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertAnnotationArgs']]]] annotations: Alert template annotations.
        :param pulumi.Input[bool] auto_annotation: whether to add automatic annotation, default is false.
        :param pulumi.Input[str] condition: Join condition.
        :param pulumi.Input[pulumi.InputType['AlertGroupConfigurationArgs']] group_configuration: Group configuration for new alert.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertJoinConfigurationArgs']]]] join_configurations: Join configuration for different queries.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertLabelArgs']]]] labels: Labels for new alert.
        :param pulumi.Input[int] mute_until: Timestamp, notifications before closing again.
        :param pulumi.Input[bool] no_data_fire: Switch for whether new alert fires when no data happens, default is false.
        :param pulumi.Input[int] no_data_severity: when no data happens, the severity of new alert.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertNotificationListArgs']]]] notification_lists: Alarm information notification list, Deprecated from 1.161.0+.
        :param pulumi.Input[int] notify_threshold: Notification threshold, which is not notified until the number of triggers is reached. The default is 1, Deprecated from 1.161.0+.
        :param pulumi.Input[pulumi.InputType['AlertPolicyConfigurationArgs']] policy_configuration: Policy configuration for new alert.
        :param pulumi.Input[str] project_name: The project name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertQueryListArgs']]]] query_lists: Multiple conditions for configured alarm query.
        :param pulumi.Input[pulumi.InputType['AlertScheduleArgs']] schedule: schedule for alert.
        :param pulumi.Input[str] schedule_interval: Execution interval. 60 seconds minimum, such as 60s, 1h. Deprecated from 1.176.0+. use interval in schedule.
        :param pulumi.Input[str] schedule_type: Default FixedRate. No need to configure this parameter. Deprecated from 1.176.0+. use type in schedule.
        :param pulumi.Input[bool] send_resolved: when new alert is resolved, whether to notify, default is false.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertSeverityConfigurationArgs']]]] severity_configurations: Severity configuration for new alert.
        :param pulumi.Input[pulumi.InputType['AlertTemplateConfigurationArgs']] template_configuration: Template configuration for alert, when `type` is `tpl`.
        :param pulumi.Input[int] threshold: Evaluation threshold, alert will not fire until the number of triggers is reached. The default is 1.
        :param pulumi.Input[str] throttling: Notification interval, default is no interval. Support number + unit type, for example 60s, 1h, Deprecated from 1.161.0+.
        :param pulumi.Input[str] type: including FixedRate,Hourly,Daily,Weekly,Cron.
        :param pulumi.Input[str] version: The version of alert, new alert is 2.0.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Log alert is a unit of log service, which is used to monitor and alert the user's logstore status information.
        Log Service enables you to configure alerts based on the charts in a dashboard to monitor the service status in real time.

        For information about SLS Alert and how to use it, see [SLS Alert Overview](https://www.alibabacloud.com/help/en/doc-detail/209202.html)

        > **NOTE:** Available in 1.78.0

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.RandomInteger("default",
            max=99999,
            min=10000)
        example_project = alicloud.log.Project("exampleProject", description="terraform-example")
        example_store = alicloud.log.Store("exampleStore",
            project=example_project.name,
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example_alert = alicloud.log.Alert("exampleAlert",
            project_name=example_project.name,
            alert_name="example-alert",
            alert_displayname="example-alert",
            condition="count> 100",
            dashboard="example-dashboard",
            schedule=alicloud.log.AlertScheduleArgs(
                type="FixedRate",
                interval="5m",
                hour=0,
                day_of_week=0,
                delay=0,
                run_immediately=False,
            ),
            query_lists=[alicloud.log.AlertQueryListArgs(
                logstore=example_store.name,
                chart_title="chart_title",
                start="-60s",
                end="20s",
                query="* AND aliyun",
            )],
            notification_lists=[
                alicloud.log.AlertNotificationListArgs(
                    type="SMS",
                    mobile_lists=[
                        "12345678",
                        "87654321",
                    ],
                    content="alert content",
                ),
                alicloud.log.AlertNotificationListArgs(
                    type="Email",
                    email_lists=[
                        "aliyun@alibaba-inc.com",
                        "tf-example@123.com",
                    ],
                    content="alert content",
                ),
                alicloud.log.AlertNotificationListArgs(
                    type="DingTalk",
                    service_uri="www.aliyun.com",
                    content="alert content",
                ),
            ])
        ```

        Basic Usage for new alert

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.RandomInteger("default",
            max=99999,
            min=10000)
        example_project = alicloud.log.Project("exampleProject", description="terraform-example")
        example_store = alicloud.log.Store("exampleStore",
            project=example_project.name,
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example_2 = alicloud.log.Alert("example-2",
            version="2.0",
            type="default",
            project_name=example_project.name,
            alert_name="example-alert",
            alert_displayname="example-alert",
            mute_until=1632486684,
            no_data_fire=False,
            no_data_severity=8,
            send_resolved=True,
            auto_annotation=True,
            dashboard="example-dashboard",
            schedule=alicloud.log.AlertScheduleArgs(
                type="FixedRate",
                interval="5m",
                hour=0,
                day_of_week=0,
                delay=0,
                run_immediately=False,
            ),
            query_lists=[
                alicloud.log.AlertQueryListArgs(
                    store=example_store.name,
                    store_type="log",
                    project=example_project.name,
                    region="cn-heyuan",
                    chart_title="chart_title",
                    start="-60s",
                    end="20s",
                    query="* AND aliyun | select count(1) as cnt",
                    power_sql_mode="auto",
                ),
                alicloud.log.AlertQueryListArgs(
                    store=example_store.name,
                    store_type="log",
                    project=example_project.name,
                    region="cn-heyuan",
                    chart_title="chart_title",
                    start="-60s",
                    end="20s",
                    query="error | select count(1) as error_cnt",
                    power_sql_mode="enable",
                ),
            ],
            labels=[alicloud.log.AlertLabelArgs(
                key="env",
                value="test",
            )],
            annotations=[
                alicloud.log.AlertAnnotationArgs(
                    key="title",
                    value="alert title",
                ),
                alicloud.log.AlertAnnotationArgs(
                    key="desc",
                    value="alert desc",
                ),
                alicloud.log.AlertAnnotationArgs(
                    key="test_key",
                    value="test value",
                ),
            ],
            group_configuration=alicloud.log.AlertGroupConfigurationArgs(
                type="custom",
                fields=["cnt"],
            ),
            policy_configuration=alicloud.log.AlertPolicyConfigurationArgs(
                alert_policy_id="sls.bultin",
                action_policy_id="sls_test_action",
                repeat_interval="4h",
            ),
            severity_configurations=[
                alicloud.log.AlertSeverityConfigurationArgs(
                    severity=8,
                    eval_condition={
                        "condition": "cnt > 3",
                        "count_condition": "__count__ > 3",
                    },
                ),
                alicloud.log.AlertSeverityConfigurationArgs(
                    severity=6,
                    eval_condition={
                        "condition": "",
                        "count_condition": "__count__ > 0",
                    },
                ),
                alicloud.log.AlertSeverityConfigurationArgs(
                    severity=2,
                    eval_condition={
                        "condition": "",
                        "count_condition": "",
                    },
                ),
            ],
            join_configurations=[alicloud.log.AlertJoinConfigurationArgs(
                type="cross_join",
                condition="",
            )])
        ```

        Basic Usage for alert template

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.RandomInteger("default",
            max=99999,
            min=10000)
        example_project = alicloud.log.Project("exampleProject", description="terraform-example")
        example_store = alicloud.log.Store("exampleStore",
            project=example_project.name,
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example_3 = alicloud.log.Alert("example-3",
            version="2.0",
            type="tpl",
            project_name=example_project.name,
            alert_name="example-alert",
            alert_displayname="example-alert",
            mute_until=1632486684,
            schedule=alicloud.log.AlertScheduleArgs(
                type="FixedRate",
                interval="5m",
                hour=0,
                day_of_week=0,
                delay=0,
                run_immediately=False,
            ),
            template_configuration=alicloud.log.AlertTemplateConfigurationArgs(
                id="sls.app.sls_ack.node.down",
                type="sys",
                lang="cn",
                annotations={},
                tokens={
                    "interval_minute": "5",
                    "default.action_policy": "sls.app.ack.builtin",
                    "default.severity": "6",
                    "sendResolved": "false",
                    "default.project": example_project.name,
                    "default.logstore": "k8s-event",
                    "default.repeatInterval": "4h",
                    "trigger_threshold": "1",
                    "default.clusterId": "example-cluster-id",
                },
            ))
        ```

        ## Import

        Log alert can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:log/alert:Alert example tf-log:tf-log-alert
        ```

        :param str resource_name: The name of the resource.
        :param AlertArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_description: Optional[pulumi.Input[str]] = None,
                 alert_displayname: Optional[pulumi.Input[str]] = None,
                 alert_name: Optional[pulumi.Input[str]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertAnnotationArgs']]]]] = None,
                 auto_annotation: Optional[pulumi.Input[bool]] = None,
                 condition: Optional[pulumi.Input[str]] = None,
                 dashboard: Optional[pulumi.Input[str]] = None,
                 group_configuration: Optional[pulumi.Input[pulumi.InputType['AlertGroupConfigurationArgs']]] = None,
                 join_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertJoinConfigurationArgs']]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertLabelArgs']]]]] = None,
                 mute_until: Optional[pulumi.Input[int]] = None,
                 no_data_fire: Optional[pulumi.Input[bool]] = None,
                 no_data_severity: Optional[pulumi.Input[int]] = None,
                 notification_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertNotificationListArgs']]]]] = None,
                 notify_threshold: Optional[pulumi.Input[int]] = None,
                 policy_configuration: Optional[pulumi.Input[pulumi.InputType['AlertPolicyConfigurationArgs']]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 query_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertQueryListArgs']]]]] = None,
                 schedule: Optional[pulumi.Input[pulumi.InputType['AlertScheduleArgs']]] = None,
                 schedule_interval: Optional[pulumi.Input[str]] = None,
                 schedule_type: Optional[pulumi.Input[str]] = None,
                 send_resolved: Optional[pulumi.Input[bool]] = None,
                 severity_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertSeverityConfigurationArgs']]]]] = None,
                 template_configuration: Optional[pulumi.Input[pulumi.InputType['AlertTemplateConfigurationArgs']]] = None,
                 threshold: Optional[pulumi.Input[int]] = None,
                 throttling: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertArgs.__new__(AlertArgs)

            __props__.__dict__["alert_description"] = alert_description
            if alert_displayname is None and not opts.urn:
                raise TypeError("Missing required property 'alert_displayname'")
            __props__.__dict__["alert_displayname"] = alert_displayname
            if alert_name is None and not opts.urn:
                raise TypeError("Missing required property 'alert_name'")
            __props__.__dict__["alert_name"] = alert_name
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["auto_annotation"] = auto_annotation
            __props__.__dict__["condition"] = condition
            __props__.__dict__["dashboard"] = dashboard
            __props__.__dict__["group_configuration"] = group_configuration
            __props__.__dict__["join_configurations"] = join_configurations
            __props__.__dict__["labels"] = labels
            __props__.__dict__["mute_until"] = mute_until
            __props__.__dict__["no_data_fire"] = no_data_fire
            __props__.__dict__["no_data_severity"] = no_data_severity
            __props__.__dict__["notification_lists"] = notification_lists
            __props__.__dict__["notify_threshold"] = notify_threshold
            __props__.__dict__["policy_configuration"] = policy_configuration
            if project_name is None and not opts.urn:
                raise TypeError("Missing required property 'project_name'")
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["query_lists"] = query_lists
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["schedule_interval"] = schedule_interval
            __props__.__dict__["schedule_type"] = schedule_type
            __props__.__dict__["send_resolved"] = send_resolved
            __props__.__dict__["severity_configurations"] = severity_configurations
            __props__.__dict__["template_configuration"] = template_configuration
            __props__.__dict__["threshold"] = threshold
            __props__.__dict__["throttling"] = throttling
            __props__.__dict__["type"] = type
            __props__.__dict__["version"] = version
        super(Alert, __self__).__init__(
            'alicloud:log/alert:Alert',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alert_description: Optional[pulumi.Input[str]] = None,
            alert_displayname: Optional[pulumi.Input[str]] = None,
            alert_name: Optional[pulumi.Input[str]] = None,
            annotations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertAnnotationArgs']]]]] = None,
            auto_annotation: Optional[pulumi.Input[bool]] = None,
            condition: Optional[pulumi.Input[str]] = None,
            dashboard: Optional[pulumi.Input[str]] = None,
            group_configuration: Optional[pulumi.Input[pulumi.InputType['AlertGroupConfigurationArgs']]] = None,
            join_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertJoinConfigurationArgs']]]]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertLabelArgs']]]]] = None,
            mute_until: Optional[pulumi.Input[int]] = None,
            no_data_fire: Optional[pulumi.Input[bool]] = None,
            no_data_severity: Optional[pulumi.Input[int]] = None,
            notification_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertNotificationListArgs']]]]] = None,
            notify_threshold: Optional[pulumi.Input[int]] = None,
            policy_configuration: Optional[pulumi.Input[pulumi.InputType['AlertPolicyConfigurationArgs']]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            query_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertQueryListArgs']]]]] = None,
            schedule: Optional[pulumi.Input[pulumi.InputType['AlertScheduleArgs']]] = None,
            schedule_interval: Optional[pulumi.Input[str]] = None,
            schedule_type: Optional[pulumi.Input[str]] = None,
            send_resolved: Optional[pulumi.Input[bool]] = None,
            severity_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertSeverityConfigurationArgs']]]]] = None,
            template_configuration: Optional[pulumi.Input[pulumi.InputType['AlertTemplateConfigurationArgs']]] = None,
            threshold: Optional[pulumi.Input[int]] = None,
            throttling: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'Alert':
        """
        Get an existing Alert resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alert_description: Alert description.
        :param pulumi.Input[str] alert_displayname: Alert displayname.
        :param pulumi.Input[str] alert_name: Name of logstore for configuring alarm service.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertAnnotationArgs']]]] annotations: Alert template annotations.
        :param pulumi.Input[bool] auto_annotation: whether to add automatic annotation, default is false.
        :param pulumi.Input[str] condition: Join condition.
        :param pulumi.Input[pulumi.InputType['AlertGroupConfigurationArgs']] group_configuration: Group configuration for new alert.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertJoinConfigurationArgs']]]] join_configurations: Join configuration for different queries.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertLabelArgs']]]] labels: Labels for new alert.
        :param pulumi.Input[int] mute_until: Timestamp, notifications before closing again.
        :param pulumi.Input[bool] no_data_fire: Switch for whether new alert fires when no data happens, default is false.
        :param pulumi.Input[int] no_data_severity: when no data happens, the severity of new alert.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertNotificationListArgs']]]] notification_lists: Alarm information notification list, Deprecated from 1.161.0+.
        :param pulumi.Input[int] notify_threshold: Notification threshold, which is not notified until the number of triggers is reached. The default is 1, Deprecated from 1.161.0+.
        :param pulumi.Input[pulumi.InputType['AlertPolicyConfigurationArgs']] policy_configuration: Policy configuration for new alert.
        :param pulumi.Input[str] project_name: The project name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertQueryListArgs']]]] query_lists: Multiple conditions for configured alarm query.
        :param pulumi.Input[pulumi.InputType['AlertScheduleArgs']] schedule: schedule for alert.
        :param pulumi.Input[str] schedule_interval: Execution interval. 60 seconds minimum, such as 60s, 1h. Deprecated from 1.176.0+. use interval in schedule.
        :param pulumi.Input[str] schedule_type: Default FixedRate. No need to configure this parameter. Deprecated from 1.176.0+. use type in schedule.
        :param pulumi.Input[bool] send_resolved: when new alert is resolved, whether to notify, default is false.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertSeverityConfigurationArgs']]]] severity_configurations: Severity configuration for new alert.
        :param pulumi.Input[pulumi.InputType['AlertTemplateConfigurationArgs']] template_configuration: Template configuration for alert, when `type` is `tpl`.
        :param pulumi.Input[int] threshold: Evaluation threshold, alert will not fire until the number of triggers is reached. The default is 1.
        :param pulumi.Input[str] throttling: Notification interval, default is no interval. Support number + unit type, for example 60s, 1h, Deprecated from 1.161.0+.
        :param pulumi.Input[str] type: including FixedRate,Hourly,Daily,Weekly,Cron.
        :param pulumi.Input[str] version: The version of alert, new alert is 2.0.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertState.__new__(_AlertState)

        __props__.__dict__["alert_description"] = alert_description
        __props__.__dict__["alert_displayname"] = alert_displayname
        __props__.__dict__["alert_name"] = alert_name
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["auto_annotation"] = auto_annotation
        __props__.__dict__["condition"] = condition
        __props__.__dict__["dashboard"] = dashboard
        __props__.__dict__["group_configuration"] = group_configuration
        __props__.__dict__["join_configurations"] = join_configurations
        __props__.__dict__["labels"] = labels
        __props__.__dict__["mute_until"] = mute_until
        __props__.__dict__["no_data_fire"] = no_data_fire
        __props__.__dict__["no_data_severity"] = no_data_severity
        __props__.__dict__["notification_lists"] = notification_lists
        __props__.__dict__["notify_threshold"] = notify_threshold
        __props__.__dict__["policy_configuration"] = policy_configuration
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["query_lists"] = query_lists
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["schedule_interval"] = schedule_interval
        __props__.__dict__["schedule_type"] = schedule_type
        __props__.__dict__["send_resolved"] = send_resolved
        __props__.__dict__["severity_configurations"] = severity_configurations
        __props__.__dict__["template_configuration"] = template_configuration
        __props__.__dict__["threshold"] = threshold
        __props__.__dict__["throttling"] = throttling
        __props__.__dict__["type"] = type
        __props__.__dict__["version"] = version
        return Alert(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alertDescription")
    def alert_description(self) -> pulumi.Output[Optional[str]]:
        """
        Alert description.
        """
        return pulumi.get(self, "alert_description")

    @property
    @pulumi.getter(name="alertDisplayname")
    def alert_displayname(self) -> pulumi.Output[str]:
        """
        Alert displayname.
        """
        return pulumi.get(self, "alert_displayname")

    @property
    @pulumi.getter(name="alertName")
    def alert_name(self) -> pulumi.Output[str]:
        """
        Name of logstore for configuring alarm service.
        """
        return pulumi.get(self, "alert_name")

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Sequence['outputs.AlertAnnotation']]]:
        """
        Alert template annotations.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="autoAnnotation")
    def auto_annotation(self) -> pulumi.Output[Optional[bool]]:
        """
        whether to add automatic annotation, default is false.
        """
        return pulumi.get(self, "auto_annotation")

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Output[Optional[str]]:
        """
        Join condition.
        """
        warnings.warn("""Deprecated from 1.161.0+, use eval_condition in severity_configurations""", DeprecationWarning)
        pulumi.log.warn("""condition is deprecated: Deprecated from 1.161.0+, use eval_condition in severity_configurations""")

        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def dashboard(self) -> pulumi.Output[Optional[str]]:
        warnings.warn("""Deprecated from 1.161.0+, use dashboardId in query_list""", DeprecationWarning)
        pulumi.log.warn("""dashboard is deprecated: Deprecated from 1.161.0+, use dashboardId in query_list""")

        return pulumi.get(self, "dashboard")

    @property
    @pulumi.getter(name="groupConfiguration")
    def group_configuration(self) -> pulumi.Output[Optional['outputs.AlertGroupConfiguration']]:
        """
        Group configuration for new alert.
        """
        return pulumi.get(self, "group_configuration")

    @property
    @pulumi.getter(name="joinConfigurations")
    def join_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.AlertJoinConfiguration']]]:
        """
        Join configuration for different queries.
        """
        return pulumi.get(self, "join_configurations")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence['outputs.AlertLabel']]]:
        """
        Labels for new alert.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="muteUntil")
    def mute_until(self) -> pulumi.Output[int]:
        """
        Timestamp, notifications before closing again.
        """
        return pulumi.get(self, "mute_until")

    @property
    @pulumi.getter(name="noDataFire")
    def no_data_fire(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch for whether new alert fires when no data happens, default is false.
        """
        return pulumi.get(self, "no_data_fire")

    @property
    @pulumi.getter(name="noDataSeverity")
    def no_data_severity(self) -> pulumi.Output[Optional[int]]:
        """
        when no data happens, the severity of new alert.
        """
        return pulumi.get(self, "no_data_severity")

    @property
    @pulumi.getter(name="notificationLists")
    def notification_lists(self) -> pulumi.Output[Optional[Sequence['outputs.AlertNotificationList']]]:
        """
        Alarm information notification list, Deprecated from 1.161.0+.
        """
        warnings.warn("""Deprecated from 1.161.0+, use policy_configuration for notification""", DeprecationWarning)
        pulumi.log.warn("""notification_lists is deprecated: Deprecated from 1.161.0+, use policy_configuration for notification""")

        return pulumi.get(self, "notification_lists")

    @property
    @pulumi.getter(name="notifyThreshold")
    def notify_threshold(self) -> pulumi.Output[Optional[int]]:
        """
        Notification threshold, which is not notified until the number of triggers is reached. The default is 1, Deprecated from 1.161.0+.
        """
        warnings.warn("""Deprecated from 1.161.0+, use threshold""", DeprecationWarning)
        pulumi.log.warn("""notify_threshold is deprecated: Deprecated from 1.161.0+, use threshold""")

        return pulumi.get(self, "notify_threshold")

    @property
    @pulumi.getter(name="policyConfiguration")
    def policy_configuration(self) -> pulumi.Output[Optional['outputs.AlertPolicyConfiguration']]:
        """
        Policy configuration for new alert.
        """
        return pulumi.get(self, "policy_configuration")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        The project name.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="queryLists")
    def query_lists(self) -> pulumi.Output[Optional[Sequence['outputs.AlertQueryList']]]:
        """
        Multiple conditions for configured alarm query.
        """
        return pulumi.get(self, "query_lists")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional['outputs.AlertSchedule']]:
        """
        schedule for alert.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="scheduleInterval")
    def schedule_interval(self) -> pulumi.Output[str]:
        """
        Execution interval. 60 seconds minimum, such as 60s, 1h. Deprecated from 1.176.0+. use interval in schedule.
        """
        warnings.warn("""Field 'schedule_interval' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""", DeprecationWarning)
        pulumi.log.warn("""schedule_interval is deprecated: Field 'schedule_interval' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""")

        return pulumi.get(self, "schedule_interval")

    @property
    @pulumi.getter(name="scheduleType")
    def schedule_type(self) -> pulumi.Output[str]:
        """
        Default FixedRate. No need to configure this parameter. Deprecated from 1.176.0+. use type in schedule.
        """
        warnings.warn("""Field 'schedule_type' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""", DeprecationWarning)
        pulumi.log.warn("""schedule_type is deprecated: Field 'schedule_type' has been deprecated from provider version 1.176.0. New field 'schedule' instead.""")

        return pulumi.get(self, "schedule_type")

    @property
    @pulumi.getter(name="sendResolved")
    def send_resolved(self) -> pulumi.Output[Optional[bool]]:
        """
        when new alert is resolved, whether to notify, default is false.
        """
        return pulumi.get(self, "send_resolved")

    @property
    @pulumi.getter(name="severityConfigurations")
    def severity_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.AlertSeverityConfiguration']]]:
        """
        Severity configuration for new alert.
        """
        return pulumi.get(self, "severity_configurations")

    @property
    @pulumi.getter(name="templateConfiguration")
    def template_configuration(self) -> pulumi.Output[Optional['outputs.AlertTemplateConfiguration']]:
        """
        Template configuration for alert, when `type` is `tpl`.
        """
        return pulumi.get(self, "template_configuration")

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Output[int]:
        """
        Evaluation threshold, alert will not fire until the number of triggers is reached. The default is 1.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def throttling(self) -> pulumi.Output[Optional[str]]:
        """
        Notification interval, default is no interval. Support number + unit type, for example 60s, 1h, Deprecated from 1.161.0+.
        """
        warnings.warn("""Deprecated from 1.161.0+, use repeat_interval in policy_configuration""", DeprecationWarning)
        pulumi.log.warn("""throttling is deprecated: Deprecated from 1.161.0+, use repeat_interval in policy_configuration""")

        return pulumi.get(self, "throttling")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        including FixedRate,Hourly,Daily,Weekly,Cron.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[str]]:
        """
        The version of alert, new alert is 2.0.
        """
        return pulumi.get(self, "version")

