# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OssExportArgs', 'OssExport']

@pulumi.input_type
class OssExportArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 buffer_interval: pulumi.Input[int],
                 buffer_size: pulumi.Input[int],
                 content_type: pulumi.Input[str],
                 export_name: pulumi.Input[str],
                 logstore_name: pulumi.Input[str],
                 path_format: pulumi.Input[str],
                 project_name: pulumi.Input[str],
                 time_zone: pulumi.Input[str],
                 compress_type: Optional[pulumi.Input[str]] = None,
                 config_columns: Optional[pulumi.Input[Sequence[pulumi.Input['OssExportConfigColumnArgs']]]] = None,
                 csv_config_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 csv_config_delimiter: Optional[pulumi.Input[str]] = None,
                 csv_config_escape: Optional[pulumi.Input[str]] = None,
                 csv_config_header: Optional[pulumi.Input[bool]] = None,
                 csv_config_linefeed: Optional[pulumi.Input[str]] = None,
                 csv_config_null: Optional[pulumi.Input[str]] = None,
                 csv_config_quote: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 from_time: Optional[pulumi.Input[int]] = None,
                 json_enable_tag: Optional[pulumi.Input[bool]] = None,
                 log_read_role_arn: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 suffix: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a OssExport resource.
        :param pulumi.Input[str] bucket: The name of the oss bucket.
        :param pulumi.Input[int] buffer_interval: How often is it delivered every interval.
        :param pulumi.Input[int] buffer_size: Automatically control the creation interval of delivery tasks and set the upper limit of an OSS object size (calculated in uncompressed), unit: `MB`.
        :param pulumi.Input[str] content_type: Storage format, only supports three types: `json`, `parquet`, `orc`, `csv`.
               **According to the different format, please select the following parameters**
        :param pulumi.Input[str] export_name: Delivery configuration name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
        :param pulumi.Input[str] logstore_name: The name of the log logstore.
        :param pulumi.Input[str] path_format: The OSS Bucket directory is dynamically generated according to the creation time of the export task, it cannot start with a forward slash `/`, the default value is `%Y/%m/%d/%H/%M`.
        :param pulumi.Input[str] project_name: The name of the log project. It is the only in one Alicloud account.
        :param pulumi.Input[str] time_zone: This time zone that is used to format the time, `+0800` e.g.
        :param pulumi.Input[str] compress_type: OSS data storage compression method, support: `none`, `snappy`, `zstd`, `gzip`. Among them, none means that the original data is not compressed, and snappy means that the data is compressed using the snappy algorithm, which can reduce the storage space usage of the `OSS Bucket`.
        :param pulumi.Input[Sequence[pulumi.Input['OssExportConfigColumnArgs']]] config_columns: Configure columns when `content_type` is `parquet` or `orc`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] csv_config_columns: Field configuration in csv content_type.
        :param pulumi.Input[str] csv_config_delimiter: Separator configuration in csv content_type.
        :param pulumi.Input[str] csv_config_escape: escape in csv content_type.
        :param pulumi.Input[bool] csv_config_header: Indicates whether to write the field name to the CSV file, the default value is `false`.
        :param pulumi.Input[str] csv_config_linefeed: lineFeed in csv content_type.
        :param pulumi.Input[str] csv_config_null: Invalid field content in csv content_type.
        :param pulumi.Input[str] csv_config_quote: Escape character in csv content_type.
        :param pulumi.Input[str] display_name: The display name for oss export.
        :param pulumi.Input[int] from_time: The log from when to export to oss.
        :param pulumi.Input[bool] json_enable_tag: Whether to deliver the label when `content_type` = `json`.
        :param pulumi.Input[str] log_read_role_arn: Used for logstore reading, the role should have log read policy, such as `acs:ram::13234:role/logrole`, if `log_read_role_arn` is not set, `role_arn` is used to read logstore.
        :param pulumi.Input[str] prefix: The data synchronized from Log Service to OSS will be stored in this directory of Bucket.
        :param pulumi.Input[str] role_arn: Used to write to oss bucket, the OSS Bucket owner creates the role mark which has the oss bucket write policy, such as `acs:ram::13234:role/logrole`.
        :param pulumi.Input[str] suffix: The suffix for the objects in which the shipped data is stored.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "buffer_interval", buffer_interval)
        pulumi.set(__self__, "buffer_size", buffer_size)
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "export_name", export_name)
        pulumi.set(__self__, "logstore_name", logstore_name)
        pulumi.set(__self__, "path_format", path_format)
        pulumi.set(__self__, "project_name", project_name)
        pulumi.set(__self__, "time_zone", time_zone)
        if compress_type is not None:
            pulumi.set(__self__, "compress_type", compress_type)
        if config_columns is not None:
            pulumi.set(__self__, "config_columns", config_columns)
        if csv_config_columns is not None:
            pulumi.set(__self__, "csv_config_columns", csv_config_columns)
        if csv_config_delimiter is not None:
            pulumi.set(__self__, "csv_config_delimiter", csv_config_delimiter)
        if csv_config_escape is not None:
            pulumi.set(__self__, "csv_config_escape", csv_config_escape)
        if csv_config_header is not None:
            pulumi.set(__self__, "csv_config_header", csv_config_header)
        if csv_config_linefeed is not None:
            pulumi.set(__self__, "csv_config_linefeed", csv_config_linefeed)
        if csv_config_null is not None:
            pulumi.set(__self__, "csv_config_null", csv_config_null)
        if csv_config_quote is not None:
            pulumi.set(__self__, "csv_config_quote", csv_config_quote)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if from_time is not None:
            pulumi.set(__self__, "from_time", from_time)
        if json_enable_tag is not None:
            pulumi.set(__self__, "json_enable_tag", json_enable_tag)
        if log_read_role_arn is not None:
            pulumi.set(__self__, "log_read_role_arn", log_read_role_arn)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if suffix is not None:
            pulumi.set(__self__, "suffix", suffix)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        The name of the oss bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="bufferInterval")
    def buffer_interval(self) -> pulumi.Input[int]:
        """
        How often is it delivered every interval.
        """
        return pulumi.get(self, "buffer_interval")

    @buffer_interval.setter
    def buffer_interval(self, value: pulumi.Input[int]):
        pulumi.set(self, "buffer_interval", value)

    @property
    @pulumi.getter(name="bufferSize")
    def buffer_size(self) -> pulumi.Input[int]:
        """
        Automatically control the creation interval of delivery tasks and set the upper limit of an OSS object size (calculated in uncompressed), unit: `MB`.
        """
        return pulumi.get(self, "buffer_size")

    @buffer_size.setter
    def buffer_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "buffer_size", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Input[str]:
        """
        Storage format, only supports three types: `json`, `parquet`, `orc`, `csv`.
        **According to the different format, please select the following parameters**
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="exportName")
    def export_name(self) -> pulumi.Input[str]:
        """
        Delivery configuration name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
        """
        return pulumi.get(self, "export_name")

    @export_name.setter
    def export_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "export_name", value)

    @property
    @pulumi.getter(name="logstoreName")
    def logstore_name(self) -> pulumi.Input[str]:
        """
        The name of the log logstore.
        """
        return pulumi.get(self, "logstore_name")

    @logstore_name.setter
    def logstore_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "logstore_name", value)

    @property
    @pulumi.getter(name="pathFormat")
    def path_format(self) -> pulumi.Input[str]:
        """
        The OSS Bucket directory is dynamically generated according to the creation time of the export task, it cannot start with a forward slash `/`, the default value is `%Y/%m/%d/%H/%M`.
        """
        return pulumi.get(self, "path_format")

    @path_format.setter
    def path_format(self, value: pulumi.Input[str]):
        pulumi.set(self, "path_format", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Input[str]:
        """
        The name of the log project. It is the only in one Alicloud account.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Input[str]:
        """
        This time zone that is used to format the time, `+0800` e.g.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="compressType")
    def compress_type(self) -> Optional[pulumi.Input[str]]:
        """
        OSS data storage compression method, support: `none`, `snappy`, `zstd`, `gzip`. Among them, none means that the original data is not compressed, and snappy means that the data is compressed using the snappy algorithm, which can reduce the storage space usage of the `OSS Bucket`.
        """
        return pulumi.get(self, "compress_type")

    @compress_type.setter
    def compress_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compress_type", value)

    @property
    @pulumi.getter(name="configColumns")
    def config_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OssExportConfigColumnArgs']]]]:
        """
        Configure columns when `content_type` is `parquet` or `orc`.
        """
        return pulumi.get(self, "config_columns")

    @config_columns.setter
    def config_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OssExportConfigColumnArgs']]]]):
        pulumi.set(self, "config_columns", value)

    @property
    @pulumi.getter(name="csvConfigColumns")
    def csv_config_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Field configuration in csv content_type.
        """
        return pulumi.get(self, "csv_config_columns")

    @csv_config_columns.setter
    def csv_config_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "csv_config_columns", value)

    @property
    @pulumi.getter(name="csvConfigDelimiter")
    def csv_config_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        Separator configuration in csv content_type.
        """
        return pulumi.get(self, "csv_config_delimiter")

    @csv_config_delimiter.setter
    def csv_config_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csv_config_delimiter", value)

    @property
    @pulumi.getter(name="csvConfigEscape")
    def csv_config_escape(self) -> Optional[pulumi.Input[str]]:
        """
        escape in csv content_type.
        """
        return pulumi.get(self, "csv_config_escape")

    @csv_config_escape.setter
    def csv_config_escape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csv_config_escape", value)

    @property
    @pulumi.getter(name="csvConfigHeader")
    def csv_config_header(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to write the field name to the CSV file, the default value is `false`.
        """
        return pulumi.get(self, "csv_config_header")

    @csv_config_header.setter
    def csv_config_header(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "csv_config_header", value)

    @property
    @pulumi.getter(name="csvConfigLinefeed")
    def csv_config_linefeed(self) -> Optional[pulumi.Input[str]]:
        """
        lineFeed in csv content_type.
        """
        return pulumi.get(self, "csv_config_linefeed")

    @csv_config_linefeed.setter
    def csv_config_linefeed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csv_config_linefeed", value)

    @property
    @pulumi.getter(name="csvConfigNull")
    def csv_config_null(self) -> Optional[pulumi.Input[str]]:
        """
        Invalid field content in csv content_type.
        """
        return pulumi.get(self, "csv_config_null")

    @csv_config_null.setter
    def csv_config_null(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csv_config_null", value)

    @property
    @pulumi.getter(name="csvConfigQuote")
    def csv_config_quote(self) -> Optional[pulumi.Input[str]]:
        """
        Escape character in csv content_type.
        """
        return pulumi.get(self, "csv_config_quote")

    @csv_config_quote.setter
    def csv_config_quote(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csv_config_quote", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name for oss export.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="fromTime")
    def from_time(self) -> Optional[pulumi.Input[int]]:
        """
        The log from when to export to oss.
        """
        return pulumi.get(self, "from_time")

    @from_time.setter
    def from_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "from_time", value)

    @property
    @pulumi.getter(name="jsonEnableTag")
    def json_enable_tag(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to deliver the label when `content_type` = `json`.
        """
        return pulumi.get(self, "json_enable_tag")

    @json_enable_tag.setter
    def json_enable_tag(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "json_enable_tag", value)

    @property
    @pulumi.getter(name="logReadRoleArn")
    def log_read_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Used for logstore reading, the role should have log read policy, such as `acs:ram::13234:role/logrole`, if `log_read_role_arn` is not set, `role_arn` is used to read logstore.
        """
        return pulumi.get(self, "log_read_role_arn")

    @log_read_role_arn.setter
    def log_read_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_read_role_arn", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The data synchronized from Log Service to OSS will be stored in this directory of Bucket.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Used to write to oss bucket, the OSS Bucket owner creates the role mark which has the oss bucket write policy, such as `acs:ram::13234:role/logrole`.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def suffix(self) -> Optional[pulumi.Input[str]]:
        """
        The suffix for the objects in which the shipped data is stored.
        """
        return pulumi.get(self, "suffix")

    @suffix.setter
    def suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "suffix", value)


@pulumi.input_type
class _OssExportState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 buffer_interval: Optional[pulumi.Input[int]] = None,
                 buffer_size: Optional[pulumi.Input[int]] = None,
                 compress_type: Optional[pulumi.Input[str]] = None,
                 config_columns: Optional[pulumi.Input[Sequence[pulumi.Input['OssExportConfigColumnArgs']]]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 csv_config_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 csv_config_delimiter: Optional[pulumi.Input[str]] = None,
                 csv_config_escape: Optional[pulumi.Input[str]] = None,
                 csv_config_header: Optional[pulumi.Input[bool]] = None,
                 csv_config_linefeed: Optional[pulumi.Input[str]] = None,
                 csv_config_null: Optional[pulumi.Input[str]] = None,
                 csv_config_quote: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 export_name: Optional[pulumi.Input[str]] = None,
                 from_time: Optional[pulumi.Input[int]] = None,
                 json_enable_tag: Optional[pulumi.Input[bool]] = None,
                 log_read_role_arn: Optional[pulumi.Input[str]] = None,
                 logstore_name: Optional[pulumi.Input[str]] = None,
                 path_format: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 suffix: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OssExport resources.
        :param pulumi.Input[str] bucket: The name of the oss bucket.
        :param pulumi.Input[int] buffer_interval: How often is it delivered every interval.
        :param pulumi.Input[int] buffer_size: Automatically control the creation interval of delivery tasks and set the upper limit of an OSS object size (calculated in uncompressed), unit: `MB`.
        :param pulumi.Input[str] compress_type: OSS data storage compression method, support: `none`, `snappy`, `zstd`, `gzip`. Among them, none means that the original data is not compressed, and snappy means that the data is compressed using the snappy algorithm, which can reduce the storage space usage of the `OSS Bucket`.
        :param pulumi.Input[Sequence[pulumi.Input['OssExportConfigColumnArgs']]] config_columns: Configure columns when `content_type` is `parquet` or `orc`.
        :param pulumi.Input[str] content_type: Storage format, only supports three types: `json`, `parquet`, `orc`, `csv`.
               **According to the different format, please select the following parameters**
        :param pulumi.Input[Sequence[pulumi.Input[str]]] csv_config_columns: Field configuration in csv content_type.
        :param pulumi.Input[str] csv_config_delimiter: Separator configuration in csv content_type.
        :param pulumi.Input[str] csv_config_escape: escape in csv content_type.
        :param pulumi.Input[bool] csv_config_header: Indicates whether to write the field name to the CSV file, the default value is `false`.
        :param pulumi.Input[str] csv_config_linefeed: lineFeed in csv content_type.
        :param pulumi.Input[str] csv_config_null: Invalid field content in csv content_type.
        :param pulumi.Input[str] csv_config_quote: Escape character in csv content_type.
        :param pulumi.Input[str] display_name: The display name for oss export.
        :param pulumi.Input[str] export_name: Delivery configuration name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
        :param pulumi.Input[int] from_time: The log from when to export to oss.
        :param pulumi.Input[bool] json_enable_tag: Whether to deliver the label when `content_type` = `json`.
        :param pulumi.Input[str] log_read_role_arn: Used for logstore reading, the role should have log read policy, such as `acs:ram::13234:role/logrole`, if `log_read_role_arn` is not set, `role_arn` is used to read logstore.
        :param pulumi.Input[str] logstore_name: The name of the log logstore.
        :param pulumi.Input[str] path_format: The OSS Bucket directory is dynamically generated according to the creation time of the export task, it cannot start with a forward slash `/`, the default value is `%Y/%m/%d/%H/%M`.
        :param pulumi.Input[str] prefix: The data synchronized from Log Service to OSS will be stored in this directory of Bucket.
        :param pulumi.Input[str] project_name: The name of the log project. It is the only in one Alicloud account.
        :param pulumi.Input[str] role_arn: Used to write to oss bucket, the OSS Bucket owner creates the role mark which has the oss bucket write policy, such as `acs:ram::13234:role/logrole`.
        :param pulumi.Input[str] suffix: The suffix for the objects in which the shipped data is stored.
        :param pulumi.Input[str] time_zone: This time zone that is used to format the time, `+0800` e.g.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if buffer_interval is not None:
            pulumi.set(__self__, "buffer_interval", buffer_interval)
        if buffer_size is not None:
            pulumi.set(__self__, "buffer_size", buffer_size)
        if compress_type is not None:
            pulumi.set(__self__, "compress_type", compress_type)
        if config_columns is not None:
            pulumi.set(__self__, "config_columns", config_columns)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if csv_config_columns is not None:
            pulumi.set(__self__, "csv_config_columns", csv_config_columns)
        if csv_config_delimiter is not None:
            pulumi.set(__self__, "csv_config_delimiter", csv_config_delimiter)
        if csv_config_escape is not None:
            pulumi.set(__self__, "csv_config_escape", csv_config_escape)
        if csv_config_header is not None:
            pulumi.set(__self__, "csv_config_header", csv_config_header)
        if csv_config_linefeed is not None:
            pulumi.set(__self__, "csv_config_linefeed", csv_config_linefeed)
        if csv_config_null is not None:
            pulumi.set(__self__, "csv_config_null", csv_config_null)
        if csv_config_quote is not None:
            pulumi.set(__self__, "csv_config_quote", csv_config_quote)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if export_name is not None:
            pulumi.set(__self__, "export_name", export_name)
        if from_time is not None:
            pulumi.set(__self__, "from_time", from_time)
        if json_enable_tag is not None:
            pulumi.set(__self__, "json_enable_tag", json_enable_tag)
        if log_read_role_arn is not None:
            pulumi.set(__self__, "log_read_role_arn", log_read_role_arn)
        if logstore_name is not None:
            pulumi.set(__self__, "logstore_name", logstore_name)
        if path_format is not None:
            pulumi.set(__self__, "path_format", path_format)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if suffix is not None:
            pulumi.set(__self__, "suffix", suffix)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the oss bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="bufferInterval")
    def buffer_interval(self) -> Optional[pulumi.Input[int]]:
        """
        How often is it delivered every interval.
        """
        return pulumi.get(self, "buffer_interval")

    @buffer_interval.setter
    def buffer_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "buffer_interval", value)

    @property
    @pulumi.getter(name="bufferSize")
    def buffer_size(self) -> Optional[pulumi.Input[int]]:
        """
        Automatically control the creation interval of delivery tasks and set the upper limit of an OSS object size (calculated in uncompressed), unit: `MB`.
        """
        return pulumi.get(self, "buffer_size")

    @buffer_size.setter
    def buffer_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "buffer_size", value)

    @property
    @pulumi.getter(name="compressType")
    def compress_type(self) -> Optional[pulumi.Input[str]]:
        """
        OSS data storage compression method, support: `none`, `snappy`, `zstd`, `gzip`. Among them, none means that the original data is not compressed, and snappy means that the data is compressed using the snappy algorithm, which can reduce the storage space usage of the `OSS Bucket`.
        """
        return pulumi.get(self, "compress_type")

    @compress_type.setter
    def compress_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compress_type", value)

    @property
    @pulumi.getter(name="configColumns")
    def config_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OssExportConfigColumnArgs']]]]:
        """
        Configure columns when `content_type` is `parquet` or `orc`.
        """
        return pulumi.get(self, "config_columns")

    @config_columns.setter
    def config_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OssExportConfigColumnArgs']]]]):
        pulumi.set(self, "config_columns", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        Storage format, only supports three types: `json`, `parquet`, `orc`, `csv`.
        **According to the different format, please select the following parameters**
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="csvConfigColumns")
    def csv_config_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Field configuration in csv content_type.
        """
        return pulumi.get(self, "csv_config_columns")

    @csv_config_columns.setter
    def csv_config_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "csv_config_columns", value)

    @property
    @pulumi.getter(name="csvConfigDelimiter")
    def csv_config_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        Separator configuration in csv content_type.
        """
        return pulumi.get(self, "csv_config_delimiter")

    @csv_config_delimiter.setter
    def csv_config_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csv_config_delimiter", value)

    @property
    @pulumi.getter(name="csvConfigEscape")
    def csv_config_escape(self) -> Optional[pulumi.Input[str]]:
        """
        escape in csv content_type.
        """
        return pulumi.get(self, "csv_config_escape")

    @csv_config_escape.setter
    def csv_config_escape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csv_config_escape", value)

    @property
    @pulumi.getter(name="csvConfigHeader")
    def csv_config_header(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to write the field name to the CSV file, the default value is `false`.
        """
        return pulumi.get(self, "csv_config_header")

    @csv_config_header.setter
    def csv_config_header(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "csv_config_header", value)

    @property
    @pulumi.getter(name="csvConfigLinefeed")
    def csv_config_linefeed(self) -> Optional[pulumi.Input[str]]:
        """
        lineFeed in csv content_type.
        """
        return pulumi.get(self, "csv_config_linefeed")

    @csv_config_linefeed.setter
    def csv_config_linefeed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csv_config_linefeed", value)

    @property
    @pulumi.getter(name="csvConfigNull")
    def csv_config_null(self) -> Optional[pulumi.Input[str]]:
        """
        Invalid field content in csv content_type.
        """
        return pulumi.get(self, "csv_config_null")

    @csv_config_null.setter
    def csv_config_null(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csv_config_null", value)

    @property
    @pulumi.getter(name="csvConfigQuote")
    def csv_config_quote(self) -> Optional[pulumi.Input[str]]:
        """
        Escape character in csv content_type.
        """
        return pulumi.get(self, "csv_config_quote")

    @csv_config_quote.setter
    def csv_config_quote(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csv_config_quote", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name for oss export.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="exportName")
    def export_name(self) -> Optional[pulumi.Input[str]]:
        """
        Delivery configuration name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
        """
        return pulumi.get(self, "export_name")

    @export_name.setter
    def export_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "export_name", value)

    @property
    @pulumi.getter(name="fromTime")
    def from_time(self) -> Optional[pulumi.Input[int]]:
        """
        The log from when to export to oss.
        """
        return pulumi.get(self, "from_time")

    @from_time.setter
    def from_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "from_time", value)

    @property
    @pulumi.getter(name="jsonEnableTag")
    def json_enable_tag(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to deliver the label when `content_type` = `json`.
        """
        return pulumi.get(self, "json_enable_tag")

    @json_enable_tag.setter
    def json_enable_tag(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "json_enable_tag", value)

    @property
    @pulumi.getter(name="logReadRoleArn")
    def log_read_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Used for logstore reading, the role should have log read policy, such as `acs:ram::13234:role/logrole`, if `log_read_role_arn` is not set, `role_arn` is used to read logstore.
        """
        return pulumi.get(self, "log_read_role_arn")

    @log_read_role_arn.setter
    def log_read_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_read_role_arn", value)

    @property
    @pulumi.getter(name="logstoreName")
    def logstore_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the log logstore.
        """
        return pulumi.get(self, "logstore_name")

    @logstore_name.setter
    def logstore_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logstore_name", value)

    @property
    @pulumi.getter(name="pathFormat")
    def path_format(self) -> Optional[pulumi.Input[str]]:
        """
        The OSS Bucket directory is dynamically generated according to the creation time of the export task, it cannot start with a forward slash `/`, the default value is `%Y/%m/%d/%H/%M`.
        """
        return pulumi.get(self, "path_format")

    @path_format.setter
    def path_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_format", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The data synchronized from Log Service to OSS will be stored in this directory of Bucket.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the log project. It is the only in one Alicloud account.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Used to write to oss bucket, the OSS Bucket owner creates the role mark which has the oss bucket write policy, such as `acs:ram::13234:role/logrole`.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def suffix(self) -> Optional[pulumi.Input[str]]:
        """
        The suffix for the objects in which the shipped data is stored.
        """
        return pulumi.get(self, "suffix")

    @suffix.setter
    def suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "suffix", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        This time zone that is used to format the time, `+0800` e.g.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


class OssExport(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 buffer_interval: Optional[pulumi.Input[int]] = None,
                 buffer_size: Optional[pulumi.Input[int]] = None,
                 compress_type: Optional[pulumi.Input[str]] = None,
                 config_columns: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OssExportConfigColumnArgs']]]]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 csv_config_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 csv_config_delimiter: Optional[pulumi.Input[str]] = None,
                 csv_config_escape: Optional[pulumi.Input[str]] = None,
                 csv_config_header: Optional[pulumi.Input[bool]] = None,
                 csv_config_linefeed: Optional[pulumi.Input[str]] = None,
                 csv_config_null: Optional[pulumi.Input[str]] = None,
                 csv_config_quote: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 export_name: Optional[pulumi.Input[str]] = None,
                 from_time: Optional[pulumi.Input[int]] = None,
                 json_enable_tag: Optional[pulumi.Input[bool]] = None,
                 log_read_role_arn: Optional[pulumi.Input[str]] = None,
                 logstore_name: Optional[pulumi.Input[str]] = None,
                 path_format: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 suffix: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Log service data delivery management, this service provides the function of delivering data in logstore to oss product storage.
        [Refer to details](https://www.alibabacloud.com/help/en/log-service/latest/ship-logs-to-oss-new-version).

        > **NOTE:** Available in 1.187.0+

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.RandomInteger("default",
            max=99999,
            min=10000)
        example_project = alicloud.log.Project("exampleProject",
            description="terraform-example",
            tags={
                "Created": "TF",
                "For": "example",
            })
        example_store = alicloud.log.Store("exampleStore",
            project=example_project.name,
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example_oss_export = alicloud.log.OssExport("exampleOssExport",
            project_name=example_project.name,
            logstore_name=example_store.name,
            export_name="terraform-example",
            display_name="terraform-example",
            bucket="example-bucket",
            prefix="root",
            suffix="",
            buffer_interval=300,
            buffer_size=250,
            compress_type="none",
            path_format="%Y/%m/%d/%H/%M",
            content_type="json",
            json_enable_tag=True,
            role_arn="role_arn_for_oss_write",
            log_read_role_arn="role_arn_for_sls_read",
            time_zone="+0800")
        ```

        ## Import

        Log oss export can be imported using the id or name, e.g.

        ```sh
         $ pulumi import alicloud:log/ossExport:OssExport example tf-log-project:tf-log-logstore:tf-log-export
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bucket: The name of the oss bucket.
        :param pulumi.Input[int] buffer_interval: How often is it delivered every interval.
        :param pulumi.Input[int] buffer_size: Automatically control the creation interval of delivery tasks and set the upper limit of an OSS object size (calculated in uncompressed), unit: `MB`.
        :param pulumi.Input[str] compress_type: OSS data storage compression method, support: `none`, `snappy`, `zstd`, `gzip`. Among them, none means that the original data is not compressed, and snappy means that the data is compressed using the snappy algorithm, which can reduce the storage space usage of the `OSS Bucket`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OssExportConfigColumnArgs']]]] config_columns: Configure columns when `content_type` is `parquet` or `orc`.
        :param pulumi.Input[str] content_type: Storage format, only supports three types: `json`, `parquet`, `orc`, `csv`.
               **According to the different format, please select the following parameters**
        :param pulumi.Input[Sequence[pulumi.Input[str]]] csv_config_columns: Field configuration in csv content_type.
        :param pulumi.Input[str] csv_config_delimiter: Separator configuration in csv content_type.
        :param pulumi.Input[str] csv_config_escape: escape in csv content_type.
        :param pulumi.Input[bool] csv_config_header: Indicates whether to write the field name to the CSV file, the default value is `false`.
        :param pulumi.Input[str] csv_config_linefeed: lineFeed in csv content_type.
        :param pulumi.Input[str] csv_config_null: Invalid field content in csv content_type.
        :param pulumi.Input[str] csv_config_quote: Escape character in csv content_type.
        :param pulumi.Input[str] display_name: The display name for oss export.
        :param pulumi.Input[str] export_name: Delivery configuration name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
        :param pulumi.Input[int] from_time: The log from when to export to oss.
        :param pulumi.Input[bool] json_enable_tag: Whether to deliver the label when `content_type` = `json`.
        :param pulumi.Input[str] log_read_role_arn: Used for logstore reading, the role should have log read policy, such as `acs:ram::13234:role/logrole`, if `log_read_role_arn` is not set, `role_arn` is used to read logstore.
        :param pulumi.Input[str] logstore_name: The name of the log logstore.
        :param pulumi.Input[str] path_format: The OSS Bucket directory is dynamically generated according to the creation time of the export task, it cannot start with a forward slash `/`, the default value is `%Y/%m/%d/%H/%M`.
        :param pulumi.Input[str] prefix: The data synchronized from Log Service to OSS will be stored in this directory of Bucket.
        :param pulumi.Input[str] project_name: The name of the log project. It is the only in one Alicloud account.
        :param pulumi.Input[str] role_arn: Used to write to oss bucket, the OSS Bucket owner creates the role mark which has the oss bucket write policy, such as `acs:ram::13234:role/logrole`.
        :param pulumi.Input[str] suffix: The suffix for the objects in which the shipped data is stored.
        :param pulumi.Input[str] time_zone: This time zone that is used to format the time, `+0800` e.g.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OssExportArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Log service data delivery management, this service provides the function of delivering data in logstore to oss product storage.
        [Refer to details](https://www.alibabacloud.com/help/en/log-service/latest/ship-logs-to-oss-new-version).

        > **NOTE:** Available in 1.187.0+

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.RandomInteger("default",
            max=99999,
            min=10000)
        example_project = alicloud.log.Project("exampleProject",
            description="terraform-example",
            tags={
                "Created": "TF",
                "For": "example",
            })
        example_store = alicloud.log.Store("exampleStore",
            project=example_project.name,
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example_oss_export = alicloud.log.OssExport("exampleOssExport",
            project_name=example_project.name,
            logstore_name=example_store.name,
            export_name="terraform-example",
            display_name="terraform-example",
            bucket="example-bucket",
            prefix="root",
            suffix="",
            buffer_interval=300,
            buffer_size=250,
            compress_type="none",
            path_format="%Y/%m/%d/%H/%M",
            content_type="json",
            json_enable_tag=True,
            role_arn="role_arn_for_oss_write",
            log_read_role_arn="role_arn_for_sls_read",
            time_zone="+0800")
        ```

        ## Import

        Log oss export can be imported using the id or name, e.g.

        ```sh
         $ pulumi import alicloud:log/ossExport:OssExport example tf-log-project:tf-log-logstore:tf-log-export
        ```

        :param str resource_name: The name of the resource.
        :param OssExportArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OssExportArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 buffer_interval: Optional[pulumi.Input[int]] = None,
                 buffer_size: Optional[pulumi.Input[int]] = None,
                 compress_type: Optional[pulumi.Input[str]] = None,
                 config_columns: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OssExportConfigColumnArgs']]]]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 csv_config_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 csv_config_delimiter: Optional[pulumi.Input[str]] = None,
                 csv_config_escape: Optional[pulumi.Input[str]] = None,
                 csv_config_header: Optional[pulumi.Input[bool]] = None,
                 csv_config_linefeed: Optional[pulumi.Input[str]] = None,
                 csv_config_null: Optional[pulumi.Input[str]] = None,
                 csv_config_quote: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 export_name: Optional[pulumi.Input[str]] = None,
                 from_time: Optional[pulumi.Input[int]] = None,
                 json_enable_tag: Optional[pulumi.Input[bool]] = None,
                 log_read_role_arn: Optional[pulumi.Input[str]] = None,
                 logstore_name: Optional[pulumi.Input[str]] = None,
                 path_format: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 suffix: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OssExportArgs.__new__(OssExportArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            if buffer_interval is None and not opts.urn:
                raise TypeError("Missing required property 'buffer_interval'")
            __props__.__dict__["buffer_interval"] = buffer_interval
            if buffer_size is None and not opts.urn:
                raise TypeError("Missing required property 'buffer_size'")
            __props__.__dict__["buffer_size"] = buffer_size
            __props__.__dict__["compress_type"] = compress_type
            __props__.__dict__["config_columns"] = config_columns
            if content_type is None and not opts.urn:
                raise TypeError("Missing required property 'content_type'")
            __props__.__dict__["content_type"] = content_type
            __props__.__dict__["csv_config_columns"] = csv_config_columns
            __props__.__dict__["csv_config_delimiter"] = csv_config_delimiter
            __props__.__dict__["csv_config_escape"] = csv_config_escape
            __props__.__dict__["csv_config_header"] = csv_config_header
            __props__.__dict__["csv_config_linefeed"] = csv_config_linefeed
            __props__.__dict__["csv_config_null"] = csv_config_null
            __props__.__dict__["csv_config_quote"] = csv_config_quote
            __props__.__dict__["display_name"] = display_name
            if export_name is None and not opts.urn:
                raise TypeError("Missing required property 'export_name'")
            __props__.__dict__["export_name"] = export_name
            __props__.__dict__["from_time"] = from_time
            __props__.__dict__["json_enable_tag"] = json_enable_tag
            __props__.__dict__["log_read_role_arn"] = log_read_role_arn
            if logstore_name is None and not opts.urn:
                raise TypeError("Missing required property 'logstore_name'")
            __props__.__dict__["logstore_name"] = logstore_name
            if path_format is None and not opts.urn:
                raise TypeError("Missing required property 'path_format'")
            __props__.__dict__["path_format"] = path_format
            __props__.__dict__["prefix"] = prefix
            if project_name is None and not opts.urn:
                raise TypeError("Missing required property 'project_name'")
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["suffix"] = suffix
            if time_zone is None and not opts.urn:
                raise TypeError("Missing required property 'time_zone'")
            __props__.__dict__["time_zone"] = time_zone
        super(OssExport, __self__).__init__(
            'alicloud:log/ossExport:OssExport',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[str]] = None,
            buffer_interval: Optional[pulumi.Input[int]] = None,
            buffer_size: Optional[pulumi.Input[int]] = None,
            compress_type: Optional[pulumi.Input[str]] = None,
            config_columns: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OssExportConfigColumnArgs']]]]] = None,
            content_type: Optional[pulumi.Input[str]] = None,
            csv_config_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            csv_config_delimiter: Optional[pulumi.Input[str]] = None,
            csv_config_escape: Optional[pulumi.Input[str]] = None,
            csv_config_header: Optional[pulumi.Input[bool]] = None,
            csv_config_linefeed: Optional[pulumi.Input[str]] = None,
            csv_config_null: Optional[pulumi.Input[str]] = None,
            csv_config_quote: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            export_name: Optional[pulumi.Input[str]] = None,
            from_time: Optional[pulumi.Input[int]] = None,
            json_enable_tag: Optional[pulumi.Input[bool]] = None,
            log_read_role_arn: Optional[pulumi.Input[str]] = None,
            logstore_name: Optional[pulumi.Input[str]] = None,
            path_format: Optional[pulumi.Input[str]] = None,
            prefix: Optional[pulumi.Input[str]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            role_arn: Optional[pulumi.Input[str]] = None,
            suffix: Optional[pulumi.Input[str]] = None,
            time_zone: Optional[pulumi.Input[str]] = None) -> 'OssExport':
        """
        Get an existing OssExport resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bucket: The name of the oss bucket.
        :param pulumi.Input[int] buffer_interval: How often is it delivered every interval.
        :param pulumi.Input[int] buffer_size: Automatically control the creation interval of delivery tasks and set the upper limit of an OSS object size (calculated in uncompressed), unit: `MB`.
        :param pulumi.Input[str] compress_type: OSS data storage compression method, support: `none`, `snappy`, `zstd`, `gzip`. Among them, none means that the original data is not compressed, and snappy means that the data is compressed using the snappy algorithm, which can reduce the storage space usage of the `OSS Bucket`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OssExportConfigColumnArgs']]]] config_columns: Configure columns when `content_type` is `parquet` or `orc`.
        :param pulumi.Input[str] content_type: Storage format, only supports three types: `json`, `parquet`, `orc`, `csv`.
               **According to the different format, please select the following parameters**
        :param pulumi.Input[Sequence[pulumi.Input[str]]] csv_config_columns: Field configuration in csv content_type.
        :param pulumi.Input[str] csv_config_delimiter: Separator configuration in csv content_type.
        :param pulumi.Input[str] csv_config_escape: escape in csv content_type.
        :param pulumi.Input[bool] csv_config_header: Indicates whether to write the field name to the CSV file, the default value is `false`.
        :param pulumi.Input[str] csv_config_linefeed: lineFeed in csv content_type.
        :param pulumi.Input[str] csv_config_null: Invalid field content in csv content_type.
        :param pulumi.Input[str] csv_config_quote: Escape character in csv content_type.
        :param pulumi.Input[str] display_name: The display name for oss export.
        :param pulumi.Input[str] export_name: Delivery configuration name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
        :param pulumi.Input[int] from_time: The log from when to export to oss.
        :param pulumi.Input[bool] json_enable_tag: Whether to deliver the label when `content_type` = `json`.
        :param pulumi.Input[str] log_read_role_arn: Used for logstore reading, the role should have log read policy, such as `acs:ram::13234:role/logrole`, if `log_read_role_arn` is not set, `role_arn` is used to read logstore.
        :param pulumi.Input[str] logstore_name: The name of the log logstore.
        :param pulumi.Input[str] path_format: The OSS Bucket directory is dynamically generated according to the creation time of the export task, it cannot start with a forward slash `/`, the default value is `%Y/%m/%d/%H/%M`.
        :param pulumi.Input[str] prefix: The data synchronized from Log Service to OSS will be stored in this directory of Bucket.
        :param pulumi.Input[str] project_name: The name of the log project. It is the only in one Alicloud account.
        :param pulumi.Input[str] role_arn: Used to write to oss bucket, the OSS Bucket owner creates the role mark which has the oss bucket write policy, such as `acs:ram::13234:role/logrole`.
        :param pulumi.Input[str] suffix: The suffix for the objects in which the shipped data is stored.
        :param pulumi.Input[str] time_zone: This time zone that is used to format the time, `+0800` e.g.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OssExportState.__new__(_OssExportState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["buffer_interval"] = buffer_interval
        __props__.__dict__["buffer_size"] = buffer_size
        __props__.__dict__["compress_type"] = compress_type
        __props__.__dict__["config_columns"] = config_columns
        __props__.__dict__["content_type"] = content_type
        __props__.__dict__["csv_config_columns"] = csv_config_columns
        __props__.__dict__["csv_config_delimiter"] = csv_config_delimiter
        __props__.__dict__["csv_config_escape"] = csv_config_escape
        __props__.__dict__["csv_config_header"] = csv_config_header
        __props__.__dict__["csv_config_linefeed"] = csv_config_linefeed
        __props__.__dict__["csv_config_null"] = csv_config_null
        __props__.__dict__["csv_config_quote"] = csv_config_quote
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["export_name"] = export_name
        __props__.__dict__["from_time"] = from_time
        __props__.__dict__["json_enable_tag"] = json_enable_tag
        __props__.__dict__["log_read_role_arn"] = log_read_role_arn
        __props__.__dict__["logstore_name"] = logstore_name
        __props__.__dict__["path_format"] = path_format
        __props__.__dict__["prefix"] = prefix
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["suffix"] = suffix
        __props__.__dict__["time_zone"] = time_zone
        return OssExport(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[str]:
        """
        The name of the oss bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="bufferInterval")
    def buffer_interval(self) -> pulumi.Output[int]:
        """
        How often is it delivered every interval.
        """
        return pulumi.get(self, "buffer_interval")

    @property
    @pulumi.getter(name="bufferSize")
    def buffer_size(self) -> pulumi.Output[int]:
        """
        Automatically control the creation interval of delivery tasks and set the upper limit of an OSS object size (calculated in uncompressed), unit: `MB`.
        """
        return pulumi.get(self, "buffer_size")

    @property
    @pulumi.getter(name="compressType")
    def compress_type(self) -> pulumi.Output[str]:
        """
        OSS data storage compression method, support: `none`, `snappy`, `zstd`, `gzip`. Among them, none means that the original data is not compressed, and snappy means that the data is compressed using the snappy algorithm, which can reduce the storage space usage of the `OSS Bucket`.
        """
        return pulumi.get(self, "compress_type")

    @property
    @pulumi.getter(name="configColumns")
    def config_columns(self) -> pulumi.Output[Optional[Sequence['outputs.OssExportConfigColumn']]]:
        """
        Configure columns when `content_type` is `parquet` or `orc`.
        """
        return pulumi.get(self, "config_columns")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[str]:
        """
        Storage format, only supports three types: `json`, `parquet`, `orc`, `csv`.
        **According to the different format, please select the following parameters**
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="csvConfigColumns")
    def csv_config_columns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Field configuration in csv content_type.
        """
        return pulumi.get(self, "csv_config_columns")

    @property
    @pulumi.getter(name="csvConfigDelimiter")
    def csv_config_delimiter(self) -> pulumi.Output[Optional[str]]:
        """
        Separator configuration in csv content_type.
        """
        return pulumi.get(self, "csv_config_delimiter")

    @property
    @pulumi.getter(name="csvConfigEscape")
    def csv_config_escape(self) -> pulumi.Output[Optional[str]]:
        """
        escape in csv content_type.
        """
        return pulumi.get(self, "csv_config_escape")

    @property
    @pulumi.getter(name="csvConfigHeader")
    def csv_config_header(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether to write the field name to the CSV file, the default value is `false`.
        """
        return pulumi.get(self, "csv_config_header")

    @property
    @pulumi.getter(name="csvConfigLinefeed")
    def csv_config_linefeed(self) -> pulumi.Output[Optional[str]]:
        """
        lineFeed in csv content_type.
        """
        return pulumi.get(self, "csv_config_linefeed")

    @property
    @pulumi.getter(name="csvConfigNull")
    def csv_config_null(self) -> pulumi.Output[Optional[str]]:
        """
        Invalid field content in csv content_type.
        """
        return pulumi.get(self, "csv_config_null")

    @property
    @pulumi.getter(name="csvConfigQuote")
    def csv_config_quote(self) -> pulumi.Output[Optional[str]]:
        """
        Escape character in csv content_type.
        """
        return pulumi.get(self, "csv_config_quote")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        The display name for oss export.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="exportName")
    def export_name(self) -> pulumi.Output[str]:
        """
        Delivery configuration name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
        """
        return pulumi.get(self, "export_name")

    @property
    @pulumi.getter(name="fromTime")
    def from_time(self) -> pulumi.Output[Optional[int]]:
        """
        The log from when to export to oss.
        """
        return pulumi.get(self, "from_time")

    @property
    @pulumi.getter(name="jsonEnableTag")
    def json_enable_tag(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to deliver the label when `content_type` = `json`.
        """
        return pulumi.get(self, "json_enable_tag")

    @property
    @pulumi.getter(name="logReadRoleArn")
    def log_read_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        Used for logstore reading, the role should have log read policy, such as `acs:ram::13234:role/logrole`, if `log_read_role_arn` is not set, `role_arn` is used to read logstore.
        """
        return pulumi.get(self, "log_read_role_arn")

    @property
    @pulumi.getter(name="logstoreName")
    def logstore_name(self) -> pulumi.Output[str]:
        """
        The name of the log logstore.
        """
        return pulumi.get(self, "logstore_name")

    @property
    @pulumi.getter(name="pathFormat")
    def path_format(self) -> pulumi.Output[str]:
        """
        The OSS Bucket directory is dynamically generated according to the creation time of the export task, it cannot start with a forward slash `/`, the default value is `%Y/%m/%d/%H/%M`.
        """
        return pulumi.get(self, "path_format")

    @property
    @pulumi.getter
    def prefix(self) -> pulumi.Output[Optional[str]]:
        """
        The data synchronized from Log Service to OSS will be stored in this directory of Bucket.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        The name of the log project. It is the only in one Alicloud account.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        Used to write to oss bucket, the OSS Bucket owner creates the role mark which has the oss bucket write policy, such as `acs:ram::13234:role/logrole`.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def suffix(self) -> pulumi.Output[Optional[str]]:
        """
        The suffix for the objects in which the shipped data is stored.
        """
        return pulumi.get(self, "suffix")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[str]:
        """
        This time zone that is used to format the time, `+0800` e.g.
        """
        return pulumi.get(self, "time_zone")

