# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AlertAnnotation',
    'AlertGroupConfiguration',
    'AlertJoinConfiguration',
    'AlertLabel',
    'AlertNotificationList',
    'AlertPolicyConfiguration',
    'AlertQueryList',
    'AlertSchedule',
    'AlertSeverityConfiguration',
    'AlertTemplateConfiguration',
    'EtlEtlSink',
    'OssExportConfigColumn',
    'OssShipperParquetConfig',
    'StoreEncryptConf',
    'StoreEncryptConfUserCmkInfo',
    'StoreIndexFieldSearch',
    'StoreIndexFieldSearchJsonKey',
    'StoreIndexFullText',
    'StoreShard',
    'GetProjectsProjectResult',
    'GetStoresStoreResult',
]

@pulumi.output_type
class AlertAnnotation(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: Annotations's key for new alert.
        :param str value: Annotations's value for new alert.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Annotations's key for new alert.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Annotations's value for new alert.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AlertGroupConfiguration(dict):
    def __init__(__self__, *,
                 type: str,
                 fields: Optional[Sequence[str]] = None):
        """
        :param str type: including FixedRate,Hourly,Daily,Weekly,Cron.
        """
        pulumi.set(__self__, "type", type)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        including FixedRate,Hourly,Daily,Weekly,Cron.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def fields(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "fields")


@pulumi.output_type
class AlertJoinConfiguration(dict):
    def __init__(__self__, *,
                 condition: str,
                 type: str):
        """
        :param str condition: Join condition.
        :param str type: including FixedRate,Hourly,Daily,Weekly,Cron.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def condition(self) -> str:
        """
        Join condition.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        including FixedRate,Hourly,Daily,Weekly,Cron.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AlertLabel(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: Annotations's key for new alert.
        :param str value: Annotations's value for new alert.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Annotations's key for new alert.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Annotations's value for new alert.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AlertNotificationList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailLists":
            suggest = "email_lists"
        elif key == "mobileLists":
            suggest = "mobile_lists"
        elif key == "serviceUri":
            suggest = "service_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertNotificationList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertNotificationList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertNotificationList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: str,
                 type: str,
                 email_lists: Optional[Sequence[str]] = None,
                 mobile_lists: Optional[Sequence[str]] = None,
                 service_uri: Optional[str] = None):
        """
        :param str content: Notice content of alarm.
        :param str type: including FixedRate,Hourly,Daily,Weekly,Cron.
        :param Sequence[str] email_lists: Email address list.
        :param Sequence[str] mobile_lists: SMS sending mobile number.
        :param str service_uri: Request address.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "type", type)
        if email_lists is not None:
            pulumi.set(__self__, "email_lists", email_lists)
        if mobile_lists is not None:
            pulumi.set(__self__, "mobile_lists", mobile_lists)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        Notice content of alarm.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        including FixedRate,Hourly,Daily,Weekly,Cron.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="emailLists")
    def email_lists(self) -> Optional[Sequence[str]]:
        """
        Email address list.
        """
        return pulumi.get(self, "email_lists")

    @property
    @pulumi.getter(name="mobileLists")
    def mobile_lists(self) -> Optional[Sequence[str]]:
        """
        SMS sending mobile number.
        """
        return pulumi.get(self, "mobile_lists")

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[str]:
        """
        Request address.
        """
        return pulumi.get(self, "service_uri")


@pulumi.output_type
class AlertPolicyConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertPolicyId":
            suggest = "alert_policy_id"
        elif key == "repeatInterval":
            suggest = "repeat_interval"
        elif key == "actionPolicyId":
            suggest = "action_policy_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alert_policy_id: str,
                 repeat_interval: str,
                 action_policy_id: Optional[str] = None):
        """
        :param str alert_policy_id: Alert Policy Id.
        :param str repeat_interval: Repeat interval used by alert policy, 1h, 1m.e.g.
        :param str action_policy_id: Action Policy Id.
        """
        pulumi.set(__self__, "alert_policy_id", alert_policy_id)
        pulumi.set(__self__, "repeat_interval", repeat_interval)
        if action_policy_id is not None:
            pulumi.set(__self__, "action_policy_id", action_policy_id)

    @property
    @pulumi.getter(name="alertPolicyId")
    def alert_policy_id(self) -> str:
        """
        Alert Policy Id.
        """
        return pulumi.get(self, "alert_policy_id")

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> str:
        """
        Repeat interval used by alert policy, 1h, 1m.e.g.
        """
        return pulumi.get(self, "repeat_interval")

    @property
    @pulumi.getter(name="actionPolicyId")
    def action_policy_id(self) -> Optional[str]:
        """
        Action Policy Id.
        """
        return pulumi.get(self, "action_policy_id")


@pulumi.output_type
class AlertQueryList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chartTitle":
            suggest = "chart_title"
        elif key == "dashboardId":
            suggest = "dashboard_id"
        elif key == "powerSqlMode":
            suggest = "power_sql_mode"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "storeType":
            suggest = "store_type"
        elif key == "timeSpanType":
            suggest = "time_span_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertQueryList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertQueryList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertQueryList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end: str,
                 query: str,
                 start: str,
                 chart_title: Optional[str] = None,
                 dashboard_id: Optional[str] = None,
                 logstore: Optional[str] = None,
                 power_sql_mode: Optional[str] = None,
                 project: Optional[str] = None,
                 region: Optional[str] = None,
                 role_arn: Optional[str] = None,
                 store: Optional[str] = None,
                 store_type: Optional[str] = None,
                 time_span_type: Optional[str] = None):
        """
        :param str end: End time. example: 20s.
        :param str query: Query corresponding to chart. example: * AND aliyun.
        :param str start: Begin time. example: -60s.
        :param str chart_title: Chart title, optional from 1.161.0+.
        :param str dashboard_id: Query dashboard id.
        :param str logstore: Query logstore, use store for new alert, Deprecated from 1.161.0+.
        :param str power_sql_mode: default disable, whether to use power sql. support auto, enable, disable.
        :param str project: Query project.
        :param str region: Query project region.
        :param str role_arn: Query project store's ARN.
        :param str store: Query store for new alert.
        :param str store_type: Query store type for new alert, including log,metric,meta.
        :param str time_span_type: default Custom. No need to configure this parameter.
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "start", start)
        if chart_title is not None:
            pulumi.set(__self__, "chart_title", chart_title)
        if dashboard_id is not None:
            pulumi.set(__self__, "dashboard_id", dashboard_id)
        if logstore is not None:
            pulumi.set(__self__, "logstore", logstore)
        if power_sql_mode is not None:
            pulumi.set(__self__, "power_sql_mode", power_sql_mode)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if store is not None:
            pulumi.set(__self__, "store", store)
        if store_type is not None:
            pulumi.set(__self__, "store_type", store_type)
        if time_span_type is not None:
            pulumi.set(__self__, "time_span_type", time_span_type)

    @property
    @pulumi.getter
    def end(self) -> str:
        """
        End time. example: 20s.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        Query corresponding to chart. example: * AND aliyun.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter
    def start(self) -> str:
        """
        Begin time. example: -60s.
        """
        return pulumi.get(self, "start")

    @property
    @pulumi.getter(name="chartTitle")
    def chart_title(self) -> Optional[str]:
        """
        Chart title, optional from 1.161.0+.
        """
        return pulumi.get(self, "chart_title")

    @property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> Optional[str]:
        """
        Query dashboard id.
        """
        return pulumi.get(self, "dashboard_id")

    @property
    @pulumi.getter
    def logstore(self) -> Optional[str]:
        """
        Query logstore, use store for new alert, Deprecated from 1.161.0+.
        """
        warnings.warn("""Deprecated from 1.161.0+, use store""", DeprecationWarning)
        pulumi.log.warn("""logstore is deprecated: Deprecated from 1.161.0+, use store""")

        return pulumi.get(self, "logstore")

    @property
    @pulumi.getter(name="powerSqlMode")
    def power_sql_mode(self) -> Optional[str]:
        """
        default disable, whether to use power sql. support auto, enable, disable.
        """
        return pulumi.get(self, "power_sql_mode")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        """
        Query project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Query project region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        Query project store's ARN.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def store(self) -> Optional[str]:
        """
        Query store for new alert.
        """
        return pulumi.get(self, "store")

    @property
    @pulumi.getter(name="storeType")
    def store_type(self) -> Optional[str]:
        """
        Query store type for new alert, including log,metric,meta.
        """
        return pulumi.get(self, "store_type")

    @property
    @pulumi.getter(name="timeSpanType")
    def time_span_type(self) -> Optional[str]:
        """
        default Custom. No need to configure this parameter.
        """
        return pulumi.get(self, "time_span_type")


@pulumi.output_type
class AlertSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cronExpression":
            suggest = "cron_expression"
        elif key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "runImmediately":
            suggest = "run_immediately"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 cron_expression: Optional[str] = None,
                 day_of_week: Optional[int] = None,
                 delay: Optional[int] = None,
                 hour: Optional[int] = None,
                 interval: Optional[str] = None,
                 run_immediately: Optional[bool] = None,
                 time_zone: Optional[str] = None):
        """
        :param str type: including FixedRate,Hourly,Daily,Weekly,Cron.
        :param str cron_expression: Cron expression when type is Cron.
        :param int day_of_week: Day of week when type is Weekly, including 0,1,2,3,4,5,6, 0 for Sunday, 1 for Monday
        :param int hour: Hour of day when type is Weekly/Daily.
        :param str interval: Execution interval. 60 seconds minimum, such as 60s, 1h. used when type is FixedRate.
        :param str time_zone: Time zone for schedule.
        """
        pulumi.set(__self__, "type", type)
        if cron_expression is not None:
            pulumi.set(__self__, "cron_expression", cron_expression)
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if run_immediately is not None:
            pulumi.set(__self__, "run_immediately", run_immediately)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        including FixedRate,Hourly,Daily,Weekly,Cron.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> Optional[str]:
        """
        Cron expression when type is Cron.
        """
        return pulumi.get(self, "cron_expression")

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[int]:
        """
        Day of week when type is Weekly, including 0,1,2,3,4,5,6, 0 for Sunday, 1 for Monday
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter
    def delay(self) -> Optional[int]:
        return pulumi.get(self, "delay")

    @property
    @pulumi.getter
    def hour(self) -> Optional[int]:
        """
        Hour of day when type is Weekly/Daily.
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter
    def interval(self) -> Optional[str]:
        """
        Execution interval. 60 seconds minimum, such as 60s, 1h. used when type is FixedRate.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="runImmediately")
    def run_immediately(self) -> Optional[bool]:
        return pulumi.get(self, "run_immediately")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        Time zone for schedule.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class AlertSeverityConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evalCondition":
            suggest = "eval_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertSeverityConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertSeverityConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertSeverityConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eval_condition: Mapping[str, str],
                 severity: int):
        """
        :param Mapping[str, str] eval_condition: Severity when this condition is met.
        :param int severity: Severity for new alert, including 2,4,6,8,10 for Report,Low,Medium,High,Critical.
        """
        pulumi.set(__self__, "eval_condition", eval_condition)
        pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter(name="evalCondition")
    def eval_condition(self) -> Mapping[str, str]:
        """
        Severity when this condition is met.
        """
        return pulumi.get(self, "eval_condition")

    @property
    @pulumi.getter
    def severity(self) -> int:
        """
        Severity for new alert, including 2,4,6,8,10 for Report,Low,Medium,High,Critical.
        """
        return pulumi.get(self, "severity")


@pulumi.output_type
class AlertTemplateConfiguration(dict):
    def __init__(__self__, *,
                 id: str,
                 type: str,
                 annotations: Optional[Mapping[str, str]] = None,
                 lang: Optional[str] = None,
                 tokens: Optional[Mapping[str, str]] = None):
        """
        :param str id: Alert template id.
        :param str type: including FixedRate,Hourly,Daily,Weekly,Cron.
        :param Mapping[str, str] annotations: Alert template annotations.
        :param str lang: Alert template language including `cn`, `en`.
        :param Mapping[str, str] tokens: Alert template tokens.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if tokens is not None:
            pulumi.set(__self__, "tokens", tokens)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Alert template id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        including FixedRate,Hourly,Daily,Weekly,Cron.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, str]]:
        """
        Alert template annotations.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def lang(self) -> Optional[str]:
        """
        Alert template language including `cn`, `en`.
        """
        return pulumi.get(self, "lang")

    @property
    @pulumi.getter
    def tokens(self) -> Optional[Mapping[str, str]]:
        """
        Alert template tokens.
        """
        return pulumi.get(self, "tokens")


@pulumi.output_type
class EtlEtlSink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyId":
            suggest = "access_key_id"
        elif key == "accessKeySecret":
            suggest = "access_key_secret"
        elif key == "kmsEncryptedAccessKeyId":
            suggest = "kms_encrypted_access_key_id"
        elif key == "kmsEncryptedAccessKeySecret":
            suggest = "kms_encrypted_access_key_secret"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EtlEtlSink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EtlEtlSink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EtlEtlSink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: str,
                 logstore: str,
                 name: str,
                 project: str,
                 access_key_id: Optional[str] = None,
                 access_key_secret: Optional[str] = None,
                 kms_encrypted_access_key_id: Optional[str] = None,
                 kms_encrypted_access_key_secret: Optional[str] = None,
                 role_arn: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str endpoint: Delivery target logstore region.
        :param str logstore: Delivery target logstore.
        :param str name: Delivery target name.
        :param str project: The project where the target logstore is delivered.
        :param str access_key_id: Delivery target logstore access key id.
        :param str access_key_secret: Delivery target logstore access key secret.
        :param str kms_encrypted_access_key_id: An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
        :param str kms_encrypted_access_key_secret: An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
        :param str role_arn: Sts role info under delivery target logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
        :param str type: ETL sinks type, the default value is AliyunLOG.
               
               > **Note:** `from_time` and `to_time` no modification allowed after successful creation.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "logstore", logstore)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project", project)
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if access_key_secret is not None:
            pulumi.set(__self__, "access_key_secret", access_key_secret)
        if kms_encrypted_access_key_id is not None:
            pulumi.set(__self__, "kms_encrypted_access_key_id", kms_encrypted_access_key_id)
        if kms_encrypted_access_key_secret is not None:
            pulumi.set(__self__, "kms_encrypted_access_key_secret", kms_encrypted_access_key_secret)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Delivery target logstore region.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def logstore(self) -> str:
        """
        Delivery target logstore.
        """
        return pulumi.get(self, "logstore")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Delivery target name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The project where the target logstore is delivered.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[str]:
        """
        Delivery target logstore access key id.
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter(name="accessKeySecret")
    def access_key_secret(self) -> Optional[str]:
        """
        Delivery target logstore access key secret.
        """
        return pulumi.get(self, "access_key_secret")

    @property
    @pulumi.getter(name="kmsEncryptedAccessKeyId")
    def kms_encrypted_access_key_id(self) -> Optional[str]:
        """
        An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_access_key_id")

    @property
    @pulumi.getter(name="kmsEncryptedAccessKeySecret")
    def kms_encrypted_access_key_secret(self) -> Optional[str]:
        """
        An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_access_key_secret")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        Sts role info under delivery target logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        ETL sinks type, the default value is AliyunLOG.

        > **Note:** `from_time` and `to_time` no modification allowed after successful creation.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class OssExportConfigColumn(dict):
    def __init__(__self__, *,
                 name: str,
                 type: str):
        """
        :param str name: The name of the key.
        :param str type: Type of configuration name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the key.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of configuration name.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class OssShipperParquetConfig(dict):
    def __init__(__self__, *,
                 name: str,
                 type: str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class StoreEncryptConf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptType":
            suggest = "encrypt_type"
        elif key == "userCmkInfo":
            suggest = "user_cmk_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StoreEncryptConf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StoreEncryptConf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StoreEncryptConf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable: Optional[bool] = None,
                 encrypt_type: Optional[str] = None,
                 user_cmk_info: Optional['outputs.StoreEncryptConfUserCmkInfo'] = None):
        """
        :param bool enable: enable encryption. Default `false`
        :param str encrypt_type: Supported encryption type, only supports `default(AES)`,` m4`
        :param 'StoreEncryptConfUserCmkInfoArgs' user_cmk_info: User bring your own key (BYOK) encryption [Refer to details](https://www.alibabacloud.com/help/zh/doc-detail/187853.htm), the format is as follows. See `user_cmk_info` below.
               ```python
               import pulumi
               ```
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if encrypt_type is not None:
            pulumi.set(__self__, "encrypt_type", encrypt_type)
        if user_cmk_info is not None:
            pulumi.set(__self__, "user_cmk_info", user_cmk_info)

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        """
        enable encryption. Default `false`
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="encryptType")
    def encrypt_type(self) -> Optional[str]:
        """
        Supported encryption type, only supports `default(AES)`,` m4`
        """
        return pulumi.get(self, "encrypt_type")

    @property
    @pulumi.getter(name="userCmkInfo")
    def user_cmk_info(self) -> Optional['outputs.StoreEncryptConfUserCmkInfo']:
        """
        User bring your own key (BYOK) encryption [Refer to details](https://www.alibabacloud.com/help/zh/doc-detail/187853.htm), the format is as follows. See `user_cmk_info` below.
        ```python
        import pulumi
        ```
        """
        return pulumi.get(self, "user_cmk_info")


@pulumi.output_type
class StoreEncryptConfUserCmkInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cmkKeyId":
            suggest = "cmk_key_id"
        elif key == "regionId":
            suggest = "region_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StoreEncryptConfUserCmkInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StoreEncryptConfUserCmkInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StoreEncryptConfUserCmkInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: str,
                 cmk_key_id: str,
                 region_id: str):
        """
        :param str arn: role arn.
        :param str cmk_key_id: User master key id.
        :param str region_id: Region id where the  user master key id is located.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "cmk_key_id", cmk_key_id)
        pulumi.set(__self__, "region_id", region_id)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        role arn.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="cmkKeyId")
    def cmk_key_id(self) -> str:
        """
        User master key id.
        """
        return pulumi.get(self, "cmk_key_id")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        Region id where the  user master key id is located.
        """
        return pulumi.get(self, "region_id")


@pulumi.output_type
class StoreIndexFieldSearch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caseSensitive":
            suggest = "case_sensitive"
        elif key == "enableAnalytics":
            suggest = "enable_analytics"
        elif key == "includeChinese":
            suggest = "include_chinese"
        elif key == "jsonKeys":
            suggest = "json_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StoreIndexFieldSearch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StoreIndexFieldSearch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StoreIndexFieldSearch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 alias: Optional[str] = None,
                 case_sensitive: Optional[bool] = None,
                 enable_analytics: Optional[bool] = None,
                 include_chinese: Optional[bool] = None,
                 json_keys: Optional[Sequence['outputs.StoreIndexFieldSearchJsonKey']] = None,
                 token: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str name: When using the json_keys field, this field is required.
        :param str alias: The alias of one field.
        :param bool case_sensitive: Whether the case sensitive for the field. Default to false. It is valid when "type" is "text" or "json".
        :param bool enable_analytics: Whether to enable field analytics. Default to true.
        :param bool include_chinese: Whether includes the chinese for the field. Default to false. It is valid when "type" is "text" or "json".
        :param Sequence['StoreIndexFieldSearchJsonKeyArgs'] json_keys: Use nested index when type is json
        :param str token: The string of several split words, like "\\r", "#". It is valid when "type" is "text" or "json".
        :param str type: The type of one field. Valid values: ["long", "text", "double"]. Default to "long"
        """
        pulumi.set(__self__, "name", name)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)
        if enable_analytics is not None:
            pulumi.set(__self__, "enable_analytics", enable_analytics)
        if include_chinese is not None:
            pulumi.set(__self__, "include_chinese", include_chinese)
        if json_keys is not None:
            pulumi.set(__self__, "json_keys", json_keys)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        When using the json_keys field, this field is required.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def alias(self) -> Optional[str]:
        """
        The alias of one field.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[bool]:
        """
        Whether the case sensitive for the field. Default to false. It is valid when "type" is "text" or "json".
        """
        return pulumi.get(self, "case_sensitive")

    @property
    @pulumi.getter(name="enableAnalytics")
    def enable_analytics(self) -> Optional[bool]:
        """
        Whether to enable field analytics. Default to true.
        """
        return pulumi.get(self, "enable_analytics")

    @property
    @pulumi.getter(name="includeChinese")
    def include_chinese(self) -> Optional[bool]:
        """
        Whether includes the chinese for the field. Default to false. It is valid when "type" is "text" or "json".
        """
        return pulumi.get(self, "include_chinese")

    @property
    @pulumi.getter(name="jsonKeys")
    def json_keys(self) -> Optional[Sequence['outputs.StoreIndexFieldSearchJsonKey']]:
        """
        Use nested index when type is json
        """
        return pulumi.get(self, "json_keys")

    @property
    @pulumi.getter
    def token(self) -> Optional[str]:
        """
        The string of several split words, like "\\r", "#". It is valid when "type" is "text" or "json".
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of one field. Valid values: ["long", "text", "double"]. Default to "long"
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class StoreIndexFieldSearchJsonKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "docValue":
            suggest = "doc_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StoreIndexFieldSearchJsonKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StoreIndexFieldSearchJsonKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StoreIndexFieldSearchJsonKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 alias: Optional[str] = None,
                 doc_value: Optional[bool] = None,
                 type: Optional[str] = None):
        """
        :param str name: When using the json_keys field, this field is required.
        :param str alias: The alias of one field.
        :param bool doc_value: Whether to enable statistics. default to true.
               
               > **Note:** At least one of the "full_text" and "field_search" should be specified.
        :param str type: The type of one field. Valid values: ["long", "text", "double"]. Default to "long"
        """
        pulumi.set(__self__, "name", name)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if doc_value is not None:
            pulumi.set(__self__, "doc_value", doc_value)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        When using the json_keys field, this field is required.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def alias(self) -> Optional[str]:
        """
        The alias of one field.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="docValue")
    def doc_value(self) -> Optional[bool]:
        """
        Whether to enable statistics. default to true.

        > **Note:** At least one of the "full_text" and "field_search" should be specified.
        """
        return pulumi.get(self, "doc_value")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of one field. Valid values: ["long", "text", "double"]. Default to "long"
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class StoreIndexFullText(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caseSensitive":
            suggest = "case_sensitive"
        elif key == "includeChinese":
            suggest = "include_chinese"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StoreIndexFullText. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StoreIndexFullText.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StoreIndexFullText.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 case_sensitive: Optional[bool] = None,
                 include_chinese: Optional[bool] = None,
                 token: Optional[str] = None):
        """
        :param bool case_sensitive: Whether the case sensitive for the field. Default to false. It is valid when "type" is "text" or "json".
        :param bool include_chinese: Whether includes the chinese for the field. Default to false. It is valid when "type" is "text" or "json".
        :param str token: The string of several split words, like "\\r", "#". It is valid when "type" is "text" or "json".
        """
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)
        if include_chinese is not None:
            pulumi.set(__self__, "include_chinese", include_chinese)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[bool]:
        """
        Whether the case sensitive for the field. Default to false. It is valid when "type" is "text" or "json".
        """
        return pulumi.get(self, "case_sensitive")

    @property
    @pulumi.getter(name="includeChinese")
    def include_chinese(self) -> Optional[bool]:
        """
        Whether includes the chinese for the field. Default to false. It is valid when "type" is "text" or "json".
        """
        return pulumi.get(self, "include_chinese")

    @property
    @pulumi.getter
    def token(self) -> Optional[str]:
        """
        The string of several split words, like "\\r", "#". It is valid when "type" is "text" or "json".
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class StoreShard(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "beginKey":
            suggest = "begin_key"
        elif key == "endKey":
            suggest = "end_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StoreShard. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StoreShard.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StoreShard.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 begin_key: Optional[str] = None,
                 end_key: Optional[str] = None,
                 id: Optional[int] = None,
                 status: Optional[str] = None):
        """
        :param str begin_key: The begin value of the shard range(MD5), included in the shard range.
        :param str end_key: The end value of the shard range(MD5), not included in shard range.
        :param int id: The ID of the shard.
        :param str status: Shard status, only two status of `readwrite` and `readonly`.
        """
        if begin_key is not None:
            pulumi.set(__self__, "begin_key", begin_key)
        if end_key is not None:
            pulumi.set(__self__, "end_key", end_key)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="beginKey")
    def begin_key(self) -> Optional[str]:
        """
        The begin value of the shard range(MD5), included in the shard range.
        """
        return pulumi.get(self, "begin_key")

    @property
    @pulumi.getter(name="endKey")
    def end_key(self) -> Optional[str]:
        """
        The end value of the shard range(MD5), not included in shard range.
        """
        return pulumi.get(self, "end_key")

    @property
    @pulumi.getter
    def id(self) -> Optional[int]:
        """
        The ID of the shard.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Shard status, only two status of `readwrite` and `readonly`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetProjectsProjectResult(dict):
    def __init__(__self__, *,
                 description: str,
                 id: str,
                 last_modify_time: str,
                 owner: str,
                 policy: str,
                 project_name: str,
                 region: str,
                 status: str):
        """
        :param str description: The description of the project.
        :param str id: The ID of the project.
        :param str last_modify_time: The last modify time of project.
        :param str owner: The owner of project.
        :param str policy: The policy of project.
        :param str project_name: The name of the project.
        :param str region: The region of project.
        :param str status: The status of project.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_modify_time", last_modify_time)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "project_name", project_name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the project.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the project.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastModifyTime")
    def last_modify_time(self) -> str:
        """
        The last modify time of project.
        """
        return pulumi.get(self, "last_modify_time")

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        The owner of project.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def policy(self) -> str:
        """
        The policy of project.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> str:
        """
        The name of the project.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region of project.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of project.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetStoresStoreResult(dict):
    def __init__(__self__, *,
                 id: str,
                 store_name: str):
        """
        :param str id: The ID of the store.
        :param str store_name: The name of the store.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "store_name", store_name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the store.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="storeName")
    def store_name(self) -> str:
        """
        The name of the store.
        """
        return pulumi.get(self, "store_name")


