# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StoreArgs', 'Store']

@pulumi.input_type
class StoreArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[str],
                 append_meta: Optional[pulumi.Input[bool]] = None,
                 auto_split: Optional[pulumi.Input[bool]] = None,
                 enable_web_tracking: Optional[pulumi.Input[bool]] = None,
                 encrypt_conf: Optional[pulumi.Input['StoreEncryptConfArgs']] = None,
                 hot_ttl: Optional[pulumi.Input[int]] = None,
                 max_split_shard_count: Optional[pulumi.Input[int]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 retention_period: Optional[pulumi.Input[int]] = None,
                 shard_count: Optional[pulumi.Input[int]] = None,
                 telemetry_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Store resource.
        :param pulumi.Input[str] project: The project name to the log store belongs.
        :param pulumi.Input[bool] append_meta: Determines whether to append log meta automatically. The meta includes log receive time and client IP address. Default to `true`.
        :param pulumi.Input[bool] auto_split: Determines whether to automatically split a shard. Default to `false`.
        :param pulumi.Input[bool] enable_web_tracking: Determines whether to enable Web Tracking. Default `false`.
        :param pulumi.Input['StoreEncryptConfArgs'] encrypt_conf: Encrypted storage of data, providing data static protection capability, `encrypt_conf` can be updated since 1.188.0+ (only `enable` change is supported when updating logstore). See `encrypt_conf` below.
        :param pulumi.Input[int] hot_ttl: The ttl of hot storage. Default to `30`, at least `30`, hot storage ttl must be less than ttl.
        :param pulumi.Input[int] max_split_shard_count: The maximum number of shards for automatic split, which is in the range of 1 to 256. You must specify this parameter when autoSplit is true.
        :param pulumi.Input[str] mode: The mode of storage. Default to `standard`, must be `standard` or `query`.
        :param pulumi.Input[str] name: The log store, which is unique in the same project.
        :param pulumi.Input[int] retention_period: The data retention time (in days). Valid values: [1-3650]. Default to `30`. Log store data will be stored permanently when the value is `3650`.
        :param pulumi.Input[int] shard_count: The number of shards in this log store. Default to 2. You can modify it by "Split" or "Merge" operations. [Refer to details](https://www.alibabacloud.com/help/doc-detail/28976.htm)
        :param pulumi.Input[str] telemetry_type: Determines whether store type is metric. `Metrics` means metric store, empty means log store.
        """
        pulumi.set(__self__, "project", project)
        if append_meta is not None:
            pulumi.set(__self__, "append_meta", append_meta)
        if auto_split is not None:
            pulumi.set(__self__, "auto_split", auto_split)
        if enable_web_tracking is not None:
            pulumi.set(__self__, "enable_web_tracking", enable_web_tracking)
        if encrypt_conf is not None:
            pulumi.set(__self__, "encrypt_conf", encrypt_conf)
        if hot_ttl is not None:
            pulumi.set(__self__, "hot_ttl", hot_ttl)
        if max_split_shard_count is not None:
            pulumi.set(__self__, "max_split_shard_count", max_split_shard_count)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if shard_count is not None:
            pulumi.set(__self__, "shard_count", shard_count)
        if telemetry_type is not None:
            pulumi.set(__self__, "telemetry_type", telemetry_type)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The project name to the log store belongs.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="appendMeta")
    def append_meta(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether to append log meta automatically. The meta includes log receive time and client IP address. Default to `true`.
        """
        return pulumi.get(self, "append_meta")

    @append_meta.setter
    def append_meta(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "append_meta", value)

    @property
    @pulumi.getter(name="autoSplit")
    def auto_split(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether to automatically split a shard. Default to `false`.
        """
        return pulumi.get(self, "auto_split")

    @auto_split.setter
    def auto_split(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_split", value)

    @property
    @pulumi.getter(name="enableWebTracking")
    def enable_web_tracking(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether to enable Web Tracking. Default `false`.
        """
        return pulumi.get(self, "enable_web_tracking")

    @enable_web_tracking.setter
    def enable_web_tracking(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_web_tracking", value)

    @property
    @pulumi.getter(name="encryptConf")
    def encrypt_conf(self) -> Optional[pulumi.Input['StoreEncryptConfArgs']]:
        """
        Encrypted storage of data, providing data static protection capability, `encrypt_conf` can be updated since 1.188.0+ (only `enable` change is supported when updating logstore). See `encrypt_conf` below.
        """
        return pulumi.get(self, "encrypt_conf")

    @encrypt_conf.setter
    def encrypt_conf(self, value: Optional[pulumi.Input['StoreEncryptConfArgs']]):
        pulumi.set(self, "encrypt_conf", value)

    @property
    @pulumi.getter(name="hotTtl")
    def hot_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The ttl of hot storage. Default to `30`, at least `30`, hot storage ttl must be less than ttl.
        """
        return pulumi.get(self, "hot_ttl")

    @hot_ttl.setter
    def hot_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hot_ttl", value)

    @property
    @pulumi.getter(name="maxSplitShardCount")
    def max_split_shard_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of shards for automatic split, which is in the range of 1 to 256. You must specify this parameter when autoSplit is true.
        """
        return pulumi.get(self, "max_split_shard_count")

    @max_split_shard_count.setter
    def max_split_shard_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_split_shard_count", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        The mode of storage. Default to `standard`, must be `standard` or `query`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The log store, which is unique in the same project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        The data retention time (in days). Valid values: [1-3650]. Default to `30`. Log store data will be stored permanently when the value is `3650`.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_period", value)

    @property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of shards in this log store. Default to 2. You can modify it by "Split" or "Merge" operations. [Refer to details](https://www.alibabacloud.com/help/doc-detail/28976.htm)
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shard_count", value)

    @property
    @pulumi.getter(name="telemetryType")
    def telemetry_type(self) -> Optional[pulumi.Input[str]]:
        """
        Determines whether store type is metric. `Metrics` means metric store, empty means log store.
        """
        return pulumi.get(self, "telemetry_type")

    @telemetry_type.setter
    def telemetry_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "telemetry_type", value)


@pulumi.input_type
class _StoreState:
    def __init__(__self__, *,
                 append_meta: Optional[pulumi.Input[bool]] = None,
                 auto_split: Optional[pulumi.Input[bool]] = None,
                 enable_web_tracking: Optional[pulumi.Input[bool]] = None,
                 encrypt_conf: Optional[pulumi.Input['StoreEncryptConfArgs']] = None,
                 hot_ttl: Optional[pulumi.Input[int]] = None,
                 max_split_shard_count: Optional[pulumi.Input[int]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 retention_period: Optional[pulumi.Input[int]] = None,
                 shard_count: Optional[pulumi.Input[int]] = None,
                 shards: Optional[pulumi.Input[Sequence[pulumi.Input['StoreShardArgs']]]] = None,
                 telemetry_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Store resources.
        :param pulumi.Input[bool] append_meta: Determines whether to append log meta automatically. The meta includes log receive time and client IP address. Default to `true`.
        :param pulumi.Input[bool] auto_split: Determines whether to automatically split a shard. Default to `false`.
        :param pulumi.Input[bool] enable_web_tracking: Determines whether to enable Web Tracking. Default `false`.
        :param pulumi.Input['StoreEncryptConfArgs'] encrypt_conf: Encrypted storage of data, providing data static protection capability, `encrypt_conf` can be updated since 1.188.0+ (only `enable` change is supported when updating logstore). See `encrypt_conf` below.
        :param pulumi.Input[int] hot_ttl: The ttl of hot storage. Default to `30`, at least `30`, hot storage ttl must be less than ttl.
        :param pulumi.Input[int] max_split_shard_count: The maximum number of shards for automatic split, which is in the range of 1 to 256. You must specify this parameter when autoSplit is true.
        :param pulumi.Input[str] mode: The mode of storage. Default to `standard`, must be `standard` or `query`.
        :param pulumi.Input[str] name: The log store, which is unique in the same project.
        :param pulumi.Input[str] project: The project name to the log store belongs.
        :param pulumi.Input[int] retention_period: The data retention time (in days). Valid values: [1-3650]. Default to `30`. Log store data will be stored permanently when the value is `3650`.
        :param pulumi.Input[int] shard_count: The number of shards in this log store. Default to 2. You can modify it by "Split" or "Merge" operations. [Refer to details](https://www.alibabacloud.com/help/doc-detail/28976.htm)
        :param pulumi.Input[Sequence[pulumi.Input['StoreShardArgs']]] shards: The shard attribute.
        :param pulumi.Input[str] telemetry_type: Determines whether store type is metric. `Metrics` means metric store, empty means log store.
        """
        if append_meta is not None:
            pulumi.set(__self__, "append_meta", append_meta)
        if auto_split is not None:
            pulumi.set(__self__, "auto_split", auto_split)
        if enable_web_tracking is not None:
            pulumi.set(__self__, "enable_web_tracking", enable_web_tracking)
        if encrypt_conf is not None:
            pulumi.set(__self__, "encrypt_conf", encrypt_conf)
        if hot_ttl is not None:
            pulumi.set(__self__, "hot_ttl", hot_ttl)
        if max_split_shard_count is not None:
            pulumi.set(__self__, "max_split_shard_count", max_split_shard_count)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if shard_count is not None:
            pulumi.set(__self__, "shard_count", shard_count)
        if shards is not None:
            pulumi.set(__self__, "shards", shards)
        if telemetry_type is not None:
            pulumi.set(__self__, "telemetry_type", telemetry_type)

    @property
    @pulumi.getter(name="appendMeta")
    def append_meta(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether to append log meta automatically. The meta includes log receive time and client IP address. Default to `true`.
        """
        return pulumi.get(self, "append_meta")

    @append_meta.setter
    def append_meta(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "append_meta", value)

    @property
    @pulumi.getter(name="autoSplit")
    def auto_split(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether to automatically split a shard. Default to `false`.
        """
        return pulumi.get(self, "auto_split")

    @auto_split.setter
    def auto_split(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_split", value)

    @property
    @pulumi.getter(name="enableWebTracking")
    def enable_web_tracking(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether to enable Web Tracking. Default `false`.
        """
        return pulumi.get(self, "enable_web_tracking")

    @enable_web_tracking.setter
    def enable_web_tracking(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_web_tracking", value)

    @property
    @pulumi.getter(name="encryptConf")
    def encrypt_conf(self) -> Optional[pulumi.Input['StoreEncryptConfArgs']]:
        """
        Encrypted storage of data, providing data static protection capability, `encrypt_conf` can be updated since 1.188.0+ (only `enable` change is supported when updating logstore). See `encrypt_conf` below.
        """
        return pulumi.get(self, "encrypt_conf")

    @encrypt_conf.setter
    def encrypt_conf(self, value: Optional[pulumi.Input['StoreEncryptConfArgs']]):
        pulumi.set(self, "encrypt_conf", value)

    @property
    @pulumi.getter(name="hotTtl")
    def hot_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The ttl of hot storage. Default to `30`, at least `30`, hot storage ttl must be less than ttl.
        """
        return pulumi.get(self, "hot_ttl")

    @hot_ttl.setter
    def hot_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hot_ttl", value)

    @property
    @pulumi.getter(name="maxSplitShardCount")
    def max_split_shard_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of shards for automatic split, which is in the range of 1 to 256. You must specify this parameter when autoSplit is true.
        """
        return pulumi.get(self, "max_split_shard_count")

    @max_split_shard_count.setter
    def max_split_shard_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_split_shard_count", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        The mode of storage. Default to `standard`, must be `standard` or `query`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The log store, which is unique in the same project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project name to the log store belongs.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        The data retention time (in days). Valid values: [1-3650]. Default to `30`. Log store data will be stored permanently when the value is `3650`.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_period", value)

    @property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of shards in this log store. Default to 2. You can modify it by "Split" or "Merge" operations. [Refer to details](https://www.alibabacloud.com/help/doc-detail/28976.htm)
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shard_count", value)

    @property
    @pulumi.getter
    def shards(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StoreShardArgs']]]]:
        """
        The shard attribute.
        """
        return pulumi.get(self, "shards")

    @shards.setter
    def shards(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StoreShardArgs']]]]):
        pulumi.set(self, "shards", value)

    @property
    @pulumi.getter(name="telemetryType")
    def telemetry_type(self) -> Optional[pulumi.Input[str]]:
        """
        Determines whether store type is metric. `Metrics` means metric store, empty means log store.
        """
        return pulumi.get(self, "telemetry_type")

    @telemetry_type.setter
    def telemetry_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "telemetry_type", value)


class Store(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 append_meta: Optional[pulumi.Input[bool]] = None,
                 auto_split: Optional[pulumi.Input[bool]] = None,
                 enable_web_tracking: Optional[pulumi.Input[bool]] = None,
                 encrypt_conf: Optional[pulumi.Input[pulumi.InputType['StoreEncryptConfArgs']]] = None,
                 hot_ttl: Optional[pulumi.Input[int]] = None,
                 max_split_shard_count: Optional[pulumi.Input[int]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 retention_period: Optional[pulumi.Input[int]] = None,
                 shard_count: Optional[pulumi.Input[int]] = None,
                 telemetry_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The log store is a unit in Log Service to collect, store, and query the log data. Each log store belongs to a project,
        and each project can create multiple Logstores. [Refer to details](https://www.alibabacloud.com/help/doc-detail/48874.htm)

        > **NOTE:** Available since v1.0.0.
        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.RandomInteger("default",
            max=99999,
            min=10000)
        example_project = alicloud.log.Project("exampleProject", description="terraform-example")
        example_store = alicloud.log.Store("exampleStore",
            project=example_project.name,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        ```

        Encrypt Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        example_account = alicloud.get_account()
        default = random.RandomInteger("default",
            max=99999,
            min=10000)
        example_key = alicloud.kms.Key("exampleKey",
            description="terraform-example",
            pending_window_in_days=7,
            status="Enabled")
        example_project = alicloud.log.Project("exampleProject", description="terraform-example")
        example_store = alicloud.log.Store("exampleStore",
            project=example_project.name,
            shard_count=1,
            auto_split=True,
            max_split_shard_count=60,
            encrypt_conf=alicloud.log.StoreEncryptConfArgs(
                enable=True,
                encrypt_type="default",
                user_cmk_info=alicloud.log.StoreEncryptConfUserCmkInfoArgs(
                    cmk_key_id=example_key.id,
                    arn=f"acs:ram::{example_account.id}:role/aliyunlogdefaultrole",
                    region_id=region,
                ),
            ))
        ```
        ## Module Support

        You can use the existing sls module
        to create SLS project, store and store index one-click, like ECS instances.

        ## Import

        Log store can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:log/store:Store example tf-log:tf-log-store
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] append_meta: Determines whether to append log meta automatically. The meta includes log receive time and client IP address. Default to `true`.
        :param pulumi.Input[bool] auto_split: Determines whether to automatically split a shard. Default to `false`.
        :param pulumi.Input[bool] enable_web_tracking: Determines whether to enable Web Tracking. Default `false`.
        :param pulumi.Input[pulumi.InputType['StoreEncryptConfArgs']] encrypt_conf: Encrypted storage of data, providing data static protection capability, `encrypt_conf` can be updated since 1.188.0+ (only `enable` change is supported when updating logstore). See `encrypt_conf` below.
        :param pulumi.Input[int] hot_ttl: The ttl of hot storage. Default to `30`, at least `30`, hot storage ttl must be less than ttl.
        :param pulumi.Input[int] max_split_shard_count: The maximum number of shards for automatic split, which is in the range of 1 to 256. You must specify this parameter when autoSplit is true.
        :param pulumi.Input[str] mode: The mode of storage. Default to `standard`, must be `standard` or `query`.
        :param pulumi.Input[str] name: The log store, which is unique in the same project.
        :param pulumi.Input[str] project: The project name to the log store belongs.
        :param pulumi.Input[int] retention_period: The data retention time (in days). Valid values: [1-3650]. Default to `30`. Log store data will be stored permanently when the value is `3650`.
        :param pulumi.Input[int] shard_count: The number of shards in this log store. Default to 2. You can modify it by "Split" or "Merge" operations. [Refer to details](https://www.alibabacloud.com/help/doc-detail/28976.htm)
        :param pulumi.Input[str] telemetry_type: Determines whether store type is metric. `Metrics` means metric store, empty means log store.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The log store is a unit in Log Service to collect, store, and query the log data. Each log store belongs to a project,
        and each project can create multiple Logstores. [Refer to details](https://www.alibabacloud.com/help/doc-detail/48874.htm)

        > **NOTE:** Available since v1.0.0.
        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.RandomInteger("default",
            max=99999,
            min=10000)
        example_project = alicloud.log.Project("exampleProject", description="terraform-example")
        example_store = alicloud.log.Store("exampleStore",
            project=example_project.name,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        ```

        Encrypt Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        example_account = alicloud.get_account()
        default = random.RandomInteger("default",
            max=99999,
            min=10000)
        example_key = alicloud.kms.Key("exampleKey",
            description="terraform-example",
            pending_window_in_days=7,
            status="Enabled")
        example_project = alicloud.log.Project("exampleProject", description="terraform-example")
        example_store = alicloud.log.Store("exampleStore",
            project=example_project.name,
            shard_count=1,
            auto_split=True,
            max_split_shard_count=60,
            encrypt_conf=alicloud.log.StoreEncryptConfArgs(
                enable=True,
                encrypt_type="default",
                user_cmk_info=alicloud.log.StoreEncryptConfUserCmkInfoArgs(
                    cmk_key_id=example_key.id,
                    arn=f"acs:ram::{example_account.id}:role/aliyunlogdefaultrole",
                    region_id=region,
                ),
            ))
        ```
        ## Module Support

        You can use the existing sls module
        to create SLS project, store and store index one-click, like ECS instances.

        ## Import

        Log store can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:log/store:Store example tf-log:tf-log-store
        ```

        :param str resource_name: The name of the resource.
        :param StoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 append_meta: Optional[pulumi.Input[bool]] = None,
                 auto_split: Optional[pulumi.Input[bool]] = None,
                 enable_web_tracking: Optional[pulumi.Input[bool]] = None,
                 encrypt_conf: Optional[pulumi.Input[pulumi.InputType['StoreEncryptConfArgs']]] = None,
                 hot_ttl: Optional[pulumi.Input[int]] = None,
                 max_split_shard_count: Optional[pulumi.Input[int]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 retention_period: Optional[pulumi.Input[int]] = None,
                 shard_count: Optional[pulumi.Input[int]] = None,
                 telemetry_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StoreArgs.__new__(StoreArgs)

            __props__.__dict__["append_meta"] = append_meta
            __props__.__dict__["auto_split"] = auto_split
            __props__.__dict__["enable_web_tracking"] = enable_web_tracking
            __props__.__dict__["encrypt_conf"] = encrypt_conf
            __props__.__dict__["hot_ttl"] = hot_ttl
            __props__.__dict__["max_split_shard_count"] = max_split_shard_count
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["retention_period"] = retention_period
            __props__.__dict__["shard_count"] = shard_count
            __props__.__dict__["telemetry_type"] = telemetry_type
            __props__.__dict__["shards"] = None
        super(Store, __self__).__init__(
            'alicloud:log/store:Store',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            append_meta: Optional[pulumi.Input[bool]] = None,
            auto_split: Optional[pulumi.Input[bool]] = None,
            enable_web_tracking: Optional[pulumi.Input[bool]] = None,
            encrypt_conf: Optional[pulumi.Input[pulumi.InputType['StoreEncryptConfArgs']]] = None,
            hot_ttl: Optional[pulumi.Input[int]] = None,
            max_split_shard_count: Optional[pulumi.Input[int]] = None,
            mode: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            retention_period: Optional[pulumi.Input[int]] = None,
            shard_count: Optional[pulumi.Input[int]] = None,
            shards: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StoreShardArgs']]]]] = None,
            telemetry_type: Optional[pulumi.Input[str]] = None) -> 'Store':
        """
        Get an existing Store resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] append_meta: Determines whether to append log meta automatically. The meta includes log receive time and client IP address. Default to `true`.
        :param pulumi.Input[bool] auto_split: Determines whether to automatically split a shard. Default to `false`.
        :param pulumi.Input[bool] enable_web_tracking: Determines whether to enable Web Tracking. Default `false`.
        :param pulumi.Input[pulumi.InputType['StoreEncryptConfArgs']] encrypt_conf: Encrypted storage of data, providing data static protection capability, `encrypt_conf` can be updated since 1.188.0+ (only `enable` change is supported when updating logstore). See `encrypt_conf` below.
        :param pulumi.Input[int] hot_ttl: The ttl of hot storage. Default to `30`, at least `30`, hot storage ttl must be less than ttl.
        :param pulumi.Input[int] max_split_shard_count: The maximum number of shards for automatic split, which is in the range of 1 to 256. You must specify this parameter when autoSplit is true.
        :param pulumi.Input[str] mode: The mode of storage. Default to `standard`, must be `standard` or `query`.
        :param pulumi.Input[str] name: The log store, which is unique in the same project.
        :param pulumi.Input[str] project: The project name to the log store belongs.
        :param pulumi.Input[int] retention_period: The data retention time (in days). Valid values: [1-3650]. Default to `30`. Log store data will be stored permanently when the value is `3650`.
        :param pulumi.Input[int] shard_count: The number of shards in this log store. Default to 2. You can modify it by "Split" or "Merge" operations. [Refer to details](https://www.alibabacloud.com/help/doc-detail/28976.htm)
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StoreShardArgs']]]] shards: The shard attribute.
        :param pulumi.Input[str] telemetry_type: Determines whether store type is metric. `Metrics` means metric store, empty means log store.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StoreState.__new__(_StoreState)

        __props__.__dict__["append_meta"] = append_meta
        __props__.__dict__["auto_split"] = auto_split
        __props__.__dict__["enable_web_tracking"] = enable_web_tracking
        __props__.__dict__["encrypt_conf"] = encrypt_conf
        __props__.__dict__["hot_ttl"] = hot_ttl
        __props__.__dict__["max_split_shard_count"] = max_split_shard_count
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["retention_period"] = retention_period
        __props__.__dict__["shard_count"] = shard_count
        __props__.__dict__["shards"] = shards
        __props__.__dict__["telemetry_type"] = telemetry_type
        return Store(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appendMeta")
    def append_meta(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines whether to append log meta automatically. The meta includes log receive time and client IP address. Default to `true`.
        """
        return pulumi.get(self, "append_meta")

    @property
    @pulumi.getter(name="autoSplit")
    def auto_split(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines whether to automatically split a shard. Default to `false`.
        """
        return pulumi.get(self, "auto_split")

    @property
    @pulumi.getter(name="enableWebTracking")
    def enable_web_tracking(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines whether to enable Web Tracking. Default `false`.
        """
        return pulumi.get(self, "enable_web_tracking")

    @property
    @pulumi.getter(name="encryptConf")
    def encrypt_conf(self) -> pulumi.Output[Optional['outputs.StoreEncryptConf']]:
        """
        Encrypted storage of data, providing data static protection capability, `encrypt_conf` can be updated since 1.188.0+ (only `enable` change is supported when updating logstore). See `encrypt_conf` below.
        """
        return pulumi.get(self, "encrypt_conf")

    @property
    @pulumi.getter(name="hotTtl")
    def hot_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        The ttl of hot storage. Default to `30`, at least `30`, hot storage ttl must be less than ttl.
        """
        return pulumi.get(self, "hot_ttl")

    @property
    @pulumi.getter(name="maxSplitShardCount")
    def max_split_shard_count(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of shards for automatic split, which is in the range of 1 to 256. You must specify this parameter when autoSplit is true.
        """
        return pulumi.get(self, "max_split_shard_count")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional[str]]:
        """
        The mode of storage. Default to `standard`, must be `standard` or `query`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The log store, which is unique in the same project.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The project name to the log store belongs.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> pulumi.Output[Optional[int]]:
        """
        The data retention time (in days). Valid values: [1-3650]. Default to `30`. Log store data will be stored permanently when the value is `3650`.
        """
        return pulumi.get(self, "retention_period")

    @property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> pulumi.Output[Optional[int]]:
        """
        The number of shards in this log store. Default to 2. You can modify it by "Split" or "Merge" operations. [Refer to details](https://www.alibabacloud.com/help/doc-detail/28976.htm)
        """
        return pulumi.get(self, "shard_count")

    @property
    @pulumi.getter
    def shards(self) -> pulumi.Output[Sequence['outputs.StoreShard']]:
        """
        The shard attribute.
        """
        return pulumi.get(self, "shards")

    @property
    @pulumi.getter(name="telemetryType")
    def telemetry_type(self) -> pulumi.Output[Optional[str]]:
        """
        Determines whether store type is metric. `Metrics` means metric store, empty means log store.
        """
        return pulumi.get(self, "telemetry_type")

