# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetTopicsResult',
    'AwaitableGetTopicsResult',
    'get_topics',
    'get_topics_output',
]

@pulumi.output_type
class GetTopicsResult:
    """
    A collection of values returned by getTopics.
    """
    def __init__(__self__, id=None, name_prefix=None, names=None, output_file=None, topics=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name_prefix and not isinstance(name_prefix, str):
            raise TypeError("Expected argument 'name_prefix' to be a str")
        pulumi.set(__self__, "name_prefix", name_prefix)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if topics and not isinstance(topics, list):
            raise TypeError("Expected argument 'topics' to be a list")
        pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[str]:
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        A list of topic names.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def topics(self) -> Sequence['outputs.GetTopicsTopicResult']:
        """
        A list of topics. Each element contains the following attributes:
        """
        return pulumi.get(self, "topics")


class AwaitableGetTopicsResult(GetTopicsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTopicsResult(
            id=self.id,
            name_prefix=self.name_prefix,
            names=self.names,
            output_file=self.output_file,
            topics=self.topics)


def get_topics(name_prefix: Optional[str] = None,
               output_file: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTopicsResult:
    """
    This data source provides a list of MNS topics in an Alibaba Cloud account according to the specified parameters.

    > **DEPRECATED:**  This datasource has been deprecated from version `1.188.0`. Please use new datasource message_service_topics.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    topics = alicloud.mns.get_topics(name_prefix="tf-")
    pulumi.export("firstTopicId", topics.topics[0].id)
    ```


    :param str name_prefix: A string to filter resulting topics by their name prefixs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['namePrefix'] = name_prefix
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:mns/getTopics:getTopics', __args__, opts=opts, typ=GetTopicsResult).value

    return AwaitableGetTopicsResult(
        id=pulumi.get(__ret__, 'id'),
        name_prefix=pulumi.get(__ret__, 'name_prefix'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        topics=pulumi.get(__ret__, 'topics'))


@_utilities.lift_output_func(get_topics)
def get_topics_output(name_prefix: Optional[pulumi.Input[Optional[str]]] = None,
                      output_file: Optional[pulumi.Input[Optional[str]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTopicsResult]:
    """
    This data source provides a list of MNS topics in an Alibaba Cloud account according to the specified parameters.

    > **DEPRECATED:**  This datasource has been deprecated from version `1.188.0`. Please use new datasource message_service_topics.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    topics = alicloud.mns.get_topics(name_prefix="tf-")
    pulumi.export("firstTopicId", topics.topics[0].id)
    ```


    :param str name_prefix: A string to filter resulting topics by their name prefixs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    ...
