# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetServerlessInstancesResult',
    'AwaitableGetServerlessInstancesResult',
    'get_serverless_instances',
    'get_serverless_instances_output',
]

@pulumi.output_type
class GetServerlessInstancesResult:
    """
    A collection of values returned by getServerlessInstances.
    """
    def __init__(__self__, db_instance_class=None, db_instance_description=None, enable_details=None, id=None, ids=None, instances=None, network_type=None, output_file=None, resource_group_id=None, status=None, tags=None, vpc_id=None, vswitch_id=None, zone_id=None):
        if db_instance_class and not isinstance(db_instance_class, str):
            raise TypeError("Expected argument 'db_instance_class' to be a str")
        pulumi.set(__self__, "db_instance_class", db_instance_class)
        if db_instance_description and not isinstance(db_instance_description, str):
            raise TypeError("Expected argument 'db_instance_description' to be a str")
        pulumi.set(__self__, "db_instance_description", db_instance_description)
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if network_type and not isinstance(network_type, str):
            raise TypeError("Expected argument 'network_type' to be a str")
        pulumi.set(__self__, "network_type", network_type)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id and not isinstance(vswitch_id, str):
            raise TypeError("Expected argument 'vswitch_id' to be a str")
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="dbInstanceClass")
    def db_instance_class(self) -> Optional[str]:
        return pulumi.get(self, "db_instance_class")

    @property
    @pulumi.getter(name="dbInstanceDescription")
    def db_instance_description(self) -> Optional[str]:
        return pulumi.get(self, "db_instance_description")

    @property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[bool]:
        return pulumi.get(self, "enable_details")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetServerlessInstancesInstanceResult']:
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[str]:
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[str]:
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[str]:
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[str]:
        return pulumi.get(self, "zone_id")


class AwaitableGetServerlessInstancesResult(GetServerlessInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerlessInstancesResult(
            db_instance_class=self.db_instance_class,
            db_instance_description=self.db_instance_description,
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            instances=self.instances,
            network_type=self.network_type,
            output_file=self.output_file,
            resource_group_id=self.resource_group_id,
            status=self.status,
            tags=self.tags,
            vpc_id=self.vpc_id,
            vswitch_id=self.vswitch_id,
            zone_id=self.zone_id)


def get_serverless_instances(db_instance_class: Optional[str] = None,
                             db_instance_description: Optional[str] = None,
                             enable_details: Optional[bool] = None,
                             ids: Optional[Sequence[str]] = None,
                             network_type: Optional[str] = None,
                             output_file: Optional[str] = None,
                             resource_group_id: Optional[str] = None,
                             status: Optional[str] = None,
                             tags: Optional[Mapping[str, Any]] = None,
                             vpc_id: Optional[str] = None,
                             vswitch_id: Optional[str] = None,
                             zone_id: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerlessInstancesResult:
    """
    This data source provides the Mongodb Serverless Instances of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.148.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.mongodb.get_serverless_instances(ids=["example_value"],
        db_instance_class="example_value",
        db_instance_description="example_value",
        network_type="VPC",
        resource_group_id="example_value",
        status="Running",
        vpc_id="example_value",
        vswitch_id="example_value",
        zone_id="example_value",
        tags={
            "Created": "MongodbServerlessInstance",
            "For": "TF",
        })
    pulumi.export("mongodbServerlessInstanceId1", example.instances[0].id)
    ```


    :param str db_instance_class: The db instance class.
    :param str db_instance_description: The db instance description.
    :param bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[str] ids: A list of Serverless Instance IDs.
    :param str network_type: The network type of the instance.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str resource_group_id: The ID of the resource group.
    :param str status: The status of the instance.
    :param Mapping[str, Any] tags: The tag of the resource.
    :param str vpc_id: The ID of the VPC network.
    :param str vswitch_id: The id of the vswitch.
    :param str zone_id: The ID of the zone.
    """
    __args__ = dict()
    __args__['dbInstanceClass'] = db_instance_class
    __args__['dbInstanceDescription'] = db_instance_description
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['networkType'] = network_type
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    __args__['vswitchId'] = vswitch_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:mongodb/getServerlessInstances:getServerlessInstances', __args__, opts=opts, typ=GetServerlessInstancesResult).value

    return AwaitableGetServerlessInstancesResult(
        db_instance_class=pulumi.get(__ret__, 'db_instance_class'),
        db_instance_description=pulumi.get(__ret__, 'db_instance_description'),
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instances=pulumi.get(__ret__, 'instances'),
        network_type=pulumi.get(__ret__, 'network_type'),
        output_file=pulumi.get(__ret__, 'output_file'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'),
        vswitch_id=pulumi.get(__ret__, 'vswitch_id'),
        zone_id=pulumi.get(__ret__, 'zone_id'))


@_utilities.lift_output_func(get_serverless_instances)
def get_serverless_instances_output(db_instance_class: Optional[pulumi.Input[Optional[str]]] = None,
                                    db_instance_description: Optional[pulumi.Input[Optional[str]]] = None,
                                    enable_details: Optional[pulumi.Input[Optional[bool]]] = None,
                                    ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                    network_type: Optional[pulumi.Input[Optional[str]]] = None,
                                    output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                    resource_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    status: Optional[pulumi.Input[Optional[str]]] = None,
                                    tags: Optional[pulumi.Input[Optional[Mapping[str, Any]]]] = None,
                                    vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    vswitch_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    zone_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServerlessInstancesResult]:
    """
    This data source provides the Mongodb Serverless Instances of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.148.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.mongodb.get_serverless_instances(ids=["example_value"],
        db_instance_class="example_value",
        db_instance_description="example_value",
        network_type="VPC",
        resource_group_id="example_value",
        status="Running",
        vpc_id="example_value",
        vswitch_id="example_value",
        zone_id="example_value",
        tags={
            "Created": "MongodbServerlessInstance",
            "For": "TF",
        })
    pulumi.export("mongodbServerlessInstanceId1", example.instances[0].id)
    ```


    :param str db_instance_class: The db instance class.
    :param str db_instance_description: The db instance description.
    :param bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[str] ids: A list of Serverless Instance IDs.
    :param str network_type: The network type of the instance.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str resource_group_id: The ID of the resource group.
    :param str status: The status of the instance.
    :param Mapping[str, Any] tags: The tag of the resource.
    :param str vpc_id: The ID of the VPC network.
    :param str vswitch_id: The id of the vswitch.
    :param str zone_id: The ID of the zone.
    """
    ...
