# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'InstanceParameter',
    'InstanceReplicaSet',
    'ServerlessInstanceSecurityIpGroup',
    'ShardingInstanceConfigServerList',
    'ShardingInstanceMongoList',
    'ShardingInstanceShardList',
    'ShardingNetworkPrivateAddressNetworkAddress',
    'ShardingNetworkPublicAddressNetworkAddress',
    'GetAccountsAccountResult',
    'GetAuditPoliciesPolicyResult',
    'GetInstancesInstanceResult',
    'GetInstancesInstanceMongoResult',
    'GetInstancesInstanceShardResult',
    'GetServerlessInstancesInstanceResult',
    'GetServerlessInstancesInstanceSecurityIpGroupResult',
    'GetShardingNetworkPrivateAddressesAddressResult',
    'GetShardingNetworkPublicAddressesAddressResult',
    'GetZonesZoneResult',
]

@pulumi.output_type
class InstanceParameter(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The name of the parameter.
        :param str value: The value of the parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InstanceReplicaSet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionDomain":
            suggest = "connection_domain"
        elif key == "connectionPort":
            suggest = "connection_port"
        elif key == "networkType":
            suggest = "network_type"
        elif key == "replicaSetRole":
            suggest = "replica_set_role"
        elif key == "vpcCloudInstanceId":
            suggest = "vpc_cloud_instance_id"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "vswitchId":
            suggest = "vswitch_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceReplicaSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceReplicaSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceReplicaSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_domain: Optional[str] = None,
                 connection_port: Optional[str] = None,
                 network_type: Optional[str] = None,
                 replica_set_role: Optional[str] = None,
                 vpc_cloud_instance_id: Optional[str] = None,
                 vpc_id: Optional[str] = None,
                 vswitch_id: Optional[str] = None):
        """
        :param str connection_domain: The connection address of the node.
        :param str connection_port: The connection port of the node.
        :param str network_type: The network type of the instance. Valid values:`Classic`, `VPC`.
        :param str replica_set_role: The role of the node.
        :param str vpc_cloud_instance_id: VPC instance ID.
        :param str vpc_id: The ID of the VPC. > **NOTE:** `vpc_id` is valid only when `network_type` is set to `VPC`.
        :param str vswitch_id: The virtual switch ID to launch DB instances in one VPC.
        """
        if connection_domain is not None:
            pulumi.set(__self__, "connection_domain", connection_domain)
        if connection_port is not None:
            pulumi.set(__self__, "connection_port", connection_port)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if replica_set_role is not None:
            pulumi.set(__self__, "replica_set_role", replica_set_role)
        if vpc_cloud_instance_id is not None:
            pulumi.set(__self__, "vpc_cloud_instance_id", vpc_cloud_instance_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="connectionDomain")
    def connection_domain(self) -> Optional[str]:
        """
        The connection address of the node.
        """
        return pulumi.get(self, "connection_domain")

    @property
    @pulumi.getter(name="connectionPort")
    def connection_port(self) -> Optional[str]:
        """
        The connection port of the node.
        """
        return pulumi.get(self, "connection_port")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[str]:
        """
        The network type of the instance. Valid values:`Classic`, `VPC`.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="replicaSetRole")
    def replica_set_role(self) -> Optional[str]:
        """
        The role of the node.
        """
        return pulumi.get(self, "replica_set_role")

    @property
    @pulumi.getter(name="vpcCloudInstanceId")
    def vpc_cloud_instance_id(self) -> Optional[str]:
        """
        VPC instance ID.
        """
        return pulumi.get(self, "vpc_cloud_instance_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        The ID of the VPC. > **NOTE:** `vpc_id` is valid only when `network_type` is set to `VPC`.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[str]:
        """
        The virtual switch ID to launch DB instances in one VPC.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class ServerlessInstanceSecurityIpGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityIpGroupAttribute":
            suggest = "security_ip_group_attribute"
        elif key == "securityIpGroupName":
            suggest = "security_ip_group_name"
        elif key == "securityIpList":
            suggest = "security_ip_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerlessInstanceSecurityIpGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerlessInstanceSecurityIpGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerlessInstanceSecurityIpGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_ip_group_attribute: Optional[str] = None,
                 security_ip_group_name: Optional[str] = None,
                 security_ip_list: Optional[str] = None):
        """
        :param str security_ip_group_attribute: The attribute of the IP whitelist. This parameter is empty by default.
        :param str security_ip_group_name: The name of the IP whitelist.
        :param str security_ip_list: The IP addresses in the whitelist.
        """
        if security_ip_group_attribute is not None:
            pulumi.set(__self__, "security_ip_group_attribute", security_ip_group_attribute)
        if security_ip_group_name is not None:
            pulumi.set(__self__, "security_ip_group_name", security_ip_group_name)
        if security_ip_list is not None:
            pulumi.set(__self__, "security_ip_list", security_ip_list)

    @property
    @pulumi.getter(name="securityIpGroupAttribute")
    def security_ip_group_attribute(self) -> Optional[str]:
        """
        The attribute of the IP whitelist. This parameter is empty by default.
        """
        return pulumi.get(self, "security_ip_group_attribute")

    @property
    @pulumi.getter(name="securityIpGroupName")
    def security_ip_group_name(self) -> Optional[str]:
        """
        The name of the IP whitelist.
        """
        return pulumi.get(self, "security_ip_group_name")

    @property
    @pulumi.getter(name="securityIpList")
    def security_ip_list(self) -> Optional[str]:
        """
        The IP addresses in the whitelist.
        """
        return pulumi.get(self, "security_ip_list")


@pulumi.output_type
class ShardingInstanceConfigServerList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectString":
            suggest = "connect_string"
        elif key == "maxConnections":
            suggest = "max_connections"
        elif key == "maxIops":
            suggest = "max_iops"
        elif key == "nodeClass":
            suggest = "node_class"
        elif key == "nodeDescription":
            suggest = "node_description"
        elif key == "nodeId":
            suggest = "node_id"
        elif key == "nodeStorage":
            suggest = "node_storage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShardingInstanceConfigServerList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShardingInstanceConfigServerList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShardingInstanceConfigServerList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_string: Optional[str] = None,
                 max_connections: Optional[int] = None,
                 max_iops: Optional[int] = None,
                 node_class: Optional[str] = None,
                 node_description: Optional[str] = None,
                 node_id: Optional[str] = None,
                 node_storage: Optional[int] = None,
                 port: Optional[int] = None):
        """
        :param str connect_string: The connection address of the Config Server node.
        :param int max_connections: The max connections of the Config Server node.
        :param int max_iops: The maximum IOPS of the Config Server node.
        :param str node_class: The node class of the Config Server node.
        :param str node_description: The description of the Config Server node.
        :param str node_id: The ID of the Config Server node.
        :param int node_storage: The node storage of the Config Server node.
        :param int port: The connection port of the Config Server node.
        """
        if connect_string is not None:
            pulumi.set(__self__, "connect_string", connect_string)
        if max_connections is not None:
            pulumi.set(__self__, "max_connections", max_connections)
        if max_iops is not None:
            pulumi.set(__self__, "max_iops", max_iops)
        if node_class is not None:
            pulumi.set(__self__, "node_class", node_class)
        if node_description is not None:
            pulumi.set(__self__, "node_description", node_description)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if node_storage is not None:
            pulumi.set(__self__, "node_storage", node_storage)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="connectString")
    def connect_string(self) -> Optional[str]:
        """
        The connection address of the Config Server node.
        """
        return pulumi.get(self, "connect_string")

    @property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> Optional[int]:
        """
        The max connections of the Config Server node.
        """
        return pulumi.get(self, "max_connections")

    @property
    @pulumi.getter(name="maxIops")
    def max_iops(self) -> Optional[int]:
        """
        The maximum IOPS of the Config Server node.
        """
        return pulumi.get(self, "max_iops")

    @property
    @pulumi.getter(name="nodeClass")
    def node_class(self) -> Optional[str]:
        """
        The node class of the Config Server node.
        """
        return pulumi.get(self, "node_class")

    @property
    @pulumi.getter(name="nodeDescription")
    def node_description(self) -> Optional[str]:
        """
        The description of the Config Server node.
        """
        return pulumi.get(self, "node_description")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[str]:
        """
        The ID of the Config Server node.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeStorage")
    def node_storage(self) -> Optional[int]:
        """
        The node storage of the Config Server node.
        """
        return pulumi.get(self, "node_storage")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The connection port of the Config Server node.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ShardingInstanceMongoList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeClass":
            suggest = "node_class"
        elif key == "connectString":
            suggest = "connect_string"
        elif key == "nodeId":
            suggest = "node_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShardingInstanceMongoList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShardingInstanceMongoList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShardingInstanceMongoList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_class: str,
                 connect_string: Optional[str] = None,
                 node_id: Optional[str] = None,
                 port: Optional[int] = None):
        """
        :param str node_class: Node specification. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
        :param str connect_string: Mongo node connection string.
        :param str node_id: The ID of the mongo-node.
        :param int port: Mongo node port.
        """
        pulumi.set(__self__, "node_class", node_class)
        if connect_string is not None:
            pulumi.set(__self__, "connect_string", connect_string)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="nodeClass")
    def node_class(self) -> str:
        """
        Node specification. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
        """
        return pulumi.get(self, "node_class")

    @property
    @pulumi.getter(name="connectString")
    def connect_string(self) -> Optional[str]:
        """
        Mongo node connection string.
        """
        return pulumi.get(self, "connect_string")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[str]:
        """
        The ID of the mongo-node.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Mongo node port.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ShardingInstanceShardList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeClass":
            suggest = "node_class"
        elif key == "nodeStorage":
            suggest = "node_storage"
        elif key == "nodeId":
            suggest = "node_id"
        elif key == "readonlyReplicas":
            suggest = "readonly_replicas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShardingInstanceShardList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShardingInstanceShardList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShardingInstanceShardList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_class: str,
                 node_storage: int,
                 node_id: Optional[str] = None,
                 readonly_replicas: Optional[int] = None):
        """
        :param str node_class: Node specification. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
        :param int node_storage: - Custom storage space; value range: [10, 1,000]
               - 10-GB increments. Unit: GB.
        :param str node_id: The ID of the shard-node.
        :param int readonly_replicas: The number of read-only nodes in shard node. Valid values: 0 to 5. Default value: 0.
        """
        pulumi.set(__self__, "node_class", node_class)
        pulumi.set(__self__, "node_storage", node_storage)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if readonly_replicas is not None:
            pulumi.set(__self__, "readonly_replicas", readonly_replicas)

    @property
    @pulumi.getter(name="nodeClass")
    def node_class(self) -> str:
        """
        Node specification. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
        """
        return pulumi.get(self, "node_class")

    @property
    @pulumi.getter(name="nodeStorage")
    def node_storage(self) -> int:
        """
        - Custom storage space; value range: [10, 1,000]
        - 10-GB increments. Unit: GB.
        """
        return pulumi.get(self, "node_storage")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[str]:
        """
        The ID of the shard-node.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="readonlyReplicas")
    def readonly_replicas(self) -> Optional[int]:
        """
        The number of read-only nodes in shard node. Valid values: 0 to 5. Default value: 0.
        """
        return pulumi.get(self, "readonly_replicas")


@pulumi.output_type
class ShardingNetworkPrivateAddressNetworkAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiredTime":
            suggest = "expired_time"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "networkAddress":
            suggest = "network_address"
        elif key == "networkType":
            suggest = "network_type"
        elif key == "nodeId":
            suggest = "node_id"
        elif key == "nodeType":
            suggest = "node_type"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "vswitchId":
            suggest = "vswitch_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShardingNetworkPrivateAddressNetworkAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShardingNetworkPrivateAddressNetworkAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShardingNetworkPrivateAddressNetworkAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expired_time: Optional[str] = None,
                 ip_address: Optional[str] = None,
                 network_address: Optional[str] = None,
                 network_type: Optional[str] = None,
                 node_id: Optional[str] = None,
                 node_type: Optional[str] = None,
                 port: Optional[str] = None,
                 role: Optional[str] = None,
                 vpc_id: Optional[str] = None,
                 vswitch_id: Optional[str] = None):
        """
        :param str expired_time: The remaining duration of the classic network address. Unit: `seconds`.
        :param str ip_address: The IP address of the instance.
        :param str network_address: The endpoint of the instance.
        :param str network_type: The network type.
        :param str node_id: The ID of the Shard node or the ConfigServer node.
        :param str node_type: The type of the node.
        :param str port: The port number.
        :param str role: The role of the node.
        :param str vpc_id: The ID of the VPC.
        :param str vswitch_id: The vSwitch ID of the VPC.
        """
        if expired_time is not None:
            pulumi.set(__self__, "expired_time", expired_time)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if network_address is not None:
            pulumi.set(__self__, "network_address", network_address)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> Optional[str]:
        """
        The remaining duration of the classic network address. Unit: `seconds`.
        """
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        The IP address of the instance.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> Optional[str]:
        """
        The endpoint of the instance.
        """
        return pulumi.get(self, "network_address")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[str]:
        """
        The network type.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[str]:
        """
        The ID of the Shard node or the ConfigServer node.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[str]:
        """
        The type of the node.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        The port number.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        """
        The role of the node.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[str]:
        """
        The vSwitch ID of the VPC.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class ShardingNetworkPublicAddressNetworkAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiredTime":
            suggest = "expired_time"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "networkAddress":
            suggest = "network_address"
        elif key == "networkType":
            suggest = "network_type"
        elif key == "nodeId":
            suggest = "node_id"
        elif key == "nodeType":
            suggest = "node_type"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "vswitchId":
            suggest = "vswitch_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShardingNetworkPublicAddressNetworkAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShardingNetworkPublicAddressNetworkAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShardingNetworkPublicAddressNetworkAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expired_time: Optional[str] = None,
                 ip_address: Optional[str] = None,
                 network_address: Optional[str] = None,
                 network_type: Optional[str] = None,
                 node_id: Optional[str] = None,
                 node_type: Optional[str] = None,
                 port: Optional[str] = None,
                 role: Optional[str] = None,
                 vpc_id: Optional[str] = None,
                 vswitch_id: Optional[str] = None):
        """
        :param str expired_time: The remaining duration of the classic network address. Unit: `seconds`.
        :param str ip_address: The IP address of the instance.
        :param str network_address: The endpoint of the instance.
        :param str network_type: The network type.
        :param str node_id: The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
        :param str node_type: The type of the node.
        :param str port: The port number.
        :param str role: The role of the node.
        :param str vpc_id: The ID of the VPC.
        :param str vswitch_id: The vSwitch ID of the VPC.
        """
        if expired_time is not None:
            pulumi.set(__self__, "expired_time", expired_time)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if network_address is not None:
            pulumi.set(__self__, "network_address", network_address)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> Optional[str]:
        """
        The remaining duration of the classic network address. Unit: `seconds`.
        """
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        The IP address of the instance.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> Optional[str]:
        """
        The endpoint of the instance.
        """
        return pulumi.get(self, "network_address")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[str]:
        """
        The network type.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[str]:
        """
        The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[str]:
        """
        The type of the node.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        The port number.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        """
        The role of the node.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[str]:
        """
        The vSwitch ID of the VPC.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetAccountsAccountResult(dict):
    def __init__(__self__, *,
                 account_description: str,
                 account_name: str,
                 character_type: str,
                 id: str,
                 instance_id: str,
                 status: str):
        """
        :param str account_description: The description of the account.
        :param str account_name: The name of the account.
        :param str character_type: The role of the account. Valid values: `db`, `cs`, `mongos`, `logic`, `normal`.
        :param str id: The ID of the Account. The value formats as `<instance_id>:<account_name>`.
        :param str instance_id: The id of the instance to which the account belongs.
        :param str status: The status of the account. Valid values: `Unavailable`, `Available`.
        """
        pulumi.set(__self__, "account_description", account_description)
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "character_type", character_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="accountDescription")
    def account_description(self) -> str:
        """
        The description of the account.
        """
        return pulumi.get(self, "account_description")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        The name of the account.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="characterType")
    def character_type(self) -> str:
        """
        The role of the account. Valid values: `db`, `cs`, `mongos`, `logic`, `normal`.
        """
        return pulumi.get(self, "character_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Account. The value formats as `<instance_id>:<account_name>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The id of the instance to which the account belongs.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the account. Valid values: `Unavailable`, `Available`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetAuditPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 audit_status: str,
                 db_instance_id: str,
                 id: str):
        """
        :param str audit_status: The status of the log audit feature.
        :param str db_instance_id: The ID of the instance.
        :param str id: The ID of the Audit Policy.
        """
        pulumi.set(__self__, "audit_status", audit_status)
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="auditStatus")
    def audit_status(self) -> str:
        """
        The status of the log audit feature.
        """
        return pulumi.get(self, "audit_status")

    @property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> str:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "db_instance_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Audit Policy.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 charge_type: str,
                 creation_time: str,
                 engine: str,
                 engine_version: str,
                 expiration_time: str,
                 id: str,
                 instance_class: str,
                 instance_type: str,
                 lock_mode: str,
                 mongos: Sequence['outputs.GetInstancesInstanceMongoResult'],
                 name: str,
                 network_type: str,
                 region_id: str,
                 replication: str,
                 shards: Sequence['outputs.GetInstancesInstanceShardResult'],
                 status: str,
                 storage: int,
                 tags: Mapping[str, Any]):
        """
        :param str availability_zone: Instance availability zone.
        :param str charge_type: Billing method. Value options are `PostPaid` for  Pay-As-You-Go and `PrePaid` for yearly or monthly subscription.
        :param str creation_time: Creation time of the instance in RFC3339 format.
        :param str engine: Database engine type. Supported option is `MongoDB`.
        :param str engine_version: Database engine version.
        :param str expiration_time: Expiration time in RFC3339 format. Pay-As-You-Go instances are never expire.
        :param str id: The ID of the MongoDB instance.
        :param str instance_class: Sizing of the instance to be queried.
        :param str instance_type: Type of the instance to be queried. If it is set to `sharding`, the sharded cluster instances are listed. If it is set to `replicate`, replica set instances are listed. Default value `replicate`.
        :param str lock_mode: Lock status of the instance.
        :param Sequence['GetInstancesInstanceMongoArgs'] mongos: Array composed of Mongos.
        :param str name: The name of the MongoDB instance.
        :param str network_type: Classic network or VPC.
        :param str region_id: Region ID the instance belongs to.
        :param str replication: Replication factor corresponds to number of nodes. Optional values are `1` for single node and `3` for three nodes replica set.
        :param Sequence['GetInstancesInstanceShardArgs'] shards: Array composed of shards.
        :param str status: Status of the instance.
        :param int storage: Shard disk.
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "charge_type", charge_type)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_class", instance_class)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "lock_mode", lock_mode)
        pulumi.set(__self__, "mongos", mongos)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "replication", replication)
        pulumi.set(__self__, "shards", shards)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "storage", storage)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Instance availability zone.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> str:
        """
        Billing method. Value options are `PostPaid` for  Pay-As-You-Go and `PrePaid` for yearly or monthly subscription.
        """
        return pulumi.get(self, "charge_type")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Creation time of the instance in RFC3339 format.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        Database engine type. Supported option is `MongoDB`.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> str:
        """
        Database engine version.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> str:
        """
        Expiration time in RFC3339 format. Pay-As-You-Go instances are never expire.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the MongoDB instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> str:
        """
        Sizing of the instance to be queried.
        """
        return pulumi.get(self, "instance_class")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Type of the instance to be queried. If it is set to `sharding`, the sharded cluster instances are listed. If it is set to `replicate`, replica set instances are listed. Default value `replicate`.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="lockMode")
    def lock_mode(self) -> str:
        """
        Lock status of the instance.
        """
        return pulumi.get(self, "lock_mode")

    @property
    @pulumi.getter
    def mongos(self) -> Sequence['outputs.GetInstancesInstanceMongoResult']:
        """
        Array composed of Mongos.
        """
        return pulumi.get(self, "mongos")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the MongoDB instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        Classic network or VPC.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        Region ID the instance belongs to.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter
    def replication(self) -> str:
        """
        Replication factor corresponds to number of nodes. Optional values are `1` for single node and `3` for three nodes replica set.
        """
        return pulumi.get(self, "replication")

    @property
    @pulumi.getter
    def shards(self) -> Sequence['outputs.GetInstancesInstanceShardResult']:
        """
        Array composed of shards.
        """
        return pulumi.get(self, "shards")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def storage(self) -> int:
        """
        Shard disk.
        """
        return pulumi.get(self, "storage")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetInstancesInstanceMongoResult(dict):
    def __init__(__self__, *,
                 class_: str,
                 description: str,
                 node_id: str):
        """
        :param str class_: Shard instance specification.
        :param str description: Shard instance description.
        :param str node_id: Shard instance ID.
        """
        pulumi.set(__self__, "class_", class_)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "node_id", node_id)

    @property
    @pulumi.getter(name="class")
    def class_(self) -> str:
        """
        Shard instance specification.
        """
        return pulumi.get(self, "class_")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Shard instance description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        Shard instance ID.
        """
        return pulumi.get(self, "node_id")


@pulumi.output_type
class GetInstancesInstanceShardResult(dict):
    def __init__(__self__, *,
                 class_: str,
                 description: str,
                 node_id: str,
                 storage: int):
        """
        :param str class_: Shard instance specification.
        :param str description: Shard instance description.
        :param str node_id: Shard instance ID.
        :param int storage: Shard disk.
        """
        pulumi.set(__self__, "class_", class_)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "storage", storage)

    @property
    @pulumi.getter(name="class")
    def class_(self) -> str:
        """
        Shard instance specification.
        """
        return pulumi.get(self, "class_")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Shard instance description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        Shard instance ID.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter
    def storage(self) -> int:
        """
        Shard disk.
        """
        return pulumi.get(self, "storage")


@pulumi.output_type
class GetServerlessInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 capacity_unit: int,
                 db_instance_class: str,
                 db_instance_description: str,
                 db_instance_id: str,
                 db_instance_release_protection: bool,
                 db_instance_storage: int,
                 engine: str,
                 engine_version: str,
                 expire_time: str,
                 id: str,
                 kind_code: str,
                 lock_mode: str,
                 maintain_end_time: str,
                 maintain_start_time: str,
                 max_connections: int,
                 max_iops: int,
                 network_type: str,
                 payment_type: str,
                 protocol_type: str,
                 resource_group_id: str,
                 security_ip_groups: Sequence['outputs.GetServerlessInstancesInstanceSecurityIpGroupResult'],
                 status: str,
                 storage_engine: str,
                 tags: Mapping[str, Any],
                 vpc_auth_mode: str,
                 vpc_id: str,
                 vswitch_id: str,
                 zone_id: str):
        """
        :param int capacity_unit: The read/write throughput consumed by the instance.
        :param str db_instance_class: The db instance class.
        :param str db_instance_description: The db instance description.
        :param str db_instance_id: The db instance id.
        :param bool db_instance_release_protection: The db instance release protection.
        :param int db_instance_storage: The db instance storage.
        :param str engine: The database engine of the instance.
        :param str engine_version: The database version number. Valid values: `4.2`.
        :param str expire_time: The time when the subscription instance expires. The time is in the `yyyy-MM-ddTHH:mmZ` format. The time is displayed in UTC.
        :param str id: The ID of the Serverless Instance.
        :param str kind_code: Indicates the type of the instance. Valid values: `0`: physical machine. `1`: ECS. `2`: DOCKER. `18`: k8s new architecture instance.
        :param str lock_mode: The locked status of the instance.
        :param str maintain_end_time: The start time of the maintenance window. The time is in the `HH:mmZ` format. The time is displayed in UTC.
        :param str maintain_start_time: The end time of the maintenance window. The time is in the `HH:mmZ` format. The time is displayed in UTC.
        :param int max_connections: Instance maximum connections.
        :param int max_iops: The maximum IOPS of the instance.
        :param str network_type: The network type of the instance.
        :param str payment_type: The Payment type of the instance.
        :param str protocol_type: The access protocol type of the instance. Valid values: `mongodb`, `dynamodb`.
        :param str resource_group_id: The ID of the resource group.
        :param Sequence['GetServerlessInstancesInstanceSecurityIpGroupArgs'] security_ip_groups: The security ip list.
        :param str status: The status of the instance.
        :param str storage_engine: The storage engine used by the instance.
        :param Mapping[str, Any] tags: The tag of the resource.
        :param str vpc_auth_mode: Intranet secret free access mode.
        :param str vpc_id: The ID of the VPC network.
        :param str vswitch_id: The id of the vswitch.
        :param str zone_id: The ID of the zone.
        """
        pulumi.set(__self__, "capacity_unit", capacity_unit)
        pulumi.set(__self__, "db_instance_class", db_instance_class)
        pulumi.set(__self__, "db_instance_description", db_instance_description)
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "db_instance_release_protection", db_instance_release_protection)
        pulumi.set(__self__, "db_instance_storage", db_instance_storage)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "kind_code", kind_code)
        pulumi.set(__self__, "lock_mode", lock_mode)
        pulumi.set(__self__, "maintain_end_time", maintain_end_time)
        pulumi.set(__self__, "maintain_start_time", maintain_start_time)
        pulumi.set(__self__, "max_connections", max_connections)
        pulumi.set(__self__, "max_iops", max_iops)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "protocol_type", protocol_type)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "security_ip_groups", security_ip_groups)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "storage_engine", storage_engine)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_auth_mode", vpc_auth_mode)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="capacityUnit")
    def capacity_unit(self) -> int:
        """
        The read/write throughput consumed by the instance.
        """
        return pulumi.get(self, "capacity_unit")

    @property
    @pulumi.getter(name="dbInstanceClass")
    def db_instance_class(self) -> str:
        """
        The db instance class.
        """
        return pulumi.get(self, "db_instance_class")

    @property
    @pulumi.getter(name="dbInstanceDescription")
    def db_instance_description(self) -> str:
        """
        The db instance description.
        """
        return pulumi.get(self, "db_instance_description")

    @property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> str:
        """
        The db instance id.
        """
        return pulumi.get(self, "db_instance_id")

    @property
    @pulumi.getter(name="dbInstanceReleaseProtection")
    def db_instance_release_protection(self) -> bool:
        """
        The db instance release protection.
        """
        return pulumi.get(self, "db_instance_release_protection")

    @property
    @pulumi.getter(name="dbInstanceStorage")
    def db_instance_storage(self) -> int:
        """
        The db instance storage.
        """
        return pulumi.get(self, "db_instance_storage")

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        The database engine of the instance.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> str:
        """
        The database version number. Valid values: `4.2`.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        The time when the subscription instance expires. The time is in the `yyyy-MM-ddTHH:mmZ` format. The time is displayed in UTC.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Serverless Instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kindCode")
    def kind_code(self) -> str:
        """
        Indicates the type of the instance. Valid values: `0`: physical machine. `1`: ECS. `2`: DOCKER. `18`: k8s new architecture instance.
        """
        return pulumi.get(self, "kind_code")

    @property
    @pulumi.getter(name="lockMode")
    def lock_mode(self) -> str:
        """
        The locked status of the instance.
        """
        return pulumi.get(self, "lock_mode")

    @property
    @pulumi.getter(name="maintainEndTime")
    def maintain_end_time(self) -> str:
        """
        The start time of the maintenance window. The time is in the `HH:mmZ` format. The time is displayed in UTC.
        """
        return pulumi.get(self, "maintain_end_time")

    @property
    @pulumi.getter(name="maintainStartTime")
    def maintain_start_time(self) -> str:
        """
        The end time of the maintenance window. The time is in the `HH:mmZ` format. The time is displayed in UTC.
        """
        return pulumi.get(self, "maintain_start_time")

    @property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> int:
        """
        Instance maximum connections.
        """
        return pulumi.get(self, "max_connections")

    @property
    @pulumi.getter(name="maxIops")
    def max_iops(self) -> int:
        """
        The maximum IOPS of the instance.
        """
        return pulumi.get(self, "max_iops")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        The network type of the instance.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        The Payment type of the instance.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> str:
        """
        The access protocol type of the instance. Valid values: `mongodb`, `dynamodb`.
        """
        return pulumi.get(self, "protocol_type")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="securityIpGroups")
    def security_ip_groups(self) -> Sequence['outputs.GetServerlessInstancesInstanceSecurityIpGroupResult']:
        """
        The security ip list.
        """
        return pulumi.get(self, "security_ip_groups")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageEngine")
    def storage_engine(self) -> str:
        """
        The storage engine used by the instance.
        """
        return pulumi.get(self, "storage_engine")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcAuthMode")
    def vpc_auth_mode(self) -> str:
        """
        Intranet secret free access mode.
        """
        return pulumi.get(self, "vpc_auth_mode")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the VPC network.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The id of the vswitch.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The ID of the zone.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetServerlessInstancesInstanceSecurityIpGroupResult(dict):
    def __init__(__self__, *,
                 security_ip_group_attribute: str,
                 security_ip_group_name: str,
                 security_ip_list: str):
        """
        :param str security_ip_group_attribute: The attribute of the IP whitelist. This parameter is empty by default.
        :param str security_ip_group_name: The name of the IP whitelist.
        :param str security_ip_list: The IP addresses in the whitelist.
        """
        pulumi.set(__self__, "security_ip_group_attribute", security_ip_group_attribute)
        pulumi.set(__self__, "security_ip_group_name", security_ip_group_name)
        pulumi.set(__self__, "security_ip_list", security_ip_list)

    @property
    @pulumi.getter(name="securityIpGroupAttribute")
    def security_ip_group_attribute(self) -> str:
        """
        The attribute of the IP whitelist. This parameter is empty by default.
        """
        return pulumi.get(self, "security_ip_group_attribute")

    @property
    @pulumi.getter(name="securityIpGroupName")
    def security_ip_group_name(self) -> str:
        """
        The name of the IP whitelist.
        """
        return pulumi.get(self, "security_ip_group_name")

    @property
    @pulumi.getter(name="securityIpList")
    def security_ip_list(self) -> str:
        """
        The IP addresses in the whitelist.
        """
        return pulumi.get(self, "security_ip_list")


@pulumi.output_type
class GetShardingNetworkPrivateAddressesAddressResult(dict):
    def __init__(__self__, *,
                 db_instance_id: str,
                 expired_time: str,
                 ip_address: str,
                 network_address: str,
                 network_type: str,
                 node_id: str,
                 node_type: str,
                 port: str,
                 role: str,
                 vpc_id: str,
                 vswitch_id: str):
        """
        :param str db_instance_id: The db instance id.
        :param str expired_time: The remaining duration of the classic network address. Unit: `seconds`.
        :param str ip_address: The IP address of the instance.
        :param str network_address: The endpoint of the instance.
        :param str network_type: The type of the network.
        :param str node_id: The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
        :param str node_type: The type of the node.
        :param str port: The port number.
        :param str role: The role of the node.
        :param str vpc_id: The ID of the VPC.
        :param str vswitch_id: The vSwitch ID of the VPC.
        """
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "network_address", network_address)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "node_type", node_type)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> str:
        """
        The db instance id.
        """
        return pulumi.get(self, "db_instance_id")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> str:
        """
        The remaining duration of the classic network address. Unit: `seconds`.
        """
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address of the instance.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> str:
        """
        The endpoint of the instance.
        """
        return pulumi.get(self, "network_address")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        The type of the network.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> str:
        """
        The type of the node.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter
    def port(self) -> str:
        """
        The port number.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The role of the node.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The vSwitch ID of the VPC.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetShardingNetworkPublicAddressesAddressResult(dict):
    def __init__(__self__, *,
                 db_instance_id: str,
                 expired_time: str,
                 ip_address: str,
                 network_address: str,
                 network_type: str,
                 node_id: str,
                 node_type: str,
                 port: str,
                 role: str,
                 vpc_id: str,
                 vswitch_id: str):
        """
        :param str db_instance_id: The db instance id.
        :param str expired_time: The remaining duration of the classic network address. Unit: `seconds`.
        :param str ip_address: The IP address of the instance.
        :param str network_address: The endpoint of the instance.
        :param str network_type: The network type.
        :param str node_id: The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
        :param str node_type: The type of the node.
        :param str port: The port number.
        :param str role: The role of the node.
        :param str vpc_id: The ID of the VPC.
        :param str vswitch_id: The vSwitch ID of the VPC.
        """
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "network_address", network_address)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "node_type", node_type)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> str:
        """
        The db instance id.
        """
        return pulumi.get(self, "db_instance_id")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> str:
        """
        The remaining duration of the classic network address. Unit: `seconds`.
        """
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address of the instance.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> str:
        """
        The endpoint of the instance.
        """
        return pulumi.get(self, "network_address")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        The network type.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> str:
        """
        The type of the node.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter
    def port(self) -> str:
        """
        The port number.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The role of the node.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The vSwitch ID of the VPC.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetZonesZoneResult(dict):
    def __init__(__self__, *,
                 id: str,
                 multi_zone_ids: Sequence[str]):
        """
        :param str id: ID of the zone.
        :param Sequence[str] multi_zone_ids: A list of zone ids in which the multi zone.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "multi_zone_ids", multi_zone_ids)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the zone.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="multiZoneIds")
    def multi_zone_ids(self) -> Sequence[str]:
        """
        A list of zone ids in which the multi zone.
        """
        return pulumi.get(self, "multi_zone_ids")


