# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerlessInstanceArgs', 'ServerlessInstance']

@pulumi.input_type
class ServerlessInstanceArgs:
    def __init__(__self__, *,
                 account_password: pulumi.Input[str],
                 capacity_unit: pulumi.Input[int],
                 db_instance_storage: pulumi.Input[int],
                 engine_version: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 vswitch_id: pulumi.Input[str],
                 zone_id: pulumi.Input[str],
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 db_instance_description: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 maintain_end_time: Optional[pulumi.Input[str]] = None,
                 maintain_start_time: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_price_type: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_ip_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceSecurityIpGroupArgs']]]] = None,
                 storage_engine: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a ServerlessInstance resource.
        :param pulumi.Input[str] account_password: The password of the database logon account.
               * The password length is `8` to `32` bits.
               * The password consists of at least any three of uppercase letters, lowercase letters, numbers, and special characters. The special character is `!#$%^&*()_+-=`. The MongoDB Serverless instance provides a default database login account. This account cannot be modified. You can only set or modify the password for this account.
        :param pulumi.Input[int] capacity_unit: The I/O throughput consumed by the instance. Valid values: `100` to `8000`.
        :param pulumi.Input[int] db_instance_storage: The db instance storage. Valid values: `1` to `100`.
        :param pulumi.Input[str] engine_version: The database version number. Valid values: `4.2`.
        :param pulumi.Input[str] vpc_id: The ID of the VPC network.
        :param pulumi.Input[str] vswitch_id: The of the vswitch.
        :param pulumi.Input[str] zone_id: The ID of the zone. Use this parameter to specify the zone created by the instance.
        :param pulumi.Input[bool] auto_renew: Set whether the instance is automatically renewed.
        :param pulumi.Input[str] db_instance_description: The db instance description.
        :param pulumi.Input[str] engine: The database engine of the instance. Valid values: `MongoDB`.
        :param pulumi.Input[str] maintain_end_time: The end time of the maintenance window. Specify the time in the `HH:mmZ` format. The time must be in UTC. **NOTE:** The difference between the start time and end time must be one hour. For example, if `maintain_start_time` is `01:00Z`, `maintain_end_time` must be `02:00Z`.
        :param pulumi.Input[str] maintain_start_time: The start time of the maintenance window. Specify the time in the `HH:mmZ` format. The time must be in UTC.
        :param pulumi.Input[int] period: The purchase duration of the instance, in months. Valid values: `1` to `9`, `12`, `24`, `36`, `60`.
        :param pulumi.Input[str] period_price_type: The period price type. Valid values: `Day`, `Month`.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceSecurityIpGroupArgs']]] security_ip_groups: An array that consists of the information of IP whitelists.
        :param pulumi.Input[str] storage_engine: The storage engine used by the instance. Valid values: `WiredTiger`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "account_password", account_password)
        pulumi.set(__self__, "capacity_unit", capacity_unit)
        pulumi.set(__self__, "db_instance_storage", db_instance_storage)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if db_instance_description is not None:
            pulumi.set(__self__, "db_instance_description", db_instance_description)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if maintain_end_time is not None:
            pulumi.set(__self__, "maintain_end_time", maintain_end_time)
        if maintain_start_time is not None:
            pulumi.set(__self__, "maintain_start_time", maintain_start_time)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_price_type is not None:
            pulumi.set(__self__, "period_price_type", period_price_type)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_ip_groups is not None:
            pulumi.set(__self__, "security_ip_groups", security_ip_groups)
        if storage_engine is not None:
            pulumi.set(__self__, "storage_engine", storage_engine)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> pulumi.Input[str]:
        """
        The password of the database logon account.
        * The password length is `8` to `32` bits.
        * The password consists of at least any three of uppercase letters, lowercase letters, numbers, and special characters. The special character is `!#$%^&*()_+-=`. The MongoDB Serverless instance provides a default database login account. This account cannot be modified. You can only set or modify the password for this account.
        """
        return pulumi.get(self, "account_password")

    @account_password.setter
    def account_password(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_password", value)

    @property
    @pulumi.getter(name="capacityUnit")
    def capacity_unit(self) -> pulumi.Input[int]:
        """
        The I/O throughput consumed by the instance. Valid values: `100` to `8000`.
        """
        return pulumi.get(self, "capacity_unit")

    @capacity_unit.setter
    def capacity_unit(self, value: pulumi.Input[int]):
        pulumi.set(self, "capacity_unit", value)

    @property
    @pulumi.getter(name="dbInstanceStorage")
    def db_instance_storage(self) -> pulumi.Input[int]:
        """
        The db instance storage. Valid values: `1` to `100`.
        """
        return pulumi.get(self, "db_instance_storage")

    @db_instance_storage.setter
    def db_instance_storage(self, value: pulumi.Input[int]):
        pulumi.set(self, "db_instance_storage", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Input[str]:
        """
        The database version number. Valid values: `4.2`.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        The ID of the VPC network.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[str]:
        """
        The of the vswitch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[str]:
        """
        The ID of the zone. Use this parameter to specify the zone created by the instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Set whether the instance is automatically renewed.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="dbInstanceDescription")
    def db_instance_description(self) -> Optional[pulumi.Input[str]]:
        """
        The db instance description.
        """
        return pulumi.get(self, "db_instance_description")

    @db_instance_description.setter
    def db_instance_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_instance_description", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        """
        The database engine of the instance. Valid values: `MongoDB`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="maintainEndTime")
    def maintain_end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The end time of the maintenance window. Specify the time in the `HH:mmZ` format. The time must be in UTC. **NOTE:** The difference between the start time and end time must be one hour. For example, if `maintain_start_time` is `01:00Z`, `maintain_end_time` must be `02:00Z`.
        """
        return pulumi.get(self, "maintain_end_time")

    @maintain_end_time.setter
    def maintain_end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_end_time", value)

    @property
    @pulumi.getter(name="maintainStartTime")
    def maintain_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The start time of the maintenance window. Specify the time in the `HH:mmZ` format. The time must be in UTC.
        """
        return pulumi.get(self, "maintain_start_time")

    @maintain_start_time.setter
    def maintain_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_start_time", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The purchase duration of the instance, in months. Valid values: `1` to `9`, `12`, `24`, `36`, `60`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodPriceType")
    def period_price_type(self) -> Optional[pulumi.Input[str]]:
        """
        The period price type. Valid values: `Day`, `Month`.
        """
        return pulumi.get(self, "period_price_type")

    @period_price_type.setter
    def period_price_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_price_type", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="securityIpGroups")
    def security_ip_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceSecurityIpGroupArgs']]]]:
        """
        An array that consists of the information of IP whitelists.
        """
        return pulumi.get(self, "security_ip_groups")

    @security_ip_groups.setter
    def security_ip_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceSecurityIpGroupArgs']]]]):
        pulumi.set(self, "security_ip_groups", value)

    @property
    @pulumi.getter(name="storageEngine")
    def storage_engine(self) -> Optional[pulumi.Input[str]]:
        """
        The storage engine used by the instance. Valid values: `WiredTiger`.
        """
        return pulumi.get(self, "storage_engine")

    @storage_engine.setter
    def storage_engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_engine", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ServerlessInstanceState:
    def __init__(__self__, *,
                 account_password: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 capacity_unit: Optional[pulumi.Input[int]] = None,
                 db_instance_description: Optional[pulumi.Input[str]] = None,
                 db_instance_storage: Optional[pulumi.Input[int]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 maintain_end_time: Optional[pulumi.Input[str]] = None,
                 maintain_start_time: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_price_type: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_ip_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceSecurityIpGroupArgs']]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 storage_engine: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServerlessInstance resources.
        :param pulumi.Input[str] account_password: The password of the database logon account.
               * The password length is `8` to `32` bits.
               * The password consists of at least any three of uppercase letters, lowercase letters, numbers, and special characters. The special character is `!#$%^&*()_+-=`. The MongoDB Serverless instance provides a default database login account. This account cannot be modified. You can only set or modify the password for this account.
        :param pulumi.Input[bool] auto_renew: Set whether the instance is automatically renewed.
        :param pulumi.Input[int] capacity_unit: The I/O throughput consumed by the instance. Valid values: `100` to `8000`.
        :param pulumi.Input[str] db_instance_description: The db instance description.
        :param pulumi.Input[int] db_instance_storage: The db instance storage. Valid values: `1` to `100`.
        :param pulumi.Input[str] engine: The database engine of the instance. Valid values: `MongoDB`.
        :param pulumi.Input[str] engine_version: The database version number. Valid values: `4.2`.
        :param pulumi.Input[str] maintain_end_time: The end time of the maintenance window. Specify the time in the `HH:mmZ` format. The time must be in UTC. **NOTE:** The difference between the start time and end time must be one hour. For example, if `maintain_start_time` is `01:00Z`, `maintain_end_time` must be `02:00Z`.
        :param pulumi.Input[str] maintain_start_time: The start time of the maintenance window. Specify the time in the `HH:mmZ` format. The time must be in UTC.
        :param pulumi.Input[int] period: The purchase duration of the instance, in months. Valid values: `1` to `9`, `12`, `24`, `36`, `60`.
        :param pulumi.Input[str] period_price_type: The period price type. Valid values: `Day`, `Month`.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceSecurityIpGroupArgs']]] security_ip_groups: An array that consists of the information of IP whitelists.
        :param pulumi.Input[str] status: The instance status. For more information, see the instance Status Table.
        :param pulumi.Input[str] storage_engine: The storage engine used by the instance. Valid values: `WiredTiger`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] vpc_id: The ID of the VPC network.
        :param pulumi.Input[str] vswitch_id: The of the vswitch.
        :param pulumi.Input[str] zone_id: The ID of the zone. Use this parameter to specify the zone created by the instance.
        """
        if account_password is not None:
            pulumi.set(__self__, "account_password", account_password)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if capacity_unit is not None:
            pulumi.set(__self__, "capacity_unit", capacity_unit)
        if db_instance_description is not None:
            pulumi.set(__self__, "db_instance_description", db_instance_description)
        if db_instance_storage is not None:
            pulumi.set(__self__, "db_instance_storage", db_instance_storage)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if maintain_end_time is not None:
            pulumi.set(__self__, "maintain_end_time", maintain_end_time)
        if maintain_start_time is not None:
            pulumi.set(__self__, "maintain_start_time", maintain_start_time)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_price_type is not None:
            pulumi.set(__self__, "period_price_type", period_price_type)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_ip_groups is not None:
            pulumi.set(__self__, "security_ip_groups", security_ip_groups)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_engine is not None:
            pulumi.set(__self__, "storage_engine", storage_engine)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of the database logon account.
        * The password length is `8` to `32` bits.
        * The password consists of at least any three of uppercase letters, lowercase letters, numbers, and special characters. The special character is `!#$%^&*()_+-=`. The MongoDB Serverless instance provides a default database login account. This account cannot be modified. You can only set or modify the password for this account.
        """
        return pulumi.get(self, "account_password")

    @account_password.setter
    def account_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_password", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Set whether the instance is automatically renewed.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="capacityUnit")
    def capacity_unit(self) -> Optional[pulumi.Input[int]]:
        """
        The I/O throughput consumed by the instance. Valid values: `100` to `8000`.
        """
        return pulumi.get(self, "capacity_unit")

    @capacity_unit.setter
    def capacity_unit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity_unit", value)

    @property
    @pulumi.getter(name="dbInstanceDescription")
    def db_instance_description(self) -> Optional[pulumi.Input[str]]:
        """
        The db instance description.
        """
        return pulumi.get(self, "db_instance_description")

    @db_instance_description.setter
    def db_instance_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_instance_description", value)

    @property
    @pulumi.getter(name="dbInstanceStorage")
    def db_instance_storage(self) -> Optional[pulumi.Input[int]]:
        """
        The db instance storage. Valid values: `1` to `100`.
        """
        return pulumi.get(self, "db_instance_storage")

    @db_instance_storage.setter
    def db_instance_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_instance_storage", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        """
        The database engine of the instance. Valid values: `MongoDB`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        The database version number. Valid values: `4.2`.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="maintainEndTime")
    def maintain_end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The end time of the maintenance window. Specify the time in the `HH:mmZ` format. The time must be in UTC. **NOTE:** The difference between the start time and end time must be one hour. For example, if `maintain_start_time` is `01:00Z`, `maintain_end_time` must be `02:00Z`.
        """
        return pulumi.get(self, "maintain_end_time")

    @maintain_end_time.setter
    def maintain_end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_end_time", value)

    @property
    @pulumi.getter(name="maintainStartTime")
    def maintain_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The start time of the maintenance window. Specify the time in the `HH:mmZ` format. The time must be in UTC.
        """
        return pulumi.get(self, "maintain_start_time")

    @maintain_start_time.setter
    def maintain_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_start_time", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The purchase duration of the instance, in months. Valid values: `1` to `9`, `12`, `24`, `36`, `60`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodPriceType")
    def period_price_type(self) -> Optional[pulumi.Input[str]]:
        """
        The period price type. Valid values: `Day`, `Month`.
        """
        return pulumi.get(self, "period_price_type")

    @period_price_type.setter
    def period_price_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_price_type", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="securityIpGroups")
    def security_ip_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceSecurityIpGroupArgs']]]]:
        """
        An array that consists of the information of IP whitelists.
        """
        return pulumi.get(self, "security_ip_groups")

    @security_ip_groups.setter
    def security_ip_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessInstanceSecurityIpGroupArgs']]]]):
        pulumi.set(self, "security_ip_groups", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The instance status. For more information, see the instance Status Table.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="storageEngine")
    def storage_engine(self) -> Optional[pulumi.Input[str]]:
        """
        The storage engine used by the instance. Valid values: `WiredTiger`.
        """
        return pulumi.get(self, "storage_engine")

    @storage_engine.setter
    def storage_engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_engine", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPC network.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The of the vswitch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the zone. Use this parameter to specify the zone created by the instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class ServerlessInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_password: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 capacity_unit: Optional[pulumi.Input[int]] = None,
                 db_instance_description: Optional[pulumi.Input[str]] = None,
                 db_instance_storage: Optional[pulumi.Input[int]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 maintain_end_time: Optional[pulumi.Input[str]] = None,
                 maintain_start_time: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_price_type: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_ip_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerlessInstanceSecurityIpGroupArgs']]]]] = None,
                 storage_engine: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a MongoDB Serverless Instance resource.

        For information about MongoDB Serverless Instance and how to use it, see [What is Serverless Instance](https://www.alibabacloud.com/help/doc-detail/26558.html).

        > **NOTE:** Deprecated since v1.214.0.

        > **DEPRECATED:**  This resource has been deprecated from version `1.214.0`.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_zones = alicloud.mongodb.get_zones()
        default_networks = alicloud.vpc.get_networks(name_regex="default-NODELETING")
        default_switches = alicloud.vpc.get_switches(vpc_id=default_networks.ids[0],
            zone_id=default_zones.zones[0].id)
        default_resource_groups = alicloud.resourcemanager.get_resource_groups()
        example = alicloud.mongodb.ServerlessInstance("example",
            account_password="Abc12345",
            db_instance_description="example_value",
            db_instance_storage=5,
            storage_engine="WiredTiger",
            capacity_unit=100,
            engine="MongoDB",
            resource_group_id=default_resource_groups.groups[0].id,
            engine_version="4.2",
            period=1,
            period_price_type="Month",
            vpc_id=default_networks.ids[0],
            zone_id=default_zones.zones[0].id,
            vswitch_id=default_switches.ids[0],
            tags={
                "Created": "MongodbServerlessInstance",
                "For": "TF",
            },
            security_ip_groups=[alicloud.mongodb.ServerlessInstanceSecurityIpGroupArgs(
                security_ip_group_attribute="example_value",
                security_ip_group_name="example_value",
                security_ip_list="192.168.0.1",
            )])
        ```

        ## Import

        MongoDB Serverless Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:mongodb/serverlessInstance:ServerlessInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_password: The password of the database logon account.
               * The password length is `8` to `32` bits.
               * The password consists of at least any three of uppercase letters, lowercase letters, numbers, and special characters. The special character is `!#$%^&*()_+-=`. The MongoDB Serverless instance provides a default database login account. This account cannot be modified. You can only set or modify the password for this account.
        :param pulumi.Input[bool] auto_renew: Set whether the instance is automatically renewed.
        :param pulumi.Input[int] capacity_unit: The I/O throughput consumed by the instance. Valid values: `100` to `8000`.
        :param pulumi.Input[str] db_instance_description: The db instance description.
        :param pulumi.Input[int] db_instance_storage: The db instance storage. Valid values: `1` to `100`.
        :param pulumi.Input[str] engine: The database engine of the instance. Valid values: `MongoDB`.
        :param pulumi.Input[str] engine_version: The database version number. Valid values: `4.2`.
        :param pulumi.Input[str] maintain_end_time: The end time of the maintenance window. Specify the time in the `HH:mmZ` format. The time must be in UTC. **NOTE:** The difference between the start time and end time must be one hour. For example, if `maintain_start_time` is `01:00Z`, `maintain_end_time` must be `02:00Z`.
        :param pulumi.Input[str] maintain_start_time: The start time of the maintenance window. Specify the time in the `HH:mmZ` format. The time must be in UTC.
        :param pulumi.Input[int] period: The purchase duration of the instance, in months. Valid values: `1` to `9`, `12`, `24`, `36`, `60`.
        :param pulumi.Input[str] period_price_type: The period price type. Valid values: `Day`, `Month`.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerlessInstanceSecurityIpGroupArgs']]]] security_ip_groups: An array that consists of the information of IP whitelists.
        :param pulumi.Input[str] storage_engine: The storage engine used by the instance. Valid values: `WiredTiger`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] vpc_id: The ID of the VPC network.
        :param pulumi.Input[str] vswitch_id: The of the vswitch.
        :param pulumi.Input[str] zone_id: The ID of the zone. Use this parameter to specify the zone created by the instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerlessInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a MongoDB Serverless Instance resource.

        For information about MongoDB Serverless Instance and how to use it, see [What is Serverless Instance](https://www.alibabacloud.com/help/doc-detail/26558.html).

        > **NOTE:** Deprecated since v1.214.0.

        > **DEPRECATED:**  This resource has been deprecated from version `1.214.0`.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_zones = alicloud.mongodb.get_zones()
        default_networks = alicloud.vpc.get_networks(name_regex="default-NODELETING")
        default_switches = alicloud.vpc.get_switches(vpc_id=default_networks.ids[0],
            zone_id=default_zones.zones[0].id)
        default_resource_groups = alicloud.resourcemanager.get_resource_groups()
        example = alicloud.mongodb.ServerlessInstance("example",
            account_password="Abc12345",
            db_instance_description="example_value",
            db_instance_storage=5,
            storage_engine="WiredTiger",
            capacity_unit=100,
            engine="MongoDB",
            resource_group_id=default_resource_groups.groups[0].id,
            engine_version="4.2",
            period=1,
            period_price_type="Month",
            vpc_id=default_networks.ids[0],
            zone_id=default_zones.zones[0].id,
            vswitch_id=default_switches.ids[0],
            tags={
                "Created": "MongodbServerlessInstance",
                "For": "TF",
            },
            security_ip_groups=[alicloud.mongodb.ServerlessInstanceSecurityIpGroupArgs(
                security_ip_group_attribute="example_value",
                security_ip_group_name="example_value",
                security_ip_list="192.168.0.1",
            )])
        ```

        ## Import

        MongoDB Serverless Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:mongodb/serverlessInstance:ServerlessInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ServerlessInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerlessInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_password: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 capacity_unit: Optional[pulumi.Input[int]] = None,
                 db_instance_description: Optional[pulumi.Input[str]] = None,
                 db_instance_storage: Optional[pulumi.Input[int]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 maintain_end_time: Optional[pulumi.Input[str]] = None,
                 maintain_start_time: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_price_type: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_ip_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerlessInstanceSecurityIpGroupArgs']]]]] = None,
                 storage_engine: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerlessInstanceArgs.__new__(ServerlessInstanceArgs)

            if account_password is None and not opts.urn:
                raise TypeError("Missing required property 'account_password'")
            __props__.__dict__["account_password"] = None if account_password is None else pulumi.Output.secret(account_password)
            __props__.__dict__["auto_renew"] = auto_renew
            if capacity_unit is None and not opts.urn:
                raise TypeError("Missing required property 'capacity_unit'")
            __props__.__dict__["capacity_unit"] = capacity_unit
            __props__.__dict__["db_instance_description"] = db_instance_description
            if db_instance_storage is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_storage'")
            __props__.__dict__["db_instance_storage"] = db_instance_storage
            __props__.__dict__["engine"] = engine
            if engine_version is None and not opts.urn:
                raise TypeError("Missing required property 'engine_version'")
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["maintain_end_time"] = maintain_end_time
            __props__.__dict__["maintain_start_time"] = maintain_start_time
            __props__.__dict__["period"] = period
            __props__.__dict__["period_price_type"] = period_price_type
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["security_ip_groups"] = security_ip_groups
            __props__.__dict__["storage_engine"] = storage_engine
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accountPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServerlessInstance, __self__).__init__(
            'alicloud:mongodb/serverlessInstance:ServerlessInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_password: Optional[pulumi.Input[str]] = None,
            auto_renew: Optional[pulumi.Input[bool]] = None,
            capacity_unit: Optional[pulumi.Input[int]] = None,
            db_instance_description: Optional[pulumi.Input[str]] = None,
            db_instance_storage: Optional[pulumi.Input[int]] = None,
            engine: Optional[pulumi.Input[str]] = None,
            engine_version: Optional[pulumi.Input[str]] = None,
            maintain_end_time: Optional[pulumi.Input[str]] = None,
            maintain_start_time: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_price_type: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            security_ip_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerlessInstanceSecurityIpGroupArgs']]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            storage_engine: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vswitch_id: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'ServerlessInstance':
        """
        Get an existing ServerlessInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_password: The password of the database logon account.
               * The password length is `8` to `32` bits.
               * The password consists of at least any three of uppercase letters, lowercase letters, numbers, and special characters. The special character is `!#$%^&*()_+-=`. The MongoDB Serverless instance provides a default database login account. This account cannot be modified. You can only set or modify the password for this account.
        :param pulumi.Input[bool] auto_renew: Set whether the instance is automatically renewed.
        :param pulumi.Input[int] capacity_unit: The I/O throughput consumed by the instance. Valid values: `100` to `8000`.
        :param pulumi.Input[str] db_instance_description: The db instance description.
        :param pulumi.Input[int] db_instance_storage: The db instance storage. Valid values: `1` to `100`.
        :param pulumi.Input[str] engine: The database engine of the instance. Valid values: `MongoDB`.
        :param pulumi.Input[str] engine_version: The database version number. Valid values: `4.2`.
        :param pulumi.Input[str] maintain_end_time: The end time of the maintenance window. Specify the time in the `HH:mmZ` format. The time must be in UTC. **NOTE:** The difference between the start time and end time must be one hour. For example, if `maintain_start_time` is `01:00Z`, `maintain_end_time` must be `02:00Z`.
        :param pulumi.Input[str] maintain_start_time: The start time of the maintenance window. Specify the time in the `HH:mmZ` format. The time must be in UTC.
        :param pulumi.Input[int] period: The purchase duration of the instance, in months. Valid values: `1` to `9`, `12`, `24`, `36`, `60`.
        :param pulumi.Input[str] period_price_type: The period price type. Valid values: `Day`, `Month`.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServerlessInstanceSecurityIpGroupArgs']]]] security_ip_groups: An array that consists of the information of IP whitelists.
        :param pulumi.Input[str] status: The instance status. For more information, see the instance Status Table.
        :param pulumi.Input[str] storage_engine: The storage engine used by the instance. Valid values: `WiredTiger`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] vpc_id: The ID of the VPC network.
        :param pulumi.Input[str] vswitch_id: The of the vswitch.
        :param pulumi.Input[str] zone_id: The ID of the zone. Use this parameter to specify the zone created by the instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerlessInstanceState.__new__(_ServerlessInstanceState)

        __props__.__dict__["account_password"] = account_password
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["capacity_unit"] = capacity_unit
        __props__.__dict__["db_instance_description"] = db_instance_description
        __props__.__dict__["db_instance_storage"] = db_instance_storage
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["maintain_end_time"] = maintain_end_time
        __props__.__dict__["maintain_start_time"] = maintain_start_time
        __props__.__dict__["period"] = period
        __props__.__dict__["period_price_type"] = period_price_type
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["security_ip_groups"] = security_ip_groups
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_engine"] = storage_engine
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return ServerlessInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> pulumi.Output[str]:
        """
        The password of the database logon account.
        * The password length is `8` to `32` bits.
        * The password consists of at least any three of uppercase letters, lowercase letters, numbers, and special characters. The special character is `!#$%^&*()_+-=`. The MongoDB Serverless instance provides a default database login account. This account cannot be modified. You can only set or modify the password for this account.
        """
        return pulumi.get(self, "account_password")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[bool]]:
        """
        Set whether the instance is automatically renewed.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="capacityUnit")
    def capacity_unit(self) -> pulumi.Output[int]:
        """
        The I/O throughput consumed by the instance. Valid values: `100` to `8000`.
        """
        return pulumi.get(self, "capacity_unit")

    @property
    @pulumi.getter(name="dbInstanceDescription")
    def db_instance_description(self) -> pulumi.Output[Optional[str]]:
        """
        The db instance description.
        """
        return pulumi.get(self, "db_instance_description")

    @property
    @pulumi.getter(name="dbInstanceStorage")
    def db_instance_storage(self) -> pulumi.Output[int]:
        """
        The db instance storage. Valid values: `1` to `100`.
        """
        return pulumi.get(self, "db_instance_storage")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[str]:
        """
        The database engine of the instance. Valid values: `MongoDB`.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[str]:
        """
        The database version number. Valid values: `4.2`.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="maintainEndTime")
    def maintain_end_time(self) -> pulumi.Output[str]:
        """
        The end time of the maintenance window. Specify the time in the `HH:mmZ` format. The time must be in UTC. **NOTE:** The difference between the start time and end time must be one hour. For example, if `maintain_start_time` is `01:00Z`, `maintain_end_time` must be `02:00Z`.
        """
        return pulumi.get(self, "maintain_end_time")

    @property
    @pulumi.getter(name="maintainStartTime")
    def maintain_start_time(self) -> pulumi.Output[str]:
        """
        The start time of the maintenance window. Specify the time in the `HH:mmZ` format. The time must be in UTC.
        """
        return pulumi.get(self, "maintain_start_time")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        The purchase duration of the instance, in months. Valid values: `1` to `9`, `12`, `24`, `36`, `60`.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodPriceType")
    def period_price_type(self) -> pulumi.Output[Optional[str]]:
        """
        The period price type. Valid values: `Day`, `Month`.
        """
        return pulumi.get(self, "period_price_type")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="securityIpGroups")
    def security_ip_groups(self) -> pulumi.Output[Optional[Sequence['outputs.ServerlessInstanceSecurityIpGroup']]]:
        """
        An array that consists of the information of IP whitelists.
        """
        return pulumi.get(self, "security_ip_groups")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The instance status. For more information, see the instance Status Table.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageEngine")
    def storage_engine(self) -> pulumi.Output[str]:
        """
        The storage engine used by the instance. Valid values: `WiredTiger`.
        """
        return pulumi.get(self, "storage_engine")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The ID of the VPC network.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[str]:
        """
        The of the vswitch.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The ID of the zone. Use this parameter to specify the zone created by the instance.
        """
        return pulumi.get(self, "zone_id")

