# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['MscSubWebhookArgs', 'MscSubWebhook']

@pulumi.input_type
class MscSubWebhookArgs:
    def __init__(__self__, *,
                 server_url: pulumi.Input[str],
                 webhook_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a MscSubWebhook resource.
        :param pulumi.Input[str] server_url: The serverUrl of the Webhook. This url must start with `https://oapi.dingtalk.com/robot/send?access_token=`.
        :param pulumi.Input[str] webhook_name: The name of the Webhook. **Note:** The name must be `2` to `12` characters in length, and can contain uppercase and lowercase letters.
        """
        pulumi.set(__self__, "server_url", server_url)
        pulumi.set(__self__, "webhook_name", webhook_name)

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> pulumi.Input[str]:
        """
        The serverUrl of the Webhook. This url must start with `https://oapi.dingtalk.com/robot/send?access_token=`.
        """
        return pulumi.get(self, "server_url")

    @server_url.setter
    def server_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_url", value)

    @property
    @pulumi.getter(name="webhookName")
    def webhook_name(self) -> pulumi.Input[str]:
        """
        The name of the Webhook. **Note:** The name must be `2` to `12` characters in length, and can contain uppercase and lowercase letters.
        """
        return pulumi.get(self, "webhook_name")

    @webhook_name.setter
    def webhook_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "webhook_name", value)


@pulumi.input_type
class _MscSubWebhookState:
    def __init__(__self__, *,
                 server_url: Optional[pulumi.Input[str]] = None,
                 webhook_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MscSubWebhook resources.
        :param pulumi.Input[str] server_url: The serverUrl of the Webhook. This url must start with `https://oapi.dingtalk.com/robot/send?access_token=`.
        :param pulumi.Input[str] webhook_name: The name of the Webhook. **Note:** The name must be `2` to `12` characters in length, and can contain uppercase and lowercase letters.
        """
        if server_url is not None:
            pulumi.set(__self__, "server_url", server_url)
        if webhook_name is not None:
            pulumi.set(__self__, "webhook_name", webhook_name)

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> Optional[pulumi.Input[str]]:
        """
        The serverUrl of the Webhook. This url must start with `https://oapi.dingtalk.com/robot/send?access_token=`.
        """
        return pulumi.get(self, "server_url")

    @server_url.setter
    def server_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_url", value)

    @property
    @pulumi.getter(name="webhookName")
    def webhook_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Webhook. **Note:** The name must be `2` to `12` characters in length, and can contain uppercase and lowercase letters.
        """
        return pulumi.get(self, "webhook_name")

    @webhook_name.setter
    def webhook_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "webhook_name", value)


class MscSubWebhook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 server_url: Optional[pulumi.Input[str]] = None,
                 webhook_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Msc Sub Webhook resource.

        > **NOTE:** Available since v1.141.0.

        ## Import

        Msc Sub Webhook can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:index/mscSubWebhook:MscSubWebhook example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] server_url: The serverUrl of the Webhook. This url must start with `https://oapi.dingtalk.com/robot/send?access_token=`.
        :param pulumi.Input[str] webhook_name: The name of the Webhook. **Note:** The name must be `2` to `12` characters in length, and can contain uppercase and lowercase letters.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MscSubWebhookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Msc Sub Webhook resource.

        > **NOTE:** Available since v1.141.0.

        ## Import

        Msc Sub Webhook can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:index/mscSubWebhook:MscSubWebhook example <id>
        ```

        :param str resource_name: The name of the resource.
        :param MscSubWebhookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MscSubWebhookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 server_url: Optional[pulumi.Input[str]] = None,
                 webhook_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MscSubWebhookArgs.__new__(MscSubWebhookArgs)

            if server_url is None and not opts.urn:
                raise TypeError("Missing required property 'server_url'")
            __props__.__dict__["server_url"] = server_url
            if webhook_name is None and not opts.urn:
                raise TypeError("Missing required property 'webhook_name'")
            __props__.__dict__["webhook_name"] = webhook_name
        super(MscSubWebhook, __self__).__init__(
            'alicloud:index/mscSubWebhook:MscSubWebhook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            server_url: Optional[pulumi.Input[str]] = None,
            webhook_name: Optional[pulumi.Input[str]] = None) -> 'MscSubWebhook':
        """
        Get an existing MscSubWebhook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] server_url: The serverUrl of the Webhook. This url must start with `https://oapi.dingtalk.com/robot/send?access_token=`.
        :param pulumi.Input[str] webhook_name: The name of the Webhook. **Note:** The name must be `2` to `12` characters in length, and can contain uppercase and lowercase letters.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MscSubWebhookState.__new__(_MscSubWebhookState)

        __props__.__dict__["server_url"] = server_url
        __props__.__dict__["webhook_name"] = webhook_name
        return MscSubWebhook(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> pulumi.Output[str]:
        """
        The serverUrl of the Webhook. This url must start with `https://oapi.dingtalk.com/robot/send?access_token=`.
        """
        return pulumi.get(self, "server_url")

    @property
    @pulumi.getter(name="webhookName")
    def webhook_name(self) -> pulumi.Output[str]:
        """
        The name of the Webhook. **Note:** The name must be `2` to `12` characters in length, and can contain uppercase and lowercase letters.
        """
        return pulumi.get(self, "webhook_name")

