# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ZnodeArgs', 'Znode']

@pulumi.input_type
class ZnodeArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 path: pulumi.Input[str],
                 accept_language: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Znode resource.
        :param pulumi.Input[str] cluster_id: The ID of the Cluster.
        :param pulumi.Input[str] path: The Node path. The value must start with a forward slash (/).
        :param pulumi.Input[str] accept_language: The language type of the returned information. Valid values: `zh` or `en`.
        :param pulumi.Input[str] data: The Node data.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "path", path)
        if accept_language is not None:
            pulumi.set(__self__, "accept_language", accept_language)
        if data is not None:
            pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        The ID of the Cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The Node path. The value must start with a forward slash (/).
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="acceptLanguage")
    def accept_language(self) -> Optional[pulumi.Input[str]]:
        """
        The language type of the returned information. Valid values: `zh` or `en`.
        """
        return pulumi.get(self, "accept_language")

    @accept_language.setter
    def accept_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accept_language", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        The Node data.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)


@pulumi.input_type
class _ZnodeState:
    def __init__(__self__, *,
                 accept_language: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Znode resources.
        :param pulumi.Input[str] accept_language: The language type of the returned information. Valid values: `zh` or `en`.
        :param pulumi.Input[str] cluster_id: The ID of the Cluster.
        :param pulumi.Input[str] data: The Node data.
        :param pulumi.Input[str] path: The Node path. The value must start with a forward slash (/).
        """
        if accept_language is not None:
            pulumi.set(__self__, "accept_language", accept_language)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="acceptLanguage")
    def accept_language(self) -> Optional[pulumi.Input[str]]:
        """
        The language type of the returned information. Valid values: `zh` or `en`.
        """
        return pulumi.get(self, "accept_language")

    @accept_language.setter
    def accept_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accept_language", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        The Node data.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The Node path. The value must start with a forward slash (/).
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


class Znode(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accept_language: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Microservice Engine (MSE) Znode resource.

        For information about Microservice Engine (MSE) Znode and how to use it, see [What is Znode](https://help.aliyun.com/document_detail/393622.html).

        > **NOTE:** Available in v1.162.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        example_network = alicloud.vpc.Network("exampleNetwork",
            vpc_name="terraform-example",
            cidr_block="172.17.3.0/24")
        example_switch = alicloud.vpc.Switch("exampleSwitch",
            vswitch_name="terraform-example",
            cidr_block="172.17.3.0/24",
            vpc_id=example_network.id,
            zone_id=example_zones.zones[0].id)
        example_cluster = alicloud.mse.Cluster("exampleCluster",
            cluster_specification="MSE_SC_1_2_60_c",
            cluster_type="ZooKeeper",
            cluster_version="ZooKeeper_3_8_0",
            instance_count=1,
            net_type="privatenet",
            pub_network_flow="1",
            acl_entry_lists=["127.0.0.1/32"],
            cluster_alias_name="terraform-example",
            mse_version="mse_dev",
            vswitch_id=example_switch.id,
            vpc_id=example_network.id)
        example_znode = alicloud.mse.Znode("exampleZnode",
            cluster_id=example_cluster.cluster_id,
            data="terraform-example",
            path="/example")
        ```

        ## Import

        Microservice Engine (MSE) Znode can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:mse/znode:Znode example <cluster_id>:<path>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accept_language: The language type of the returned information. Valid values: `zh` or `en`.
        :param pulumi.Input[str] cluster_id: The ID of the Cluster.
        :param pulumi.Input[str] data: The Node data.
        :param pulumi.Input[str] path: The Node path. The value must start with a forward slash (/).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZnodeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Microservice Engine (MSE) Znode resource.

        For information about Microservice Engine (MSE) Znode and how to use it, see [What is Znode](https://help.aliyun.com/document_detail/393622.html).

        > **NOTE:** Available in v1.162.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        example_network = alicloud.vpc.Network("exampleNetwork",
            vpc_name="terraform-example",
            cidr_block="172.17.3.0/24")
        example_switch = alicloud.vpc.Switch("exampleSwitch",
            vswitch_name="terraform-example",
            cidr_block="172.17.3.0/24",
            vpc_id=example_network.id,
            zone_id=example_zones.zones[0].id)
        example_cluster = alicloud.mse.Cluster("exampleCluster",
            cluster_specification="MSE_SC_1_2_60_c",
            cluster_type="ZooKeeper",
            cluster_version="ZooKeeper_3_8_0",
            instance_count=1,
            net_type="privatenet",
            pub_network_flow="1",
            acl_entry_lists=["127.0.0.1/32"],
            cluster_alias_name="terraform-example",
            mse_version="mse_dev",
            vswitch_id=example_switch.id,
            vpc_id=example_network.id)
        example_znode = alicloud.mse.Znode("exampleZnode",
            cluster_id=example_cluster.cluster_id,
            data="terraform-example",
            path="/example")
        ```

        ## Import

        Microservice Engine (MSE) Znode can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:mse/znode:Znode example <cluster_id>:<path>
        ```

        :param str resource_name: The name of the resource.
        :param ZnodeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZnodeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accept_language: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZnodeArgs.__new__(ZnodeArgs)

            __props__.__dict__["accept_language"] = accept_language
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["data"] = data
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
        super(Znode, __self__).__init__(
            'alicloud:mse/znode:Znode',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accept_language: Optional[pulumi.Input[str]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            data: Optional[pulumi.Input[str]] = None,
            path: Optional[pulumi.Input[str]] = None) -> 'Znode':
        """
        Get an existing Znode resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accept_language: The language type of the returned information. Valid values: `zh` or `en`.
        :param pulumi.Input[str] cluster_id: The ID of the Cluster.
        :param pulumi.Input[str] data: The Node data.
        :param pulumi.Input[str] path: The Node path. The value must start with a forward slash (/).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZnodeState.__new__(_ZnodeState)

        __props__.__dict__["accept_language"] = accept_language
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["data"] = data
        __props__.__dict__["path"] = path
        return Znode(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="acceptLanguage")
    def accept_language(self) -> pulumi.Output[Optional[str]]:
        """
        The language type of the returned information. Valid values: `zh` or `en`.
        """
        return pulumi.get(self, "accept_language")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The ID of the Cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def data(self) -> pulumi.Output[Optional[str]]:
        """
        The Node data.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[str]:
        """
        The Node path. The value must start with a forward slash (/).
        """
        return pulumi.get(self, "path")

