# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetListenersResult',
    'AwaitableGetListenersResult',
    'get_listeners',
    'get_listeners_output',
]

@pulumi.output_type
class GetListenersResult:
    """
    A collection of values returned by getListeners.
    """
    def __init__(__self__, id=None, ids=None, listener_protocol=None, listeners=None, load_balancer_ids=None, output_file=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if listener_protocol and not isinstance(listener_protocol, str):
            raise TypeError("Expected argument 'listener_protocol' to be a str")
        pulumi.set(__self__, "listener_protocol", listener_protocol)
        if listeners and not isinstance(listeners, list):
            raise TypeError("Expected argument 'listeners' to be a list")
        pulumi.set(__self__, "listeners", listeners)
        if load_balancer_ids and not isinstance(load_balancer_ids, list):
            raise TypeError("Expected argument 'load_balancer_ids' to be a list")
        pulumi.set(__self__, "load_balancer_ids", load_balancer_ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> Optional[str]:
        return pulumi.get(self, "listener_protocol")

    @property
    @pulumi.getter
    def listeners(self) -> Sequence['outputs.GetListenersListenerResult']:
        return pulumi.get(self, "listeners")

    @property
    @pulumi.getter(name="loadBalancerIds")
    def load_balancer_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "load_balancer_ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")


class AwaitableGetListenersResult(GetListenersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetListenersResult(
            id=self.id,
            ids=self.ids,
            listener_protocol=self.listener_protocol,
            listeners=self.listeners,
            load_balancer_ids=self.load_balancer_ids,
            output_file=self.output_file)


def get_listeners(ids: Optional[Sequence[str]] = None,
                  listener_protocol: Optional[str] = None,
                  load_balancer_ids: Optional[Sequence[str]] = None,
                  output_file: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetListenersResult:
    """
    This data source provides the Nlb Listeners of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.191.0+.


    :param Sequence[str] ids: A list of Listener IDs.
    :param str listener_protocol: The listening protocol. Valid values: `TCP`, `UDP`, or `TCPSSL`.
    :param Sequence[str] load_balancer_ids: The ID of the NLB instance. You can specify at most 20 IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['listenerProtocol'] = listener_protocol
    __args__['loadBalancerIds'] = load_balancer_ids
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:nlb/getListeners:getListeners', __args__, opts=opts, typ=GetListenersResult).value

    return AwaitableGetListenersResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        listener_protocol=pulumi.get(__ret__, 'listener_protocol'),
        listeners=pulumi.get(__ret__, 'listeners'),
        load_balancer_ids=pulumi.get(__ret__, 'load_balancer_ids'),
        output_file=pulumi.get(__ret__, 'output_file'))


@_utilities.lift_output_func(get_listeners)
def get_listeners_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                         listener_protocol: Optional[pulumi.Input[Optional[str]]] = None,
                         load_balancer_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                         output_file: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetListenersResult]:
    """
    This data source provides the Nlb Listeners of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.191.0+.


    :param Sequence[str] ids: A list of Listener IDs.
    :param str listener_protocol: The listening protocol. Valid values: `TCP`, `UDP`, or `TCPSSL`.
    :param Sequence[str] load_balancer_ids: The ID of the NLB instance. You can specify at most 20 IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    ...
