# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ListenerArgs', 'Listener']

@pulumi.input_type
class ListenerArgs:
    def __init__(__self__, *,
                 listener_port: pulumi.Input[int],
                 listener_protocol: pulumi.Input[str],
                 load_balancer_id: pulumi.Input[str],
                 server_group_id: pulumi.Input[str],
                 alpn_enabled: Optional[pulumi.Input[bool]] = None,
                 alpn_policy: Optional[pulumi.Input[str]] = None,
                 ca_certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ca_enabled: Optional[pulumi.Input[bool]] = None,
                 certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cps: Optional[pulumi.Input[int]] = None,
                 end_port: Optional[pulumi.Input[int]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 listener_description: Optional[pulumi.Input[str]] = None,
                 mss: Optional[pulumi.Input[int]] = None,
                 proxy_protocol_enabled: Optional[pulumi.Input[bool]] = None,
                 sec_sensor_enabled: Optional[pulumi.Input[bool]] = None,
                 security_policy_id: Optional[pulumi.Input[str]] = None,
                 start_port: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Listener resource.
        :param pulumi.Input[int] listener_port: Listening port. Valid values: 0 ~ 65535. `0`: indicates that full port listening is used. When set to `0`, you must configure `StartPort` and `EndPort`.
        :param pulumi.Input[str] listener_protocol: The listening protocol. Valid values: `TCP`, `UDP`, or `TCPSSL`.
        :param pulumi.Input[str] load_balancer_id: The ID of the network-based server load balancer instance.
        :param pulumi.Input[str] server_group_id: The ID of the server group.
        :param pulumi.Input[bool] alpn_enabled: Specifies whether to enable Application-Layer Protocol Negotiation (ALPN).
        :param pulumi.Input[str] alpn_policy: The ALPN policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ca_certificate_ids: The list of certificate authority (CA) certificates. This parameter takes effect only for listeners that use SSL over TCP. **Note:** Only one CA certificate is supported.
        :param pulumi.Input[bool] ca_enabled: Specifies whether to enable mutual authentication.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] certificate_ids: The list of server certificates. This parameter takes effect only for listeners that use SSL over TCP. **Note:** Only one server certificate is supported.
        :param pulumi.Input[int] cps: The maximum number of connections that can be created per second on the NLB instance. Valid values: 0 to 1000000. 0 specifies that the number of connections is unlimited.
        :param pulumi.Input[int] end_port: Full port listening end port. Valid values: `0` ~ `65535`. The value of the end port is less than the start port.
        :param pulumi.Input[int] idle_timeout: The timeout period of an idle connection. Unit: seconds. Valid values: `1` to `900`. Default value: `900`.
        :param pulumi.Input[str] listener_description: Custom listener name. The length is limited to 2 to 256 characters, supports Chinese and English letters, and can include numbers, commas (,), half-width periods (.), half-width semicolons (;), forward slashes (/), at(@), underscores (_), and dashes (-).
        :param pulumi.Input[int] mss: The maximum size of a TCP segment. Unit: bytes. Valid values: 0 to 1500. 0 specifies that the maximum segment size remains unchanged. **Note:** This parameter is supported only by listeners that use SSL over TCP.
        :param pulumi.Input[bool] proxy_protocol_enabled: Specifies whether to use the Proxy protocol to pass client IP addresses to backend servers.
        :param pulumi.Input[bool] sec_sensor_enabled: Specifies whether to enable fine-grained monitoring.
        :param pulumi.Input[str] security_policy_id: The ID of the security policy. System security policies and custom security policies are supported. 
               System security policies valid values: `tls_cipher_policy_1_0` (default), `tls_cipher_policy_1_1,` `tls_cipher_policy_1_2`, `tls_cipher_policy_1_2_strict`, and `tls_cipher_policy_1_2_strict_with_1_3`.
               Custom security policies can be created by resource `nlb.SecurityPolicy`.
        :param pulumi.Input[int] start_port: Full Port listens to the starting port. Valid values: `0` ~ `65535`.
        :param pulumi.Input[str] status: The status of the resource. Valid values: `Running`, `Stopped`.
        """
        pulumi.set(__self__, "listener_port", listener_port)
        pulumi.set(__self__, "listener_protocol", listener_protocol)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "server_group_id", server_group_id)
        if alpn_enabled is not None:
            pulumi.set(__self__, "alpn_enabled", alpn_enabled)
        if alpn_policy is not None:
            pulumi.set(__self__, "alpn_policy", alpn_policy)
        if ca_certificate_ids is not None:
            pulumi.set(__self__, "ca_certificate_ids", ca_certificate_ids)
        if ca_enabled is not None:
            pulumi.set(__self__, "ca_enabled", ca_enabled)
        if certificate_ids is not None:
            pulumi.set(__self__, "certificate_ids", certificate_ids)
        if cps is not None:
            pulumi.set(__self__, "cps", cps)
        if end_port is not None:
            pulumi.set(__self__, "end_port", end_port)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if listener_description is not None:
            pulumi.set(__self__, "listener_description", listener_description)
        if mss is not None:
            pulumi.set(__self__, "mss", mss)
        if proxy_protocol_enabled is not None:
            pulumi.set(__self__, "proxy_protocol_enabled", proxy_protocol_enabled)
        if sec_sensor_enabled is not None:
            pulumi.set(__self__, "sec_sensor_enabled", sec_sensor_enabled)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)
        if start_port is not None:
            pulumi.set(__self__, "start_port", start_port)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> pulumi.Input[int]:
        """
        Listening port. Valid values: 0 ~ 65535. `0`: indicates that full port listening is used. When set to `0`, you must configure `StartPort` and `EndPort`.
        """
        return pulumi.get(self, "listener_port")

    @listener_port.setter
    def listener_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "listener_port", value)

    @property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> pulumi.Input[str]:
        """
        The listening protocol. Valid values: `TCP`, `UDP`, or `TCPSSL`.
        """
        return pulumi.get(self, "listener_protocol")

    @listener_protocol.setter
    def listener_protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "listener_protocol", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Input[str]:
        """
        The ID of the network-based server load balancer instance.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> pulumi.Input[str]:
        """
        The ID of the server group.
        """
        return pulumi.get(self, "server_group_id")

    @server_group_id.setter
    def server_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_group_id", value)

    @property
    @pulumi.getter(name="alpnEnabled")
    def alpn_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable Application-Layer Protocol Negotiation (ALPN).
        """
        return pulumi.get(self, "alpn_enabled")

    @alpn_enabled.setter
    def alpn_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "alpn_enabled", value)

    @property
    @pulumi.getter(name="alpnPolicy")
    def alpn_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The ALPN policy.
        """
        return pulumi.get(self, "alpn_policy")

    @alpn_policy.setter
    def alpn_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alpn_policy", value)

    @property
    @pulumi.getter(name="caCertificateIds")
    def ca_certificate_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of certificate authority (CA) certificates. This parameter takes effect only for listeners that use SSL over TCP. **Note:** Only one CA certificate is supported.
        """
        return pulumi.get(self, "ca_certificate_ids")

    @ca_certificate_ids.setter
    def ca_certificate_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ca_certificate_ids", value)

    @property
    @pulumi.getter(name="caEnabled")
    def ca_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable mutual authentication.
        """
        return pulumi.get(self, "ca_enabled")

    @ca_enabled.setter
    def ca_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ca_enabled", value)

    @property
    @pulumi.getter(name="certificateIds")
    def certificate_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of server certificates. This parameter takes effect only for listeners that use SSL over TCP. **Note:** Only one server certificate is supported.
        """
        return pulumi.get(self, "certificate_ids")

    @certificate_ids.setter
    def certificate_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "certificate_ids", value)

    @property
    @pulumi.getter
    def cps(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of connections that can be created per second on the NLB instance. Valid values: 0 to 1000000. 0 specifies that the number of connections is unlimited.
        """
        return pulumi.get(self, "cps")

    @cps.setter
    def cps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cps", value)

    @property
    @pulumi.getter(name="endPort")
    def end_port(self) -> Optional[pulumi.Input[int]]:
        """
        Full port listening end port. Valid values: `0` ~ `65535`. The value of the end port is less than the start port.
        """
        return pulumi.get(self, "end_port")

    @end_port.setter
    def end_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "end_port", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout period of an idle connection. Unit: seconds. Valid values: `1` to `900`. Default value: `900`.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter(name="listenerDescription")
    def listener_description(self) -> Optional[pulumi.Input[str]]:
        """
        Custom listener name. The length is limited to 2 to 256 characters, supports Chinese and English letters, and can include numbers, commas (,), half-width periods (.), half-width semicolons (;), forward slashes (/), at(@), underscores (_), and dashes (-).
        """
        return pulumi.get(self, "listener_description")

    @listener_description.setter
    def listener_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_description", value)

    @property
    @pulumi.getter
    def mss(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum size of a TCP segment. Unit: bytes. Valid values: 0 to 1500. 0 specifies that the maximum segment size remains unchanged. **Note:** This parameter is supported only by listeners that use SSL over TCP.
        """
        return pulumi.get(self, "mss")

    @mss.setter
    def mss(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mss", value)

    @property
    @pulumi.getter(name="proxyProtocolEnabled")
    def proxy_protocol_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use the Proxy protocol to pass client IP addresses to backend servers.
        """
        return pulumi.get(self, "proxy_protocol_enabled")

    @proxy_protocol_enabled.setter
    def proxy_protocol_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "proxy_protocol_enabled", value)

    @property
    @pulumi.getter(name="secSensorEnabled")
    def sec_sensor_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable fine-grained monitoring.
        """
        return pulumi.get(self, "sec_sensor_enabled")

    @sec_sensor_enabled.setter
    def sec_sensor_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sec_sensor_enabled", value)

    @property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the security policy. System security policies and custom security policies are supported. 
        System security policies valid values: `tls_cipher_policy_1_0` (default), `tls_cipher_policy_1_1,` `tls_cipher_policy_1_2`, `tls_cipher_policy_1_2_strict`, and `tls_cipher_policy_1_2_strict_with_1_3`.
        Custom security policies can be created by resource `nlb.SecurityPolicy`.
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_policy_id", value)

    @property
    @pulumi.getter(name="startPort")
    def start_port(self) -> Optional[pulumi.Input[int]]:
        """
        Full Port listens to the starting port. Valid values: `0` ~ `65535`.
        """
        return pulumi.get(self, "start_port")

    @start_port.setter
    def start_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "start_port", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the resource. Valid values: `Running`, `Stopped`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _ListenerState:
    def __init__(__self__, *,
                 alpn_enabled: Optional[pulumi.Input[bool]] = None,
                 alpn_policy: Optional[pulumi.Input[str]] = None,
                 ca_certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ca_enabled: Optional[pulumi.Input[bool]] = None,
                 certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cps: Optional[pulumi.Input[int]] = None,
                 end_port: Optional[pulumi.Input[int]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 listener_description: Optional[pulumi.Input[str]] = None,
                 listener_port: Optional[pulumi.Input[int]] = None,
                 listener_protocol: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 mss: Optional[pulumi.Input[int]] = None,
                 proxy_protocol_enabled: Optional[pulumi.Input[bool]] = None,
                 sec_sensor_enabled: Optional[pulumi.Input[bool]] = None,
                 security_policy_id: Optional[pulumi.Input[str]] = None,
                 server_group_id: Optional[pulumi.Input[str]] = None,
                 start_port: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Listener resources.
        :param pulumi.Input[bool] alpn_enabled: Specifies whether to enable Application-Layer Protocol Negotiation (ALPN).
        :param pulumi.Input[str] alpn_policy: The ALPN policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ca_certificate_ids: The list of certificate authority (CA) certificates. This parameter takes effect only for listeners that use SSL over TCP. **Note:** Only one CA certificate is supported.
        :param pulumi.Input[bool] ca_enabled: Specifies whether to enable mutual authentication.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] certificate_ids: The list of server certificates. This parameter takes effect only for listeners that use SSL over TCP. **Note:** Only one server certificate is supported.
        :param pulumi.Input[int] cps: The maximum number of connections that can be created per second on the NLB instance. Valid values: 0 to 1000000. 0 specifies that the number of connections is unlimited.
        :param pulumi.Input[int] end_port: Full port listening end port. Valid values: `0` ~ `65535`. The value of the end port is less than the start port.
        :param pulumi.Input[int] idle_timeout: The timeout period of an idle connection. Unit: seconds. Valid values: `1` to `900`. Default value: `900`.
        :param pulumi.Input[str] listener_description: Custom listener name. The length is limited to 2 to 256 characters, supports Chinese and English letters, and can include numbers, commas (,), half-width periods (.), half-width semicolons (;), forward slashes (/), at(@), underscores (_), and dashes (-).
        :param pulumi.Input[int] listener_port: Listening port. Valid values: 0 ~ 65535. `0`: indicates that full port listening is used. When set to `0`, you must configure `StartPort` and `EndPort`.
        :param pulumi.Input[str] listener_protocol: The listening protocol. Valid values: `TCP`, `UDP`, or `TCPSSL`.
        :param pulumi.Input[str] load_balancer_id: The ID of the network-based server load balancer instance.
        :param pulumi.Input[int] mss: The maximum size of a TCP segment. Unit: bytes. Valid values: 0 to 1500. 0 specifies that the maximum segment size remains unchanged. **Note:** This parameter is supported only by listeners that use SSL over TCP.
        :param pulumi.Input[bool] proxy_protocol_enabled: Specifies whether to use the Proxy protocol to pass client IP addresses to backend servers.
        :param pulumi.Input[bool] sec_sensor_enabled: Specifies whether to enable fine-grained monitoring.
        :param pulumi.Input[str] security_policy_id: The ID of the security policy. System security policies and custom security policies are supported. 
               System security policies valid values: `tls_cipher_policy_1_0` (default), `tls_cipher_policy_1_1,` `tls_cipher_policy_1_2`, `tls_cipher_policy_1_2_strict`, and `tls_cipher_policy_1_2_strict_with_1_3`.
               Custom security policies can be created by resource `nlb.SecurityPolicy`.
        :param pulumi.Input[str] server_group_id: The ID of the server group.
        :param pulumi.Input[int] start_port: Full Port listens to the starting port. Valid values: `0` ~ `65535`.
        :param pulumi.Input[str] status: The status of the resource. Valid values: `Running`, `Stopped`.
        """
        if alpn_enabled is not None:
            pulumi.set(__self__, "alpn_enabled", alpn_enabled)
        if alpn_policy is not None:
            pulumi.set(__self__, "alpn_policy", alpn_policy)
        if ca_certificate_ids is not None:
            pulumi.set(__self__, "ca_certificate_ids", ca_certificate_ids)
        if ca_enabled is not None:
            pulumi.set(__self__, "ca_enabled", ca_enabled)
        if certificate_ids is not None:
            pulumi.set(__self__, "certificate_ids", certificate_ids)
        if cps is not None:
            pulumi.set(__self__, "cps", cps)
        if end_port is not None:
            pulumi.set(__self__, "end_port", end_port)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if listener_description is not None:
            pulumi.set(__self__, "listener_description", listener_description)
        if listener_port is not None:
            pulumi.set(__self__, "listener_port", listener_port)
        if listener_protocol is not None:
            pulumi.set(__self__, "listener_protocol", listener_protocol)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if mss is not None:
            pulumi.set(__self__, "mss", mss)
        if proxy_protocol_enabled is not None:
            pulumi.set(__self__, "proxy_protocol_enabled", proxy_protocol_enabled)
        if sec_sensor_enabled is not None:
            pulumi.set(__self__, "sec_sensor_enabled", sec_sensor_enabled)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)
        if server_group_id is not None:
            pulumi.set(__self__, "server_group_id", server_group_id)
        if start_port is not None:
            pulumi.set(__self__, "start_port", start_port)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="alpnEnabled")
    def alpn_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable Application-Layer Protocol Negotiation (ALPN).
        """
        return pulumi.get(self, "alpn_enabled")

    @alpn_enabled.setter
    def alpn_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "alpn_enabled", value)

    @property
    @pulumi.getter(name="alpnPolicy")
    def alpn_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The ALPN policy.
        """
        return pulumi.get(self, "alpn_policy")

    @alpn_policy.setter
    def alpn_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alpn_policy", value)

    @property
    @pulumi.getter(name="caCertificateIds")
    def ca_certificate_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of certificate authority (CA) certificates. This parameter takes effect only for listeners that use SSL over TCP. **Note:** Only one CA certificate is supported.
        """
        return pulumi.get(self, "ca_certificate_ids")

    @ca_certificate_ids.setter
    def ca_certificate_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ca_certificate_ids", value)

    @property
    @pulumi.getter(name="caEnabled")
    def ca_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable mutual authentication.
        """
        return pulumi.get(self, "ca_enabled")

    @ca_enabled.setter
    def ca_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ca_enabled", value)

    @property
    @pulumi.getter(name="certificateIds")
    def certificate_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of server certificates. This parameter takes effect only for listeners that use SSL over TCP. **Note:** Only one server certificate is supported.
        """
        return pulumi.get(self, "certificate_ids")

    @certificate_ids.setter
    def certificate_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "certificate_ids", value)

    @property
    @pulumi.getter
    def cps(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of connections that can be created per second on the NLB instance. Valid values: 0 to 1000000. 0 specifies that the number of connections is unlimited.
        """
        return pulumi.get(self, "cps")

    @cps.setter
    def cps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cps", value)

    @property
    @pulumi.getter(name="endPort")
    def end_port(self) -> Optional[pulumi.Input[int]]:
        """
        Full port listening end port. Valid values: `0` ~ `65535`. The value of the end port is less than the start port.
        """
        return pulumi.get(self, "end_port")

    @end_port.setter
    def end_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "end_port", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout period of an idle connection. Unit: seconds. Valid values: `1` to `900`. Default value: `900`.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter(name="listenerDescription")
    def listener_description(self) -> Optional[pulumi.Input[str]]:
        """
        Custom listener name. The length is limited to 2 to 256 characters, supports Chinese and English letters, and can include numbers, commas (,), half-width periods (.), half-width semicolons (;), forward slashes (/), at(@), underscores (_), and dashes (-).
        """
        return pulumi.get(self, "listener_description")

    @listener_description.setter
    def listener_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_description", value)

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> Optional[pulumi.Input[int]]:
        """
        Listening port. Valid values: 0 ~ 65535. `0`: indicates that full port listening is used. When set to `0`, you must configure `StartPort` and `EndPort`.
        """
        return pulumi.get(self, "listener_port")

    @listener_port.setter
    def listener_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "listener_port", value)

    @property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The listening protocol. Valid values: `TCP`, `UDP`, or `TCPSSL`.
        """
        return pulumi.get(self, "listener_protocol")

    @listener_protocol.setter
    def listener_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_protocol", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the network-based server load balancer instance.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter
    def mss(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum size of a TCP segment. Unit: bytes. Valid values: 0 to 1500. 0 specifies that the maximum segment size remains unchanged. **Note:** This parameter is supported only by listeners that use SSL over TCP.
        """
        return pulumi.get(self, "mss")

    @mss.setter
    def mss(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mss", value)

    @property
    @pulumi.getter(name="proxyProtocolEnabled")
    def proxy_protocol_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use the Proxy protocol to pass client IP addresses to backend servers.
        """
        return pulumi.get(self, "proxy_protocol_enabled")

    @proxy_protocol_enabled.setter
    def proxy_protocol_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "proxy_protocol_enabled", value)

    @property
    @pulumi.getter(name="secSensorEnabled")
    def sec_sensor_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable fine-grained monitoring.
        """
        return pulumi.get(self, "sec_sensor_enabled")

    @sec_sensor_enabled.setter
    def sec_sensor_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sec_sensor_enabled", value)

    @property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the security policy. System security policies and custom security policies are supported. 
        System security policies valid values: `tls_cipher_policy_1_0` (default), `tls_cipher_policy_1_1,` `tls_cipher_policy_1_2`, `tls_cipher_policy_1_2_strict`, and `tls_cipher_policy_1_2_strict_with_1_3`.
        Custom security policies can be created by resource `nlb.SecurityPolicy`.
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_policy_id", value)

    @property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the server group.
        """
        return pulumi.get(self, "server_group_id")

    @server_group_id.setter
    def server_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_group_id", value)

    @property
    @pulumi.getter(name="startPort")
    def start_port(self) -> Optional[pulumi.Input[int]]:
        """
        Full Port listens to the starting port. Valid values: `0` ~ `65535`.
        """
        return pulumi.get(self, "start_port")

    @start_port.setter
    def start_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "start_port", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the resource. Valid values: `Running`, `Stopped`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class Listener(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alpn_enabled: Optional[pulumi.Input[bool]] = None,
                 alpn_policy: Optional[pulumi.Input[str]] = None,
                 ca_certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ca_enabled: Optional[pulumi.Input[bool]] = None,
                 certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cps: Optional[pulumi.Input[int]] = None,
                 end_port: Optional[pulumi.Input[int]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 listener_description: Optional[pulumi.Input[str]] = None,
                 listener_port: Optional[pulumi.Input[int]] = None,
                 listener_protocol: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 mss: Optional[pulumi.Input[int]] = None,
                 proxy_protocol_enabled: Optional[pulumi.Input[bool]] = None,
                 sec_sensor_enabled: Optional[pulumi.Input[bool]] = None,
                 security_policy_id: Optional[pulumi.Input[str]] = None,
                 server_group_id: Optional[pulumi.Input[str]] = None,
                 start_port: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a NLB Listener resource.

        For information about NLB Listener and how to use it, see [What is Listener](https://www.alibabacloud.com/help/en/server-load-balancer/latest/createlistener-nl).

        > **NOTE:** Available since v1.191.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_resource_groups = alicloud.resourcemanager.get_resource_groups()
        default_zones = alicloud.nlb.get_zones()
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default1 = alicloud.vpc.Switch("default1",
            vswitch_name=name,
            cidr_block="10.4.1.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[1].id)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_load_balancer = alicloud.nlb.LoadBalancer("defaultLoadBalancer",
            load_balancer_name=name,
            resource_group_id=default_resource_groups.ids[0],
            load_balancer_type="Network",
            address_type="Internet",
            address_ip_version="Ipv4",
            vpc_id=default_network.id,
            tags={
                "Created": "TF",
                "For": "example",
            },
            zone_mappings=[
                alicloud.nlb.LoadBalancerZoneMappingArgs(
                    vswitch_id=default_switch.id,
                    zone_id=default_zones.zones[0].id,
                ),
                alicloud.nlb.LoadBalancerZoneMappingArgs(
                    vswitch_id=default1.id,
                    zone_id=default_zones.zones[1].id,
                ),
            ])
        default_server_group = alicloud.nlb.ServerGroup("defaultServerGroup",
            resource_group_id=default_resource_groups.ids[0],
            server_group_name=name,
            server_group_type="Instance",
            vpc_id=default_network.id,
            scheduler="Wrr",
            protocol="TCP",
            connection_drain=True,
            connection_drain_timeout=60,
            address_ip_version="Ipv4",
            health_check=alicloud.nlb.ServerGroupHealthCheckArgs(
                health_check_enabled=True,
                health_check_type="TCP",
                health_check_connect_port=0,
                healthy_threshold=2,
                unhealthy_threshold=2,
                health_check_connect_timeout=5,
                health_check_interval=10,
                http_check_method="GET",
                health_check_http_codes=[
                    "http_2xx",
                    "http_3xx",
                    "http_4xx",
                ],
            ),
            tags={
                "Created": "TF",
                "For": "example",
            })
        default_listener = alicloud.nlb.Listener("defaultListener",
            listener_protocol="TCP",
            listener_port=80,
            listener_description=name,
            load_balancer_id=default_load_balancer.id,
            server_group_id=default_server_group.id,
            idle_timeout=900,
            proxy_protocol_enabled=True,
            sec_sensor_enabled=True,
            cps=10000,
            mss=0)
        ```

        ## Import

        NLB Listener can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:nlb/listener:Listener example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] alpn_enabled: Specifies whether to enable Application-Layer Protocol Negotiation (ALPN).
        :param pulumi.Input[str] alpn_policy: The ALPN policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ca_certificate_ids: The list of certificate authority (CA) certificates. This parameter takes effect only for listeners that use SSL over TCP. **Note:** Only one CA certificate is supported.
        :param pulumi.Input[bool] ca_enabled: Specifies whether to enable mutual authentication.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] certificate_ids: The list of server certificates. This parameter takes effect only for listeners that use SSL over TCP. **Note:** Only one server certificate is supported.
        :param pulumi.Input[int] cps: The maximum number of connections that can be created per second on the NLB instance. Valid values: 0 to 1000000. 0 specifies that the number of connections is unlimited.
        :param pulumi.Input[int] end_port: Full port listening end port. Valid values: `0` ~ `65535`. The value of the end port is less than the start port.
        :param pulumi.Input[int] idle_timeout: The timeout period of an idle connection. Unit: seconds. Valid values: `1` to `900`. Default value: `900`.
        :param pulumi.Input[str] listener_description: Custom listener name. The length is limited to 2 to 256 characters, supports Chinese and English letters, and can include numbers, commas (,), half-width periods (.), half-width semicolons (;), forward slashes (/), at(@), underscores (_), and dashes (-).
        :param pulumi.Input[int] listener_port: Listening port. Valid values: 0 ~ 65535. `0`: indicates that full port listening is used. When set to `0`, you must configure `StartPort` and `EndPort`.
        :param pulumi.Input[str] listener_protocol: The listening protocol. Valid values: `TCP`, `UDP`, or `TCPSSL`.
        :param pulumi.Input[str] load_balancer_id: The ID of the network-based server load balancer instance.
        :param pulumi.Input[int] mss: The maximum size of a TCP segment. Unit: bytes. Valid values: 0 to 1500. 0 specifies that the maximum segment size remains unchanged. **Note:** This parameter is supported only by listeners that use SSL over TCP.
        :param pulumi.Input[bool] proxy_protocol_enabled: Specifies whether to use the Proxy protocol to pass client IP addresses to backend servers.
        :param pulumi.Input[bool] sec_sensor_enabled: Specifies whether to enable fine-grained monitoring.
        :param pulumi.Input[str] security_policy_id: The ID of the security policy. System security policies and custom security policies are supported. 
               System security policies valid values: `tls_cipher_policy_1_0` (default), `tls_cipher_policy_1_1,` `tls_cipher_policy_1_2`, `tls_cipher_policy_1_2_strict`, and `tls_cipher_policy_1_2_strict_with_1_3`.
               Custom security policies can be created by resource `nlb.SecurityPolicy`.
        :param pulumi.Input[str] server_group_id: The ID of the server group.
        :param pulumi.Input[int] start_port: Full Port listens to the starting port. Valid values: `0` ~ `65535`.
        :param pulumi.Input[str] status: The status of the resource. Valid values: `Running`, `Stopped`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListenerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a NLB Listener resource.

        For information about NLB Listener and how to use it, see [What is Listener](https://www.alibabacloud.com/help/en/server-load-balancer/latest/createlistener-nl).

        > **NOTE:** Available since v1.191.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_resource_groups = alicloud.resourcemanager.get_resource_groups()
        default_zones = alicloud.nlb.get_zones()
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default1 = alicloud.vpc.Switch("default1",
            vswitch_name=name,
            cidr_block="10.4.1.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[1].id)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_load_balancer = alicloud.nlb.LoadBalancer("defaultLoadBalancer",
            load_balancer_name=name,
            resource_group_id=default_resource_groups.ids[0],
            load_balancer_type="Network",
            address_type="Internet",
            address_ip_version="Ipv4",
            vpc_id=default_network.id,
            tags={
                "Created": "TF",
                "For": "example",
            },
            zone_mappings=[
                alicloud.nlb.LoadBalancerZoneMappingArgs(
                    vswitch_id=default_switch.id,
                    zone_id=default_zones.zones[0].id,
                ),
                alicloud.nlb.LoadBalancerZoneMappingArgs(
                    vswitch_id=default1.id,
                    zone_id=default_zones.zones[1].id,
                ),
            ])
        default_server_group = alicloud.nlb.ServerGroup("defaultServerGroup",
            resource_group_id=default_resource_groups.ids[0],
            server_group_name=name,
            server_group_type="Instance",
            vpc_id=default_network.id,
            scheduler="Wrr",
            protocol="TCP",
            connection_drain=True,
            connection_drain_timeout=60,
            address_ip_version="Ipv4",
            health_check=alicloud.nlb.ServerGroupHealthCheckArgs(
                health_check_enabled=True,
                health_check_type="TCP",
                health_check_connect_port=0,
                healthy_threshold=2,
                unhealthy_threshold=2,
                health_check_connect_timeout=5,
                health_check_interval=10,
                http_check_method="GET",
                health_check_http_codes=[
                    "http_2xx",
                    "http_3xx",
                    "http_4xx",
                ],
            ),
            tags={
                "Created": "TF",
                "For": "example",
            })
        default_listener = alicloud.nlb.Listener("defaultListener",
            listener_protocol="TCP",
            listener_port=80,
            listener_description=name,
            load_balancer_id=default_load_balancer.id,
            server_group_id=default_server_group.id,
            idle_timeout=900,
            proxy_protocol_enabled=True,
            sec_sensor_enabled=True,
            cps=10000,
            mss=0)
        ```

        ## Import

        NLB Listener can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:nlb/listener:Listener example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ListenerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListenerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alpn_enabled: Optional[pulumi.Input[bool]] = None,
                 alpn_policy: Optional[pulumi.Input[str]] = None,
                 ca_certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ca_enabled: Optional[pulumi.Input[bool]] = None,
                 certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cps: Optional[pulumi.Input[int]] = None,
                 end_port: Optional[pulumi.Input[int]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 listener_description: Optional[pulumi.Input[str]] = None,
                 listener_port: Optional[pulumi.Input[int]] = None,
                 listener_protocol: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 mss: Optional[pulumi.Input[int]] = None,
                 proxy_protocol_enabled: Optional[pulumi.Input[bool]] = None,
                 sec_sensor_enabled: Optional[pulumi.Input[bool]] = None,
                 security_policy_id: Optional[pulumi.Input[str]] = None,
                 server_group_id: Optional[pulumi.Input[str]] = None,
                 start_port: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListenerArgs.__new__(ListenerArgs)

            __props__.__dict__["alpn_enabled"] = alpn_enabled
            __props__.__dict__["alpn_policy"] = alpn_policy
            __props__.__dict__["ca_certificate_ids"] = ca_certificate_ids
            __props__.__dict__["ca_enabled"] = ca_enabled
            __props__.__dict__["certificate_ids"] = certificate_ids
            __props__.__dict__["cps"] = cps
            __props__.__dict__["end_port"] = end_port
            __props__.__dict__["idle_timeout"] = idle_timeout
            __props__.__dict__["listener_description"] = listener_description
            if listener_port is None and not opts.urn:
                raise TypeError("Missing required property 'listener_port'")
            __props__.__dict__["listener_port"] = listener_port
            if listener_protocol is None and not opts.urn:
                raise TypeError("Missing required property 'listener_protocol'")
            __props__.__dict__["listener_protocol"] = listener_protocol
            if load_balancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_id'")
            __props__.__dict__["load_balancer_id"] = load_balancer_id
            __props__.__dict__["mss"] = mss
            __props__.__dict__["proxy_protocol_enabled"] = proxy_protocol_enabled
            __props__.__dict__["sec_sensor_enabled"] = sec_sensor_enabled
            __props__.__dict__["security_policy_id"] = security_policy_id
            if server_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'server_group_id'")
            __props__.__dict__["server_group_id"] = server_group_id
            __props__.__dict__["start_port"] = start_port
            __props__.__dict__["status"] = status
        super(Listener, __self__).__init__(
            'alicloud:nlb/listener:Listener',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alpn_enabled: Optional[pulumi.Input[bool]] = None,
            alpn_policy: Optional[pulumi.Input[str]] = None,
            ca_certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ca_enabled: Optional[pulumi.Input[bool]] = None,
            certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            cps: Optional[pulumi.Input[int]] = None,
            end_port: Optional[pulumi.Input[int]] = None,
            idle_timeout: Optional[pulumi.Input[int]] = None,
            listener_description: Optional[pulumi.Input[str]] = None,
            listener_port: Optional[pulumi.Input[int]] = None,
            listener_protocol: Optional[pulumi.Input[str]] = None,
            load_balancer_id: Optional[pulumi.Input[str]] = None,
            mss: Optional[pulumi.Input[int]] = None,
            proxy_protocol_enabled: Optional[pulumi.Input[bool]] = None,
            sec_sensor_enabled: Optional[pulumi.Input[bool]] = None,
            security_policy_id: Optional[pulumi.Input[str]] = None,
            server_group_id: Optional[pulumi.Input[str]] = None,
            start_port: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'Listener':
        """
        Get an existing Listener resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] alpn_enabled: Specifies whether to enable Application-Layer Protocol Negotiation (ALPN).
        :param pulumi.Input[str] alpn_policy: The ALPN policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ca_certificate_ids: The list of certificate authority (CA) certificates. This parameter takes effect only for listeners that use SSL over TCP. **Note:** Only one CA certificate is supported.
        :param pulumi.Input[bool] ca_enabled: Specifies whether to enable mutual authentication.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] certificate_ids: The list of server certificates. This parameter takes effect only for listeners that use SSL over TCP. **Note:** Only one server certificate is supported.
        :param pulumi.Input[int] cps: The maximum number of connections that can be created per second on the NLB instance. Valid values: 0 to 1000000. 0 specifies that the number of connections is unlimited.
        :param pulumi.Input[int] end_port: Full port listening end port. Valid values: `0` ~ `65535`. The value of the end port is less than the start port.
        :param pulumi.Input[int] idle_timeout: The timeout period of an idle connection. Unit: seconds. Valid values: `1` to `900`. Default value: `900`.
        :param pulumi.Input[str] listener_description: Custom listener name. The length is limited to 2 to 256 characters, supports Chinese and English letters, and can include numbers, commas (,), half-width periods (.), half-width semicolons (;), forward slashes (/), at(@), underscores (_), and dashes (-).
        :param pulumi.Input[int] listener_port: Listening port. Valid values: 0 ~ 65535. `0`: indicates that full port listening is used. When set to `0`, you must configure `StartPort` and `EndPort`.
        :param pulumi.Input[str] listener_protocol: The listening protocol. Valid values: `TCP`, `UDP`, or `TCPSSL`.
        :param pulumi.Input[str] load_balancer_id: The ID of the network-based server load balancer instance.
        :param pulumi.Input[int] mss: The maximum size of a TCP segment. Unit: bytes. Valid values: 0 to 1500. 0 specifies that the maximum segment size remains unchanged. **Note:** This parameter is supported only by listeners that use SSL over TCP.
        :param pulumi.Input[bool] proxy_protocol_enabled: Specifies whether to use the Proxy protocol to pass client IP addresses to backend servers.
        :param pulumi.Input[bool] sec_sensor_enabled: Specifies whether to enable fine-grained monitoring.
        :param pulumi.Input[str] security_policy_id: The ID of the security policy. System security policies and custom security policies are supported. 
               System security policies valid values: `tls_cipher_policy_1_0` (default), `tls_cipher_policy_1_1,` `tls_cipher_policy_1_2`, `tls_cipher_policy_1_2_strict`, and `tls_cipher_policy_1_2_strict_with_1_3`.
               Custom security policies can be created by resource `nlb.SecurityPolicy`.
        :param pulumi.Input[str] server_group_id: The ID of the server group.
        :param pulumi.Input[int] start_port: Full Port listens to the starting port. Valid values: `0` ~ `65535`.
        :param pulumi.Input[str] status: The status of the resource. Valid values: `Running`, `Stopped`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListenerState.__new__(_ListenerState)

        __props__.__dict__["alpn_enabled"] = alpn_enabled
        __props__.__dict__["alpn_policy"] = alpn_policy
        __props__.__dict__["ca_certificate_ids"] = ca_certificate_ids
        __props__.__dict__["ca_enabled"] = ca_enabled
        __props__.__dict__["certificate_ids"] = certificate_ids
        __props__.__dict__["cps"] = cps
        __props__.__dict__["end_port"] = end_port
        __props__.__dict__["idle_timeout"] = idle_timeout
        __props__.__dict__["listener_description"] = listener_description
        __props__.__dict__["listener_port"] = listener_port
        __props__.__dict__["listener_protocol"] = listener_protocol
        __props__.__dict__["load_balancer_id"] = load_balancer_id
        __props__.__dict__["mss"] = mss
        __props__.__dict__["proxy_protocol_enabled"] = proxy_protocol_enabled
        __props__.__dict__["sec_sensor_enabled"] = sec_sensor_enabled
        __props__.__dict__["security_policy_id"] = security_policy_id
        __props__.__dict__["server_group_id"] = server_group_id
        __props__.__dict__["start_port"] = start_port
        __props__.__dict__["status"] = status
        return Listener(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alpnEnabled")
    def alpn_enabled(self) -> pulumi.Output[bool]:
        """
        Specifies whether to enable Application-Layer Protocol Negotiation (ALPN).
        """
        return pulumi.get(self, "alpn_enabled")

    @property
    @pulumi.getter(name="alpnPolicy")
    def alpn_policy(self) -> pulumi.Output[Optional[str]]:
        """
        The ALPN policy.
        """
        return pulumi.get(self, "alpn_policy")

    @property
    @pulumi.getter(name="caCertificateIds")
    def ca_certificate_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of certificate authority (CA) certificates. This parameter takes effect only for listeners that use SSL over TCP. **Note:** Only one CA certificate is supported.
        """
        return pulumi.get(self, "ca_certificate_ids")

    @property
    @pulumi.getter(name="caEnabled")
    def ca_enabled(self) -> pulumi.Output[bool]:
        """
        Specifies whether to enable mutual authentication.
        """
        return pulumi.get(self, "ca_enabled")

    @property
    @pulumi.getter(name="certificateIds")
    def certificate_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of server certificates. This parameter takes effect only for listeners that use SSL over TCP. **Note:** Only one server certificate is supported.
        """
        return pulumi.get(self, "certificate_ids")

    @property
    @pulumi.getter
    def cps(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of connections that can be created per second on the NLB instance. Valid values: 0 to 1000000. 0 specifies that the number of connections is unlimited.
        """
        return pulumi.get(self, "cps")

    @property
    @pulumi.getter(name="endPort")
    def end_port(self) -> pulumi.Output[Optional[int]]:
        """
        Full port listening end port. Valid values: `0` ~ `65535`. The value of the end port is less than the start port.
        """
        return pulumi.get(self, "end_port")

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> pulumi.Output[int]:
        """
        The timeout period of an idle connection. Unit: seconds. Valid values: `1` to `900`. Default value: `900`.
        """
        return pulumi.get(self, "idle_timeout")

    @property
    @pulumi.getter(name="listenerDescription")
    def listener_description(self) -> pulumi.Output[Optional[str]]:
        """
        Custom listener name. The length is limited to 2 to 256 characters, supports Chinese and English letters, and can include numbers, commas (,), half-width periods (.), half-width semicolons (;), forward slashes (/), at(@), underscores (_), and dashes (-).
        """
        return pulumi.get(self, "listener_description")

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> pulumi.Output[int]:
        """
        Listening port. Valid values: 0 ~ 65535. `0`: indicates that full port listening is used. When set to `0`, you must configure `StartPort` and `EndPort`.
        """
        return pulumi.get(self, "listener_port")

    @property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> pulumi.Output[str]:
        """
        The listening protocol. Valid values: `TCP`, `UDP`, or `TCPSSL`.
        """
        return pulumi.get(self, "listener_protocol")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Output[str]:
        """
        The ID of the network-based server load balancer instance.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter
    def mss(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum size of a TCP segment. Unit: bytes. Valid values: 0 to 1500. 0 specifies that the maximum segment size remains unchanged. **Note:** This parameter is supported only by listeners that use SSL over TCP.
        """
        return pulumi.get(self, "mss")

    @property
    @pulumi.getter(name="proxyProtocolEnabled")
    def proxy_protocol_enabled(self) -> pulumi.Output[bool]:
        """
        Specifies whether to use the Proxy protocol to pass client IP addresses to backend servers.
        """
        return pulumi.get(self, "proxy_protocol_enabled")

    @property
    @pulumi.getter(name="secSensorEnabled")
    def sec_sensor_enabled(self) -> pulumi.Output[bool]:
        """
        Specifies whether to enable fine-grained monitoring.
        """
        return pulumi.get(self, "sec_sensor_enabled")

    @property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Output[str]:
        """
        The ID of the security policy. System security policies and custom security policies are supported. 
        System security policies valid values: `tls_cipher_policy_1_0` (default), `tls_cipher_policy_1_1,` `tls_cipher_policy_1_2`, `tls_cipher_policy_1_2_strict`, and `tls_cipher_policy_1_2_strict_with_1_3`.
        Custom security policies can be created by resource `nlb.SecurityPolicy`.
        """
        return pulumi.get(self, "security_policy_id")

    @property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the server group.
        """
        return pulumi.get(self, "server_group_id")

    @property
    @pulumi.getter(name="startPort")
    def start_port(self) -> pulumi.Output[Optional[int]]:
        """
        Full Port listens to the starting port. Valid values: `0` ~ `65535`.
        """
        return pulumi.get(self, "start_port")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the resource. Valid values: `Running`, `Stopped`.
        """
        return pulumi.get(self, "status")

