# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadBalancerArgs', 'LoadBalancer']

@pulumi.input_type
class LoadBalancerArgs:
    def __init__(__self__, *,
                 address_type: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 zone_mappings: pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]],
                 address_ip_version: Optional[pulumi.Input[str]] = None,
                 bandwidth_package_id: Optional[pulumi.Input[str]] = None,
                 cross_zone_enabled: Optional[pulumi.Input[bool]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 deletion_protection_reason: Optional[pulumi.Input[str]] = None,
                 load_balancer_name: Optional[pulumi.Input[str]] = None,
                 load_balancer_type: Optional[pulumi.Input[str]] = None,
                 modification_protection_reason: Optional[pulumi.Input[str]] = None,
                 modification_protection_status: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a LoadBalancer resource.
        :param pulumi.Input[str] address_type: The type of IPv4 address used by the NLB instance. Valid values:
               - Internet: The NLB instance uses a public IP address. The domain name of the NLB instance is resolved to the public IP address. Therefore, the NLB instance can be accessed over the Internet.
               - Intranet: The NLB instance uses a private IP address. The domain name of the NLB instance is resolved to the private IP address. Therefore, the NLB instance can be accessed over the virtual private cloud (VPC) where the NLB instance is deployed.
        :param pulumi.Input[str] vpc_id: The ID of the VPC where the NLB instance is deployed.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]] zone_mappings: Available Area Configuration List. You must add at least two zones. You can add a maximum of 10 zones. See `zone_mappings` below.
        :param pulumi.Input[str] address_ip_version: The protocol version. Valid values:
               - ipv4 (default): IPv4
               - DualStack: dual stack
        :param pulumi.Input[str] bandwidth_package_id: The ID of the EIP bandwidth plan that is associated with the NLB instance if the NLB instance uses a public IP address.
        :param pulumi.Input[bool] cross_zone_enabled: Specifies whether to enable cross-zone load balancing for the NLB instance.
        :param pulumi.Input[bool] deletion_protection_enabled: Specifies whether to enable deletion protection. Default value: `false`. Valid values:
        :param pulumi.Input[str] deletion_protection_reason: The reason why the deletion protection feature is enabled or disabled. The `deletion_protection_reason` takes effect only when `deletion_protection_enabled` is set to `true`.
        :param pulumi.Input[str] load_balancer_name: The name of the NLB instance. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[str] load_balancer_type: The type of the instance. Set the value to `Network`, which specifies an NLB instance.
        :param pulumi.Input[str] modification_protection_reason: The reason why the configuration read-only mode is enabled. The `modification_protection_reason` takes effect only when `modification_protection_status` is set to `ConsoleProtection`.
        :param pulumi.Input[str] modification_protection_status: Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. Valid values:
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "address_type", address_type)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "zone_mappings", zone_mappings)
        if address_ip_version is not None:
            pulumi.set(__self__, "address_ip_version", address_ip_version)
        if bandwidth_package_id is not None:
            pulumi.set(__self__, "bandwidth_package_id", bandwidth_package_id)
        if cross_zone_enabled is not None:
            pulumi.set(__self__, "cross_zone_enabled", cross_zone_enabled)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if deletion_protection_reason is not None:
            pulumi.set(__self__, "deletion_protection_reason", deletion_protection_reason)
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if modification_protection_reason is not None:
            pulumi.set(__self__, "modification_protection_reason", modification_protection_reason)
        if modification_protection_status is not None:
            pulumi.set(__self__, "modification_protection_status", modification_protection_status)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="addressType")
    def address_type(self) -> pulumi.Input[str]:
        """
        The type of IPv4 address used by the NLB instance. Valid values:
        - Internet: The NLB instance uses a public IP address. The domain name of the NLB instance is resolved to the public IP address. Therefore, the NLB instance can be accessed over the Internet.
        - Intranet: The NLB instance uses a private IP address. The domain name of the NLB instance is resolved to the private IP address. Therefore, the NLB instance can be accessed over the virtual private cloud (VPC) where the NLB instance is deployed.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "address_type", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        The ID of the VPC where the NLB instance is deployed.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="zoneMappings")
    def zone_mappings(self) -> pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]]:
        """
        Available Area Configuration List. You must add at least two zones. You can add a maximum of 10 zones. See `zone_mappings` below.
        """
        return pulumi.get(self, "zone_mappings")

    @zone_mappings.setter
    def zone_mappings(self, value: pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]]):
        pulumi.set(self, "zone_mappings", value)

    @property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol version. Valid values:
        - ipv4 (default): IPv4
        - DualStack: dual stack
        """
        return pulumi.get(self, "address_ip_version")

    @address_ip_version.setter
    def address_ip_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_ip_version", value)

    @property
    @pulumi.getter(name="bandwidthPackageId")
    def bandwidth_package_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the EIP bandwidth plan that is associated with the NLB instance if the NLB instance uses a public IP address.
        """
        return pulumi.get(self, "bandwidth_package_id")

    @bandwidth_package_id.setter
    def bandwidth_package_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth_package_id", value)

    @property
    @pulumi.getter(name="crossZoneEnabled")
    def cross_zone_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable cross-zone load balancing for the NLB instance.
        """
        return pulumi.get(self, "cross_zone_enabled")

    @cross_zone_enabled.setter
    def cross_zone_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cross_zone_enabled", value)

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable deletion protection. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @property
    @pulumi.getter(name="deletionProtectionReason")
    def deletion_protection_reason(self) -> Optional[pulumi.Input[str]]:
        """
        The reason why the deletion protection feature is enabled or disabled. The `deletion_protection_reason` takes effect only when `deletion_protection_enabled` is set to `true`.
        """
        return pulumi.get(self, "deletion_protection_reason")

    @deletion_protection_reason.setter
    def deletion_protection_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_protection_reason", value)

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the NLB instance. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        """
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_name", value)

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the instance. Set the value to `Network`, which specifies an NLB instance.
        """
        return pulumi.get(self, "load_balancer_type")

    @load_balancer_type.setter
    def load_balancer_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_type", value)

    @property
    @pulumi.getter(name="modificationProtectionReason")
    def modification_protection_reason(self) -> Optional[pulumi.Input[str]]:
        """
        The reason why the configuration read-only mode is enabled. The `modification_protection_reason` takes effect only when `modification_protection_status` is set to `ConsoleProtection`.
        """
        return pulumi.get(self, "modification_protection_reason")

    @modification_protection_reason.setter
    def modification_protection_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modification_protection_reason", value)

    @property
    @pulumi.getter(name="modificationProtectionStatus")
    def modification_protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. Valid values:
        """
        return pulumi.get(self, "modification_protection_status")

    @modification_protection_status.setter
    def modification_protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modification_protection_status", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _LoadBalancerState:
    def __init__(__self__, *,
                 address_ip_version: Optional[pulumi.Input[str]] = None,
                 address_type: Optional[pulumi.Input[str]] = None,
                 bandwidth_package_id: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 cross_zone_enabled: Optional[pulumi.Input[bool]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 deletion_protection_reason: Optional[pulumi.Input[str]] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 ipv6_address_type: Optional[pulumi.Input[str]] = None,
                 load_balancer_business_status: Optional[pulumi.Input[str]] = None,
                 load_balancer_name: Optional[pulumi.Input[str]] = None,
                 load_balancer_type: Optional[pulumi.Input[str]] = None,
                 modification_protection_reason: Optional[pulumi.Input[str]] = None,
                 modification_protection_status: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]]] = None):
        """
        Input properties used for looking up and filtering LoadBalancer resources.
        :param pulumi.Input[str] address_ip_version: The protocol version. Valid values:
               - ipv4 (default): IPv4
               - DualStack: dual stack
        :param pulumi.Input[str] address_type: The type of IPv4 address used by the NLB instance. Valid values:
               - Internet: The NLB instance uses a public IP address. The domain name of the NLB instance is resolved to the public IP address. Therefore, the NLB instance can be accessed over the Internet.
               - Intranet: The NLB instance uses a private IP address. The domain name of the NLB instance is resolved to the private IP address. Therefore, the NLB instance can be accessed over the virtual private cloud (VPC) where the NLB instance is deployed.
        :param pulumi.Input[str] bandwidth_package_id: The ID of the EIP bandwidth plan that is associated with the NLB instance if the NLB instance uses a public IP address.
        :param pulumi.Input[str] create_time: The time when the resource was created. The time is displayed in UTC in `yyyy-MM-ddTHH:mm:ssZ` format.
        :param pulumi.Input[bool] cross_zone_enabled: Specifies whether to enable cross-zone load balancing for the NLB instance.
        :param pulumi.Input[bool] deletion_protection_enabled: Specifies whether to enable deletion protection. Default value: `false`. Valid values:
        :param pulumi.Input[str] deletion_protection_reason: The reason why the deletion protection feature is enabled or disabled. The `deletion_protection_reason` takes effect only when `deletion_protection_enabled` is set to `true`.
        :param pulumi.Input[str] dns_name: The domain name of the NLB instance.
        :param pulumi.Input[str] ipv6_address_type: The type of IPv6 address used by the NLB instance.
        :param pulumi.Input[str] load_balancer_business_status: The business status of the NLB instance.
        :param pulumi.Input[str] load_balancer_name: The name of the NLB instance. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[str] load_balancer_type: The type of the instance. Set the value to `Network`, which specifies an NLB instance.
        :param pulumi.Input[str] modification_protection_reason: The reason why the configuration read-only mode is enabled. The `modification_protection_reason` takes effect only when `modification_protection_status` is set to `ConsoleProtection`.
        :param pulumi.Input[str] modification_protection_status: Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. Valid values:
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] status: The status of the NLB instance.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] vpc_id: The ID of the VPC where the NLB instance is deployed.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]] zone_mappings: Available Area Configuration List. You must add at least two zones. You can add a maximum of 10 zones. See `zone_mappings` below.
        """
        if address_ip_version is not None:
            pulumi.set(__self__, "address_ip_version", address_ip_version)
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if bandwidth_package_id is not None:
            pulumi.set(__self__, "bandwidth_package_id", bandwidth_package_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if cross_zone_enabled is not None:
            pulumi.set(__self__, "cross_zone_enabled", cross_zone_enabled)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if deletion_protection_reason is not None:
            pulumi.set(__self__, "deletion_protection_reason", deletion_protection_reason)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ipv6_address_type is not None:
            pulumi.set(__self__, "ipv6_address_type", ipv6_address_type)
        if load_balancer_business_status is not None:
            pulumi.set(__self__, "load_balancer_business_status", load_balancer_business_status)
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if modification_protection_reason is not None:
            pulumi.set(__self__, "modification_protection_reason", modification_protection_reason)
        if modification_protection_status is not None:
            pulumi.set(__self__, "modification_protection_status", modification_protection_status)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if zone_mappings is not None:
            pulumi.set(__self__, "zone_mappings", zone_mappings)

    @property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol version. Valid values:
        - ipv4 (default): IPv4
        - DualStack: dual stack
        """
        return pulumi.get(self, "address_ip_version")

    @address_ip_version.setter
    def address_ip_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_ip_version", value)

    @property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of IPv4 address used by the NLB instance. Valid values:
        - Internet: The NLB instance uses a public IP address. The domain name of the NLB instance is resolved to the public IP address. Therefore, the NLB instance can be accessed over the Internet.
        - Intranet: The NLB instance uses a private IP address. The domain name of the NLB instance is resolved to the private IP address. Therefore, the NLB instance can be accessed over the virtual private cloud (VPC) where the NLB instance is deployed.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_type", value)

    @property
    @pulumi.getter(name="bandwidthPackageId")
    def bandwidth_package_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the EIP bandwidth plan that is associated with the NLB instance if the NLB instance uses a public IP address.
        """
        return pulumi.get(self, "bandwidth_package_id")

    @bandwidth_package_id.setter
    def bandwidth_package_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth_package_id", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the resource was created. The time is displayed in UTC in `yyyy-MM-ddTHH:mm:ssZ` format.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="crossZoneEnabled")
    def cross_zone_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable cross-zone load balancing for the NLB instance.
        """
        return pulumi.get(self, "cross_zone_enabled")

    @cross_zone_enabled.setter
    def cross_zone_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cross_zone_enabled", value)

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable deletion protection. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @property
    @pulumi.getter(name="deletionProtectionReason")
    def deletion_protection_reason(self) -> Optional[pulumi.Input[str]]:
        """
        The reason why the deletion protection feature is enabled or disabled. The `deletion_protection_reason` takes effect only when `deletion_protection_enabled` is set to `true`.
        """
        return pulumi.get(self, "deletion_protection_reason")

    @deletion_protection_reason.setter
    def deletion_protection_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_protection_reason", value)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name of the NLB instance.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="ipv6AddressType")
    def ipv6_address_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of IPv6 address used by the NLB instance.
        """
        return pulumi.get(self, "ipv6_address_type")

    @ipv6_address_type.setter
    def ipv6_address_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_address_type", value)

    @property
    @pulumi.getter(name="loadBalancerBusinessStatus")
    def load_balancer_business_status(self) -> Optional[pulumi.Input[str]]:
        """
        The business status of the NLB instance.
        """
        return pulumi.get(self, "load_balancer_business_status")

    @load_balancer_business_status.setter
    def load_balancer_business_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_business_status", value)

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the NLB instance. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        """
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_name", value)

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the instance. Set the value to `Network`, which specifies an NLB instance.
        """
        return pulumi.get(self, "load_balancer_type")

    @load_balancer_type.setter
    def load_balancer_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_type", value)

    @property
    @pulumi.getter(name="modificationProtectionReason")
    def modification_protection_reason(self) -> Optional[pulumi.Input[str]]:
        """
        The reason why the configuration read-only mode is enabled. The `modification_protection_reason` takes effect only when `modification_protection_status` is set to `ConsoleProtection`.
        """
        return pulumi.get(self, "modification_protection_reason")

    @modification_protection_reason.setter
    def modification_protection_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modification_protection_reason", value)

    @property
    @pulumi.getter(name="modificationProtectionStatus")
    def modification_protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. Valid values:
        """
        return pulumi.get(self, "modification_protection_status")

    @modification_protection_status.setter
    def modification_protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modification_protection_status", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the NLB instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPC where the NLB instance is deployed.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="zoneMappings")
    def zone_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]]]:
        """
        Available Area Configuration List. You must add at least two zones. You can add a maximum of 10 zones. See `zone_mappings` below.
        """
        return pulumi.get(self, "zone_mappings")

    @zone_mappings.setter
    def zone_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]]]):
        pulumi.set(self, "zone_mappings", value)


class LoadBalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_ip_version: Optional[pulumi.Input[str]] = None,
                 address_type: Optional[pulumi.Input[str]] = None,
                 bandwidth_package_id: Optional[pulumi.Input[str]] = None,
                 cross_zone_enabled: Optional[pulumi.Input[bool]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 deletion_protection_reason: Optional[pulumi.Input[str]] = None,
                 load_balancer_name: Optional[pulumi.Input[str]] = None,
                 load_balancer_type: Optional[pulumi.Input[str]] = None,
                 modification_protection_reason: Optional[pulumi.Input[str]] = None,
                 modification_protection_status: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerZoneMappingArgs']]]]] = None,
                 __props__=None):
        """
        Provides a NLB Load Balancer resource.

        For information about NLB Load Balancer and how to use it, see [What is Load Balancer](https://www.alibabacloud.com/help/en/server-load-balancer/latest/createloadbalancer).

        > **NOTE:** Available since v1.191.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_resource_groups = alicloud.resourcemanager.get_resource_groups()
        default_zones = alicloud.nlb.get_zones()
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default1 = alicloud.vpc.Switch("default1",
            vswitch_name=name,
            cidr_block="10.4.1.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[1].id)
        default_load_balancer = alicloud.nlb.LoadBalancer("defaultLoadBalancer",
            load_balancer_name=name,
            resource_group_id=default_resource_groups.ids[0],
            load_balancer_type="Network",
            address_type="Internet",
            address_ip_version="Ipv4",
            vpc_id=default_network.id,
            tags={
                "Created": "TF",
                "For": "example",
            },
            zone_mappings=[
                alicloud.nlb.LoadBalancerZoneMappingArgs(
                    vswitch_id=default_switch.id,
                    zone_id=default_zones.zones[0].id,
                ),
                alicloud.nlb.LoadBalancerZoneMappingArgs(
                    vswitch_id=default1.id,
                    zone_id=default_zones.zones[1].id,
                ),
            ])
        ```

        ## Import

        NLB Load Balancer can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:nlb/loadBalancer:LoadBalancer example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address_ip_version: The protocol version. Valid values:
               - ipv4 (default): IPv4
               - DualStack: dual stack
        :param pulumi.Input[str] address_type: The type of IPv4 address used by the NLB instance. Valid values:
               - Internet: The NLB instance uses a public IP address. The domain name of the NLB instance is resolved to the public IP address. Therefore, the NLB instance can be accessed over the Internet.
               - Intranet: The NLB instance uses a private IP address. The domain name of the NLB instance is resolved to the private IP address. Therefore, the NLB instance can be accessed over the virtual private cloud (VPC) where the NLB instance is deployed.
        :param pulumi.Input[str] bandwidth_package_id: The ID of the EIP bandwidth plan that is associated with the NLB instance if the NLB instance uses a public IP address.
        :param pulumi.Input[bool] cross_zone_enabled: Specifies whether to enable cross-zone load balancing for the NLB instance.
        :param pulumi.Input[bool] deletion_protection_enabled: Specifies whether to enable deletion protection. Default value: `false`. Valid values:
        :param pulumi.Input[str] deletion_protection_reason: The reason why the deletion protection feature is enabled or disabled. The `deletion_protection_reason` takes effect only when `deletion_protection_enabled` is set to `true`.
        :param pulumi.Input[str] load_balancer_name: The name of the NLB instance. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[str] load_balancer_type: The type of the instance. Set the value to `Network`, which specifies an NLB instance.
        :param pulumi.Input[str] modification_protection_reason: The reason why the configuration read-only mode is enabled. The `modification_protection_reason` takes effect only when `modification_protection_status` is set to `ConsoleProtection`.
        :param pulumi.Input[str] modification_protection_status: Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. Valid values:
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] vpc_id: The ID of the VPC where the NLB instance is deployed.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerZoneMappingArgs']]]] zone_mappings: Available Area Configuration List. You must add at least two zones. You can add a maximum of 10 zones. See `zone_mappings` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a NLB Load Balancer resource.

        For information about NLB Load Balancer and how to use it, see [What is Load Balancer](https://www.alibabacloud.com/help/en/server-load-balancer/latest/createloadbalancer).

        > **NOTE:** Available since v1.191.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_resource_groups = alicloud.resourcemanager.get_resource_groups()
        default_zones = alicloud.nlb.get_zones()
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default1 = alicloud.vpc.Switch("default1",
            vswitch_name=name,
            cidr_block="10.4.1.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[1].id)
        default_load_balancer = alicloud.nlb.LoadBalancer("defaultLoadBalancer",
            load_balancer_name=name,
            resource_group_id=default_resource_groups.ids[0],
            load_balancer_type="Network",
            address_type="Internet",
            address_ip_version="Ipv4",
            vpc_id=default_network.id,
            tags={
                "Created": "TF",
                "For": "example",
            },
            zone_mappings=[
                alicloud.nlb.LoadBalancerZoneMappingArgs(
                    vswitch_id=default_switch.id,
                    zone_id=default_zones.zones[0].id,
                ),
                alicloud.nlb.LoadBalancerZoneMappingArgs(
                    vswitch_id=default1.id,
                    zone_id=default_zones.zones[1].id,
                ),
            ])
        ```

        ## Import

        NLB Load Balancer can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:nlb/loadBalancer:LoadBalancer example <id>
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_ip_version: Optional[pulumi.Input[str]] = None,
                 address_type: Optional[pulumi.Input[str]] = None,
                 bandwidth_package_id: Optional[pulumi.Input[str]] = None,
                 cross_zone_enabled: Optional[pulumi.Input[bool]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 deletion_protection_reason: Optional[pulumi.Input[str]] = None,
                 load_balancer_name: Optional[pulumi.Input[str]] = None,
                 load_balancer_type: Optional[pulumi.Input[str]] = None,
                 modification_protection_reason: Optional[pulumi.Input[str]] = None,
                 modification_protection_status: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerZoneMappingArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerArgs.__new__(LoadBalancerArgs)

            __props__.__dict__["address_ip_version"] = address_ip_version
            if address_type is None and not opts.urn:
                raise TypeError("Missing required property 'address_type'")
            __props__.__dict__["address_type"] = address_type
            __props__.__dict__["bandwidth_package_id"] = bandwidth_package_id
            __props__.__dict__["cross_zone_enabled"] = cross_zone_enabled
            __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
            __props__.__dict__["deletion_protection_reason"] = deletion_protection_reason
            __props__.__dict__["load_balancer_name"] = load_balancer_name
            __props__.__dict__["load_balancer_type"] = load_balancer_type
            __props__.__dict__["modification_protection_reason"] = modification_protection_reason
            __props__.__dict__["modification_protection_status"] = modification_protection_status
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if zone_mappings is None and not opts.urn:
                raise TypeError("Missing required property 'zone_mappings'")
            __props__.__dict__["zone_mappings"] = zone_mappings
            __props__.__dict__["create_time"] = None
            __props__.__dict__["dns_name"] = None
            __props__.__dict__["ipv6_address_type"] = None
            __props__.__dict__["load_balancer_business_status"] = None
            __props__.__dict__["status"] = None
        super(LoadBalancer, __self__).__init__(
            'alicloud:nlb/loadBalancer:LoadBalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_ip_version: Optional[pulumi.Input[str]] = None,
            address_type: Optional[pulumi.Input[str]] = None,
            bandwidth_package_id: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            cross_zone_enabled: Optional[pulumi.Input[bool]] = None,
            deletion_protection_enabled: Optional[pulumi.Input[bool]] = None,
            deletion_protection_reason: Optional[pulumi.Input[str]] = None,
            dns_name: Optional[pulumi.Input[str]] = None,
            ipv6_address_type: Optional[pulumi.Input[str]] = None,
            load_balancer_business_status: Optional[pulumi.Input[str]] = None,
            load_balancer_name: Optional[pulumi.Input[str]] = None,
            load_balancer_type: Optional[pulumi.Input[str]] = None,
            modification_protection_reason: Optional[pulumi.Input[str]] = None,
            modification_protection_status: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerZoneMappingArgs']]]]] = None) -> 'LoadBalancer':
        """
        Get an existing LoadBalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address_ip_version: The protocol version. Valid values:
               - ipv4 (default): IPv4
               - DualStack: dual stack
        :param pulumi.Input[str] address_type: The type of IPv4 address used by the NLB instance. Valid values:
               - Internet: The NLB instance uses a public IP address. The domain name of the NLB instance is resolved to the public IP address. Therefore, the NLB instance can be accessed over the Internet.
               - Intranet: The NLB instance uses a private IP address. The domain name of the NLB instance is resolved to the private IP address. Therefore, the NLB instance can be accessed over the virtual private cloud (VPC) where the NLB instance is deployed.
        :param pulumi.Input[str] bandwidth_package_id: The ID of the EIP bandwidth plan that is associated with the NLB instance if the NLB instance uses a public IP address.
        :param pulumi.Input[str] create_time: The time when the resource was created. The time is displayed in UTC in `yyyy-MM-ddTHH:mm:ssZ` format.
        :param pulumi.Input[bool] cross_zone_enabled: Specifies whether to enable cross-zone load balancing for the NLB instance.
        :param pulumi.Input[bool] deletion_protection_enabled: Specifies whether to enable deletion protection. Default value: `false`. Valid values:
        :param pulumi.Input[str] deletion_protection_reason: The reason why the deletion protection feature is enabled or disabled. The `deletion_protection_reason` takes effect only when `deletion_protection_enabled` is set to `true`.
        :param pulumi.Input[str] dns_name: The domain name of the NLB instance.
        :param pulumi.Input[str] ipv6_address_type: The type of IPv6 address used by the NLB instance.
        :param pulumi.Input[str] load_balancer_business_status: The business status of the NLB instance.
        :param pulumi.Input[str] load_balancer_name: The name of the NLB instance. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[str] load_balancer_type: The type of the instance. Set the value to `Network`, which specifies an NLB instance.
        :param pulumi.Input[str] modification_protection_reason: The reason why the configuration read-only mode is enabled. The `modification_protection_reason` takes effect only when `modification_protection_status` is set to `ConsoleProtection`.
        :param pulumi.Input[str] modification_protection_status: Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. Valid values:
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] status: The status of the NLB instance.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] vpc_id: The ID of the VPC where the NLB instance is deployed.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerZoneMappingArgs']]]] zone_mappings: Available Area Configuration List. You must add at least two zones. You can add a maximum of 10 zones. See `zone_mappings` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerState.__new__(_LoadBalancerState)

        __props__.__dict__["address_ip_version"] = address_ip_version
        __props__.__dict__["address_type"] = address_type
        __props__.__dict__["bandwidth_package_id"] = bandwidth_package_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["cross_zone_enabled"] = cross_zone_enabled
        __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
        __props__.__dict__["deletion_protection_reason"] = deletion_protection_reason
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["ipv6_address_type"] = ipv6_address_type
        __props__.__dict__["load_balancer_business_status"] = load_balancer_business_status
        __props__.__dict__["load_balancer_name"] = load_balancer_name
        __props__.__dict__["load_balancer_type"] = load_balancer_type
        __props__.__dict__["modification_protection_reason"] = modification_protection_reason
        __props__.__dict__["modification_protection_status"] = modification_protection_status
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["zone_mappings"] = zone_mappings
        return LoadBalancer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> pulumi.Output[str]:
        """
        The protocol version. Valid values:
        - ipv4 (default): IPv4
        - DualStack: dual stack
        """
        return pulumi.get(self, "address_ip_version")

    @property
    @pulumi.getter(name="addressType")
    def address_type(self) -> pulumi.Output[str]:
        """
        The type of IPv4 address used by the NLB instance. Valid values:
        - Internet: The NLB instance uses a public IP address. The domain name of the NLB instance is resolved to the public IP address. Therefore, the NLB instance can be accessed over the Internet.
        - Intranet: The NLB instance uses a private IP address. The domain name of the NLB instance is resolved to the private IP address. Therefore, the NLB instance can be accessed over the virtual private cloud (VPC) where the NLB instance is deployed.
        """
        return pulumi.get(self, "address_type")

    @property
    @pulumi.getter(name="bandwidthPackageId")
    def bandwidth_package_id(self) -> pulumi.Output[str]:
        """
        The ID of the EIP bandwidth plan that is associated with the NLB instance if the NLB instance uses a public IP address.
        """
        return pulumi.get(self, "bandwidth_package_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time when the resource was created. The time is displayed in UTC in `yyyy-MM-ddTHH:mm:ssZ` format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="crossZoneEnabled")
    def cross_zone_enabled(self) -> pulumi.Output[bool]:
        """
        Specifies whether to enable cross-zone load balancing for the NLB instance.
        """
        return pulumi.get(self, "cross_zone_enabled")

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> pulumi.Output[bool]:
        """
        Specifies whether to enable deletion protection. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @property
    @pulumi.getter(name="deletionProtectionReason")
    def deletion_protection_reason(self) -> pulumi.Output[str]:
        """
        The reason why the deletion protection feature is enabled or disabled. The `deletion_protection_reason` takes effect only when `deletion_protection_enabled` is set to `true`.
        """
        return pulumi.get(self, "deletion_protection_reason")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[str]:
        """
        The domain name of the NLB instance.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ipv6AddressType")
    def ipv6_address_type(self) -> pulumi.Output[str]:
        """
        The type of IPv6 address used by the NLB instance.
        """
        return pulumi.get(self, "ipv6_address_type")

    @property
    @pulumi.getter(name="loadBalancerBusinessStatus")
    def load_balancer_business_status(self) -> pulumi.Output[str]:
        """
        The business status of the NLB instance.
        """
        return pulumi.get(self, "load_balancer_business_status")

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> pulumi.Output[str]:
        """
        The name of the NLB instance. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        """
        return pulumi.get(self, "load_balancer_name")

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> pulumi.Output[str]:
        """
        The type of the instance. Set the value to `Network`, which specifies an NLB instance.
        """
        return pulumi.get(self, "load_balancer_type")

    @property
    @pulumi.getter(name="modificationProtectionReason")
    def modification_protection_reason(self) -> pulumi.Output[str]:
        """
        The reason why the configuration read-only mode is enabled. The `modification_protection_reason` takes effect only when `modification_protection_status` is set to `ConsoleProtection`.
        """
        return pulumi.get(self, "modification_protection_reason")

    @property
    @pulumi.getter(name="modificationProtectionStatus")
    def modification_protection_status(self) -> pulumi.Output[str]:
        """
        Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. Valid values:
        """
        return pulumi.get(self, "modification_protection_status")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the NLB instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The ID of the VPC where the NLB instance is deployed.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="zoneMappings")
    def zone_mappings(self) -> pulumi.Output[Sequence['outputs.LoadBalancerZoneMapping']]:
        """
        Available Area Configuration List. You must add at least two zones. You can add a maximum of 10 zones. See `zone_mappings` below.
        """
        return pulumi.get(self, "zone_mappings")

