# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'LoadBalancerZoneMapping',
    'ServerGroupHealthCheck',
    'GetListenersListenerResult',
    'GetLoadBalancersBalancerResult',
    'GetLoadBalancersBalancerOperationLockResult',
    'GetLoadBalancersBalancerZoneMappingResult',
    'GetSecurityPoliciesPolicyResult',
    'GetServerGroupServerAttachmentsAttachmentResult',
    'GetServerGroupsGroupResult',
    'GetServerGroupsGroupHealthCheckResult',
    'GetZonesZoneResult',
]

@pulumi.output_type
class LoadBalancerZoneMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vswitchId":
            suggest = "vswitch_id"
        elif key == "zoneId":
            suggest = "zone_id"
        elif key == "allocationId":
            suggest = "allocation_id"
        elif key == "eniId":
            suggest = "eni_id"
        elif key == "ipv6Address":
            suggest = "ipv6_address"
        elif key == "privateIpv4Address":
            suggest = "private_ipv4_address"
        elif key == "publicIpv4Address":
            suggest = "public_ipv4_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerZoneMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerZoneMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerZoneMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vswitch_id: str,
                 zone_id: str,
                 allocation_id: Optional[str] = None,
                 eni_id: Optional[str] = None,
                 ipv6_address: Optional[str] = None,
                 private_ipv4_address: Optional[str] = None,
                 public_ipv4_address: Optional[str] = None):
        """
        :param str vswitch_id: The vSwitch in the zone. You can specify only one vSwitch (subnet) in each zone of an NLB instance.
        :param str zone_id: The ID of the zone of the NLB instance.
        :param str allocation_id: The ID of the EIP associated with the Internet-facing NLB instance.
        :param str eni_id: The ID of the elastic network interface (ENI).
        :param str ipv6_address: The IPv6 address of the NLB instance.
        :param str private_ipv4_address: The private IPv4 address of the NLB instance.
        :param str public_ipv4_address: The public IPv4 address of the NLB instance.
        """
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if allocation_id is not None:
            pulumi.set(__self__, "allocation_id", allocation_id)
        if eni_id is not None:
            pulumi.set(__self__, "eni_id", eni_id)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if private_ipv4_address is not None:
            pulumi.set(__self__, "private_ipv4_address", private_ipv4_address)
        if public_ipv4_address is not None:
            pulumi.set(__self__, "public_ipv4_address", public_ipv4_address)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The vSwitch in the zone. You can specify only one vSwitch (subnet) in each zone of an NLB instance.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The ID of the zone of the NLB instance.
        """
        return pulumi.get(self, "zone_id")

    @property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> Optional[str]:
        """
        The ID of the EIP associated with the Internet-facing NLB instance.
        """
        return pulumi.get(self, "allocation_id")

    @property
    @pulumi.getter(name="eniId")
    def eni_id(self) -> Optional[str]:
        """
        The ID of the elastic network interface (ENI).
        """
        return pulumi.get(self, "eni_id")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[str]:
        """
        The IPv6 address of the NLB instance.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="privateIpv4Address")
    def private_ipv4_address(self) -> Optional[str]:
        """
        The private IPv4 address of the NLB instance.
        """
        return pulumi.get(self, "private_ipv4_address")

    @property
    @pulumi.getter(name="publicIpv4Address")
    def public_ipv4_address(self) -> Optional[str]:
        """
        The public IPv4 address of the NLB instance.
        """
        return pulumi.get(self, "public_ipv4_address")


@pulumi.output_type
class ServerGroupHealthCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheckConnectPort":
            suggest = "health_check_connect_port"
        elif key == "healthCheckConnectTimeout":
            suggest = "health_check_connect_timeout"
        elif key == "healthCheckDomain":
            suggest = "health_check_domain"
        elif key == "healthCheckEnabled":
            suggest = "health_check_enabled"
        elif key == "healthCheckHttpCodes":
            suggest = "health_check_http_codes"
        elif key == "healthCheckInterval":
            suggest = "health_check_interval"
        elif key == "healthCheckType":
            suggest = "health_check_type"
        elif key == "healthCheckUrl":
            suggest = "health_check_url"
        elif key == "healthyThreshold":
            suggest = "healthy_threshold"
        elif key == "httpCheckMethod":
            suggest = "http_check_method"
        elif key == "unhealthyThreshold":
            suggest = "unhealthy_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerGroupHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerGroupHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerGroupHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_check_connect_port: Optional[int] = None,
                 health_check_connect_timeout: Optional[int] = None,
                 health_check_domain: Optional[str] = None,
                 health_check_enabled: Optional[bool] = None,
                 health_check_http_codes: Optional[Sequence[str]] = None,
                 health_check_interval: Optional[int] = None,
                 health_check_type: Optional[str] = None,
                 health_check_url: Optional[str] = None,
                 healthy_threshold: Optional[int] = None,
                 http_check_method: Optional[str] = None,
                 unhealthy_threshold: Optional[int] = None):
        """
        :param int health_check_connect_port: The backend port that is used for health checks. Valid values: 0 to 65535. Default value: 0. If you set the value to 0, the port of a backend server is used for health checks.
        :param int health_check_connect_timeout: The maximum timeout period of a health check response. Unit: seconds. Valid values: 1 to 300. Default value: 5.
        :param str health_check_domain: The domain name that is used for health checks. Valid values:
               - `$SERVER_IP`: the private IP address of a backend server.
        :param bool health_check_enabled: Specifies whether to enable health checks.
        :param Sequence[str] health_check_http_codes: The HTTP status codes to return to health checks. Separate multiple HTTP status codes with commas (,). Valid values: http_2xx (default), http_3xx, http_4xx, and http_5xx. **Note:** This parameter takes effect only if `health_check_type` is set to `http`.
        :param int health_check_interval: The interval between two consecutive health checks. Unit: seconds. Valid values: 5 to 5000. Default value: 10.
        :param str health_check_type: The protocol that is used for health checks. Valid values: `TCP` (default) and `HTTP`.
        :param str health_check_url: The path to which health check requests are sent. The path must be 1 to 80 characters in length, and can contain only letters, digits, and the following special characters: `- / . % ? # & =`. It can also contain the following extended characters: `_ ; ~ ! ( ) * [ ] @ $ ^ : ' , +`. The path must start with a forward slash (/). **Note:** This parameter takes effect only if `health_check_type` is set to `http`.
        :param int healthy_threshold: The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy. In this case, the health status is changed from fail to success. Valid values: 2 to 10. Default value: 2.
        :param str http_check_method: The HTTP method that is used for health checks. Valid values: `GET` and `HEAD`. **Note:** This parameter takes effect only if `health_check_type` is set to `http`.
        :param int unhealthy_threshold: The number of times that a healthy backend server must consecutively fail health checks before it is declared unhealthy. In this case, the health status is changed from success to fail. Valid values: 2 to 10. Default value: 2.
        """
        if health_check_connect_port is not None:
            pulumi.set(__self__, "health_check_connect_port", health_check_connect_port)
        if health_check_connect_timeout is not None:
            pulumi.set(__self__, "health_check_connect_timeout", health_check_connect_timeout)
        if health_check_domain is not None:
            pulumi.set(__self__, "health_check_domain", health_check_domain)
        if health_check_enabled is not None:
            pulumi.set(__self__, "health_check_enabled", health_check_enabled)
        if health_check_http_codes is not None:
            pulumi.set(__self__, "health_check_http_codes", health_check_http_codes)
        if health_check_interval is not None:
            pulumi.set(__self__, "health_check_interval", health_check_interval)
        if health_check_type is not None:
            pulumi.set(__self__, "health_check_type", health_check_type)
        if health_check_url is not None:
            pulumi.set(__self__, "health_check_url", health_check_url)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if http_check_method is not None:
            pulumi.set(__self__, "http_check_method", http_check_method)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter(name="healthCheckConnectPort")
    def health_check_connect_port(self) -> Optional[int]:
        """
        The backend port that is used for health checks. Valid values: 0 to 65535. Default value: 0. If you set the value to 0, the port of a backend server is used for health checks.
        """
        return pulumi.get(self, "health_check_connect_port")

    @property
    @pulumi.getter(name="healthCheckConnectTimeout")
    def health_check_connect_timeout(self) -> Optional[int]:
        """
        The maximum timeout period of a health check response. Unit: seconds. Valid values: 1 to 300. Default value: 5.
        """
        return pulumi.get(self, "health_check_connect_timeout")

    @property
    @pulumi.getter(name="healthCheckDomain")
    def health_check_domain(self) -> Optional[str]:
        """
        The domain name that is used for health checks. Valid values:
        - `$SERVER_IP`: the private IP address of a backend server.
        """
        return pulumi.get(self, "health_check_domain")

    @property
    @pulumi.getter(name="healthCheckEnabled")
    def health_check_enabled(self) -> Optional[bool]:
        """
        Specifies whether to enable health checks.
        """
        return pulumi.get(self, "health_check_enabled")

    @property
    @pulumi.getter(name="healthCheckHttpCodes")
    def health_check_http_codes(self) -> Optional[Sequence[str]]:
        """
        The HTTP status codes to return to health checks. Separate multiple HTTP status codes with commas (,). Valid values: http_2xx (default), http_3xx, http_4xx, and http_5xx. **Note:** This parameter takes effect only if `health_check_type` is set to `http`.
        """
        return pulumi.get(self, "health_check_http_codes")

    @property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> Optional[int]:
        """
        The interval between two consecutive health checks. Unit: seconds. Valid values: 5 to 5000. Default value: 10.
        """
        return pulumi.get(self, "health_check_interval")

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> Optional[str]:
        """
        The protocol that is used for health checks. Valid values: `TCP` (default) and `HTTP`.
        """
        return pulumi.get(self, "health_check_type")

    @property
    @pulumi.getter(name="healthCheckUrl")
    def health_check_url(self) -> Optional[str]:
        """
        The path to which health check requests are sent. The path must be 1 to 80 characters in length, and can contain only letters, digits, and the following special characters: `- / . % ? # & =`. It can also contain the following extended characters: `_ ; ~ ! ( ) * [ ] @ $ ^ : ' , +`. The path must start with a forward slash (/). **Note:** This parameter takes effect only if `health_check_type` is set to `http`.
        """
        return pulumi.get(self, "health_check_url")

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[int]:
        """
        The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy. In this case, the health status is changed from fail to success. Valid values: 2 to 10. Default value: 2.
        """
        return pulumi.get(self, "healthy_threshold")

    @property
    @pulumi.getter(name="httpCheckMethod")
    def http_check_method(self) -> Optional[str]:
        """
        The HTTP method that is used for health checks. Valid values: `GET` and `HEAD`. **Note:** This parameter takes effect only if `health_check_type` is set to `http`.
        """
        return pulumi.get(self, "http_check_method")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[int]:
        """
        The number of times that a healthy backend server must consecutively fail health checks before it is declared unhealthy. In this case, the health status is changed from success to fail. Valid values: 2 to 10. Default value: 2.
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class GetListenersListenerResult(dict):
    def __init__(__self__, *,
                 alpn_enabled: bool,
                 alpn_policy: str,
                 ca_certificate_ids: Sequence[str],
                 ca_enabled: bool,
                 certificate_ids: Sequence[str],
                 cps: int,
                 end_port: str,
                 id: str,
                 idle_timeout: int,
                 listener_description: str,
                 listener_id: str,
                 listener_port: int,
                 listener_protocol: str,
                 load_balancer_id: str,
                 mss: int,
                 proxy_protocol_enabled: bool,
                 sec_sensor_enabled: bool,
                 security_policy_id: str,
                 server_group_id: str,
                 start_port: str,
                 status: str):
        """
        :param bool alpn_enabled: ndicates whether Application-Layer Protocol Negotiation (ALPN) is enabled.
        :param str alpn_policy: The ALPN policy.
        :param Sequence[str] ca_certificate_ids: CA certificate list information. Currently, only one CA certificate can be added. **NOTE:** This parameter only takes effect for `TCPSSL` listeners.
        :param bool ca_enabled: Whether to start two-way authentication.
        :param Sequence[str] certificate_ids: Server certificate list information. Currently, only one server certificate can be added. This parameter only takes effect for `TCPSSL` listeners.
        :param int cps: The new connection speed limit for a network-based load balancing instance per second. Valid values: `0` ~ `1000000`. `0` indicates unlimited speed.
        :param str end_port: Full port listening end port. Valid values: `0` ~ `65535`. The value of the end port is less than the start port.
        :param str id: The ID of the Nlb Listener.
        :param int idle_timeout: Connection idle timeout time. Unit: seconds. Valid values: `1` ~ `900`.
        :param str listener_description: Custom listener name. The length is limited to 2 to 256 characters, supports Chinese and English letters, and can include numbers, commas (,), half-width periods (.), half-width semicolons (;), forward slashes (/), at(@), underscores (_), and dashes (-).
        :param str listener_id: The ID of the listener.
        :param int listener_port: Listening port. Valid values: `0` ~ `65535`. `0`: indicates that full port listening is used. When set to 0, you must configure `StartPort` and `EndPort`.
        :param str listener_protocol: The listening protocol. Valid values: `TCP`, `UDP`, or `TCPSSL`.
        :param str load_balancer_id: The ID of the network-based server load balancer instance.
        :param int mss: The maximum segment size of the TCP message. Unit: Bytes. Valid values: `0` ~ `1500`. `0` indicates that the MSS value of the TCP message is not modified. only `TCP` and `TCPSSL` listeners support this field value.
        :param bool proxy_protocol_enabled: Whether to enable the Proxy Protocol to carry the source address of the client to the backend server.
        :param bool sec_sensor_enabled: Indicates whether fine-grained monitoring is enabled.
        :param str security_policy_id: Security policy ID. Support system security policies and custom security policies. Valid values: `tls_cipher_policy_1_0`, `tls_cipher_policy_1_1`, `tls_cipher_policy_1_2`, `tls_cipher_policy_1_2_strict`, or `tls_cipher_policy_1_2_strict_with_1_3`. **Note:** This parameter only takes effect for `TCPSSL` listeners.
        :param str server_group_id: The ID of the server group.
        :param str start_port: Full Port listens to the starting port. Valid values: `0` ~ `65535`.
        :param str status: The status of the resource.
        """
        pulumi.set(__self__, "alpn_enabled", alpn_enabled)
        pulumi.set(__self__, "alpn_policy", alpn_policy)
        pulumi.set(__self__, "ca_certificate_ids", ca_certificate_ids)
        pulumi.set(__self__, "ca_enabled", ca_enabled)
        pulumi.set(__self__, "certificate_ids", certificate_ids)
        pulumi.set(__self__, "cps", cps)
        pulumi.set(__self__, "end_port", end_port)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "idle_timeout", idle_timeout)
        pulumi.set(__self__, "listener_description", listener_description)
        pulumi.set(__self__, "listener_id", listener_id)
        pulumi.set(__self__, "listener_port", listener_port)
        pulumi.set(__self__, "listener_protocol", listener_protocol)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "mss", mss)
        pulumi.set(__self__, "proxy_protocol_enabled", proxy_protocol_enabled)
        pulumi.set(__self__, "sec_sensor_enabled", sec_sensor_enabled)
        pulumi.set(__self__, "security_policy_id", security_policy_id)
        pulumi.set(__self__, "server_group_id", server_group_id)
        pulumi.set(__self__, "start_port", start_port)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="alpnEnabled")
    def alpn_enabled(self) -> bool:
        """
        ndicates whether Application-Layer Protocol Negotiation (ALPN) is enabled.
        """
        return pulumi.get(self, "alpn_enabled")

    @property
    @pulumi.getter(name="alpnPolicy")
    def alpn_policy(self) -> str:
        """
        The ALPN policy.
        """
        return pulumi.get(self, "alpn_policy")

    @property
    @pulumi.getter(name="caCertificateIds")
    def ca_certificate_ids(self) -> Sequence[str]:
        """
        CA certificate list information. Currently, only one CA certificate can be added. **NOTE:** This parameter only takes effect for `TCPSSL` listeners.
        """
        return pulumi.get(self, "ca_certificate_ids")

    @property
    @pulumi.getter(name="caEnabled")
    def ca_enabled(self) -> bool:
        """
        Whether to start two-way authentication.
        """
        return pulumi.get(self, "ca_enabled")

    @property
    @pulumi.getter(name="certificateIds")
    def certificate_ids(self) -> Sequence[str]:
        """
        Server certificate list information. Currently, only one server certificate can be added. This parameter only takes effect for `TCPSSL` listeners.
        """
        return pulumi.get(self, "certificate_ids")

    @property
    @pulumi.getter
    def cps(self) -> int:
        """
        The new connection speed limit for a network-based load balancing instance per second. Valid values: `0` ~ `1000000`. `0` indicates unlimited speed.
        """
        return pulumi.get(self, "cps")

    @property
    @pulumi.getter(name="endPort")
    def end_port(self) -> str:
        """
        Full port listening end port. Valid values: `0` ~ `65535`. The value of the end port is less than the start port.
        """
        return pulumi.get(self, "end_port")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Nlb Listener.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> int:
        """
        Connection idle timeout time. Unit: seconds. Valid values: `1` ~ `900`.
        """
        return pulumi.get(self, "idle_timeout")

    @property
    @pulumi.getter(name="listenerDescription")
    def listener_description(self) -> str:
        """
        Custom listener name. The length is limited to 2 to 256 characters, supports Chinese and English letters, and can include numbers, commas (,), half-width periods (.), half-width semicolons (;), forward slashes (/), at(@), underscores (_), and dashes (-).
        """
        return pulumi.get(self, "listener_description")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> str:
        """
        The ID of the listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> int:
        """
        Listening port. Valid values: `0` ~ `65535`. `0`: indicates that full port listening is used. When set to 0, you must configure `StartPort` and `EndPort`.
        """
        return pulumi.get(self, "listener_port")

    @property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> str:
        """
        The listening protocol. Valid values: `TCP`, `UDP`, or `TCPSSL`.
        """
        return pulumi.get(self, "listener_protocol")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> str:
        """
        The ID of the network-based server load balancer instance.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter
    def mss(self) -> int:
        """
        The maximum segment size of the TCP message. Unit: Bytes. Valid values: `0` ~ `1500`. `0` indicates that the MSS value of the TCP message is not modified. only `TCP` and `TCPSSL` listeners support this field value.
        """
        return pulumi.get(self, "mss")

    @property
    @pulumi.getter(name="proxyProtocolEnabled")
    def proxy_protocol_enabled(self) -> bool:
        """
        Whether to enable the Proxy Protocol to carry the source address of the client to the backend server.
        """
        return pulumi.get(self, "proxy_protocol_enabled")

    @property
    @pulumi.getter(name="secSensorEnabled")
    def sec_sensor_enabled(self) -> bool:
        """
        Indicates whether fine-grained monitoring is enabled.
        """
        return pulumi.get(self, "sec_sensor_enabled")

    @property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> str:
        """
        Security policy ID. Support system security policies and custom security policies. Valid values: `tls_cipher_policy_1_0`, `tls_cipher_policy_1_1`, `tls_cipher_policy_1_2`, `tls_cipher_policy_1_2_strict`, or `tls_cipher_policy_1_2_strict_with_1_3`. **Note:** This parameter only takes effect for `TCPSSL` listeners.
        """
        return pulumi.get(self, "security_policy_id")

    @property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> str:
        """
        The ID of the server group.
        """
        return pulumi.get(self, "server_group_id")

    @property
    @pulumi.getter(name="startPort")
    def start_port(self) -> str:
        """
        Full Port listens to the starting port. Valid values: `0` ~ `65535`.
        """
        return pulumi.get(self, "start_port")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetLoadBalancersBalancerResult(dict):
    def __init__(__self__, *,
                 address_ip_version: str,
                 address_type: str,
                 bandwidth_package_id: str,
                 create_time: str,
                 cross_zone_enabled: bool,
                 dns_name: str,
                 id: str,
                 ipv6_address_type: str,
                 load_balancer_business_status: str,
                 load_balancer_id: str,
                 load_balancer_name: str,
                 load_balancer_type: str,
                 operation_locks: Sequence['outputs.GetLoadBalancersBalancerOperationLockResult'],
                 resource_group_id: str,
                 security_group_ids: Sequence[str],
                 status: str,
                 vpc_id: str,
                 zone_mappings: Sequence['outputs.GetLoadBalancersBalancerZoneMappingResult'],
                 tags: Optional[Mapping[str, Any]] = None):
        """
        :param str address_ip_version: The IP version.
        :param str address_type: The type of IPv4 address used by the NLB instance.
        :param str bandwidth_package_id: The ID of the EIP bandwidth plan that is associated with the NLB instance if the NLB instance uses a public IP address.
        :param str create_time: The time when the resource was created. The time is displayed in UTC in `yyyy-MM-ddTHH:mm:ssZ` format.
        :param bool cross_zone_enabled: Indicates whether cross-zone load balancing is enabled for the NLB instance.
        :param str dns_name: The domain name of the NLB instance.
        :param str id: The ID of the NLB instance.
        :param str ipv6_address_type: The type of IPv6 address used by the NLB instance.
        :param str load_balancer_business_status: The business status of the NLB instance.
        :param str load_balancer_id: The ID of the NLB instance.
        :param str load_balancer_name: The name of the NLB instance.
        :param str load_balancer_type: The type of the SLB instance. Only Network is supported, which indicates NLB.
        :param Sequence['GetLoadBalancersBalancerOperationLockArgs'] operation_locks: The configuration of the operation lock. This parameter takes effect if LoadBalancerBussinessStatus is Abnormal.
        :param str resource_group_id: The ID of the resource group.
        :param Sequence[str] security_group_ids: The security group to which the NLB instance belongs.
        :param str status: The status of the NLB instance.
        :param str vpc_id: The ID of the VPC where the NLB instance is deployed.
        :param Sequence['GetLoadBalancersBalancerZoneMappingArgs'] zone_mappings: The zones and the vSwitches in the zones. An NLB instance can be deployed across 2 to 10 zones.
        :param Mapping[str, Any] tags: The tag of the resource.
        """
        pulumi.set(__self__, "address_ip_version", address_ip_version)
        pulumi.set(__self__, "address_type", address_type)
        pulumi.set(__self__, "bandwidth_package_id", bandwidth_package_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "cross_zone_enabled", cross_zone_enabled)
        pulumi.set(__self__, "dns_name", dns_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipv6_address_type", ipv6_address_type)
        pulumi.set(__self__, "load_balancer_business_status", load_balancer_business_status)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        pulumi.set(__self__, "operation_locks", operation_locks)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "zone_mappings", zone_mappings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> str:
        """
        The IP version.
        """
        return pulumi.get(self, "address_ip_version")

    @property
    @pulumi.getter(name="addressType")
    def address_type(self) -> str:
        """
        The type of IPv4 address used by the NLB instance.
        """
        return pulumi.get(self, "address_type")

    @property
    @pulumi.getter(name="bandwidthPackageId")
    def bandwidth_package_id(self) -> str:
        """
        The ID of the EIP bandwidth plan that is associated with the NLB instance if the NLB instance uses a public IP address.
        """
        return pulumi.get(self, "bandwidth_package_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the resource was created. The time is displayed in UTC in `yyyy-MM-ddTHH:mm:ssZ` format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="crossZoneEnabled")
    def cross_zone_enabled(self) -> bool:
        """
        Indicates whether cross-zone load balancing is enabled for the NLB instance.
        """
        return pulumi.get(self, "cross_zone_enabled")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> str:
        """
        The domain name of the NLB instance.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the NLB instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipv6AddressType")
    def ipv6_address_type(self) -> str:
        """
        The type of IPv6 address used by the NLB instance.
        """
        return pulumi.get(self, "ipv6_address_type")

    @property
    @pulumi.getter(name="loadBalancerBusinessStatus")
    def load_balancer_business_status(self) -> str:
        """
        The business status of the NLB instance.
        """
        return pulumi.get(self, "load_balancer_business_status")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> str:
        """
        The ID of the NLB instance.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> str:
        """
        The name of the NLB instance.
        """
        return pulumi.get(self, "load_balancer_name")

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> str:
        """
        The type of the SLB instance. Only Network is supported, which indicates NLB.
        """
        return pulumi.get(self, "load_balancer_type")

    @property
    @pulumi.getter(name="operationLocks")
    def operation_locks(self) -> Sequence['outputs.GetLoadBalancersBalancerOperationLockResult']:
        """
        The configuration of the operation lock. This parameter takes effect if LoadBalancerBussinessStatus is Abnormal.
        """
        return pulumi.get(self, "operation_locks")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        The security group to which the NLB instance belongs.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the NLB instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the VPC where the NLB instance is deployed.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="zoneMappings")
    def zone_mappings(self) -> Sequence['outputs.GetLoadBalancersBalancerZoneMappingResult']:
        """
        The zones and the vSwitches in the zones. An NLB instance can be deployed across 2 to 10 zones.
        """
        return pulumi.get(self, "zone_mappings")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, Any]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetLoadBalancersBalancerOperationLockResult(dict):
    def __init__(__self__, *,
                 lock_reason: str,
                 lock_type: str):
        """
        :param str lock_reason: The reason why the NLB instance is locked.
        :param str lock_type: The type of lock.
        """
        pulumi.set(__self__, "lock_reason", lock_reason)
        pulumi.set(__self__, "lock_type", lock_type)

    @property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> str:
        """
        The reason why the NLB instance is locked.
        """
        return pulumi.get(self, "lock_reason")

    @property
    @pulumi.getter(name="lockType")
    def lock_type(self) -> str:
        """
        The type of lock.
        """
        return pulumi.get(self, "lock_type")


@pulumi.output_type
class GetLoadBalancersBalancerZoneMappingResult(dict):
    def __init__(__self__, *,
                 allocation_id: str,
                 eni_id: str,
                 ipv6_address: str,
                 private_ipv4_address: str,
                 public_ipv4_address: str,
                 vswitch_id: str,
                 zone_id: str):
        """
        :param str allocation_id: The ID of the elastic IP address (EIP).
        :param str eni_id: The ID of the elastic network interface (ENI) attached to the NLB instance.
        :param str ipv6_address: The IPv6 address of the NLB instance.
        :param str private_ipv4_address: The private IPv4 address used by the NLB instance.
        :param str public_ipv4_address: The public IPv4 address used by the NLB instance.
        :param str vswitch_id: The ID of the vSwitch. By default, you can specify one vSwitch (subnet) in each zone of the NLB instance.
        :param str zone_id: The name of the zone.
        """
        pulumi.set(__self__, "allocation_id", allocation_id)
        pulumi.set(__self__, "eni_id", eni_id)
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        pulumi.set(__self__, "private_ipv4_address", private_ipv4_address)
        pulumi.set(__self__, "public_ipv4_address", public_ipv4_address)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> str:
        """
        The ID of the elastic IP address (EIP).
        """
        return pulumi.get(self, "allocation_id")

    @property
    @pulumi.getter(name="eniId")
    def eni_id(self) -> str:
        """
        The ID of the elastic network interface (ENI) attached to the NLB instance.
        """
        return pulumi.get(self, "eni_id")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> str:
        """
        The IPv6 address of the NLB instance.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="privateIpv4Address")
    def private_ipv4_address(self) -> str:
        """
        The private IPv4 address used by the NLB instance.
        """
        return pulumi.get(self, "private_ipv4_address")

    @property
    @pulumi.getter(name="publicIpv4Address")
    def public_ipv4_address(self) -> str:
        """
        The public IPv4 address used by the NLB instance.
        """
        return pulumi.get(self, "public_ipv4_address")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The ID of the vSwitch. By default, you can specify one vSwitch (subnet) in each zone of the NLB instance.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The name of the zone.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetSecurityPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 ciphers: Sequence[str],
                 id: str,
                 resource_group_id: str,
                 security_policy_name: str,
                 status: str,
                 tags: Mapping[str, Any],
                 tls_versions: Sequence[str]):
        """
        :param Sequence[str] ciphers: The supported cipher suites, which are determined by the TLS protocol version.
        :param str id: The id of the TLS security policy.
        :param str resource_group_id: The ID of the resource group.
        :param str security_policy_name: The name of the TLS security policy.
        :param str status: The status of the resource.
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        :param Sequence[str] tls_versions: The TLS protocol versions that are supported.
        """
        pulumi.set(__self__, "ciphers", ciphers)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "security_policy_name", security_policy_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "tls_versions", tls_versions)

    @property
    @pulumi.getter
    def ciphers(self) -> Sequence[str]:
        """
        The supported cipher suites, which are determined by the TLS protocol version.
        """
        return pulumi.get(self, "ciphers")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the TLS security policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="securityPolicyName")
    def security_policy_name(self) -> str:
        """
        The name of the TLS security policy.
        """
        return pulumi.get(self, "security_policy_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tlsVersions")
    def tls_versions(self) -> Sequence[str]:
        """
        The TLS protocol versions that are supported.
        """
        return pulumi.get(self, "tls_versions")


@pulumi.output_type
class GetServerGroupServerAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 description: str,
                 id: str,
                 port: int,
                 server_group_id: str,
                 server_id: str,
                 server_ip: str,
                 server_type: str,
                 status: str,
                 weight: int,
                 zone_id: str):
        """
        :param str description: The description of the backend server.
        :param str id: The ID of the server group.
        :param int port: The port used by the backend server.
        :param str server_group_id: The ID of the server group.
        :param str server_id: The ID of the server.
        :param str server_ip: The IP address of the backend server.
        :param str server_type: The type of the backend server.
        :param str status: Indicates the status of the backend server.
        :param int weight: The weight of the backend server.
        :param str zone_id: The zone ID of the server.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_group_id", server_group_id)
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "server_ip", server_ip)
        pulumi.set(__self__, "server_type", server_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "weight", weight)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the backend server.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the server group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port used by the backend server.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> str:
        """
        The ID of the server group.
        """
        return pulumi.get(self, "server_group_id")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter(name="serverIp")
    def server_ip(self) -> str:
        """
        The IP address of the backend server.
        """
        return pulumi.get(self, "server_ip")

    @property
    @pulumi.getter(name="serverType")
    def server_type(self) -> str:
        """
        The type of the backend server.
        """
        return pulumi.get(self, "server_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates the status of the backend server.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        The weight of the backend server.
        """
        return pulumi.get(self, "weight")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The zone ID of the server.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetServerGroupsGroupResult(dict):
    def __init__(__self__, *,
                 address_ip_version: str,
                 connection_drain: bool,
                 connection_drain_timeout: int,
                 health_checks: Sequence['outputs.GetServerGroupsGroupHealthCheckResult'],
                 id: str,
                 preserve_client_ip_enabled: bool,
                 protocol: str,
                 related_load_balancer_ids: Sequence[str],
                 resource_group_id: str,
                 scheduler: str,
                 server_count: int,
                 server_group_name: str,
                 server_group_type: str,
                 status: str,
                 tags: Mapping[str, Any],
                 vpc_id: str):
        """
        :param str address_ip_version: The protocol version.
        :param bool connection_drain: Indicates whether connection draining is enabled.
        :param int connection_drain_timeout: The timeout period of connection draining. Unit: seconds.
        :param Sequence['GetServerGroupsGroupHealthCheckArgs'] health_checks: The configurations of health checks.
        :param str id: The ID of the Server Group.
        :param bool preserve_client_ip_enabled: Indicates whether client address retention is enabled.
        :param str protocol: The protocol used to forward requests to the backend servers.
        :param Sequence[str] related_load_balancer_ids: The NLB instance.
        :param str resource_group_id: The ID of the resource group to which the security group belongs.
        :param str scheduler: The routing algorithm.
        :param int server_count: The number of server groups associated with the NLB instance.
        :param str server_group_name: The name of the server group.
        :param str server_group_type: The type of the server group.
        :param str status: The status of the server group.
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        :param str vpc_id: The ID of the VPC to which the server group belongs.
        """
        pulumi.set(__self__, "address_ip_version", address_ip_version)
        pulumi.set(__self__, "connection_drain", connection_drain)
        pulumi.set(__self__, "connection_drain_timeout", connection_drain_timeout)
        pulumi.set(__self__, "health_checks", health_checks)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "preserve_client_ip_enabled", preserve_client_ip_enabled)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "related_load_balancer_ids", related_load_balancer_ids)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "scheduler", scheduler)
        pulumi.set(__self__, "server_count", server_count)
        pulumi.set(__self__, "server_group_name", server_group_name)
        pulumi.set(__self__, "server_group_type", server_group_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> str:
        """
        The protocol version.
        """
        return pulumi.get(self, "address_ip_version")

    @property
    @pulumi.getter(name="connectionDrain")
    def connection_drain(self) -> bool:
        """
        Indicates whether connection draining is enabled.
        """
        return pulumi.get(self, "connection_drain")

    @property
    @pulumi.getter(name="connectionDrainTimeout")
    def connection_drain_timeout(self) -> int:
        """
        The timeout period of connection draining. Unit: seconds.
        """
        return pulumi.get(self, "connection_drain_timeout")

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Sequence['outputs.GetServerGroupsGroupHealthCheckResult']:
        """
        The configurations of health checks.
        """
        return pulumi.get(self, "health_checks")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Server Group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="preserveClientIpEnabled")
    def preserve_client_ip_enabled(self) -> bool:
        """
        Indicates whether client address retention is enabled.
        """
        return pulumi.get(self, "preserve_client_ip_enabled")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used to forward requests to the backend servers.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="relatedLoadBalancerIds")
    def related_load_balancer_ids(self) -> Sequence[str]:
        """
        The NLB instance.
        """
        return pulumi.get(self, "related_load_balancer_ids")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The ID of the resource group to which the security group belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def scheduler(self) -> str:
        """
        The routing algorithm.
        """
        return pulumi.get(self, "scheduler")

    @property
    @pulumi.getter(name="serverCount")
    def server_count(self) -> int:
        """
        The number of server groups associated with the NLB instance.
        """
        return pulumi.get(self, "server_count")

    @property
    @pulumi.getter(name="serverGroupName")
    def server_group_name(self) -> str:
        """
        The name of the server group.
        """
        return pulumi.get(self, "server_group_name")

    @property
    @pulumi.getter(name="serverGroupType")
    def server_group_type(self) -> str:
        """
        The type of the server group.
        """
        return pulumi.get(self, "server_group_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the server group.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the VPC to which the server group belongs.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetServerGroupsGroupHealthCheckResult(dict):
    def __init__(__self__, *,
                 health_check_connect_port: int,
                 health_check_connect_timeout: int,
                 health_check_domain: str,
                 health_check_enabled: bool,
                 health_check_http_codes: Sequence[str],
                 health_check_interval: int,
                 health_check_type: str,
                 health_check_url: str,
                 healthy_threshold: int,
                 http_check_method: str,
                 unhealthy_threshold: int):
        """
        :param int health_check_connect_port: The backend port that is used for health checks.
        :param int health_check_connect_timeout: The maximum timeout period of a health check response.
        :param str health_check_domain: The domain name that is used for health checks.
        :param bool health_check_enabled: Specifies whether to enable health checks.
        :param Sequence[str] health_check_http_codes: The HTTP status codes returned for health checks.
        :param int health_check_interval: The interval between two consecutive health checks.
        :param str health_check_type: The protocol that is used for health checks.
        :param str health_check_url: The path to which health check requests are sent.
        :param int healthy_threshold: The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy.
        :param str http_check_method: The HTTP method that is used for health checks.
        :param int unhealthy_threshold: The number of times that a healthy backend server must consecutively fail health checks before it is declared unhealthy.
        """
        pulumi.set(__self__, "health_check_connect_port", health_check_connect_port)
        pulumi.set(__self__, "health_check_connect_timeout", health_check_connect_timeout)
        pulumi.set(__self__, "health_check_domain", health_check_domain)
        pulumi.set(__self__, "health_check_enabled", health_check_enabled)
        pulumi.set(__self__, "health_check_http_codes", health_check_http_codes)
        pulumi.set(__self__, "health_check_interval", health_check_interval)
        pulumi.set(__self__, "health_check_type", health_check_type)
        pulumi.set(__self__, "health_check_url", health_check_url)
        pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        pulumi.set(__self__, "http_check_method", http_check_method)
        pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter(name="healthCheckConnectPort")
    def health_check_connect_port(self) -> int:
        """
        The backend port that is used for health checks.
        """
        return pulumi.get(self, "health_check_connect_port")

    @property
    @pulumi.getter(name="healthCheckConnectTimeout")
    def health_check_connect_timeout(self) -> int:
        """
        The maximum timeout period of a health check response.
        """
        return pulumi.get(self, "health_check_connect_timeout")

    @property
    @pulumi.getter(name="healthCheckDomain")
    def health_check_domain(self) -> str:
        """
        The domain name that is used for health checks.
        """
        return pulumi.get(self, "health_check_domain")

    @property
    @pulumi.getter(name="healthCheckEnabled")
    def health_check_enabled(self) -> bool:
        """
        Specifies whether to enable health checks.
        """
        return pulumi.get(self, "health_check_enabled")

    @property
    @pulumi.getter(name="healthCheckHttpCodes")
    def health_check_http_codes(self) -> Sequence[str]:
        """
        The HTTP status codes returned for health checks.
        """
        return pulumi.get(self, "health_check_http_codes")

    @property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> int:
        """
        The interval between two consecutive health checks.
        """
        return pulumi.get(self, "health_check_interval")

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> str:
        """
        The protocol that is used for health checks.
        """
        return pulumi.get(self, "health_check_type")

    @property
    @pulumi.getter(name="healthCheckUrl")
    def health_check_url(self) -> str:
        """
        The path to which health check requests are sent.
        """
        return pulumi.get(self, "health_check_url")

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> int:
        """
        The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy.
        """
        return pulumi.get(self, "healthy_threshold")

    @property
    @pulumi.getter(name="httpCheckMethod")
    def http_check_method(self) -> str:
        """
        The HTTP method that is used for health checks.
        """
        return pulumi.get(self, "http_check_method")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> int:
        """
        The number of times that a healthy backend server must consecutively fail health checks before it is declared unhealthy.
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class GetZonesZoneResult(dict):
    def __init__(__self__, *,
                 id: str,
                 local_name: str,
                 zone_id: str):
        """
        :param str id: The ID of zone.
        :param str local_name: The local name.
        :param str zone_id: The zone ID.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "local_name", local_name)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of zone.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="localName")
    def local_name(self) -> str:
        """
        The local name.
        """
        return pulumi.get(self, "local_name")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")


