# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['BaseInstanceArgs', 'BaseInstance']

@pulumi.input_type
class BaseInstanceArgs:
    def __init__(__self__, *,
                 disk_size: pulumi.Input[int],
                 instance_class: pulumi.Input[str],
                 payment_type: pulumi.Input[str],
                 series: pulumi.Input[str],
                 zones: pulumi.Input[Sequence[pulumi.Input[str]]],
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 backup_retain_mode: Optional[pulumi.Input[str]] = None,
                 disk_type: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 node_num: Optional[pulumi.Input[str]] = None,
                 ob_version: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a BaseInstance resource.
        :param pulumi.Input[int] disk_size: The size of the storage space, in GB.
               The limits of storage space vary according to the cluster specifications, as follows:
               - 8C32GB:100GB ~ 10000GB
               - 14C70GB:200GB ~ 10000GB
               - 30C180GB:400GB ~ 10000GB
               - 62C400G:800GB ~ 10000GB.
               The default value of each package is its minimum value.
        :param pulumi.Input[str] instance_class: Cluster specification information.
               Four packages are currently supported:
               - 4C16GB：4cores 16GB
               - 8C32GB：8cores 32GB
               - 14C70GB：14cores 70GB
               - 24C120GB：24cores 120GB
               - 30C180GB：30cores 180GB
               - 62C400GB：62cores 400GB
               - 104C600GB：104cores 600GB
               - 16C70GB：16cores 70GB
               - 32C160GB：32cores 160GB
               - 64C380GB：64cores 380GB
               - 20C32GB：20cores 32GB
               - 40C64GB：40cores 64GB
               - 16C32GB：16cores 32GB
               - 32C70GB：32cores 70GB
               - 64C180GB：64cores 180GB
               - 32C180GB：32cores 180GB
               - 64C400GB：64cores 400GB.
        :param pulumi.Input[str] payment_type: The payment method of the instance. Value range:
               - Subscription: Package year and month. When you select this type of payment method, you must make sure that your account supports balance payment or credit payment. Otherwise, an InvalidPayMethod error message will be returned.
               - PayAsYouGo (default): Pay-as-you-go (default hourly billing).
        :param pulumi.Input[str] series: Series of OceanBase cluster instances-normal (default): Standard cluster version (cloud disk)-normal_SSD: Standard cluster version (local disk)-history: history Library cluster version.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: Information about the zone where the cluster is deployed.
        :param pulumi.Input[bool] auto_renew: Whether to automatically renew.
               It takes effect when the parameter ChargeType is PrePaid. Value range:
               - true: automatic renewal.
               - false (default): no automatic renewal.
        :param pulumi.Input[int] auto_renew_period: The duration of each auto-renewal. When the value of the AutoRenew parameter is True, this parameter is required.
               - PeriodUnit is Week, AutoRenewPeriod is {"1", "2", "3"}.
               - PeriodUnit is Month, AutoRenewPeriod is {"1", "2", "3", "6", "12"}.
        :param pulumi.Input[str] backup_retain_mode: The backup retention policy after the cluster is deleted. The values are as follows:
               - receive_all: Keep all backup sets;
               - delete_all: delete all backup sets;
               - receive_last: Keep the last backup set.
               > **NOTE:**   The default value is delete_all.
        :param pulumi.Input[str] disk_type: The storage type of the cluster. Effective only in the standard cluster version (cloud disk).
               Two types are currently supported:
               - cloud_essd_pl1: cloud disk ESSD pl1.
               - cloud_essd_pl0: cloud disk ESSD pl0. The default value is cloud_essd_pl1.
        :param pulumi.Input[str] instance_name: OceanBase cluster name.The length is 1 to 20 English or Chinese characters.If this parameter is not specified, the default value is the InstanceId of the cluster.
        :param pulumi.Input[str] node_num: The number of nodes in the cluster. If the deployment mode is n-n-n, the number of nodes is n * 3.
        :param pulumi.Input[str] ob_version: The OceanBase Server version number.
        :param pulumi.Input[int] period: The duration of the resource purchase. The unit is specified by the PeriodUnit. The parameter InstanceChargeType takes effect only when the value is PrePaid and is required. Once the DedicatedHostId is specified, the value cannot exceed the subscription duration of the dedicated host. When PeriodUnit = Week, Period values: {"1", "2", "3", "4"}. When PeriodUnit = Month, Period values: {"1", "2", "3", "4", "5", "6", "7", "8", "9", "12", "24", "36", "48", "60"}.
        :param pulumi.Input[str] period_unit: The duration of the purchase of resources.Package year and Month value range: Month.Default value: Month of the package, which is billed by volume. The default period is Hour.
        :param pulumi.Input[str] resource_group_id: The ID of the enterprise resource group to which the instance resides.
        """
        pulumi.set(__self__, "disk_size", disk_size)
        pulumi.set(__self__, "instance_class", instance_class)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "series", series)
        pulumi.set(__self__, "zones", zones)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if backup_retain_mode is not None:
            pulumi.set(__self__, "backup_retain_mode", backup_retain_mode)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if node_num is not None:
            pulumi.set(__self__, "node_num", node_num)
        if ob_version is not None:
            pulumi.set(__self__, "ob_version", ob_version)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> pulumi.Input[int]:
        """
        The size of the storage space, in GB.
        The limits of storage space vary according to the cluster specifications, as follows:
        - 8C32GB:100GB ~ 10000GB
        - 14C70GB:200GB ~ 10000GB
        - 30C180GB:400GB ~ 10000GB
        - 62C400G:800GB ~ 10000GB.
        The default value of each package is its minimum value.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "disk_size", value)

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Input[str]:
        """
        Cluster specification information.
        Four packages are currently supported:
        - 4C16GB：4cores 16GB
        - 8C32GB：8cores 32GB
        - 14C70GB：14cores 70GB
        - 24C120GB：24cores 120GB
        - 30C180GB：30cores 180GB
        - 62C400GB：62cores 400GB
        - 104C600GB：104cores 600GB
        - 16C70GB：16cores 70GB
        - 32C160GB：32cores 160GB
        - 64C380GB：64cores 380GB
        - 20C32GB：20cores 32GB
        - 40C64GB：40cores 64GB
        - 16C32GB：16cores 32GB
        - 32C70GB：32cores 70GB
        - 64C180GB：64cores 180GB
        - 32C180GB：32cores 180GB
        - 64C400GB：64cores 400GB.
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_class", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[str]:
        """
        The payment method of the instance. Value range:
        - Subscription: Package year and month. When you select this type of payment method, you must make sure that your account supports balance payment or credit payment. Otherwise, an InvalidPayMethod error message will be returned.
        - PayAsYouGo (default): Pay-as-you-go (default hourly billing).
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def series(self) -> pulumi.Input[str]:
        """
        Series of OceanBase cluster instances-normal (default): Standard cluster version (cloud disk)-normal_SSD: Standard cluster version (local disk)-history: history Library cluster version.
        """
        return pulumi.get(self, "series")

    @series.setter
    def series(self, value: pulumi.Input[str]):
        pulumi.set(self, "series", value)

    @property
    @pulumi.getter
    def zones(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Information about the zone where the cluster is deployed.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "zones", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically renew.
        It takes effect when the parameter ChargeType is PrePaid. Value range:
        - true: automatic renewal.
        - false (default): no automatic renewal.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        The duration of each auto-renewal. When the value of the AutoRenew parameter is True, this parameter is required.
        - PeriodUnit is Week, AutoRenewPeriod is {"1", "2", "3"}.
        - PeriodUnit is Month, AutoRenewPeriod is {"1", "2", "3", "6", "12"}.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_period", value)

    @property
    @pulumi.getter(name="backupRetainMode")
    def backup_retain_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The backup retention policy after the cluster is deleted. The values are as follows:
        - receive_all: Keep all backup sets;
        - delete_all: delete all backup sets;
        - receive_last: Keep the last backup set.
        > **NOTE:**   The default value is delete_all.
        """
        return pulumi.get(self, "backup_retain_mode")

    @backup_retain_mode.setter
    def backup_retain_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_retain_mode", value)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        The storage type of the cluster. Effective only in the standard cluster version (cloud disk).
        Two types are currently supported:
        - cloud_essd_pl1: cloud disk ESSD pl1.
        - cloud_essd_pl0: cloud disk ESSD pl0. The default value is cloud_essd_pl1.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_type", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        OceanBase cluster name.The length is 1 to 20 English or Chinese characters.If this parameter is not specified, the default value is the InstanceId of the cluster.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="nodeNum")
    def node_num(self) -> Optional[pulumi.Input[str]]:
        """
        The number of nodes in the cluster. If the deployment mode is n-n-n, the number of nodes is n * 3.
        """
        return pulumi.get(self, "node_num")

    @node_num.setter
    def node_num(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_num", value)

    @property
    @pulumi.getter(name="obVersion")
    def ob_version(self) -> Optional[pulumi.Input[str]]:
        """
        The OceanBase Server version number.
        """
        return pulumi.get(self, "ob_version")

    @ob_version.setter
    def ob_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ob_version", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The duration of the resource purchase. The unit is specified by the PeriodUnit. The parameter InstanceChargeType takes effect only when the value is PrePaid and is required. Once the DedicatedHostId is specified, the value cannot exceed the subscription duration of the dedicated host. When PeriodUnit = Week, Period values: {"1", "2", "3", "4"}. When PeriodUnit = Month, Period values: {"1", "2", "3", "4", "5", "6", "7", "8", "9", "12", "24", "36", "48", "60"}.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The duration of the purchase of resources.Package year and Month value range: Month.Default value: Month of the package, which is billed by volume. The default period is Hour.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the enterprise resource group to which the instance resides.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)


@pulumi.input_type
class _BaseInstanceState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 backup_retain_mode: Optional[pulumi.Input[str]] = None,
                 commodity_code: Optional[pulumi.Input[str]] = None,
                 cpu: Optional[pulumi.Input[int]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 disk_size: Optional[pulumi.Input[int]] = None,
                 disk_type: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 node_num: Optional[pulumi.Input[str]] = None,
                 ob_version: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 series: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering BaseInstance resources.
        :param pulumi.Input[bool] auto_renew: Whether to automatically renew.
               It takes effect when the parameter ChargeType is PrePaid. Value range:
               - true: automatic renewal.
               - false (default): no automatic renewal.
        :param pulumi.Input[int] auto_renew_period: The duration of each auto-renewal. When the value of the AutoRenew parameter is True, this parameter is required.
               - PeriodUnit is Week, AutoRenewPeriod is {"1", "2", "3"}.
               - PeriodUnit is Month, AutoRenewPeriod is {"1", "2", "3", "6", "12"}.
        :param pulumi.Input[str] backup_retain_mode: The backup retention policy after the cluster is deleted. The values are as follows:
               - receive_all: Keep all backup sets;
               - delete_all: delete all backup sets;
               - receive_last: Keep the last backup set.
               > **NOTE:**   The default value is delete_all.
        :param pulumi.Input[str] commodity_code: The product code of the OceanBase cluster._oceanbasepre_public_cn: Domestic station cloud database package Year-to-month package._oceanbasepost_public_cn: The domestic station cloud database is paid by the hour._obpre_public_intl: International Station Cloud Database Package Monthly Package.
        :param pulumi.Input[int] cpu: The number of CPU cores of the cluster.
        :param pulumi.Input[str] create_time: The creation time of the resource.
        :param pulumi.Input[int] disk_size: The size of the storage space, in GB.
               The limits of storage space vary according to the cluster specifications, as follows:
               - 8C32GB:100GB ~ 10000GB
               - 14C70GB:200GB ~ 10000GB
               - 30C180GB:400GB ~ 10000GB
               - 62C400G:800GB ~ 10000GB.
               The default value of each package is its minimum value.
        :param pulumi.Input[str] disk_type: The storage type of the cluster. Effective only in the standard cluster version (cloud disk).
               Two types are currently supported:
               - cloud_essd_pl1: cloud disk ESSD pl1.
               - cloud_essd_pl0: cloud disk ESSD pl0. The default value is cloud_essd_pl1.
        :param pulumi.Input[str] instance_class: Cluster specification information.
               Four packages are currently supported:
               - 4C16GB：4cores 16GB
               - 8C32GB：8cores 32GB
               - 14C70GB：14cores 70GB
               - 24C120GB：24cores 120GB
               - 30C180GB：30cores 180GB
               - 62C400GB：62cores 400GB
               - 104C600GB：104cores 600GB
               - 16C70GB：16cores 70GB
               - 32C160GB：32cores 160GB
               - 64C380GB：64cores 380GB
               - 20C32GB：20cores 32GB
               - 40C64GB：40cores 64GB
               - 16C32GB：16cores 32GB
               - 32C70GB：32cores 70GB
               - 64C180GB：64cores 180GB
               - 32C180GB：32cores 180GB
               - 64C400GB：64cores 400GB.
        :param pulumi.Input[str] instance_name: OceanBase cluster name.The length is 1 to 20 English or Chinese characters.If this parameter is not specified, the default value is the InstanceId of the cluster.
        :param pulumi.Input[str] node_num: The number of nodes in the cluster. If the deployment mode is n-n-n, the number of nodes is n * 3.
        :param pulumi.Input[str] ob_version: The OceanBase Server version number.
        :param pulumi.Input[str] payment_type: The payment method of the instance. Value range:
               - Subscription: Package year and month. When you select this type of payment method, you must make sure that your account supports balance payment or credit payment. Otherwise, an InvalidPayMethod error message will be returned.
               - PayAsYouGo (default): Pay-as-you-go (default hourly billing).
        :param pulumi.Input[int] period: The duration of the resource purchase. The unit is specified by the PeriodUnit. The parameter InstanceChargeType takes effect only when the value is PrePaid and is required. Once the DedicatedHostId is specified, the value cannot exceed the subscription duration of the dedicated host. When PeriodUnit = Week, Period values: {"1", "2", "3", "4"}. When PeriodUnit = Month, Period values: {"1", "2", "3", "4", "5", "6", "7", "8", "9", "12", "24", "36", "48", "60"}.
        :param pulumi.Input[str] period_unit: The duration of the purchase of resources.Package year and Month value range: Month.Default value: Month of the package, which is billed by volume. The default period is Hour.
        :param pulumi.Input[str] resource_group_id: The ID of the enterprise resource group to which the instance resides.
        :param pulumi.Input[str] series: Series of OceanBase cluster instances-normal (default): Standard cluster version (cloud disk)-normal_SSD: Standard cluster version (local disk)-history: history Library cluster version.
        :param pulumi.Input[str] status: The status of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: Information about the zone where the cluster is deployed.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if backup_retain_mode is not None:
            pulumi.set(__self__, "backup_retain_mode", backup_retain_mode)
        if commodity_code is not None:
            pulumi.set(__self__, "commodity_code", commodity_code)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if node_num is not None:
            pulumi.set(__self__, "node_num", node_num)
        if ob_version is not None:
            pulumi.set(__self__, "ob_version", ob_version)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if series is not None:
            pulumi.set(__self__, "series", series)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically renew.
        It takes effect when the parameter ChargeType is PrePaid. Value range:
        - true: automatic renewal.
        - false (default): no automatic renewal.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        The duration of each auto-renewal. When the value of the AutoRenew parameter is True, this parameter is required.
        - PeriodUnit is Week, AutoRenewPeriod is {"1", "2", "3"}.
        - PeriodUnit is Month, AutoRenewPeriod is {"1", "2", "3", "6", "12"}.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_period", value)

    @property
    @pulumi.getter(name="backupRetainMode")
    def backup_retain_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The backup retention policy after the cluster is deleted. The values are as follows:
        - receive_all: Keep all backup sets;
        - delete_all: delete all backup sets;
        - receive_last: Keep the last backup set.
        > **NOTE:**   The default value is delete_all.
        """
        return pulumi.get(self, "backup_retain_mode")

    @backup_retain_mode.setter
    def backup_retain_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_retain_mode", value)

    @property
    @pulumi.getter(name="commodityCode")
    def commodity_code(self) -> Optional[pulumi.Input[str]]:
        """
        The product code of the OceanBase cluster._oceanbasepre_public_cn: Domestic station cloud database package Year-to-month package._oceanbasepost_public_cn: The domestic station cloud database is paid by the hour._obpre_public_intl: International Station Cloud Database Package Monthly Package.
        """
        return pulumi.get(self, "commodity_code")

    @commodity_code.setter
    def commodity_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commodity_code", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[int]]:
        """
        The number of CPU cores of the cluster.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the storage space, in GB.
        The limits of storage space vary according to the cluster specifications, as follows:
        - 8C32GB:100GB ~ 10000GB
        - 14C70GB:200GB ~ 10000GB
        - 30C180GB:400GB ~ 10000GB
        - 62C400G:800GB ~ 10000GB.
        The default value of each package is its minimum value.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size", value)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        The storage type of the cluster. Effective only in the standard cluster version (cloud disk).
        Two types are currently supported:
        - cloud_essd_pl1: cloud disk ESSD pl1.
        - cloud_essd_pl0: cloud disk ESSD pl0. The default value is cloud_essd_pl1.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_type", value)

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster specification information.
        Four packages are currently supported:
        - 4C16GB：4cores 16GB
        - 8C32GB：8cores 32GB
        - 14C70GB：14cores 70GB
        - 24C120GB：24cores 120GB
        - 30C180GB：30cores 180GB
        - 62C400GB：62cores 400GB
        - 104C600GB：104cores 600GB
        - 16C70GB：16cores 70GB
        - 32C160GB：32cores 160GB
        - 64C380GB：64cores 380GB
        - 20C32GB：20cores 32GB
        - 40C64GB：40cores 64GB
        - 16C32GB：16cores 32GB
        - 32C70GB：32cores 70GB
        - 64C180GB：64cores 180GB
        - 32C180GB：32cores 180GB
        - 64C400GB：64cores 400GB.
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_class", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        OceanBase cluster name.The length is 1 to 20 English or Chinese characters.If this parameter is not specified, the default value is the InstanceId of the cluster.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="nodeNum")
    def node_num(self) -> Optional[pulumi.Input[str]]:
        """
        The number of nodes in the cluster. If the deployment mode is n-n-n, the number of nodes is n * 3.
        """
        return pulumi.get(self, "node_num")

    @node_num.setter
    def node_num(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_num", value)

    @property
    @pulumi.getter(name="obVersion")
    def ob_version(self) -> Optional[pulumi.Input[str]]:
        """
        The OceanBase Server version number.
        """
        return pulumi.get(self, "ob_version")

    @ob_version.setter
    def ob_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ob_version", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The payment method of the instance. Value range:
        - Subscription: Package year and month. When you select this type of payment method, you must make sure that your account supports balance payment or credit payment. Otherwise, an InvalidPayMethod error message will be returned.
        - PayAsYouGo (default): Pay-as-you-go (default hourly billing).
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The duration of the resource purchase. The unit is specified by the PeriodUnit. The parameter InstanceChargeType takes effect only when the value is PrePaid and is required. Once the DedicatedHostId is specified, the value cannot exceed the subscription duration of the dedicated host. When PeriodUnit = Week, Period values: {"1", "2", "3", "4"}. When PeriodUnit = Month, Period values: {"1", "2", "3", "4", "5", "6", "7", "8", "9", "12", "24", "36", "48", "60"}.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The duration of the purchase of resources.Package year and Month value range: Month.Default value: Month of the package, which is billed by volume. The default period is Hour.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the enterprise resource group to which the instance resides.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter
    def series(self) -> Optional[pulumi.Input[str]]:
        """
        Series of OceanBase cluster instances-normal (default): Standard cluster version (cloud disk)-normal_SSD: Standard cluster version (local disk)-history: history Library cluster version.
        """
        return pulumi.get(self, "series")

    @series.setter
    def series(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "series", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Information about the zone where the cluster is deployed.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zones", value)


class BaseInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 backup_retain_mode: Optional[pulumi.Input[str]] = None,
                 disk_size: Optional[pulumi.Input[int]] = None,
                 disk_type: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 node_num: Optional[pulumi.Input[str]] = None,
                 ob_version: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 series: Optional[pulumi.Input[str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a Ocean Base Instance resource.

        For information about Ocean Base Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/apsaradb-for-oceanbase/latest/what-is-oceanbase-database).

        > **NOTE:** Available since v1.203.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_zones = alicloud.get_zones()
        default_resource_groups = alicloud.resourcemanager.get_resource_groups()
        default_base_instance = alicloud.ocean.BaseInstance("defaultBaseInstance",
            resource_group_id=default_resource_groups.ids[0],
            zones=[
                default_zones.ids[len(default_zones.ids) - 2],
                default_zones.ids[len(default_zones.ids) - 3],
                default_zones.ids[len(default_zones.ids) - 4],
            ],
            auto_renew=False,
            disk_size=100,
            payment_type="PayAsYouGo",
            instance_class="8C32GB",
            backup_retain_mode="delete_all",
            series="normal",
            instance_name=name)
        ```

        ## Import

        Ocean Base Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ocean/baseInstance:BaseInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_renew: Whether to automatically renew.
               It takes effect when the parameter ChargeType is PrePaid. Value range:
               - true: automatic renewal.
               - false (default): no automatic renewal.
        :param pulumi.Input[int] auto_renew_period: The duration of each auto-renewal. When the value of the AutoRenew parameter is True, this parameter is required.
               - PeriodUnit is Week, AutoRenewPeriod is {"1", "2", "3"}.
               - PeriodUnit is Month, AutoRenewPeriod is {"1", "2", "3", "6", "12"}.
        :param pulumi.Input[str] backup_retain_mode: The backup retention policy after the cluster is deleted. The values are as follows:
               - receive_all: Keep all backup sets;
               - delete_all: delete all backup sets;
               - receive_last: Keep the last backup set.
               > **NOTE:**   The default value is delete_all.
        :param pulumi.Input[int] disk_size: The size of the storage space, in GB.
               The limits of storage space vary according to the cluster specifications, as follows:
               - 8C32GB:100GB ~ 10000GB
               - 14C70GB:200GB ~ 10000GB
               - 30C180GB:400GB ~ 10000GB
               - 62C400G:800GB ~ 10000GB.
               The default value of each package is its minimum value.
        :param pulumi.Input[str] disk_type: The storage type of the cluster. Effective only in the standard cluster version (cloud disk).
               Two types are currently supported:
               - cloud_essd_pl1: cloud disk ESSD pl1.
               - cloud_essd_pl0: cloud disk ESSD pl0. The default value is cloud_essd_pl1.
        :param pulumi.Input[str] instance_class: Cluster specification information.
               Four packages are currently supported:
               - 4C16GB：4cores 16GB
               - 8C32GB：8cores 32GB
               - 14C70GB：14cores 70GB
               - 24C120GB：24cores 120GB
               - 30C180GB：30cores 180GB
               - 62C400GB：62cores 400GB
               - 104C600GB：104cores 600GB
               - 16C70GB：16cores 70GB
               - 32C160GB：32cores 160GB
               - 64C380GB：64cores 380GB
               - 20C32GB：20cores 32GB
               - 40C64GB：40cores 64GB
               - 16C32GB：16cores 32GB
               - 32C70GB：32cores 70GB
               - 64C180GB：64cores 180GB
               - 32C180GB：32cores 180GB
               - 64C400GB：64cores 400GB.
        :param pulumi.Input[str] instance_name: OceanBase cluster name.The length is 1 to 20 English or Chinese characters.If this parameter is not specified, the default value is the InstanceId of the cluster.
        :param pulumi.Input[str] node_num: The number of nodes in the cluster. If the deployment mode is n-n-n, the number of nodes is n * 3.
        :param pulumi.Input[str] ob_version: The OceanBase Server version number.
        :param pulumi.Input[str] payment_type: The payment method of the instance. Value range:
               - Subscription: Package year and month. When you select this type of payment method, you must make sure that your account supports balance payment or credit payment. Otherwise, an InvalidPayMethod error message will be returned.
               - PayAsYouGo (default): Pay-as-you-go (default hourly billing).
        :param pulumi.Input[int] period: The duration of the resource purchase. The unit is specified by the PeriodUnit. The parameter InstanceChargeType takes effect only when the value is PrePaid and is required. Once the DedicatedHostId is specified, the value cannot exceed the subscription duration of the dedicated host. When PeriodUnit = Week, Period values: {"1", "2", "3", "4"}. When PeriodUnit = Month, Period values: {"1", "2", "3", "4", "5", "6", "7", "8", "9", "12", "24", "36", "48", "60"}.
        :param pulumi.Input[str] period_unit: The duration of the purchase of resources.Package year and Month value range: Month.Default value: Month of the package, which is billed by volume. The default period is Hour.
        :param pulumi.Input[str] resource_group_id: The ID of the enterprise resource group to which the instance resides.
        :param pulumi.Input[str] series: Series of OceanBase cluster instances-normal (default): Standard cluster version (cloud disk)-normal_SSD: Standard cluster version (local disk)-history: history Library cluster version.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: Information about the zone where the cluster is deployed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BaseInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Ocean Base Instance resource.

        For information about Ocean Base Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/apsaradb-for-oceanbase/latest/what-is-oceanbase-database).

        > **NOTE:** Available since v1.203.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_zones = alicloud.get_zones()
        default_resource_groups = alicloud.resourcemanager.get_resource_groups()
        default_base_instance = alicloud.ocean.BaseInstance("defaultBaseInstance",
            resource_group_id=default_resource_groups.ids[0],
            zones=[
                default_zones.ids[len(default_zones.ids) - 2],
                default_zones.ids[len(default_zones.ids) - 3],
                default_zones.ids[len(default_zones.ids) - 4],
            ],
            auto_renew=False,
            disk_size=100,
            payment_type="PayAsYouGo",
            instance_class="8C32GB",
            backup_retain_mode="delete_all",
            series="normal",
            instance_name=name)
        ```

        ## Import

        Ocean Base Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ocean/baseInstance:BaseInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param BaseInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BaseInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 backup_retain_mode: Optional[pulumi.Input[str]] = None,
                 disk_size: Optional[pulumi.Input[int]] = None,
                 disk_type: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 node_num: Optional[pulumi.Input[str]] = None,
                 ob_version: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 series: Optional[pulumi.Input[str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BaseInstanceArgs.__new__(BaseInstanceArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["auto_renew_period"] = auto_renew_period
            __props__.__dict__["backup_retain_mode"] = backup_retain_mode
            if disk_size is None and not opts.urn:
                raise TypeError("Missing required property 'disk_size'")
            __props__.__dict__["disk_size"] = disk_size
            __props__.__dict__["disk_type"] = disk_type
            if instance_class is None and not opts.urn:
                raise TypeError("Missing required property 'instance_class'")
            __props__.__dict__["instance_class"] = instance_class
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["node_num"] = node_num
            __props__.__dict__["ob_version"] = ob_version
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["resource_group_id"] = resource_group_id
            if series is None and not opts.urn:
                raise TypeError("Missing required property 'series'")
            __props__.__dict__["series"] = series
            if zones is None and not opts.urn:
                raise TypeError("Missing required property 'zones'")
            __props__.__dict__["zones"] = zones
            __props__.__dict__["commodity_code"] = None
            __props__.__dict__["cpu"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(BaseInstance, __self__).__init__(
            'alicloud:ocean/baseInstance:BaseInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[bool]] = None,
            auto_renew_period: Optional[pulumi.Input[int]] = None,
            backup_retain_mode: Optional[pulumi.Input[str]] = None,
            commodity_code: Optional[pulumi.Input[str]] = None,
            cpu: Optional[pulumi.Input[int]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            disk_size: Optional[pulumi.Input[int]] = None,
            disk_type: Optional[pulumi.Input[str]] = None,
            instance_class: Optional[pulumi.Input[str]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            node_num: Optional[pulumi.Input[str]] = None,
            ob_version: Optional[pulumi.Input[str]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            series: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'BaseInstance':
        """
        Get an existing BaseInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_renew: Whether to automatically renew.
               It takes effect when the parameter ChargeType is PrePaid. Value range:
               - true: automatic renewal.
               - false (default): no automatic renewal.
        :param pulumi.Input[int] auto_renew_period: The duration of each auto-renewal. When the value of the AutoRenew parameter is True, this parameter is required.
               - PeriodUnit is Week, AutoRenewPeriod is {"1", "2", "3"}.
               - PeriodUnit is Month, AutoRenewPeriod is {"1", "2", "3", "6", "12"}.
        :param pulumi.Input[str] backup_retain_mode: The backup retention policy after the cluster is deleted. The values are as follows:
               - receive_all: Keep all backup sets;
               - delete_all: delete all backup sets;
               - receive_last: Keep the last backup set.
               > **NOTE:**   The default value is delete_all.
        :param pulumi.Input[str] commodity_code: The product code of the OceanBase cluster._oceanbasepre_public_cn: Domestic station cloud database package Year-to-month package._oceanbasepost_public_cn: The domestic station cloud database is paid by the hour._obpre_public_intl: International Station Cloud Database Package Monthly Package.
        :param pulumi.Input[int] cpu: The number of CPU cores of the cluster.
        :param pulumi.Input[str] create_time: The creation time of the resource.
        :param pulumi.Input[int] disk_size: The size of the storage space, in GB.
               The limits of storage space vary according to the cluster specifications, as follows:
               - 8C32GB:100GB ~ 10000GB
               - 14C70GB:200GB ~ 10000GB
               - 30C180GB:400GB ~ 10000GB
               - 62C400G:800GB ~ 10000GB.
               The default value of each package is its minimum value.
        :param pulumi.Input[str] disk_type: The storage type of the cluster. Effective only in the standard cluster version (cloud disk).
               Two types are currently supported:
               - cloud_essd_pl1: cloud disk ESSD pl1.
               - cloud_essd_pl0: cloud disk ESSD pl0. The default value is cloud_essd_pl1.
        :param pulumi.Input[str] instance_class: Cluster specification information.
               Four packages are currently supported:
               - 4C16GB：4cores 16GB
               - 8C32GB：8cores 32GB
               - 14C70GB：14cores 70GB
               - 24C120GB：24cores 120GB
               - 30C180GB：30cores 180GB
               - 62C400GB：62cores 400GB
               - 104C600GB：104cores 600GB
               - 16C70GB：16cores 70GB
               - 32C160GB：32cores 160GB
               - 64C380GB：64cores 380GB
               - 20C32GB：20cores 32GB
               - 40C64GB：40cores 64GB
               - 16C32GB：16cores 32GB
               - 32C70GB：32cores 70GB
               - 64C180GB：64cores 180GB
               - 32C180GB：32cores 180GB
               - 64C400GB：64cores 400GB.
        :param pulumi.Input[str] instance_name: OceanBase cluster name.The length is 1 to 20 English or Chinese characters.If this parameter is not specified, the default value is the InstanceId of the cluster.
        :param pulumi.Input[str] node_num: The number of nodes in the cluster. If the deployment mode is n-n-n, the number of nodes is n * 3.
        :param pulumi.Input[str] ob_version: The OceanBase Server version number.
        :param pulumi.Input[str] payment_type: The payment method of the instance. Value range:
               - Subscription: Package year and month. When you select this type of payment method, you must make sure that your account supports balance payment or credit payment. Otherwise, an InvalidPayMethod error message will be returned.
               - PayAsYouGo (default): Pay-as-you-go (default hourly billing).
        :param pulumi.Input[int] period: The duration of the resource purchase. The unit is specified by the PeriodUnit. The parameter InstanceChargeType takes effect only when the value is PrePaid and is required. Once the DedicatedHostId is specified, the value cannot exceed the subscription duration of the dedicated host. When PeriodUnit = Week, Period values: {"1", "2", "3", "4"}. When PeriodUnit = Month, Period values: {"1", "2", "3", "4", "5", "6", "7", "8", "9", "12", "24", "36", "48", "60"}.
        :param pulumi.Input[str] period_unit: The duration of the purchase of resources.Package year and Month value range: Month.Default value: Month of the package, which is billed by volume. The default period is Hour.
        :param pulumi.Input[str] resource_group_id: The ID of the enterprise resource group to which the instance resides.
        :param pulumi.Input[str] series: Series of OceanBase cluster instances-normal (default): Standard cluster version (cloud disk)-normal_SSD: Standard cluster version (local disk)-history: history Library cluster version.
        :param pulumi.Input[str] status: The status of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: Information about the zone where the cluster is deployed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BaseInstanceState.__new__(_BaseInstanceState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["auto_renew_period"] = auto_renew_period
        __props__.__dict__["backup_retain_mode"] = backup_retain_mode
        __props__.__dict__["commodity_code"] = commodity_code
        __props__.__dict__["cpu"] = cpu
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["disk_size"] = disk_size
        __props__.__dict__["disk_type"] = disk_type
        __props__.__dict__["instance_class"] = instance_class
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["node_num"] = node_num
        __props__.__dict__["ob_version"] = ob_version
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["series"] = series
        __props__.__dict__["status"] = status
        __props__.__dict__["zones"] = zones
        return BaseInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to automatically renew.
        It takes effect when the parameter ChargeType is PrePaid. Value range:
        - true: automatic renewal.
        - false (default): no automatic renewal.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> pulumi.Output[Optional[int]]:
        """
        The duration of each auto-renewal. When the value of the AutoRenew parameter is True, this parameter is required.
        - PeriodUnit is Week, AutoRenewPeriod is {"1", "2", "3"}.
        - PeriodUnit is Month, AutoRenewPeriod is {"1", "2", "3", "6", "12"}.
        """
        return pulumi.get(self, "auto_renew_period")

    @property
    @pulumi.getter(name="backupRetainMode")
    def backup_retain_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The backup retention policy after the cluster is deleted. The values are as follows:
        - receive_all: Keep all backup sets;
        - delete_all: delete all backup sets;
        - receive_last: Keep the last backup set.
        > **NOTE:**   The default value is delete_all.
        """
        return pulumi.get(self, "backup_retain_mode")

    @property
    @pulumi.getter(name="commodityCode")
    def commodity_code(self) -> pulumi.Output[str]:
        """
        The product code of the OceanBase cluster._oceanbasepre_public_cn: Domestic station cloud database package Year-to-month package._oceanbasepost_public_cn: The domestic station cloud database is paid by the hour._obpre_public_intl: International Station Cloud Database Package Monthly Package.
        """
        return pulumi.get(self, "commodity_code")

    @property
    @pulumi.getter
    def cpu(self) -> pulumi.Output[int]:
        """
        The number of CPU cores of the cluster.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> pulumi.Output[int]:
        """
        The size of the storage space, in GB.
        The limits of storage space vary according to the cluster specifications, as follows:
        - 8C32GB:100GB ~ 10000GB
        - 14C70GB:200GB ~ 10000GB
        - 30C180GB:400GB ~ 10000GB
        - 62C400G:800GB ~ 10000GB.
        The default value of each package is its minimum value.
        """
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> pulumi.Output[str]:
        """
        The storage type of the cluster. Effective only in the standard cluster version (cloud disk).
        Two types are currently supported:
        - cloud_essd_pl1: cloud disk ESSD pl1.
        - cloud_essd_pl0: cloud disk ESSD pl0. The default value is cloud_essd_pl1.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Output[str]:
        """
        Cluster specification information.
        Four packages are currently supported:
        - 4C16GB：4cores 16GB
        - 8C32GB：8cores 32GB
        - 14C70GB：14cores 70GB
        - 24C120GB：24cores 120GB
        - 30C180GB：30cores 180GB
        - 62C400GB：62cores 400GB
        - 104C600GB：104cores 600GB
        - 16C70GB：16cores 70GB
        - 32C160GB：32cores 160GB
        - 64C380GB：64cores 380GB
        - 20C32GB：20cores 32GB
        - 40C64GB：40cores 64GB
        - 16C32GB：16cores 32GB
        - 32C70GB：32cores 70GB
        - 64C180GB：64cores 180GB
        - 32C180GB：32cores 180GB
        - 64C400GB：64cores 400GB.
        """
        return pulumi.get(self, "instance_class")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[str]:
        """
        OceanBase cluster name.The length is 1 to 20 English or Chinese characters.If this parameter is not specified, the default value is the InstanceId of the cluster.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="nodeNum")
    def node_num(self) -> pulumi.Output[str]:
        """
        The number of nodes in the cluster. If the deployment mode is n-n-n, the number of nodes is n * 3.
        """
        return pulumi.get(self, "node_num")

    @property
    @pulumi.getter(name="obVersion")
    def ob_version(self) -> pulumi.Output[str]:
        """
        The OceanBase Server version number.
        """
        return pulumi.get(self, "ob_version")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        The payment method of the instance. Value range:
        - Subscription: Package year and month. When you select this type of payment method, you must make sure that your account supports balance payment or credit payment. Otherwise, an InvalidPayMethod error message will be returned.
        - PayAsYouGo (default): Pay-as-you-go (default hourly billing).
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        The duration of the resource purchase. The unit is specified by the PeriodUnit. The parameter InstanceChargeType takes effect only when the value is PrePaid and is required. Once the DedicatedHostId is specified, the value cannot exceed the subscription duration of the dedicated host. When PeriodUnit = Week, Period values: {"1", "2", "3", "4"}. When PeriodUnit = Month, Period values: {"1", "2", "3", "4", "5", "6", "7", "8", "9", "12", "24", "36", "48", "60"}.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        The duration of the purchase of resources.Package year and Month value range: Month.Default value: Month of the package, which is billed by volume. The default period is Hour.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the enterprise resource group to which the instance resides.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def series(self) -> pulumi.Output[str]:
        """
        Series of OceanBase cluster instances-normal (default): Standard cluster version (cloud disk)-normal_SSD: Standard cluster version (local disk)-history: history Library cluster version.
        """
        return pulumi.get(self, "series")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Sequence[str]]:
        """
        Information about the zone where the cluster is deployed.
        """
        return pulumi.get(self, "zones")

