# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DefaultPatchBaselineArgs', 'DefaultPatchBaseline']

@pulumi.input_type
class DefaultPatchBaselineArgs:
    def __init__(__self__, *,
                 patch_baseline_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a DefaultPatchBaseline resource.
        :param pulumi.Input[str] patch_baseline_name: The name of the patch baseline.
        """
        pulumi.set(__self__, "patch_baseline_name", patch_baseline_name)

    @property
    @pulumi.getter(name="patchBaselineName")
    def patch_baseline_name(self) -> pulumi.Input[str]:
        """
        The name of the patch baseline.
        """
        return pulumi.get(self, "patch_baseline_name")

    @patch_baseline_name.setter
    def patch_baseline_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "patch_baseline_name", value)


@pulumi.input_type
class _DefaultPatchBaselineState:
    def __init__(__self__, *,
                 patch_baseline_id: Optional[pulumi.Input[str]] = None,
                 patch_baseline_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DefaultPatchBaseline resources.
        :param pulumi.Input[str] patch_baseline_id: The ID of the patch baseline.
        :param pulumi.Input[str] patch_baseline_name: The name of the patch baseline.
        """
        if patch_baseline_id is not None:
            pulumi.set(__self__, "patch_baseline_id", patch_baseline_id)
        if patch_baseline_name is not None:
            pulumi.set(__self__, "patch_baseline_name", patch_baseline_name)

    @property
    @pulumi.getter(name="patchBaselineId")
    def patch_baseline_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the patch baseline.
        """
        return pulumi.get(self, "patch_baseline_id")

    @patch_baseline_id.setter
    def patch_baseline_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "patch_baseline_id", value)

    @property
    @pulumi.getter(name="patchBaselineName")
    def patch_baseline_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the patch baseline.
        """
        return pulumi.get(self, "patch_baseline_name")

    @patch_baseline_name.setter
    def patch_baseline_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "patch_baseline_name", value)


class DefaultPatchBaseline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 patch_baseline_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Oos Default Patch Baseline resource.

        For information about Oos Default Patch Baseline and how to use it, see [What is Default Patch Baseline](https://www.alibabacloud.com/help/en/operation-orchestration-service/latest/api-oos-2019-06-01-registerdefaultpatchbaseline).

        > **NOTE:** Available in v1.203.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_patch_baseline = alicloud.oos.PatchBaseline("defaultPatchBaseline",
            operation_system="Windows",
            patch_baseline_name="terraform-example",
            description="terraform-example",
            approval_rules="{\\"PatchRules\\":[{\\"PatchFilterGroup\\":[{\\"Key\\":\\"PatchSet\\",\\"Values\\":[\\"OS\\"]},{\\"Key\\":\\"ProductFamily\\",\\"Values\\":[\\"Windows\\"]},{\\"Key\\":\\"Product\\",\\"Values\\":[\\"Windows 10\\",\\"Windows 7\\"]},{\\"Key\\":\\"Classification\\",\\"Values\\":[\\"Security Updates\\",\\"Updates\\",\\"Update Rollups\\",\\"Critical Updates\\"]},{\\"Key\\":\\"Severity\\",\\"Values\\":[\\"Critical\\",\\"Important\\",\\"Moderate\\"]}],\\"ApproveAfterDays\\":7,\\"EnableNonSecurity\\":true,\\"ComplianceLevel\\":\\"Medium\\"}]}")
        default_default_patch_baseline = alicloud.oos.DefaultPatchBaseline("defaultDefaultPatchBaseline", patch_baseline_name=default_patch_baseline.id)
        ```

        ## Import

        Oos Default Patch Baseline can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:oos/defaultPatchBaseline:DefaultPatchBaseline example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] patch_baseline_name: The name of the patch baseline.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DefaultPatchBaselineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Oos Default Patch Baseline resource.

        For information about Oos Default Patch Baseline and how to use it, see [What is Default Patch Baseline](https://www.alibabacloud.com/help/en/operation-orchestration-service/latest/api-oos-2019-06-01-registerdefaultpatchbaseline).

        > **NOTE:** Available in v1.203.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_patch_baseline = alicloud.oos.PatchBaseline("defaultPatchBaseline",
            operation_system="Windows",
            patch_baseline_name="terraform-example",
            description="terraform-example",
            approval_rules="{\\"PatchRules\\":[{\\"PatchFilterGroup\\":[{\\"Key\\":\\"PatchSet\\",\\"Values\\":[\\"OS\\"]},{\\"Key\\":\\"ProductFamily\\",\\"Values\\":[\\"Windows\\"]},{\\"Key\\":\\"Product\\",\\"Values\\":[\\"Windows 10\\",\\"Windows 7\\"]},{\\"Key\\":\\"Classification\\",\\"Values\\":[\\"Security Updates\\",\\"Updates\\",\\"Update Rollups\\",\\"Critical Updates\\"]},{\\"Key\\":\\"Severity\\",\\"Values\\":[\\"Critical\\",\\"Important\\",\\"Moderate\\"]}],\\"ApproveAfterDays\\":7,\\"EnableNonSecurity\\":true,\\"ComplianceLevel\\":\\"Medium\\"}]}")
        default_default_patch_baseline = alicloud.oos.DefaultPatchBaseline("defaultDefaultPatchBaseline", patch_baseline_name=default_patch_baseline.id)
        ```

        ## Import

        Oos Default Patch Baseline can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:oos/defaultPatchBaseline:DefaultPatchBaseline example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DefaultPatchBaselineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DefaultPatchBaselineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 patch_baseline_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DefaultPatchBaselineArgs.__new__(DefaultPatchBaselineArgs)

            if patch_baseline_name is None and not opts.urn:
                raise TypeError("Missing required property 'patch_baseline_name'")
            __props__.__dict__["patch_baseline_name"] = patch_baseline_name
            __props__.__dict__["patch_baseline_id"] = None
        super(DefaultPatchBaseline, __self__).__init__(
            'alicloud:oos/defaultPatchBaseline:DefaultPatchBaseline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            patch_baseline_id: Optional[pulumi.Input[str]] = None,
            patch_baseline_name: Optional[pulumi.Input[str]] = None) -> 'DefaultPatchBaseline':
        """
        Get an existing DefaultPatchBaseline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] patch_baseline_id: The ID of the patch baseline.
        :param pulumi.Input[str] patch_baseline_name: The name of the patch baseline.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DefaultPatchBaselineState.__new__(_DefaultPatchBaselineState)

        __props__.__dict__["patch_baseline_id"] = patch_baseline_id
        __props__.__dict__["patch_baseline_name"] = patch_baseline_name
        return DefaultPatchBaseline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="patchBaselineId")
    def patch_baseline_id(self) -> pulumi.Output[str]:
        """
        The ID of the patch baseline.
        """
        return pulumi.get(self, "patch_baseline_id")

    @property
    @pulumi.getter(name="patchBaselineName")
    def patch_baseline_name(self) -> pulumi.Output[str]:
        """
        The name of the patch baseline.
        """
        return pulumi.get(self, "patch_baseline_name")

