# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'BucketAccessMonitorArgs',
    'BucketCorsRuleArgs',
    'BucketLifecycleRuleArgs',
    'BucketLifecycleRuleAbortMultipartUploadArgs',
    'BucketLifecycleRuleExpirationArgs',
    'BucketLifecycleRuleFilterArgs',
    'BucketLifecycleRuleFilterNotArgs',
    'BucketLifecycleRuleFilterNotTagArgs',
    'BucketLifecycleRuleNoncurrentVersionExpirationArgs',
    'BucketLifecycleRuleNoncurrentVersionTransitionArgs',
    'BucketLifecycleRuleTransitionArgs',
    'BucketLoggingArgs',
    'BucketRefererConfigArgs',
    'BucketReplicationDestinationArgs',
    'BucketReplicationEncryptionConfigurationArgs',
    'BucketReplicationPrefixSetArgs',
    'BucketReplicationProgressArgs',
    'BucketReplicationSourceSelectionCriteriaArgs',
    'BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjectsArgs',
    'BucketServerSideEncryptionRuleArgs',
    'BucketTransferAccelerationArgs',
    'BucketVersioningArgs',
    'BucketWebsiteArgs',
]

@pulumi.input_type
class BucketAccessMonitorArgs:
    def __init__(__self__, *,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] status: The access monitor state of a bucket. If you want to manage objects based on the last access time of the objects, specifies the status to `Enabled`. Valid values: `Enabled` and `Disabled`.
        """
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The access monitor state of a bucket. If you want to manage objects based on the last access time of the objects, specifies the status to `Enabled`. Valid values: `Enabled` and `Disabled`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class BucketCorsRuleArgs:
    def __init__(__self__, *,
                 allowed_methods: pulumi.Input[Sequence[pulumi.Input[str]]],
                 allowed_origins: pulumi.Input[Sequence[pulumi.Input[str]]],
                 allowed_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 expose_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_age_seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_methods: Specifies which methods are allowed. Can be GET, PUT, POST, DELETE or HEAD.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: Specifies which origins are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_headers: Specifies which headers are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] expose_headers: Specifies expose header in the response.
        :param pulumi.Input[int] max_age_seconds: Specifies time in seconds that browser can cache the response for a preflight request.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies which methods are allowed. Can be GET, PUT, POST, DELETE or HEAD.
        """
        return pulumi.get(self, "allowed_methods")

    @allowed_methods.setter
    def allowed_methods(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_methods", value)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies which origins are allowed.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_origins", value)

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies which headers are allowed.
        """
        return pulumi.get(self, "allowed_headers")

    @allowed_headers.setter
    def allowed_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_headers", value)

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies expose header in the response.
        """
        return pulumi.get(self, "expose_headers")

    @expose_headers.setter
    def expose_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "expose_headers", value)

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies time in seconds that browser can cache the response for a preflight request.
        """
        return pulumi.get(self, "max_age_seconds")

    @max_age_seconds.setter
    def max_age_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_age_seconds", value)


@pulumi.input_type
class BucketLifecycleRuleArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 abort_multipart_uploads: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleAbortMultipartUploadArgs']]]] = None,
                 expirations: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleExpirationArgs']]]] = None,
                 filter: Optional[pulumi.Input['BucketLifecycleRuleFilterArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 noncurrent_version_expirations: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleNoncurrentVersionExpirationArgs']]]] = None,
                 noncurrent_version_transitions: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleNoncurrentVersionTransitionArgs']]]] = None,
                 prefix: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 transitions: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleTransitionArgs']]]] = None):
        """
        :param pulumi.Input[bool] enabled: Specifies lifecycle rule status.
        :param pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleAbortMultipartUploadArgs']]] abort_multipart_uploads: Specifies the number of days after initiating a multipart upload when the multipart upload must be completed. See `abort_multipart_upload` below.
        :param pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleExpirationArgs']]] expirations: Specifies a period in the object's expire. See `expiration` below.
        :param pulumi.Input['BucketLifecycleRuleFilterArgs'] filter: Configuration block used to identify objects that a Lifecycle rule applies to. See `filter` below.
               
               `NOTE`: At least one of expiration, transitions, abort_multipart_upload, noncurrent_version_expiration and noncurrent_version_transition should be configured.
        :param pulumi.Input[str] id: Unique identifier for the rule. If omitted, OSS bucket will assign a unique name.
        :param pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleNoncurrentVersionExpirationArgs']]] noncurrent_version_expirations: Specifies when noncurrent object versions expire. See `noncurrent_version_expiration` below.
        :param pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleNoncurrentVersionTransitionArgs']]] noncurrent_version_transitions: Specifies when noncurrent object versions transitions. See `noncurrent_version_transition` below.
        :param pulumi.Input[str] prefix: The prefix in the names of the objects to which the lifecycle rule does not apply.
        :param pulumi.Input[Mapping[str, Any]] tags: Key-value map of resource tags. All of these tags must exist in the object's tag set in order for the rule to apply.
        :param pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleTransitionArgs']]] transitions: Specifies the time when an object is converted to the IA or archive storage class during a valid life cycle. See `transitions` below.
        """
        pulumi.set(__self__, "enabled", enabled)
        if abort_multipart_uploads is not None:
            pulumi.set(__self__, "abort_multipart_uploads", abort_multipart_uploads)
        if expirations is not None:
            pulumi.set(__self__, "expirations", expirations)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if noncurrent_version_expirations is not None:
            pulumi.set(__self__, "noncurrent_version_expirations", noncurrent_version_expirations)
        if noncurrent_version_transitions is not None:
            pulumi.set(__self__, "noncurrent_version_transitions", noncurrent_version_transitions)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Specifies lifecycle rule status.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="abortMultipartUploads")
    def abort_multipart_uploads(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleAbortMultipartUploadArgs']]]]:
        """
        Specifies the number of days after initiating a multipart upload when the multipart upload must be completed. See `abort_multipart_upload` below.
        """
        return pulumi.get(self, "abort_multipart_uploads")

    @abort_multipart_uploads.setter
    def abort_multipart_uploads(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleAbortMultipartUploadArgs']]]]):
        pulumi.set(self, "abort_multipart_uploads", value)

    @property
    @pulumi.getter
    def expirations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleExpirationArgs']]]]:
        """
        Specifies a period in the object's expire. See `expiration` below.
        """
        return pulumi.get(self, "expirations")

    @expirations.setter
    def expirations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleExpirationArgs']]]]):
        pulumi.set(self, "expirations", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['BucketLifecycleRuleFilterArgs']]:
        """
        Configuration block used to identify objects that a Lifecycle rule applies to. See `filter` below.

        `NOTE`: At least one of expiration, transitions, abort_multipart_upload, noncurrent_version_expiration and noncurrent_version_transition should be configured.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['BucketLifecycleRuleFilterArgs']]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier for the rule. If omitted, OSS bucket will assign a unique name.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="noncurrentVersionExpirations")
    def noncurrent_version_expirations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleNoncurrentVersionExpirationArgs']]]]:
        """
        Specifies when noncurrent object versions expire. See `noncurrent_version_expiration` below.
        """
        return pulumi.get(self, "noncurrent_version_expirations")

    @noncurrent_version_expirations.setter
    def noncurrent_version_expirations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleNoncurrentVersionExpirationArgs']]]]):
        pulumi.set(self, "noncurrent_version_expirations", value)

    @property
    @pulumi.getter(name="noncurrentVersionTransitions")
    def noncurrent_version_transitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleNoncurrentVersionTransitionArgs']]]]:
        """
        Specifies when noncurrent object versions transitions. See `noncurrent_version_transition` below.
        """
        return pulumi.get(self, "noncurrent_version_transitions")

    @noncurrent_version_transitions.setter
    def noncurrent_version_transitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleNoncurrentVersionTransitionArgs']]]]):
        pulumi.set(self, "noncurrent_version_transitions", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The prefix in the names of the objects to which the lifecycle rule does not apply.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Key-value map of resource tags. All of these tags must exist in the object's tag set in order for the rule to apply.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def transitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleTransitionArgs']]]]:
        """
        Specifies the time when an object is converted to the IA or archive storage class during a valid life cycle. See `transitions` below.
        """
        return pulumi.get(self, "transitions")

    @transitions.setter
    def transitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleTransitionArgs']]]]):
        pulumi.set(self, "transitions", value)


@pulumi.input_type
class BucketLifecycleRuleAbortMultipartUploadArgs:
    def __init__(__self__, *,
                 created_before_date: Optional[pulumi.Input[str]] = None,
                 days: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] created_before_date: Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
        :param pulumi.Input[int] days: Specifies the number of days noncurrent object versions transition.
        """
        if created_before_date is not None:
            pulumi.set(__self__, "created_before_date", created_before_date)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter(name="createdBeforeDate")
    def created_before_date(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
        """
        return pulumi.get(self, "created_before_date")

    @created_before_date.setter
    def created_before_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_before_date", value)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of days noncurrent object versions transition.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)


@pulumi.input_type
class BucketLifecycleRuleExpirationArgs:
    def __init__(__self__, *,
                 created_before_date: Optional[pulumi.Input[str]] = None,
                 date: Optional[pulumi.Input[str]] = None,
                 days: Optional[pulumi.Input[int]] = None,
                 expired_object_delete_marker: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] created_before_date: Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
        :param pulumi.Input[str] date: Specifies the date after which you want the corresponding action to take effect. The value obeys ISO8601 format like `2017-03-09`.
        :param pulumi.Input[int] days: Specifies the number of days noncurrent object versions transition.
        :param pulumi.Input[bool] expired_object_delete_marker: On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct OSS to delete expired object delete markers. This cannot be specified with Days, Date or CreatedBeforeDate in a Lifecycle Expiration Policy.
               
               `NOTE`: One and only one of "date", "days", "created_before_date" and "expired_object_delete_marker" can be specified in one expiration configuration.
        """
        if created_before_date is not None:
            pulumi.set(__self__, "created_before_date", created_before_date)
        if date is not None:
            pulumi.set(__self__, "date", date)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if expired_object_delete_marker is not None:
            pulumi.set(__self__, "expired_object_delete_marker", expired_object_delete_marker)

    @property
    @pulumi.getter(name="createdBeforeDate")
    def created_before_date(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
        """
        return pulumi.get(self, "created_before_date")

    @created_before_date.setter
    def created_before_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_before_date", value)

    @property
    @pulumi.getter
    def date(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the date after which you want the corresponding action to take effect. The value obeys ISO8601 format like `2017-03-09`.
        """
        return pulumi.get(self, "date")

    @date.setter
    def date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date", value)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of days noncurrent object versions transition.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter(name="expiredObjectDeleteMarker")
    def expired_object_delete_marker(self) -> Optional[pulumi.Input[bool]]:
        """
        On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct OSS to delete expired object delete markers. This cannot be specified with Days, Date or CreatedBeforeDate in a Lifecycle Expiration Policy.

        `NOTE`: One and only one of "date", "days", "created_before_date" and "expired_object_delete_marker" can be specified in one expiration configuration.
        """
        return pulumi.get(self, "expired_object_delete_marker")

    @expired_object_delete_marker.setter
    def expired_object_delete_marker(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "expired_object_delete_marker", value)


@pulumi.input_type
class BucketLifecycleRuleFilterArgs:
    def __init__(__self__, *,
                 not_: Optional[pulumi.Input['BucketLifecycleRuleFilterNotArgs']] = None,
                 object_size_greater_than: Optional[pulumi.Input[int]] = None,
                 object_size_less_than: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['BucketLifecycleRuleFilterNotArgs'] not_: The condition that is matched by objects to which the lifecycle rule does not apply. See `not` below.
        :param pulumi.Input[int] object_size_greater_than: Minimum object size (in bytes) to which the rule applies.
        :param pulumi.Input[int] object_size_less_than: Maximum object size (in bytes) to which the rule applies.
        """
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if object_size_greater_than is not None:
            pulumi.set(__self__, "object_size_greater_than", object_size_greater_than)
        if object_size_less_than is not None:
            pulumi.set(__self__, "object_size_less_than", object_size_less_than)

    @property
    @pulumi.getter(name="not")
    def not_(self) -> Optional[pulumi.Input['BucketLifecycleRuleFilterNotArgs']]:
        """
        The condition that is matched by objects to which the lifecycle rule does not apply. See `not` below.
        """
        return pulumi.get(self, "not_")

    @not_.setter
    def not_(self, value: Optional[pulumi.Input['BucketLifecycleRuleFilterNotArgs']]):
        pulumi.set(self, "not_", value)

    @property
    @pulumi.getter(name="objectSizeGreaterThan")
    def object_size_greater_than(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum object size (in bytes) to which the rule applies.
        """
        return pulumi.get(self, "object_size_greater_than")

    @object_size_greater_than.setter
    def object_size_greater_than(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "object_size_greater_than", value)

    @property
    @pulumi.getter(name="objectSizeLessThan")
    def object_size_less_than(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum object size (in bytes) to which the rule applies.
        """
        return pulumi.get(self, "object_size_less_than")

    @object_size_less_than.setter
    def object_size_less_than(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "object_size_less_than", value)


@pulumi.input_type
class BucketLifecycleRuleFilterNotArgs:
    def __init__(__self__, *,
                 prefix: Optional[pulumi.Input[str]] = None,
                 tag: Optional[pulumi.Input['BucketLifecycleRuleFilterNotTagArgs']] = None):
        """
        :param pulumi.Input[str] prefix: The prefix in the names of the objects to which the lifecycle rule does not apply.
        :param pulumi.Input['BucketLifecycleRuleFilterNotTagArgs'] tag: The tag of the objects to which the lifecycle rule does not apply. See `tag` below.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The prefix in the names of the objects to which the lifecycle rule does not apply.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input['BucketLifecycleRuleFilterNotTagArgs']]:
        """
        The tag of the objects to which the lifecycle rule does not apply. See `tag` below.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input['BucketLifecycleRuleFilterNotTagArgs']]):
        pulumi.set(self, "tag", value)


@pulumi.input_type
class BucketLifecycleRuleFilterNotTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: The key of the tag that is specified for the objects.
        :param pulumi.Input[str] value: The value of the tag that is specified for the objects.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key of the tag that is specified for the objects.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the tag that is specified for the objects.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class BucketLifecycleRuleNoncurrentVersionExpirationArgs:
    def __init__(__self__, *,
                 days: pulumi.Input[int]):
        """
        :param pulumi.Input[int] days: Specifies the number of days noncurrent object versions transition.
        """
        pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> pulumi.Input[int]:
        """
        Specifies the number of days noncurrent object versions transition.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: pulumi.Input[int]):
        pulumi.set(self, "days", value)


@pulumi.input_type
class BucketLifecycleRuleNoncurrentVersionTransitionArgs:
    def __init__(__self__, *,
                 days: pulumi.Input[int],
                 storage_class: pulumi.Input[str],
                 is_access_time: Optional[pulumi.Input[bool]] = None,
                 return_to_std_when_visit: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[int] days: Specifies the number of days noncurrent object versions transition.
        :param pulumi.Input[str] storage_class: The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
        :param pulumi.Input[bool] is_access_time: Specifies whether the lifecycle rule applies to objects based on their last access time. If set to `true`, the rule applies to objects based on their last access time; if set to `false`, the rule applies to objects based on their last modified time. If configure the rule based on the last access time, please enable `access_monitor` first.
        :param pulumi.Input[bool] return_to_std_when_visit: Specifies whether to convert the storage class of non-Standard objects back to Standard after the objects are accessed. It takes effect only when the IsAccessTime parameter is set to true. If set to `true`, converts the storage class of the objects to Standard; if set to `false`, does not convert the storage class of the objects to Standard.
        """
        pulumi.set(__self__, "days", days)
        pulumi.set(__self__, "storage_class", storage_class)
        if is_access_time is not None:
            pulumi.set(__self__, "is_access_time", is_access_time)
        if return_to_std_when_visit is not None:
            pulumi.set(__self__, "return_to_std_when_visit", return_to_std_when_visit)

    @property
    @pulumi.getter
    def days(self) -> pulumi.Input[int]:
        """
        Specifies the number of days noncurrent object versions transition.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: pulumi.Input[int]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> pulumi.Input[str]:
        """
        The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_class", value)

    @property
    @pulumi.getter(name="isAccessTime")
    def is_access_time(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the lifecycle rule applies to objects based on their last access time. If set to `true`, the rule applies to objects based on their last access time; if set to `false`, the rule applies to objects based on their last modified time. If configure the rule based on the last access time, please enable `access_monitor` first.
        """
        return pulumi.get(self, "is_access_time")

    @is_access_time.setter
    def is_access_time(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_access_time", value)

    @property
    @pulumi.getter(name="returnToStdWhenVisit")
    def return_to_std_when_visit(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to convert the storage class of non-Standard objects back to Standard after the objects are accessed. It takes effect only when the IsAccessTime parameter is set to true. If set to `true`, converts the storage class of the objects to Standard; if set to `false`, does not convert the storage class of the objects to Standard.
        """
        return pulumi.get(self, "return_to_std_when_visit")

    @return_to_std_when_visit.setter
    def return_to_std_when_visit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "return_to_std_when_visit", value)


@pulumi.input_type
class BucketLifecycleRuleTransitionArgs:
    def __init__(__self__, *,
                 storage_class: pulumi.Input[str],
                 created_before_date: Optional[pulumi.Input[str]] = None,
                 days: Optional[pulumi.Input[int]] = None,
                 is_access_time: Optional[pulumi.Input[bool]] = None,
                 return_to_std_when_visit: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] storage_class: The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
        :param pulumi.Input[str] created_before_date: Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
        :param pulumi.Input[int] days: Specifies the number of days noncurrent object versions transition.
        :param pulumi.Input[bool] is_access_time: Specifies whether the lifecycle rule applies to objects based on their last access time. If set to `true`, the rule applies to objects based on their last access time; if set to `false`, the rule applies to objects based on their last modified time. If configure the rule based on the last access time, please enable `access_monitor` first.
        :param pulumi.Input[bool] return_to_std_when_visit: Specifies whether to convert the storage class of non-Standard objects back to Standard after the objects are accessed. It takes effect only when the IsAccessTime parameter is set to true. If set to `true`, converts the storage class of the objects to Standard; if set to `false`, does not convert the storage class of the objects to Standard.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        if created_before_date is not None:
            pulumi.set(__self__, "created_before_date", created_before_date)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if is_access_time is not None:
            pulumi.set(__self__, "is_access_time", is_access_time)
        if return_to_std_when_visit is not None:
            pulumi.set(__self__, "return_to_std_when_visit", return_to_std_when_visit)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> pulumi.Input[str]:
        """
        The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_class", value)

    @property
    @pulumi.getter(name="createdBeforeDate")
    def created_before_date(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
        """
        return pulumi.get(self, "created_before_date")

    @created_before_date.setter
    def created_before_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_before_date", value)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of days noncurrent object versions transition.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter(name="isAccessTime")
    def is_access_time(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the lifecycle rule applies to objects based on their last access time. If set to `true`, the rule applies to objects based on their last access time; if set to `false`, the rule applies to objects based on their last modified time. If configure the rule based on the last access time, please enable `access_monitor` first.
        """
        return pulumi.get(self, "is_access_time")

    @is_access_time.setter
    def is_access_time(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_access_time", value)

    @property
    @pulumi.getter(name="returnToStdWhenVisit")
    def return_to_std_when_visit(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to convert the storage class of non-Standard objects back to Standard after the objects are accessed. It takes effect only when the IsAccessTime parameter is set to true. If set to `true`, converts the storage class of the objects to Standard; if set to `false`, does not convert the storage class of the objects to Standard.
        """
        return pulumi.get(self, "return_to_std_when_visit")

    @return_to_std_when_visit.setter
    def return_to_std_when_visit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "return_to_std_when_visit", value)


@pulumi.input_type
class BucketLoggingArgs:
    def __init__(__self__, *,
                 target_bucket: pulumi.Input[str],
                 target_prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] target_bucket: The name of the bucket that will receive the log objects.
        :param pulumi.Input[str] target_prefix: To specify a key prefix for log objects.
        """
        pulumi.set(__self__, "target_bucket", target_bucket)
        if target_prefix is not None:
            pulumi.set(__self__, "target_prefix", target_prefix)

    @property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> pulumi.Input[str]:
        """
        The name of the bucket that will receive the log objects.
        """
        return pulumi.get(self, "target_bucket")

    @target_bucket.setter
    def target_bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_bucket", value)

    @property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        To specify a key prefix for log objects.
        """
        return pulumi.get(self, "target_prefix")

    @target_prefix.setter
    def target_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_prefix", value)


@pulumi.input_type
class BucketRefererConfigArgs:
    def __init__(__self__, *,
                 referers: pulumi.Input[Sequence[pulumi.Input[str]]],
                 allow_empty: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] referers: The list of referer.
        :param pulumi.Input[bool] allow_empty: Allows referer to be empty. Defaults false.
        """
        pulumi.set(__self__, "referers", referers)
        if allow_empty is not None:
            pulumi.set(__self__, "allow_empty", allow_empty)

    @property
    @pulumi.getter
    def referers(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of referer.
        """
        return pulumi.get(self, "referers")

    @referers.setter
    def referers(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "referers", value)

    @property
    @pulumi.getter(name="allowEmpty")
    def allow_empty(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows referer to be empty. Defaults false.
        """
        return pulumi.get(self, "allow_empty")

    @allow_empty.setter
    def allow_empty(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_empty", value)


@pulumi.input_type
class BucketReplicationDestinationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 location: pulumi.Input[str],
                 transfer_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: The destination bucket to which the data is replicated.
        :param pulumi.Input[str] transfer_type: The link used to transfer data in data replication.. Can be `internal` or `oss_acc`. Defaults to `internal`.
               
               `NOTE`: You can set transfer_type to oss_acc only when you create cross-region replication (CRR) rules.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "location", location)
        if transfer_type is not None:
            pulumi.set(__self__, "transfer_type", transfer_type)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        The destination bucket to which the data is replicated.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="transferType")
    def transfer_type(self) -> Optional[pulumi.Input[str]]:
        """
        The link used to transfer data in data replication.. Can be `internal` or `oss_acc`. Defaults to `internal`.

        `NOTE`: You can set transfer_type to oss_acc only when you create cross-region replication (CRR) rules.
        """
        return pulumi.get(self, "transfer_type")

    @transfer_type.setter
    def transfer_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transfer_type", value)


@pulumi.input_type
class BucketReplicationEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 replica_kms_key_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] replica_kms_key_id: The CMK ID used in SSE-KMS.
               
               `NOTE`: If the status of sse_kms_encrypted_objects is set to Enabled, you must specify the replica_kms_key_id.
        """
        pulumi.set(__self__, "replica_kms_key_id", replica_kms_key_id)

    @property
    @pulumi.getter(name="replicaKmsKeyId")
    def replica_kms_key_id(self) -> pulumi.Input[str]:
        """
        The CMK ID used in SSE-KMS.

        `NOTE`: If the status of sse_kms_encrypted_objects is set to Enabled, you must specify the replica_kms_key_id.
        """
        return pulumi.get(self, "replica_kms_key_id")

    @replica_kms_key_id.setter
    def replica_kms_key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "replica_kms_key_id", value)


@pulumi.input_type
class BucketReplicationPrefixSetArgs:
    def __init__(__self__, *,
                 prefixes: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prefixes: The list of object key name prefix identifying one or more objects to which the rule applies.
               
               `NOTE`: The prefix must be less than or equal to 1024 characters in length.
        """
        pulumi.set(__self__, "prefixes", prefixes)

    @property
    @pulumi.getter
    def prefixes(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of object key name prefix identifying one or more objects to which the rule applies.

        `NOTE`: The prefix must be less than or equal to 1024 characters in length.
        """
        return pulumi.get(self, "prefixes")

    @prefixes.setter
    def prefixes(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "prefixes", value)


@pulumi.input_type
class BucketReplicationProgressArgs:
    def __init__(__self__, *,
                 historical_object: Optional[pulumi.Input[str]] = None,
                 new_object: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] historical_object: The percentage of the replicated historical data. This element is valid only when historical_object_replication is set to enabled.
        :param pulumi.Input[str] new_object: The time used to distinguish new data from historical data. Data that is written to the source bucket before the time is replicated to the destination bucket as new data. The value of this element is in GMT.
        """
        if historical_object is not None:
            pulumi.set(__self__, "historical_object", historical_object)
        if new_object is not None:
            pulumi.set(__self__, "new_object", new_object)

    @property
    @pulumi.getter(name="historicalObject")
    def historical_object(self) -> Optional[pulumi.Input[str]]:
        """
        The percentage of the replicated historical data. This element is valid only when historical_object_replication is set to enabled.
        """
        return pulumi.get(self, "historical_object")

    @historical_object.setter
    def historical_object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "historical_object", value)

    @property
    @pulumi.getter(name="newObject")
    def new_object(self) -> Optional[pulumi.Input[str]]:
        """
        The time used to distinguish new data from historical data. Data that is written to the source bucket before the time is replicated to the destination bucket as new data. The value of this element is in GMT.
        """
        return pulumi.get(self, "new_object")

    @new_object.setter
    def new_object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "new_object", value)


@pulumi.input_type
class BucketReplicationSourceSelectionCriteriaArgs:
    def __init__(__self__, *,
                 sse_kms_encrypted_objects: Optional[pulumi.Input['BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjectsArgs']] = None):
        """
        :param pulumi.Input['BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjectsArgs'] sse_kms_encrypted_objects: Filter source objects encrypted by using SSE-KMS(See the following block `sse_kms_encrypted_objects`).
        """
        if sse_kms_encrypted_objects is not None:
            pulumi.set(__self__, "sse_kms_encrypted_objects", sse_kms_encrypted_objects)

    @property
    @pulumi.getter(name="sseKmsEncryptedObjects")
    def sse_kms_encrypted_objects(self) -> Optional[pulumi.Input['BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjectsArgs']]:
        """
        Filter source objects encrypted by using SSE-KMS(See the following block `sse_kms_encrypted_objects`).
        """
        return pulumi.get(self, "sse_kms_encrypted_objects")

    @sse_kms_encrypted_objects.setter
    def sse_kms_encrypted_objects(self, value: Optional[pulumi.Input['BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjectsArgs']]):
        pulumi.set(self, "sse_kms_encrypted_objects", value)


@pulumi.input_type
class BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjectsArgs:
    def __init__(__self__, *,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] status: Specifies whether to replicate objects encrypted by using SSE-KMS. Can be `Enabled` or `Disabled`.
        """
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to replicate objects encrypted by using SSE-KMS. Can be `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class BucketServerSideEncryptionRuleArgs:
    def __init__(__self__, *,
                 sse_algorithm: pulumi.Input[str],
                 kms_master_key_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] sse_algorithm: The server-side encryption algorithm to use. Possible values: `AES256` and `KMS`.
        :param pulumi.Input[str] kms_master_key_id: The alibaba cloud KMS master key ID used for the SSE-KMS encryption.
        """
        pulumi.set(__self__, "sse_algorithm", sse_algorithm)
        if kms_master_key_id is not None:
            pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)

    @property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> pulumi.Input[str]:
        """
        The server-side encryption algorithm to use. Possible values: `AES256` and `KMS`.
        """
        return pulumi.get(self, "sse_algorithm")

    @sse_algorithm.setter
    def sse_algorithm(self, value: pulumi.Input[str]):
        pulumi.set(self, "sse_algorithm", value)

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The alibaba cloud KMS master key ID used for the SSE-KMS encryption.
        """
        return pulumi.get(self, "kms_master_key_id")

    @kms_master_key_id.setter
    def kms_master_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_master_key_id", value)


@pulumi.input_type
class BucketTransferAccelerationArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool]):
        """
        :param pulumi.Input[bool] enabled: Specifies the accelerate status of a bucket.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Specifies the accelerate status of a bucket.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class BucketVersioningArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[str]):
        """
        :param pulumi.Input[str] status: Specifies the versioning state of a bucket. Valid values: `Enabled` and `Suspended`.
        """
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        """
        Specifies the versioning state of a bucket. Valid values: `Enabled` and `Suspended`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class BucketWebsiteArgs:
    def __init__(__self__, *,
                 index_document: pulumi.Input[str],
                 error_document: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] index_document: Alicloud OSS returns this index document when requests are made to the root domain or any of the subfolders.
        :param pulumi.Input[str] error_document: An absolute path to the document to return in case of a 4XX error.
        """
        pulumi.set(__self__, "index_document", index_document)
        if error_document is not None:
            pulumi.set(__self__, "error_document", error_document)

    @property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> pulumi.Input[str]:
        """
        Alicloud OSS returns this index document when requests are made to the root domain or any of the subfolders.
        """
        return pulumi.get(self, "index_document")

    @index_document.setter
    def index_document(self, value: pulumi.Input[str]):
        pulumi.set(self, "index_document", value)

    @property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> Optional[pulumi.Input[str]]:
        """
        An absolute path to the document to return in case of a 4XX error.
        """
        return pulumi.get(self, "error_document")

    @error_document.setter
    def error_document(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error_document", value)


