# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BucketReplicationArgs', 'BucketReplication']

@pulumi.input_type
class BucketReplicationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 destination: pulumi.Input['BucketReplicationDestinationArgs'],
                 action: Optional[pulumi.Input[str]] = None,
                 encryption_configuration: Optional[pulumi.Input['BucketReplicationEncryptionConfigurationArgs']] = None,
                 historical_object_replication: Optional[pulumi.Input[str]] = None,
                 prefix_set: Optional[pulumi.Input['BucketReplicationPrefixSetArgs']] = None,
                 progress: Optional[pulumi.Input['BucketReplicationProgressArgs']] = None,
                 source_selection_criteria: Optional[pulumi.Input['BucketReplicationSourceSelectionCriteriaArgs']] = None,
                 sync_role: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a BucketReplication resource.
        :param pulumi.Input[str] bucket: The name of the bucket.
        :param pulumi.Input['BucketReplicationDestinationArgs'] destination: Specifies the destination for the rule(See the following block `destination`).
        :param pulumi.Input[str] action: The operations that can be synchronized to the destination bucket. You can set action to one or more of the following operation types. Valid values: `ALL`(contains PUT, DELETE, and ABORT), `PUT`, `DELETE` and `ABORT`. Defaults to `ALL`.
        :param pulumi.Input['BucketReplicationEncryptionConfigurationArgs'] encryption_configuration: Specifies the encryption configuration for the objects replicated to the destination bucket(See the following block `encryption_configuration`).
        :param pulumi.Input[str] historical_object_replication: Specifies whether to replicate historical data from the source bucket to the destination bucket before data replication is enabled. Can be `enabled` or `disabled`. Defaults to `enabled`.
        :param pulumi.Input['BucketReplicationPrefixSetArgs'] prefix_set: The prefixes used to specify the object to replicate. Only objects that match the prefix are replicated to the destination bucket(See the following block `prefix_set`).
        :param pulumi.Input['BucketReplicationProgressArgs'] progress: Retrieves the progress of the data replication task. This status is returned only when the data replication task is in the doing state.
        :param pulumi.Input['BucketReplicationSourceSelectionCriteriaArgs'] source_selection_criteria: Specifies other conditions used to filter the source objects to replicate(See the following block `source_selection_criteria`).
        :param pulumi.Input[str] sync_role: Specifies the role that you authorize OSS to use to replicate data. If SSE-KMS is specified to encrypt the objects replicated to the destination bucket, it must be specified.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "destination", destination)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if historical_object_replication is not None:
            pulumi.set(__self__, "historical_object_replication", historical_object_replication)
        if prefix_set is not None:
            pulumi.set(__self__, "prefix_set", prefix_set)
        if progress is not None:
            pulumi.set(__self__, "progress", progress)
        if source_selection_criteria is not None:
            pulumi.set(__self__, "source_selection_criteria", source_selection_criteria)
        if sync_role is not None:
            pulumi.set(__self__, "sync_role", sync_role)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input['BucketReplicationDestinationArgs']:
        """
        Specifies the destination for the rule(See the following block `destination`).
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['BucketReplicationDestinationArgs']):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The operations that can be synchronized to the destination bucket. You can set action to one or more of the following operation types. Valid values: `ALL`(contains PUT, DELETE, and ABORT), `PUT`, `DELETE` and `ABORT`. Defaults to `ALL`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['BucketReplicationEncryptionConfigurationArgs']]:
        """
        Specifies the encryption configuration for the objects replicated to the destination bucket(See the following block `encryption_configuration`).
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['BucketReplicationEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @property
    @pulumi.getter(name="historicalObjectReplication")
    def historical_object_replication(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to replicate historical data from the source bucket to the destination bucket before data replication is enabled. Can be `enabled` or `disabled`. Defaults to `enabled`.
        """
        return pulumi.get(self, "historical_object_replication")

    @historical_object_replication.setter
    def historical_object_replication(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "historical_object_replication", value)

    @property
    @pulumi.getter(name="prefixSet")
    def prefix_set(self) -> Optional[pulumi.Input['BucketReplicationPrefixSetArgs']]:
        """
        The prefixes used to specify the object to replicate. Only objects that match the prefix are replicated to the destination bucket(See the following block `prefix_set`).
        """
        return pulumi.get(self, "prefix_set")

    @prefix_set.setter
    def prefix_set(self, value: Optional[pulumi.Input['BucketReplicationPrefixSetArgs']]):
        pulumi.set(self, "prefix_set", value)

    @property
    @pulumi.getter
    def progress(self) -> Optional[pulumi.Input['BucketReplicationProgressArgs']]:
        """
        Retrieves the progress of the data replication task. This status is returned only when the data replication task is in the doing state.
        """
        return pulumi.get(self, "progress")

    @progress.setter
    def progress(self, value: Optional[pulumi.Input['BucketReplicationProgressArgs']]):
        pulumi.set(self, "progress", value)

    @property
    @pulumi.getter(name="sourceSelectionCriteria")
    def source_selection_criteria(self) -> Optional[pulumi.Input['BucketReplicationSourceSelectionCriteriaArgs']]:
        """
        Specifies other conditions used to filter the source objects to replicate(See the following block `source_selection_criteria`).
        """
        return pulumi.get(self, "source_selection_criteria")

    @source_selection_criteria.setter
    def source_selection_criteria(self, value: Optional[pulumi.Input['BucketReplicationSourceSelectionCriteriaArgs']]):
        pulumi.set(self, "source_selection_criteria", value)

    @property
    @pulumi.getter(name="syncRole")
    def sync_role(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the role that you authorize OSS to use to replicate data. If SSE-KMS is specified to encrypt the objects replicated to the destination bucket, it must be specified.
        """
        return pulumi.get(self, "sync_role")

    @sync_role.setter
    def sync_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sync_role", value)


@pulumi.input_type
class _BucketReplicationState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input['BucketReplicationDestinationArgs']] = None,
                 encryption_configuration: Optional[pulumi.Input['BucketReplicationEncryptionConfigurationArgs']] = None,
                 historical_object_replication: Optional[pulumi.Input[str]] = None,
                 prefix_set: Optional[pulumi.Input['BucketReplicationPrefixSetArgs']] = None,
                 progress: Optional[pulumi.Input['BucketReplicationProgressArgs']] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 source_selection_criteria: Optional[pulumi.Input['BucketReplicationSourceSelectionCriteriaArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 sync_role: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering BucketReplication resources.
        :param pulumi.Input[str] action: The operations that can be synchronized to the destination bucket. You can set action to one or more of the following operation types. Valid values: `ALL`(contains PUT, DELETE, and ABORT), `PUT`, `DELETE` and `ABORT`. Defaults to `ALL`.
        :param pulumi.Input[str] bucket: The name of the bucket.
        :param pulumi.Input['BucketReplicationDestinationArgs'] destination: Specifies the destination for the rule(See the following block `destination`).
        :param pulumi.Input['BucketReplicationEncryptionConfigurationArgs'] encryption_configuration: Specifies the encryption configuration for the objects replicated to the destination bucket(See the following block `encryption_configuration`).
        :param pulumi.Input[str] historical_object_replication: Specifies whether to replicate historical data from the source bucket to the destination bucket before data replication is enabled. Can be `enabled` or `disabled`. Defaults to `enabled`.
        :param pulumi.Input['BucketReplicationPrefixSetArgs'] prefix_set: The prefixes used to specify the object to replicate. Only objects that match the prefix are replicated to the destination bucket(See the following block `prefix_set`).
        :param pulumi.Input['BucketReplicationProgressArgs'] progress: Retrieves the progress of the data replication task. This status is returned only when the data replication task is in the doing state.
        :param pulumi.Input[str] rule_id: The ID of the data replication rule.
        :param pulumi.Input['BucketReplicationSourceSelectionCriteriaArgs'] source_selection_criteria: Specifies other conditions used to filter the source objects to replicate(See the following block `source_selection_criteria`).
        :param pulumi.Input[str] status: Specifies whether to replicate objects encrypted by using SSE-KMS. Can be `Enabled` or `Disabled`.
        :param pulumi.Input[str] sync_role: Specifies the role that you authorize OSS to use to replicate data. If SSE-KMS is specified to encrypt the objects replicated to the destination bucket, it must be specified.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if historical_object_replication is not None:
            pulumi.set(__self__, "historical_object_replication", historical_object_replication)
        if prefix_set is not None:
            pulumi.set(__self__, "prefix_set", prefix_set)
        if progress is not None:
            pulumi.set(__self__, "progress", progress)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if source_selection_criteria is not None:
            pulumi.set(__self__, "source_selection_criteria", source_selection_criteria)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sync_role is not None:
            pulumi.set(__self__, "sync_role", sync_role)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The operations that can be synchronized to the destination bucket. You can set action to one or more of the following operation types. Valid values: `ALL`(contains PUT, DELETE, and ABORT), `PUT`, `DELETE` and `ABORT`. Defaults to `ALL`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['BucketReplicationDestinationArgs']]:
        """
        Specifies the destination for the rule(See the following block `destination`).
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['BucketReplicationDestinationArgs']]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['BucketReplicationEncryptionConfigurationArgs']]:
        """
        Specifies the encryption configuration for the objects replicated to the destination bucket(See the following block `encryption_configuration`).
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['BucketReplicationEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @property
    @pulumi.getter(name="historicalObjectReplication")
    def historical_object_replication(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to replicate historical data from the source bucket to the destination bucket before data replication is enabled. Can be `enabled` or `disabled`. Defaults to `enabled`.
        """
        return pulumi.get(self, "historical_object_replication")

    @historical_object_replication.setter
    def historical_object_replication(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "historical_object_replication", value)

    @property
    @pulumi.getter(name="prefixSet")
    def prefix_set(self) -> Optional[pulumi.Input['BucketReplicationPrefixSetArgs']]:
        """
        The prefixes used to specify the object to replicate. Only objects that match the prefix are replicated to the destination bucket(See the following block `prefix_set`).
        """
        return pulumi.get(self, "prefix_set")

    @prefix_set.setter
    def prefix_set(self, value: Optional[pulumi.Input['BucketReplicationPrefixSetArgs']]):
        pulumi.set(self, "prefix_set", value)

    @property
    @pulumi.getter
    def progress(self) -> Optional[pulumi.Input['BucketReplicationProgressArgs']]:
        """
        Retrieves the progress of the data replication task. This status is returned only when the data replication task is in the doing state.
        """
        return pulumi.get(self, "progress")

    @progress.setter
    def progress(self, value: Optional[pulumi.Input['BucketReplicationProgressArgs']]):
        pulumi.set(self, "progress", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the data replication rule.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="sourceSelectionCriteria")
    def source_selection_criteria(self) -> Optional[pulumi.Input['BucketReplicationSourceSelectionCriteriaArgs']]:
        """
        Specifies other conditions used to filter the source objects to replicate(See the following block `source_selection_criteria`).
        """
        return pulumi.get(self, "source_selection_criteria")

    @source_selection_criteria.setter
    def source_selection_criteria(self, value: Optional[pulumi.Input['BucketReplicationSourceSelectionCriteriaArgs']]):
        pulumi.set(self, "source_selection_criteria", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to replicate objects encrypted by using SSE-KMS. Can be `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="syncRole")
    def sync_role(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the role that you authorize OSS to use to replicate data. If SSE-KMS is specified to encrypt the objects replicated to the destination bucket, it must be specified.
        """
        return pulumi.get(self, "sync_role")

    @sync_role.setter
    def sync_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sync_role", value)


class BucketReplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[pulumi.InputType['BucketReplicationDestinationArgs']]] = None,
                 encryption_configuration: Optional[pulumi.Input[pulumi.InputType['BucketReplicationEncryptionConfigurationArgs']]] = None,
                 historical_object_replication: Optional[pulumi.Input[str]] = None,
                 prefix_set: Optional[pulumi.Input[pulumi.InputType['BucketReplicationPrefixSetArgs']]] = None,
                 progress: Optional[pulumi.Input[pulumi.InputType['BucketReplicationProgressArgs']]] = None,
                 source_selection_criteria: Optional[pulumi.Input[pulumi.InputType['BucketReplicationSourceSelectionCriteriaArgs']]] = None,
                 sync_role: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an independent replication configuration resource for OSS bucket.

        For information about OSS replication and how to use it, see [What is cross-region replication](https://www.alibabacloud.com/help/doc-detail/31864.html) and [What is same-region replication](https://www.alibabacloud.com/help/doc-detail/254865.html).

        > **NOTE:** Available in v1.161.0+.

        ## Example Usage

        Set bucket replication configuration

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.RandomInteger("default",
            max=99999,
            min=10000)
        bucket_src = alicloud.oss.Bucket("bucketSrc", bucket=default.result.apply(lambda result: f"example-src-{result}"))
        bucket_dest = alicloud.oss.Bucket("bucketDest", bucket=default.result.apply(lambda result: f"example-dest-{result}"))
        role = alicloud.ram.Role("role",
            document=\"\"\"		{
        		  "Statement": [
        			{
        			  "Action": "sts:AssumeRole",
        			  "Effect": "Allow",
        			  "Principal": {
        				"Service": [
        				  "oss.aliyuncs.com"
        				]
        			  }
        			}
        		  ],
        		  "Version": "1"
        		}
        \"\"\",
            description="this is a test",
            force=True)
        policy = alicloud.ram.Policy("policy",
            policy_name=default.result.apply(lambda result: f"example-policy-{result}"),
            policy_document=\"\"\"		{
        		  "Statement": [
        			{
        			  "Action": [
        				"*"
        			  ],
        			  "Effect": "Allow",
        			  "Resource": [
        				"*"
        			  ]
        			}
        		  ],
        			"Version": "1"
        		}
        \"\"\",
            description="this is a policy test",
            force=True)
        attach = alicloud.ram.RolePolicyAttachment("attach",
            policy_name=policy.name,
            policy_type=policy.type,
            role_name=role.name)
        key = alicloud.kms.Key("key",
            description="Hello KMS",
            pending_window_in_days=7,
            status="Enabled")
        cross_region_replication = alicloud.oss.BucketReplication("cross-region-replication",
            bucket=bucket_src.id,
            action="PUT,DELETE",
            historical_object_replication="enabled",
            prefix_set=alicloud.oss.BucketReplicationPrefixSetArgs(
                prefixes=[
                    "prefix1/",
                    "prefix2/",
                ],
            ),
            destination=alicloud.oss.BucketReplicationDestinationArgs(
                bucket=bucket_dest.id,
                location=bucket_dest.location,
            ),
            sync_role=role.name,
            encryption_configuration=alicloud.oss.BucketReplicationEncryptionConfigurationArgs(
                replica_kms_key_id=key.id,
            ),
            source_selection_criteria=alicloud.oss.BucketReplicationSourceSelectionCriteriaArgs(
                sse_kms_encrypted_objects=alicloud.oss.BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjectsArgs(
                    status="Enabled",
                ),
            ))
        ```

        ## Import

        ### Timeouts The `timeouts` block allows you to specify timeouts for certain actions* `delete` - (Defaults to 30 mins) Used when delete a data replication rule (until the data replication task is cleared).

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The operations that can be synchronized to the destination bucket. You can set action to one or more of the following operation types. Valid values: `ALL`(contains PUT, DELETE, and ABORT), `PUT`, `DELETE` and `ABORT`. Defaults to `ALL`.
        :param pulumi.Input[str] bucket: The name of the bucket.
        :param pulumi.Input[pulumi.InputType['BucketReplicationDestinationArgs']] destination: Specifies the destination for the rule(See the following block `destination`).
        :param pulumi.Input[pulumi.InputType['BucketReplicationEncryptionConfigurationArgs']] encryption_configuration: Specifies the encryption configuration for the objects replicated to the destination bucket(See the following block `encryption_configuration`).
        :param pulumi.Input[str] historical_object_replication: Specifies whether to replicate historical data from the source bucket to the destination bucket before data replication is enabled. Can be `enabled` or `disabled`. Defaults to `enabled`.
        :param pulumi.Input[pulumi.InputType['BucketReplicationPrefixSetArgs']] prefix_set: The prefixes used to specify the object to replicate. Only objects that match the prefix are replicated to the destination bucket(See the following block `prefix_set`).
        :param pulumi.Input[pulumi.InputType['BucketReplicationProgressArgs']] progress: Retrieves the progress of the data replication task. This status is returned only when the data replication task is in the doing state.
        :param pulumi.Input[pulumi.InputType['BucketReplicationSourceSelectionCriteriaArgs']] source_selection_criteria: Specifies other conditions used to filter the source objects to replicate(See the following block `source_selection_criteria`).
        :param pulumi.Input[str] sync_role: Specifies the role that you authorize OSS to use to replicate data. If SSE-KMS is specified to encrypt the objects replicated to the destination bucket, it must be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketReplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an independent replication configuration resource for OSS bucket.

        For information about OSS replication and how to use it, see [What is cross-region replication](https://www.alibabacloud.com/help/doc-detail/31864.html) and [What is same-region replication](https://www.alibabacloud.com/help/doc-detail/254865.html).

        > **NOTE:** Available in v1.161.0+.

        ## Example Usage

        Set bucket replication configuration

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.RandomInteger("default",
            max=99999,
            min=10000)
        bucket_src = alicloud.oss.Bucket("bucketSrc", bucket=default.result.apply(lambda result: f"example-src-{result}"))
        bucket_dest = alicloud.oss.Bucket("bucketDest", bucket=default.result.apply(lambda result: f"example-dest-{result}"))
        role = alicloud.ram.Role("role",
            document=\"\"\"		{
        		  "Statement": [
        			{
        			  "Action": "sts:AssumeRole",
        			  "Effect": "Allow",
        			  "Principal": {
        				"Service": [
        				  "oss.aliyuncs.com"
        				]
        			  }
        			}
        		  ],
        		  "Version": "1"
        		}
        \"\"\",
            description="this is a test",
            force=True)
        policy = alicloud.ram.Policy("policy",
            policy_name=default.result.apply(lambda result: f"example-policy-{result}"),
            policy_document=\"\"\"		{
        		  "Statement": [
        			{
        			  "Action": [
        				"*"
        			  ],
        			  "Effect": "Allow",
        			  "Resource": [
        				"*"
        			  ]
        			}
        		  ],
        			"Version": "1"
        		}
        \"\"\",
            description="this is a policy test",
            force=True)
        attach = alicloud.ram.RolePolicyAttachment("attach",
            policy_name=policy.name,
            policy_type=policy.type,
            role_name=role.name)
        key = alicloud.kms.Key("key",
            description="Hello KMS",
            pending_window_in_days=7,
            status="Enabled")
        cross_region_replication = alicloud.oss.BucketReplication("cross-region-replication",
            bucket=bucket_src.id,
            action="PUT,DELETE",
            historical_object_replication="enabled",
            prefix_set=alicloud.oss.BucketReplicationPrefixSetArgs(
                prefixes=[
                    "prefix1/",
                    "prefix2/",
                ],
            ),
            destination=alicloud.oss.BucketReplicationDestinationArgs(
                bucket=bucket_dest.id,
                location=bucket_dest.location,
            ),
            sync_role=role.name,
            encryption_configuration=alicloud.oss.BucketReplicationEncryptionConfigurationArgs(
                replica_kms_key_id=key.id,
            ),
            source_selection_criteria=alicloud.oss.BucketReplicationSourceSelectionCriteriaArgs(
                sse_kms_encrypted_objects=alicloud.oss.BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjectsArgs(
                    status="Enabled",
                ),
            ))
        ```

        ## Import

        ### Timeouts The `timeouts` block allows you to specify timeouts for certain actions* `delete` - (Defaults to 30 mins) Used when delete a data replication rule (until the data replication task is cleared).

        :param str resource_name: The name of the resource.
        :param BucketReplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketReplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[pulumi.InputType['BucketReplicationDestinationArgs']]] = None,
                 encryption_configuration: Optional[pulumi.Input[pulumi.InputType['BucketReplicationEncryptionConfigurationArgs']]] = None,
                 historical_object_replication: Optional[pulumi.Input[str]] = None,
                 prefix_set: Optional[pulumi.Input[pulumi.InputType['BucketReplicationPrefixSetArgs']]] = None,
                 progress: Optional[pulumi.Input[pulumi.InputType['BucketReplicationProgressArgs']]] = None,
                 source_selection_criteria: Optional[pulumi.Input[pulumi.InputType['BucketReplicationSourceSelectionCriteriaArgs']]] = None,
                 sync_role: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketReplicationArgs.__new__(BucketReplicationArgs)

            __props__.__dict__["action"] = action
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            __props__.__dict__["encryption_configuration"] = encryption_configuration
            __props__.__dict__["historical_object_replication"] = historical_object_replication
            __props__.__dict__["prefix_set"] = prefix_set
            __props__.__dict__["progress"] = progress
            __props__.__dict__["source_selection_criteria"] = source_selection_criteria
            __props__.__dict__["sync_role"] = sync_role
            __props__.__dict__["rule_id"] = None
            __props__.__dict__["status"] = None
        super(BucketReplication, __self__).__init__(
            'alicloud:oss/bucketReplication:BucketReplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[str]] = None,
            bucket: Optional[pulumi.Input[str]] = None,
            destination: Optional[pulumi.Input[pulumi.InputType['BucketReplicationDestinationArgs']]] = None,
            encryption_configuration: Optional[pulumi.Input[pulumi.InputType['BucketReplicationEncryptionConfigurationArgs']]] = None,
            historical_object_replication: Optional[pulumi.Input[str]] = None,
            prefix_set: Optional[pulumi.Input[pulumi.InputType['BucketReplicationPrefixSetArgs']]] = None,
            progress: Optional[pulumi.Input[pulumi.InputType['BucketReplicationProgressArgs']]] = None,
            rule_id: Optional[pulumi.Input[str]] = None,
            source_selection_criteria: Optional[pulumi.Input[pulumi.InputType['BucketReplicationSourceSelectionCriteriaArgs']]] = None,
            status: Optional[pulumi.Input[str]] = None,
            sync_role: Optional[pulumi.Input[str]] = None) -> 'BucketReplication':
        """
        Get an existing BucketReplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The operations that can be synchronized to the destination bucket. You can set action to one or more of the following operation types. Valid values: `ALL`(contains PUT, DELETE, and ABORT), `PUT`, `DELETE` and `ABORT`. Defaults to `ALL`.
        :param pulumi.Input[str] bucket: The name of the bucket.
        :param pulumi.Input[pulumi.InputType['BucketReplicationDestinationArgs']] destination: Specifies the destination for the rule(See the following block `destination`).
        :param pulumi.Input[pulumi.InputType['BucketReplicationEncryptionConfigurationArgs']] encryption_configuration: Specifies the encryption configuration for the objects replicated to the destination bucket(See the following block `encryption_configuration`).
        :param pulumi.Input[str] historical_object_replication: Specifies whether to replicate historical data from the source bucket to the destination bucket before data replication is enabled. Can be `enabled` or `disabled`. Defaults to `enabled`.
        :param pulumi.Input[pulumi.InputType['BucketReplicationPrefixSetArgs']] prefix_set: The prefixes used to specify the object to replicate. Only objects that match the prefix are replicated to the destination bucket(See the following block `prefix_set`).
        :param pulumi.Input[pulumi.InputType['BucketReplicationProgressArgs']] progress: Retrieves the progress of the data replication task. This status is returned only when the data replication task is in the doing state.
        :param pulumi.Input[str] rule_id: The ID of the data replication rule.
        :param pulumi.Input[pulumi.InputType['BucketReplicationSourceSelectionCriteriaArgs']] source_selection_criteria: Specifies other conditions used to filter the source objects to replicate(See the following block `source_selection_criteria`).
        :param pulumi.Input[str] status: Specifies whether to replicate objects encrypted by using SSE-KMS. Can be `Enabled` or `Disabled`.
        :param pulumi.Input[str] sync_role: Specifies the role that you authorize OSS to use to replicate data. If SSE-KMS is specified to encrypt the objects replicated to the destination bucket, it must be specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketReplicationState.__new__(_BucketReplicationState)

        __props__.__dict__["action"] = action
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["destination"] = destination
        __props__.__dict__["encryption_configuration"] = encryption_configuration
        __props__.__dict__["historical_object_replication"] = historical_object_replication
        __props__.__dict__["prefix_set"] = prefix_set
        __props__.__dict__["progress"] = progress
        __props__.__dict__["rule_id"] = rule_id
        __props__.__dict__["source_selection_criteria"] = source_selection_criteria
        __props__.__dict__["status"] = status
        __props__.__dict__["sync_role"] = sync_role
        return BucketReplication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[Optional[str]]:
        """
        The operations that can be synchronized to the destination bucket. You can set action to one or more of the following operation types. Valid values: `ALL`(contains PUT, DELETE, and ABORT), `PUT`, `DELETE` and `ABORT`. Defaults to `ALL`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Output['outputs.BucketReplicationDestination']:
        """
        Specifies the destination for the rule(See the following block `destination`).
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> pulumi.Output[Optional['outputs.BucketReplicationEncryptionConfiguration']]:
        """
        Specifies the encryption configuration for the objects replicated to the destination bucket(See the following block `encryption_configuration`).
        """
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter(name="historicalObjectReplication")
    def historical_object_replication(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether to replicate historical data from the source bucket to the destination bucket before data replication is enabled. Can be `enabled` or `disabled`. Defaults to `enabled`.
        """
        return pulumi.get(self, "historical_object_replication")

    @property
    @pulumi.getter(name="prefixSet")
    def prefix_set(self) -> pulumi.Output[Optional['outputs.BucketReplicationPrefixSet']]:
        """
        The prefixes used to specify the object to replicate. Only objects that match the prefix are replicated to the destination bucket(See the following block `prefix_set`).
        """
        return pulumi.get(self, "prefix_set")

    @property
    @pulumi.getter
    def progress(self) -> pulumi.Output['outputs.BucketReplicationProgress']:
        """
        Retrieves the progress of the data replication task. This status is returned only when the data replication task is in the doing state.
        """
        return pulumi.get(self, "progress")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Output[str]:
        """
        The ID of the data replication rule.
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="sourceSelectionCriteria")
    def source_selection_criteria(self) -> pulumi.Output[Optional['outputs.BucketReplicationSourceSelectionCriteria']]:
        """
        Specifies other conditions used to filter the source objects to replicate(See the following block `source_selection_criteria`).
        """
        return pulumi.get(self, "source_selection_criteria")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Specifies whether to replicate objects encrypted by using SSE-KMS. Can be `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="syncRole")
    def sync_role(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the role that you authorize OSS to use to replicate data. If SSE-KMS is specified to encrypt the objects replicated to the destination bucket, it must be specified.
        """
        return pulumi.get(self, "sync_role")

