# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetBucketsResult',
    'AwaitableGetBucketsResult',
    'get_buckets',
    'get_buckets_output',
]

@pulumi.output_type
class GetBucketsResult:
    """
    A collection of values returned by getBuckets.
    """
    def __init__(__self__, buckets=None, id=None, name_regex=None, names=None, output_file=None):
        if buckets and not isinstance(buckets, list):
            raise TypeError("Expected argument 'buckets' to be a list")
        pulumi.set(__self__, "buckets", buckets)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @property
    @pulumi.getter
    def buckets(self) -> Sequence['outputs.GetBucketsBucketResult']:
        """
        A list of buckets. Each element contains the following attributes:
        """
        return pulumi.get(self, "buckets")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        A list of bucket names.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")


class AwaitableGetBucketsResult(GetBucketsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBucketsResult(
            buckets=self.buckets,
            id=self.id,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file)


def get_buckets(name_regex: Optional[str] = None,
                output_file: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBucketsResult:
    """
    This data source provides the OSS buckets of the current Alibaba Cloud user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    oss_buckets_ds = alicloud.oss.get_buckets(name_regex="sample_oss_bucket")
    pulumi.export("firstOssBucketName", oss_buckets_ds.buckets[0].name)
    ```


    :param str name_regex: A regex string to filter results by bucket name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:oss/getBuckets:getBuckets', __args__, opts=opts, typ=GetBucketsResult).value

    return AwaitableGetBucketsResult(
        buckets=pulumi.get(__ret__, 'buckets'),
        id=pulumi.get(__ret__, 'id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'))


@_utilities.lift_output_func(get_buckets)
def get_buckets_output(name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                       output_file: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBucketsResult]:
    """
    This data source provides the OSS buckets of the current Alibaba Cloud user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    oss_buckets_ds = alicloud.oss.get_buckets(name_regex="sample_oss_bucket")
    pulumi.export("firstOssBucketName", oss_buckets_ds.buckets[0].name)
    ```


    :param str name_regex: A regex string to filter results by bucket name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    ...
