# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'BucketAccessMonitor',
    'BucketCorsRule',
    'BucketLifecycleRule',
    'BucketLifecycleRuleAbortMultipartUpload',
    'BucketLifecycleRuleExpiration',
    'BucketLifecycleRuleFilter',
    'BucketLifecycleRuleFilterNot',
    'BucketLifecycleRuleFilterNotTag',
    'BucketLifecycleRuleNoncurrentVersionExpiration',
    'BucketLifecycleRuleNoncurrentVersionTransition',
    'BucketLifecycleRuleTransition',
    'BucketLogging',
    'BucketRefererConfig',
    'BucketReplicationDestination',
    'BucketReplicationEncryptionConfiguration',
    'BucketReplicationPrefixSet',
    'BucketReplicationProgress',
    'BucketReplicationSourceSelectionCriteria',
    'BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjects',
    'BucketServerSideEncryptionRule',
    'BucketTransferAcceleration',
    'BucketVersioning',
    'BucketWebsite',
    'GetBucketObjectsObjectResult',
    'GetBucketsBucketResult',
    'GetBucketsBucketCorsRuleResult',
    'GetBucketsBucketLifecycleRuleResult',
    'GetBucketsBucketLifecycleRuleExpirationResult',
    'GetBucketsBucketLoggingResult',
    'GetBucketsBucketRefererConfigResult',
    'GetBucketsBucketServerSideEncryptionRuleResult',
    'GetBucketsBucketVersioningResult',
    'GetBucketsBucketWebsiteResult',
    'GetInstanceAttachmentsAttachmentResult',
    'GetInstancesInstanceResult',
    'GetTablesTableResult',
    'GetTablesTableDefinedColumnResult',
    'GetTablesTablePrimaryKeyResult',
]

@pulumi.output_type
class BucketAccessMonitor(dict):
    def __init__(__self__, *,
                 status: Optional[str] = None):
        """
        :param str status: The access monitor state of a bucket. If you want to manage objects based on the last access time of the objects, specifies the status to `Enabled`. Valid values: `Enabled` and `Disabled`.
        """
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The access monitor state of a bucket. If you want to manage objects based on the last access time of the objects, specifies the status to `Enabled`. Valid values: `Enabled` and `Disabled`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketCorsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAgeSeconds":
            suggest = "max_age_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketCorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketCorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketCorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_methods: Sequence[str],
                 allowed_origins: Sequence[str],
                 allowed_headers: Optional[Sequence[str]] = None,
                 expose_headers: Optional[Sequence[str]] = None,
                 max_age_seconds: Optional[int] = None):
        """
        :param Sequence[str] allowed_methods: Specifies which methods are allowed. Can be GET, PUT, POST, DELETE or HEAD.
        :param Sequence[str] allowed_origins: Specifies which origins are allowed.
        :param Sequence[str] allowed_headers: Specifies which headers are allowed.
        :param Sequence[str] expose_headers: Specifies expose header in the response.
        :param int max_age_seconds: Specifies time in seconds that browser can cache the response for a preflight request.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[str]:
        """
        Specifies which methods are allowed. Can be GET, PUT, POST, DELETE or HEAD.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[str]:
        """
        Specifies which origins are allowed.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[str]]:
        """
        Specifies which headers are allowed.
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[str]]:
        """
        Specifies expose header in the response.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[int]:
        """
        Specifies time in seconds that browser can cache the response for a preflight request.
        """
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class BucketLifecycleRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortMultipartUploads":
            suggest = "abort_multipart_uploads"
        elif key == "noncurrentVersionExpirations":
            suggest = "noncurrent_version_expirations"
        elif key == "noncurrentVersionTransitions":
            suggest = "noncurrent_version_transitions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 abort_multipart_uploads: Optional[Sequence['outputs.BucketLifecycleRuleAbortMultipartUpload']] = None,
                 expirations: Optional[Sequence['outputs.BucketLifecycleRuleExpiration']] = None,
                 filter: Optional['outputs.BucketLifecycleRuleFilter'] = None,
                 id: Optional[str] = None,
                 noncurrent_version_expirations: Optional[Sequence['outputs.BucketLifecycleRuleNoncurrentVersionExpiration']] = None,
                 noncurrent_version_transitions: Optional[Sequence['outputs.BucketLifecycleRuleNoncurrentVersionTransition']] = None,
                 prefix: Optional[str] = None,
                 tags: Optional[Mapping[str, Any]] = None,
                 transitions: Optional[Sequence['outputs.BucketLifecycleRuleTransition']] = None):
        """
        :param bool enabled: Specifies lifecycle rule status.
        :param Sequence['BucketLifecycleRuleAbortMultipartUploadArgs'] abort_multipart_uploads: Specifies the number of days after initiating a multipart upload when the multipart upload must be completed. See `abort_multipart_upload` below.
        :param Sequence['BucketLifecycleRuleExpirationArgs'] expirations: Specifies a period in the object's expire. See `expiration` below.
        :param 'BucketLifecycleRuleFilterArgs' filter: Configuration block used to identify objects that a Lifecycle rule applies to. See `filter` below.
               
               `NOTE`: At least one of expiration, transitions, abort_multipart_upload, noncurrent_version_expiration and noncurrent_version_transition should be configured.
        :param str id: Unique identifier for the rule. If omitted, OSS bucket will assign a unique name.
        :param Sequence['BucketLifecycleRuleNoncurrentVersionExpirationArgs'] noncurrent_version_expirations: Specifies when noncurrent object versions expire. See `noncurrent_version_expiration` below.
        :param Sequence['BucketLifecycleRuleNoncurrentVersionTransitionArgs'] noncurrent_version_transitions: Specifies when noncurrent object versions transitions. See `noncurrent_version_transition` below.
        :param str prefix: The prefix in the names of the objects to which the lifecycle rule does not apply.
        :param Mapping[str, Any] tags: Key-value map of resource tags. All of these tags must exist in the object's tag set in order for the rule to apply.
        :param Sequence['BucketLifecycleRuleTransitionArgs'] transitions: Specifies the time when an object is converted to the IA or archive storage class during a valid life cycle. See `transitions` below.
        """
        pulumi.set(__self__, "enabled", enabled)
        if abort_multipart_uploads is not None:
            pulumi.set(__self__, "abort_multipart_uploads", abort_multipart_uploads)
        if expirations is not None:
            pulumi.set(__self__, "expirations", expirations)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if noncurrent_version_expirations is not None:
            pulumi.set(__self__, "noncurrent_version_expirations", noncurrent_version_expirations)
        if noncurrent_version_transitions is not None:
            pulumi.set(__self__, "noncurrent_version_transitions", noncurrent_version_transitions)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Specifies lifecycle rule status.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="abortMultipartUploads")
    def abort_multipart_uploads(self) -> Optional[Sequence['outputs.BucketLifecycleRuleAbortMultipartUpload']]:
        """
        Specifies the number of days after initiating a multipart upload when the multipart upload must be completed. See `abort_multipart_upload` below.
        """
        return pulumi.get(self, "abort_multipart_uploads")

    @property
    @pulumi.getter
    def expirations(self) -> Optional[Sequence['outputs.BucketLifecycleRuleExpiration']]:
        """
        Specifies a period in the object's expire. See `expiration` below.
        """
        return pulumi.get(self, "expirations")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.BucketLifecycleRuleFilter']:
        """
        Configuration block used to identify objects that a Lifecycle rule applies to. See `filter` below.

        `NOTE`: At least one of expiration, transitions, abort_multipart_upload, noncurrent_version_expiration and noncurrent_version_transition should be configured.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for the rule. If omitted, OSS bucket will assign a unique name.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="noncurrentVersionExpirations")
    def noncurrent_version_expirations(self) -> Optional[Sequence['outputs.BucketLifecycleRuleNoncurrentVersionExpiration']]:
        """
        Specifies when noncurrent object versions expire. See `noncurrent_version_expiration` below.
        """
        return pulumi.get(self, "noncurrent_version_expirations")

    @property
    @pulumi.getter(name="noncurrentVersionTransitions")
    def noncurrent_version_transitions(self) -> Optional[Sequence['outputs.BucketLifecycleRuleNoncurrentVersionTransition']]:
        """
        Specifies when noncurrent object versions transitions. See `noncurrent_version_transition` below.
        """
        return pulumi.get(self, "noncurrent_version_transitions")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        The prefix in the names of the objects to which the lifecycle rule does not apply.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, Any]]:
        """
        Key-value map of resource tags. All of these tags must exist in the object's tag set in order for the rule to apply.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def transitions(self) -> Optional[Sequence['outputs.BucketLifecycleRuleTransition']]:
        """
        Specifies the time when an object is converted to the IA or archive storage class during a valid life cycle. See `transitions` below.
        """
        return pulumi.get(self, "transitions")


@pulumi.output_type
class BucketLifecycleRuleAbortMultipartUpload(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdBeforeDate":
            suggest = "created_before_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleAbortMultipartUpload. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleAbortMultipartUpload.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleAbortMultipartUpload.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_before_date: Optional[str] = None,
                 days: Optional[int] = None):
        """
        :param str created_before_date: Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
        :param int days: Specifies the number of days noncurrent object versions transition.
        """
        if created_before_date is not None:
            pulumi.set(__self__, "created_before_date", created_before_date)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter(name="createdBeforeDate")
    def created_before_date(self) -> Optional[str]:
        """
        Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
        """
        return pulumi.get(self, "created_before_date")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Specifies the number of days noncurrent object versions transition.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketLifecycleRuleExpiration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdBeforeDate":
            suggest = "created_before_date"
        elif key == "expiredObjectDeleteMarker":
            suggest = "expired_object_delete_marker"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleExpiration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleExpiration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleExpiration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_before_date: Optional[str] = None,
                 date: Optional[str] = None,
                 days: Optional[int] = None,
                 expired_object_delete_marker: Optional[bool] = None):
        """
        :param str created_before_date: Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
        :param str date: Specifies the date after which you want the corresponding action to take effect. The value obeys ISO8601 format like `2017-03-09`.
        :param int days: Specifies the number of days noncurrent object versions transition.
        :param bool expired_object_delete_marker: On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct OSS to delete expired object delete markers. This cannot be specified with Days, Date or CreatedBeforeDate in a Lifecycle Expiration Policy.
               
               `NOTE`: One and only one of "date", "days", "created_before_date" and "expired_object_delete_marker" can be specified in one expiration configuration.
        """
        if created_before_date is not None:
            pulumi.set(__self__, "created_before_date", created_before_date)
        if date is not None:
            pulumi.set(__self__, "date", date)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if expired_object_delete_marker is not None:
            pulumi.set(__self__, "expired_object_delete_marker", expired_object_delete_marker)

    @property
    @pulumi.getter(name="createdBeforeDate")
    def created_before_date(self) -> Optional[str]:
        """
        Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
        """
        return pulumi.get(self, "created_before_date")

    @property
    @pulumi.getter
    def date(self) -> Optional[str]:
        """
        Specifies the date after which you want the corresponding action to take effect. The value obeys ISO8601 format like `2017-03-09`.
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Specifies the number of days noncurrent object versions transition.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="expiredObjectDeleteMarker")
    def expired_object_delete_marker(self) -> Optional[bool]:
        """
        On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct OSS to delete expired object delete markers. This cannot be specified with Days, Date or CreatedBeforeDate in a Lifecycle Expiration Policy.

        `NOTE`: One and only one of "date", "days", "created_before_date" and "expired_object_delete_marker" can be specified in one expiration configuration.
        """
        return pulumi.get(self, "expired_object_delete_marker")


@pulumi.output_type
class BucketLifecycleRuleFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "not":
            suggest = "not_"
        elif key == "objectSizeGreaterThan":
            suggest = "object_size_greater_than"
        elif key == "objectSizeLessThan":
            suggest = "object_size_less_than"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 not_: Optional['outputs.BucketLifecycleRuleFilterNot'] = None,
                 object_size_greater_than: Optional[int] = None,
                 object_size_less_than: Optional[int] = None):
        """
        :param 'BucketLifecycleRuleFilterNotArgs' not_: The condition that is matched by objects to which the lifecycle rule does not apply. See `not` below.
        :param int object_size_greater_than: Minimum object size (in bytes) to which the rule applies.
        :param int object_size_less_than: Maximum object size (in bytes) to which the rule applies.
        """
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if object_size_greater_than is not None:
            pulumi.set(__self__, "object_size_greater_than", object_size_greater_than)
        if object_size_less_than is not None:
            pulumi.set(__self__, "object_size_less_than", object_size_less_than)

    @property
    @pulumi.getter(name="not")
    def not_(self) -> Optional['outputs.BucketLifecycleRuleFilterNot']:
        """
        The condition that is matched by objects to which the lifecycle rule does not apply. See `not` below.
        """
        return pulumi.get(self, "not_")

    @property
    @pulumi.getter(name="objectSizeGreaterThan")
    def object_size_greater_than(self) -> Optional[int]:
        """
        Minimum object size (in bytes) to which the rule applies.
        """
        return pulumi.get(self, "object_size_greater_than")

    @property
    @pulumi.getter(name="objectSizeLessThan")
    def object_size_less_than(self) -> Optional[int]:
        """
        Maximum object size (in bytes) to which the rule applies.
        """
        return pulumi.get(self, "object_size_less_than")


@pulumi.output_type
class BucketLifecycleRuleFilterNot(dict):
    def __init__(__self__, *,
                 prefix: Optional[str] = None,
                 tag: Optional['outputs.BucketLifecycleRuleFilterNotTag'] = None):
        """
        :param str prefix: The prefix in the names of the objects to which the lifecycle rule does not apply.
        :param 'BucketLifecycleRuleFilterNotTagArgs' tag: The tag of the objects to which the lifecycle rule does not apply. See `tag` below.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        The prefix in the names of the objects to which the lifecycle rule does not apply.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tag(self) -> Optional['outputs.BucketLifecycleRuleFilterNotTag']:
        """
        The tag of the objects to which the lifecycle rule does not apply. See `tag` below.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class BucketLifecycleRuleFilterNotTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The key of the tag that is specified for the objects.
        :param str value: The value of the tag that is specified for the objects.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of the tag that is specified for the objects.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the tag that is specified for the objects.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class BucketLifecycleRuleNoncurrentVersionExpiration(dict):
    def __init__(__self__, *,
                 days: int):
        """
        :param int days: Specifies the number of days noncurrent object versions transition.
        """
        pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> int:
        """
        Specifies the number of days noncurrent object versions transition.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketLifecycleRuleNoncurrentVersionTransition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"
        elif key == "isAccessTime":
            suggest = "is_access_time"
        elif key == "returnToStdWhenVisit":
            suggest = "return_to_std_when_visit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleNoncurrentVersionTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleNoncurrentVersionTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleNoncurrentVersionTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days: int,
                 storage_class: str,
                 is_access_time: Optional[bool] = None,
                 return_to_std_when_visit: Optional[bool] = None):
        """
        :param int days: Specifies the number of days noncurrent object versions transition.
        :param str storage_class: The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
        :param bool is_access_time: Specifies whether the lifecycle rule applies to objects based on their last access time. If set to `true`, the rule applies to objects based on their last access time; if set to `false`, the rule applies to objects based on their last modified time. If configure the rule based on the last access time, please enable `access_monitor` first.
        :param bool return_to_std_when_visit: Specifies whether to convert the storage class of non-Standard objects back to Standard after the objects are accessed. It takes effect only when the IsAccessTime parameter is set to true. If set to `true`, converts the storage class of the objects to Standard; if set to `false`, does not convert the storage class of the objects to Standard.
        """
        pulumi.set(__self__, "days", days)
        pulumi.set(__self__, "storage_class", storage_class)
        if is_access_time is not None:
            pulumi.set(__self__, "is_access_time", is_access_time)
        if return_to_std_when_visit is not None:
            pulumi.set(__self__, "return_to_std_when_visit", return_to_std_when_visit)

    @property
    @pulumi.getter
    def days(self) -> int:
        """
        Specifies the number of days noncurrent object versions transition.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        """
        The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter(name="isAccessTime")
    def is_access_time(self) -> Optional[bool]:
        """
        Specifies whether the lifecycle rule applies to objects based on their last access time. If set to `true`, the rule applies to objects based on their last access time; if set to `false`, the rule applies to objects based on their last modified time. If configure the rule based on the last access time, please enable `access_monitor` first.
        """
        return pulumi.get(self, "is_access_time")

    @property
    @pulumi.getter(name="returnToStdWhenVisit")
    def return_to_std_when_visit(self) -> Optional[bool]:
        """
        Specifies whether to convert the storage class of non-Standard objects back to Standard after the objects are accessed. It takes effect only when the IsAccessTime parameter is set to true. If set to `true`, converts the storage class of the objects to Standard; if set to `false`, does not convert the storage class of the objects to Standard.
        """
        return pulumi.get(self, "return_to_std_when_visit")


@pulumi.output_type
class BucketLifecycleRuleTransition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"
        elif key == "createdBeforeDate":
            suggest = "created_before_date"
        elif key == "isAccessTime":
            suggest = "is_access_time"
        elif key == "returnToStdWhenVisit":
            suggest = "return_to_std_when_visit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_class: str,
                 created_before_date: Optional[str] = None,
                 days: Optional[int] = None,
                 is_access_time: Optional[bool] = None,
                 return_to_std_when_visit: Optional[bool] = None):
        """
        :param str storage_class: The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
        :param str created_before_date: Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
        :param int days: Specifies the number of days noncurrent object versions transition.
        :param bool is_access_time: Specifies whether the lifecycle rule applies to objects based on their last access time. If set to `true`, the rule applies to objects based on their last access time; if set to `false`, the rule applies to objects based on their last modified time. If configure the rule based on the last access time, please enable `access_monitor` first.
        :param bool return_to_std_when_visit: Specifies whether to convert the storage class of non-Standard objects back to Standard after the objects are accessed. It takes effect only when the IsAccessTime parameter is set to true. If set to `true`, converts the storage class of the objects to Standard; if set to `false`, does not convert the storage class of the objects to Standard.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        if created_before_date is not None:
            pulumi.set(__self__, "created_before_date", created_before_date)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if is_access_time is not None:
            pulumi.set(__self__, "is_access_time", is_access_time)
        if return_to_std_when_visit is not None:
            pulumi.set(__self__, "return_to_std_when_visit", return_to_std_when_visit)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        """
        The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter(name="createdBeforeDate")
    def created_before_date(self) -> Optional[str]:
        """
        Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
        """
        return pulumi.get(self, "created_before_date")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Specifies the number of days noncurrent object versions transition.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="isAccessTime")
    def is_access_time(self) -> Optional[bool]:
        """
        Specifies whether the lifecycle rule applies to objects based on their last access time. If set to `true`, the rule applies to objects based on their last access time; if set to `false`, the rule applies to objects based on their last modified time. If configure the rule based on the last access time, please enable `access_monitor` first.
        """
        return pulumi.get(self, "is_access_time")

    @property
    @pulumi.getter(name="returnToStdWhenVisit")
    def return_to_std_when_visit(self) -> Optional[bool]:
        """
        Specifies whether to convert the storage class of non-Standard objects back to Standard after the objects are accessed. It takes effect only when the IsAccessTime parameter is set to true. If set to `true`, converts the storage class of the objects to Standard; if set to `false`, does not convert the storage class of the objects to Standard.
        """
        return pulumi.get(self, "return_to_std_when_visit")


@pulumi.output_type
class BucketLogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetBucket":
            suggest = "target_bucket"
        elif key == "targetPrefix":
            suggest = "target_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_bucket: str,
                 target_prefix: Optional[str] = None):
        """
        :param str target_bucket: The name of the bucket that will receive the log objects.
        :param str target_prefix: To specify a key prefix for log objects.
        """
        pulumi.set(__self__, "target_bucket", target_bucket)
        if target_prefix is not None:
            pulumi.set(__self__, "target_prefix", target_prefix)

    @property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> str:
        """
        The name of the bucket that will receive the log objects.
        """
        return pulumi.get(self, "target_bucket")

    @property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> Optional[str]:
        """
        To specify a key prefix for log objects.
        """
        return pulumi.get(self, "target_prefix")


@pulumi.output_type
class BucketRefererConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowEmpty":
            suggest = "allow_empty"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketRefererConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketRefererConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketRefererConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 referers: Sequence[str],
                 allow_empty: Optional[bool] = None):
        """
        :param Sequence[str] referers: The list of referer.
        :param bool allow_empty: Allows referer to be empty. Defaults false.
        """
        pulumi.set(__self__, "referers", referers)
        if allow_empty is not None:
            pulumi.set(__self__, "allow_empty", allow_empty)

    @property
    @pulumi.getter
    def referers(self) -> Sequence[str]:
        """
        The list of referer.
        """
        return pulumi.get(self, "referers")

    @property
    @pulumi.getter(name="allowEmpty")
    def allow_empty(self) -> Optional[bool]:
        """
        Allows referer to be empty. Defaults false.
        """
        return pulumi.get(self, "allow_empty")


@pulumi.output_type
class BucketReplicationDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "transferType":
            suggest = "transfer_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 location: str,
                 transfer_type: Optional[str] = None):
        """
        :param str bucket: The destination bucket to which the data is replicated.
        :param str transfer_type: The link used to transfer data in data replication.. Can be `internal` or `oss_acc`. Defaults to `internal`.
               
               `NOTE`: You can set transfer_type to oss_acc only when you create cross-region replication (CRR) rules.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "location", location)
        if transfer_type is not None:
            pulumi.set(__self__, "transfer_type", transfer_type)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The destination bucket to which the data is replicated.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="transferType")
    def transfer_type(self) -> Optional[str]:
        """
        The link used to transfer data in data replication.. Can be `internal` or `oss_acc`. Defaults to `internal`.

        `NOTE`: You can set transfer_type to oss_acc only when you create cross-region replication (CRR) rules.
        """
        return pulumi.get(self, "transfer_type")


@pulumi.output_type
class BucketReplicationEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicaKmsKeyId":
            suggest = "replica_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replica_kms_key_id: str):
        """
        :param str replica_kms_key_id: The CMK ID used in SSE-KMS.
               
               `NOTE`: If the status of sse_kms_encrypted_objects is set to Enabled, you must specify the replica_kms_key_id.
        """
        pulumi.set(__self__, "replica_kms_key_id", replica_kms_key_id)

    @property
    @pulumi.getter(name="replicaKmsKeyId")
    def replica_kms_key_id(self) -> str:
        """
        The CMK ID used in SSE-KMS.

        `NOTE`: If the status of sse_kms_encrypted_objects is set to Enabled, you must specify the replica_kms_key_id.
        """
        return pulumi.get(self, "replica_kms_key_id")


@pulumi.output_type
class BucketReplicationPrefixSet(dict):
    def __init__(__self__, *,
                 prefixes: Sequence[str]):
        """
        :param Sequence[str] prefixes: The list of object key name prefix identifying one or more objects to which the rule applies.
               
               `NOTE`: The prefix must be less than or equal to 1024 characters in length.
        """
        pulumi.set(__self__, "prefixes", prefixes)

    @property
    @pulumi.getter
    def prefixes(self) -> Sequence[str]:
        """
        The list of object key name prefix identifying one or more objects to which the rule applies.

        `NOTE`: The prefix must be less than or equal to 1024 characters in length.
        """
        return pulumi.get(self, "prefixes")


@pulumi.output_type
class BucketReplicationProgress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "historicalObject":
            suggest = "historical_object"
        elif key == "newObject":
            suggest = "new_object"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationProgress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationProgress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationProgress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 historical_object: Optional[str] = None,
                 new_object: Optional[str] = None):
        """
        :param str historical_object: The percentage of the replicated historical data. This element is valid only when historical_object_replication is set to enabled.
        :param str new_object: The time used to distinguish new data from historical data. Data that is written to the source bucket before the time is replicated to the destination bucket as new data. The value of this element is in GMT.
        """
        if historical_object is not None:
            pulumi.set(__self__, "historical_object", historical_object)
        if new_object is not None:
            pulumi.set(__self__, "new_object", new_object)

    @property
    @pulumi.getter(name="historicalObject")
    def historical_object(self) -> Optional[str]:
        """
        The percentage of the replicated historical data. This element is valid only when historical_object_replication is set to enabled.
        """
        return pulumi.get(self, "historical_object")

    @property
    @pulumi.getter(name="newObject")
    def new_object(self) -> Optional[str]:
        """
        The time used to distinguish new data from historical data. Data that is written to the source bucket before the time is replicated to the destination bucket as new data. The value of this element is in GMT.
        """
        return pulumi.get(self, "new_object")


@pulumi.output_type
class BucketReplicationSourceSelectionCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sseKmsEncryptedObjects":
            suggest = "sse_kms_encrypted_objects"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationSourceSelectionCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationSourceSelectionCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationSourceSelectionCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sse_kms_encrypted_objects: Optional['outputs.BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjects'] = None):
        """
        :param 'BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjectsArgs' sse_kms_encrypted_objects: Filter source objects encrypted by using SSE-KMS(See the following block `sse_kms_encrypted_objects`).
        """
        if sse_kms_encrypted_objects is not None:
            pulumi.set(__self__, "sse_kms_encrypted_objects", sse_kms_encrypted_objects)

    @property
    @pulumi.getter(name="sseKmsEncryptedObjects")
    def sse_kms_encrypted_objects(self) -> Optional['outputs.BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjects']:
        """
        Filter source objects encrypted by using SSE-KMS(See the following block `sse_kms_encrypted_objects`).
        """
        return pulumi.get(self, "sse_kms_encrypted_objects")


@pulumi.output_type
class BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjects(dict):
    def __init__(__self__, *,
                 status: Optional[str] = None):
        """
        :param str status: Specifies whether to replicate objects encrypted by using SSE-KMS. Can be `Enabled` or `Disabled`.
        """
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Specifies whether to replicate objects encrypted by using SSE-KMS. Can be `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketServerSideEncryptionRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sseAlgorithm":
            suggest = "sse_algorithm"
        elif key == "kmsMasterKeyId":
            suggest = "kms_master_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketServerSideEncryptionRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketServerSideEncryptionRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketServerSideEncryptionRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sse_algorithm: str,
                 kms_master_key_id: Optional[str] = None):
        """
        :param str sse_algorithm: The server-side encryption algorithm to use. Possible values: `AES256` and `KMS`.
        :param str kms_master_key_id: The alibaba cloud KMS master key ID used for the SSE-KMS encryption.
        """
        pulumi.set(__self__, "sse_algorithm", sse_algorithm)
        if kms_master_key_id is not None:
            pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)

    @property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> str:
        """
        The server-side encryption algorithm to use. Possible values: `AES256` and `KMS`.
        """
        return pulumi.get(self, "sse_algorithm")

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> Optional[str]:
        """
        The alibaba cloud KMS master key ID used for the SSE-KMS encryption.
        """
        return pulumi.get(self, "kms_master_key_id")


@pulumi.output_type
class BucketTransferAcceleration(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: Specifies the accelerate status of a bucket.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Specifies the accelerate status of a bucket.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class BucketVersioning(dict):
    def __init__(__self__, *,
                 status: str):
        """
        :param str status: Specifies the versioning state of a bucket. Valid values: `Enabled` and `Suspended`.
        """
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Specifies the versioning state of a bucket. Valid values: `Enabled` and `Suspended`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketWebsite(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexDocument":
            suggest = "index_document"
        elif key == "errorDocument":
            suggest = "error_document"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsite. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsite.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsite.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index_document: str,
                 error_document: Optional[str] = None):
        """
        :param str index_document: Alicloud OSS returns this index document when requests are made to the root domain or any of the subfolders.
        :param str error_document: An absolute path to the document to return in case of a 4XX error.
        """
        pulumi.set(__self__, "index_document", index_document)
        if error_document is not None:
            pulumi.set(__self__, "error_document", error_document)

    @property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> str:
        """
        Alicloud OSS returns this index document when requests are made to the root domain or any of the subfolders.
        """
        return pulumi.get(self, "index_document")

    @property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> Optional[str]:
        """
        An absolute path to the document to return in case of a 4XX error.
        """
        return pulumi.get(self, "error_document")


@pulumi.output_type
class GetBucketObjectsObjectResult(dict):
    def __init__(__self__, *,
                 acl: str,
                 cache_control: str,
                 content_disposition: str,
                 content_encoding: str,
                 content_length: str,
                 content_md5: str,
                 content_type: str,
                 etag: str,
                 expires: str,
                 key: str,
                 last_modification_time: str,
                 server_side_encryption: str,
                 sse_kms_key_id: str,
                 storage_class: str):
        """
        :param str acl: Object access control list. Possible values: `default`, `private`, `public-read` and `public-read-write`.
        :param str cache_control: Caching behavior along the request/reply chain. Read [RFC2616 Cache-Control](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param str content_disposition: Presentational information for the object. Read [RFC2616 Content-Disposition](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param str content_encoding: Content encodings that have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [RFC2616 Content-Encoding](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param str content_length: Size of the object in bytes.
        :param str content_md5: MD5 value of the content. Read [MD5](https://www.alibabacloud.com/help/doc-detail/31978.htm) for computing method.
        :param str content_type: Standard MIME type describing the format of the object data, e.g. "application/octet-stream".
        :param str etag: ETag generated for the object (MD5 sum of the object content).
        :param str expires: Expiration date for the the request/response. Read [RFC2616 Expires](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param str key: Object key.
        :param str last_modification_time: Last modification time of the object.
        :param str server_side_encryption: Server-side encryption of the object in OSS. It can be empty or `AES256`.
        :param str sse_kms_key_id: If present, specifies the ID of the Key Management Service(KMS) master encryption key that was used for the object.
        :param str storage_class: Object storage type. Possible values: `Standard`, `IA`, `Archive` and `ColdArchive`.
        """
        pulumi.set(__self__, "acl", acl)
        pulumi.set(__self__, "cache_control", cache_control)
        pulumi.set(__self__, "content_disposition", content_disposition)
        pulumi.set(__self__, "content_encoding", content_encoding)
        pulumi.set(__self__, "content_length", content_length)
        pulumi.set(__self__, "content_md5", content_md5)
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "expires", expires)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "last_modification_time", last_modification_time)
        pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        pulumi.set(__self__, "sse_kms_key_id", sse_kms_key_id)
        pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def acl(self) -> str:
        """
        Object access control list. Possible values: `default`, `private`, `public-read` and `public-read-write`.
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> str:
        """
        Caching behavior along the request/reply chain. Read [RFC2616 Cache-Control](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        """
        return pulumi.get(self, "cache_control")

    @property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> str:
        """
        Presentational information for the object. Read [RFC2616 Content-Disposition](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        """
        return pulumi.get(self, "content_disposition")

    @property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> str:
        """
        Content encodings that have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [RFC2616 Content-Encoding](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        """
        return pulumi.get(self, "content_encoding")

    @property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> str:
        """
        Size of the object in bytes.
        """
        return pulumi.get(self, "content_length")

    @property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> str:
        """
        MD5 value of the content. Read [MD5](https://www.alibabacloud.com/help/doc-detail/31978.htm) for computing method.
        """
        return pulumi.get(self, "content_md5")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        Standard MIME type describing the format of the object data, e.g. "application/octet-stream".
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        ETag generated for the object (MD5 sum of the object content).
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def expires(self) -> str:
        """
        Expiration date for the the request/response. Read [RFC2616 Expires](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        """
        return pulumi.get(self, "expires")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Object key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="lastModificationTime")
    def last_modification_time(self) -> str:
        """
        Last modification time of the object.
        """
        return pulumi.get(self, "last_modification_time")

    @property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> str:
        """
        Server-side encryption of the object in OSS. It can be empty or `AES256`.
        """
        return pulumi.get(self, "server_side_encryption")

    @property
    @pulumi.getter(name="sseKmsKeyId")
    def sse_kms_key_id(self) -> str:
        """
        If present, specifies the ID of the Key Management Service(KMS) master encryption key that was used for the object.
        """
        return pulumi.get(self, "sse_kms_key_id")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        """
        Object storage type. Possible values: `Standard`, `IA`, `Archive` and `ColdArchive`.
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class GetBucketsBucketResult(dict):
    def __init__(__self__, *,
                 acl: str,
                 cors_rules: Sequence['outputs.GetBucketsBucketCorsRuleResult'],
                 creation_date: str,
                 extranet_endpoint: str,
                 intranet_endpoint: str,
                 lifecycle_rules: Sequence['outputs.GetBucketsBucketLifecycleRuleResult'],
                 location: str,
                 logging: 'outputs.GetBucketsBucketLoggingResult',
                 name: str,
                 owner: str,
                 redundancy_type: str,
                 referer_config: 'outputs.GetBucketsBucketRefererConfigResult',
                 server_side_encryption_rule: 'outputs.GetBucketsBucketServerSideEncryptionRuleResult',
                 storage_class: str,
                 tags: Mapping[str, Any],
                 versioning: 'outputs.GetBucketsBucketVersioningResult',
                 website: 'outputs.GetBucketsBucketWebsiteResult',
                 policy: Optional[str] = None):
        """
        :param str acl: Bucket access control list. Possible values: `private`, `public-read` and `public-read-write`.
        :param Sequence['GetBucketsBucketCorsRuleArgs'] cors_rules: A list of CORS rule configurations. Each element contains the following attributes:
        :param str creation_date: Bucket creation date.
        :param str extranet_endpoint: Internet domain name for accessing the bucket from outside.
        :param str intranet_endpoint: Intranet domain name for accessing the bucket from an ECS instance in the same region.
        :param Sequence['GetBucketsBucketLifecycleRuleArgs'] lifecycle_rules: A list CORS of lifecycle configurations. When Lifecycle is enabled, OSS automatically deletes the objects or transitions the objects (to another storage class) corresponding the lifecycle rules on a regular basis. Each element contains the following attributes:
        :param str location: Region of the data center where the bucket is located.
        :param 'GetBucketsBucketLoggingArgs' logging: A list of one element containing configuration parameters used for storing access log information. It contains the following attributes:
        :param str name: Bucket name.
        :param str owner: Bucket owner.
        :param str redundancy_type: Redundancy type. Possible values: `LRS`, and `ZRS`.
        :param 'GetBucketsBucketRefererConfigArgs' referer_config: A list of one element containing referer configuration. It contains the following attributes:
        :param 'GetBucketsBucketServerSideEncryptionRuleArgs' server_side_encryption_rule: A configuration of default encryption for a bucket. It contains the following attributes:
        :param str storage_class: Object storage type. Possible values: `Standard`, `IA`, `Archive` and `ColdArchive`.
        :param Mapping[str, Any] tags: A mapping of tags.
        :param 'GetBucketsBucketVersioningArgs' versioning: If present , the versioning state has been set on the bucket. It contains the following attribute.
        :param 'GetBucketsBucketWebsiteArgs' website: A list of one element containing configuration parameters used when the bucket is used as a website. It contains the following attributes:
        """
        pulumi.set(__self__, "acl", acl)
        pulumi.set(__self__, "cors_rules", cors_rules)
        pulumi.set(__self__, "creation_date", creation_date)
        pulumi.set(__self__, "extranet_endpoint", extranet_endpoint)
        pulumi.set(__self__, "intranet_endpoint", intranet_endpoint)
        pulumi.set(__self__, "lifecycle_rules", lifecycle_rules)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "logging", logging)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "redundancy_type", redundancy_type)
        pulumi.set(__self__, "referer_config", referer_config)
        pulumi.set(__self__, "server_side_encryption_rule", server_side_encryption_rule)
        pulumi.set(__self__, "storage_class", storage_class)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "versioning", versioning)
        pulumi.set(__self__, "website", website)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def acl(self) -> str:
        """
        Bucket access control list. Possible values: `private`, `public-read` and `public-read-write`.
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Sequence['outputs.GetBucketsBucketCorsRuleResult']:
        """
        A list of CORS rule configurations. Each element contains the following attributes:
        """
        return pulumi.get(self, "cors_rules")

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> str:
        """
        Bucket creation date.
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter(name="extranetEndpoint")
    def extranet_endpoint(self) -> str:
        """
        Internet domain name for accessing the bucket from outside.
        """
        return pulumi.get(self, "extranet_endpoint")

    @property
    @pulumi.getter(name="intranetEndpoint")
    def intranet_endpoint(self) -> str:
        """
        Intranet domain name for accessing the bucket from an ECS instance in the same region.
        """
        return pulumi.get(self, "intranet_endpoint")

    @property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> Sequence['outputs.GetBucketsBucketLifecycleRuleResult']:
        """
        A list CORS of lifecycle configurations. When Lifecycle is enabled, OSS automatically deletes the objects or transitions the objects (to another storage class) corresponding the lifecycle rules on a regular basis. Each element contains the following attributes:
        """
        return pulumi.get(self, "lifecycle_rules")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Region of the data center where the bucket is located.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def logging(self) -> 'outputs.GetBucketsBucketLoggingResult':
        """
        A list of one element containing configuration parameters used for storing access log information. It contains the following attributes:
        """
        return pulumi.get(self, "logging")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Bucket name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        Bucket owner.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="redundancyType")
    def redundancy_type(self) -> str:
        """
        Redundancy type. Possible values: `LRS`, and `ZRS`.
        """
        return pulumi.get(self, "redundancy_type")

    @property
    @pulumi.getter(name="refererConfig")
    def referer_config(self) -> 'outputs.GetBucketsBucketRefererConfigResult':
        """
        A list of one element containing referer configuration. It contains the following attributes:
        """
        return pulumi.get(self, "referer_config")

    @property
    @pulumi.getter(name="serverSideEncryptionRule")
    def server_side_encryption_rule(self) -> 'outputs.GetBucketsBucketServerSideEncryptionRuleResult':
        """
        A configuration of default encryption for a bucket. It contains the following attributes:
        """
        return pulumi.get(self, "server_side_encryption_rule")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        """
        Object storage type. Possible values: `Standard`, `IA`, `Archive` and `ColdArchive`.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A mapping of tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def versioning(self) -> 'outputs.GetBucketsBucketVersioningResult':
        """
        If present , the versioning state has been set on the bucket. It contains the following attribute.
        """
        return pulumi.get(self, "versioning")

    @property
    @pulumi.getter
    def website(self) -> 'outputs.GetBucketsBucketWebsiteResult':
        """
        A list of one element containing configuration parameters used when the bucket is used as a website. It contains the following attributes:
        """
        return pulumi.get(self, "website")

    @property
    @pulumi.getter
    def policy(self) -> Optional[str]:
        return pulumi.get(self, "policy")


@pulumi.output_type
class GetBucketsBucketCorsRuleResult(dict):
    def __init__(__self__, *,
                 allowed_headers: Sequence[str],
                 allowed_methods: Sequence[str],
                 allowed_origins: Sequence[str],
                 expose_headers: Sequence[str],
                 max_age_seconds: int):
        """
        :param Sequence[str] allowed_headers: Control whether the headers specified by Access-Control-Request-Headers in the OPTIONS prefetch command are allowed. Each header specified by Access-Control-Request-Headers must match a value in AllowedHeader. Each rule allows up to one wildcard “*” .
        :param Sequence[str] allowed_methods: Specify the allowed methods for cross-domain requests. Possible values: `GET`, `PUT`, `DELETE`, `POST` and `HEAD`.
        :param Sequence[str] allowed_origins: The origins allowed for cross-domain requests. Multiple elements can be used to specify multiple allowed origins. Each rule allows up to one wildcard "\\*". If "\\*" is specified, cross-domain requests of all origins are allowed.
        :param Sequence[str] expose_headers: Specify the response headers allowing users to access from an application (for example, a Javascript XMLHttpRequest object). The wildcard "\\*" is not allowed.
        :param int max_age_seconds: Specify the cache time for the returned result of a browser prefetch (OPTIONS) request to a specific resource.
        """
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "expose_headers", expose_headers)
        pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Sequence[str]:
        """
        Control whether the headers specified by Access-Control-Request-Headers in the OPTIONS prefetch command are allowed. Each header specified by Access-Control-Request-Headers must match a value in AllowedHeader. Each rule allows up to one wildcard “*” .
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[str]:
        """
        Specify the allowed methods for cross-domain requests. Possible values: `GET`, `PUT`, `DELETE`, `POST` and `HEAD`.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[str]:
        """
        The origins allowed for cross-domain requests. Multiple elements can be used to specify multiple allowed origins. Each rule allows up to one wildcard "\\*". If "\\*" is specified, cross-domain requests of all origins are allowed.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Sequence[str]:
        """
        Specify the response headers allowing users to access from an application (for example, a Javascript XMLHttpRequest object). The wildcard "\\*" is not allowed.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> int:
        """
        Specify the cache time for the returned result of a browser prefetch (OPTIONS) request to a specific resource.
        """
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class GetBucketsBucketLifecycleRuleResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 expiration: 'outputs.GetBucketsBucketLifecycleRuleExpirationResult',
                 id: str,
                 prefix: str):
        """
        :param bool enabled: Indicate whether the rule is enabled or not.
        :param 'GetBucketsBucketLifecycleRuleExpirationArgs' expiration: A list of one element containing expiration attributes of an object. It contains the following attributes:
        :param str id: Unique ID of the rule.
        :param str prefix: Prefix applicable to a rule. Only those objects with a matching prefix can be affected by the rule.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "expiration", expiration)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Indicate whether the rule is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def expiration(self) -> 'outputs.GetBucketsBucketLifecycleRuleExpirationResult':
        """
        A list of one element containing expiration attributes of an object. It contains the following attributes:
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique ID of the rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        Prefix applicable to a rule. Only those objects with a matching prefix can be affected by the rule.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class GetBucketsBucketLifecycleRuleExpirationResult(dict):
    def __init__(__self__, *,
                 date: Optional[str] = None,
                 days: Optional[int] = None):
        """
        :param str date: Date after which the rule to take effect. The format is like 2017-03-09.
        :param int days: Indicate the number of days after the last object update until the rules take effect.
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def date(self) -> Optional[str]:
        """
        Date after which the rule to take effect. The format is like 2017-03-09.
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Indicate the number of days after the last object update until the rules take effect.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class GetBucketsBucketLoggingResult(dict):
    def __init__(__self__, *,
                 target_bucket: str,
                 target_prefix: str):
        """
        :param str target_bucket: Bucket for storing access logs.
        :param str target_prefix: Prefix of the saved access log file paths.
        """
        pulumi.set(__self__, "target_bucket", target_bucket)
        pulumi.set(__self__, "target_prefix", target_prefix)

    @property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> str:
        """
        Bucket for storing access logs.
        """
        return pulumi.get(self, "target_bucket")

    @property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> str:
        """
        Prefix of the saved access log file paths.
        """
        return pulumi.get(self, "target_prefix")


@pulumi.output_type
class GetBucketsBucketRefererConfigResult(dict):
    def __init__(__self__, *,
                 allow_empty: bool,
                 referers: Sequence[str]):
        """
        :param bool allow_empty: Indicate whether the access request referer field can be empty.
        :param Sequence[str] referers: Referer access whitelist.
        """
        pulumi.set(__self__, "allow_empty", allow_empty)
        pulumi.set(__self__, "referers", referers)

    @property
    @pulumi.getter(name="allowEmpty")
    def allow_empty(self) -> bool:
        """
        Indicate whether the access request referer field can be empty.
        """
        return pulumi.get(self, "allow_empty")

    @property
    @pulumi.getter
    def referers(self) -> Sequence[str]:
        """
        Referer access whitelist.
        """
        return pulumi.get(self, "referers")


@pulumi.output_type
class GetBucketsBucketServerSideEncryptionRuleResult(dict):
    def __init__(__self__, *,
                 kms_master_key_id: str,
                 sse_algorithm: str):
        """
        :param str kms_master_key_id: The alibaba cloud KMS master key ID used for the SSE-KMS encryption.
        :param str sse_algorithm: The server-side encryption algorithm to use.
        """
        pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)
        pulumi.set(__self__, "sse_algorithm", sse_algorithm)

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> str:
        """
        The alibaba cloud KMS master key ID used for the SSE-KMS encryption.
        """
        return pulumi.get(self, "kms_master_key_id")

    @property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> str:
        """
        The server-side encryption algorithm to use.
        """
        return pulumi.get(self, "sse_algorithm")


@pulumi.output_type
class GetBucketsBucketVersioningResult(dict):
    def __init__(__self__, *,
                 status: str):
        """
        :param str status: A bucket versioning state. Possible values:`Enabled` and `Suspended`.
        """
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        A bucket versioning state. Possible values:`Enabled` and `Suspended`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetBucketsBucketWebsiteResult(dict):
    def __init__(__self__, *,
                 error_document: str,
                 index_document: str):
        """
        :param str error_document: Key of the HTML document containing the error page.
        :param str index_document: Key of the HTML document containing the home page.
        """
        pulumi.set(__self__, "error_document", error_document)
        pulumi.set(__self__, "index_document", index_document)

    @property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> str:
        """
        Key of the HTML document containing the error page.
        """
        return pulumi.get(self, "error_document")

    @property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> str:
        """
        Key of the HTML document containing the home page.
        """
        return pulumi.get(self, "index_document")


@pulumi.output_type
class GetInstanceAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 domain: str,
                 endpoint: str,
                 id: str,
                 instance_name: str,
                 region: str,
                 vpc_id: str,
                 vpc_name: str):
        """
        :param str domain: The domain of the instance attachment.
        :param str endpoint: The access endpoint of the instance attachment.
        :param str id: The resource ID, the value is same as "instance_name".
        :param str instance_name: The name of OTS instance.
        :param str region: The region of the instance attachment.
        :param str vpc_id: The ID of attaching VPC to instance.
        :param str vpc_name: The name of attaching VPC to instance.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_name", vpc_name)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The domain of the instance attachment.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        The access endpoint of the instance attachment.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource ID, the value is same as "instance_name".
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The name of OTS instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region of the instance attachment.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of attaching VPC to instance.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> str:
        """
        The name of attaching VPC to instance.
        """
        return pulumi.get(self, "vpc_name")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 cluster_type: str,
                 create_time: str,
                 description: str,
                 entity_quota: int,
                 id: str,
                 name: str,
                 network: str,
                 read_capacity: int,
                 status: str,
                 tags: Mapping[str, Any],
                 user_id: str,
                 write_capacity: int):
        """
        :param str cluster_type: The cluster type of the instance. Possible values: `SSD`, `HYBRID`.
        :param str create_time: The create time of the instance.
        :param str description: The description of the instance.
        :param int entity_quota: The instance quota which indicating the maximum number of tables.
        :param str id: ID of the instance.
        :param str name: Instance name.
        :param str network: The network type of the instance. Possible values: `NORMAL`, `VPC`, `VPC_CONSOLE`.
        :param int read_capacity: The maximum adjustable read capacity unit of the instance.
        :param str status: Instance status. Possible values: `Running`, `Disabled`, `Deleting`.
        :param Mapping[str, Any] tags: A map of tags assigned to the instance. It must be in the format:
               ```python
               import pulumi
               import pulumi_alicloud as alicloud
               
               instances_ds = alicloud.ots.get_instances(tags={
                   "tagKey1": "tagValue1",
                   "tagKey2": "tagValue2",
               })
               ```
        :param str user_id: The user id of the instance.
        :param int write_capacity: The maximum adjustable write capacity unit of the instance.
        """
        pulumi.set(__self__, "cluster_type", cluster_type)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "entity_quota", entity_quota)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "read_capacity", read_capacity)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "user_id", user_id)
        pulumi.set(__self__, "write_capacity", write_capacity)

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> str:
        """
        The cluster type of the instance. Possible values: `SSD`, `HYBRID`.
        """
        return pulumi.get(self, "cluster_type")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The create time of the instance.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="entityQuota")
    def entity_quota(self) -> int:
        """
        The instance quota which indicating the maximum number of tables.
        """
        return pulumi.get(self, "entity_quota")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Instance name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        The network type of the instance. Possible values: `NORMAL`, `VPC`, `VPC_CONSOLE`.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="readCapacity")
    def read_capacity(self) -> int:
        """
        The maximum adjustable read capacity unit of the instance.
        """
        return pulumi.get(self, "read_capacity")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Instance status. Possible values: `Running`, `Disabled`, `Deleting`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A map of tags assigned to the instance. It must be in the format:
        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        instances_ds = alicloud.ots.get_instances(tags={
            "tagKey1": "tagValue1",
            "tagKey2": "tagValue2",
        })
        ```
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        The user id of the instance.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="writeCapacity")
    def write_capacity(self) -> int:
        """
        The maximum adjustable write capacity unit of the instance.
        """
        return pulumi.get(self, "write_capacity")


@pulumi.output_type
class GetTablesTableResult(dict):
    def __init__(__self__, *,
                 defined_columns: Sequence['outputs.GetTablesTableDefinedColumnResult'],
                 id: str,
                 instance_name: str,
                 max_version: int,
                 primary_keys: Sequence['outputs.GetTablesTablePrimaryKeyResult'],
                 table_name: str,
                 time_to_live: int):
        """
        :param str id: ID of the table. The value is `<instance_name>:<table_name>`.
        :param str instance_name: The name of OTS instance.
        :param int max_version: The maximum number of versions stored in this table.
        :param Sequence['GetTablesTablePrimaryKeyArgs'] primary_keys: The property of `TableMeta` which indicates the structure information of a table.
        :param str table_name: The table name of the OTS which could not be changed.
        :param int time_to_live: The retention time of data stored in this table.
        """
        pulumi.set(__self__, "defined_columns", defined_columns)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "max_version", max_version)
        pulumi.set(__self__, "primary_keys", primary_keys)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "time_to_live", time_to_live)

    @property
    @pulumi.getter(name="definedColumns")
    def defined_columns(self) -> Sequence['outputs.GetTablesTableDefinedColumnResult']:
        return pulumi.get(self, "defined_columns")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the table. The value is `<instance_name>:<table_name>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The name of OTS instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="maxVersion")
    def max_version(self) -> int:
        """
        The maximum number of versions stored in this table.
        """
        return pulumi.get(self, "max_version")

    @property
    @pulumi.getter(name="primaryKeys")
    def primary_keys(self) -> Sequence['outputs.GetTablesTablePrimaryKeyResult']:
        """
        The property of `TableMeta` which indicates the structure information of a table.
        """
        return pulumi.get(self, "primary_keys")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        """
        The table name of the OTS which could not be changed.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="timeToLive")
    def time_to_live(self) -> int:
        """
        The retention time of data stored in this table.
        """
        return pulumi.get(self, "time_to_live")


@pulumi.output_type
class GetTablesTableDefinedColumnResult(dict):
    def __init__(__self__, *,
                 name: str,
                 type: str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetTablesTablePrimaryKeyResult(dict):
    def __init__(__self__, *,
                 name: str,
                 type: str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


