# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SearchIndexArgs', 'SearchIndex']

@pulumi.input_type
class SearchIndexArgs:
    def __init__(__self__, *,
                 index_name: pulumi.Input[str],
                 instance_name: pulumi.Input[str],
                 schemas: pulumi.Input[Sequence[pulumi.Input['SearchIndexSchemaArgs']]],
                 table_name: pulumi.Input[str],
                 time_to_live: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a SearchIndex resource.
        :param pulumi.Input[str] index_name: The index name of the OTS Table. If changed, a new index would be created.
        :param pulumi.Input[str] instance_name: The name of the OTS instance in which table will located.
        :param pulumi.Input[Sequence[pulumi.Input['SearchIndexSchemaArgs']]] schemas: The schema of the search index. If changed, a new index would be created. See `schema` below.
        :param pulumi.Input[str] table_name: The name of the OTS table. If changed, a new table would be created.
        :param pulumi.Input[int] time_to_live: The index type of the OTS Table. Specifies the retention period of data in the search index. Unit: seconds. Default value: -1.
               If the retention period exceeds the TTL value, OTS automatically deletes expired data.
        """
        pulumi.set(__self__, "index_name", index_name)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "schemas", schemas)
        pulumi.set(__self__, "table_name", table_name)
        if time_to_live is not None:
            pulumi.set(__self__, "time_to_live", time_to_live)

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> pulumi.Input[str]:
        """
        The index name of the OTS Table. If changed, a new index would be created.
        """
        return pulumi.get(self, "index_name")

    @index_name.setter
    def index_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "index_name", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Input[str]:
        """
        The name of the OTS instance in which table will located.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Input[Sequence[pulumi.Input['SearchIndexSchemaArgs']]]:
        """
        The schema of the search index. If changed, a new index would be created. See `schema` below.
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: pulumi.Input[Sequence[pulumi.Input['SearchIndexSchemaArgs']]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[str]:
        """
        The name of the OTS table. If changed, a new table would be created.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="timeToLive")
    def time_to_live(self) -> Optional[pulumi.Input[int]]:
        """
        The index type of the OTS Table. Specifies the retention period of data in the search index. Unit: seconds. Default value: -1.
        If the retention period exceeds the TTL value, OTS automatically deletes expired data.
        """
        return pulumi.get(self, "time_to_live")

    @time_to_live.setter
    def time_to_live(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "time_to_live", value)


@pulumi.input_type
class _SearchIndexState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[int]] = None,
                 current_sync_timestamp: Optional[pulumi.Input[int]] = None,
                 index_id: Optional[pulumi.Input[str]] = None,
                 index_name: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input['SearchIndexSchemaArgs']]]] = None,
                 sync_phase: Optional[pulumi.Input[str]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 time_to_live: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering SearchIndex resources.
        :param pulumi.Input[int] create_time: The search index create time.
        :param pulumi.Input[int] current_sync_timestamp: The timestamp for sync phase.
        :param pulumi.Input[str] index_id: The index id of the search index which could not be changed.
        :param pulumi.Input[str] index_name: The index name of the OTS Table. If changed, a new index would be created.
        :param pulumi.Input[str] instance_name: The name of the OTS instance in which table will located.
        :param pulumi.Input[Sequence[pulumi.Input['SearchIndexSchemaArgs']]] schemas: The schema of the search index. If changed, a new index would be created. See `schema` below.
        :param pulumi.Input[str] sync_phase: The search index sync phase. possible values: `Full`, `Incr`.
        :param pulumi.Input[str] table_name: The name of the OTS table. If changed, a new table would be created.
        :param pulumi.Input[int] time_to_live: The index type of the OTS Table. Specifies the retention period of data in the search index. Unit: seconds. Default value: -1.
               If the retention period exceeds the TTL value, OTS automatically deletes expired data.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if current_sync_timestamp is not None:
            pulumi.set(__self__, "current_sync_timestamp", current_sync_timestamp)
        if index_id is not None:
            pulumi.set(__self__, "index_id", index_id)
        if index_name is not None:
            pulumi.set(__self__, "index_name", index_name)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if sync_phase is not None:
            pulumi.set(__self__, "sync_phase", sync_phase)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)
        if time_to_live is not None:
            pulumi.set(__self__, "time_to_live", time_to_live)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[int]]:
        """
        The search index create time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="currentSyncTimestamp")
    def current_sync_timestamp(self) -> Optional[pulumi.Input[int]]:
        """
        The timestamp for sync phase.
        """
        return pulumi.get(self, "current_sync_timestamp")

    @current_sync_timestamp.setter
    def current_sync_timestamp(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "current_sync_timestamp", value)

    @property
    @pulumi.getter(name="indexId")
    def index_id(self) -> Optional[pulumi.Input[str]]:
        """
        The index id of the search index which could not be changed.
        """
        return pulumi.get(self, "index_id")

    @index_id.setter
    def index_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "index_id", value)

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> Optional[pulumi.Input[str]]:
        """
        The index name of the OTS Table. If changed, a new index would be created.
        """
        return pulumi.get(self, "index_name")

    @index_name.setter
    def index_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "index_name", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the OTS instance in which table will located.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SearchIndexSchemaArgs']]]]:
        """
        The schema of the search index. If changed, a new index would be created. See `schema` below.
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SearchIndexSchemaArgs']]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="syncPhase")
    def sync_phase(self) -> Optional[pulumi.Input[str]]:
        """
        The search index sync phase. possible values: `Full`, `Incr`.
        """
        return pulumi.get(self, "sync_phase")

    @sync_phase.setter
    def sync_phase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sync_phase", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the OTS table. If changed, a new table would be created.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="timeToLive")
    def time_to_live(self) -> Optional[pulumi.Input[int]]:
        """
        The index type of the OTS Table. Specifies the retention period of data in the search index. Unit: seconds. Default value: -1.
        If the retention period exceeds the TTL value, OTS automatically deletes expired data.
        """
        return pulumi.get(self, "time_to_live")

    @time_to_live.setter
    def time_to_live(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "time_to_live", value)


class SearchIndex(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 index_name: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SearchIndexSchemaArgs']]]]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 time_to_live: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides an OTS search index resource.

        For information about OTS search index and how to use it, see [Search index overview](https://www.alibabacloud.com/help/en/tablestore/latest/search-index-overview).

        > **NOTE:** Available since v1.187.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_instance = alicloud.ots.Instance("defaultInstance",
            description=name,
            accessed_by="Any",
            tags={
                "Created": "TF",
                "For": "example",
            })
        default_table = alicloud.ots.Table("defaultTable",
            instance_name=default_instance.name,
            table_name="tf_example",
            time_to_live=-1,
            max_version=1,
            enable_sse=True,
            sse_key_type="SSE_KMS_SERVICE",
            primary_keys=[
                alicloud.ots.TablePrimaryKeyArgs(
                    name="pk1",
                    type="Integer",
                ),
                alicloud.ots.TablePrimaryKeyArgs(
                    name="pk2",
                    type="String",
                ),
                alicloud.ots.TablePrimaryKeyArgs(
                    name="pk3",
                    type="Binary",
                ),
            ])
        default_search_index = alicloud.ots.SearchIndex("defaultSearchIndex",
            instance_name=default_instance.name,
            table_name=default_table.table_name,
            index_name="example_index",
            time_to_live=-1,
            schemas=[alicloud.ots.SearchIndexSchemaArgs(
                field_schemas=[
                    alicloud.ots.SearchIndexSchemaFieldSchemaArgs(
                        field_name="col1",
                        field_type="Text",
                        is_array=False,
                        index=True,
                        analyzer="Split",
                        store=True,
                    ),
                    alicloud.ots.SearchIndexSchemaFieldSchemaArgs(
                        field_name="col2",
                        field_type="Long",
                        enable_sort_and_agg=True,
                    ),
                    alicloud.ots.SearchIndexSchemaFieldSchemaArgs(
                        field_name="pk1",
                        field_type="Long",
                    ),
                    alicloud.ots.SearchIndexSchemaFieldSchemaArgs(
                        field_name="pk2",
                        field_type="Text",
                    ),
                ],
                index_settings=[alicloud.ots.SearchIndexSchemaIndexSettingArgs(
                    routing_fields=[
                        "pk1",
                        "pk2",
                    ],
                )],
                index_sorts=[alicloud.ots.SearchIndexSchemaIndexSortArgs(
                    sorters=[
                        alicloud.ots.SearchIndexSchemaIndexSortSorterArgs(
                            sorter_type="PrimaryKeySort",
                            order="Asc",
                        ),
                        alicloud.ots.SearchIndexSchemaIndexSortSorterArgs(
                            sorter_type="FieldSort",
                            order="Desc",
                            field_name="col2",
                            mode="Max",
                        ),
                    ],
                )],
            )])
        ```

        ## Import

        OTS search index can be imported using id, e.g.

        ```sh
         $ pulumi import alicloud:ots/searchIndex:SearchIndex index1 <instance_name>:<table_name>:<index_name>:<index_type>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] index_name: The index name of the OTS Table. If changed, a new index would be created.
        :param pulumi.Input[str] instance_name: The name of the OTS instance in which table will located.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SearchIndexSchemaArgs']]]] schemas: The schema of the search index. If changed, a new index would be created. See `schema` below.
        :param pulumi.Input[str] table_name: The name of the OTS table. If changed, a new table would be created.
        :param pulumi.Input[int] time_to_live: The index type of the OTS Table. Specifies the retention period of data in the search index. Unit: seconds. Default value: -1.
               If the retention period exceeds the TTL value, OTS automatically deletes expired data.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SearchIndexArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an OTS search index resource.

        For information about OTS search index and how to use it, see [Search index overview](https://www.alibabacloud.com/help/en/tablestore/latest/search-index-overview).

        > **NOTE:** Available since v1.187.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_instance = alicloud.ots.Instance("defaultInstance",
            description=name,
            accessed_by="Any",
            tags={
                "Created": "TF",
                "For": "example",
            })
        default_table = alicloud.ots.Table("defaultTable",
            instance_name=default_instance.name,
            table_name="tf_example",
            time_to_live=-1,
            max_version=1,
            enable_sse=True,
            sse_key_type="SSE_KMS_SERVICE",
            primary_keys=[
                alicloud.ots.TablePrimaryKeyArgs(
                    name="pk1",
                    type="Integer",
                ),
                alicloud.ots.TablePrimaryKeyArgs(
                    name="pk2",
                    type="String",
                ),
                alicloud.ots.TablePrimaryKeyArgs(
                    name="pk3",
                    type="Binary",
                ),
            ])
        default_search_index = alicloud.ots.SearchIndex("defaultSearchIndex",
            instance_name=default_instance.name,
            table_name=default_table.table_name,
            index_name="example_index",
            time_to_live=-1,
            schemas=[alicloud.ots.SearchIndexSchemaArgs(
                field_schemas=[
                    alicloud.ots.SearchIndexSchemaFieldSchemaArgs(
                        field_name="col1",
                        field_type="Text",
                        is_array=False,
                        index=True,
                        analyzer="Split",
                        store=True,
                    ),
                    alicloud.ots.SearchIndexSchemaFieldSchemaArgs(
                        field_name="col2",
                        field_type="Long",
                        enable_sort_and_agg=True,
                    ),
                    alicloud.ots.SearchIndexSchemaFieldSchemaArgs(
                        field_name="pk1",
                        field_type="Long",
                    ),
                    alicloud.ots.SearchIndexSchemaFieldSchemaArgs(
                        field_name="pk2",
                        field_type="Text",
                    ),
                ],
                index_settings=[alicloud.ots.SearchIndexSchemaIndexSettingArgs(
                    routing_fields=[
                        "pk1",
                        "pk2",
                    ],
                )],
                index_sorts=[alicloud.ots.SearchIndexSchemaIndexSortArgs(
                    sorters=[
                        alicloud.ots.SearchIndexSchemaIndexSortSorterArgs(
                            sorter_type="PrimaryKeySort",
                            order="Asc",
                        ),
                        alicloud.ots.SearchIndexSchemaIndexSortSorterArgs(
                            sorter_type="FieldSort",
                            order="Desc",
                            field_name="col2",
                            mode="Max",
                        ),
                    ],
                )],
            )])
        ```

        ## Import

        OTS search index can be imported using id, e.g.

        ```sh
         $ pulumi import alicloud:ots/searchIndex:SearchIndex index1 <instance_name>:<table_name>:<index_name>:<index_type>
        ```

        :param str resource_name: The name of the resource.
        :param SearchIndexArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SearchIndexArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 index_name: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SearchIndexSchemaArgs']]]]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 time_to_live: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SearchIndexArgs.__new__(SearchIndexArgs)

            if index_name is None and not opts.urn:
                raise TypeError("Missing required property 'index_name'")
            __props__.__dict__["index_name"] = index_name
            if instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_name'")
            __props__.__dict__["instance_name"] = instance_name
            if schemas is None and not opts.urn:
                raise TypeError("Missing required property 'schemas'")
            __props__.__dict__["schemas"] = schemas
            if table_name is None and not opts.urn:
                raise TypeError("Missing required property 'table_name'")
            __props__.__dict__["table_name"] = table_name
            __props__.__dict__["time_to_live"] = time_to_live
            __props__.__dict__["create_time"] = None
            __props__.__dict__["current_sync_timestamp"] = None
            __props__.__dict__["index_id"] = None
            __props__.__dict__["sync_phase"] = None
        super(SearchIndex, __self__).__init__(
            'alicloud:ots/searchIndex:SearchIndex',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[int]] = None,
            current_sync_timestamp: Optional[pulumi.Input[int]] = None,
            index_id: Optional[pulumi.Input[str]] = None,
            index_name: Optional[pulumi.Input[str]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SearchIndexSchemaArgs']]]]] = None,
            sync_phase: Optional[pulumi.Input[str]] = None,
            table_name: Optional[pulumi.Input[str]] = None,
            time_to_live: Optional[pulumi.Input[int]] = None) -> 'SearchIndex':
        """
        Get an existing SearchIndex resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] create_time: The search index create time.
        :param pulumi.Input[int] current_sync_timestamp: The timestamp for sync phase.
        :param pulumi.Input[str] index_id: The index id of the search index which could not be changed.
        :param pulumi.Input[str] index_name: The index name of the OTS Table. If changed, a new index would be created.
        :param pulumi.Input[str] instance_name: The name of the OTS instance in which table will located.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SearchIndexSchemaArgs']]]] schemas: The schema of the search index. If changed, a new index would be created. See `schema` below.
        :param pulumi.Input[str] sync_phase: The search index sync phase. possible values: `Full`, `Incr`.
        :param pulumi.Input[str] table_name: The name of the OTS table. If changed, a new table would be created.
        :param pulumi.Input[int] time_to_live: The index type of the OTS Table. Specifies the retention period of data in the search index. Unit: seconds. Default value: -1.
               If the retention period exceeds the TTL value, OTS automatically deletes expired data.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SearchIndexState.__new__(_SearchIndexState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["current_sync_timestamp"] = current_sync_timestamp
        __props__.__dict__["index_id"] = index_id
        __props__.__dict__["index_name"] = index_name
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["sync_phase"] = sync_phase
        __props__.__dict__["table_name"] = table_name
        __props__.__dict__["time_to_live"] = time_to_live
        return SearchIndex(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[int]:
        """
        The search index create time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="currentSyncTimestamp")
    def current_sync_timestamp(self) -> pulumi.Output[int]:
        """
        The timestamp for sync phase.
        """
        return pulumi.get(self, "current_sync_timestamp")

    @property
    @pulumi.getter(name="indexId")
    def index_id(self) -> pulumi.Output[str]:
        """
        The index id of the search index which could not be changed.
        """
        return pulumi.get(self, "index_id")

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> pulumi.Output[str]:
        """
        The index name of the OTS Table. If changed, a new index would be created.
        """
        return pulumi.get(self, "index_name")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[str]:
        """
        The name of the OTS instance in which table will located.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Sequence['outputs.SearchIndexSchema']]:
        """
        The schema of the search index. If changed, a new index would be created. See `schema` below.
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter(name="syncPhase")
    def sync_phase(self) -> pulumi.Output[str]:
        """
        The search index sync phase. possible values: `Full`, `Incr`.
        """
        return pulumi.get(self, "sync_phase")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Output[str]:
        """
        The name of the OTS table. If changed, a new table would be created.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="timeToLive")
    def time_to_live(self) -> pulumi.Output[Optional[int]]:
        """
        The index type of the OTS Table. Specifies the retention period of data in the search index. Unit: seconds. Default value: -1.
        If the retention period exceeds the TTL value, OTS automatically deletes expired data.
        """
        return pulumi.get(self, "time_to_live")

