# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TunnelArgs', 'Tunnel']

@pulumi.input_type
class TunnelArgs:
    def __init__(__self__, *,
                 instance_name: pulumi.Input[str],
                 table_name: pulumi.Input[str],
                 tunnel_name: pulumi.Input[str],
                 tunnel_type: pulumi.Input[str]):
        """
        The set of arguments for constructing a Tunnel resource.
        :param pulumi.Input[str] instance_name: The name of the OTS instance in which table will located.
        :param pulumi.Input[str] table_name: The name of the OTS table. If changed, a new table would be created.
        :param pulumi.Input[str] tunnel_name: The name of the OTS tunnel. If changed, a new tunnel would be created.
        :param pulumi.Input[str] tunnel_type: The type of the OTS tunnel. Only `BaseAndStream`, `BaseData` or `Stream` is allowed.
        """
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "tunnel_name", tunnel_name)
        pulumi.set(__self__, "tunnel_type", tunnel_type)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Input[str]:
        """
        The name of the OTS instance in which table will located.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[str]:
        """
        The name of the OTS table. If changed, a new table would be created.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="tunnelName")
    def tunnel_name(self) -> pulumi.Input[str]:
        """
        The name of the OTS tunnel. If changed, a new tunnel would be created.
        """
        return pulumi.get(self, "tunnel_name")

    @tunnel_name.setter
    def tunnel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "tunnel_name", value)

    @property
    @pulumi.getter(name="tunnelType")
    def tunnel_type(self) -> pulumi.Input[str]:
        """
        The type of the OTS tunnel. Only `BaseAndStream`, `BaseData` or `Stream` is allowed.
        """
        return pulumi.get(self, "tunnel_type")

    @tunnel_type.setter
    def tunnel_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "tunnel_type", value)


@pulumi.input_type
class _TunnelState:
    def __init__(__self__, *,
                 channels: Optional[pulumi.Input[Sequence[pulumi.Input['TunnelChannelArgs']]]] = None,
                 create_time: Optional[pulumi.Input[int]] = None,
                 expired: Optional[pulumi.Input[bool]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 tunnel_id: Optional[pulumi.Input[str]] = None,
                 tunnel_name: Optional[pulumi.Input[str]] = None,
                 tunnel_rpo: Optional[pulumi.Input[int]] = None,
                 tunnel_stage: Optional[pulumi.Input[str]] = None,
                 tunnel_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Tunnel resources.
        :param pulumi.Input[Sequence[pulumi.Input['TunnelChannelArgs']]] channels: The channels of OTS tunnel. Each element contains the following attributes:
        :param pulumi.Input[int] create_time: The creation time of the Tunnel.
        :param pulumi.Input[bool] expired: Whether the tunnel has expired.
        :param pulumi.Input[str] instance_name: The name of the OTS instance in which table will located.
        :param pulumi.Input[str] table_name: The name of the OTS table. If changed, a new table would be created.
        :param pulumi.Input[str] tunnel_id: The tunnel id of the OTS which could not be changed.
        :param pulumi.Input[str] tunnel_name: The name of the OTS tunnel. If changed, a new tunnel would be created.
        :param pulumi.Input[int] tunnel_rpo: The latest consumption time of the tunnel, unix time in nanosecond.
        :param pulumi.Input[str] tunnel_stage: The stage of OTS tunnel, valid values: `InitBaseDataAndStreamShard`, `ProcessBaseData`, `ProcessStream`.
        :param pulumi.Input[str] tunnel_type: The type of the OTS tunnel. Only `BaseAndStream`, `BaseData` or `Stream` is allowed.
        """
        if channels is not None:
            pulumi.set(__self__, "channels", channels)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if expired is not None:
            pulumi.set(__self__, "expired", expired)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)
        if tunnel_id is not None:
            pulumi.set(__self__, "tunnel_id", tunnel_id)
        if tunnel_name is not None:
            pulumi.set(__self__, "tunnel_name", tunnel_name)
        if tunnel_rpo is not None:
            pulumi.set(__self__, "tunnel_rpo", tunnel_rpo)
        if tunnel_stage is not None:
            pulumi.set(__self__, "tunnel_stage", tunnel_stage)
        if tunnel_type is not None:
            pulumi.set(__self__, "tunnel_type", tunnel_type)

    @property
    @pulumi.getter
    def channels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TunnelChannelArgs']]]]:
        """
        The channels of OTS tunnel. Each element contains the following attributes:
        """
        return pulumi.get(self, "channels")

    @channels.setter
    def channels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TunnelChannelArgs']]]]):
        pulumi.set(self, "channels", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[int]]:
        """
        The creation time of the Tunnel.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def expired(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the tunnel has expired.
        """
        return pulumi.get(self, "expired")

    @expired.setter
    def expired(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "expired", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the OTS instance in which table will located.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the OTS table. If changed, a new table would be created.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> Optional[pulumi.Input[str]]:
        """
        The tunnel id of the OTS which could not be changed.
        """
        return pulumi.get(self, "tunnel_id")

    @tunnel_id.setter
    def tunnel_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_id", value)

    @property
    @pulumi.getter(name="tunnelName")
    def tunnel_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the OTS tunnel. If changed, a new tunnel would be created.
        """
        return pulumi.get(self, "tunnel_name")

    @tunnel_name.setter
    def tunnel_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_name", value)

    @property
    @pulumi.getter(name="tunnelRpo")
    def tunnel_rpo(self) -> Optional[pulumi.Input[int]]:
        """
        The latest consumption time of the tunnel, unix time in nanosecond.
        """
        return pulumi.get(self, "tunnel_rpo")

    @tunnel_rpo.setter
    def tunnel_rpo(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tunnel_rpo", value)

    @property
    @pulumi.getter(name="tunnelStage")
    def tunnel_stage(self) -> Optional[pulumi.Input[str]]:
        """
        The stage of OTS tunnel, valid values: `InitBaseDataAndStreamShard`, `ProcessBaseData`, `ProcessStream`.
        """
        return pulumi.get(self, "tunnel_stage")

    @tunnel_stage.setter
    def tunnel_stage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_stage", value)

    @property
    @pulumi.getter(name="tunnelType")
    def tunnel_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the OTS tunnel. Only `BaseAndStream`, `BaseData` or `Stream` is allowed.
        """
        return pulumi.get(self, "tunnel_type")

    @tunnel_type.setter
    def tunnel_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_type", value)


class Tunnel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 tunnel_name: Optional[pulumi.Input[str]] = None,
                 tunnel_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an OTS tunnel resource.

        For information about OTS tunnel and how to use it, see [Tunnel overview](https://www.alibabacloud.com/help/en/tablestore/latest/tunnel-service-overview).

        > **NOTE:** Available since v1.172.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_instance = alicloud.ots.Instance("defaultInstance",
            description=name,
            accessed_by="Any",
            tags={
                "Created": "TF",
                "For": "example",
            })
        default_table = alicloud.ots.Table("defaultTable",
            instance_name=default_instance.name,
            table_name="tf_example",
            time_to_live=-1,
            max_version=1,
            enable_sse=True,
            sse_key_type="SSE_KMS_SERVICE",
            primary_keys=[
                alicloud.ots.TablePrimaryKeyArgs(
                    name="pk1",
                    type="Integer",
                ),
                alicloud.ots.TablePrimaryKeyArgs(
                    name="pk2",
                    type="String",
                ),
                alicloud.ots.TablePrimaryKeyArgs(
                    name="pk3",
                    type="Binary",
                ),
            ])
        default_tunnel = alicloud.ots.Tunnel("defaultTunnel",
            instance_name=default_instance.name,
            table_name=default_table.table_name,
            tunnel_name="tf_example",
            tunnel_type="BaseAndStream")
        ```

        ## Import

        OTS tunnel can be imported using id, e.g.

        ```sh
         $ pulumi import alicloud:ots/tunnel:Tunnel foo <instance_name>:<table_name>:<tunnel_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] instance_name: The name of the OTS instance in which table will located.
        :param pulumi.Input[str] table_name: The name of the OTS table. If changed, a new table would be created.
        :param pulumi.Input[str] tunnel_name: The name of the OTS tunnel. If changed, a new tunnel would be created.
        :param pulumi.Input[str] tunnel_type: The type of the OTS tunnel. Only `BaseAndStream`, `BaseData` or `Stream` is allowed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TunnelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an OTS tunnel resource.

        For information about OTS tunnel and how to use it, see [Tunnel overview](https://www.alibabacloud.com/help/en/tablestore/latest/tunnel-service-overview).

        > **NOTE:** Available since v1.172.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_instance = alicloud.ots.Instance("defaultInstance",
            description=name,
            accessed_by="Any",
            tags={
                "Created": "TF",
                "For": "example",
            })
        default_table = alicloud.ots.Table("defaultTable",
            instance_name=default_instance.name,
            table_name="tf_example",
            time_to_live=-1,
            max_version=1,
            enable_sse=True,
            sse_key_type="SSE_KMS_SERVICE",
            primary_keys=[
                alicloud.ots.TablePrimaryKeyArgs(
                    name="pk1",
                    type="Integer",
                ),
                alicloud.ots.TablePrimaryKeyArgs(
                    name="pk2",
                    type="String",
                ),
                alicloud.ots.TablePrimaryKeyArgs(
                    name="pk3",
                    type="Binary",
                ),
            ])
        default_tunnel = alicloud.ots.Tunnel("defaultTunnel",
            instance_name=default_instance.name,
            table_name=default_table.table_name,
            tunnel_name="tf_example",
            tunnel_type="BaseAndStream")
        ```

        ## Import

        OTS tunnel can be imported using id, e.g.

        ```sh
         $ pulumi import alicloud:ots/tunnel:Tunnel foo <instance_name>:<table_name>:<tunnel_name>
        ```

        :param str resource_name: The name of the resource.
        :param TunnelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TunnelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 tunnel_name: Optional[pulumi.Input[str]] = None,
                 tunnel_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TunnelArgs.__new__(TunnelArgs)

            if instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_name'")
            __props__.__dict__["instance_name"] = instance_name
            if table_name is None and not opts.urn:
                raise TypeError("Missing required property 'table_name'")
            __props__.__dict__["table_name"] = table_name
            if tunnel_name is None and not opts.urn:
                raise TypeError("Missing required property 'tunnel_name'")
            __props__.__dict__["tunnel_name"] = tunnel_name
            if tunnel_type is None and not opts.urn:
                raise TypeError("Missing required property 'tunnel_type'")
            __props__.__dict__["tunnel_type"] = tunnel_type
            __props__.__dict__["channels"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["expired"] = None
            __props__.__dict__["tunnel_id"] = None
            __props__.__dict__["tunnel_rpo"] = None
            __props__.__dict__["tunnel_stage"] = None
        super(Tunnel, __self__).__init__(
            'alicloud:ots/tunnel:Tunnel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            channels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TunnelChannelArgs']]]]] = None,
            create_time: Optional[pulumi.Input[int]] = None,
            expired: Optional[pulumi.Input[bool]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            table_name: Optional[pulumi.Input[str]] = None,
            tunnel_id: Optional[pulumi.Input[str]] = None,
            tunnel_name: Optional[pulumi.Input[str]] = None,
            tunnel_rpo: Optional[pulumi.Input[int]] = None,
            tunnel_stage: Optional[pulumi.Input[str]] = None,
            tunnel_type: Optional[pulumi.Input[str]] = None) -> 'Tunnel':
        """
        Get an existing Tunnel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TunnelChannelArgs']]]] channels: The channels of OTS tunnel. Each element contains the following attributes:
        :param pulumi.Input[int] create_time: The creation time of the Tunnel.
        :param pulumi.Input[bool] expired: Whether the tunnel has expired.
        :param pulumi.Input[str] instance_name: The name of the OTS instance in which table will located.
        :param pulumi.Input[str] table_name: The name of the OTS table. If changed, a new table would be created.
        :param pulumi.Input[str] tunnel_id: The tunnel id of the OTS which could not be changed.
        :param pulumi.Input[str] tunnel_name: The name of the OTS tunnel. If changed, a new tunnel would be created.
        :param pulumi.Input[int] tunnel_rpo: The latest consumption time of the tunnel, unix time in nanosecond.
        :param pulumi.Input[str] tunnel_stage: The stage of OTS tunnel, valid values: `InitBaseDataAndStreamShard`, `ProcessBaseData`, `ProcessStream`.
        :param pulumi.Input[str] tunnel_type: The type of the OTS tunnel. Only `BaseAndStream`, `BaseData` or `Stream` is allowed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TunnelState.__new__(_TunnelState)

        __props__.__dict__["channels"] = channels
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["expired"] = expired
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["table_name"] = table_name
        __props__.__dict__["tunnel_id"] = tunnel_id
        __props__.__dict__["tunnel_name"] = tunnel_name
        __props__.__dict__["tunnel_rpo"] = tunnel_rpo
        __props__.__dict__["tunnel_stage"] = tunnel_stage
        __props__.__dict__["tunnel_type"] = tunnel_type
        return Tunnel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def channels(self) -> pulumi.Output[Sequence['outputs.TunnelChannel']]:
        """
        The channels of OTS tunnel. Each element contains the following attributes:
        """
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[int]:
        """
        The creation time of the Tunnel.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def expired(self) -> pulumi.Output[bool]:
        """
        Whether the tunnel has expired.
        """
        return pulumi.get(self, "expired")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[str]:
        """
        The name of the OTS instance in which table will located.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Output[str]:
        """
        The name of the OTS table. If changed, a new table would be created.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> pulumi.Output[str]:
        """
        The tunnel id of the OTS which could not be changed.
        """
        return pulumi.get(self, "tunnel_id")

    @property
    @pulumi.getter(name="tunnelName")
    def tunnel_name(self) -> pulumi.Output[str]:
        """
        The name of the OTS tunnel. If changed, a new tunnel would be created.
        """
        return pulumi.get(self, "tunnel_name")

    @property
    @pulumi.getter(name="tunnelRpo")
    def tunnel_rpo(self) -> pulumi.Output[int]:
        """
        The latest consumption time of the tunnel, unix time in nanosecond.
        """
        return pulumi.get(self, "tunnel_rpo")

    @property
    @pulumi.getter(name="tunnelStage")
    def tunnel_stage(self) -> pulumi.Output[str]:
        """
        The stage of OTS tunnel, valid values: `InitBaseDataAndStreamShard`, `ProcessBaseData`, `ProcessStream`.
        """
        return pulumi.get(self, "tunnel_stage")

    @property
    @pulumi.getter(name="tunnelType")
    def tunnel_type(self) -> pulumi.Output[str]:
        """
        The type of the OTS tunnel. Only `BaseAndStream`, `BaseData` or `Stream` is allowed.
        """
        return pulumi.get(self, "tunnel_type")

