# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['EndpointAddressArgs', 'EndpointAddress']

@pulumi.input_type
class EndpointAddressArgs:
    def __init__(__self__, *,
                 db_cluster_id: pulumi.Input[str],
                 db_endpoint_id: pulumi.Input[str],
                 connection_prefix: Optional[pulumi.Input[str]] = None,
                 net_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a EndpointAddress resource.
        :param pulumi.Input[str] db_cluster_id: The Id of cluster that can run database.
        :param pulumi.Input[str] db_endpoint_id: The Id of endpoint that can run database.
        :param pulumi.Input[str] connection_prefix: Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
        :param pulumi.Input[str] net_type: Internet connection net type. Valid value: `Public`. Default to `Public`. Currently supported only `Public`.
        """
        pulumi.set(__self__, "db_cluster_id", db_cluster_id)
        pulumi.set(__self__, "db_endpoint_id", db_endpoint_id)
        if connection_prefix is not None:
            pulumi.set(__self__, "connection_prefix", connection_prefix)
        if net_type is not None:
            pulumi.set(__self__, "net_type", net_type)

    @property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> pulumi.Input[str]:
        """
        The Id of cluster that can run database.
        """
        return pulumi.get(self, "db_cluster_id")

    @db_cluster_id.setter
    def db_cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_cluster_id", value)

    @property
    @pulumi.getter(name="dbEndpointId")
    def db_endpoint_id(self) -> pulumi.Input[str]:
        """
        The Id of endpoint that can run database.
        """
        return pulumi.get(self, "db_endpoint_id")

    @db_endpoint_id.setter
    def db_endpoint_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_endpoint_id", value)

    @property
    @pulumi.getter(name="connectionPrefix")
    def connection_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
        """
        return pulumi.get(self, "connection_prefix")

    @connection_prefix.setter
    def connection_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_prefix", value)

    @property
    @pulumi.getter(name="netType")
    def net_type(self) -> Optional[pulumi.Input[str]]:
        """
        Internet connection net type. Valid value: `Public`. Default to `Public`. Currently supported only `Public`.
        """
        return pulumi.get(self, "net_type")

    @net_type.setter
    def net_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "net_type", value)


@pulumi.input_type
class _EndpointAddressState:
    def __init__(__self__, *,
                 connection_prefix: Optional[pulumi.Input[str]] = None,
                 connection_string: Optional[pulumi.Input[str]] = None,
                 db_cluster_id: Optional[pulumi.Input[str]] = None,
                 db_endpoint_id: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 net_type: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering EndpointAddress resources.
        :param pulumi.Input[str] connection_prefix: Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
        :param pulumi.Input[str] connection_string: Connection cluster or endpoint string.
        :param pulumi.Input[str] db_cluster_id: The Id of cluster that can run database.
        :param pulumi.Input[str] db_endpoint_id: The Id of endpoint that can run database.
        :param pulumi.Input[str] ip_address: The ip address of connection string.
        :param pulumi.Input[str] net_type: Internet connection net type. Valid value: `Public`. Default to `Public`. Currently supported only `Public`.
        :param pulumi.Input[str] port: Connection cluster or endpoint port.
        """
        if connection_prefix is not None:
            pulumi.set(__self__, "connection_prefix", connection_prefix)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if db_cluster_id is not None:
            pulumi.set(__self__, "db_cluster_id", db_cluster_id)
        if db_endpoint_id is not None:
            pulumi.set(__self__, "db_endpoint_id", db_endpoint_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if net_type is not None:
            pulumi.set(__self__, "net_type", net_type)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="connectionPrefix")
    def connection_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
        """
        return pulumi.get(self, "connection_prefix")

    @connection_prefix.setter
    def connection_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_prefix", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        Connection cluster or endpoint string.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of cluster that can run database.
        """
        return pulumi.get(self, "db_cluster_id")

    @db_cluster_id.setter
    def db_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_cluster_id", value)

    @property
    @pulumi.getter(name="dbEndpointId")
    def db_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of endpoint that can run database.
        """
        return pulumi.get(self, "db_endpoint_id")

    @db_endpoint_id.setter
    def db_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_endpoint_id", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The ip address of connection string.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="netType")
    def net_type(self) -> Optional[pulumi.Input[str]]:
        """
        Internet connection net type. Valid value: `Public`. Default to `Public`. Currently supported only `Public`.
        """
        return pulumi.get(self, "net_type")

    @net_type.setter
    def net_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "net_type", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        Connection cluster or endpoint port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)


class EndpointAddress(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_prefix: Optional[pulumi.Input[str]] = None,
                 db_cluster_id: Optional[pulumi.Input[str]] = None,
                 db_endpoint_id: Optional[pulumi.Input[str]] = None,
                 net_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a PolarDB endpoint address resource to allocate an Internet endpoint address string for PolarDB instance.

        > **NOTE:** Available in v1.68.0+. Each PolarDB instance will allocate a intranet connection string automatically and its prefix is Cluster ID.
         To avoid unnecessary conflict, please specified a internet connection prefix before applying the resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_node_classes = alicloud.polardb.get_node_classes(db_type="MySQL",
            db_version="8.0",
            pay_type="PostPaid")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name="terraform-example",
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default_node_classes.classes[0].zone_id,
            vswitch_name="terraform-example")
        default_cluster = alicloud.polardb.Cluster("defaultCluster",
            db_type="MySQL",
            db_version="8.0",
            db_node_class=default_node_classes.classes[0].supported_engines[0].available_resources[0].db_node_class,
            pay_type="PostPaid",
            vswitch_id=default_switch.id,
            description="terraform-example")
        default_endpoints = alicloud.polardb.get_endpoints_output(db_cluster_id=default_cluster.id)
        default_endpoint_address = alicloud.polardb.EndpointAddress("defaultEndpointAddress",
            db_cluster_id=default_cluster.id,
            db_endpoint_id=default_endpoints.endpoints[0].db_endpoint_id,
            connection_prefix="polardbexample",
            net_type="Public")
        ```

        ## Import

        PolarDB endpoint address can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:polardb/endpointAddress:EndpointAddress example pc-abc123456:pe-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_prefix: Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
        :param pulumi.Input[str] db_cluster_id: The Id of cluster that can run database.
        :param pulumi.Input[str] db_endpoint_id: The Id of endpoint that can run database.
        :param pulumi.Input[str] net_type: Internet connection net type. Valid value: `Public`. Default to `Public`. Currently supported only `Public`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointAddressArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a PolarDB endpoint address resource to allocate an Internet endpoint address string for PolarDB instance.

        > **NOTE:** Available in v1.68.0+. Each PolarDB instance will allocate a intranet connection string automatically and its prefix is Cluster ID.
         To avoid unnecessary conflict, please specified a internet connection prefix before applying the resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_node_classes = alicloud.polardb.get_node_classes(db_type="MySQL",
            db_version="8.0",
            pay_type="PostPaid")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name="terraform-example",
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default_node_classes.classes[0].zone_id,
            vswitch_name="terraform-example")
        default_cluster = alicloud.polardb.Cluster("defaultCluster",
            db_type="MySQL",
            db_version="8.0",
            db_node_class=default_node_classes.classes[0].supported_engines[0].available_resources[0].db_node_class,
            pay_type="PostPaid",
            vswitch_id=default_switch.id,
            description="terraform-example")
        default_endpoints = alicloud.polardb.get_endpoints_output(db_cluster_id=default_cluster.id)
        default_endpoint_address = alicloud.polardb.EndpointAddress("defaultEndpointAddress",
            db_cluster_id=default_cluster.id,
            db_endpoint_id=default_endpoints.endpoints[0].db_endpoint_id,
            connection_prefix="polardbexample",
            net_type="Public")
        ```

        ## Import

        PolarDB endpoint address can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:polardb/endpointAddress:EndpointAddress example pc-abc123456:pe-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param EndpointAddressArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointAddressArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_prefix: Optional[pulumi.Input[str]] = None,
                 db_cluster_id: Optional[pulumi.Input[str]] = None,
                 db_endpoint_id: Optional[pulumi.Input[str]] = None,
                 net_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointAddressArgs.__new__(EndpointAddressArgs)

            __props__.__dict__["connection_prefix"] = connection_prefix
            if db_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_id'")
            __props__.__dict__["db_cluster_id"] = db_cluster_id
            if db_endpoint_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_endpoint_id'")
            __props__.__dict__["db_endpoint_id"] = db_endpoint_id
            __props__.__dict__["net_type"] = net_type
            __props__.__dict__["connection_string"] = None
            __props__.__dict__["ip_address"] = None
            __props__.__dict__["port"] = None
        super(EndpointAddress, __self__).__init__(
            'alicloud:polardb/endpointAddress:EndpointAddress',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_prefix: Optional[pulumi.Input[str]] = None,
            connection_string: Optional[pulumi.Input[str]] = None,
            db_cluster_id: Optional[pulumi.Input[str]] = None,
            db_endpoint_id: Optional[pulumi.Input[str]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            net_type: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[str]] = None) -> 'EndpointAddress':
        """
        Get an existing EndpointAddress resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_prefix: Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
        :param pulumi.Input[str] connection_string: Connection cluster or endpoint string.
        :param pulumi.Input[str] db_cluster_id: The Id of cluster that can run database.
        :param pulumi.Input[str] db_endpoint_id: The Id of endpoint that can run database.
        :param pulumi.Input[str] ip_address: The ip address of connection string.
        :param pulumi.Input[str] net_type: Internet connection net type. Valid value: `Public`. Default to `Public`. Currently supported only `Public`.
        :param pulumi.Input[str] port: Connection cluster or endpoint port.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointAddressState.__new__(_EndpointAddressState)

        __props__.__dict__["connection_prefix"] = connection_prefix
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["db_cluster_id"] = db_cluster_id
        __props__.__dict__["db_endpoint_id"] = db_endpoint_id
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["net_type"] = net_type
        __props__.__dict__["port"] = port
        return EndpointAddress(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectionPrefix")
    def connection_prefix(self) -> pulumi.Output[str]:
        """
        Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
        """
        return pulumi.get(self, "connection_prefix")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[str]:
        """
        Connection cluster or endpoint string.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> pulumi.Output[str]:
        """
        The Id of cluster that can run database.
        """
        return pulumi.get(self, "db_cluster_id")

    @property
    @pulumi.getter(name="dbEndpointId")
    def db_endpoint_id(self) -> pulumi.Output[str]:
        """
        The Id of endpoint that can run database.
        """
        return pulumi.get(self, "db_endpoint_id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        The ip address of connection string.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="netType")
    def net_type(self) -> pulumi.Output[Optional[str]]:
        """
        Internet connection net type. Valid value: `Public`. Default to `Public`. Currently supported only `Public`.
        """
        return pulumi.get(self, "net_type")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[str]:
        """
        Connection cluster or endpoint port.
        """
        return pulumi.get(self, "port")

