# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['GlobalDatabaseNetworkArgs', 'GlobalDatabaseNetwork']

@pulumi.input_type
class GlobalDatabaseNetworkArgs:
    def __init__(__self__, *,
                 db_cluster_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a GlobalDatabaseNetwork resource.
        :param pulumi.Input[str] db_cluster_id: The ID of the primary cluster.
        :param pulumi.Input[str] description: The description of the Global Database Network.
        """
        pulumi.set(__self__, "db_cluster_id", db_cluster_id)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> pulumi.Input[str]:
        """
        The ID of the primary cluster.
        """
        return pulumi.get(self, "db_cluster_id")

    @db_cluster_id.setter
    def db_cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_cluster_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Global Database Network.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _GlobalDatabaseNetworkState:
    def __init__(__self__, *,
                 db_cluster_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering GlobalDatabaseNetwork resources.
        :param pulumi.Input[str] db_cluster_id: The ID of the primary cluster.
        :param pulumi.Input[str] description: The description of the Global Database Network.
        :param pulumi.Input[str] status: The status of the Global Database Network.
        """
        if db_cluster_id is not None:
            pulumi.set(__self__, "db_cluster_id", db_cluster_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the primary cluster.
        """
        return pulumi.get(self, "db_cluster_id")

    @db_cluster_id.setter
    def db_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_cluster_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Global Database Network.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the Global Database Network.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class GlobalDatabaseNetwork(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_cluster_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a PolarDB Global Database Network resource.

        For information about PolarDB Global Database Network and how to use it, see [What is Global Database Network](https://www.alibabacloud.com/help/en/polardb/api-polardb-2017-08-01-createglobaldatabasenetwork).

        > **NOTE:** Available since v1.181.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_node_classes = alicloud.polardb.get_node_classes(db_type="MySQL",
            db_version="8.0",
            category="Normal",
            pay_type="PostPaid")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name="terraform-example",
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default_node_classes.classes[0].zone_id,
            vswitch_name="terraform-example")
        default_cluster = alicloud.polardb.Cluster("defaultCluster",
            db_type="MySQL",
            db_version="8.0",
            db_node_class=default_node_classes.classes[0].supported_engines[0].available_resources[0].db_node_class,
            pay_type="PostPaid",
            vswitch_id=default_switch.id,
            description="terraform-example")
        default_global_database_network = alicloud.polardb.GlobalDatabaseNetwork("defaultGlobalDatabaseNetwork",
            db_cluster_id=default_cluster.id,
            description="terraform-example")
        ```

        ## Import

        PolarDB Global Database Network can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:polardb/globalDatabaseNetwork:GlobalDatabaseNetwork example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] db_cluster_id: The ID of the primary cluster.
        :param pulumi.Input[str] description: The description of the Global Database Network.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GlobalDatabaseNetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a PolarDB Global Database Network resource.

        For information about PolarDB Global Database Network and how to use it, see [What is Global Database Network](https://www.alibabacloud.com/help/en/polardb/api-polardb-2017-08-01-createglobaldatabasenetwork).

        > **NOTE:** Available since v1.181.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_node_classes = alicloud.polardb.get_node_classes(db_type="MySQL",
            db_version="8.0",
            category="Normal",
            pay_type="PostPaid")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name="terraform-example",
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default_node_classes.classes[0].zone_id,
            vswitch_name="terraform-example")
        default_cluster = alicloud.polardb.Cluster("defaultCluster",
            db_type="MySQL",
            db_version="8.0",
            db_node_class=default_node_classes.classes[0].supported_engines[0].available_resources[0].db_node_class,
            pay_type="PostPaid",
            vswitch_id=default_switch.id,
            description="terraform-example")
        default_global_database_network = alicloud.polardb.GlobalDatabaseNetwork("defaultGlobalDatabaseNetwork",
            db_cluster_id=default_cluster.id,
            description="terraform-example")
        ```

        ## Import

        PolarDB Global Database Network can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:polardb/globalDatabaseNetwork:GlobalDatabaseNetwork example <id>
        ```

        :param str resource_name: The name of the resource.
        :param GlobalDatabaseNetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GlobalDatabaseNetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_cluster_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GlobalDatabaseNetworkArgs.__new__(GlobalDatabaseNetworkArgs)

            if db_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_id'")
            __props__.__dict__["db_cluster_id"] = db_cluster_id
            __props__.__dict__["description"] = description
            __props__.__dict__["status"] = None
        super(GlobalDatabaseNetwork, __self__).__init__(
            'alicloud:polardb/globalDatabaseNetwork:GlobalDatabaseNetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            db_cluster_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'GlobalDatabaseNetwork':
        """
        Get an existing GlobalDatabaseNetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] db_cluster_id: The ID of the primary cluster.
        :param pulumi.Input[str] description: The description of the Global Database Network.
        :param pulumi.Input[str] status: The status of the Global Database Network.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GlobalDatabaseNetworkState.__new__(_GlobalDatabaseNetworkState)

        __props__.__dict__["db_cluster_id"] = db_cluster_id
        __props__.__dict__["description"] = description
        __props__.__dict__["status"] = status
        return GlobalDatabaseNetwork(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> pulumi.Output[str]:
        """
        The ID of the primary cluster.
        """
        return pulumi.get(self, "db_cluster_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the Global Database Network.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the Global Database Network.
        """
        return pulumi.get(self, "status")

