# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['VpcEndpointArgs', 'VpcEndpoint']

@pulumi.input_type
class VpcEndpointArgs:
    def __init__(__self__, *,
                 security_group_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 vpc_id: pulumi.Input[str],
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 endpoint_description: Optional[pulumi.Input[str]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 protected_enabled: Optional[pulumi.Input[bool]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vpc_endpoint_name: Optional[pulumi.Input[str]] = None,
                 zone_private_ip_address_count: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a VpcEndpoint resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: The ID of the security group that is associated with the endpoint ENI. The security group can be used to control data transfer between the VPC and the endpoint ENI.The endpoint can be associated with up to 10 security groups.
        :param pulumi.Input[str] vpc_id: The ID of the VPC to which the endpoint belongs.
        :param pulumi.Input[bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request. Valid values:
               - **true**: performs only a dry run. The system checks the request for potential issues, including missing parameter values, incorrect request syntax, and service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
               - **false (default)**: performs a dry run and performs the actual request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
        :param pulumi.Input[str] endpoint_description: The description of the endpoint.
        :param pulumi.Input[str] endpoint_type: The endpoint type.Only the value: Interface, indicating the Interface endpoint. You can add the service resource types of Application Load Balancer (ALB), Classic Load Balancer (CLB), and Network Load Balancer (NLB).
        :param pulumi.Input[bool] protected_enabled: Specifies whether to enable user authentication. This parameter is available in Security Token Service (STS) mode. Valid values:
               - **true**: enables user authentication. After user authentication is enabled, only the user who creates the endpoint can modify or delete the endpoint in STS mode.
               - **false (default)**: disables user authentication.
        :param pulumi.Input[str] resource_group_id: The resource group ID.
        :param pulumi.Input[str] service_id: The ID of the endpoint service with which the endpoint is associated.
        :param pulumi.Input[str] service_name: The name of the endpoint service with which the endpoint is associated.
        :param pulumi.Input[Mapping[str, Any]] tags: The list of tags.
        :param pulumi.Input[str] vpc_endpoint_name: The name of the endpoint.
        :param pulumi.Input[int] zone_private_ip_address_count: The number of private IP addresses that are assigned to an elastic network interface (ENI) in each zone. Only 1 is returned.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if endpoint_description is not None:
            pulumi.set(__self__, "endpoint_description", endpoint_description)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if protected_enabled is not None:
            pulumi.set(__self__, "protected_enabled", protected_enabled)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_endpoint_name is not None:
            pulumi.set(__self__, "vpc_endpoint_name", vpc_endpoint_name)
        if zone_private_ip_address_count is not None:
            pulumi.set(__self__, "zone_private_ip_address_count", zone_private_ip_address_count)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The ID of the security group that is associated with the endpoint ENI. The security group can be used to control data transfer between the VPC and the endpoint ENI.The endpoint can be associated with up to 10 security groups.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        The ID of the VPC to which the endpoint belongs.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        - **true**: performs only a dry run. The system checks the request for potential issues, including missing parameter values, incorrect request syntax, and service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
        - **false (default)**: performs a dry run and performs the actual request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter(name="endpointDescription")
    def endpoint_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the endpoint.
        """
        return pulumi.get(self, "endpoint_description")

    @endpoint_description.setter
    def endpoint_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_description", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint type.Only the value: Interface, indicating the Interface endpoint. You can add the service resource types of Application Load Balancer (ALB), Classic Load Balancer (CLB), and Network Load Balancer (NLB).
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="protectedEnabled")
    def protected_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable user authentication. This parameter is available in Security Token Service (STS) mode. Valid values:
        - **true**: enables user authentication. After user authentication is enabled, only the user who creates the endpoint can modify or delete the endpoint in STS mode.
        - **false (default)**: disables user authentication.
        """
        return pulumi.get(self, "protected_enabled")

    @protected_enabled.setter
    def protected_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "protected_enabled", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the endpoint service with which the endpoint is associated.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the endpoint service with which the endpoint is associated.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The list of tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcEndpointName")
    def vpc_endpoint_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the endpoint.
        """
        return pulumi.get(self, "vpc_endpoint_name")

    @vpc_endpoint_name.setter
    def vpc_endpoint_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_endpoint_name", value)

    @property
    @pulumi.getter(name="zonePrivateIpAddressCount")
    def zone_private_ip_address_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of private IP addresses that are assigned to an elastic network interface (ENI) in each zone. Only 1 is returned.
        """
        return pulumi.get(self, "zone_private_ip_address_count")

    @zone_private_ip_address_count.setter
    def zone_private_ip_address_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zone_private_ip_address_count", value)


@pulumi.input_type
class _VpcEndpointState:
    def __init__(__self__, *,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 connection_status: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 endpoint_business_status: Optional[pulumi.Input[str]] = None,
                 endpoint_description: Optional[pulumi.Input[str]] = None,
                 endpoint_domain: Optional[pulumi.Input[str]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 protected_enabled: Optional[pulumi.Input[bool]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vpc_endpoint_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone_private_ip_address_count: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering VpcEndpoint resources.
        :param pulumi.Input[int] bandwidth: The bandwidth of the endpoint connection.  1024 to 10240. Unit: Mbit/s.Note: The bandwidth of an endpoint connection is in the range of 100 to 10,240 Mbit/s. The default bandwidth is 1,024 Mbit/s. When the endpoint is connected to the endpoint service, the default bandwidth is the minimum bandwidth. In this case, the connection bandwidth range is 1,024 to 10,240 Mbit/s.
        :param pulumi.Input[str] connection_status: The state of the endpoint connection.
        :param pulumi.Input[str] create_time: The time when the endpoint was created.
        :param pulumi.Input[bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request. Valid values:
               - **true**: performs only a dry run. The system checks the request for potential issues, including missing parameter values, incorrect request syntax, and service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
               - **false (default)**: performs a dry run and performs the actual request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
        :param pulumi.Input[str] endpoint_business_status: The service state of the endpoint.
        :param pulumi.Input[str] endpoint_description: The description of the endpoint.
        :param pulumi.Input[str] endpoint_domain: The domain name of the endpoint.
        :param pulumi.Input[str] endpoint_type: The endpoint type.Only the value: Interface, indicating the Interface endpoint. You can add the service resource types of Application Load Balancer (ALB), Classic Load Balancer (CLB), and Network Load Balancer (NLB).
        :param pulumi.Input[bool] protected_enabled: Specifies whether to enable user authentication. This parameter is available in Security Token Service (STS) mode. Valid values:
               - **true**: enables user authentication. After user authentication is enabled, only the user who creates the endpoint can modify or delete the endpoint in STS mode.
               - **false (default)**: disables user authentication.
        :param pulumi.Input[str] resource_group_id: The resource group ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: The ID of the security group that is associated with the endpoint ENI. The security group can be used to control data transfer between the VPC and the endpoint ENI.The endpoint can be associated with up to 10 security groups.
        :param pulumi.Input[str] service_id: The ID of the endpoint service with which the endpoint is associated.
        :param pulumi.Input[str] service_name: The name of the endpoint service with which the endpoint is associated.
        :param pulumi.Input[str] status: The state of the endpoint.
        :param pulumi.Input[Mapping[str, Any]] tags: The list of tags.
        :param pulumi.Input[str] vpc_endpoint_name: The name of the endpoint.
        :param pulumi.Input[str] vpc_id: The ID of the VPC to which the endpoint belongs.
        :param pulumi.Input[int] zone_private_ip_address_count: The number of private IP addresses that are assigned to an elastic network interface (ENI) in each zone. Only 1 is returned.
        """
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if connection_status is not None:
            pulumi.set(__self__, "connection_status", connection_status)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if endpoint_business_status is not None:
            pulumi.set(__self__, "endpoint_business_status", endpoint_business_status)
        if endpoint_description is not None:
            pulumi.set(__self__, "endpoint_description", endpoint_description)
        if endpoint_domain is not None:
            pulumi.set(__self__, "endpoint_domain", endpoint_domain)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if protected_enabled is not None:
            pulumi.set(__self__, "protected_enabled", protected_enabled)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_endpoint_name is not None:
            pulumi.set(__self__, "vpc_endpoint_name", vpc_endpoint_name)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if zone_private_ip_address_count is not None:
            pulumi.set(__self__, "zone_private_ip_address_count", zone_private_ip_address_count)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The bandwidth of the endpoint connection.  1024 to 10240. Unit: Mbit/s.Note: The bandwidth of an endpoint connection is in the range of 100 to 10,240 Mbit/s. The default bandwidth is 1,024 Mbit/s. When the endpoint is connected to the endpoint service, the default bandwidth is the minimum bandwidth. In this case, the connection bandwidth range is 1,024 to 10,240 Mbit/s.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the endpoint connection.
        """
        return pulumi.get(self, "connection_status")

    @connection_status.setter
    def connection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_status", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the endpoint was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        - **true**: performs only a dry run. The system checks the request for potential issues, including missing parameter values, incorrect request syntax, and service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
        - **false (default)**: performs a dry run and performs the actual request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter(name="endpointBusinessStatus")
    def endpoint_business_status(self) -> Optional[pulumi.Input[str]]:
        """
        The service state of the endpoint.
        """
        return pulumi.get(self, "endpoint_business_status")

    @endpoint_business_status.setter
    def endpoint_business_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_business_status", value)

    @property
    @pulumi.getter(name="endpointDescription")
    def endpoint_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the endpoint.
        """
        return pulumi.get(self, "endpoint_description")

    @endpoint_description.setter
    def endpoint_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_description", value)

    @property
    @pulumi.getter(name="endpointDomain")
    def endpoint_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name of the endpoint.
        """
        return pulumi.get(self, "endpoint_domain")

    @endpoint_domain.setter
    def endpoint_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_domain", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint type.Only the value: Interface, indicating the Interface endpoint. You can add the service resource types of Application Load Balancer (ALB), Classic Load Balancer (CLB), and Network Load Balancer (NLB).
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="protectedEnabled")
    def protected_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable user authentication. This parameter is available in Security Token Service (STS) mode. Valid values:
        - **true**: enables user authentication. After user authentication is enabled, only the user who creates the endpoint can modify or delete the endpoint in STS mode.
        - **false (default)**: disables user authentication.
        """
        return pulumi.get(self, "protected_enabled")

    @protected_enabled.setter
    def protected_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "protected_enabled", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ID of the security group that is associated with the endpoint ENI. The security group can be used to control data transfer between the VPC and the endpoint ENI.The endpoint can be associated with up to 10 security groups.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the endpoint service with which the endpoint is associated.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the endpoint service with which the endpoint is associated.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the endpoint.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The list of tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcEndpointName")
    def vpc_endpoint_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the endpoint.
        """
        return pulumi.get(self, "vpc_endpoint_name")

    @vpc_endpoint_name.setter
    def vpc_endpoint_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_endpoint_name", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPC to which the endpoint belongs.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="zonePrivateIpAddressCount")
    def zone_private_ip_address_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of private IP addresses that are assigned to an elastic network interface (ENI) in each zone. Only 1 is returned.
        """
        return pulumi.get(self, "zone_private_ip_address_count")

    @zone_private_ip_address_count.setter
    def zone_private_ip_address_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zone_private_ip_address_count", value)


class VpcEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 endpoint_description: Optional[pulumi.Input[str]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 protected_enabled: Optional[pulumi.Input[bool]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vpc_endpoint_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone_private_ip_address_count: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a Private Link Vpc Endpoint resource.

        For information about Private Link Vpc Endpoint and how to use it, see [What is Vpc Endpoint](https://www.alibabacloud.com/help/en/privatelink/latest/api-privatelink-2020-04-15-createvpcendpoint).

        > **NOTE:** Available since v1.109.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        example_vpc_endpoint_service = alicloud.privatelink.VpcEndpointService("exampleVpcEndpointService",
            service_description=name,
            connect_bandwidth=103,
            auto_accept_connection=False)
        example_network = alicloud.vpc.Network("exampleNetwork",
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        example_security_group = alicloud.ecs.SecurityGroup("exampleSecurityGroup", vpc_id=example_network.id)
        example_vpc_endpoint = alicloud.privatelink.VpcEndpoint("exampleVpcEndpoint",
            service_id=example_vpc_endpoint_service.id,
            security_group_ids=[example_security_group.id],
            vpc_id=example_network.id,
            vpc_endpoint_name=name)
        ```

        ## Import

        Private Link Vpc Endpoint can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:privatelink/vpcEndpoint:VpcEndpoint example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request. Valid values:
               - **true**: performs only a dry run. The system checks the request for potential issues, including missing parameter values, incorrect request syntax, and service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
               - **false (default)**: performs a dry run and performs the actual request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
        :param pulumi.Input[str] endpoint_description: The description of the endpoint.
        :param pulumi.Input[str] endpoint_type: The endpoint type.Only the value: Interface, indicating the Interface endpoint. You can add the service resource types of Application Load Balancer (ALB), Classic Load Balancer (CLB), and Network Load Balancer (NLB).
        :param pulumi.Input[bool] protected_enabled: Specifies whether to enable user authentication. This parameter is available in Security Token Service (STS) mode. Valid values:
               - **true**: enables user authentication. After user authentication is enabled, only the user who creates the endpoint can modify or delete the endpoint in STS mode.
               - **false (default)**: disables user authentication.
        :param pulumi.Input[str] resource_group_id: The resource group ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: The ID of the security group that is associated with the endpoint ENI. The security group can be used to control data transfer between the VPC and the endpoint ENI.The endpoint can be associated with up to 10 security groups.
        :param pulumi.Input[str] service_id: The ID of the endpoint service with which the endpoint is associated.
        :param pulumi.Input[str] service_name: The name of the endpoint service with which the endpoint is associated.
        :param pulumi.Input[Mapping[str, Any]] tags: The list of tags.
        :param pulumi.Input[str] vpc_endpoint_name: The name of the endpoint.
        :param pulumi.Input[str] vpc_id: The ID of the VPC to which the endpoint belongs.
        :param pulumi.Input[int] zone_private_ip_address_count: The number of private IP addresses that are assigned to an elastic network interface (ENI) in each zone. Only 1 is returned.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Private Link Vpc Endpoint resource.

        For information about Private Link Vpc Endpoint and how to use it, see [What is Vpc Endpoint](https://www.alibabacloud.com/help/en/privatelink/latest/api-privatelink-2020-04-15-createvpcendpoint).

        > **NOTE:** Available since v1.109.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        example_vpc_endpoint_service = alicloud.privatelink.VpcEndpointService("exampleVpcEndpointService",
            service_description=name,
            connect_bandwidth=103,
            auto_accept_connection=False)
        example_network = alicloud.vpc.Network("exampleNetwork",
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        example_security_group = alicloud.ecs.SecurityGroup("exampleSecurityGroup", vpc_id=example_network.id)
        example_vpc_endpoint = alicloud.privatelink.VpcEndpoint("exampleVpcEndpoint",
            service_id=example_vpc_endpoint_service.id,
            security_group_ids=[example_security_group.id],
            vpc_id=example_network.id,
            vpc_endpoint_name=name)
        ```

        ## Import

        Private Link Vpc Endpoint can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:privatelink/vpcEndpoint:VpcEndpoint example <id>
        ```

        :param str resource_name: The name of the resource.
        :param VpcEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 endpoint_description: Optional[pulumi.Input[str]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 protected_enabled: Optional[pulumi.Input[bool]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vpc_endpoint_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone_private_ip_address_count: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcEndpointArgs.__new__(VpcEndpointArgs)

            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["endpoint_description"] = endpoint_description
            __props__.__dict__["endpoint_type"] = endpoint_type
            __props__.__dict__["protected_enabled"] = protected_enabled
            __props__.__dict__["resource_group_id"] = resource_group_id
            if security_group_ids is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_ids'")
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["service_id"] = service_id
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_endpoint_name"] = vpc_endpoint_name
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["zone_private_ip_address_count"] = zone_private_ip_address_count
            __props__.__dict__["bandwidth"] = None
            __props__.__dict__["connection_status"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["endpoint_business_status"] = None
            __props__.__dict__["endpoint_domain"] = None
            __props__.__dict__["status"] = None
        super(VpcEndpoint, __self__).__init__(
            'alicloud:privatelink/vpcEndpoint:VpcEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth: Optional[pulumi.Input[int]] = None,
            connection_status: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            dry_run: Optional[pulumi.Input[bool]] = None,
            endpoint_business_status: Optional[pulumi.Input[str]] = None,
            endpoint_description: Optional[pulumi.Input[str]] = None,
            endpoint_domain: Optional[pulumi.Input[str]] = None,
            endpoint_type: Optional[pulumi.Input[str]] = None,
            protected_enabled: Optional[pulumi.Input[bool]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            service_id: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            vpc_endpoint_name: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            zone_private_ip_address_count: Optional[pulumi.Input[int]] = None) -> 'VpcEndpoint':
        """
        Get an existing VpcEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] bandwidth: The bandwidth of the endpoint connection.  1024 to 10240. Unit: Mbit/s.Note: The bandwidth of an endpoint connection is in the range of 100 to 10,240 Mbit/s. The default bandwidth is 1,024 Mbit/s. When the endpoint is connected to the endpoint service, the default bandwidth is the minimum bandwidth. In this case, the connection bandwidth range is 1,024 to 10,240 Mbit/s.
        :param pulumi.Input[str] connection_status: The state of the endpoint connection.
        :param pulumi.Input[str] create_time: The time when the endpoint was created.
        :param pulumi.Input[bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request. Valid values:
               - **true**: performs only a dry run. The system checks the request for potential issues, including missing parameter values, incorrect request syntax, and service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
               - **false (default)**: performs a dry run and performs the actual request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
        :param pulumi.Input[str] endpoint_business_status: The service state of the endpoint.
        :param pulumi.Input[str] endpoint_description: The description of the endpoint.
        :param pulumi.Input[str] endpoint_domain: The domain name of the endpoint.
        :param pulumi.Input[str] endpoint_type: The endpoint type.Only the value: Interface, indicating the Interface endpoint. You can add the service resource types of Application Load Balancer (ALB), Classic Load Balancer (CLB), and Network Load Balancer (NLB).
        :param pulumi.Input[bool] protected_enabled: Specifies whether to enable user authentication. This parameter is available in Security Token Service (STS) mode. Valid values:
               - **true**: enables user authentication. After user authentication is enabled, only the user who creates the endpoint can modify or delete the endpoint in STS mode.
               - **false (default)**: disables user authentication.
        :param pulumi.Input[str] resource_group_id: The resource group ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: The ID of the security group that is associated with the endpoint ENI. The security group can be used to control data transfer between the VPC and the endpoint ENI.The endpoint can be associated with up to 10 security groups.
        :param pulumi.Input[str] service_id: The ID of the endpoint service with which the endpoint is associated.
        :param pulumi.Input[str] service_name: The name of the endpoint service with which the endpoint is associated.
        :param pulumi.Input[str] status: The state of the endpoint.
        :param pulumi.Input[Mapping[str, Any]] tags: The list of tags.
        :param pulumi.Input[str] vpc_endpoint_name: The name of the endpoint.
        :param pulumi.Input[str] vpc_id: The ID of the VPC to which the endpoint belongs.
        :param pulumi.Input[int] zone_private_ip_address_count: The number of private IP addresses that are assigned to an elastic network interface (ENI) in each zone. Only 1 is returned.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcEndpointState.__new__(_VpcEndpointState)

        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["connection_status"] = connection_status
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["endpoint_business_status"] = endpoint_business_status
        __props__.__dict__["endpoint_description"] = endpoint_description
        __props__.__dict__["endpoint_domain"] = endpoint_domain
        __props__.__dict__["endpoint_type"] = endpoint_type
        __props__.__dict__["protected_enabled"] = protected_enabled
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["service_id"] = service_id
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_endpoint_name"] = vpc_endpoint_name
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["zone_private_ip_address_count"] = zone_private_ip_address_count
        return VpcEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[int]:
        """
        The bandwidth of the endpoint connection.  1024 to 10240. Unit: Mbit/s.Note: The bandwidth of an endpoint connection is in the range of 100 to 10,240 Mbit/s. The default bandwidth is 1,024 Mbit/s. When the endpoint is connected to the endpoint service, the default bandwidth is the minimum bandwidth. In this case, the connection bandwidth range is 1,024 to 10,240 Mbit/s.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> pulumi.Output[str]:
        """
        The state of the endpoint connection.
        """
        return pulumi.get(self, "connection_status")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time when the endpoint was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        - **true**: performs only a dry run. The system checks the request for potential issues, including missing parameter values, incorrect request syntax, and service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
        - **false (default)**: performs a dry run and performs the actual request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
        """
        return pulumi.get(self, "dry_run")

    @property
    @pulumi.getter(name="endpointBusinessStatus")
    def endpoint_business_status(self) -> pulumi.Output[str]:
        """
        The service state of the endpoint.
        """
        return pulumi.get(self, "endpoint_business_status")

    @property
    @pulumi.getter(name="endpointDescription")
    def endpoint_description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the endpoint.
        """
        return pulumi.get(self, "endpoint_description")

    @property
    @pulumi.getter(name="endpointDomain")
    def endpoint_domain(self) -> pulumi.Output[str]:
        """
        The domain name of the endpoint.
        """
        return pulumi.get(self, "endpoint_domain")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Output[str]:
        """
        The endpoint type.Only the value: Interface, indicating the Interface endpoint. You can add the service resource types of Application Load Balancer (ALB), Classic Load Balancer (CLB), and Network Load Balancer (NLB).
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="protectedEnabled")
    def protected_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable user authentication. This parameter is available in Security Token Service (STS) mode. Valid values:
        - **true**: enables user authentication. After user authentication is enabled, only the user who creates the endpoint can modify or delete the endpoint in STS mode.
        - **false (default)**: disables user authentication.
        """
        return pulumi.get(self, "protected_enabled")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The resource group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The ID of the security group that is associated with the endpoint ENI. The security group can be used to control data transfer between the VPC and the endpoint ENI.The endpoint can be associated with up to 10 security groups.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the endpoint service with which the endpoint is associated.
        """
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        The name of the endpoint service with which the endpoint is associated.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The state of the endpoint.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        The list of tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcEndpointName")
    def vpc_endpoint_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the endpoint.
        """
        return pulumi.get(self, "vpc_endpoint_name")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The ID of the VPC to which the endpoint belongs.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="zonePrivateIpAddressCount")
    def zone_private_ip_address_count(self) -> pulumi.Output[int]:
        """
        The number of private IP addresses that are assigned to an elastic network interface (ENI) in each zone. Only 1 is returned.
        """
        return pulumi.get(self, "zone_private_ip_address_count")

