# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['VpcEndpointZoneArgs', 'VpcEndpointZone']

@pulumi.input_type
class VpcEndpointZoneArgs:
    def __init__(__self__, *,
                 endpoint_id: pulumi.Input[str],
                 vswitch_id: pulumi.Input[str],
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 eni_ip: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VpcEndpointZone resource.
        :param pulumi.Input[str] endpoint_id: The endpoint ID.
        :param pulumi.Input[str] vswitch_id: The ID of the vSwitch in the zone. .
        :param pulumi.Input[bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request. Valid values:
               - **true**: performs only a dry run. The system checks the request for potential issues, including missing parameter values, incorrect request syntax, and service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
               - **false (default)**: performs a dry run and performs the actual request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
        :param pulumi.Input[str] eni_ip: The IP address of the endpoint ENI.
        :param pulumi.Input[str] zone_id: The zone ID.
        """
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if eni_ip is not None:
            pulumi.set(__self__, "eni_ip", eni_ip)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> pulumi.Input[str]:
        """
        The endpoint ID.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[str]:
        """
        The ID of the vSwitch in the zone. .
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        - **true**: performs only a dry run. The system checks the request for potential issues, including missing parameter values, incorrect request syntax, and service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
        - **false (default)**: performs a dry run and performs the actual request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter(name="eniIp")
    def eni_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the endpoint ENI.
        """
        return pulumi.get(self, "eni_ip")

    @eni_ip.setter
    def eni_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eni_ip", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _VpcEndpointZoneState:
    def __init__(__self__, *,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 eni_ip: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering VpcEndpointZone resources.
        :param pulumi.Input[bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request. Valid values:
               - **true**: performs only a dry run. The system checks the request for potential issues, including missing parameter values, incorrect request syntax, and service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
               - **false (default)**: performs a dry run and performs the actual request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
        :param pulumi.Input[str] endpoint_id: The endpoint ID.
        :param pulumi.Input[str] eni_ip: The IP address of the endpoint ENI.
        :param pulumi.Input[str] status: The state of the zone.
        :param pulumi.Input[str] vswitch_id: The ID of the vSwitch in the zone. .
        :param pulumi.Input[str] zone_id: The zone ID.
        """
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if eni_ip is not None:
            pulumi.set(__self__, "eni_ip", eni_ip)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        - **true**: performs only a dry run. The system checks the request for potential issues, including missing parameter values, incorrect request syntax, and service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
        - **false (default)**: performs a dry run and performs the actual request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint ID.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter(name="eniIp")
    def eni_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the endpoint ENI.
        """
        return pulumi.get(self, "eni_ip")

    @eni_ip.setter
    def eni_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eni_ip", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the zone.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the vSwitch in the zone. .
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class VpcEndpointZone(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 eni_ip: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Private Link Vpc Endpoint Zone resource.

        For information about Private Link Vpc Endpoint Zone and how to use it, see [What is Vpc Endpoint Zone](https://www.alibabacloud.com/help/en/privatelink/latest/api-privatelink-2020-04-15-addzonetovpcendpoint).

        > **NOTE:** Available since v1.111.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        example_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        example_vpc_endpoint_service = alicloud.privatelink.VpcEndpointService("exampleVpcEndpointService",
            service_description=name,
            connect_bandwidth=103,
            auto_accept_connection=False)
        example_network = alicloud.vpc.Network("exampleNetwork",
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        example_switch = alicloud.vpc.Switch("exampleSwitch",
            vswitch_name=name,
            cidr_block="10.1.0.0/16",
            vpc_id=example_network.id,
            zone_id=example_zones.zones[0].id)
        example_security_group = alicloud.ecs.SecurityGroup("exampleSecurityGroup", vpc_id=example_network.id)
        example_application_load_balancer = alicloud.slb.ApplicationLoadBalancer("exampleApplicationLoadBalancer",
            load_balancer_name=name,
            vswitch_id=example_switch.id,
            load_balancer_spec="slb.s2.small",
            address_type="intranet")
        example_vpc_endpoint_service_resource = alicloud.privatelink.VpcEndpointServiceResource("exampleVpcEndpointServiceResource",
            service_id=example_vpc_endpoint_service.id,
            resource_id=example_application_load_balancer.id,
            resource_type="slb")
        example_vpc_endpoint = alicloud.privatelink.VpcEndpoint("exampleVpcEndpoint",
            service_id=example_vpc_endpoint_service_resource.service_id,
            security_group_ids=[example_security_group.id],
            vpc_id=example_network.id,
            vpc_endpoint_name=name)
        example_vpc_endpoint_zone = alicloud.privatelink.VpcEndpointZone("exampleVpcEndpointZone",
            endpoint_id=example_vpc_endpoint.id,
            vswitch_id=example_switch.id,
            zone_id=example_zones.zones[0].id)
        ```

        ## Import

        Private Link Vpc Endpoint Zone can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:privatelink/vpcEndpointZone:VpcEndpointZone example <endpoint_id>:<zone_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request. Valid values:
               - **true**: performs only a dry run. The system checks the request for potential issues, including missing parameter values, incorrect request syntax, and service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
               - **false (default)**: performs a dry run and performs the actual request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
        :param pulumi.Input[str] endpoint_id: The endpoint ID.
        :param pulumi.Input[str] eni_ip: The IP address of the endpoint ENI.
        :param pulumi.Input[str] vswitch_id: The ID of the vSwitch in the zone. .
        :param pulumi.Input[str] zone_id: The zone ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcEndpointZoneArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Private Link Vpc Endpoint Zone resource.

        For information about Private Link Vpc Endpoint Zone and how to use it, see [What is Vpc Endpoint Zone](https://www.alibabacloud.com/help/en/privatelink/latest/api-privatelink-2020-04-15-addzonetovpcendpoint).

        > **NOTE:** Available since v1.111.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        example_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        example_vpc_endpoint_service = alicloud.privatelink.VpcEndpointService("exampleVpcEndpointService",
            service_description=name,
            connect_bandwidth=103,
            auto_accept_connection=False)
        example_network = alicloud.vpc.Network("exampleNetwork",
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        example_switch = alicloud.vpc.Switch("exampleSwitch",
            vswitch_name=name,
            cidr_block="10.1.0.0/16",
            vpc_id=example_network.id,
            zone_id=example_zones.zones[0].id)
        example_security_group = alicloud.ecs.SecurityGroup("exampleSecurityGroup", vpc_id=example_network.id)
        example_application_load_balancer = alicloud.slb.ApplicationLoadBalancer("exampleApplicationLoadBalancer",
            load_balancer_name=name,
            vswitch_id=example_switch.id,
            load_balancer_spec="slb.s2.small",
            address_type="intranet")
        example_vpc_endpoint_service_resource = alicloud.privatelink.VpcEndpointServiceResource("exampleVpcEndpointServiceResource",
            service_id=example_vpc_endpoint_service.id,
            resource_id=example_application_load_balancer.id,
            resource_type="slb")
        example_vpc_endpoint = alicloud.privatelink.VpcEndpoint("exampleVpcEndpoint",
            service_id=example_vpc_endpoint_service_resource.service_id,
            security_group_ids=[example_security_group.id],
            vpc_id=example_network.id,
            vpc_endpoint_name=name)
        example_vpc_endpoint_zone = alicloud.privatelink.VpcEndpointZone("exampleVpcEndpointZone",
            endpoint_id=example_vpc_endpoint.id,
            vswitch_id=example_switch.id,
            zone_id=example_zones.zones[0].id)
        ```

        ## Import

        Private Link Vpc Endpoint Zone can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:privatelink/vpcEndpointZone:VpcEndpointZone example <endpoint_id>:<zone_id>
        ```

        :param str resource_name: The name of the resource.
        :param VpcEndpointZoneArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcEndpointZoneArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 eni_ip: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcEndpointZoneArgs.__new__(VpcEndpointZoneArgs)

            __props__.__dict__["dry_run"] = dry_run
            if endpoint_id is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_id'")
            __props__.__dict__["endpoint_id"] = endpoint_id
            __props__.__dict__["eni_ip"] = eni_ip
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["status"] = None
        super(VpcEndpointZone, __self__).__init__(
            'alicloud:privatelink/vpcEndpointZone:VpcEndpointZone',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dry_run: Optional[pulumi.Input[bool]] = None,
            endpoint_id: Optional[pulumi.Input[str]] = None,
            eni_ip: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            vswitch_id: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'VpcEndpointZone':
        """
        Get an existing VpcEndpointZone resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] dry_run: Specifies whether to perform only a dry run, without performing the actual request. Valid values:
               - **true**: performs only a dry run. The system checks the request for potential issues, including missing parameter values, incorrect request syntax, and service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
               - **false (default)**: performs a dry run and performs the actual request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
        :param pulumi.Input[str] endpoint_id: The endpoint ID.
        :param pulumi.Input[str] eni_ip: The IP address of the endpoint ENI.
        :param pulumi.Input[str] status: The state of the zone.
        :param pulumi.Input[str] vswitch_id: The ID of the vSwitch in the zone. .
        :param pulumi.Input[str] zone_id: The zone ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcEndpointZoneState.__new__(_VpcEndpointZoneState)

        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["endpoint_id"] = endpoint_id
        __props__.__dict__["eni_ip"] = eni_ip
        __props__.__dict__["status"] = status
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return VpcEndpointZone(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to perform only a dry run, without performing the actual request. Valid values:
        - **true**: performs only a dry run. The system checks the request for potential issues, including missing parameter values, incorrect request syntax, and service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
        - **false (default)**: performs a dry run and performs the actual request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
        """
        return pulumi.get(self, "dry_run")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> pulumi.Output[str]:
        """
        The endpoint ID.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter(name="eniIp")
    def eni_ip(self) -> pulumi.Output[str]:
        """
        The IP address of the endpoint ENI.
        """
        return pulumi.get(self, "eni_ip")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The state of the zone.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[str]:
        """
        The ID of the vSwitch in the zone. .
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[Optional[str]]:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")

