# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EndpointArgs', 'Endpoint']

@pulumi.input_type
class EndpointArgs:
    def __init__(__self__, *,
                 endpoint_name: pulumi.Input[str],
                 ip_configs: pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigArgs']]],
                 security_group_id: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 vpc_region_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a Endpoint resource.
        :param pulumi.Input[str] endpoint_name: The name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigArgs']]] ip_configs: The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
        :param pulumi.Input[str] security_group_id: The ID of the Security Group.
        :param pulumi.Input[str] vpc_id: The VPC ID.
        :param pulumi.Input[str] vpc_region_id: The Region of the VPC.
        """
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "ip_configs", ip_configs)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_region_id", vpc_region_id)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> pulumi.Input[str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_name", value)

    @property
    @pulumi.getter(name="ipConfigs")
    def ip_configs(self) -> pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigArgs']]]:
        """
        The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
        """
        return pulumi.get(self, "ip_configs")

    @ip_configs.setter
    def ip_configs(self, value: pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigArgs']]]):
        pulumi.set(self, "ip_configs", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[str]:
        """
        The ID of the Security Group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vpcRegionId")
    def vpc_region_id(self) -> pulumi.Input[str]:
        """
        The Region of the VPC.
        """
        return pulumi.get(self, "vpc_region_id")

    @vpc_region_id.setter
    def vpc_region_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_region_id", value)


@pulumi.input_type
class _EndpointState:
    def __init__(__self__, *,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 ip_configs: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigArgs']]]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpc_region_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Endpoint resources.
        :param pulumi.Input[str] endpoint_name: The name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigArgs']]] ip_configs: The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
        :param pulumi.Input[str] security_group_id: The ID of the Security Group.
        :param pulumi.Input[str] status: The status of the resource. Valid values: `CHANGE_FAILED`, `CHANGE_INIT`, `EXCEPTION`, `FAILED`, `INIT`, `SUCCESS`.
        :param pulumi.Input[str] vpc_id: The VPC ID.
        :param pulumi.Input[str] vpc_region_id: The Region of the VPC.
        """
        if endpoint_name is not None:
            pulumi.set(__self__, "endpoint_name", endpoint_name)
        if ip_configs is not None:
            pulumi.set(__self__, "ip_configs", ip_configs)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_region_id is not None:
            pulumi.set(__self__, "vpc_region_id", vpc_region_id)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_name", value)

    @property
    @pulumi.getter(name="ipConfigs")
    def ip_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigArgs']]]]:
        """
        The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
        """
        return pulumi.get(self, "ip_configs")

    @ip_configs.setter
    def ip_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointIpConfigArgs']]]]):
        pulumi.set(self, "ip_configs", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Security Group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the resource. Valid values: `CHANGE_FAILED`, `CHANGE_INIT`, `EXCEPTION`, `FAILED`, `INIT`, `SUCCESS`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vpcRegionId")
    def vpc_region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Region of the VPC.
        """
        return pulumi.get(self, "vpc_region_id")

    @vpc_region_id.setter
    def vpc_region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_region_id", value)


class Endpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 ip_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EndpointIpConfigArgs']]]]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpc_region_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Private Zone Endpoint resource.

        For information about Private Zone Endpoint and how to use it, see [What is Endpoint](https://www.alibabacloud.com/help/en/privatezone/latest/add-endpoint).

        > **NOTE:** Available since v1.143.0.

        ## Import

        Private Zone Endpoint can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:pvtz/endpoint:Endpoint example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] endpoint_name: The name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EndpointIpConfigArgs']]]] ip_configs: The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
        :param pulumi.Input[str] security_group_id: The ID of the Security Group.
        :param pulumi.Input[str] vpc_id: The VPC ID.
        :param pulumi.Input[str] vpc_region_id: The Region of the VPC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Private Zone Endpoint resource.

        For information about Private Zone Endpoint and how to use it, see [What is Endpoint](https://www.alibabacloud.com/help/en/privatezone/latest/add-endpoint).

        > **NOTE:** Available since v1.143.0.

        ## Import

        Private Zone Endpoint can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:pvtz/endpoint:Endpoint example <id>
        ```

        :param str resource_name: The name of the resource.
        :param EndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 ip_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EndpointIpConfigArgs']]]]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpc_region_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointArgs.__new__(EndpointArgs)

            if endpoint_name is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_name'")
            __props__.__dict__["endpoint_name"] = endpoint_name
            if ip_configs is None and not opts.urn:
                raise TypeError("Missing required property 'ip_configs'")
            __props__.__dict__["ip_configs"] = ip_configs
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if vpc_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_region_id'")
            __props__.__dict__["vpc_region_id"] = vpc_region_id
            __props__.__dict__["status"] = None
        super(Endpoint, __self__).__init__(
            'alicloud:pvtz/endpoint:Endpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            endpoint_name: Optional[pulumi.Input[str]] = None,
            ip_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EndpointIpConfigArgs']]]]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vpc_region_id: Optional[pulumi.Input[str]] = None) -> 'Endpoint':
        """
        Get an existing Endpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] endpoint_name: The name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EndpointIpConfigArgs']]]] ip_configs: The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
        :param pulumi.Input[str] security_group_id: The ID of the Security Group.
        :param pulumi.Input[str] status: The status of the resource. Valid values: `CHANGE_FAILED`, `CHANGE_INIT`, `EXCEPTION`, `FAILED`, `INIT`, `SUCCESS`.
        :param pulumi.Input[str] vpc_id: The VPC ID.
        :param pulumi.Input[str] vpc_region_id: The Region of the VPC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointState.__new__(_EndpointState)

        __props__.__dict__["endpoint_name"] = endpoint_name
        __props__.__dict__["ip_configs"] = ip_configs
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpc_region_id"] = vpc_region_id
        return Endpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> pulumi.Output[str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="ipConfigs")
    def ip_configs(self) -> pulumi.Output[Sequence['outputs.EndpointIpConfig']]:
        """
        The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
        """
        return pulumi.get(self, "ip_configs")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the Security Group.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the resource. Valid values: `CHANGE_FAILED`, `CHANGE_INIT`, `EXCEPTION`, `FAILED`, `INIT`, `SUCCESS`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcRegionId")
    def vpc_region_id(self) -> pulumi.Output[str]:
        """
        The Region of the VPC.
        """
        return pulumi.get(self, "vpc_region_id")

