# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetZonesResult',
    'AwaitableGetZonesResult',
    'get_zones',
    'get_zones_output',
]

@pulumi.output_type
class GetZonesResult:
    """
    A collection of values returned by getZones.
    """
    def __init__(__self__, enable_details=None, id=None, ids=None, keyword=None, lang=None, name_regex=None, names=None, output_file=None, query_region_id=None, query_vpc_id=None, resource_group_id=None, search_mode=None, zones=None):
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if keyword and not isinstance(keyword, str):
            raise TypeError("Expected argument 'keyword' to be a str")
        pulumi.set(__self__, "keyword", keyword)
        if lang and not isinstance(lang, str):
            raise TypeError("Expected argument 'lang' to be a str")
        pulumi.set(__self__, "lang", lang)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if query_region_id and not isinstance(query_region_id, str):
            raise TypeError("Expected argument 'query_region_id' to be a str")
        pulumi.set(__self__, "query_region_id", query_region_id)
        if query_vpc_id and not isinstance(query_vpc_id, str):
            raise TypeError("Expected argument 'query_vpc_id' to be a str")
        pulumi.set(__self__, "query_vpc_id", query_vpc_id)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if search_mode and not isinstance(search_mode, str):
            raise TypeError("Expected argument 'search_mode' to be a str")
        pulumi.set(__self__, "search_mode", search_mode)
        if zones and not isinstance(zones, list):
            raise TypeError("Expected argument 'zones' to be a list")
        pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[bool]:
        return pulumi.get(self, "enable_details")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        """
        A list of zone IDs.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def keyword(self) -> Optional[str]:
        return pulumi.get(self, "keyword")

    @property
    @pulumi.getter
    def lang(self) -> Optional[str]:
        return pulumi.get(self, "lang")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        A list of zone names.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="queryRegionId")
    def query_region_id(self) -> Optional[str]:
        return pulumi.get(self, "query_region_id")

    @property
    @pulumi.getter(name="queryVpcId")
    def query_vpc_id(self) -> Optional[str]:
        return pulumi.get(self, "query_vpc_id")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[str]:
        """
        The Id of resource group which the Private Zone belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="searchMode")
    def search_mode(self) -> Optional[str]:
        return pulumi.get(self, "search_mode")

    @property
    @pulumi.getter
    def zones(self) -> Sequence['outputs.GetZonesZoneResult']:
        """
        A list of zones. Each element contains the following attributes:
        """
        return pulumi.get(self, "zones")


class AwaitableGetZonesResult(GetZonesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZonesResult(
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            keyword=self.keyword,
            lang=self.lang,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            query_region_id=self.query_region_id,
            query_vpc_id=self.query_vpc_id,
            resource_group_id=self.resource_group_id,
            search_mode=self.search_mode,
            zones=self.zones)


def get_zones(enable_details: Optional[bool] = None,
              ids: Optional[Sequence[str]] = None,
              keyword: Optional[str] = None,
              lang: Optional[str] = None,
              name_regex: Optional[str] = None,
              output_file: Optional[str] = None,
              query_region_id: Optional[str] = None,
              query_vpc_id: Optional[str] = None,
              resource_group_id: Optional[str] = None,
              search_mode: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZonesResult:
    """
    This data source lists a number of Private Zones resource information owned by an Alibaba Cloud account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    pvtz_zones_ds = alicloud.pvtz.get_zones(keyword=alicloud_pvtz_zone["basic"]["zone_name"])
    pulumi.export("firstZoneId", pvtz_zones_ds.zones[0].id)
    ```


    :param bool enable_details: Default to `false`. Set it to true can output more details.
    :param Sequence[str] ids: A list of zone IDs.
    :param str keyword: keyword for zone name.
    :param str lang: User language.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str query_region_id: query_region_id for zone regionId.
    :param str query_vpc_id: query_vpc_id for zone vpcId.
    :param str resource_group_id: resource_group_id for zone resourceGroupId.
    :param str search_mode: Search mode. Value: 
           - LIKE: fuzzy search.
           - EXACT: precise search. It is not filled in by default.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['keyword'] = keyword
    __args__['lang'] = lang
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['queryRegionId'] = query_region_id
    __args__['queryVpcId'] = query_vpc_id
    __args__['resourceGroupId'] = resource_group_id
    __args__['searchMode'] = search_mode
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:pvtz/getZones:getZones', __args__, opts=opts, typ=GetZonesResult).value

    return AwaitableGetZonesResult(
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        keyword=pulumi.get(__ret__, 'keyword'),
        lang=pulumi.get(__ret__, 'lang'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        query_region_id=pulumi.get(__ret__, 'query_region_id'),
        query_vpc_id=pulumi.get(__ret__, 'query_vpc_id'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        search_mode=pulumi.get(__ret__, 'search_mode'),
        zones=pulumi.get(__ret__, 'zones'))


@_utilities.lift_output_func(get_zones)
def get_zones_output(enable_details: Optional[pulumi.Input[Optional[bool]]] = None,
                     ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                     keyword: Optional[pulumi.Input[Optional[str]]] = None,
                     lang: Optional[pulumi.Input[Optional[str]]] = None,
                     name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                     output_file: Optional[pulumi.Input[Optional[str]]] = None,
                     query_region_id: Optional[pulumi.Input[Optional[str]]] = None,
                     query_vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                     resource_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                     search_mode: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetZonesResult]:
    """
    This data source lists a number of Private Zones resource information owned by an Alibaba Cloud account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    pvtz_zones_ds = alicloud.pvtz.get_zones(keyword=alicloud_pvtz_zone["basic"]["zone_name"])
    pulumi.export("firstZoneId", pvtz_zones_ds.zones[0].id)
    ```


    :param bool enable_details: Default to `false`. Set it to true can output more details.
    :param Sequence[str] ids: A list of zone IDs.
    :param str keyword: keyword for zone name.
    :param str lang: User language.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str query_region_id: query_region_id for zone regionId.
    :param str query_vpc_id: query_vpc_id for zone vpcId.
    :param str resource_group_id: resource_group_id for zone resourceGroupId.
    :param str search_mode: Search mode. Value: 
           - LIKE: fuzzy search.
           - EXACT: precise search. It is not filled in by default.
    """
    ...
