# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetTemplateApplicationsResult',
    'AwaitableGetTemplateApplicationsResult',
    'get_template_applications',
    'get_template_applications_output',
]

@pulumi.output_type
class GetTemplateApplicationsResult:
    """
    A collection of values returned by getTemplateApplications.
    """
    def __init__(__self__, applications=None, batch_quota_application_id=None, id=None, ids=None, output_file=None, product_code=None, quota_action_code=None, quota_category=None):
        if applications and not isinstance(applications, list):
            raise TypeError("Expected argument 'applications' to be a list")
        pulumi.set(__self__, "applications", applications)
        if batch_quota_application_id and not isinstance(batch_quota_application_id, str):
            raise TypeError("Expected argument 'batch_quota_application_id' to be a str")
        pulumi.set(__self__, "batch_quota_application_id", batch_quota_application_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if product_code and not isinstance(product_code, str):
            raise TypeError("Expected argument 'product_code' to be a str")
        pulumi.set(__self__, "product_code", product_code)
        if quota_action_code and not isinstance(quota_action_code, str):
            raise TypeError("Expected argument 'quota_action_code' to be a str")
        pulumi.set(__self__, "quota_action_code", quota_action_code)
        if quota_category and not isinstance(quota_category, str):
            raise TypeError("Expected argument 'quota_category' to be a str")
        pulumi.set(__self__, "quota_category", quota_category)

    @property
    @pulumi.getter
    def applications(self) -> Sequence['outputs.GetTemplateApplicationsApplicationResult']:
        """
        A list of Template Applications Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "applications")

    @property
    @pulumi.getter(name="batchQuotaApplicationId")
    def batch_quota_application_id(self) -> Optional[str]:
        """
        The ID of the quota application batch.
        """
        return pulumi.get(self, "batch_quota_application_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        """
        A list of Template Applications IDs.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="productCode")
    def product_code(self) -> Optional[str]:
        """
        Cloud service name abbreviation.> For more information about cloud services that support quota centers, see Cloud services that support quota centers.
        """
        return pulumi.get(self, "product_code")

    @property
    @pulumi.getter(name="quotaActionCode")
    def quota_action_code(self) -> Optional[str]:
        """
        The quota ID.
        """
        return pulumi.get(self, "quota_action_code")

    @property
    @pulumi.getter(name="quotaCategory")
    def quota_category(self) -> Optional[str]:
        """
        The quota type. Value:-CommonQuota (default): Generic quota.-FlowControl:API rate quota.-WhiteListLabel: Equity quota.
        """
        return pulumi.get(self, "quota_category")


class AwaitableGetTemplateApplicationsResult(GetTemplateApplicationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTemplateApplicationsResult(
            applications=self.applications,
            batch_quota_application_id=self.batch_quota_application_id,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            product_code=self.product_code,
            quota_action_code=self.quota_action_code,
            quota_category=self.quota_category)


def get_template_applications(batch_quota_application_id: Optional[str] = None,
                              ids: Optional[Sequence[str]] = None,
                              output_file: Optional[str] = None,
                              product_code: Optional[str] = None,
                              quota_action_code: Optional[str] = None,
                              quota_category: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTemplateApplicationsResult:
    """
    This data source provides Quotas Template Applications available to the user.[What is Template Applications](https://www.alibabacloud.com/help/en/quota-center/developer-reference/api-quotas-2020-05-10-createquotaapplicationsfortemplate)

    > **NOTE:** Available since v1.214.0.


    :param str batch_quota_application_id: The ID of the quota application batch.
    :param Sequence[str] ids: A list of Template Applications IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str product_code: Cloud service name abbreviation.> For more information about cloud services that support quota centers, see Cloud services that support quota centers.
    :param str quota_action_code: The quota ID.
    :param str quota_category: The quota type. Value:-CommonQuota (default): Generic quota.-FlowControl:API rate quota.-WhiteListLabel: Equity quota.
    """
    __args__ = dict()
    __args__['batchQuotaApplicationId'] = batch_quota_application_id
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['productCode'] = product_code
    __args__['quotaActionCode'] = quota_action_code
    __args__['quotaCategory'] = quota_category
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:quotas/getTemplateApplications:getTemplateApplications', __args__, opts=opts, typ=GetTemplateApplicationsResult).value

    return AwaitableGetTemplateApplicationsResult(
        applications=pulumi.get(__ret__, 'applications'),
        batch_quota_application_id=pulumi.get(__ret__, 'batch_quota_application_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        product_code=pulumi.get(__ret__, 'product_code'),
        quota_action_code=pulumi.get(__ret__, 'quota_action_code'),
        quota_category=pulumi.get(__ret__, 'quota_category'))


@_utilities.lift_output_func(get_template_applications)
def get_template_applications_output(batch_quota_application_id: Optional[pulumi.Input[Optional[str]]] = None,
                                     ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                     output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                     product_code: Optional[pulumi.Input[Optional[str]]] = None,
                                     quota_action_code: Optional[pulumi.Input[Optional[str]]] = None,
                                     quota_category: Optional[pulumi.Input[Optional[str]]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTemplateApplicationsResult]:
    """
    This data source provides Quotas Template Applications available to the user.[What is Template Applications](https://www.alibabacloud.com/help/en/quota-center/developer-reference/api-quotas-2020-05-10-createquotaapplicationsfortemplate)

    > **NOTE:** Available since v1.214.0.


    :param str batch_quota_application_id: The ID of the quota application batch.
    :param Sequence[str] ids: A list of Template Applications IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str product_code: Cloud service name abbreviation.> For more information about cloud services that support quota centers, see Cloud services that support quota centers.
    :param str quota_action_code: The quota ID.
    :param str quota_category: The quota type. Value:-CommonQuota (default): Generic quota.-FlowControl:API rate quota.-WhiteListLabel: Equity quota.
    """
    ...
