# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TemplateApplicationsArgs', 'TemplateApplications']

@pulumi.input_type
class TemplateApplicationsArgs:
    def __init__(__self__, *,
                 aliyun_uids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 desire_value: pulumi.Input[float],
                 product_code: pulumi.Input[str],
                 quota_action_code: pulumi.Input[str],
                 quota_category: pulumi.Input[str],
                 reason: pulumi.Input[str],
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['TemplateApplicationsDimensionArgs']]]] = None,
                 effective_time: Optional[pulumi.Input[str]] = None,
                 env_language: Optional[pulumi.Input[str]] = None,
                 expire_time: Optional[pulumi.Input[str]] = None,
                 notice_type: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a TemplateApplications resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] aliyun_uids: The list of Alibaba Cloud accounts (primary accounts) of the resource directory members to which the quota is applied.
               > **NOTE:**  Only 50 members can apply for quota increase in batch at a time. For more information about the members of the resource directory, see Query the list of all members in the resource directory.
        :param pulumi.Input[float] desire_value: The value of the quota request.
               > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
        :param pulumi.Input[str] product_code: Cloud service name abbreviation.
               > **NOTE:**  For more information about cloud services that support quota centers, see Cloud services that support quota centers.
        :param pulumi.Input[str] quota_action_code: The quota ID.
        :param pulumi.Input[str] quota_category: The quota type. Value:
               - CommonQuota (default): Generic quota.
               - FlowControl:API rate quota.
               - WhiteListLabel: Equity quota.
        :param pulumi.Input[str] reason: Reason for quota application.
               > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
        :param pulumi.Input[Sequence[pulumi.Input['TemplateApplicationsDimensionArgs']]] dimensions: Quota dimension. See `dimensions` below.
        :param pulumi.Input[str] effective_time: The UTC time when the quota takes effect. This parameter applies only to the equity quota (WhiteListLabel).
               > **NOTE:**  If the current account does not select the effective time, the default is the submission time.
        :param pulumi.Input[str] env_language: The language of the quota application result notification. Value:
               - zh (default): Chinese.
               - en: English.
        :param pulumi.Input[str] expire_time: The UTC time when the quota expires. This parameter applies only to the equity quota (WhiteListLabel).
               > **NOTE:**  If No Expiration Time is selected for the current account, the expiration time is 99 years from the effective time of the current quota.
        :param pulumi.Input[int] notice_type: Whether to send notification of quota application result. Value:
               - 0 (default): No.
               - 3: Yes.
        """
        pulumi.set(__self__, "aliyun_uids", aliyun_uids)
        pulumi.set(__self__, "desire_value", desire_value)
        pulumi.set(__self__, "product_code", product_code)
        pulumi.set(__self__, "quota_action_code", quota_action_code)
        pulumi.set(__self__, "quota_category", quota_category)
        pulumi.set(__self__, "reason", reason)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if env_language is not None:
            pulumi.set(__self__, "env_language", env_language)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if notice_type is not None:
            pulumi.set(__self__, "notice_type", notice_type)

    @property
    @pulumi.getter(name="aliyunUids")
    def aliyun_uids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of Alibaba Cloud accounts (primary accounts) of the resource directory members to which the quota is applied.
        > **NOTE:**  Only 50 members can apply for quota increase in batch at a time. For more information about the members of the resource directory, see Query the list of all members in the resource directory.
        """
        return pulumi.get(self, "aliyun_uids")

    @aliyun_uids.setter
    def aliyun_uids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "aliyun_uids", value)

    @property
    @pulumi.getter(name="desireValue")
    def desire_value(self) -> pulumi.Input[float]:
        """
        The value of the quota request.
        > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
        """
        return pulumi.get(self, "desire_value")

    @desire_value.setter
    def desire_value(self, value: pulumi.Input[float]):
        pulumi.set(self, "desire_value", value)

    @property
    @pulumi.getter(name="productCode")
    def product_code(self) -> pulumi.Input[str]:
        """
        Cloud service name abbreviation.
        > **NOTE:**  For more information about cloud services that support quota centers, see Cloud services that support quota centers.
        """
        return pulumi.get(self, "product_code")

    @product_code.setter
    def product_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "product_code", value)

    @property
    @pulumi.getter(name="quotaActionCode")
    def quota_action_code(self) -> pulumi.Input[str]:
        """
        The quota ID.
        """
        return pulumi.get(self, "quota_action_code")

    @quota_action_code.setter
    def quota_action_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "quota_action_code", value)

    @property
    @pulumi.getter(name="quotaCategory")
    def quota_category(self) -> pulumi.Input[str]:
        """
        The quota type. Value:
        - CommonQuota (default): Generic quota.
        - FlowControl:API rate quota.
        - WhiteListLabel: Equity quota.
        """
        return pulumi.get(self, "quota_category")

    @quota_category.setter
    def quota_category(self, value: pulumi.Input[str]):
        pulumi.set(self, "quota_category", value)

    @property
    @pulumi.getter
    def reason(self) -> pulumi.Input[str]:
        """
        Reason for quota application.
        > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: pulumi.Input[str]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TemplateApplicationsDimensionArgs']]]]:
        """
        Quota dimension. See `dimensions` below.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TemplateApplicationsDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[pulumi.Input[str]]:
        """
        The UTC time when the quota takes effect. This parameter applies only to the equity quota (WhiteListLabel).
        > **NOTE:**  If the current account does not select the effective time, the default is the submission time.
        """
        return pulumi.get(self, "effective_time")

    @effective_time.setter
    def effective_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effective_time", value)

    @property
    @pulumi.getter(name="envLanguage")
    def env_language(self) -> Optional[pulumi.Input[str]]:
        """
        The language of the quota application result notification. Value:
        - zh (default): Chinese.
        - en: English.
        """
        return pulumi.get(self, "env_language")

    @env_language.setter
    def env_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "env_language", value)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[str]]:
        """
        The UTC time when the quota expires. This parameter applies only to the equity quota (WhiteListLabel).
        > **NOTE:**  If No Expiration Time is selected for the current account, the expiration time is 99 years from the effective time of the current quota.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expire_time", value)

    @property
    @pulumi.getter(name="noticeType")
    def notice_type(self) -> Optional[pulumi.Input[int]]:
        """
        Whether to send notification of quota application result. Value:
        - 0 (default): No.
        - 3: Yes.
        """
        return pulumi.get(self, "notice_type")

    @notice_type.setter
    def notice_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "notice_type", value)


@pulumi.input_type
class _TemplateApplicationsState:
    def __init__(__self__, *,
                 aliyun_uids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 desire_value: Optional[pulumi.Input[float]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['TemplateApplicationsDimensionArgs']]]] = None,
                 effective_time: Optional[pulumi.Input[str]] = None,
                 env_language: Optional[pulumi.Input[str]] = None,
                 expire_time: Optional[pulumi.Input[str]] = None,
                 notice_type: Optional[pulumi.Input[int]] = None,
                 product_code: Optional[pulumi.Input[str]] = None,
                 quota_action_code: Optional[pulumi.Input[str]] = None,
                 quota_application_details: Optional[pulumi.Input[Sequence[pulumi.Input['TemplateApplicationsQuotaApplicationDetailArgs']]]] = None,
                 quota_category: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TemplateApplications resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] aliyun_uids: The list of Alibaba Cloud accounts (primary accounts) of the resource directory members to which the quota is applied.
               > **NOTE:**  Only 50 members can apply for quota increase in batch at a time. For more information about the members of the resource directory, see Query the list of all members in the resource directory.
        :param pulumi.Input[float] desire_value: The value of the quota request.
               > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
        :param pulumi.Input[Sequence[pulumi.Input['TemplateApplicationsDimensionArgs']]] dimensions: Quota dimension. See `dimensions` below.
        :param pulumi.Input[str] effective_time: The UTC time when the quota takes effect. This parameter applies only to the equity quota (WhiteListLabel).
               > **NOTE:**  If the current account does not select the effective time, the default is the submission time.
        :param pulumi.Input[str] env_language: The language of the quota application result notification. Value:
               - zh (default): Chinese.
               - en: English.
        :param pulumi.Input[str] expire_time: The UTC time when the quota expires. This parameter applies only to the equity quota (WhiteListLabel).
               > **NOTE:**  If No Expiration Time is selected for the current account, the expiration time is 99 years from the effective time of the current quota.
        :param pulumi.Input[int] notice_type: Whether to send notification of quota application result. Value:
               - 0 (default): No.
               - 3: Yes.
        :param pulumi.Input[str] product_code: Cloud service name abbreviation.
               > **NOTE:**  For more information about cloud services that support quota centers, see Cloud services that support quota centers.
        :param pulumi.Input[str] quota_action_code: The quota ID.
        :param pulumi.Input[Sequence[pulumi.Input['TemplateApplicationsQuotaApplicationDetailArgs']]] quota_application_details: List of quota application details.
        :param pulumi.Input[str] quota_category: The quota type. Value:
               - CommonQuota (default): Generic quota.
               - FlowControl:API rate quota.
               - WhiteListLabel: Equity quota.
        :param pulumi.Input[str] reason: Reason for quota application.
               > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
        """
        if aliyun_uids is not None:
            pulumi.set(__self__, "aliyun_uids", aliyun_uids)
        if desire_value is not None:
            pulumi.set(__self__, "desire_value", desire_value)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if env_language is not None:
            pulumi.set(__self__, "env_language", env_language)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if notice_type is not None:
            pulumi.set(__self__, "notice_type", notice_type)
        if product_code is not None:
            pulumi.set(__self__, "product_code", product_code)
        if quota_action_code is not None:
            pulumi.set(__self__, "quota_action_code", quota_action_code)
        if quota_application_details is not None:
            pulumi.set(__self__, "quota_application_details", quota_application_details)
        if quota_category is not None:
            pulumi.set(__self__, "quota_category", quota_category)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter(name="aliyunUids")
    def aliyun_uids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of Alibaba Cloud accounts (primary accounts) of the resource directory members to which the quota is applied.
        > **NOTE:**  Only 50 members can apply for quota increase in batch at a time. For more information about the members of the resource directory, see Query the list of all members in the resource directory.
        """
        return pulumi.get(self, "aliyun_uids")

    @aliyun_uids.setter
    def aliyun_uids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "aliyun_uids", value)

    @property
    @pulumi.getter(name="desireValue")
    def desire_value(self) -> Optional[pulumi.Input[float]]:
        """
        The value of the quota request.
        > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
        """
        return pulumi.get(self, "desire_value")

    @desire_value.setter
    def desire_value(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "desire_value", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TemplateApplicationsDimensionArgs']]]]:
        """
        Quota dimension. See `dimensions` below.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TemplateApplicationsDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[pulumi.Input[str]]:
        """
        The UTC time when the quota takes effect. This parameter applies only to the equity quota (WhiteListLabel).
        > **NOTE:**  If the current account does not select the effective time, the default is the submission time.
        """
        return pulumi.get(self, "effective_time")

    @effective_time.setter
    def effective_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effective_time", value)

    @property
    @pulumi.getter(name="envLanguage")
    def env_language(self) -> Optional[pulumi.Input[str]]:
        """
        The language of the quota application result notification. Value:
        - zh (default): Chinese.
        - en: English.
        """
        return pulumi.get(self, "env_language")

    @env_language.setter
    def env_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "env_language", value)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[str]]:
        """
        The UTC time when the quota expires. This parameter applies only to the equity quota (WhiteListLabel).
        > **NOTE:**  If No Expiration Time is selected for the current account, the expiration time is 99 years from the effective time of the current quota.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expire_time", value)

    @property
    @pulumi.getter(name="noticeType")
    def notice_type(self) -> Optional[pulumi.Input[int]]:
        """
        Whether to send notification of quota application result. Value:
        - 0 (default): No.
        - 3: Yes.
        """
        return pulumi.get(self, "notice_type")

    @notice_type.setter
    def notice_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "notice_type", value)

    @property
    @pulumi.getter(name="productCode")
    def product_code(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud service name abbreviation.
        > **NOTE:**  For more information about cloud services that support quota centers, see Cloud services that support quota centers.
        """
        return pulumi.get(self, "product_code")

    @product_code.setter
    def product_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_code", value)

    @property
    @pulumi.getter(name="quotaActionCode")
    def quota_action_code(self) -> Optional[pulumi.Input[str]]:
        """
        The quota ID.
        """
        return pulumi.get(self, "quota_action_code")

    @quota_action_code.setter
    def quota_action_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quota_action_code", value)

    @property
    @pulumi.getter(name="quotaApplicationDetails")
    def quota_application_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TemplateApplicationsQuotaApplicationDetailArgs']]]]:
        """
        List of quota application details.
        """
        return pulumi.get(self, "quota_application_details")

    @quota_application_details.setter
    def quota_application_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TemplateApplicationsQuotaApplicationDetailArgs']]]]):
        pulumi.set(self, "quota_application_details", value)

    @property
    @pulumi.getter(name="quotaCategory")
    def quota_category(self) -> Optional[pulumi.Input[str]]:
        """
        The quota type. Value:
        - CommonQuota (default): Generic quota.
        - FlowControl:API rate quota.
        - WhiteListLabel: Equity quota.
        """
        return pulumi.get(self, "quota_category")

    @quota_category.setter
    def quota_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quota_category", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        Reason for quota application.
        > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)


class TemplateApplications(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliyun_uids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 desire_value: Optional[pulumi.Input[float]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TemplateApplicationsDimensionArgs']]]]] = None,
                 effective_time: Optional[pulumi.Input[str]] = None,
                 env_language: Optional[pulumi.Input[str]] = None,
                 expire_time: Optional[pulumi.Input[str]] = None,
                 notice_type: Optional[pulumi.Input[int]] = None,
                 product_code: Optional[pulumi.Input[str]] = None,
                 quota_action_code: Optional[pulumi.Input[str]] = None,
                 quota_category: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        Quotas Template Applications can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:quotas/templateApplications:TemplateApplications example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] aliyun_uids: The list of Alibaba Cloud accounts (primary accounts) of the resource directory members to which the quota is applied.
               > **NOTE:**  Only 50 members can apply for quota increase in batch at a time. For more information about the members of the resource directory, see Query the list of all members in the resource directory.
        :param pulumi.Input[float] desire_value: The value of the quota request.
               > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TemplateApplicationsDimensionArgs']]]] dimensions: Quota dimension. See `dimensions` below.
        :param pulumi.Input[str] effective_time: The UTC time when the quota takes effect. This parameter applies only to the equity quota (WhiteListLabel).
               > **NOTE:**  If the current account does not select the effective time, the default is the submission time.
        :param pulumi.Input[str] env_language: The language of the quota application result notification. Value:
               - zh (default): Chinese.
               - en: English.
        :param pulumi.Input[str] expire_time: The UTC time when the quota expires. This parameter applies only to the equity quota (WhiteListLabel).
               > **NOTE:**  If No Expiration Time is selected for the current account, the expiration time is 99 years from the effective time of the current quota.
        :param pulumi.Input[int] notice_type: Whether to send notification of quota application result. Value:
               - 0 (default): No.
               - 3: Yes.
        :param pulumi.Input[str] product_code: Cloud service name abbreviation.
               > **NOTE:**  For more information about cloud services that support quota centers, see Cloud services that support quota centers.
        :param pulumi.Input[str] quota_action_code: The quota ID.
        :param pulumi.Input[str] quota_category: The quota type. Value:
               - CommonQuota (default): Generic quota.
               - FlowControl:API rate quota.
               - WhiteListLabel: Equity quota.
        :param pulumi.Input[str] reason: Reason for quota application.
               > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TemplateApplicationsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Quotas Template Applications can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:quotas/templateApplications:TemplateApplications example <id>
        ```

        :param str resource_name: The name of the resource.
        :param TemplateApplicationsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TemplateApplicationsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliyun_uids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 desire_value: Optional[pulumi.Input[float]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TemplateApplicationsDimensionArgs']]]]] = None,
                 effective_time: Optional[pulumi.Input[str]] = None,
                 env_language: Optional[pulumi.Input[str]] = None,
                 expire_time: Optional[pulumi.Input[str]] = None,
                 notice_type: Optional[pulumi.Input[int]] = None,
                 product_code: Optional[pulumi.Input[str]] = None,
                 quota_action_code: Optional[pulumi.Input[str]] = None,
                 quota_category: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TemplateApplicationsArgs.__new__(TemplateApplicationsArgs)

            if aliyun_uids is None and not opts.urn:
                raise TypeError("Missing required property 'aliyun_uids'")
            __props__.__dict__["aliyun_uids"] = aliyun_uids
            if desire_value is None and not opts.urn:
                raise TypeError("Missing required property 'desire_value'")
            __props__.__dict__["desire_value"] = desire_value
            __props__.__dict__["dimensions"] = dimensions
            __props__.__dict__["effective_time"] = effective_time
            __props__.__dict__["env_language"] = env_language
            __props__.__dict__["expire_time"] = expire_time
            __props__.__dict__["notice_type"] = notice_type
            if product_code is None and not opts.urn:
                raise TypeError("Missing required property 'product_code'")
            __props__.__dict__["product_code"] = product_code
            if quota_action_code is None and not opts.urn:
                raise TypeError("Missing required property 'quota_action_code'")
            __props__.__dict__["quota_action_code"] = quota_action_code
            if quota_category is None and not opts.urn:
                raise TypeError("Missing required property 'quota_category'")
            __props__.__dict__["quota_category"] = quota_category
            if reason is None and not opts.urn:
                raise TypeError("Missing required property 'reason'")
            __props__.__dict__["reason"] = reason
            __props__.__dict__["quota_application_details"] = None
        super(TemplateApplications, __self__).__init__(
            'alicloud:quotas/templateApplications:TemplateApplications',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aliyun_uids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            desire_value: Optional[pulumi.Input[float]] = None,
            dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TemplateApplicationsDimensionArgs']]]]] = None,
            effective_time: Optional[pulumi.Input[str]] = None,
            env_language: Optional[pulumi.Input[str]] = None,
            expire_time: Optional[pulumi.Input[str]] = None,
            notice_type: Optional[pulumi.Input[int]] = None,
            product_code: Optional[pulumi.Input[str]] = None,
            quota_action_code: Optional[pulumi.Input[str]] = None,
            quota_application_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TemplateApplicationsQuotaApplicationDetailArgs']]]]] = None,
            quota_category: Optional[pulumi.Input[str]] = None,
            reason: Optional[pulumi.Input[str]] = None) -> 'TemplateApplications':
        """
        Get an existing TemplateApplications resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] aliyun_uids: The list of Alibaba Cloud accounts (primary accounts) of the resource directory members to which the quota is applied.
               > **NOTE:**  Only 50 members can apply for quota increase in batch at a time. For more information about the members of the resource directory, see Query the list of all members in the resource directory.
        :param pulumi.Input[float] desire_value: The value of the quota request.
               > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TemplateApplicationsDimensionArgs']]]] dimensions: Quota dimension. See `dimensions` below.
        :param pulumi.Input[str] effective_time: The UTC time when the quota takes effect. This parameter applies only to the equity quota (WhiteListLabel).
               > **NOTE:**  If the current account does not select the effective time, the default is the submission time.
        :param pulumi.Input[str] env_language: The language of the quota application result notification. Value:
               - zh (default): Chinese.
               - en: English.
        :param pulumi.Input[str] expire_time: The UTC time when the quota expires. This parameter applies only to the equity quota (WhiteListLabel).
               > **NOTE:**  If No Expiration Time is selected for the current account, the expiration time is 99 years from the effective time of the current quota.
        :param pulumi.Input[int] notice_type: Whether to send notification of quota application result. Value:
               - 0 (default): No.
               - 3: Yes.
        :param pulumi.Input[str] product_code: Cloud service name abbreviation.
               > **NOTE:**  For more information about cloud services that support quota centers, see Cloud services that support quota centers.
        :param pulumi.Input[str] quota_action_code: The quota ID.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TemplateApplicationsQuotaApplicationDetailArgs']]]] quota_application_details: List of quota application details.
        :param pulumi.Input[str] quota_category: The quota type. Value:
               - CommonQuota (default): Generic quota.
               - FlowControl:API rate quota.
               - WhiteListLabel: Equity quota.
        :param pulumi.Input[str] reason: Reason for quota application.
               > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TemplateApplicationsState.__new__(_TemplateApplicationsState)

        __props__.__dict__["aliyun_uids"] = aliyun_uids
        __props__.__dict__["desire_value"] = desire_value
        __props__.__dict__["dimensions"] = dimensions
        __props__.__dict__["effective_time"] = effective_time
        __props__.__dict__["env_language"] = env_language
        __props__.__dict__["expire_time"] = expire_time
        __props__.__dict__["notice_type"] = notice_type
        __props__.__dict__["product_code"] = product_code
        __props__.__dict__["quota_action_code"] = quota_action_code
        __props__.__dict__["quota_application_details"] = quota_application_details
        __props__.__dict__["quota_category"] = quota_category
        __props__.__dict__["reason"] = reason
        return TemplateApplications(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aliyunUids")
    def aliyun_uids(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of Alibaba Cloud accounts (primary accounts) of the resource directory members to which the quota is applied.
        > **NOTE:**  Only 50 members can apply for quota increase in batch at a time. For more information about the members of the resource directory, see Query the list of all members in the resource directory.
        """
        return pulumi.get(self, "aliyun_uids")

    @property
    @pulumi.getter(name="desireValue")
    def desire_value(self) -> pulumi.Output[float]:
        """
        The value of the quota request.
        > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
        """
        return pulumi.get(self, "desire_value")

    @property
    @pulumi.getter
    def dimensions(self) -> pulumi.Output[Optional[Sequence['outputs.TemplateApplicationsDimension']]]:
        """
        Quota dimension. See `dimensions` below.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> pulumi.Output[Optional[str]]:
        """
        The UTC time when the quota takes effect. This parameter applies only to the equity quota (WhiteListLabel).
        > **NOTE:**  If the current account does not select the effective time, the default is the submission time.
        """
        return pulumi.get(self, "effective_time")

    @property
    @pulumi.getter(name="envLanguage")
    def env_language(self) -> pulumi.Output[Optional[str]]:
        """
        The language of the quota application result notification. Value:
        - zh (default): Chinese.
        - en: English.
        """
        return pulumi.get(self, "env_language")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[Optional[str]]:
        """
        The UTC time when the quota expires. This parameter applies only to the equity quota (WhiteListLabel).
        > **NOTE:**  If No Expiration Time is selected for the current account, the expiration time is 99 years from the effective time of the current quota.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter(name="noticeType")
    def notice_type(self) -> pulumi.Output[Optional[int]]:
        """
        Whether to send notification of quota application result. Value:
        - 0 (default): No.
        - 3: Yes.
        """
        return pulumi.get(self, "notice_type")

    @property
    @pulumi.getter(name="productCode")
    def product_code(self) -> pulumi.Output[str]:
        """
        Cloud service name abbreviation.
        > **NOTE:**  For more information about cloud services that support quota centers, see Cloud services that support quota centers.
        """
        return pulumi.get(self, "product_code")

    @property
    @pulumi.getter(name="quotaActionCode")
    def quota_action_code(self) -> pulumi.Output[str]:
        """
        The quota ID.
        """
        return pulumi.get(self, "quota_action_code")

    @property
    @pulumi.getter(name="quotaApplicationDetails")
    def quota_application_details(self) -> pulumi.Output[Sequence['outputs.TemplateApplicationsQuotaApplicationDetail']]:
        """
        List of quota application details.
        """
        return pulumi.get(self, "quota_application_details")

    @property
    @pulumi.getter(name="quotaCategory")
    def quota_category(self) -> pulumi.Output[str]:
        """
        The quota type. Value:
        - CommonQuota (default): Generic quota.
        - FlowControl:API rate quota.
        - WhiteListLabel: Equity quota.
        """
        return pulumi.get(self, "quota_category")

    @property
    @pulumi.getter
    def reason(self) -> pulumi.Output[str]:
        """
        Reason for quota application.
        > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
        """
        return pulumi.get(self, "reason")

