# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetUsersResult',
    'AwaitableGetUsersResult',
    'get_users',
    'get_users_output',
]

@pulumi.output_type
class GetUsersResult:
    """
    A collection of values returned by getUsers.
    """
    def __init__(__self__, group_name=None, id=None, ids=None, name_regex=None, names=None, output_file=None, policy_name=None, policy_type=None, users=None):
        if group_name and not isinstance(group_name, str):
            raise TypeError("Expected argument 'group_name' to be a str")
        pulumi.set(__self__, "group_name", group_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if policy_name and not isinstance(policy_name, str):
            raise TypeError("Expected argument 'policy_name' to be a str")
        pulumi.set(__self__, "policy_name", policy_name)
        if policy_type and not isinstance(policy_type, str):
            raise TypeError("Expected argument 'policy_type' to be a str")
        pulumi.set(__self__, "policy_type", policy_type)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[str]:
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        """
        A list of ram user IDs.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        A list of ram user's name.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[str]:
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetUsersUserResult']:
        """
        A list of users. Each element contains the following attributes:
        """
        return pulumi.get(self, "users")


class AwaitableGetUsersResult(GetUsersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUsersResult(
            group_name=self.group_name,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            policy_name=self.policy_name,
            policy_type=self.policy_type,
            users=self.users)


def get_users(group_name: Optional[str] = None,
              ids: Optional[Sequence[str]] = None,
              name_regex: Optional[str] = None,
              output_file: Optional[str] = None,
              policy_name: Optional[str] = None,
              policy_type: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUsersResult:
    """
    This data source provides a list of RAM users in an Alibaba Cloud account according to the specified filters.

    > **NOTE:** Available since v1.0.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default_group = alicloud.ram.Group("defaultGroup",
        comments="group comments",
        force=True)
    default_user = alicloud.ram.User("defaultUser",
        display_name="displayname",
        mobile="86-18888888888",
        email="hello.uuu@aaa.com",
        comments="yoyoyo")
    default_group_membership = alicloud.ram.GroupMembership("defaultGroupMembership",
        group_name=default_group.name,
        user_names=[default_user.name])
    default_policy = alicloud.ram.Policy("defaultPolicy",
        policy_name="ram-policy-example",
        policy_document=\"\"\"			{
    				"Statement": [
    				 {
    					"Action": [
    					"oss:ListObjects",
    					"oss:ListObjects"
    			  		],
    			  		"Effect": "Deny",
    			  		"Resource": [
    						"acs:oss:*:*:mybucket",
    						"acs:oss:*:*:mybucket/*"
    			  		]
    				 }
    		  		],
    				"Version": "1"
    			}
    \"\"\",
        description="this is a policy example",
        force=True)
    default_user_policy_attachment = alicloud.ram.UserPolicyAttachment("defaultUserPolicyAttachment",
        policy_name=default_policy.policy_name,
        user_name=default_user.name,
        policy_type=default_policy.type)
    users_ds = alicloud.ram.get_users_output(output_file="users.txt",
        group_name=default_group.name,
        policy_name=default_policy.policy_name,
        policy_type="Custom",
        name_regex=default_user.name)
    pulumi.export("firstUserId", users_ds.users[0].id)
    ```


    :param str group_name: Filter results by a specific group name. Returned users are in the specified group.
    :param Sequence[str] ids: A list of ram user IDs.
    :param str name_regex: A regex string to filter resulting users by their names.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str policy_name: Filter results by a specific policy name. If you set this parameter without setting `policy_type`, the later will be automatically set to `System`. Returned users are attached to the specified policy.
    :param str policy_type: Filter results by a specific policy type. Valid values are `Custom` and `System`. If you set this parameter, you must set `policy_name` as well.
    """
    __args__ = dict()
    __args__['groupName'] = group_name
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['policyName'] = policy_name
    __args__['policyType'] = policy_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ram/getUsers:getUsers', __args__, opts=opts, typ=GetUsersResult).value

    return AwaitableGetUsersResult(
        group_name=pulumi.get(__ret__, 'group_name'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        policy_name=pulumi.get(__ret__, 'policy_name'),
        policy_type=pulumi.get(__ret__, 'policy_type'),
        users=pulumi.get(__ret__, 'users'))


@_utilities.lift_output_func(get_users)
def get_users_output(group_name: Optional[pulumi.Input[Optional[str]]] = None,
                     ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                     name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                     output_file: Optional[pulumi.Input[Optional[str]]] = None,
                     policy_name: Optional[pulumi.Input[Optional[str]]] = None,
                     policy_type: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUsersResult]:
    """
    This data source provides a list of RAM users in an Alibaba Cloud account according to the specified filters.

    > **NOTE:** Available since v1.0.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default_group = alicloud.ram.Group("defaultGroup",
        comments="group comments",
        force=True)
    default_user = alicloud.ram.User("defaultUser",
        display_name="displayname",
        mobile="86-18888888888",
        email="hello.uuu@aaa.com",
        comments="yoyoyo")
    default_group_membership = alicloud.ram.GroupMembership("defaultGroupMembership",
        group_name=default_group.name,
        user_names=[default_user.name])
    default_policy = alicloud.ram.Policy("defaultPolicy",
        policy_name="ram-policy-example",
        policy_document=\"\"\"			{
    				"Statement": [
    				 {
    					"Action": [
    					"oss:ListObjects",
    					"oss:ListObjects"
    			  		],
    			  		"Effect": "Deny",
    			  		"Resource": [
    						"acs:oss:*:*:mybucket",
    						"acs:oss:*:*:mybucket/*"
    			  		]
    				 }
    		  		],
    				"Version": "1"
    			}
    \"\"\",
        description="this is a policy example",
        force=True)
    default_user_policy_attachment = alicloud.ram.UserPolicyAttachment("defaultUserPolicyAttachment",
        policy_name=default_policy.policy_name,
        user_name=default_user.name,
        policy_type=default_policy.type)
    users_ds = alicloud.ram.get_users_output(output_file="users.txt",
        group_name=default_group.name,
        policy_name=default_policy.policy_name,
        policy_type="Custom",
        name_regex=default_user.name)
    pulumi.export("firstUserId", users_ds.users[0].id)
    ```


    :param str group_name: Filter results by a specific group name. Returned users are in the specified group.
    :param Sequence[str] ids: A list of ram user IDs.
    :param str name_regex: A regex string to filter resulting users by their names.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str policy_name: Filter results by a specific policy name. If you set this parameter without setting `policy_type`, the later will be automatically set to `System`. Returned users are attached to the specified policy.
    :param str policy_type: Filter results by a specific policy type. Valid values are `Custom` and `System`. If you set this parameter, you must set `policy_name` as well.
    """
    ...
