# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SecurityPreferenceArgs', 'SecurityPreference']

@pulumi.input_type
class SecurityPreferenceArgs:
    def __init__(__self__, *,
                 allow_user_to_change_password: Optional[pulumi.Input[bool]] = None,
                 allow_user_to_manage_access_keys: Optional[pulumi.Input[bool]] = None,
                 allow_user_to_manage_mfa_devices: Optional[pulumi.Input[bool]] = None,
                 enable_save_mfa_ticket: Optional[pulumi.Input[bool]] = None,
                 enforce_mfa_for_login: Optional[pulumi.Input[bool]] = None,
                 login_network_masks: Optional[pulumi.Input[str]] = None,
                 login_session_duration: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a SecurityPreference resource.
        :param pulumi.Input[bool] allow_user_to_change_password: Specifies whether RAM users can change their passwords. Valid values: `true` and `false`
        :param pulumi.Input[bool] allow_user_to_manage_access_keys: Specifies whether RAM users can manage their AccessKey pairs. Valid values: `true` and `false`
        :param pulumi.Input[bool] allow_user_to_manage_mfa_devices: Specifies whether RAM users can manage their MFA devices. Valid values: `true` and `false`
        :param pulumi.Input[bool] enable_save_mfa_ticket: Specifies whether to remember the MFA devices for seven days. Valid values: `true` and `false`
        :param pulumi.Input[bool] enforce_mfa_for_login: Specifies whether MFA is required for all RAM users when they log on to the Alibaba Cloud Management Console by using usernames and passwords. Valid values: `true` and `false`
        :param pulumi.Input[str] login_network_masks: The subnet mask that specifies the IP addresses from which you can log on to the Alibaba Cloud Management Console. This parameter takes effect on password-based logon and single sign-on (SSO). However, this parameter does not take effect on API calls that are authenticated by using AccessKey pairs.**NOTE:** You can specify up to 25 subnet masks. The total length of the subnet masks can be a maximum of 512 characters.
               * If you specify a subnet mask, RAM users can use only the IP addresses in the subnet mask to log on to the Alibaba Cloud Management Console.
               * If you do not specify a subnet mask, RAM users can use all IP addresses to log on to the Alibaba Cloud Management Console.
               * If you need to specify multiple subnet masks, separate the subnet masks with semicolons (;). Example: 192.168.0.0/16;10.0.0.0/8.
        :param pulumi.Input[int] login_session_duration: The validity period of the logon session of RAM users. Valid values: 6 to 24. Unit: hours. Default value: 6.
        """
        if allow_user_to_change_password is not None:
            pulumi.set(__self__, "allow_user_to_change_password", allow_user_to_change_password)
        if allow_user_to_manage_access_keys is not None:
            pulumi.set(__self__, "allow_user_to_manage_access_keys", allow_user_to_manage_access_keys)
        if allow_user_to_manage_mfa_devices is not None:
            pulumi.set(__self__, "allow_user_to_manage_mfa_devices", allow_user_to_manage_mfa_devices)
        if enable_save_mfa_ticket is not None:
            pulumi.set(__self__, "enable_save_mfa_ticket", enable_save_mfa_ticket)
        if enforce_mfa_for_login is not None:
            pulumi.set(__self__, "enforce_mfa_for_login", enforce_mfa_for_login)
        if login_network_masks is not None:
            pulumi.set(__self__, "login_network_masks", login_network_masks)
        if login_session_duration is not None:
            pulumi.set(__self__, "login_session_duration", login_session_duration)

    @property
    @pulumi.getter(name="allowUserToChangePassword")
    def allow_user_to_change_password(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether RAM users can change their passwords. Valid values: `true` and `false`
        """
        return pulumi.get(self, "allow_user_to_change_password")

    @allow_user_to_change_password.setter
    def allow_user_to_change_password(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_user_to_change_password", value)

    @property
    @pulumi.getter(name="allowUserToManageAccessKeys")
    def allow_user_to_manage_access_keys(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether RAM users can manage their AccessKey pairs. Valid values: `true` and `false`
        """
        return pulumi.get(self, "allow_user_to_manage_access_keys")

    @allow_user_to_manage_access_keys.setter
    def allow_user_to_manage_access_keys(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_user_to_manage_access_keys", value)

    @property
    @pulumi.getter(name="allowUserToManageMfaDevices")
    def allow_user_to_manage_mfa_devices(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether RAM users can manage their MFA devices. Valid values: `true` and `false`
        """
        return pulumi.get(self, "allow_user_to_manage_mfa_devices")

    @allow_user_to_manage_mfa_devices.setter
    def allow_user_to_manage_mfa_devices(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_user_to_manage_mfa_devices", value)

    @property
    @pulumi.getter(name="enableSaveMfaTicket")
    def enable_save_mfa_ticket(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to remember the MFA devices for seven days. Valid values: `true` and `false`
        """
        return pulumi.get(self, "enable_save_mfa_ticket")

    @enable_save_mfa_ticket.setter
    def enable_save_mfa_ticket(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_save_mfa_ticket", value)

    @property
    @pulumi.getter(name="enforceMfaForLogin")
    def enforce_mfa_for_login(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether MFA is required for all RAM users when they log on to the Alibaba Cloud Management Console by using usernames and passwords. Valid values: `true` and `false`
        """
        return pulumi.get(self, "enforce_mfa_for_login")

    @enforce_mfa_for_login.setter
    def enforce_mfa_for_login(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enforce_mfa_for_login", value)

    @property
    @pulumi.getter(name="loginNetworkMasks")
    def login_network_masks(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet mask that specifies the IP addresses from which you can log on to the Alibaba Cloud Management Console. This parameter takes effect on password-based logon and single sign-on (SSO). However, this parameter does not take effect on API calls that are authenticated by using AccessKey pairs.**NOTE:** You can specify up to 25 subnet masks. The total length of the subnet masks can be a maximum of 512 characters.
        * If you specify a subnet mask, RAM users can use only the IP addresses in the subnet mask to log on to the Alibaba Cloud Management Console.
        * If you do not specify a subnet mask, RAM users can use all IP addresses to log on to the Alibaba Cloud Management Console.
        * If you need to specify multiple subnet masks, separate the subnet masks with semicolons (;). Example: 192.168.0.0/16;10.0.0.0/8.
        """
        return pulumi.get(self, "login_network_masks")

    @login_network_masks.setter
    def login_network_masks(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "login_network_masks", value)

    @property
    @pulumi.getter(name="loginSessionDuration")
    def login_session_duration(self) -> Optional[pulumi.Input[int]]:
        """
        The validity period of the logon session of RAM users. Valid values: 6 to 24. Unit: hours. Default value: 6.
        """
        return pulumi.get(self, "login_session_duration")

    @login_session_duration.setter
    def login_session_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "login_session_duration", value)


@pulumi.input_type
class _SecurityPreferenceState:
    def __init__(__self__, *,
                 allow_user_to_change_password: Optional[pulumi.Input[bool]] = None,
                 allow_user_to_manage_access_keys: Optional[pulumi.Input[bool]] = None,
                 allow_user_to_manage_mfa_devices: Optional[pulumi.Input[bool]] = None,
                 enable_save_mfa_ticket: Optional[pulumi.Input[bool]] = None,
                 enforce_mfa_for_login: Optional[pulumi.Input[bool]] = None,
                 login_network_masks: Optional[pulumi.Input[str]] = None,
                 login_session_duration: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering SecurityPreference resources.
        :param pulumi.Input[bool] allow_user_to_change_password: Specifies whether RAM users can change their passwords. Valid values: `true` and `false`
        :param pulumi.Input[bool] allow_user_to_manage_access_keys: Specifies whether RAM users can manage their AccessKey pairs. Valid values: `true` and `false`
        :param pulumi.Input[bool] allow_user_to_manage_mfa_devices: Specifies whether RAM users can manage their MFA devices. Valid values: `true` and `false`
        :param pulumi.Input[bool] enable_save_mfa_ticket: Specifies whether to remember the MFA devices for seven days. Valid values: `true` and `false`
        :param pulumi.Input[bool] enforce_mfa_for_login: Specifies whether MFA is required for all RAM users when they log on to the Alibaba Cloud Management Console by using usernames and passwords. Valid values: `true` and `false`
        :param pulumi.Input[str] login_network_masks: The subnet mask that specifies the IP addresses from which you can log on to the Alibaba Cloud Management Console. This parameter takes effect on password-based logon and single sign-on (SSO). However, this parameter does not take effect on API calls that are authenticated by using AccessKey pairs.**NOTE:** You can specify up to 25 subnet masks. The total length of the subnet masks can be a maximum of 512 characters.
               * If you specify a subnet mask, RAM users can use only the IP addresses in the subnet mask to log on to the Alibaba Cloud Management Console.
               * If you do not specify a subnet mask, RAM users can use all IP addresses to log on to the Alibaba Cloud Management Console.
               * If you need to specify multiple subnet masks, separate the subnet masks with semicolons (;). Example: 192.168.0.0/16;10.0.0.0/8.
        :param pulumi.Input[int] login_session_duration: The validity period of the logon session of RAM users. Valid values: 6 to 24. Unit: hours. Default value: 6.
        """
        if allow_user_to_change_password is not None:
            pulumi.set(__self__, "allow_user_to_change_password", allow_user_to_change_password)
        if allow_user_to_manage_access_keys is not None:
            pulumi.set(__self__, "allow_user_to_manage_access_keys", allow_user_to_manage_access_keys)
        if allow_user_to_manage_mfa_devices is not None:
            pulumi.set(__self__, "allow_user_to_manage_mfa_devices", allow_user_to_manage_mfa_devices)
        if enable_save_mfa_ticket is not None:
            pulumi.set(__self__, "enable_save_mfa_ticket", enable_save_mfa_ticket)
        if enforce_mfa_for_login is not None:
            pulumi.set(__self__, "enforce_mfa_for_login", enforce_mfa_for_login)
        if login_network_masks is not None:
            pulumi.set(__self__, "login_network_masks", login_network_masks)
        if login_session_duration is not None:
            pulumi.set(__self__, "login_session_duration", login_session_duration)

    @property
    @pulumi.getter(name="allowUserToChangePassword")
    def allow_user_to_change_password(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether RAM users can change their passwords. Valid values: `true` and `false`
        """
        return pulumi.get(self, "allow_user_to_change_password")

    @allow_user_to_change_password.setter
    def allow_user_to_change_password(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_user_to_change_password", value)

    @property
    @pulumi.getter(name="allowUserToManageAccessKeys")
    def allow_user_to_manage_access_keys(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether RAM users can manage their AccessKey pairs. Valid values: `true` and `false`
        """
        return pulumi.get(self, "allow_user_to_manage_access_keys")

    @allow_user_to_manage_access_keys.setter
    def allow_user_to_manage_access_keys(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_user_to_manage_access_keys", value)

    @property
    @pulumi.getter(name="allowUserToManageMfaDevices")
    def allow_user_to_manage_mfa_devices(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether RAM users can manage their MFA devices. Valid values: `true` and `false`
        """
        return pulumi.get(self, "allow_user_to_manage_mfa_devices")

    @allow_user_to_manage_mfa_devices.setter
    def allow_user_to_manage_mfa_devices(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_user_to_manage_mfa_devices", value)

    @property
    @pulumi.getter(name="enableSaveMfaTicket")
    def enable_save_mfa_ticket(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to remember the MFA devices for seven days. Valid values: `true` and `false`
        """
        return pulumi.get(self, "enable_save_mfa_ticket")

    @enable_save_mfa_ticket.setter
    def enable_save_mfa_ticket(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_save_mfa_ticket", value)

    @property
    @pulumi.getter(name="enforceMfaForLogin")
    def enforce_mfa_for_login(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether MFA is required for all RAM users when they log on to the Alibaba Cloud Management Console by using usernames and passwords. Valid values: `true` and `false`
        """
        return pulumi.get(self, "enforce_mfa_for_login")

    @enforce_mfa_for_login.setter
    def enforce_mfa_for_login(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enforce_mfa_for_login", value)

    @property
    @pulumi.getter(name="loginNetworkMasks")
    def login_network_masks(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet mask that specifies the IP addresses from which you can log on to the Alibaba Cloud Management Console. This parameter takes effect on password-based logon and single sign-on (SSO). However, this parameter does not take effect on API calls that are authenticated by using AccessKey pairs.**NOTE:** You can specify up to 25 subnet masks. The total length of the subnet masks can be a maximum of 512 characters.
        * If you specify a subnet mask, RAM users can use only the IP addresses in the subnet mask to log on to the Alibaba Cloud Management Console.
        * If you do not specify a subnet mask, RAM users can use all IP addresses to log on to the Alibaba Cloud Management Console.
        * If you need to specify multiple subnet masks, separate the subnet masks with semicolons (;). Example: 192.168.0.0/16;10.0.0.0/8.
        """
        return pulumi.get(self, "login_network_masks")

    @login_network_masks.setter
    def login_network_masks(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "login_network_masks", value)

    @property
    @pulumi.getter(name="loginSessionDuration")
    def login_session_duration(self) -> Optional[pulumi.Input[int]]:
        """
        The validity period of the logon session of RAM users. Valid values: 6 to 24. Unit: hours. Default value: 6.
        """
        return pulumi.get(self, "login_session_duration")

    @login_session_duration.setter
    def login_session_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "login_session_duration", value)


class SecurityPreference(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_user_to_change_password: Optional[pulumi.Input[bool]] = None,
                 allow_user_to_manage_access_keys: Optional[pulumi.Input[bool]] = None,
                 allow_user_to_manage_mfa_devices: Optional[pulumi.Input[bool]] = None,
                 enable_save_mfa_ticket: Optional[pulumi.Input[bool]] = None,
                 enforce_mfa_for_login: Optional[pulumi.Input[bool]] = None,
                 login_network_masks: Optional[pulumi.Input[str]] = None,
                 login_session_duration: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a RAM Security Preference resource.

        For information about RAM Security Preference and how to use it, see [What is Security Preference](https://www.alibabacloud.com/help/en/doc-detail/186694.htm).

        > **NOTE:** Available since v1.152.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.ram.SecurityPreference("example",
            allow_user_to_change_password=True,
            enable_save_mfa_ticket=False)
        ```

        ## Import

        RAM Security Preference can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ram/securityPreference:SecurityPreference example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_user_to_change_password: Specifies whether RAM users can change their passwords. Valid values: `true` and `false`
        :param pulumi.Input[bool] allow_user_to_manage_access_keys: Specifies whether RAM users can manage their AccessKey pairs. Valid values: `true` and `false`
        :param pulumi.Input[bool] allow_user_to_manage_mfa_devices: Specifies whether RAM users can manage their MFA devices. Valid values: `true` and `false`
        :param pulumi.Input[bool] enable_save_mfa_ticket: Specifies whether to remember the MFA devices for seven days. Valid values: `true` and `false`
        :param pulumi.Input[bool] enforce_mfa_for_login: Specifies whether MFA is required for all RAM users when they log on to the Alibaba Cloud Management Console by using usernames and passwords. Valid values: `true` and `false`
        :param pulumi.Input[str] login_network_masks: The subnet mask that specifies the IP addresses from which you can log on to the Alibaba Cloud Management Console. This parameter takes effect on password-based logon and single sign-on (SSO). However, this parameter does not take effect on API calls that are authenticated by using AccessKey pairs.**NOTE:** You can specify up to 25 subnet masks. The total length of the subnet masks can be a maximum of 512 characters.
               * If you specify a subnet mask, RAM users can use only the IP addresses in the subnet mask to log on to the Alibaba Cloud Management Console.
               * If you do not specify a subnet mask, RAM users can use all IP addresses to log on to the Alibaba Cloud Management Console.
               * If you need to specify multiple subnet masks, separate the subnet masks with semicolons (;). Example: 192.168.0.0/16;10.0.0.0/8.
        :param pulumi.Input[int] login_session_duration: The validity period of the logon session of RAM users. Valid values: 6 to 24. Unit: hours. Default value: 6.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SecurityPreferenceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a RAM Security Preference resource.

        For information about RAM Security Preference and how to use it, see [What is Security Preference](https://www.alibabacloud.com/help/en/doc-detail/186694.htm).

        > **NOTE:** Available since v1.152.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.ram.SecurityPreference("example",
            allow_user_to_change_password=True,
            enable_save_mfa_ticket=False)
        ```

        ## Import

        RAM Security Preference can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ram/securityPreference:SecurityPreference example <id>
        ```

        :param str resource_name: The name of the resource.
        :param SecurityPreferenceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityPreferenceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_user_to_change_password: Optional[pulumi.Input[bool]] = None,
                 allow_user_to_manage_access_keys: Optional[pulumi.Input[bool]] = None,
                 allow_user_to_manage_mfa_devices: Optional[pulumi.Input[bool]] = None,
                 enable_save_mfa_ticket: Optional[pulumi.Input[bool]] = None,
                 enforce_mfa_for_login: Optional[pulumi.Input[bool]] = None,
                 login_network_masks: Optional[pulumi.Input[str]] = None,
                 login_session_duration: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityPreferenceArgs.__new__(SecurityPreferenceArgs)

            __props__.__dict__["allow_user_to_change_password"] = allow_user_to_change_password
            __props__.__dict__["allow_user_to_manage_access_keys"] = allow_user_to_manage_access_keys
            __props__.__dict__["allow_user_to_manage_mfa_devices"] = allow_user_to_manage_mfa_devices
            __props__.__dict__["enable_save_mfa_ticket"] = enable_save_mfa_ticket
            __props__.__dict__["enforce_mfa_for_login"] = enforce_mfa_for_login
            __props__.__dict__["login_network_masks"] = login_network_masks
            __props__.__dict__["login_session_duration"] = login_session_duration
        super(SecurityPreference, __self__).__init__(
            'alicloud:ram/securityPreference:SecurityPreference',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_user_to_change_password: Optional[pulumi.Input[bool]] = None,
            allow_user_to_manage_access_keys: Optional[pulumi.Input[bool]] = None,
            allow_user_to_manage_mfa_devices: Optional[pulumi.Input[bool]] = None,
            enable_save_mfa_ticket: Optional[pulumi.Input[bool]] = None,
            enforce_mfa_for_login: Optional[pulumi.Input[bool]] = None,
            login_network_masks: Optional[pulumi.Input[str]] = None,
            login_session_duration: Optional[pulumi.Input[int]] = None) -> 'SecurityPreference':
        """
        Get an existing SecurityPreference resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_user_to_change_password: Specifies whether RAM users can change their passwords. Valid values: `true` and `false`
        :param pulumi.Input[bool] allow_user_to_manage_access_keys: Specifies whether RAM users can manage their AccessKey pairs. Valid values: `true` and `false`
        :param pulumi.Input[bool] allow_user_to_manage_mfa_devices: Specifies whether RAM users can manage their MFA devices. Valid values: `true` and `false`
        :param pulumi.Input[bool] enable_save_mfa_ticket: Specifies whether to remember the MFA devices for seven days. Valid values: `true` and `false`
        :param pulumi.Input[bool] enforce_mfa_for_login: Specifies whether MFA is required for all RAM users when they log on to the Alibaba Cloud Management Console by using usernames and passwords. Valid values: `true` and `false`
        :param pulumi.Input[str] login_network_masks: The subnet mask that specifies the IP addresses from which you can log on to the Alibaba Cloud Management Console. This parameter takes effect on password-based logon and single sign-on (SSO). However, this parameter does not take effect on API calls that are authenticated by using AccessKey pairs.**NOTE:** You can specify up to 25 subnet masks. The total length of the subnet masks can be a maximum of 512 characters.
               * If you specify a subnet mask, RAM users can use only the IP addresses in the subnet mask to log on to the Alibaba Cloud Management Console.
               * If you do not specify a subnet mask, RAM users can use all IP addresses to log on to the Alibaba Cloud Management Console.
               * If you need to specify multiple subnet masks, separate the subnet masks with semicolons (;). Example: 192.168.0.0/16;10.0.0.0/8.
        :param pulumi.Input[int] login_session_duration: The validity period of the logon session of RAM users. Valid values: 6 to 24. Unit: hours. Default value: 6.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityPreferenceState.__new__(_SecurityPreferenceState)

        __props__.__dict__["allow_user_to_change_password"] = allow_user_to_change_password
        __props__.__dict__["allow_user_to_manage_access_keys"] = allow_user_to_manage_access_keys
        __props__.__dict__["allow_user_to_manage_mfa_devices"] = allow_user_to_manage_mfa_devices
        __props__.__dict__["enable_save_mfa_ticket"] = enable_save_mfa_ticket
        __props__.__dict__["enforce_mfa_for_login"] = enforce_mfa_for_login
        __props__.__dict__["login_network_masks"] = login_network_masks
        __props__.__dict__["login_session_duration"] = login_session_duration
        return SecurityPreference(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowUserToChangePassword")
    def allow_user_to_change_password(self) -> pulumi.Output[bool]:
        """
        Specifies whether RAM users can change their passwords. Valid values: `true` and `false`
        """
        return pulumi.get(self, "allow_user_to_change_password")

    @property
    @pulumi.getter(name="allowUserToManageAccessKeys")
    def allow_user_to_manage_access_keys(self) -> pulumi.Output[bool]:
        """
        Specifies whether RAM users can manage their AccessKey pairs. Valid values: `true` and `false`
        """
        return pulumi.get(self, "allow_user_to_manage_access_keys")

    @property
    @pulumi.getter(name="allowUserToManageMfaDevices")
    def allow_user_to_manage_mfa_devices(self) -> pulumi.Output[bool]:
        """
        Specifies whether RAM users can manage their MFA devices. Valid values: `true` and `false`
        """
        return pulumi.get(self, "allow_user_to_manage_mfa_devices")

    @property
    @pulumi.getter(name="enableSaveMfaTicket")
    def enable_save_mfa_ticket(self) -> pulumi.Output[bool]:
        """
        Specifies whether to remember the MFA devices for seven days. Valid values: `true` and `false`
        """
        return pulumi.get(self, "enable_save_mfa_ticket")

    @property
    @pulumi.getter(name="enforceMfaForLogin")
    def enforce_mfa_for_login(self) -> pulumi.Output[bool]:
        """
        Specifies whether MFA is required for all RAM users when they log on to the Alibaba Cloud Management Console by using usernames and passwords. Valid values: `true` and `false`
        """
        return pulumi.get(self, "enforce_mfa_for_login")

    @property
    @pulumi.getter(name="loginNetworkMasks")
    def login_network_masks(self) -> pulumi.Output[Optional[str]]:
        """
        The subnet mask that specifies the IP addresses from which you can log on to the Alibaba Cloud Management Console. This parameter takes effect on password-based logon and single sign-on (SSO). However, this parameter does not take effect on API calls that are authenticated by using AccessKey pairs.**NOTE:** You can specify up to 25 subnet masks. The total length of the subnet masks can be a maximum of 512 characters.
        * If you specify a subnet mask, RAM users can use only the IP addresses in the subnet mask to log on to the Alibaba Cloud Management Console.
        * If you do not specify a subnet mask, RAM users can use all IP addresses to log on to the Alibaba Cloud Management Console.
        * If you need to specify multiple subnet masks, separate the subnet masks with semicolons (;). Example: 192.168.0.0/16;10.0.0.0/8.
        """
        return pulumi.get(self, "login_network_masks")

    @property
    @pulumi.getter(name="loginSessionDuration")
    def login_session_duration(self) -> pulumi.Output[int]:
        """
        The validity period of the logon session of RAM users. Valid values: 6 to 24. Unit: hours. Default value: 6.
        """
        return pulumi.get(self, "login_session_duration")

