# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['OrganizationArgs', 'Organization']

@pulumi.input_type
class OrganizationArgs:
    def __init__(__self__, *,
                 organization_name: pulumi.Input[str],
                 source: pulumi.Input[str],
                 desired_member_count: Optional[pulumi.Input[int]] = None,
                 real_pk: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Organization resource.
        :param pulumi.Input[str] organization_name: Company name.
        :param pulumi.Input[str] source: This is organization source information
        :param pulumi.Input[int] desired_member_count: The desired member count.
        :param pulumi.Input[str] real_pk: User pk, not required, only required when the ak used by the calling interface is inconsistent with the user pk
        """
        pulumi.set(__self__, "organization_name", organization_name)
        pulumi.set(__self__, "source", source)
        if desired_member_count is not None:
            pulumi.set(__self__, "desired_member_count", desired_member_count)
        if real_pk is not None:
            pulumi.set(__self__, "real_pk", real_pk)

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> pulumi.Input[str]:
        """
        Company name.
        """
        return pulumi.get(self, "organization_name")

    @organization_name.setter
    def organization_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization_name", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        This is organization source information
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="desiredMemberCount")
    def desired_member_count(self) -> Optional[pulumi.Input[int]]:
        """
        The desired member count.
        """
        return pulumi.get(self, "desired_member_count")

    @desired_member_count.setter
    def desired_member_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_member_count", value)

    @property
    @pulumi.getter(name="realPk")
    def real_pk(self) -> Optional[pulumi.Input[str]]:
        """
        User pk, not required, only required when the ak used by the calling interface is inconsistent with the user pk
        """
        return pulumi.get(self, "real_pk")

    @real_pk.setter
    def real_pk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "real_pk", value)


@pulumi.input_type
class _OrganizationState:
    def __init__(__self__, *,
                 desired_member_count: Optional[pulumi.Input[int]] = None,
                 organization_name: Optional[pulumi.Input[str]] = None,
                 real_pk: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Organization resources.
        :param pulumi.Input[int] desired_member_count: The desired member count.
        :param pulumi.Input[str] organization_name: Company name.
        :param pulumi.Input[str] real_pk: User pk, not required, only required when the ak used by the calling interface is inconsistent with the user pk
        :param pulumi.Input[str] source: This is organization source information
        """
        if desired_member_count is not None:
            pulumi.set(__self__, "desired_member_count", desired_member_count)
        if organization_name is not None:
            pulumi.set(__self__, "organization_name", organization_name)
        if real_pk is not None:
            pulumi.set(__self__, "real_pk", real_pk)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="desiredMemberCount")
    def desired_member_count(self) -> Optional[pulumi.Input[int]]:
        """
        The desired member count.
        """
        return pulumi.get(self, "desired_member_count")

    @desired_member_count.setter
    def desired_member_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_member_count", value)

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[pulumi.Input[str]]:
        """
        Company name.
        """
        return pulumi.get(self, "organization_name")

    @organization_name.setter
    def organization_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_name", value)

    @property
    @pulumi.getter(name="realPk")
    def real_pk(self) -> Optional[pulumi.Input[str]]:
        """
        User pk, not required, only required when the ak used by the calling interface is inconsistent with the user pk
        """
        return pulumi.get(self, "real_pk")

    @real_pk.setter
    def real_pk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "real_pk", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        This is organization source information
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)


class Organization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 desired_member_count: Optional[pulumi.Input[int]] = None,
                 organization_name: Optional[pulumi.Input[str]] = None,
                 real_pk: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a RDC Organization resource.

        For information about RDC Organization and how to use it, see [What is Organization](https://help.aliyun.com/product/51588.html).

        > **NOTE:** Available in v1.137.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.rdc.Organization("example",
            organization_name="example_value",
            source="example_value")
        ```

        ## Import

        RDC Organization can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:rdc/organization:Organization example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] desired_member_count: The desired member count.
        :param pulumi.Input[str] organization_name: Company name.
        :param pulumi.Input[str] real_pk: User pk, not required, only required when the ak used by the calling interface is inconsistent with the user pk
        :param pulumi.Input[str] source: This is organization source information
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a RDC Organization resource.

        For information about RDC Organization and how to use it, see [What is Organization](https://help.aliyun.com/product/51588.html).

        > **NOTE:** Available in v1.137.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.rdc.Organization("example",
            organization_name="example_value",
            source="example_value")
        ```

        ## Import

        RDC Organization can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:rdc/organization:Organization example <id>
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 desired_member_count: Optional[pulumi.Input[int]] = None,
                 organization_name: Optional[pulumi.Input[str]] = None,
                 real_pk: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationArgs.__new__(OrganizationArgs)

            __props__.__dict__["desired_member_count"] = desired_member_count
            if organization_name is None and not opts.urn:
                raise TypeError("Missing required property 'organization_name'")
            __props__.__dict__["organization_name"] = organization_name
            __props__.__dict__["real_pk"] = real_pk
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
        super(Organization, __self__).__init__(
            'alicloud:rdc/organization:Organization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            desired_member_count: Optional[pulumi.Input[int]] = None,
            organization_name: Optional[pulumi.Input[str]] = None,
            real_pk: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[str]] = None) -> 'Organization':
        """
        Get an existing Organization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] desired_member_count: The desired member count.
        :param pulumi.Input[str] organization_name: Company name.
        :param pulumi.Input[str] real_pk: User pk, not required, only required when the ak used by the calling interface is inconsistent with the user pk
        :param pulumi.Input[str] source: This is organization source information
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationState.__new__(_OrganizationState)

        __props__.__dict__["desired_member_count"] = desired_member_count
        __props__.__dict__["organization_name"] = organization_name
        __props__.__dict__["real_pk"] = real_pk
        __props__.__dict__["source"] = source
        return Organization(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="desiredMemberCount")
    def desired_member_count(self) -> pulumi.Output[Optional[int]]:
        """
        The desired member count.
        """
        return pulumi.get(self, "desired_member_count")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> pulumi.Output[str]:
        """
        Company name.
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="realPk")
    def real_pk(self) -> pulumi.Output[Optional[str]]:
        """
        User pk, not required, only required when the ak used by the calling interface is inconsistent with the user pk
        """
        return pulumi.get(self, "real_pk")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[str]:
        """
        This is organization source information
        """
        return pulumi.get(self, "source")

