# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DbInstanceEndpointNodeItemArgs',
    'DdrInstanceParameterArgs',
    'DdrInstancePgHbaConfArgs',
    'InstanceBabelfishConfigArgs',
    'InstanceParameterArgs',
    'InstancePgHbaConfArgs',
    'InstanceServerlessConfigArgs',
    'RdsCloneDbInstanceParameterArgs',
    'RdsCloneDbInstancePgHbaConfArgs',
    'RdsCloneDbInstanceServerlessConfigArgs',
    'RdsDbProxyReadOnlyInstanceWeightArgs',
    'RdsParameterGroupParamDetailArgs',
    'RdsUpgradeDbInstanceParameterArgs',
    'RdsUpgradeDbInstancePgHbaConfArgs',
    'ReadOnlyInstanceParameterArgs',
    'GetCollationTimeZonesCollationTimeZoneArgs',
    'GetInstanceClassInfosInfoArgs',
]

@pulumi.input_type
class DbInstanceEndpointNodeItemArgs:
    def __init__(__self__, *,
                 node_id: pulumi.Input[str],
                 weight: pulumi.Input[int]):
        """
        :param pulumi.Input[str] node_id: The ID of the node.
        :param pulumi.Input[int] weight: The weight of the node. Read requests are distributed based on the weight.Valid values: 0 to 100.
        """
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> pulumi.Input[str]:
        """
        The ID of the node.
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_id", value)

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Input[int]:
        """
        The weight of the node. Read requests are distributed based on the weight.Valid values: 0 to 100.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: pulumi.Input[int]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class DdrInstanceParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The parameter name.
        :param pulumi.Input[str] value: The parameter value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The parameter value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class DdrInstancePgHbaConfArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 database: pulumi.Input[str],
                 method: pulumi.Input[str],
                 priority_id: pulumi.Input[int],
                 type: pulumi.Input[str],
                 user: pulumi.Input[str],
                 mask: Optional[pulumi.Input[str]] = None,
                 option: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        :param pulumi.Input[str] database: The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        :param pulumi.Input[str] method: The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        :param pulumi.Input[int] priority_id: The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        :param pulumi.Input[str] type: The type of connection to the instance. Valid values:
               * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
               * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
               * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.
               
               > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        :param pulumi.Input[str] user: The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        :param pulumi.Input[str] mask: The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        :param pulumi.Input[str] option: Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "priority_id", priority_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user", user)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)
        if option is not None:
            pulumi.set(__self__, "option", option)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[str]:
        """
        The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def method(self) -> pulumi.Input[str]:
        """
        The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: pulumi.Input[str]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter(name="priorityId")
    def priority_id(self) -> pulumi.Input[int]:
        """
        The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        """
        return pulumi.get(self, "priority_id")

    @priority_id.setter
    def priority_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of connection to the instance. Valid values:
        * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
        * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
        * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.

        > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[str]:
        """
        The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[str]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter
    def mask(self) -> Optional[pulumi.Input[str]]:
        """
        The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        """
        return pulumi.get(self, "mask")

    @mask.setter
    def mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mask", value)

    @property
    @pulumi.getter
    def option(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        return pulumi.get(self, "option")

    @option.setter
    def option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "option", value)


@pulumi.input_type
class InstanceBabelfishConfigArgs:
    def __init__(__self__, *,
                 babelfish_enabled: pulumi.Input[str],
                 master_user_password: pulumi.Input[str],
                 master_username: pulumi.Input[str],
                 migration_mode: pulumi.Input[str]):
        """
        :param pulumi.Input[str] babelfish_enabled: specifies whether to enable the Babelfish for the instance. If you set this parameter to **true**, you enable Babelfish for the instance. If you leave this parameter empty, you disable Babelfish for the instance.
        :param pulumi.Input[str] master_user_password: The password of the administrator account. The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. It must be 8 to 32 characters in length. The password can contain any of the following characters:! @ # $ % ^ & * () _ + - =
        :param pulumi.Input[str] master_username: The name of the administrator account. The name can contain lowercase letters, digits, and underscores (_). It must start with a letter and end with a letter or digit. It can be up to 63 characters in length and cannot start with pg.
        :param pulumi.Input[str] migration_mode: The migration mode of the instance. Valid values: **single-db** and **multi-db**.
        """
        pulumi.set(__self__, "babelfish_enabled", babelfish_enabled)
        pulumi.set(__self__, "master_user_password", master_user_password)
        pulumi.set(__self__, "master_username", master_username)
        pulumi.set(__self__, "migration_mode", migration_mode)

    @property
    @pulumi.getter(name="babelfishEnabled")
    def babelfish_enabled(self) -> pulumi.Input[str]:
        """
        specifies whether to enable the Babelfish for the instance. If you set this parameter to **true**, you enable Babelfish for the instance. If you leave this parameter empty, you disable Babelfish for the instance.
        """
        return pulumi.get(self, "babelfish_enabled")

    @babelfish_enabled.setter
    def babelfish_enabled(self, value: pulumi.Input[str]):
        pulumi.set(self, "babelfish_enabled", value)

    @property
    @pulumi.getter(name="masterUserPassword")
    def master_user_password(self) -> pulumi.Input[str]:
        """
        The password of the administrator account. The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. It must be 8 to 32 characters in length. The password can contain any of the following characters:! @ # $ % ^ & * () _ + - =
        """
        return pulumi.get(self, "master_user_password")

    @master_user_password.setter
    def master_user_password(self, value: pulumi.Input[str]):
        pulumi.set(self, "master_user_password", value)

    @property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> pulumi.Input[str]:
        """
        The name of the administrator account. The name can contain lowercase letters, digits, and underscores (_). It must start with a letter and end with a letter or digit. It can be up to 63 characters in length and cannot start with pg.
        """
        return pulumi.get(self, "master_username")

    @master_username.setter
    def master_username(self, value: pulumi.Input[str]):
        pulumi.set(self, "master_username", value)

    @property
    @pulumi.getter(name="migrationMode")
    def migration_mode(self) -> pulumi.Input[str]:
        """
        The migration mode of the instance. Valid values: **single-db** and **multi-db**.
        """
        return pulumi.get(self, "migration_mode")

    @migration_mode.setter
    def migration_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "migration_mode", value)


@pulumi.input_type
class InstanceParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The parameter name.
        :param pulumi.Input[str] value: The parameter value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The parameter value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class InstancePgHbaConfArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 database: pulumi.Input[str],
                 method: pulumi.Input[str],
                 priority_id: pulumi.Input[int],
                 type: pulumi.Input[str],
                 user: pulumi.Input[str],
                 mask: Optional[pulumi.Input[str]] = None,
                 option: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        :param pulumi.Input[str] database: The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        :param pulumi.Input[str] method: The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        :param pulumi.Input[int] priority_id: The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        :param pulumi.Input[str] type: The type of connection to the instance. Valid values:
               * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
               * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
               * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.
               
               > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        :param pulumi.Input[str] user: The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        :param pulumi.Input[str] mask: The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        :param pulumi.Input[str] option: Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "priority_id", priority_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user", user)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)
        if option is not None:
            pulumi.set(__self__, "option", option)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[str]:
        """
        The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def method(self) -> pulumi.Input[str]:
        """
        The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: pulumi.Input[str]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter(name="priorityId")
    def priority_id(self) -> pulumi.Input[int]:
        """
        The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        """
        return pulumi.get(self, "priority_id")

    @priority_id.setter
    def priority_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of connection to the instance. Valid values:
        * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
        * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
        * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.

        > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[str]:
        """
        The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[str]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter
    def mask(self) -> Optional[pulumi.Input[str]]:
        """
        The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        """
        return pulumi.get(self, "mask")

    @mask.setter
    def mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mask", value)

    @property
    @pulumi.getter
    def option(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        return pulumi.get(self, "option")

    @option.setter
    def option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "option", value)


@pulumi.input_type
class InstanceServerlessConfigArgs:
    def __init__(__self__, *,
                 max_capacity: pulumi.Input[float],
                 min_capacity: pulumi.Input[float],
                 auto_pause: Optional[pulumi.Input[bool]] = None,
                 switch_force: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[float] max_capacity: The maximum number of RDS Capacity Units (RCUs). The value of this parameter must be greater than or equal to `min_capacity` and only supports passing integers. Valid values:
               - MySQL: 1~8
               - SQLServer: 2~8
               - PostgreSQL: 1~12
        :param pulumi.Input[float] min_capacity: The minimum number of RCUs. The value of this parameter must be less than or equal to `max_capacity`. Valid values:
               - MySQL: 0.5~8
               - SQLServer: 2~8 \\(Supports integers only\\).
               - PostgreSQL: 0.5~12
        :param pulumi.Input[bool] auto_pause: Specifies whether to enable the smart startup and stop feature for the serverless instance. Valid values:
               - true: enables the feature.
               - false: disables the feature. This is the default value.
               > - Only MySQL Serverless instances need to set this parameter. If there is no connection within 10 minutes, it will enter a paused state and automatically wake up when the connection enters.
        :param pulumi.Input[bool] switch_force: Specifies whether to enable the forced scaling feature for the serverless instance. Valid values:
               - true: enables the feature.
               - false: disables the feature. This is the default value.
               > - Only MySQL Serverless instances need to set this parameter. After enabling this parameter, there will be a flash break within 1 minute when the instance is forced to expand or shrink. Please use it with caution according to the actual situation.
               > - The elastic scaling of an instance RCU usually takes effect immediately, but in some special circumstances (such as during large transaction execution), it is not possible to complete scaling immediately. In this case, this parameter can be enabled to force scaling.
        """
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "min_capacity", min_capacity)
        if auto_pause is not None:
            pulumi.set(__self__, "auto_pause", auto_pause)
        if switch_force is not None:
            pulumi.set(__self__, "switch_force", switch_force)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> pulumi.Input[float]:
        """
        The maximum number of RDS Capacity Units (RCUs). The value of this parameter must be greater than or equal to `min_capacity` and only supports passing integers. Valid values:
        - MySQL: 1~8
        - SQLServer: 2~8
        - PostgreSQL: 1~12
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: pulumi.Input[float]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> pulumi.Input[float]:
        """
        The minimum number of RCUs. The value of this parameter must be less than or equal to `max_capacity`. Valid values:
        - MySQL: 0.5~8
        - SQLServer: 2~8 \\(Supports integers only\\).
        - PostgreSQL: 0.5~12
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: pulumi.Input[float]):
        pulumi.set(self, "min_capacity", value)

    @property
    @pulumi.getter(name="autoPause")
    def auto_pause(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the smart startup and stop feature for the serverless instance. Valid values:
        - true: enables the feature.
        - false: disables the feature. This is the default value.
        > - Only MySQL Serverless instances need to set this parameter. If there is no connection within 10 minutes, it will enter a paused state and automatically wake up when the connection enters.
        """
        return pulumi.get(self, "auto_pause")

    @auto_pause.setter
    def auto_pause(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_pause", value)

    @property
    @pulumi.getter(name="switchForce")
    def switch_force(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the forced scaling feature for the serverless instance. Valid values:
        - true: enables the feature.
        - false: disables the feature. This is the default value.
        > - Only MySQL Serverless instances need to set this parameter. After enabling this parameter, there will be a flash break within 1 minute when the instance is forced to expand or shrink. Please use it with caution according to the actual situation.
        > - The elastic scaling of an instance RCU usually takes effect immediately, but in some special circumstances (such as during large transaction execution), it is not possible to complete scaling immediately. In this case, this parameter can be enabled to force scaling.
        """
        return pulumi.get(self, "switch_force")

    @switch_force.setter
    def switch_force(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "switch_force", value)


@pulumi.input_type
class RdsCloneDbInstanceParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The parameters name.
        :param pulumi.Input[str] value: The parameters value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The parameters name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The parameters value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class RdsCloneDbInstancePgHbaConfArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 database: pulumi.Input[str],
                 method: pulumi.Input[str],
                 priority_id: pulumi.Input[int],
                 type: pulumi.Input[str],
                 user: pulumi.Input[str],
                 mask: Optional[pulumi.Input[str]] = None,
                 option: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        :param pulumi.Input[str] database: The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        :param pulumi.Input[str] method: The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        :param pulumi.Input[int] priority_id: The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        :param pulumi.Input[str] type: The type of connection to the instance. Valid values:
               * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
               * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
               * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.
               
               > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        :param pulumi.Input[str] user: The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        :param pulumi.Input[str] mask: The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        :param pulumi.Input[str] option: Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "priority_id", priority_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user", user)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)
        if option is not None:
            pulumi.set(__self__, "option", option)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[str]:
        """
        The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def method(self) -> pulumi.Input[str]:
        """
        The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: pulumi.Input[str]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter(name="priorityId")
    def priority_id(self) -> pulumi.Input[int]:
        """
        The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        """
        return pulumi.get(self, "priority_id")

    @priority_id.setter
    def priority_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of connection to the instance. Valid values:
        * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
        * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
        * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.

        > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[str]:
        """
        The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[str]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter
    def mask(self) -> Optional[pulumi.Input[str]]:
        """
        The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        """
        return pulumi.get(self, "mask")

    @mask.setter
    def mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mask", value)

    @property
    @pulumi.getter
    def option(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        return pulumi.get(self, "option")

    @option.setter
    def option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "option", value)


@pulumi.input_type
class RdsCloneDbInstanceServerlessConfigArgs:
    def __init__(__self__, *,
                 max_capacity: pulumi.Input[float],
                 min_capacity: pulumi.Input[float],
                 auto_pause: Optional[pulumi.Input[bool]] = None,
                 switch_force: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[float] max_capacity: The maximum number of RDS Capacity Units (RCUs). The value of this parameter must be greater than or equal to `min_capacity` and only supports passing integers. Valid values:
               - MySQL: 1~8
               - SQLServer: 2~8
               - PostgreSQL: 1~12
        :param pulumi.Input[float] min_capacity: The minimum number of RCUs. The value of this parameter must be less than or equal to `max_capacity`. Valid values:
               - MySQL: 0.5~8
               - SQLServer: 2~8 \\(Supports integers only\\).
               - PostgreSQL: 0.5~12
        :param pulumi.Input[bool] auto_pause: Specifies whether to enable the smart startup and stop feature for the serverless instance. Valid values:
               - true: enables the feature.
               - false: disables the feature. This is the default value.
               > - Only MySQL Serverless instances need to set this parameter. If there is no connection within 10 minutes, it will enter a paused state and automatically wake up when the connection enters.
        :param pulumi.Input[bool] switch_force: Specifies whether to enable the forced scaling feature for the serverless instance. Valid values:
               - true: enables the feature.
               - false: disables the feature. This is the default value.
               > - Only MySQL Serverless instances need to set this parameter. After enabling this parameter, there will be a flash break within 1 minute when the instance is forced to expand or shrink. Please use it with caution according to the actual situation.
               > - The elastic scaling of an instance RCU usually takes effect immediately, but in some special circumstances (such as during large transaction execution), it is not possible to complete scaling immediately. In this case, this parameter can be enabled to force scaling.
        """
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "min_capacity", min_capacity)
        if auto_pause is not None:
            pulumi.set(__self__, "auto_pause", auto_pause)
        if switch_force is not None:
            pulumi.set(__self__, "switch_force", switch_force)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> pulumi.Input[float]:
        """
        The maximum number of RDS Capacity Units (RCUs). The value of this parameter must be greater than or equal to `min_capacity` and only supports passing integers. Valid values:
        - MySQL: 1~8
        - SQLServer: 2~8
        - PostgreSQL: 1~12
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: pulumi.Input[float]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> pulumi.Input[float]:
        """
        The minimum number of RCUs. The value of this parameter must be less than or equal to `max_capacity`. Valid values:
        - MySQL: 0.5~8
        - SQLServer: 2~8 \\(Supports integers only\\).
        - PostgreSQL: 0.5~12
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: pulumi.Input[float]):
        pulumi.set(self, "min_capacity", value)

    @property
    @pulumi.getter(name="autoPause")
    def auto_pause(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the smart startup and stop feature for the serverless instance. Valid values:
        - true: enables the feature.
        - false: disables the feature. This is the default value.
        > - Only MySQL Serverless instances need to set this parameter. If there is no connection within 10 minutes, it will enter a paused state and automatically wake up when the connection enters.
        """
        return pulumi.get(self, "auto_pause")

    @auto_pause.setter
    def auto_pause(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_pause", value)

    @property
    @pulumi.getter(name="switchForce")
    def switch_force(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the forced scaling feature for the serverless instance. Valid values:
        - true: enables the feature.
        - false: disables the feature. This is the default value.
        > - Only MySQL Serverless instances need to set this parameter. After enabling this parameter, there will be a flash break within 1 minute when the instance is forced to expand or shrink. Please use it with caution according to the actual situation.
        > - The elastic scaling of an instance RCU usually takes effect immediately, but in some special circumstances (such as during large transaction execution), it is not possible to complete scaling immediately. In this case, this parameter can be enabled to force scaling.
        """
        return pulumi.get(self, "switch_force")

    @switch_force.setter
    def switch_force(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "switch_force", value)


@pulumi.input_type
class RdsDbProxyReadOnlyInstanceWeightArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[str],
                 weight: pulumi.Input[str]):
        """
        :param pulumi.Input[str] instance_id: The Id of the instance and its read-only instances that can run database.
        :param pulumi.Input[str] weight: Weight of instances that can run the database and their read-only instances. Read weights increase in increments of 100, and the maximum read weight is 10000.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The Id of the instance and its read-only instances that can run database.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Input[str]:
        """
        Weight of instances that can run the database and their read-only instances. Read weights increase in increments of 100, and the maximum read weight is 10000.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: pulumi.Input[str]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class RdsParameterGroupParamDetailArgs:
    def __init__(__self__, *,
                 param_name: pulumi.Input[str],
                 param_value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] param_name: The name of a parameter.
        :param pulumi.Input[str] param_value: The value of a parameter.
        """
        pulumi.set(__self__, "param_name", param_name)
        pulumi.set(__self__, "param_value", param_value)

    @property
    @pulumi.getter(name="paramName")
    def param_name(self) -> pulumi.Input[str]:
        """
        The name of a parameter.
        """
        return pulumi.get(self, "param_name")

    @param_name.setter
    def param_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "param_name", value)

    @property
    @pulumi.getter(name="paramValue")
    def param_value(self) -> pulumi.Input[str]:
        """
        The value of a parameter.
        """
        return pulumi.get(self, "param_value")

    @param_value.setter
    def param_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "param_value", value)


@pulumi.input_type
class RdsUpgradeDbInstanceParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The parameter name.
        :param pulumi.Input[str] value: The parameter value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The parameter value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class RdsUpgradeDbInstancePgHbaConfArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 database: pulumi.Input[str],
                 method: pulumi.Input[str],
                 priority_id: pulumi.Input[int],
                 type: pulumi.Input[str],
                 user: pulumi.Input[str],
                 mask: Optional[pulumi.Input[str]] = None,
                 option: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        :param pulumi.Input[str] database: The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        :param pulumi.Input[str] method: The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        :param pulumi.Input[int] priority_id: The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        :param pulumi.Input[str] type: The type of connection to the instance. Valid values:
               * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
               * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
               * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.
               
               > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        :param pulumi.Input[str] user: The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        :param pulumi.Input[str] mask: The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        :param pulumi.Input[str] option: Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "priority_id", priority_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user", user)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)
        if option is not None:
            pulumi.set(__self__, "option", option)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[str]:
        """
        The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def method(self) -> pulumi.Input[str]:
        """
        The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: pulumi.Input[str]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter(name="priorityId")
    def priority_id(self) -> pulumi.Input[int]:
        """
        The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        """
        return pulumi.get(self, "priority_id")

    @priority_id.setter
    def priority_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of connection to the instance. Valid values:
        * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
        * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
        * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.

        > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[str]:
        """
        The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[str]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter
    def mask(self) -> Optional[pulumi.Input[str]]:
        """
        The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        """
        return pulumi.get(self, "mask")

    @mask.setter
    def mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mask", value)

    @property
    @pulumi.getter
    def option(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        return pulumi.get(self, "option")

    @option.setter
    def option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "option", value)


@pulumi.input_type
class ReadOnlyInstanceParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The parameter name.
        :param pulumi.Input[str] value: The parameter value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The parameter value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GetCollationTimeZonesCollationTimeZoneArgs:
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 standard_time_offset: Optional[str] = None,
                 time_zone: Optional[str] = None):
        """
        :param str description: The code of the instance type.
        :param str standard_time_offset: The offset of the UTC time. The offset is in the following format: (UTC+<i>HH:mm</i>).
        :param str time_zone: The time zone that is available for use in ApsaraDB RDS.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if standard_time_offset is not None:
            pulumi.set(__self__, "standard_time_offset", standard_time_offset)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The code of the instance type.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="standardTimeOffset")
    def standard_time_offset(self) -> Optional[str]:
        """
        The offset of the UTC time. The offset is in the following format: (UTC+<i>HH:mm</i>).
        """
        return pulumi.get(self, "standard_time_offset")

    @standard_time_offset.setter
    def standard_time_offset(self, value: Optional[str]):
        pulumi.set(self, "standard_time_offset", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        The time zone that is available for use in ApsaraDB RDS.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[str]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class GetInstanceClassInfosInfoArgs:
    def __init__(__self__, *,
                 class_code: Optional[str] = None,
                 class_group: Optional[str] = None,
                 cpu: Optional[str] = None,
                 instruction_set_arch: Optional[str] = None,
                 max_connections: Optional[str] = None,
                 max_iombps: Optional[str] = None,
                 max_iops: Optional[str] = None,
                 memory_class: Optional[str] = None,
                 reference_price: Optional[str] = None):
        """
        :param str class_code: The code of the instance type.
        :param str class_group: The instance family of the instance.
        :param str cpu: The number of cores that are supported by the instance type. Unit: cores.
        :param str instruction_set_arch: The architecture of the instance type.
        :param str max_connections: The maximum number of connections that are supported by the instance type. Unit: connections.
        :param str max_iombps: The maximum I/O bandwidth that is supported by the instance type. Unit: Mbit/s.
        :param str max_iops: The maximum input/output operations per second (IOPS) that is supported by the instance type. Unit: operations per second.
        :param str memory_class: The memory capacity that is supported by the instance type. Unit: GB.
        :param str reference_price: The fee that you must pay for the instance type. Unit: cent (USD).
        """
        if class_code is not None:
            pulumi.set(__self__, "class_code", class_code)
        if class_group is not None:
            pulumi.set(__self__, "class_group", class_group)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if instruction_set_arch is not None:
            pulumi.set(__self__, "instruction_set_arch", instruction_set_arch)
        if max_connections is not None:
            pulumi.set(__self__, "max_connections", max_connections)
        if max_iombps is not None:
            pulumi.set(__self__, "max_iombps", max_iombps)
        if max_iops is not None:
            pulumi.set(__self__, "max_iops", max_iops)
        if memory_class is not None:
            pulumi.set(__self__, "memory_class", memory_class)
        if reference_price is not None:
            pulumi.set(__self__, "reference_price", reference_price)

    @property
    @pulumi.getter(name="classCode")
    def class_code(self) -> Optional[str]:
        """
        The code of the instance type.
        """
        return pulumi.get(self, "class_code")

    @class_code.setter
    def class_code(self, value: Optional[str]):
        pulumi.set(self, "class_code", value)

    @property
    @pulumi.getter(name="classGroup")
    def class_group(self) -> Optional[str]:
        """
        The instance family of the instance.
        """
        return pulumi.get(self, "class_group")

    @class_group.setter
    def class_group(self, value: Optional[str]):
        pulumi.set(self, "class_group", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[str]:
        """
        The number of cores that are supported by the instance type. Unit: cores.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[str]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="instructionSetArch")
    def instruction_set_arch(self) -> Optional[str]:
        """
        The architecture of the instance type.
        """
        return pulumi.get(self, "instruction_set_arch")

    @instruction_set_arch.setter
    def instruction_set_arch(self, value: Optional[str]):
        pulumi.set(self, "instruction_set_arch", value)

    @property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> Optional[str]:
        """
        The maximum number of connections that are supported by the instance type. Unit: connections.
        """
        return pulumi.get(self, "max_connections")

    @max_connections.setter
    def max_connections(self, value: Optional[str]):
        pulumi.set(self, "max_connections", value)

    @property
    @pulumi.getter(name="maxIombps")
    def max_iombps(self) -> Optional[str]:
        """
        The maximum I/O bandwidth that is supported by the instance type. Unit: Mbit/s.
        """
        return pulumi.get(self, "max_iombps")

    @max_iombps.setter
    def max_iombps(self, value: Optional[str]):
        pulumi.set(self, "max_iombps", value)

    @property
    @pulumi.getter(name="maxIops")
    def max_iops(self) -> Optional[str]:
        """
        The maximum input/output operations per second (IOPS) that is supported by the instance type. Unit: operations per second.
        """
        return pulumi.get(self, "max_iops")

    @max_iops.setter
    def max_iops(self, value: Optional[str]):
        pulumi.set(self, "max_iops", value)

    @property
    @pulumi.getter(name="memoryClass")
    def memory_class(self) -> Optional[str]:
        """
        The memory capacity that is supported by the instance type. Unit: GB.
        """
        return pulumi.get(self, "memory_class")

    @memory_class.setter
    def memory_class(self, value: Optional[str]):
        pulumi.set(self, "memory_class", value)

    @property
    @pulumi.getter(name="referencePrice")
    def reference_price(self) -> Optional[str]:
        """
        The fee that you must pay for the instance type. Unit: cent (USD).
        """
        return pulumi.get(self, "reference_price")

    @reference_price.setter
    def reference_price(self, value: Optional[str]):
        pulumi.set(self, "reference_price", value)


