# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DdrInstanceArgs', 'DdrInstance']

@pulumi.input_type
class DdrInstanceArgs:
    def __init__(__self__, *,
                 engine: pulumi.Input[str],
                 engine_version: pulumi.Input[str],
                 instance_storage: pulumi.Input[int],
                 instance_type: pulumi.Input[str],
                 payment_type: pulumi.Input[str],
                 restore_type: pulumi.Input[str],
                 acl: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 auto_upgrade_minor_version: Optional[pulumi.Input[str]] = None,
                 backup_set_id: Optional[pulumi.Input[str]] = None,
                 ca_type: Optional[pulumi.Input[str]] = None,
                 client_ca_cert: Optional[pulumi.Input[str]] = None,
                 client_ca_enabled: Optional[pulumi.Input[int]] = None,
                 client_cert_revocation_list: Optional[pulumi.Input[str]] = None,
                 client_crl_enabled: Optional[pulumi.Input[int]] = None,
                 connection_string_prefix: Optional[pulumi.Input[str]] = None,
                 db_instance_ip_array_attribute: Optional[pulumi.Input[str]] = None,
                 db_instance_ip_array_name: Optional[pulumi.Input[str]] = None,
                 db_instance_storage_type: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 effective_time: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[str]] = None,
                 force_restart: Optional[pulumi.Input[bool]] = None,
                 fresh_white_list_readins: Optional[pulumi.Input[str]] = None,
                 ha_config: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 maintain_time: Optional[pulumi.Input[str]] = None,
                 manual_ha_time: Optional[pulumi.Input[str]] = None,
                 modify_mode: Optional[pulumi.Input[str]] = None,
                 monitoring_period: Optional[pulumi.Input[int]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['DdrInstanceParameterArgs']]]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 pg_hba_confs: Optional[pulumi.Input[Sequence[pulumi.Input['DdrInstancePgHbaConfArgs']]]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 released_keep_policy: Optional[pulumi.Input[str]] = None,
                 replication_acl: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 restore_time: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_ip_mode: Optional[pulumi.Input[str]] = None,
                 security_ip_type: Optional[pulumi.Input[str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 server_cert: Optional[pulumi.Input[str]] = None,
                 server_key: Optional[pulumi.Input[str]] = None,
                 source_db_instance_name: Optional[pulumi.Input[str]] = None,
                 source_region: Optional[pulumi.Input[str]] = None,
                 sql_collector_config_value: Optional[pulumi.Input[int]] = None,
                 sql_collector_status: Optional[pulumi.Input[str]] = None,
                 ssl_action: Optional[pulumi.Input[str]] = None,
                 storage_auto_scale: Optional[pulumi.Input[str]] = None,
                 storage_threshold: Optional[pulumi.Input[int]] = None,
                 storage_upper_bound: Optional[pulumi.Input[int]] = None,
                 switch_time: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_minor_version: Optional[pulumi.Input[str]] = None,
                 tcp_connection_type: Optional[pulumi.Input[str]] = None,
                 tde_status: Optional[pulumi.Input[str]] = None,
                 upgrade_db_instance_kernel_version: Optional[pulumi.Input[bool]] = None,
                 upgrade_time: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 whitelist_network_type: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DdrInstance resource.
        :param pulumi.Input[str] engine: Database type. Value options: MySQL, SQLServer.
               
               > **NOTE:** When the 'EngineVersion' changes, it can be used as the target database version for the large version upgrade of RDS for MySQL instance.
        :param pulumi.Input[str] engine_version: Database version. Value options can refer to the latest docs [CreateDdrInstance](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/restore-data-to-a-new-instance-across-regions) `EngineVersion`.
        :param pulumi.Input[int] instance_storage: The storage capacity of the destination instance. Valid values: 5 to 2000. Unit: GB.
               
               This value must be a multiple of 5 GB. For more information, see Primary ApsaraDB RDS instance types.
        :param pulumi.Input[str] instance_type: DB Instance type.
               
               > **NOTE:** When `storage_auto_scale="Enable"`, do not perform `instance_storage` check. when `storage_auto_scale="Disable"`, if the instance itself `instance_storage`has changed. You need to manually revise the `instance_storage` in the template value.
        :param pulumi.Input[str] payment_type: Valid values are `Subscription`, `PayAsYouGo`, Default to `PayAsYouGo`.
        :param pulumi.Input[str] restore_type: The method that is used to restore data. Valid values:
               - BackupSet: Data is restored from a backup set. If you use this value, you must also specify the BackupSetID parameter.
               - BackupTime: restores data to a point in time. You must also specify the RestoreTime, SourceRegion, and SourceDBInstanceName parameters.
        :param pulumi.Input[str] acl: The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param pulumi.Input[bool] auto_renew: Whether to renewal a DB instance automatically or not. It is valid when payment_type is `Subscription`. Default to `false`.
        :param pulumi.Input[int] auto_renew_period: Auto-renewal period of an instance, in the unit of the month. It is valid when payment_type is `Subscription`. Valid value:[1~12], Default to 1.
        :param pulumi.Input[str] auto_upgrade_minor_version: The upgrade method to use. Valid values:
               - Auto: Instances are automatically upgraded to a higher minor version.
               - Manual: Instances are forcibly upgraded to a higher minor version when the current version is unpublished.
               
               See more [details and limitation](https://www.alibabacloud.com/help/doc-detail/123605.htm).
        :param pulumi.Input[str] backup_set_id: The ID of the backup set that is used for the restoration. You can call the DescribeCrossRegionBackups operation to query the ID of the backup set.
        :param pulumi.Input[str] ca_type: The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. Value range:
               - aliyun: a cloud certificate
               - custom: a custom certificate
        :param pulumi.Input[str] client_ca_cert: The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter.
        :param pulumi.Input[int] client_ca_enabled: Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
               - 1: enables the public key
               - 0: disables the public key
        :param pulumi.Input[str] client_cert_revocation_list: The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter.
        :param pulumi.Input[int] client_crl_enabled: Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - 1: enables the CRL
               - 0: disables the CRL
        :param pulumi.Input[str] connection_string_prefix: The private connection string prefix. If you want to update public connection string prefix, please use resource rds.Connection connection_prefix. 
               > **NOTE:** The prefix must be 8 to 64 characters in length and can contain letters, digits, and hyphens (-). It cannot contain Chinese characters and special characters ~!#%^&*=+\\|{};:'",<>/?
        :param pulumi.Input[str] db_instance_ip_array_attribute: The attribute of the IP address whitelist. By default, this parameter is empty.
               
               > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
        :param pulumi.Input[str] db_instance_ip_array_name: The name of the IP address whitelist. Default value: Default.
               
               > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
        :param pulumi.Input[str] db_instance_storage_type: The storage type of the instance. Valid values:
               - local_ssd: specifies to use local SSDs. This value is recommended.
               - cloud_ssd: specifies to use standard SSDs.
               - cloud_essd: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
               
               > **NOTE:** You can specify the time zone when you create a primary instance. You cannot specify the time zone when you create a read-only instance. Read-only instances inherit the time zone of their primary instance. If you do not specify this parameter, the system assigns the default time zone of the region where the instance resides.
        :param pulumi.Input[bool] deletion_protection: The switch of delete protection. Valid values: 
               - true: delete protect.
               - false: no delete protect.
               
               > **NOTE:** `deletion_protection` is valid only when attribute `payment_type` is set to `PayAsYouGo`, supported engine type: **MySQL**, **PostgreSQL**, **MariaDB**, **MSSQL**.
        :param pulumi.Input[str] effective_time: The method to update the engine version and change.  Default value: Immediate. Valid values:
               - Immediate: The change immediately takes effect.
               - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
        :param pulumi.Input[str] encryption_key: The key id of the KMS. Used for encrypting a disk if not null. Only for PostgreSQL, MySQL and SQLServer.
        :param pulumi.Input[bool] force_restart: Set it to true to make some parameter efficient when modifying them. Default to false.
        :param pulumi.Input[str] fresh_white_list_readins: The read-only instances to which you want to synchronize the IP address whitelist.
               * If the instance is attached with a read-only instance, you can use this parameter to synchronize the IP address whitelist to the read-only instance. If the instance is attached with multiple read-only instances, the read-only instances must be separated by commas (,).
               * If the instance is not attached with a read-only instance, this parameter is empty.
        :param pulumi.Input[str] ha_config: The primary/secondary switchover mode of the instance. Default value: Auto. Valid values:
               - Auto: The system automatically switches over services from the primary to secondary instances in the event of a fault.
               - Manual: You must manually switch over services from the primary to secondary instances in the event of a fault.
               
               > **NOTE:** If you set this parameter to Manual, you must specify the ManualHATime parameter.
        :param pulumi.Input[str] instance_name: The name of DB instance. It a string of 2 to 256 characters.
        :param pulumi.Input[str] maintain_time: Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
        :param pulumi.Input[str] manual_ha_time: The time after when you want to enable automatic primary/secondary switchover. At most, you can set this parameter to 23:59:59 seven days later. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
               
               > **NOTE:** This parameter only takes effect when the HAConfig parameter is set to Manual.
        :param pulumi.Input[str] modify_mode: The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
               - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
               - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
               - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
        :param pulumi.Input[int] monitoring_period: The monitoring frequency in seconds. Valid values are 5, 60, 300. Defaults to 300.
        :param pulumi.Input[Sequence[pulumi.Input['DdrInstanceParameterArgs']]] parameters: Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
        :param pulumi.Input[int] period: The duration that you will buy DB instance (in month). It is valid when payment_type is `Subscription`. Valid values: [1~9], 12, 24, 36.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[Sequence[pulumi.Input['DdrInstancePgHbaConfArgs']]] pg_hba_confs: The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
        :param pulumi.Input[str] port: The private port of the database service. If you want to update public port, please use resource rds.Connection port.
        :param pulumi.Input[str] private_ip_address: The private IP address of the instance. The private IP address must be within the Classless Inter-Domain Routing (CIDR) block of the vSwitch that is specified by the VSwitchId parameter.
        :param pulumi.Input[str] released_keep_policy: The policy based on which ApsaraDB RDS retains archived backup files after the instance is released. Valid values:
               - None: No archived backup files are retained.
               - Lastest: Only the last archived backup file is retained.
               - All: All the archived backup files are retained.
               
               > **NOTE:** This parameter is supported only when the instance runs the MySQL database engine.
        :param pulumi.Input[str] replication_acl: The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param pulumi.Input[str] resource_group_id: The ID of resource group which the DB instance belongs.
        :param pulumi.Input[str] restore_time: The point in time to which you want to restore data. The point in time that you specify must be earlier than the current time. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: ) The list IDs to join ECS Security Group. At most supports three security groups.
        :param pulumi.Input[str] security_ip_mode: Valid values are `normal`, `safety`, Default to `normal`. support `safety` switch to high security access mode.
        :param pulumi.Input[str] security_ip_type: The type of IP address in the IP address whitelist.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_ips: List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        :param pulumi.Input[str] server_cert: The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
        :param pulumi.Input[str] server_key: The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
        :param pulumi.Input[str] source_db_instance_name: The ID of the source instance if you want to restore data to a point in time.
        :param pulumi.Input[str] source_region: The region ID of the source instance if you want to restore data to a point in time.
        :param pulumi.Input[int] sql_collector_config_value: The sql collector keep time of the instance. Valid values are `30`, `180`, `365`, `1095`, `1825`, Default to `30`.
        :param pulumi.Input[str] sql_collector_status: The sql collector status of the instance. Valid values are `Enabled`, `Disabled`, Default to `Disabled`.
        :param pulumi.Input[str] ssl_action: Actions performed on SSL functions, Valid values: `Open`: turn on SSL encryption; `Close`: turn off SSL encryption; `Update`: update SSL certificate. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26254.htm).
        :param pulumi.Input[str] storage_auto_scale: Automatic storage space expansion switch. Valid values:
               - Enable
               - Disable
               
               > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable.
        :param pulumi.Input[int] storage_threshold: The trigger threshold (percentage) for automatic storage space expansion. Valid values:
               - 10
               - 20
               - 30
               - 40
               - 50
               
               > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable. The value must be greater than or equal to the total size of the current storage space of the instance.
        :param pulumi.Input[int] storage_upper_bound: The upper limit of the total storage space for automatic expansion of the storage space, that is, automatic expansion will not cause the total storage space of the instance to exceed this value. Unit: GB. The value must be ≥0.
               
               > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
        :param pulumi.Input[str] switch_time: The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `upgrade_db_instance_kernel_version = true`. The time must be in UTC.
               
               > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[str] target_minor_version: The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. It is valid only when `upgrade_db_instance_kernel_version = true`. You must specify the minor engine version in one of the following formats:
               - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
               - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
               - rds: The instance runs RDS Basic or High-availability Edition.
               - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
               - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
               - SQLServer: <Minor engine version>. Example: 15.0.4073.23.
               
               > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
        :param pulumi.Input[str] tcp_connection_type: The availability check method of the instance. Valid values:
               - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
               - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
        :param pulumi.Input[str] tde_status: The TDE(Transparent Data Encryption) status. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26256.htm).
        :param pulumi.Input[bool] upgrade_db_instance_kernel_version: Whether to upgrade a minor version of the kernel. Valid values:
               - true: upgrade
               - false: not to upgrade
        :param pulumi.Input[str] upgrade_time: The method to update the minor engine version. Default value: Immediate. It is valid only when `upgrade_db_instance_kernel_version = true`. Valid values:
               - Immediate: The minor engine version is immediately updated.
               - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
               - SpecifyTime: The minor engine version is updated at the point in time you specify.
        :param pulumi.Input[str] vpc_id: The VPC ID of the instance.
               
               > **NOTE:** This parameter applies only to ApsaraDB RDS for MySQL instances. For more information about Upgrade the major engine version of an ApsaraDB RDS for MySQL instance, see [Upgrade the major engine version of an RDS instance in the ApsaraDB RDS console](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/upgrade-the-major-engine-version-of-an-apsaradb-rds-for-mysql-instance-1).
        :param pulumi.Input[str] vswitch_id: The virtual switch ID to launch DB instances in one VPC. If there are multiple vswitches, separate them with commas.
        :param pulumi.Input[str] whitelist_network_type: The network type of the IP address whitelist. Default value: MIX. Valid values:
               - Classic: classic network in enhanced whitelist mode
               - VPC: virtual private cloud (VPC) in enhanced whitelist mode
               - MIX: standard whitelist mode
               
               > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
        :param pulumi.Input[str] zone_id: The Zone to launch the DB instance. It supports multiple zone.
               If it is a multi-zone and `vswitch_id` is specified, the vswitch must in the one of them.
               The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `get_zones`.
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "instance_storage", instance_storage)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "restore_type", restore_type)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if backup_set_id is not None:
            pulumi.set(__self__, "backup_set_id", backup_set_id)
        if ca_type is not None:
            pulumi.set(__self__, "ca_type", ca_type)
        if client_ca_cert is not None:
            pulumi.set(__self__, "client_ca_cert", client_ca_cert)
        if client_ca_enabled is not None:
            pulumi.set(__self__, "client_ca_enabled", client_ca_enabled)
        if client_cert_revocation_list is not None:
            pulumi.set(__self__, "client_cert_revocation_list", client_cert_revocation_list)
        if client_crl_enabled is not None:
            pulumi.set(__self__, "client_crl_enabled", client_crl_enabled)
        if connection_string_prefix is not None:
            pulumi.set(__self__, "connection_string_prefix", connection_string_prefix)
        if db_instance_ip_array_attribute is not None:
            pulumi.set(__self__, "db_instance_ip_array_attribute", db_instance_ip_array_attribute)
        if db_instance_ip_array_name is not None:
            pulumi.set(__self__, "db_instance_ip_array_name", db_instance_ip_array_name)
        if db_instance_storage_type is not None:
            pulumi.set(__self__, "db_instance_storage_type", db_instance_storage_type)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if force_restart is not None:
            pulumi.set(__self__, "force_restart", force_restart)
        if fresh_white_list_readins is not None:
            pulumi.set(__self__, "fresh_white_list_readins", fresh_white_list_readins)
        if ha_config is not None:
            pulumi.set(__self__, "ha_config", ha_config)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if maintain_time is not None:
            pulumi.set(__self__, "maintain_time", maintain_time)
        if manual_ha_time is not None:
            pulumi.set(__self__, "manual_ha_time", manual_ha_time)
        if modify_mode is not None:
            pulumi.set(__self__, "modify_mode", modify_mode)
        if monitoring_period is not None:
            pulumi.set(__self__, "monitoring_period", monitoring_period)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if pg_hba_confs is not None:
            pulumi.set(__self__, "pg_hba_confs", pg_hba_confs)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if released_keep_policy is not None:
            pulumi.set(__self__, "released_keep_policy", released_keep_policy)
        if replication_acl is not None:
            pulumi.set(__self__, "replication_acl", replication_acl)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if restore_time is not None:
            pulumi.set(__self__, "restore_time", restore_time)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if security_ip_mode is not None:
            pulumi.set(__self__, "security_ip_mode", security_ip_mode)
        if security_ip_type is not None:
            pulumi.set(__self__, "security_ip_type", security_ip_type)
        if security_ips is not None:
            pulumi.set(__self__, "security_ips", security_ips)
        if server_cert is not None:
            pulumi.set(__self__, "server_cert", server_cert)
        if server_key is not None:
            pulumi.set(__self__, "server_key", server_key)
        if source_db_instance_name is not None:
            pulumi.set(__self__, "source_db_instance_name", source_db_instance_name)
        if source_region is not None:
            pulumi.set(__self__, "source_region", source_region)
        if sql_collector_config_value is not None:
            pulumi.set(__self__, "sql_collector_config_value", sql_collector_config_value)
        if sql_collector_status is not None:
            pulumi.set(__self__, "sql_collector_status", sql_collector_status)
        if ssl_action is not None:
            pulumi.set(__self__, "ssl_action", ssl_action)
        if storage_auto_scale is not None:
            pulumi.set(__self__, "storage_auto_scale", storage_auto_scale)
        if storage_threshold is not None:
            pulumi.set(__self__, "storage_threshold", storage_threshold)
        if storage_upper_bound is not None:
            pulumi.set(__self__, "storage_upper_bound", storage_upper_bound)
        if switch_time is not None:
            pulumi.set(__self__, "switch_time", switch_time)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_minor_version is not None:
            pulumi.set(__self__, "target_minor_version", target_minor_version)
        if tcp_connection_type is not None:
            pulumi.set(__self__, "tcp_connection_type", tcp_connection_type)
        if tde_status is not None:
            pulumi.set(__self__, "tde_status", tde_status)
        if upgrade_db_instance_kernel_version is not None:
            pulumi.set(__self__, "upgrade_db_instance_kernel_version", upgrade_db_instance_kernel_version)
        if upgrade_time is not None:
            pulumi.set(__self__, "upgrade_time", upgrade_time)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if whitelist_network_type is not None:
            pulumi.set(__self__, "whitelist_network_type", whitelist_network_type)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Input[str]:
        """
        Database type. Value options: MySQL, SQLServer.

        > **NOTE:** When the 'EngineVersion' changes, it can be used as the target database version for the large version upgrade of RDS for MySQL instance.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: pulumi.Input[str]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Input[str]:
        """
        Database version. Value options can refer to the latest docs [CreateDdrInstance](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/restore-data-to-a-new-instance-across-regions) `EngineVersion`.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="instanceStorage")
    def instance_storage(self) -> pulumi.Input[int]:
        """
        The storage capacity of the destination instance. Valid values: 5 to 2000. Unit: GB.

        This value must be a multiple of 5 GB. For more information, see Primary ApsaraDB RDS instance types.
        """
        return pulumi.get(self, "instance_storage")

    @instance_storage.setter
    def instance_storage(self, value: pulumi.Input[int]):
        pulumi.set(self, "instance_storage", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        DB Instance type.

        > **NOTE:** When `storage_auto_scale="Enable"`, do not perform `instance_storage` check. when `storage_auto_scale="Disable"`, if the instance itself `instance_storage`has changed. You need to manually revise the `instance_storage` in the template value.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[str]:
        """
        Valid values are `Subscription`, `PayAsYouGo`, Default to `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> pulumi.Input[str]:
        """
        The method that is used to restore data. Valid values:
        - BackupSet: Data is restored from a backup set. If you use this value, you must also specify the BackupSetID parameter.
        - BackupTime: restores data to a point in time. You must also specify the RestoreTime, SourceRegion, and SourceDBInstanceName parameters.
        """
        return pulumi.get(self, "restore_type")

    @restore_type.setter
    def restore_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "restore_type", value)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[str]]:
        """
        The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to renewal a DB instance automatically or not. It is valid when payment_type is `Subscription`. Default to `false`.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        Auto-renewal period of an instance, in the unit of the month. It is valid when payment_type is `Subscription`. Valid value:[1~12], Default to 1.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_period", value)

    @property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[pulumi.Input[str]]:
        """
        The upgrade method to use. Valid values:
        - Auto: Instances are automatically upgraded to a higher minor version.
        - Manual: Instances are forcibly upgraded to a higher minor version when the current version is unpublished.

        See more [details and limitation](https://www.alibabacloud.com/help/doc-detail/123605.htm).
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @auto_upgrade_minor_version.setter
    def auto_upgrade_minor_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_upgrade_minor_version", value)

    @property
    @pulumi.getter(name="backupSetId")
    def backup_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the backup set that is used for the restoration. You can call the DescribeCrossRegionBackups operation to query the ID of the backup set.
        """
        return pulumi.get(self, "backup_set_id")

    @backup_set_id.setter
    def backup_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_id", value)

    @property
    @pulumi.getter(name="caType")
    def ca_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. Value range:
        - aliyun: a cloud certificate
        - custom: a custom certificate
        """
        return pulumi.get(self, "ca_type")

    @ca_type.setter
    def ca_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_type", value)

    @property
    @pulumi.getter(name="clientCaCert")
    def client_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter.
        """
        return pulumi.get(self, "client_ca_cert")

    @client_ca_cert.setter
    def client_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_ca_cert", value)

    @property
    @pulumi.getter(name="clientCaEnabled")
    def client_ca_enabled(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
        - 1: enables the public key
        - 0: disables the public key
        """
        return pulumi.get(self, "client_ca_enabled")

    @client_ca_enabled.setter
    def client_ca_enabled(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "client_ca_enabled", value)

    @property
    @pulumi.getter(name="clientCertRevocationList")
    def client_cert_revocation_list(self) -> Optional[pulumi.Input[str]]:
        """
        The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter.
        """
        return pulumi.get(self, "client_cert_revocation_list")

    @client_cert_revocation_list.setter
    def client_cert_revocation_list(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_cert_revocation_list", value)

    @property
    @pulumi.getter(name="clientCrlEnabled")
    def client_crl_enabled(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
        - 1: enables the CRL
        - 0: disables the CRL
        """
        return pulumi.get(self, "client_crl_enabled")

    @client_crl_enabled.setter
    def client_crl_enabled(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "client_crl_enabled", value)

    @property
    @pulumi.getter(name="connectionStringPrefix")
    def connection_string_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The private connection string prefix. If you want to update public connection string prefix, please use resource rds.Connection connection_prefix. 
        > **NOTE:** The prefix must be 8 to 64 characters in length and can contain letters, digits, and hyphens (-). It cannot contain Chinese characters and special characters ~!#%^&*=+\\|{};:'",<>/?
        """
        return pulumi.get(self, "connection_string_prefix")

    @connection_string_prefix.setter
    def connection_string_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string_prefix", value)

    @property
    @pulumi.getter(name="dbInstanceIpArrayAttribute")
    def db_instance_ip_array_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        The attribute of the IP address whitelist. By default, this parameter is empty.

        > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
        """
        return pulumi.get(self, "db_instance_ip_array_attribute")

    @db_instance_ip_array_attribute.setter
    def db_instance_ip_array_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_instance_ip_array_attribute", value)

    @property
    @pulumi.getter(name="dbInstanceIpArrayName")
    def db_instance_ip_array_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the IP address whitelist. Default value: Default.

        > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
        """
        return pulumi.get(self, "db_instance_ip_array_name")

    @db_instance_ip_array_name.setter
    def db_instance_ip_array_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_instance_ip_array_name", value)

    @property
    @pulumi.getter(name="dbInstanceStorageType")
    def db_instance_storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        The storage type of the instance. Valid values:
        - local_ssd: specifies to use local SSDs. This value is recommended.
        - cloud_ssd: specifies to use standard SSDs.
        - cloud_essd: specifies to use enhanced SSDs (ESSDs).
        - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
        - cloud_essd3: specifies to use enhanced SSDs (ESSDs).

        > **NOTE:** You can specify the time zone when you create a primary instance. You cannot specify the time zone when you create a read-only instance. Read-only instances inherit the time zone of their primary instance. If you do not specify this parameter, the system assigns the default time zone of the region where the instance resides.
        """
        return pulumi.get(self, "db_instance_storage_type")

    @db_instance_storage_type.setter
    def db_instance_storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_instance_storage_type", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        The switch of delete protection. Valid values: 
        - true: delete protect.
        - false: no delete protect.

        > **NOTE:** `deletion_protection` is valid only when attribute `payment_type` is set to `PayAsYouGo`, supported engine type: **MySQL**, **PostgreSQL**, **MariaDB**, **MSSQL**.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[pulumi.Input[str]]:
        """
        The method to update the engine version and change.  Default value: Immediate. Valid values:
        - Immediate: The change immediately takes effect.
        - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
        """
        return pulumi.get(self, "effective_time")

    @effective_time.setter
    def effective_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effective_time", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[str]]:
        """
        The key id of the KMS. Used for encrypting a disk if not null. Only for PostgreSQL, MySQL and SQLServer.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> Optional[pulumi.Input[bool]]:
        """
        Set it to true to make some parameter efficient when modifying them. Default to false.
        """
        return pulumi.get(self, "force_restart")

    @force_restart.setter
    def force_restart(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_restart", value)

    @property
    @pulumi.getter(name="freshWhiteListReadins")
    def fresh_white_list_readins(self) -> Optional[pulumi.Input[str]]:
        """
        The read-only instances to which you want to synchronize the IP address whitelist.
        * If the instance is attached with a read-only instance, you can use this parameter to synchronize the IP address whitelist to the read-only instance. If the instance is attached with multiple read-only instances, the read-only instances must be separated by commas (,).
        * If the instance is not attached with a read-only instance, this parameter is empty.
        """
        return pulumi.get(self, "fresh_white_list_readins")

    @fresh_white_list_readins.setter
    def fresh_white_list_readins(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fresh_white_list_readins", value)

    @property
    @pulumi.getter(name="haConfig")
    def ha_config(self) -> Optional[pulumi.Input[str]]:
        """
        The primary/secondary switchover mode of the instance. Default value: Auto. Valid values:
        - Auto: The system automatically switches over services from the primary to secondary instances in the event of a fault.
        - Manual: You must manually switch over services from the primary to secondary instances in the event of a fault.

        > **NOTE:** If you set this parameter to Manual, you must specify the ManualHATime parameter.
        """
        return pulumi.get(self, "ha_config")

    @ha_config.setter
    def ha_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_config", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of DB instance. It a string of 2 to 256 characters.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="maintainTime")
    def maintain_time(self) -> Optional[pulumi.Input[str]]:
        """
        Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
        """
        return pulumi.get(self, "maintain_time")

    @maintain_time.setter
    def maintain_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_time", value)

    @property
    @pulumi.getter(name="manualHaTime")
    def manual_ha_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time after when you want to enable automatic primary/secondary switchover. At most, you can set this parameter to 23:59:59 seven days later. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.

        > **NOTE:** This parameter only takes effect when the HAConfig parameter is set to Manual.
        """
        return pulumi.get(self, "manual_ha_time")

    @manual_ha_time.setter
    def manual_ha_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manual_ha_time", value)

    @property
    @pulumi.getter(name="modifyMode")
    def modify_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
        - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
        - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
        - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
        """
        return pulumi.get(self, "modify_mode")

    @modify_mode.setter
    def modify_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modify_mode", value)

    @property
    @pulumi.getter(name="monitoringPeriod")
    def monitoring_period(self) -> Optional[pulumi.Input[int]]:
        """
        The monitoring frequency in seconds. Valid values are 5, 60, 300. Defaults to 300.
        """
        return pulumi.get(self, "monitoring_period")

    @monitoring_period.setter
    def monitoring_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "monitoring_period", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DdrInstanceParameterArgs']]]]:
        """
        Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DdrInstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The duration that you will buy DB instance (in month). It is valid when payment_type is `Subscription`. Valid values: [1~9], 12, 24, 36.
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="pgHbaConfs")
    def pg_hba_confs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DdrInstancePgHbaConfArgs']]]]:
        """
        The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
        """
        return pulumi.get(self, "pg_hba_confs")

    @pg_hba_confs.setter
    def pg_hba_confs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DdrInstancePgHbaConfArgs']]]]):
        pulumi.set(self, "pg_hba_confs", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        The private port of the database service. If you want to update public port, please use resource rds.Connection port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The private IP address of the instance. The private IP address must be within the Classless Inter-Domain Routing (CIDR) block of the vSwitch that is specified by the VSwitchId parameter.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="releasedKeepPolicy")
    def released_keep_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The policy based on which ApsaraDB RDS retains archived backup files after the instance is released. Valid values:
        - None: No archived backup files are retained.
        - Lastest: Only the last archived backup file is retained.
        - All: All the archived backup files are retained.

        > **NOTE:** This parameter is supported only when the instance runs the MySQL database engine.
        """
        return pulumi.get(self, "released_keep_policy")

    @released_keep_policy.setter
    def released_keep_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "released_keep_policy", value)

    @property
    @pulumi.getter(name="replicationAcl")
    def replication_acl(self) -> Optional[pulumi.Input[str]]:
        """
        The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        """
        return pulumi.get(self, "replication_acl")

    @replication_acl.setter
    def replication_acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_acl", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of resource group which the DB instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="restoreTime")
    def restore_time(self) -> Optional[pulumi.Input[str]]:
        """
        The point in time to which you want to restore data. The point in time that you specify must be earlier than the current time. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        """
        return pulumi.get(self, "restore_time")

    @restore_time.setter
    def restore_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restore_time", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        ) The list IDs to join ECS Security Group. At most supports three security groups.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="securityIpMode")
    def security_ip_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Valid values are `normal`, `safety`, Default to `normal`. support `safety` switch to high security access mode.
        """
        return pulumi.get(self, "security_ip_mode")

    @security_ip_mode.setter
    def security_ip_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_ip_mode", value)

    @property
    @pulumi.getter(name="securityIpType")
    def security_ip_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of IP address in the IP address whitelist.
        """
        return pulumi.get(self, "security_ip_type")

    @security_ip_type.setter
    def security_ip_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_ip_type", value)

    @property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        """
        return pulumi.get(self, "security_ips")

    @security_ips.setter
    def security_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_ips", value)

    @property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
        """
        return pulumi.get(self, "server_cert")

    @server_cert.setter
    def server_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_cert", value)

    @property
    @pulumi.getter(name="serverKey")
    def server_key(self) -> Optional[pulumi.Input[str]]:
        """
        The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
        """
        return pulumi.get(self, "server_key")

    @server_key.setter
    def server_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_key", value)

    @property
    @pulumi.getter(name="sourceDbInstanceName")
    def source_db_instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the source instance if you want to restore data to a point in time.
        """
        return pulumi.get(self, "source_db_instance_name")

    @source_db_instance_name.setter
    def source_db_instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_db_instance_name", value)

    @property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region ID of the source instance if you want to restore data to a point in time.
        """
        return pulumi.get(self, "source_region")

    @source_region.setter
    def source_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_region", value)

    @property
    @pulumi.getter(name="sqlCollectorConfigValue")
    def sql_collector_config_value(self) -> Optional[pulumi.Input[int]]:
        """
        The sql collector keep time of the instance. Valid values are `30`, `180`, `365`, `1095`, `1825`, Default to `30`.
        """
        return pulumi.get(self, "sql_collector_config_value")

    @sql_collector_config_value.setter
    def sql_collector_config_value(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sql_collector_config_value", value)

    @property
    @pulumi.getter(name="sqlCollectorStatus")
    def sql_collector_status(self) -> Optional[pulumi.Input[str]]:
        """
        The sql collector status of the instance. Valid values are `Enabled`, `Disabled`, Default to `Disabled`.
        """
        return pulumi.get(self, "sql_collector_status")

    @sql_collector_status.setter
    def sql_collector_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql_collector_status", value)

    @property
    @pulumi.getter(name="sslAction")
    def ssl_action(self) -> Optional[pulumi.Input[str]]:
        """
        Actions performed on SSL functions, Valid values: `Open`: turn on SSL encryption; `Close`: turn off SSL encryption; `Update`: update SSL certificate. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26254.htm).
        """
        return pulumi.get(self, "ssl_action")

    @ssl_action.setter
    def ssl_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_action", value)

    @property
    @pulumi.getter(name="storageAutoScale")
    def storage_auto_scale(self) -> Optional[pulumi.Input[str]]:
        """
        Automatic storage space expansion switch. Valid values:
        - Enable
        - Disable

        > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable.
        """
        return pulumi.get(self, "storage_auto_scale")

    @storage_auto_scale.setter
    def storage_auto_scale(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_auto_scale", value)

    @property
    @pulumi.getter(name="storageThreshold")
    def storage_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The trigger threshold (percentage) for automatic storage space expansion. Valid values:
        - 10
        - 20
        - 30
        - 40
        - 50

        > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable. The value must be greater than or equal to the total size of the current storage space of the instance.
        """
        return pulumi.get(self, "storage_threshold")

    @storage_threshold.setter
    def storage_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_threshold", value)

    @property
    @pulumi.getter(name="storageUpperBound")
    def storage_upper_bound(self) -> Optional[pulumi.Input[int]]:
        """
        The upper limit of the total storage space for automatic expansion of the storage space, that is, automatic expansion will not cause the total storage space of the instance to exceed this value. Unit: GB. The value must be ≥0.

        > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
        """
        return pulumi.get(self, "storage_upper_bound")

    @storage_upper_bound.setter
    def storage_upper_bound(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_upper_bound", value)

    @property
    @pulumi.getter(name="switchTime")
    def switch_time(self) -> Optional[pulumi.Input[str]]:
        """
        The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `upgrade_db_instance_kernel_version = true`. The time must be in UTC.

        > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
        """
        return pulumi.get(self, "switch_time")

    @switch_time.setter
    def switch_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "switch_time", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetMinorVersion")
    def target_minor_version(self) -> Optional[pulumi.Input[str]]:
        """
        The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. It is valid only when `upgrade_db_instance_kernel_version = true`. You must specify the minor engine version in one of the following formats:
        - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
        - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
        - rds: The instance runs RDS Basic or High-availability Edition.
        - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
        - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
        - SQLServer: <Minor engine version>. Example: 15.0.4073.23.

        > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
        """
        return pulumi.get(self, "target_minor_version")

    @target_minor_version.setter
    def target_minor_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_minor_version", value)

    @property
    @pulumi.getter(name="tcpConnectionType")
    def tcp_connection_type(self) -> Optional[pulumi.Input[str]]:
        """
        The availability check method of the instance. Valid values:
        - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
        - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
        """
        return pulumi.get(self, "tcp_connection_type")

    @tcp_connection_type.setter
    def tcp_connection_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tcp_connection_type", value)

    @property
    @pulumi.getter(name="tdeStatus")
    def tde_status(self) -> Optional[pulumi.Input[str]]:
        """
        The TDE(Transparent Data Encryption) status. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26256.htm).
        """
        return pulumi.get(self, "tde_status")

    @tde_status.setter
    def tde_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tde_status", value)

    @property
    @pulumi.getter(name="upgradeDbInstanceKernelVersion")
    def upgrade_db_instance_kernel_version(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to upgrade a minor version of the kernel. Valid values:
        - true: upgrade
        - false: not to upgrade
        """
        return pulumi.get(self, "upgrade_db_instance_kernel_version")

    @upgrade_db_instance_kernel_version.setter
    def upgrade_db_instance_kernel_version(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "upgrade_db_instance_kernel_version", value)

    @property
    @pulumi.getter(name="upgradeTime")
    def upgrade_time(self) -> Optional[pulumi.Input[str]]:
        """
        The method to update the minor engine version. Default value: Immediate. It is valid only when `upgrade_db_instance_kernel_version = true`. Valid values:
        - Immediate: The minor engine version is immediately updated.
        - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
        - SpecifyTime: The minor engine version is updated at the point in time you specify.
        """
        return pulumi.get(self, "upgrade_time")

    @upgrade_time.setter
    def upgrade_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "upgrade_time", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC ID of the instance.

        > **NOTE:** This parameter applies only to ApsaraDB RDS for MySQL instances. For more information about Upgrade the major engine version of an ApsaraDB RDS for MySQL instance, see [Upgrade the major engine version of an RDS instance in the ApsaraDB RDS console](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/upgrade-the-major-engine-version-of-an-apsaradb-rds-for-mysql-instance-1).
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The virtual switch ID to launch DB instances in one VPC. If there are multiple vswitches, separate them with commas.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="whitelistNetworkType")
    def whitelist_network_type(self) -> Optional[pulumi.Input[str]]:
        """
        The network type of the IP address whitelist. Default value: MIX. Valid values:
        - Classic: classic network in enhanced whitelist mode
        - VPC: virtual private cloud (VPC) in enhanced whitelist mode
        - MIX: standard whitelist mode

        > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
        """
        return pulumi.get(self, "whitelist_network_type")

    @whitelist_network_type.setter
    def whitelist_network_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "whitelist_network_type", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Zone to launch the DB instance. It supports multiple zone.
        If it is a multi-zone and `vswitch_id` is specified, the vswitch must in the one of them.
        The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `get_zones`.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _DdrInstanceState:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 auto_upgrade_minor_version: Optional[pulumi.Input[str]] = None,
                 backup_set_id: Optional[pulumi.Input[str]] = None,
                 ca_type: Optional[pulumi.Input[str]] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 client_ca_cert: Optional[pulumi.Input[str]] = None,
                 client_ca_enabled: Optional[pulumi.Input[int]] = None,
                 client_cert_revocation_list: Optional[pulumi.Input[str]] = None,
                 client_crl_enabled: Optional[pulumi.Input[int]] = None,
                 connection_string: Optional[pulumi.Input[str]] = None,
                 connection_string_prefix: Optional[pulumi.Input[str]] = None,
                 db_instance_ip_array_attribute: Optional[pulumi.Input[str]] = None,
                 db_instance_ip_array_name: Optional[pulumi.Input[str]] = None,
                 db_instance_storage_type: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 effective_time: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 force_restart: Optional[pulumi.Input[bool]] = None,
                 fresh_white_list_readins: Optional[pulumi.Input[str]] = None,
                 ha_config: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_storage: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 maintain_time: Optional[pulumi.Input[str]] = None,
                 manual_ha_time: Optional[pulumi.Input[str]] = None,
                 modify_mode: Optional[pulumi.Input[str]] = None,
                 monitoring_period: Optional[pulumi.Input[int]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['DdrInstanceParameterArgs']]]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 pg_hba_confs: Optional[pulumi.Input[Sequence[pulumi.Input['DdrInstancePgHbaConfArgs']]]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 released_keep_policy: Optional[pulumi.Input[str]] = None,
                 replication_acl: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 restore_time: Optional[pulumi.Input[str]] = None,
                 restore_type: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_ip_mode: Optional[pulumi.Input[str]] = None,
                 security_ip_type: Optional[pulumi.Input[str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 server_cert: Optional[pulumi.Input[str]] = None,
                 server_key: Optional[pulumi.Input[str]] = None,
                 source_db_instance_name: Optional[pulumi.Input[str]] = None,
                 source_region: Optional[pulumi.Input[str]] = None,
                 sql_collector_config_value: Optional[pulumi.Input[int]] = None,
                 sql_collector_status: Optional[pulumi.Input[str]] = None,
                 ssl_action: Optional[pulumi.Input[str]] = None,
                 ssl_status: Optional[pulumi.Input[str]] = None,
                 storage_auto_scale: Optional[pulumi.Input[str]] = None,
                 storage_threshold: Optional[pulumi.Input[int]] = None,
                 storage_upper_bound: Optional[pulumi.Input[int]] = None,
                 switch_time: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_minor_version: Optional[pulumi.Input[str]] = None,
                 tcp_connection_type: Optional[pulumi.Input[str]] = None,
                 tde_status: Optional[pulumi.Input[str]] = None,
                 upgrade_db_instance_kernel_version: Optional[pulumi.Input[bool]] = None,
                 upgrade_time: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 whitelist_network_type: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 zone_id_slave_a: Optional[pulumi.Input[str]] = None,
                 zone_id_slave_b: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DdrInstance resources.
        :param pulumi.Input[str] acl: The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param pulumi.Input[bool] auto_renew: Whether to renewal a DB instance automatically or not. It is valid when payment_type is `Subscription`. Default to `false`.
        :param pulumi.Input[int] auto_renew_period: Auto-renewal period of an instance, in the unit of the month. It is valid when payment_type is `Subscription`. Valid value:[1~12], Default to 1.
        :param pulumi.Input[str] auto_upgrade_minor_version: The upgrade method to use. Valid values:
               - Auto: Instances are automatically upgraded to a higher minor version.
               - Manual: Instances are forcibly upgraded to a higher minor version when the current version is unpublished.
               
               See more [details and limitation](https://www.alibabacloud.com/help/doc-detail/123605.htm).
        :param pulumi.Input[str] backup_set_id: The ID of the backup set that is used for the restoration. You can call the DescribeCrossRegionBackups operation to query the ID of the backup set.
        :param pulumi.Input[str] ca_type: The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. Value range:
               - aliyun: a cloud certificate
               - custom: a custom certificate
        :param pulumi.Input[str] category: The RDS edition of the instance.
        :param pulumi.Input[str] client_ca_cert: The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter.
        :param pulumi.Input[int] client_ca_enabled: Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
               - 1: enables the public key
               - 0: disables the public key
        :param pulumi.Input[str] client_cert_revocation_list: The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter.
        :param pulumi.Input[int] client_crl_enabled: Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - 1: enables the CRL
               - 0: disables the CRL
        :param pulumi.Input[str] connection_string: RDS database connection string.
        :param pulumi.Input[str] connection_string_prefix: The private connection string prefix. If you want to update public connection string prefix, please use resource rds.Connection connection_prefix. 
               > **NOTE:** The prefix must be 8 to 64 characters in length and can contain letters, digits, and hyphens (-). It cannot contain Chinese characters and special characters ~!#%^&*=+\\|{};:'",<>/?
        :param pulumi.Input[str] db_instance_ip_array_attribute: The attribute of the IP address whitelist. By default, this parameter is empty.
               
               > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
        :param pulumi.Input[str] db_instance_ip_array_name: The name of the IP address whitelist. Default value: Default.
               
               > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
        :param pulumi.Input[str] db_instance_storage_type: The storage type of the instance. Valid values:
               - local_ssd: specifies to use local SSDs. This value is recommended.
               - cloud_ssd: specifies to use standard SSDs.
               - cloud_essd: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
               
               > **NOTE:** You can specify the time zone when you create a primary instance. You cannot specify the time zone when you create a read-only instance. Read-only instances inherit the time zone of their primary instance. If you do not specify this parameter, the system assigns the default time zone of the region where the instance resides.
        :param pulumi.Input[bool] deletion_protection: The switch of delete protection. Valid values: 
               - true: delete protect.
               - false: no delete protect.
               
               > **NOTE:** `deletion_protection` is valid only when attribute `payment_type` is set to `PayAsYouGo`, supported engine type: **MySQL**, **PostgreSQL**, **MariaDB**, **MSSQL**.
        :param pulumi.Input[str] effective_time: The method to update the engine version and change.  Default value: Immediate. Valid values:
               - Immediate: The change immediately takes effect.
               - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
        :param pulumi.Input[str] encryption_key: The key id of the KMS. Used for encrypting a disk if not null. Only for PostgreSQL, MySQL and SQLServer.
        :param pulumi.Input[str] engine: Database type. Value options: MySQL, SQLServer.
               
               > **NOTE:** When the 'EngineVersion' changes, it can be used as the target database version for the large version upgrade of RDS for MySQL instance.
        :param pulumi.Input[str] engine_version: Database version. Value options can refer to the latest docs [CreateDdrInstance](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/restore-data-to-a-new-instance-across-regions) `EngineVersion`.
        :param pulumi.Input[bool] force_restart: Set it to true to make some parameter efficient when modifying them. Default to false.
        :param pulumi.Input[str] fresh_white_list_readins: The read-only instances to which you want to synchronize the IP address whitelist.
               * If the instance is attached with a read-only instance, you can use this parameter to synchronize the IP address whitelist to the read-only instance. If the instance is attached with multiple read-only instances, the read-only instances must be separated by commas (,).
               * If the instance is not attached with a read-only instance, this parameter is empty.
        :param pulumi.Input[str] ha_config: The primary/secondary switchover mode of the instance. Default value: Auto. Valid values:
               - Auto: The system automatically switches over services from the primary to secondary instances in the event of a fault.
               - Manual: You must manually switch over services from the primary to secondary instances in the event of a fault.
               
               > **NOTE:** If you set this parameter to Manual, you must specify the ManualHATime parameter.
        :param pulumi.Input[str] instance_name: The name of DB instance. It a string of 2 to 256 characters.
        :param pulumi.Input[int] instance_storage: The storage capacity of the destination instance. Valid values: 5 to 2000. Unit: GB.
               
               This value must be a multiple of 5 GB. For more information, see Primary ApsaraDB RDS instance types.
        :param pulumi.Input[str] instance_type: DB Instance type.
               
               > **NOTE:** When `storage_auto_scale="Enable"`, do not perform `instance_storage` check. when `storage_auto_scale="Disable"`, if the instance itself `instance_storage`has changed. You need to manually revise the `instance_storage` in the template value.
        :param pulumi.Input[str] maintain_time: Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
        :param pulumi.Input[str] manual_ha_time: The time after when you want to enable automatic primary/secondary switchover. At most, you can set this parameter to 23:59:59 seven days later. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
               
               > **NOTE:** This parameter only takes effect when the HAConfig parameter is set to Manual.
        :param pulumi.Input[str] modify_mode: The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
               - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
               - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
               - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
        :param pulumi.Input[int] monitoring_period: The monitoring frequency in seconds. Valid values are 5, 60, 300. Defaults to 300.
        :param pulumi.Input[Sequence[pulumi.Input['DdrInstanceParameterArgs']]] parameters: Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
        :param pulumi.Input[str] payment_type: Valid values are `Subscription`, `PayAsYouGo`, Default to `PayAsYouGo`.
        :param pulumi.Input[int] period: The duration that you will buy DB instance (in month). It is valid when payment_type is `Subscription`. Valid values: [1~9], 12, 24, 36.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[Sequence[pulumi.Input['DdrInstancePgHbaConfArgs']]] pg_hba_confs: The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
        :param pulumi.Input[str] port: The private port of the database service. If you want to update public port, please use resource rds.Connection port.
        :param pulumi.Input[str] private_ip_address: The private IP address of the instance. The private IP address must be within the Classless Inter-Domain Routing (CIDR) block of the vSwitch that is specified by the VSwitchId parameter.
        :param pulumi.Input[str] released_keep_policy: The policy based on which ApsaraDB RDS retains archived backup files after the instance is released. Valid values:
               - None: No archived backup files are retained.
               - Lastest: Only the last archived backup file is retained.
               - All: All the archived backup files are retained.
               
               > **NOTE:** This parameter is supported only when the instance runs the MySQL database engine.
        :param pulumi.Input[str] replication_acl: The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param pulumi.Input[str] resource_group_id: The ID of resource group which the DB instance belongs.
        :param pulumi.Input[str] restore_time: The point in time to which you want to restore data. The point in time that you specify must be earlier than the current time. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        :param pulumi.Input[str] restore_type: The method that is used to restore data. Valid values:
               - BackupSet: Data is restored from a backup set. If you use this value, you must also specify the BackupSetID parameter.
               - BackupTime: restores data to a point in time. You must also specify the RestoreTime, SourceRegion, and SourceDBInstanceName parameters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: ) The list IDs to join ECS Security Group. At most supports three security groups.
        :param pulumi.Input[str] security_ip_mode: Valid values are `normal`, `safety`, Default to `normal`. support `safety` switch to high security access mode.
        :param pulumi.Input[str] security_ip_type: The type of IP address in the IP address whitelist.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_ips: List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        :param pulumi.Input[str] server_cert: The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
        :param pulumi.Input[str] server_key: The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
        :param pulumi.Input[str] source_db_instance_name: The ID of the source instance if you want to restore data to a point in time.
        :param pulumi.Input[str] source_region: The region ID of the source instance if you want to restore data to a point in time.
        :param pulumi.Input[int] sql_collector_config_value: The sql collector keep time of the instance. Valid values are `30`, `180`, `365`, `1095`, `1825`, Default to `30`.
        :param pulumi.Input[str] sql_collector_status: The sql collector status of the instance. Valid values are `Enabled`, `Disabled`, Default to `Disabled`.
        :param pulumi.Input[str] ssl_action: Actions performed on SSL functions, Valid values: `Open`: turn on SSL encryption; `Close`: turn off SSL encryption; `Update`: update SSL certificate. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26254.htm).
        :param pulumi.Input[str] ssl_status: Status of the SSL feature. `Yes`: SSL is turned on; `No`: SSL is turned off.
        :param pulumi.Input[str] storage_auto_scale: Automatic storage space expansion switch. Valid values:
               - Enable
               - Disable
               
               > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable.
        :param pulumi.Input[int] storage_threshold: The trigger threshold (percentage) for automatic storage space expansion. Valid values:
               - 10
               - 20
               - 30
               - 40
               - 50
               
               > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable. The value must be greater than or equal to the total size of the current storage space of the instance.
        :param pulumi.Input[int] storage_upper_bound: The upper limit of the total storage space for automatic expansion of the storage space, that is, automatic expansion will not cause the total storage space of the instance to exceed this value. Unit: GB. The value must be ≥0.
               
               > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
        :param pulumi.Input[str] switch_time: The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `upgrade_db_instance_kernel_version = true`. The time must be in UTC.
               
               > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[str] target_minor_version: The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. It is valid only when `upgrade_db_instance_kernel_version = true`. You must specify the minor engine version in one of the following formats:
               - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
               - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
               - rds: The instance runs RDS Basic or High-availability Edition.
               - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
               - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
               - SQLServer: <Minor engine version>. Example: 15.0.4073.23.
               
               > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
        :param pulumi.Input[str] tcp_connection_type: The availability check method of the instance. Valid values:
               - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
               - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
        :param pulumi.Input[str] tde_status: The TDE(Transparent Data Encryption) status. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26256.htm).
        :param pulumi.Input[bool] upgrade_db_instance_kernel_version: Whether to upgrade a minor version of the kernel. Valid values:
               - true: upgrade
               - false: not to upgrade
        :param pulumi.Input[str] upgrade_time: The method to update the minor engine version. Default value: Immediate. It is valid only when `upgrade_db_instance_kernel_version = true`. Valid values:
               - Immediate: The minor engine version is immediately updated.
               - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
               - SpecifyTime: The minor engine version is updated at the point in time you specify.
        :param pulumi.Input[str] vpc_id: The VPC ID of the instance.
               
               > **NOTE:** This parameter applies only to ApsaraDB RDS for MySQL instances. For more information about Upgrade the major engine version of an ApsaraDB RDS for MySQL instance, see [Upgrade the major engine version of an RDS instance in the ApsaraDB RDS console](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/upgrade-the-major-engine-version-of-an-apsaradb-rds-for-mysql-instance-1).
        :param pulumi.Input[str] vswitch_id: The virtual switch ID to launch DB instances in one VPC. If there are multiple vswitches, separate them with commas.
        :param pulumi.Input[str] whitelist_network_type: The network type of the IP address whitelist. Default value: MIX. Valid values:
               - Classic: classic network in enhanced whitelist mode
               - VPC: virtual private cloud (VPC) in enhanced whitelist mode
               - MIX: standard whitelist mode
               
               > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
        :param pulumi.Input[str] zone_id: The Zone to launch the DB instance. It supports multiple zone.
               If it is a multi-zone and `vswitch_id` is specified, the vswitch must in the one of them.
               The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `get_zones`.
        :param pulumi.Input[str] zone_id_slave_a: The region ID of the secondary instance if you create a secondary instance.
        :param pulumi.Input[str] zone_id_slave_b: The region ID of the log instance if you create a log instance.
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if backup_set_id is not None:
            pulumi.set(__self__, "backup_set_id", backup_set_id)
        if ca_type is not None:
            pulumi.set(__self__, "ca_type", ca_type)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if client_ca_cert is not None:
            pulumi.set(__self__, "client_ca_cert", client_ca_cert)
        if client_ca_enabled is not None:
            pulumi.set(__self__, "client_ca_enabled", client_ca_enabled)
        if client_cert_revocation_list is not None:
            pulumi.set(__self__, "client_cert_revocation_list", client_cert_revocation_list)
        if client_crl_enabled is not None:
            pulumi.set(__self__, "client_crl_enabled", client_crl_enabled)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if connection_string_prefix is not None:
            pulumi.set(__self__, "connection_string_prefix", connection_string_prefix)
        if db_instance_ip_array_attribute is not None:
            pulumi.set(__self__, "db_instance_ip_array_attribute", db_instance_ip_array_attribute)
        if db_instance_ip_array_name is not None:
            pulumi.set(__self__, "db_instance_ip_array_name", db_instance_ip_array_name)
        if db_instance_storage_type is not None:
            pulumi.set(__self__, "db_instance_storage_type", db_instance_storage_type)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if force_restart is not None:
            pulumi.set(__self__, "force_restart", force_restart)
        if fresh_white_list_readins is not None:
            pulumi.set(__self__, "fresh_white_list_readins", fresh_white_list_readins)
        if ha_config is not None:
            pulumi.set(__self__, "ha_config", ha_config)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_storage is not None:
            pulumi.set(__self__, "instance_storage", instance_storage)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if maintain_time is not None:
            pulumi.set(__self__, "maintain_time", maintain_time)
        if manual_ha_time is not None:
            pulumi.set(__self__, "manual_ha_time", manual_ha_time)
        if modify_mode is not None:
            pulumi.set(__self__, "modify_mode", modify_mode)
        if monitoring_period is not None:
            pulumi.set(__self__, "monitoring_period", monitoring_period)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if pg_hba_confs is not None:
            pulumi.set(__self__, "pg_hba_confs", pg_hba_confs)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if released_keep_policy is not None:
            pulumi.set(__self__, "released_keep_policy", released_keep_policy)
        if replication_acl is not None:
            pulumi.set(__self__, "replication_acl", replication_acl)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if restore_time is not None:
            pulumi.set(__self__, "restore_time", restore_time)
        if restore_type is not None:
            pulumi.set(__self__, "restore_type", restore_type)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if security_ip_mode is not None:
            pulumi.set(__self__, "security_ip_mode", security_ip_mode)
        if security_ip_type is not None:
            pulumi.set(__self__, "security_ip_type", security_ip_type)
        if security_ips is not None:
            pulumi.set(__self__, "security_ips", security_ips)
        if server_cert is not None:
            pulumi.set(__self__, "server_cert", server_cert)
        if server_key is not None:
            pulumi.set(__self__, "server_key", server_key)
        if source_db_instance_name is not None:
            pulumi.set(__self__, "source_db_instance_name", source_db_instance_name)
        if source_region is not None:
            pulumi.set(__self__, "source_region", source_region)
        if sql_collector_config_value is not None:
            pulumi.set(__self__, "sql_collector_config_value", sql_collector_config_value)
        if sql_collector_status is not None:
            pulumi.set(__self__, "sql_collector_status", sql_collector_status)
        if ssl_action is not None:
            pulumi.set(__self__, "ssl_action", ssl_action)
        if ssl_status is not None:
            pulumi.set(__self__, "ssl_status", ssl_status)
        if storage_auto_scale is not None:
            pulumi.set(__self__, "storage_auto_scale", storage_auto_scale)
        if storage_threshold is not None:
            pulumi.set(__self__, "storage_threshold", storage_threshold)
        if storage_upper_bound is not None:
            pulumi.set(__self__, "storage_upper_bound", storage_upper_bound)
        if switch_time is not None:
            pulumi.set(__self__, "switch_time", switch_time)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_minor_version is not None:
            pulumi.set(__self__, "target_minor_version", target_minor_version)
        if tcp_connection_type is not None:
            pulumi.set(__self__, "tcp_connection_type", tcp_connection_type)
        if tde_status is not None:
            pulumi.set(__self__, "tde_status", tde_status)
        if upgrade_db_instance_kernel_version is not None:
            pulumi.set(__self__, "upgrade_db_instance_kernel_version", upgrade_db_instance_kernel_version)
        if upgrade_time is not None:
            pulumi.set(__self__, "upgrade_time", upgrade_time)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if whitelist_network_type is not None:
            pulumi.set(__self__, "whitelist_network_type", whitelist_network_type)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)
        if zone_id_slave_a is not None:
            pulumi.set(__self__, "zone_id_slave_a", zone_id_slave_a)
        if zone_id_slave_b is not None:
            pulumi.set(__self__, "zone_id_slave_b", zone_id_slave_b)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[str]]:
        """
        The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to renewal a DB instance automatically or not. It is valid when payment_type is `Subscription`. Default to `false`.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        Auto-renewal period of an instance, in the unit of the month. It is valid when payment_type is `Subscription`. Valid value:[1~12], Default to 1.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_period", value)

    @property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[pulumi.Input[str]]:
        """
        The upgrade method to use. Valid values:
        - Auto: Instances are automatically upgraded to a higher minor version.
        - Manual: Instances are forcibly upgraded to a higher minor version when the current version is unpublished.

        See more [details and limitation](https://www.alibabacloud.com/help/doc-detail/123605.htm).
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @auto_upgrade_minor_version.setter
    def auto_upgrade_minor_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_upgrade_minor_version", value)

    @property
    @pulumi.getter(name="backupSetId")
    def backup_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the backup set that is used for the restoration. You can call the DescribeCrossRegionBackups operation to query the ID of the backup set.
        """
        return pulumi.get(self, "backup_set_id")

    @backup_set_id.setter
    def backup_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_id", value)

    @property
    @pulumi.getter(name="caType")
    def ca_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. Value range:
        - aliyun: a cloud certificate
        - custom: a custom certificate
        """
        return pulumi.get(self, "ca_type")

    @ca_type.setter
    def ca_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_type", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        The RDS edition of the instance.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="clientCaCert")
    def client_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter.
        """
        return pulumi.get(self, "client_ca_cert")

    @client_ca_cert.setter
    def client_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_ca_cert", value)

    @property
    @pulumi.getter(name="clientCaEnabled")
    def client_ca_enabled(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
        - 1: enables the public key
        - 0: disables the public key
        """
        return pulumi.get(self, "client_ca_enabled")

    @client_ca_enabled.setter
    def client_ca_enabled(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "client_ca_enabled", value)

    @property
    @pulumi.getter(name="clientCertRevocationList")
    def client_cert_revocation_list(self) -> Optional[pulumi.Input[str]]:
        """
        The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter.
        """
        return pulumi.get(self, "client_cert_revocation_list")

    @client_cert_revocation_list.setter
    def client_cert_revocation_list(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_cert_revocation_list", value)

    @property
    @pulumi.getter(name="clientCrlEnabled")
    def client_crl_enabled(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
        - 1: enables the CRL
        - 0: disables the CRL
        """
        return pulumi.get(self, "client_crl_enabled")

    @client_crl_enabled.setter
    def client_crl_enabled(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "client_crl_enabled", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        RDS database connection string.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="connectionStringPrefix")
    def connection_string_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The private connection string prefix. If you want to update public connection string prefix, please use resource rds.Connection connection_prefix. 
        > **NOTE:** The prefix must be 8 to 64 characters in length and can contain letters, digits, and hyphens (-). It cannot contain Chinese characters and special characters ~!#%^&*=+\\|{};:'",<>/?
        """
        return pulumi.get(self, "connection_string_prefix")

    @connection_string_prefix.setter
    def connection_string_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string_prefix", value)

    @property
    @pulumi.getter(name="dbInstanceIpArrayAttribute")
    def db_instance_ip_array_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        The attribute of the IP address whitelist. By default, this parameter is empty.

        > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
        """
        return pulumi.get(self, "db_instance_ip_array_attribute")

    @db_instance_ip_array_attribute.setter
    def db_instance_ip_array_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_instance_ip_array_attribute", value)

    @property
    @pulumi.getter(name="dbInstanceIpArrayName")
    def db_instance_ip_array_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the IP address whitelist. Default value: Default.

        > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
        """
        return pulumi.get(self, "db_instance_ip_array_name")

    @db_instance_ip_array_name.setter
    def db_instance_ip_array_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_instance_ip_array_name", value)

    @property
    @pulumi.getter(name="dbInstanceStorageType")
    def db_instance_storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        The storage type of the instance. Valid values:
        - local_ssd: specifies to use local SSDs. This value is recommended.
        - cloud_ssd: specifies to use standard SSDs.
        - cloud_essd: specifies to use enhanced SSDs (ESSDs).
        - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
        - cloud_essd3: specifies to use enhanced SSDs (ESSDs).

        > **NOTE:** You can specify the time zone when you create a primary instance. You cannot specify the time zone when you create a read-only instance. Read-only instances inherit the time zone of their primary instance. If you do not specify this parameter, the system assigns the default time zone of the region where the instance resides.
        """
        return pulumi.get(self, "db_instance_storage_type")

    @db_instance_storage_type.setter
    def db_instance_storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_instance_storage_type", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        The switch of delete protection. Valid values: 
        - true: delete protect.
        - false: no delete protect.

        > **NOTE:** `deletion_protection` is valid only when attribute `payment_type` is set to `PayAsYouGo`, supported engine type: **MySQL**, **PostgreSQL**, **MariaDB**, **MSSQL**.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[pulumi.Input[str]]:
        """
        The method to update the engine version and change.  Default value: Immediate. Valid values:
        - Immediate: The change immediately takes effect.
        - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
        """
        return pulumi.get(self, "effective_time")

    @effective_time.setter
    def effective_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effective_time", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[str]]:
        """
        The key id of the KMS. Used for encrypting a disk if not null. Only for PostgreSQL, MySQL and SQLServer.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        """
        Database type. Value options: MySQL, SQLServer.

        > **NOTE:** When the 'EngineVersion' changes, it can be used as the target database version for the large version upgrade of RDS for MySQL instance.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Database version. Value options can refer to the latest docs [CreateDdrInstance](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/restore-data-to-a-new-instance-across-regions) `EngineVersion`.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> Optional[pulumi.Input[bool]]:
        """
        Set it to true to make some parameter efficient when modifying them. Default to false.
        """
        return pulumi.get(self, "force_restart")

    @force_restart.setter
    def force_restart(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_restart", value)

    @property
    @pulumi.getter(name="freshWhiteListReadins")
    def fresh_white_list_readins(self) -> Optional[pulumi.Input[str]]:
        """
        The read-only instances to which you want to synchronize the IP address whitelist.
        * If the instance is attached with a read-only instance, you can use this parameter to synchronize the IP address whitelist to the read-only instance. If the instance is attached with multiple read-only instances, the read-only instances must be separated by commas (,).
        * If the instance is not attached with a read-only instance, this parameter is empty.
        """
        return pulumi.get(self, "fresh_white_list_readins")

    @fresh_white_list_readins.setter
    def fresh_white_list_readins(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fresh_white_list_readins", value)

    @property
    @pulumi.getter(name="haConfig")
    def ha_config(self) -> Optional[pulumi.Input[str]]:
        """
        The primary/secondary switchover mode of the instance. Default value: Auto. Valid values:
        - Auto: The system automatically switches over services from the primary to secondary instances in the event of a fault.
        - Manual: You must manually switch over services from the primary to secondary instances in the event of a fault.

        > **NOTE:** If you set this parameter to Manual, you must specify the ManualHATime parameter.
        """
        return pulumi.get(self, "ha_config")

    @ha_config.setter
    def ha_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_config", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of DB instance. It a string of 2 to 256 characters.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceStorage")
    def instance_storage(self) -> Optional[pulumi.Input[int]]:
        """
        The storage capacity of the destination instance. Valid values: 5 to 2000. Unit: GB.

        This value must be a multiple of 5 GB. For more information, see Primary ApsaraDB RDS instance types.
        """
        return pulumi.get(self, "instance_storage")

    @instance_storage.setter
    def instance_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_storage", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        DB Instance type.

        > **NOTE:** When `storage_auto_scale="Enable"`, do not perform `instance_storage` check. when `storage_auto_scale="Disable"`, if the instance itself `instance_storage`has changed. You need to manually revise the `instance_storage` in the template value.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="maintainTime")
    def maintain_time(self) -> Optional[pulumi.Input[str]]:
        """
        Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
        """
        return pulumi.get(self, "maintain_time")

    @maintain_time.setter
    def maintain_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_time", value)

    @property
    @pulumi.getter(name="manualHaTime")
    def manual_ha_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time after when you want to enable automatic primary/secondary switchover. At most, you can set this parameter to 23:59:59 seven days later. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.

        > **NOTE:** This parameter only takes effect when the HAConfig parameter is set to Manual.
        """
        return pulumi.get(self, "manual_ha_time")

    @manual_ha_time.setter
    def manual_ha_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manual_ha_time", value)

    @property
    @pulumi.getter(name="modifyMode")
    def modify_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
        - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
        - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
        - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
        """
        return pulumi.get(self, "modify_mode")

    @modify_mode.setter
    def modify_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modify_mode", value)

    @property
    @pulumi.getter(name="monitoringPeriod")
    def monitoring_period(self) -> Optional[pulumi.Input[int]]:
        """
        The monitoring frequency in seconds. Valid values are 5, 60, 300. Defaults to 300.
        """
        return pulumi.get(self, "monitoring_period")

    @monitoring_period.setter
    def monitoring_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "monitoring_period", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DdrInstanceParameterArgs']]]]:
        """
        Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DdrInstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        Valid values are `Subscription`, `PayAsYouGo`, Default to `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The duration that you will buy DB instance (in month). It is valid when payment_type is `Subscription`. Valid values: [1~9], 12, 24, 36.
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="pgHbaConfs")
    def pg_hba_confs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DdrInstancePgHbaConfArgs']]]]:
        """
        The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
        """
        return pulumi.get(self, "pg_hba_confs")

    @pg_hba_confs.setter
    def pg_hba_confs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DdrInstancePgHbaConfArgs']]]]):
        pulumi.set(self, "pg_hba_confs", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        The private port of the database service. If you want to update public port, please use resource rds.Connection port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The private IP address of the instance. The private IP address must be within the Classless Inter-Domain Routing (CIDR) block of the vSwitch that is specified by the VSwitchId parameter.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="releasedKeepPolicy")
    def released_keep_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The policy based on which ApsaraDB RDS retains archived backup files after the instance is released. Valid values:
        - None: No archived backup files are retained.
        - Lastest: Only the last archived backup file is retained.
        - All: All the archived backup files are retained.

        > **NOTE:** This parameter is supported only when the instance runs the MySQL database engine.
        """
        return pulumi.get(self, "released_keep_policy")

    @released_keep_policy.setter
    def released_keep_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "released_keep_policy", value)

    @property
    @pulumi.getter(name="replicationAcl")
    def replication_acl(self) -> Optional[pulumi.Input[str]]:
        """
        The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        """
        return pulumi.get(self, "replication_acl")

    @replication_acl.setter
    def replication_acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_acl", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of resource group which the DB instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="restoreTime")
    def restore_time(self) -> Optional[pulumi.Input[str]]:
        """
        The point in time to which you want to restore data. The point in time that you specify must be earlier than the current time. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        """
        return pulumi.get(self, "restore_time")

    @restore_time.setter
    def restore_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restore_time", value)

    @property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> Optional[pulumi.Input[str]]:
        """
        The method that is used to restore data. Valid values:
        - BackupSet: Data is restored from a backup set. If you use this value, you must also specify the BackupSetID parameter.
        - BackupTime: restores data to a point in time. You must also specify the RestoreTime, SourceRegion, and SourceDBInstanceName parameters.
        """
        return pulumi.get(self, "restore_type")

    @restore_type.setter
    def restore_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restore_type", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        ) The list IDs to join ECS Security Group. At most supports three security groups.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="securityIpMode")
    def security_ip_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Valid values are `normal`, `safety`, Default to `normal`. support `safety` switch to high security access mode.
        """
        return pulumi.get(self, "security_ip_mode")

    @security_ip_mode.setter
    def security_ip_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_ip_mode", value)

    @property
    @pulumi.getter(name="securityIpType")
    def security_ip_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of IP address in the IP address whitelist.
        """
        return pulumi.get(self, "security_ip_type")

    @security_ip_type.setter
    def security_ip_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_ip_type", value)

    @property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        """
        return pulumi.get(self, "security_ips")

    @security_ips.setter
    def security_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_ips", value)

    @property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
        """
        return pulumi.get(self, "server_cert")

    @server_cert.setter
    def server_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_cert", value)

    @property
    @pulumi.getter(name="serverKey")
    def server_key(self) -> Optional[pulumi.Input[str]]:
        """
        The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
        """
        return pulumi.get(self, "server_key")

    @server_key.setter
    def server_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_key", value)

    @property
    @pulumi.getter(name="sourceDbInstanceName")
    def source_db_instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the source instance if you want to restore data to a point in time.
        """
        return pulumi.get(self, "source_db_instance_name")

    @source_db_instance_name.setter
    def source_db_instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_db_instance_name", value)

    @property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region ID of the source instance if you want to restore data to a point in time.
        """
        return pulumi.get(self, "source_region")

    @source_region.setter
    def source_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_region", value)

    @property
    @pulumi.getter(name="sqlCollectorConfigValue")
    def sql_collector_config_value(self) -> Optional[pulumi.Input[int]]:
        """
        The sql collector keep time of the instance. Valid values are `30`, `180`, `365`, `1095`, `1825`, Default to `30`.
        """
        return pulumi.get(self, "sql_collector_config_value")

    @sql_collector_config_value.setter
    def sql_collector_config_value(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sql_collector_config_value", value)

    @property
    @pulumi.getter(name="sqlCollectorStatus")
    def sql_collector_status(self) -> Optional[pulumi.Input[str]]:
        """
        The sql collector status of the instance. Valid values are `Enabled`, `Disabled`, Default to `Disabled`.
        """
        return pulumi.get(self, "sql_collector_status")

    @sql_collector_status.setter
    def sql_collector_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql_collector_status", value)

    @property
    @pulumi.getter(name="sslAction")
    def ssl_action(self) -> Optional[pulumi.Input[str]]:
        """
        Actions performed on SSL functions, Valid values: `Open`: turn on SSL encryption; `Close`: turn off SSL encryption; `Update`: update SSL certificate. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26254.htm).
        """
        return pulumi.get(self, "ssl_action")

    @ssl_action.setter
    def ssl_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_action", value)

    @property
    @pulumi.getter(name="sslStatus")
    def ssl_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the SSL feature. `Yes`: SSL is turned on; `No`: SSL is turned off.
        """
        return pulumi.get(self, "ssl_status")

    @ssl_status.setter
    def ssl_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_status", value)

    @property
    @pulumi.getter(name="storageAutoScale")
    def storage_auto_scale(self) -> Optional[pulumi.Input[str]]:
        """
        Automatic storage space expansion switch. Valid values:
        - Enable
        - Disable

        > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable.
        """
        return pulumi.get(self, "storage_auto_scale")

    @storage_auto_scale.setter
    def storage_auto_scale(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_auto_scale", value)

    @property
    @pulumi.getter(name="storageThreshold")
    def storage_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The trigger threshold (percentage) for automatic storage space expansion. Valid values:
        - 10
        - 20
        - 30
        - 40
        - 50

        > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable. The value must be greater than or equal to the total size of the current storage space of the instance.
        """
        return pulumi.get(self, "storage_threshold")

    @storage_threshold.setter
    def storage_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_threshold", value)

    @property
    @pulumi.getter(name="storageUpperBound")
    def storage_upper_bound(self) -> Optional[pulumi.Input[int]]:
        """
        The upper limit of the total storage space for automatic expansion of the storage space, that is, automatic expansion will not cause the total storage space of the instance to exceed this value. Unit: GB. The value must be ≥0.

        > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
        """
        return pulumi.get(self, "storage_upper_bound")

    @storage_upper_bound.setter
    def storage_upper_bound(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_upper_bound", value)

    @property
    @pulumi.getter(name="switchTime")
    def switch_time(self) -> Optional[pulumi.Input[str]]:
        """
        The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `upgrade_db_instance_kernel_version = true`. The time must be in UTC.

        > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
        """
        return pulumi.get(self, "switch_time")

    @switch_time.setter
    def switch_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "switch_time", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetMinorVersion")
    def target_minor_version(self) -> Optional[pulumi.Input[str]]:
        """
        The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. It is valid only when `upgrade_db_instance_kernel_version = true`. You must specify the minor engine version in one of the following formats:
        - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
        - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
        - rds: The instance runs RDS Basic or High-availability Edition.
        - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
        - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
        - SQLServer: <Minor engine version>. Example: 15.0.4073.23.

        > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
        """
        return pulumi.get(self, "target_minor_version")

    @target_minor_version.setter
    def target_minor_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_minor_version", value)

    @property
    @pulumi.getter(name="tcpConnectionType")
    def tcp_connection_type(self) -> Optional[pulumi.Input[str]]:
        """
        The availability check method of the instance. Valid values:
        - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
        - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
        """
        return pulumi.get(self, "tcp_connection_type")

    @tcp_connection_type.setter
    def tcp_connection_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tcp_connection_type", value)

    @property
    @pulumi.getter(name="tdeStatus")
    def tde_status(self) -> Optional[pulumi.Input[str]]:
        """
        The TDE(Transparent Data Encryption) status. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26256.htm).
        """
        return pulumi.get(self, "tde_status")

    @tde_status.setter
    def tde_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tde_status", value)

    @property
    @pulumi.getter(name="upgradeDbInstanceKernelVersion")
    def upgrade_db_instance_kernel_version(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to upgrade a minor version of the kernel. Valid values:
        - true: upgrade
        - false: not to upgrade
        """
        return pulumi.get(self, "upgrade_db_instance_kernel_version")

    @upgrade_db_instance_kernel_version.setter
    def upgrade_db_instance_kernel_version(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "upgrade_db_instance_kernel_version", value)

    @property
    @pulumi.getter(name="upgradeTime")
    def upgrade_time(self) -> Optional[pulumi.Input[str]]:
        """
        The method to update the minor engine version. Default value: Immediate. It is valid only when `upgrade_db_instance_kernel_version = true`. Valid values:
        - Immediate: The minor engine version is immediately updated.
        - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
        - SpecifyTime: The minor engine version is updated at the point in time you specify.
        """
        return pulumi.get(self, "upgrade_time")

    @upgrade_time.setter
    def upgrade_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "upgrade_time", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC ID of the instance.

        > **NOTE:** This parameter applies only to ApsaraDB RDS for MySQL instances. For more information about Upgrade the major engine version of an ApsaraDB RDS for MySQL instance, see [Upgrade the major engine version of an RDS instance in the ApsaraDB RDS console](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/upgrade-the-major-engine-version-of-an-apsaradb-rds-for-mysql-instance-1).
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The virtual switch ID to launch DB instances in one VPC. If there are multiple vswitches, separate them with commas.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="whitelistNetworkType")
    def whitelist_network_type(self) -> Optional[pulumi.Input[str]]:
        """
        The network type of the IP address whitelist. Default value: MIX. Valid values:
        - Classic: classic network in enhanced whitelist mode
        - VPC: virtual private cloud (VPC) in enhanced whitelist mode
        - MIX: standard whitelist mode

        > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
        """
        return pulumi.get(self, "whitelist_network_type")

    @whitelist_network_type.setter
    def whitelist_network_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "whitelist_network_type", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Zone to launch the DB instance. It supports multiple zone.
        If it is a multi-zone and `vswitch_id` is specified, the vswitch must in the one of them.
        The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `get_zones`.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="zoneIdSlaveA")
    def zone_id_slave_a(self) -> Optional[pulumi.Input[str]]:
        """
        The region ID of the secondary instance if you create a secondary instance.
        """
        return pulumi.get(self, "zone_id_slave_a")

    @zone_id_slave_a.setter
    def zone_id_slave_a(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id_slave_a", value)

    @property
    @pulumi.getter(name="zoneIdSlaveB")
    def zone_id_slave_b(self) -> Optional[pulumi.Input[str]]:
        """
        The region ID of the log instance if you create a log instance.
        """
        return pulumi.get(self, "zone_id_slave_b")

    @zone_id_slave_b.setter
    def zone_id_slave_b(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id_slave_b", value)


class DdrInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 auto_upgrade_minor_version: Optional[pulumi.Input[str]] = None,
                 backup_set_id: Optional[pulumi.Input[str]] = None,
                 ca_type: Optional[pulumi.Input[str]] = None,
                 client_ca_cert: Optional[pulumi.Input[str]] = None,
                 client_ca_enabled: Optional[pulumi.Input[int]] = None,
                 client_cert_revocation_list: Optional[pulumi.Input[str]] = None,
                 client_crl_enabled: Optional[pulumi.Input[int]] = None,
                 connection_string_prefix: Optional[pulumi.Input[str]] = None,
                 db_instance_ip_array_attribute: Optional[pulumi.Input[str]] = None,
                 db_instance_ip_array_name: Optional[pulumi.Input[str]] = None,
                 db_instance_storage_type: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 effective_time: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 force_restart: Optional[pulumi.Input[bool]] = None,
                 fresh_white_list_readins: Optional[pulumi.Input[str]] = None,
                 ha_config: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_storage: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 maintain_time: Optional[pulumi.Input[str]] = None,
                 manual_ha_time: Optional[pulumi.Input[str]] = None,
                 modify_mode: Optional[pulumi.Input[str]] = None,
                 monitoring_period: Optional[pulumi.Input[int]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DdrInstanceParameterArgs']]]]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 pg_hba_confs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DdrInstancePgHbaConfArgs']]]]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 released_keep_policy: Optional[pulumi.Input[str]] = None,
                 replication_acl: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 restore_time: Optional[pulumi.Input[str]] = None,
                 restore_type: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_ip_mode: Optional[pulumi.Input[str]] = None,
                 security_ip_type: Optional[pulumi.Input[str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 server_cert: Optional[pulumi.Input[str]] = None,
                 server_key: Optional[pulumi.Input[str]] = None,
                 source_db_instance_name: Optional[pulumi.Input[str]] = None,
                 source_region: Optional[pulumi.Input[str]] = None,
                 sql_collector_config_value: Optional[pulumi.Input[int]] = None,
                 sql_collector_status: Optional[pulumi.Input[str]] = None,
                 ssl_action: Optional[pulumi.Input[str]] = None,
                 storage_auto_scale: Optional[pulumi.Input[str]] = None,
                 storage_threshold: Optional[pulumi.Input[int]] = None,
                 storage_upper_bound: Optional[pulumi.Input[int]] = None,
                 switch_time: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_minor_version: Optional[pulumi.Input[str]] = None,
                 tcp_connection_type: Optional[pulumi.Input[str]] = None,
                 tde_status: Optional[pulumi.Input[str]] = None,
                 upgrade_db_instance_kernel_version: Optional[pulumi.Input[bool]] = None,
                 upgrade_time: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 whitelist_network_type: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        RDS ddr instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:rds/ddrInstance:DdrInstance example rm-abc12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] acl: The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param pulumi.Input[bool] auto_renew: Whether to renewal a DB instance automatically or not. It is valid when payment_type is `Subscription`. Default to `false`.
        :param pulumi.Input[int] auto_renew_period: Auto-renewal period of an instance, in the unit of the month. It is valid when payment_type is `Subscription`. Valid value:[1~12], Default to 1.
        :param pulumi.Input[str] auto_upgrade_minor_version: The upgrade method to use. Valid values:
               - Auto: Instances are automatically upgraded to a higher minor version.
               - Manual: Instances are forcibly upgraded to a higher minor version when the current version is unpublished.
               
               See more [details and limitation](https://www.alibabacloud.com/help/doc-detail/123605.htm).
        :param pulumi.Input[str] backup_set_id: The ID of the backup set that is used for the restoration. You can call the DescribeCrossRegionBackups operation to query the ID of the backup set.
        :param pulumi.Input[str] ca_type: The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. Value range:
               - aliyun: a cloud certificate
               - custom: a custom certificate
        :param pulumi.Input[str] client_ca_cert: The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter.
        :param pulumi.Input[int] client_ca_enabled: Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
               - 1: enables the public key
               - 0: disables the public key
        :param pulumi.Input[str] client_cert_revocation_list: The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter.
        :param pulumi.Input[int] client_crl_enabled: Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - 1: enables the CRL
               - 0: disables the CRL
        :param pulumi.Input[str] connection_string_prefix: The private connection string prefix. If you want to update public connection string prefix, please use resource rds.Connection connection_prefix. 
               > **NOTE:** The prefix must be 8 to 64 characters in length and can contain letters, digits, and hyphens (-). It cannot contain Chinese characters and special characters ~!#%^&*=+\\|{};:'",<>/?
        :param pulumi.Input[str] db_instance_ip_array_attribute: The attribute of the IP address whitelist. By default, this parameter is empty.
               
               > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
        :param pulumi.Input[str] db_instance_ip_array_name: The name of the IP address whitelist. Default value: Default.
               
               > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
        :param pulumi.Input[str] db_instance_storage_type: The storage type of the instance. Valid values:
               - local_ssd: specifies to use local SSDs. This value is recommended.
               - cloud_ssd: specifies to use standard SSDs.
               - cloud_essd: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
               
               > **NOTE:** You can specify the time zone when you create a primary instance. You cannot specify the time zone when you create a read-only instance. Read-only instances inherit the time zone of their primary instance. If you do not specify this parameter, the system assigns the default time zone of the region where the instance resides.
        :param pulumi.Input[bool] deletion_protection: The switch of delete protection. Valid values: 
               - true: delete protect.
               - false: no delete protect.
               
               > **NOTE:** `deletion_protection` is valid only when attribute `payment_type` is set to `PayAsYouGo`, supported engine type: **MySQL**, **PostgreSQL**, **MariaDB**, **MSSQL**.
        :param pulumi.Input[str] effective_time: The method to update the engine version and change.  Default value: Immediate. Valid values:
               - Immediate: The change immediately takes effect.
               - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
        :param pulumi.Input[str] encryption_key: The key id of the KMS. Used for encrypting a disk if not null. Only for PostgreSQL, MySQL and SQLServer.
        :param pulumi.Input[str] engine: Database type. Value options: MySQL, SQLServer.
               
               > **NOTE:** When the 'EngineVersion' changes, it can be used as the target database version for the large version upgrade of RDS for MySQL instance.
        :param pulumi.Input[str] engine_version: Database version. Value options can refer to the latest docs [CreateDdrInstance](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/restore-data-to-a-new-instance-across-regions) `EngineVersion`.
        :param pulumi.Input[bool] force_restart: Set it to true to make some parameter efficient when modifying them. Default to false.
        :param pulumi.Input[str] fresh_white_list_readins: The read-only instances to which you want to synchronize the IP address whitelist.
               * If the instance is attached with a read-only instance, you can use this parameter to synchronize the IP address whitelist to the read-only instance. If the instance is attached with multiple read-only instances, the read-only instances must be separated by commas (,).
               * If the instance is not attached with a read-only instance, this parameter is empty.
        :param pulumi.Input[str] ha_config: The primary/secondary switchover mode of the instance. Default value: Auto. Valid values:
               - Auto: The system automatically switches over services from the primary to secondary instances in the event of a fault.
               - Manual: You must manually switch over services from the primary to secondary instances in the event of a fault.
               
               > **NOTE:** If you set this parameter to Manual, you must specify the ManualHATime parameter.
        :param pulumi.Input[str] instance_name: The name of DB instance. It a string of 2 to 256 characters.
        :param pulumi.Input[int] instance_storage: The storage capacity of the destination instance. Valid values: 5 to 2000. Unit: GB.
               
               This value must be a multiple of 5 GB. For more information, see Primary ApsaraDB RDS instance types.
        :param pulumi.Input[str] instance_type: DB Instance type.
               
               > **NOTE:** When `storage_auto_scale="Enable"`, do not perform `instance_storage` check. when `storage_auto_scale="Disable"`, if the instance itself `instance_storage`has changed. You need to manually revise the `instance_storage` in the template value.
        :param pulumi.Input[str] maintain_time: Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
        :param pulumi.Input[str] manual_ha_time: The time after when you want to enable automatic primary/secondary switchover. At most, you can set this parameter to 23:59:59 seven days later. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
               
               > **NOTE:** This parameter only takes effect when the HAConfig parameter is set to Manual.
        :param pulumi.Input[str] modify_mode: The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
               - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
               - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
               - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
        :param pulumi.Input[int] monitoring_period: The monitoring frequency in seconds. Valid values are 5, 60, 300. Defaults to 300.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DdrInstanceParameterArgs']]]] parameters: Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
        :param pulumi.Input[str] payment_type: Valid values are `Subscription`, `PayAsYouGo`, Default to `PayAsYouGo`.
        :param pulumi.Input[int] period: The duration that you will buy DB instance (in month). It is valid when payment_type is `Subscription`. Valid values: [1~9], 12, 24, 36.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DdrInstancePgHbaConfArgs']]]] pg_hba_confs: The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
        :param pulumi.Input[str] port: The private port of the database service. If you want to update public port, please use resource rds.Connection port.
        :param pulumi.Input[str] private_ip_address: The private IP address of the instance. The private IP address must be within the Classless Inter-Domain Routing (CIDR) block of the vSwitch that is specified by the VSwitchId parameter.
        :param pulumi.Input[str] released_keep_policy: The policy based on which ApsaraDB RDS retains archived backup files after the instance is released. Valid values:
               - None: No archived backup files are retained.
               - Lastest: Only the last archived backup file is retained.
               - All: All the archived backup files are retained.
               
               > **NOTE:** This parameter is supported only when the instance runs the MySQL database engine.
        :param pulumi.Input[str] replication_acl: The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param pulumi.Input[str] resource_group_id: The ID of resource group which the DB instance belongs.
        :param pulumi.Input[str] restore_time: The point in time to which you want to restore data. The point in time that you specify must be earlier than the current time. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        :param pulumi.Input[str] restore_type: The method that is used to restore data. Valid values:
               - BackupSet: Data is restored from a backup set. If you use this value, you must also specify the BackupSetID parameter.
               - BackupTime: restores data to a point in time. You must also specify the RestoreTime, SourceRegion, and SourceDBInstanceName parameters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: ) The list IDs to join ECS Security Group. At most supports three security groups.
        :param pulumi.Input[str] security_ip_mode: Valid values are `normal`, `safety`, Default to `normal`. support `safety` switch to high security access mode.
        :param pulumi.Input[str] security_ip_type: The type of IP address in the IP address whitelist.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_ips: List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        :param pulumi.Input[str] server_cert: The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
        :param pulumi.Input[str] server_key: The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
        :param pulumi.Input[str] source_db_instance_name: The ID of the source instance if you want to restore data to a point in time.
        :param pulumi.Input[str] source_region: The region ID of the source instance if you want to restore data to a point in time.
        :param pulumi.Input[int] sql_collector_config_value: The sql collector keep time of the instance. Valid values are `30`, `180`, `365`, `1095`, `1825`, Default to `30`.
        :param pulumi.Input[str] sql_collector_status: The sql collector status of the instance. Valid values are `Enabled`, `Disabled`, Default to `Disabled`.
        :param pulumi.Input[str] ssl_action: Actions performed on SSL functions, Valid values: `Open`: turn on SSL encryption; `Close`: turn off SSL encryption; `Update`: update SSL certificate. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26254.htm).
        :param pulumi.Input[str] storage_auto_scale: Automatic storage space expansion switch. Valid values:
               - Enable
               - Disable
               
               > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable.
        :param pulumi.Input[int] storage_threshold: The trigger threshold (percentage) for automatic storage space expansion. Valid values:
               - 10
               - 20
               - 30
               - 40
               - 50
               
               > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable. The value must be greater than or equal to the total size of the current storage space of the instance.
        :param pulumi.Input[int] storage_upper_bound: The upper limit of the total storage space for automatic expansion of the storage space, that is, automatic expansion will not cause the total storage space of the instance to exceed this value. Unit: GB. The value must be ≥0.
               
               > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
        :param pulumi.Input[str] switch_time: The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `upgrade_db_instance_kernel_version = true`. The time must be in UTC.
               
               > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[str] target_minor_version: The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. It is valid only when `upgrade_db_instance_kernel_version = true`. You must specify the minor engine version in one of the following formats:
               - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
               - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
               - rds: The instance runs RDS Basic or High-availability Edition.
               - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
               - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
               - SQLServer: <Minor engine version>. Example: 15.0.4073.23.
               
               > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
        :param pulumi.Input[str] tcp_connection_type: The availability check method of the instance. Valid values:
               - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
               - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
        :param pulumi.Input[str] tde_status: The TDE(Transparent Data Encryption) status. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26256.htm).
        :param pulumi.Input[bool] upgrade_db_instance_kernel_version: Whether to upgrade a minor version of the kernel. Valid values:
               - true: upgrade
               - false: not to upgrade
        :param pulumi.Input[str] upgrade_time: The method to update the minor engine version. Default value: Immediate. It is valid only when `upgrade_db_instance_kernel_version = true`. Valid values:
               - Immediate: The minor engine version is immediately updated.
               - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
               - SpecifyTime: The minor engine version is updated at the point in time you specify.
        :param pulumi.Input[str] vpc_id: The VPC ID of the instance.
               
               > **NOTE:** This parameter applies only to ApsaraDB RDS for MySQL instances. For more information about Upgrade the major engine version of an ApsaraDB RDS for MySQL instance, see [Upgrade the major engine version of an RDS instance in the ApsaraDB RDS console](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/upgrade-the-major-engine-version-of-an-apsaradb-rds-for-mysql-instance-1).
        :param pulumi.Input[str] vswitch_id: The virtual switch ID to launch DB instances in one VPC. If there are multiple vswitches, separate them with commas.
        :param pulumi.Input[str] whitelist_network_type: The network type of the IP address whitelist. Default value: MIX. Valid values:
               - Classic: classic network in enhanced whitelist mode
               - VPC: virtual private cloud (VPC) in enhanced whitelist mode
               - MIX: standard whitelist mode
               
               > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
        :param pulumi.Input[str] zone_id: The Zone to launch the DB instance. It supports multiple zone.
               If it is a multi-zone and `vswitch_id` is specified, the vswitch must in the one of them.
               The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `get_zones`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DdrInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        RDS ddr instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:rds/ddrInstance:DdrInstance example rm-abc12345678
        ```

        :param str resource_name: The name of the resource.
        :param DdrInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DdrInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 auto_upgrade_minor_version: Optional[pulumi.Input[str]] = None,
                 backup_set_id: Optional[pulumi.Input[str]] = None,
                 ca_type: Optional[pulumi.Input[str]] = None,
                 client_ca_cert: Optional[pulumi.Input[str]] = None,
                 client_ca_enabled: Optional[pulumi.Input[int]] = None,
                 client_cert_revocation_list: Optional[pulumi.Input[str]] = None,
                 client_crl_enabled: Optional[pulumi.Input[int]] = None,
                 connection_string_prefix: Optional[pulumi.Input[str]] = None,
                 db_instance_ip_array_attribute: Optional[pulumi.Input[str]] = None,
                 db_instance_ip_array_name: Optional[pulumi.Input[str]] = None,
                 db_instance_storage_type: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 effective_time: Optional[pulumi.Input[str]] = None,
                 encryption_key: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 force_restart: Optional[pulumi.Input[bool]] = None,
                 fresh_white_list_readins: Optional[pulumi.Input[str]] = None,
                 ha_config: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_storage: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 maintain_time: Optional[pulumi.Input[str]] = None,
                 manual_ha_time: Optional[pulumi.Input[str]] = None,
                 modify_mode: Optional[pulumi.Input[str]] = None,
                 monitoring_period: Optional[pulumi.Input[int]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DdrInstanceParameterArgs']]]]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 pg_hba_confs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DdrInstancePgHbaConfArgs']]]]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 released_keep_policy: Optional[pulumi.Input[str]] = None,
                 replication_acl: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 restore_time: Optional[pulumi.Input[str]] = None,
                 restore_type: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_ip_mode: Optional[pulumi.Input[str]] = None,
                 security_ip_type: Optional[pulumi.Input[str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 server_cert: Optional[pulumi.Input[str]] = None,
                 server_key: Optional[pulumi.Input[str]] = None,
                 source_db_instance_name: Optional[pulumi.Input[str]] = None,
                 source_region: Optional[pulumi.Input[str]] = None,
                 sql_collector_config_value: Optional[pulumi.Input[int]] = None,
                 sql_collector_status: Optional[pulumi.Input[str]] = None,
                 ssl_action: Optional[pulumi.Input[str]] = None,
                 storage_auto_scale: Optional[pulumi.Input[str]] = None,
                 storage_threshold: Optional[pulumi.Input[int]] = None,
                 storage_upper_bound: Optional[pulumi.Input[int]] = None,
                 switch_time: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_minor_version: Optional[pulumi.Input[str]] = None,
                 tcp_connection_type: Optional[pulumi.Input[str]] = None,
                 tde_status: Optional[pulumi.Input[str]] = None,
                 upgrade_db_instance_kernel_version: Optional[pulumi.Input[bool]] = None,
                 upgrade_time: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 whitelist_network_type: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DdrInstanceArgs.__new__(DdrInstanceArgs)

            __props__.__dict__["acl"] = acl
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["auto_renew_period"] = auto_renew_period
            __props__.__dict__["auto_upgrade_minor_version"] = auto_upgrade_minor_version
            __props__.__dict__["backup_set_id"] = backup_set_id
            __props__.__dict__["ca_type"] = ca_type
            __props__.__dict__["client_ca_cert"] = client_ca_cert
            __props__.__dict__["client_ca_enabled"] = client_ca_enabled
            __props__.__dict__["client_cert_revocation_list"] = client_cert_revocation_list
            __props__.__dict__["client_crl_enabled"] = client_crl_enabled
            __props__.__dict__["connection_string_prefix"] = connection_string_prefix
            __props__.__dict__["db_instance_ip_array_attribute"] = db_instance_ip_array_attribute
            __props__.__dict__["db_instance_ip_array_name"] = db_instance_ip_array_name
            __props__.__dict__["db_instance_storage_type"] = db_instance_storage_type
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["effective_time"] = effective_time
            __props__.__dict__["encryption_key"] = encryption_key
            if engine is None and not opts.urn:
                raise TypeError("Missing required property 'engine'")
            __props__.__dict__["engine"] = engine
            if engine_version is None and not opts.urn:
                raise TypeError("Missing required property 'engine_version'")
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["force_restart"] = force_restart
            __props__.__dict__["fresh_white_list_readins"] = fresh_white_list_readins
            __props__.__dict__["ha_config"] = ha_config
            __props__.__dict__["instance_name"] = instance_name
            if instance_storage is None and not opts.urn:
                raise TypeError("Missing required property 'instance_storage'")
            __props__.__dict__["instance_storage"] = instance_storage
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["maintain_time"] = maintain_time
            __props__.__dict__["manual_ha_time"] = manual_ha_time
            __props__.__dict__["modify_mode"] = modify_mode
            __props__.__dict__["monitoring_period"] = monitoring_period
            __props__.__dict__["parameters"] = parameters
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["pg_hba_confs"] = pg_hba_confs
            __props__.__dict__["port"] = port
            __props__.__dict__["private_ip_address"] = private_ip_address
            __props__.__dict__["released_keep_policy"] = released_keep_policy
            __props__.__dict__["replication_acl"] = replication_acl
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["restore_time"] = restore_time
            if restore_type is None and not opts.urn:
                raise TypeError("Missing required property 'restore_type'")
            __props__.__dict__["restore_type"] = restore_type
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["security_ip_mode"] = security_ip_mode
            __props__.__dict__["security_ip_type"] = security_ip_type
            __props__.__dict__["security_ips"] = security_ips
            __props__.__dict__["server_cert"] = server_cert
            __props__.__dict__["server_key"] = server_key
            __props__.__dict__["source_db_instance_name"] = source_db_instance_name
            __props__.__dict__["source_region"] = source_region
            __props__.__dict__["sql_collector_config_value"] = sql_collector_config_value
            __props__.__dict__["sql_collector_status"] = sql_collector_status
            __props__.__dict__["ssl_action"] = ssl_action
            __props__.__dict__["storage_auto_scale"] = storage_auto_scale
            __props__.__dict__["storage_threshold"] = storage_threshold
            __props__.__dict__["storage_upper_bound"] = storage_upper_bound
            __props__.__dict__["switch_time"] = switch_time
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_minor_version"] = target_minor_version
            __props__.__dict__["tcp_connection_type"] = tcp_connection_type
            __props__.__dict__["tde_status"] = tde_status
            __props__.__dict__["upgrade_db_instance_kernel_version"] = upgrade_db_instance_kernel_version
            __props__.__dict__["upgrade_time"] = upgrade_time
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["whitelist_network_type"] = whitelist_network_type
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["category"] = None
            __props__.__dict__["connection_string"] = None
            __props__.__dict__["ssl_status"] = None
            __props__.__dict__["zone_id_slave_a"] = None
            __props__.__dict__["zone_id_slave_b"] = None
        super(DdrInstance, __self__).__init__(
            'alicloud:rds/ddrInstance:DdrInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[str]] = None,
            auto_renew: Optional[pulumi.Input[bool]] = None,
            auto_renew_period: Optional[pulumi.Input[int]] = None,
            auto_upgrade_minor_version: Optional[pulumi.Input[str]] = None,
            backup_set_id: Optional[pulumi.Input[str]] = None,
            ca_type: Optional[pulumi.Input[str]] = None,
            category: Optional[pulumi.Input[str]] = None,
            client_ca_cert: Optional[pulumi.Input[str]] = None,
            client_ca_enabled: Optional[pulumi.Input[int]] = None,
            client_cert_revocation_list: Optional[pulumi.Input[str]] = None,
            client_crl_enabled: Optional[pulumi.Input[int]] = None,
            connection_string: Optional[pulumi.Input[str]] = None,
            connection_string_prefix: Optional[pulumi.Input[str]] = None,
            db_instance_ip_array_attribute: Optional[pulumi.Input[str]] = None,
            db_instance_ip_array_name: Optional[pulumi.Input[str]] = None,
            db_instance_storage_type: Optional[pulumi.Input[str]] = None,
            deletion_protection: Optional[pulumi.Input[bool]] = None,
            effective_time: Optional[pulumi.Input[str]] = None,
            encryption_key: Optional[pulumi.Input[str]] = None,
            engine: Optional[pulumi.Input[str]] = None,
            engine_version: Optional[pulumi.Input[str]] = None,
            force_restart: Optional[pulumi.Input[bool]] = None,
            fresh_white_list_readins: Optional[pulumi.Input[str]] = None,
            ha_config: Optional[pulumi.Input[str]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            instance_storage: Optional[pulumi.Input[int]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            maintain_time: Optional[pulumi.Input[str]] = None,
            manual_ha_time: Optional[pulumi.Input[str]] = None,
            modify_mode: Optional[pulumi.Input[str]] = None,
            monitoring_period: Optional[pulumi.Input[int]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DdrInstanceParameterArgs']]]]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            pg_hba_confs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DdrInstancePgHbaConfArgs']]]]] = None,
            port: Optional[pulumi.Input[str]] = None,
            private_ip_address: Optional[pulumi.Input[str]] = None,
            released_keep_policy: Optional[pulumi.Input[str]] = None,
            replication_acl: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            restore_time: Optional[pulumi.Input[str]] = None,
            restore_type: Optional[pulumi.Input[str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            security_ip_mode: Optional[pulumi.Input[str]] = None,
            security_ip_type: Optional[pulumi.Input[str]] = None,
            security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            server_cert: Optional[pulumi.Input[str]] = None,
            server_key: Optional[pulumi.Input[str]] = None,
            source_db_instance_name: Optional[pulumi.Input[str]] = None,
            source_region: Optional[pulumi.Input[str]] = None,
            sql_collector_config_value: Optional[pulumi.Input[int]] = None,
            sql_collector_status: Optional[pulumi.Input[str]] = None,
            ssl_action: Optional[pulumi.Input[str]] = None,
            ssl_status: Optional[pulumi.Input[str]] = None,
            storage_auto_scale: Optional[pulumi.Input[str]] = None,
            storage_threshold: Optional[pulumi.Input[int]] = None,
            storage_upper_bound: Optional[pulumi.Input[int]] = None,
            switch_time: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            target_minor_version: Optional[pulumi.Input[str]] = None,
            tcp_connection_type: Optional[pulumi.Input[str]] = None,
            tde_status: Optional[pulumi.Input[str]] = None,
            upgrade_db_instance_kernel_version: Optional[pulumi.Input[bool]] = None,
            upgrade_time: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vswitch_id: Optional[pulumi.Input[str]] = None,
            whitelist_network_type: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None,
            zone_id_slave_a: Optional[pulumi.Input[str]] = None,
            zone_id_slave_b: Optional[pulumi.Input[str]] = None) -> 'DdrInstance':
        """
        Get an existing DdrInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] acl: The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param pulumi.Input[bool] auto_renew: Whether to renewal a DB instance automatically or not. It is valid when payment_type is `Subscription`. Default to `false`.
        :param pulumi.Input[int] auto_renew_period: Auto-renewal period of an instance, in the unit of the month. It is valid when payment_type is `Subscription`. Valid value:[1~12], Default to 1.
        :param pulumi.Input[str] auto_upgrade_minor_version: The upgrade method to use. Valid values:
               - Auto: Instances are automatically upgraded to a higher minor version.
               - Manual: Instances are forcibly upgraded to a higher minor version when the current version is unpublished.
               
               See more [details and limitation](https://www.alibabacloud.com/help/doc-detail/123605.htm).
        :param pulumi.Input[str] backup_set_id: The ID of the backup set that is used for the restoration. You can call the DescribeCrossRegionBackups operation to query the ID of the backup set.
        :param pulumi.Input[str] ca_type: The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. Value range:
               - aliyun: a cloud certificate
               - custom: a custom certificate
        :param pulumi.Input[str] category: The RDS edition of the instance.
        :param pulumi.Input[str] client_ca_cert: The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter.
        :param pulumi.Input[int] client_ca_enabled: Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
               - 1: enables the public key
               - 0: disables the public key
        :param pulumi.Input[str] client_cert_revocation_list: The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter.
        :param pulumi.Input[int] client_crl_enabled: Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - 1: enables the CRL
               - 0: disables the CRL
        :param pulumi.Input[str] connection_string: RDS database connection string.
        :param pulumi.Input[str] connection_string_prefix: The private connection string prefix. If you want to update public connection string prefix, please use resource rds.Connection connection_prefix. 
               > **NOTE:** The prefix must be 8 to 64 characters in length and can contain letters, digits, and hyphens (-). It cannot contain Chinese characters and special characters ~!#%^&*=+\\|{};:'",<>/?
        :param pulumi.Input[str] db_instance_ip_array_attribute: The attribute of the IP address whitelist. By default, this parameter is empty.
               
               > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
        :param pulumi.Input[str] db_instance_ip_array_name: The name of the IP address whitelist. Default value: Default.
               
               > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
        :param pulumi.Input[str] db_instance_storage_type: The storage type of the instance. Valid values:
               - local_ssd: specifies to use local SSDs. This value is recommended.
               - cloud_ssd: specifies to use standard SSDs.
               - cloud_essd: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
               
               > **NOTE:** You can specify the time zone when you create a primary instance. You cannot specify the time zone when you create a read-only instance. Read-only instances inherit the time zone of their primary instance. If you do not specify this parameter, the system assigns the default time zone of the region where the instance resides.
        :param pulumi.Input[bool] deletion_protection: The switch of delete protection. Valid values: 
               - true: delete protect.
               - false: no delete protect.
               
               > **NOTE:** `deletion_protection` is valid only when attribute `payment_type` is set to `PayAsYouGo`, supported engine type: **MySQL**, **PostgreSQL**, **MariaDB**, **MSSQL**.
        :param pulumi.Input[str] effective_time: The method to update the engine version and change.  Default value: Immediate. Valid values:
               - Immediate: The change immediately takes effect.
               - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
        :param pulumi.Input[str] encryption_key: The key id of the KMS. Used for encrypting a disk if not null. Only for PostgreSQL, MySQL and SQLServer.
        :param pulumi.Input[str] engine: Database type. Value options: MySQL, SQLServer.
               
               > **NOTE:** When the 'EngineVersion' changes, it can be used as the target database version for the large version upgrade of RDS for MySQL instance.
        :param pulumi.Input[str] engine_version: Database version. Value options can refer to the latest docs [CreateDdrInstance](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/restore-data-to-a-new-instance-across-regions) `EngineVersion`.
        :param pulumi.Input[bool] force_restart: Set it to true to make some parameter efficient when modifying them. Default to false.
        :param pulumi.Input[str] fresh_white_list_readins: The read-only instances to which you want to synchronize the IP address whitelist.
               * If the instance is attached with a read-only instance, you can use this parameter to synchronize the IP address whitelist to the read-only instance. If the instance is attached with multiple read-only instances, the read-only instances must be separated by commas (,).
               * If the instance is not attached with a read-only instance, this parameter is empty.
        :param pulumi.Input[str] ha_config: The primary/secondary switchover mode of the instance. Default value: Auto. Valid values:
               - Auto: The system automatically switches over services from the primary to secondary instances in the event of a fault.
               - Manual: You must manually switch over services from the primary to secondary instances in the event of a fault.
               
               > **NOTE:** If you set this parameter to Manual, you must specify the ManualHATime parameter.
        :param pulumi.Input[str] instance_name: The name of DB instance. It a string of 2 to 256 characters.
        :param pulumi.Input[int] instance_storage: The storage capacity of the destination instance. Valid values: 5 to 2000. Unit: GB.
               
               This value must be a multiple of 5 GB. For more information, see Primary ApsaraDB RDS instance types.
        :param pulumi.Input[str] instance_type: DB Instance type.
               
               > **NOTE:** When `storage_auto_scale="Enable"`, do not perform `instance_storage` check. when `storage_auto_scale="Disable"`, if the instance itself `instance_storage`has changed. You need to manually revise the `instance_storage` in the template value.
        :param pulumi.Input[str] maintain_time: Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
        :param pulumi.Input[str] manual_ha_time: The time after when you want to enable automatic primary/secondary switchover. At most, you can set this parameter to 23:59:59 seven days later. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
               
               > **NOTE:** This parameter only takes effect when the HAConfig parameter is set to Manual.
        :param pulumi.Input[str] modify_mode: The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
               - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
               - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
               - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
        :param pulumi.Input[int] monitoring_period: The monitoring frequency in seconds. Valid values are 5, 60, 300. Defaults to 300.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DdrInstanceParameterArgs']]]] parameters: Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
        :param pulumi.Input[str] payment_type: Valid values are `Subscription`, `PayAsYouGo`, Default to `PayAsYouGo`.
        :param pulumi.Input[int] period: The duration that you will buy DB instance (in month). It is valid when payment_type is `Subscription`. Valid values: [1~9], 12, 24, 36.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DdrInstancePgHbaConfArgs']]]] pg_hba_confs: The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
        :param pulumi.Input[str] port: The private port of the database service. If you want to update public port, please use resource rds.Connection port.
        :param pulumi.Input[str] private_ip_address: The private IP address of the instance. The private IP address must be within the Classless Inter-Domain Routing (CIDR) block of the vSwitch that is specified by the VSwitchId parameter.
        :param pulumi.Input[str] released_keep_policy: The policy based on which ApsaraDB RDS retains archived backup files after the instance is released. Valid values:
               - None: No archived backup files are retained.
               - Lastest: Only the last archived backup file is retained.
               - All: All the archived backup files are retained.
               
               > **NOTE:** This parameter is supported only when the instance runs the MySQL database engine.
        :param pulumi.Input[str] replication_acl: The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param pulumi.Input[str] resource_group_id: The ID of resource group which the DB instance belongs.
        :param pulumi.Input[str] restore_time: The point in time to which you want to restore data. The point in time that you specify must be earlier than the current time. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        :param pulumi.Input[str] restore_type: The method that is used to restore data. Valid values:
               - BackupSet: Data is restored from a backup set. If you use this value, you must also specify the BackupSetID parameter.
               - BackupTime: restores data to a point in time. You must also specify the RestoreTime, SourceRegion, and SourceDBInstanceName parameters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: ) The list IDs to join ECS Security Group. At most supports three security groups.
        :param pulumi.Input[str] security_ip_mode: Valid values are `normal`, `safety`, Default to `normal`. support `safety` switch to high security access mode.
        :param pulumi.Input[str] security_ip_type: The type of IP address in the IP address whitelist.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_ips: List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        :param pulumi.Input[str] server_cert: The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
        :param pulumi.Input[str] server_key: The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
        :param pulumi.Input[str] source_db_instance_name: The ID of the source instance if you want to restore data to a point in time.
        :param pulumi.Input[str] source_region: The region ID of the source instance if you want to restore data to a point in time.
        :param pulumi.Input[int] sql_collector_config_value: The sql collector keep time of the instance. Valid values are `30`, `180`, `365`, `1095`, `1825`, Default to `30`.
        :param pulumi.Input[str] sql_collector_status: The sql collector status of the instance. Valid values are `Enabled`, `Disabled`, Default to `Disabled`.
        :param pulumi.Input[str] ssl_action: Actions performed on SSL functions, Valid values: `Open`: turn on SSL encryption; `Close`: turn off SSL encryption; `Update`: update SSL certificate. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26254.htm).
        :param pulumi.Input[str] ssl_status: Status of the SSL feature. `Yes`: SSL is turned on; `No`: SSL is turned off.
        :param pulumi.Input[str] storage_auto_scale: Automatic storage space expansion switch. Valid values:
               - Enable
               - Disable
               
               > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable.
        :param pulumi.Input[int] storage_threshold: The trigger threshold (percentage) for automatic storage space expansion. Valid values:
               - 10
               - 20
               - 30
               - 40
               - 50
               
               > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable. The value must be greater than or equal to the total size of the current storage space of the instance.
        :param pulumi.Input[int] storage_upper_bound: The upper limit of the total storage space for automatic expansion of the storage space, that is, automatic expansion will not cause the total storage space of the instance to exceed this value. Unit: GB. The value must be ≥0.
               
               > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
        :param pulumi.Input[str] switch_time: The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `upgrade_db_instance_kernel_version = true`. The time must be in UTC.
               
               > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[str] target_minor_version: The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. It is valid only when `upgrade_db_instance_kernel_version = true`. You must specify the minor engine version in one of the following formats:
               - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
               - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
               - rds: The instance runs RDS Basic or High-availability Edition.
               - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
               - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
               - SQLServer: <Minor engine version>. Example: 15.0.4073.23.
               
               > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
        :param pulumi.Input[str] tcp_connection_type: The availability check method of the instance. Valid values:
               - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
               - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
        :param pulumi.Input[str] tde_status: The TDE(Transparent Data Encryption) status. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26256.htm).
        :param pulumi.Input[bool] upgrade_db_instance_kernel_version: Whether to upgrade a minor version of the kernel. Valid values:
               - true: upgrade
               - false: not to upgrade
        :param pulumi.Input[str] upgrade_time: The method to update the minor engine version. Default value: Immediate. It is valid only when `upgrade_db_instance_kernel_version = true`. Valid values:
               - Immediate: The minor engine version is immediately updated.
               - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
               - SpecifyTime: The minor engine version is updated at the point in time you specify.
        :param pulumi.Input[str] vpc_id: The VPC ID of the instance.
               
               > **NOTE:** This parameter applies only to ApsaraDB RDS for MySQL instances. For more information about Upgrade the major engine version of an ApsaraDB RDS for MySQL instance, see [Upgrade the major engine version of an RDS instance in the ApsaraDB RDS console](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/upgrade-the-major-engine-version-of-an-apsaradb-rds-for-mysql-instance-1).
        :param pulumi.Input[str] vswitch_id: The virtual switch ID to launch DB instances in one VPC. If there are multiple vswitches, separate them with commas.
        :param pulumi.Input[str] whitelist_network_type: The network type of the IP address whitelist. Default value: MIX. Valid values:
               - Classic: classic network in enhanced whitelist mode
               - VPC: virtual private cloud (VPC) in enhanced whitelist mode
               - MIX: standard whitelist mode
               
               > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
        :param pulumi.Input[str] zone_id: The Zone to launch the DB instance. It supports multiple zone.
               If it is a multi-zone and `vswitch_id` is specified, the vswitch must in the one of them.
               The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `get_zones`.
        :param pulumi.Input[str] zone_id_slave_a: The region ID of the secondary instance if you create a secondary instance.
        :param pulumi.Input[str] zone_id_slave_b: The region ID of the log instance if you create a log instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DdrInstanceState.__new__(_DdrInstanceState)

        __props__.__dict__["acl"] = acl
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["auto_renew_period"] = auto_renew_period
        __props__.__dict__["auto_upgrade_minor_version"] = auto_upgrade_minor_version
        __props__.__dict__["backup_set_id"] = backup_set_id
        __props__.__dict__["ca_type"] = ca_type
        __props__.__dict__["category"] = category
        __props__.__dict__["client_ca_cert"] = client_ca_cert
        __props__.__dict__["client_ca_enabled"] = client_ca_enabled
        __props__.__dict__["client_cert_revocation_list"] = client_cert_revocation_list
        __props__.__dict__["client_crl_enabled"] = client_crl_enabled
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["connection_string_prefix"] = connection_string_prefix
        __props__.__dict__["db_instance_ip_array_attribute"] = db_instance_ip_array_attribute
        __props__.__dict__["db_instance_ip_array_name"] = db_instance_ip_array_name
        __props__.__dict__["db_instance_storage_type"] = db_instance_storage_type
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["effective_time"] = effective_time
        __props__.__dict__["encryption_key"] = encryption_key
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["force_restart"] = force_restart
        __props__.__dict__["fresh_white_list_readins"] = fresh_white_list_readins
        __props__.__dict__["ha_config"] = ha_config
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_storage"] = instance_storage
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["maintain_time"] = maintain_time
        __props__.__dict__["manual_ha_time"] = manual_ha_time
        __props__.__dict__["modify_mode"] = modify_mode
        __props__.__dict__["monitoring_period"] = monitoring_period
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["pg_hba_confs"] = pg_hba_confs
        __props__.__dict__["port"] = port
        __props__.__dict__["private_ip_address"] = private_ip_address
        __props__.__dict__["released_keep_policy"] = released_keep_policy
        __props__.__dict__["replication_acl"] = replication_acl
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["restore_time"] = restore_time
        __props__.__dict__["restore_type"] = restore_type
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["security_ip_mode"] = security_ip_mode
        __props__.__dict__["security_ip_type"] = security_ip_type
        __props__.__dict__["security_ips"] = security_ips
        __props__.__dict__["server_cert"] = server_cert
        __props__.__dict__["server_key"] = server_key
        __props__.__dict__["source_db_instance_name"] = source_db_instance_name
        __props__.__dict__["source_region"] = source_region
        __props__.__dict__["sql_collector_config_value"] = sql_collector_config_value
        __props__.__dict__["sql_collector_status"] = sql_collector_status
        __props__.__dict__["ssl_action"] = ssl_action
        __props__.__dict__["ssl_status"] = ssl_status
        __props__.__dict__["storage_auto_scale"] = storage_auto_scale
        __props__.__dict__["storage_threshold"] = storage_threshold
        __props__.__dict__["storage_upper_bound"] = storage_upper_bound
        __props__.__dict__["switch_time"] = switch_time
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_minor_version"] = target_minor_version
        __props__.__dict__["tcp_connection_type"] = tcp_connection_type
        __props__.__dict__["tde_status"] = tde_status
        __props__.__dict__["upgrade_db_instance_kernel_version"] = upgrade_db_instance_kernel_version
        __props__.__dict__["upgrade_time"] = upgrade_time
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["whitelist_network_type"] = whitelist_network_type
        __props__.__dict__["zone_id"] = zone_id
        __props__.__dict__["zone_id_slave_a"] = zone_id_slave_a
        __props__.__dict__["zone_id_slave_b"] = zone_id_slave_b
        return DdrInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output[str]:
        """
        The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[bool]:
        """
        Whether to renewal a DB instance automatically or not. It is valid when payment_type is `Subscription`. Default to `false`.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> pulumi.Output[int]:
        """
        Auto-renewal period of an instance, in the unit of the month. It is valid when payment_type is `Subscription`. Valid value:[1~12], Default to 1.
        """
        return pulumi.get(self, "auto_renew_period")

    @property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> pulumi.Output[str]:
        """
        The upgrade method to use. Valid values:
        - Auto: Instances are automatically upgraded to a higher minor version.
        - Manual: Instances are forcibly upgraded to a higher minor version when the current version is unpublished.

        See more [details and limitation](https://www.alibabacloud.com/help/doc-detail/123605.htm).
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @property
    @pulumi.getter(name="backupSetId")
    def backup_set_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the backup set that is used for the restoration. You can call the DescribeCrossRegionBackups operation to query the ID of the backup set.
        """
        return pulumi.get(self, "backup_set_id")

    @property
    @pulumi.getter(name="caType")
    def ca_type(self) -> pulumi.Output[str]:
        """
        The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. Value range:
        - aliyun: a cloud certificate
        - custom: a custom certificate
        """
        return pulumi.get(self, "ca_type")

    @property
    @pulumi.getter
    def category(self) -> pulumi.Output[str]:
        """
        The RDS edition of the instance.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="clientCaCert")
    def client_ca_cert(self) -> pulumi.Output[Optional[str]]:
        """
        The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter.
        """
        return pulumi.get(self, "client_ca_cert")

    @property
    @pulumi.getter(name="clientCaEnabled")
    def client_ca_enabled(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
        - 1: enables the public key
        - 0: disables the public key
        """
        return pulumi.get(self, "client_ca_enabled")

    @property
    @pulumi.getter(name="clientCertRevocationList")
    def client_cert_revocation_list(self) -> pulumi.Output[Optional[str]]:
        """
        The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter.
        """
        return pulumi.get(self, "client_cert_revocation_list")

    @property
    @pulumi.getter(name="clientCrlEnabled")
    def client_crl_enabled(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
        - 1: enables the CRL
        - 0: disables the CRL
        """
        return pulumi.get(self, "client_crl_enabled")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[str]:
        """
        RDS database connection string.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="connectionStringPrefix")
    def connection_string_prefix(self) -> pulumi.Output[str]:
        """
        The private connection string prefix. If you want to update public connection string prefix, please use resource rds.Connection connection_prefix. 
        > **NOTE:** The prefix must be 8 to 64 characters in length and can contain letters, digits, and hyphens (-). It cannot contain Chinese characters and special characters ~!#%^&*=+\\|{};:'",<>/?
        """
        return pulumi.get(self, "connection_string_prefix")

    @property
    @pulumi.getter(name="dbInstanceIpArrayAttribute")
    def db_instance_ip_array_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        The attribute of the IP address whitelist. By default, this parameter is empty.

        > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
        """
        return pulumi.get(self, "db_instance_ip_array_attribute")

    @property
    @pulumi.getter(name="dbInstanceIpArrayName")
    def db_instance_ip_array_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the IP address whitelist. Default value: Default.

        > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
        """
        return pulumi.get(self, "db_instance_ip_array_name")

    @property
    @pulumi.getter(name="dbInstanceStorageType")
    def db_instance_storage_type(self) -> pulumi.Output[str]:
        """
        The storage type of the instance. Valid values:
        - local_ssd: specifies to use local SSDs. This value is recommended.
        - cloud_ssd: specifies to use standard SSDs.
        - cloud_essd: specifies to use enhanced SSDs (ESSDs).
        - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
        - cloud_essd3: specifies to use enhanced SSDs (ESSDs).

        > **NOTE:** You can specify the time zone when you create a primary instance. You cannot specify the time zone when you create a read-only instance. Read-only instances inherit the time zone of their primary instance. If you do not specify this parameter, the system assigns the default time zone of the region where the instance resides.
        """
        return pulumi.get(self, "db_instance_storage_type")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[bool]:
        """
        The switch of delete protection. Valid values: 
        - true: delete protect.
        - false: no delete protect.

        > **NOTE:** `deletion_protection` is valid only when attribute `payment_type` is set to `PayAsYouGo`, supported engine type: **MySQL**, **PostgreSQL**, **MariaDB**, **MSSQL**.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> pulumi.Output[Optional[str]]:
        """
        The method to update the engine version and change.  Default value: Immediate. Valid values:
        - Immediate: The change immediately takes effect.
        - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
        """
        return pulumi.get(self, "effective_time")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> pulumi.Output[Optional[str]]:
        """
        The key id of the KMS. Used for encrypting a disk if not null. Only for PostgreSQL, MySQL and SQLServer.
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[str]:
        """
        Database type. Value options: MySQL, SQLServer.

        > **NOTE:** When the 'EngineVersion' changes, it can be used as the target database version for the large version upgrade of RDS for MySQL instance.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[str]:
        """
        Database version. Value options can refer to the latest docs [CreateDdrInstance](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/restore-data-to-a-new-instance-across-regions) `EngineVersion`.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> pulumi.Output[bool]:
        """
        Set it to true to make some parameter efficient when modifying them. Default to false.
        """
        return pulumi.get(self, "force_restart")

    @property
    @pulumi.getter(name="freshWhiteListReadins")
    def fresh_white_list_readins(self) -> pulumi.Output[Optional[str]]:
        """
        The read-only instances to which you want to synchronize the IP address whitelist.
        * If the instance is attached with a read-only instance, you can use this parameter to synchronize the IP address whitelist to the read-only instance. If the instance is attached with multiple read-only instances, the read-only instances must be separated by commas (,).
        * If the instance is not attached with a read-only instance, this parameter is empty.
        """
        return pulumi.get(self, "fresh_white_list_readins")

    @property
    @pulumi.getter(name="haConfig")
    def ha_config(self) -> pulumi.Output[str]:
        """
        The primary/secondary switchover mode of the instance. Default value: Auto. Valid values:
        - Auto: The system automatically switches over services from the primary to secondary instances in the event of a fault.
        - Manual: You must manually switch over services from the primary to secondary instances in the event of a fault.

        > **NOTE:** If you set this parameter to Manual, you must specify the ManualHATime parameter.
        """
        return pulumi.get(self, "ha_config")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of DB instance. It a string of 2 to 256 characters.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceStorage")
    def instance_storage(self) -> pulumi.Output[int]:
        """
        The storage capacity of the destination instance. Valid values: 5 to 2000. Unit: GB.

        This value must be a multiple of 5 GB. For more information, see Primary ApsaraDB RDS instance types.
        """
        return pulumi.get(self, "instance_storage")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        DB Instance type.

        > **NOTE:** When `storage_auto_scale="Enable"`, do not perform `instance_storage` check. when `storage_auto_scale="Disable"`, if the instance itself `instance_storage`has changed. You need to manually revise the `instance_storage` in the template value.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="maintainTime")
    def maintain_time(self) -> pulumi.Output[str]:
        """
        Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
        """
        return pulumi.get(self, "maintain_time")

    @property
    @pulumi.getter(name="manualHaTime")
    def manual_ha_time(self) -> pulumi.Output[Optional[str]]:
        """
        The time after when you want to enable automatic primary/secondary switchover. At most, you can set this parameter to 23:59:59 seven days later. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.

        > **NOTE:** This parameter only takes effect when the HAConfig parameter is set to Manual.
        """
        return pulumi.get(self, "manual_ha_time")

    @property
    @pulumi.getter(name="modifyMode")
    def modify_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
        - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
        - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
        - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
        """
        return pulumi.get(self, "modify_mode")

    @property
    @pulumi.getter(name="monitoringPeriod")
    def monitoring_period(self) -> pulumi.Output[int]:
        """
        The monitoring frequency in seconds. Valid values are 5, 60, 300. Defaults to 300.
        """
        return pulumi.get(self, "monitoring_period")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Sequence['outputs.DdrInstanceParameter']]:
        """
        Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        Valid values are `Subscription`, `PayAsYouGo`, Default to `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        The duration that you will buy DB instance (in month). It is valid when payment_type is `Subscription`. Valid values: [1~9], 12, 24, 36.
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="pgHbaConfs")
    def pg_hba_confs(self) -> pulumi.Output[Sequence['outputs.DdrInstancePgHbaConf']]:
        """
        The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
        """
        return pulumi.get(self, "pg_hba_confs")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[str]:
        """
        The private port of the database service. If you want to update public port, please use resource rds.Connection port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[str]:
        """
        The private IP address of the instance. The private IP address must be within the Classless Inter-Domain Routing (CIDR) block of the vSwitch that is specified by the VSwitchId parameter.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="releasedKeepPolicy")
    def released_keep_policy(self) -> pulumi.Output[Optional[str]]:
        """
        The policy based on which ApsaraDB RDS retains archived backup files after the instance is released. Valid values:
        - None: No archived backup files are retained.
        - Lastest: Only the last archived backup file is retained.
        - All: All the archived backup files are retained.

        > **NOTE:** This parameter is supported only when the instance runs the MySQL database engine.
        """
        return pulumi.get(self, "released_keep_policy")

    @property
    @pulumi.getter(name="replicationAcl")
    def replication_acl(self) -> pulumi.Output[str]:
        """
        The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        """
        return pulumi.get(self, "replication_acl")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The ID of resource group which the DB instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="restoreTime")
    def restore_time(self) -> pulumi.Output[Optional[str]]:
        """
        The point in time to which you want to restore data. The point in time that you specify must be earlier than the current time. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        """
        return pulumi.get(self, "restore_time")

    @property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> pulumi.Output[str]:
        """
        The method that is used to restore data. Valid values:
        - BackupSet: Data is restored from a backup set. If you use this value, you must also specify the BackupSetID parameter.
        - BackupTime: restores data to a point in time. You must also specify the RestoreTime, SourceRegion, and SourceDBInstanceName parameters.
        """
        return pulumi.get(self, "restore_type")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        ) The list IDs to join ECS Security Group. At most supports three security groups.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="securityIpMode")
    def security_ip_mode(self) -> pulumi.Output[str]:
        """
        Valid values are `normal`, `safety`, Default to `normal`. support `safety` switch to high security access mode.
        """
        return pulumi.get(self, "security_ip_mode")

    @property
    @pulumi.getter(name="securityIpType")
    def security_ip_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of IP address in the IP address whitelist.
        """
        return pulumi.get(self, "security_ip_type")

    @property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> pulumi.Output[Sequence[str]]:
        """
        List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        """
        return pulumi.get(self, "security_ips")

    @property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> pulumi.Output[str]:
        """
        The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
        """
        return pulumi.get(self, "server_cert")

    @property
    @pulumi.getter(name="serverKey")
    def server_key(self) -> pulumi.Output[str]:
        """
        The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter.
        """
        return pulumi.get(self, "server_key")

    @property
    @pulumi.getter(name="sourceDbInstanceName")
    def source_db_instance_name(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the source instance if you want to restore data to a point in time.
        """
        return pulumi.get(self, "source_db_instance_name")

    @property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> pulumi.Output[Optional[str]]:
        """
        The region ID of the source instance if you want to restore data to a point in time.
        """
        return pulumi.get(self, "source_region")

    @property
    @pulumi.getter(name="sqlCollectorConfigValue")
    def sql_collector_config_value(self) -> pulumi.Output[int]:
        """
        The sql collector keep time of the instance. Valid values are `30`, `180`, `365`, `1095`, `1825`, Default to `30`.
        """
        return pulumi.get(self, "sql_collector_config_value")

    @property
    @pulumi.getter(name="sqlCollectorStatus")
    def sql_collector_status(self) -> pulumi.Output[str]:
        """
        The sql collector status of the instance. Valid values are `Enabled`, `Disabled`, Default to `Disabled`.
        """
        return pulumi.get(self, "sql_collector_status")

    @property
    @pulumi.getter(name="sslAction")
    def ssl_action(self) -> pulumi.Output[str]:
        """
        Actions performed on SSL functions, Valid values: `Open`: turn on SSL encryption; `Close`: turn off SSL encryption; `Update`: update SSL certificate. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26254.htm).
        """
        return pulumi.get(self, "ssl_action")

    @property
    @pulumi.getter(name="sslStatus")
    def ssl_status(self) -> pulumi.Output[str]:
        """
        Status of the SSL feature. `Yes`: SSL is turned on; `No`: SSL is turned off.
        """
        return pulumi.get(self, "ssl_status")

    @property
    @pulumi.getter(name="storageAutoScale")
    def storage_auto_scale(self) -> pulumi.Output[Optional[str]]:
        """
        Automatic storage space expansion switch. Valid values:
        - Enable
        - Disable

        > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable.
        """
        return pulumi.get(self, "storage_auto_scale")

    @property
    @pulumi.getter(name="storageThreshold")
    def storage_threshold(self) -> pulumi.Output[Optional[int]]:
        """
        The trigger threshold (percentage) for automatic storage space expansion. Valid values:
        - 10
        - 20
        - 30
        - 40
        - 50

        > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable. The value must be greater than or equal to the total size of the current storage space of the instance.
        """
        return pulumi.get(self, "storage_threshold")

    @property
    @pulumi.getter(name="storageUpperBound")
    def storage_upper_bound(self) -> pulumi.Output[Optional[int]]:
        """
        The upper limit of the total storage space for automatic expansion of the storage space, that is, automatic expansion will not cause the total storage space of the instance to exceed this value. Unit: GB. The value must be ≥0.

        > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
        """
        return pulumi.get(self, "storage_upper_bound")

    @property
    @pulumi.getter(name="switchTime")
    def switch_time(self) -> pulumi.Output[Optional[str]]:
        """
        The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `upgrade_db_instance_kernel_version = true`. The time must be in UTC.

        > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
        """
        return pulumi.get(self, "switch_time")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetMinorVersion")
    def target_minor_version(self) -> pulumi.Output[str]:
        """
        The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. It is valid only when `upgrade_db_instance_kernel_version = true`. You must specify the minor engine version in one of the following formats:
        - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
        - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
        - rds: The instance runs RDS Basic or High-availability Edition.
        - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
        - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
        - SQLServer: <Minor engine version>. Example: 15.0.4073.23.

        > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
        """
        return pulumi.get(self, "target_minor_version")

    @property
    @pulumi.getter(name="tcpConnectionType")
    def tcp_connection_type(self) -> pulumi.Output[str]:
        """
        The availability check method of the instance. Valid values:
        - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
        - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
        """
        return pulumi.get(self, "tcp_connection_type")

    @property
    @pulumi.getter(name="tdeStatus")
    def tde_status(self) -> pulumi.Output[Optional[str]]:
        """
        The TDE(Transparent Data Encryption) status. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26256.htm).
        """
        return pulumi.get(self, "tde_status")

    @property
    @pulumi.getter(name="upgradeDbInstanceKernelVersion")
    def upgrade_db_instance_kernel_version(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to upgrade a minor version of the kernel. Valid values:
        - true: upgrade
        - false: not to upgrade
        """
        return pulumi.get(self, "upgrade_db_instance_kernel_version")

    @property
    @pulumi.getter(name="upgradeTime")
    def upgrade_time(self) -> pulumi.Output[Optional[str]]:
        """
        The method to update the minor engine version. Default value: Immediate. It is valid only when `upgrade_db_instance_kernel_version = true`. Valid values:
        - Immediate: The minor engine version is immediately updated.
        - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
        - SpecifyTime: The minor engine version is updated at the point in time you specify.
        """
        return pulumi.get(self, "upgrade_time")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The VPC ID of the instance.

        > **NOTE:** This parameter applies only to ApsaraDB RDS for MySQL instances. For more information about Upgrade the major engine version of an ApsaraDB RDS for MySQL instance, see [Upgrade the major engine version of an RDS instance in the ApsaraDB RDS console](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/upgrade-the-major-engine-version-of-an-apsaradb-rds-for-mysql-instance-1).
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[str]]:
        """
        The virtual switch ID to launch DB instances in one VPC. If there are multiple vswitches, separate them with commas.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="whitelistNetworkType")
    def whitelist_network_type(self) -> pulumi.Output[Optional[str]]:
        """
        The network type of the IP address whitelist. Default value: MIX. Valid values:
        - Classic: classic network in enhanced whitelist mode
        - VPC: virtual private cloud (VPC) in enhanced whitelist mode
        - MIX: standard whitelist mode

        > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
        """
        return pulumi.get(self, "whitelist_network_type")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The Zone to launch the DB instance. It supports multiple zone.
        If it is a multi-zone and `vswitch_id` is specified, the vswitch must in the one of them.
        The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `get_zones`.
        """
        return pulumi.get(self, "zone_id")

    @property
    @pulumi.getter(name="zoneIdSlaveA")
    def zone_id_slave_a(self) -> pulumi.Output[str]:
        """
        The region ID of the secondary instance if you create a secondary instance.
        """
        return pulumi.get(self, "zone_id_slave_a")

    @property
    @pulumi.getter(name="zoneIdSlaveB")
    def zone_id_slave_b(self) -> pulumi.Output[str]:
        """
        The region ID of the log instance if you create a log instance.
        """
        return pulumi.get(self, "zone_id_slave_b")

