# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetCharacterSetNamesResult',
    'AwaitableGetCharacterSetNamesResult',
    'get_character_set_names',
    'get_character_set_names_output',
]

@pulumi.output_type
class GetCharacterSetNamesResult:
    """
    A collection of values returned by getCharacterSetNames.
    """
    def __init__(__self__, engine=None, id=None, names=None, output_file=None):
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @property
    @pulumi.getter
    def engine(self) -> str:
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")


class AwaitableGetCharacterSetNamesResult(GetCharacterSetNamesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCharacterSetNamesResult(
            engine=self.engine,
            id=self.id,
            names=self.names,
            output_file=self.output_file)


def get_character_set_names(engine: Optional[str] = None,
                            output_file: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCharacterSetNamesResult:
    """
    This data source is the character set supported by querying RDS instances.

    > **NOTE:** Available in v1.198.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    names = alicloud.rds.get_character_set_names(engine="MySQL")
    pulumi.export("firstRdsCharacterSetNames", names.names[0])
    ```


    :param str engine: Database type. Options are `MySQL`, `SQLServer`, `PostgreSQL`, `MariaDB`.
    """
    __args__ = dict()
    __args__['engine'] = engine
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:rds/getCharacterSetNames:getCharacterSetNames', __args__, opts=opts, typ=GetCharacterSetNamesResult).value

    return AwaitableGetCharacterSetNamesResult(
        engine=pulumi.get(__ret__, 'engine'),
        id=pulumi.get(__ret__, 'id'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'))


@_utilities.lift_output_func(get_character_set_names)
def get_character_set_names_output(engine: Optional[pulumi.Input[str]] = None,
                                   output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCharacterSetNamesResult]:
    """
    This data source is the character set supported by querying RDS instances.

    > **NOTE:** Available in v1.198.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    names = alicloud.rds.get_character_set_names(engine="MySQL")
    pulumi.export("firstRdsCharacterSetNames", names.names[0])
    ```


    :param str engine: Database type. Options are `MySQL`, `SQLServer`, `PostgreSQL`, `MariaDB`.
    """
    ...
