# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCollationTimeZonesResult',
    'AwaitableGetCollationTimeZonesResult',
    'get_collation_time_zones',
    'get_collation_time_zones_output',
]

@pulumi.output_type
class GetCollationTimeZonesResult:
    """
    A collection of values returned by getCollationTimeZones.
    """
    def __init__(__self__, collation_time_zones=None, id=None, ids=None, output_file=None):
        if collation_time_zones and not isinstance(collation_time_zones, list):
            raise TypeError("Expected argument 'collation_time_zones' to be a list")
        pulumi.set(__self__, "collation_time_zones", collation_time_zones)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @property
    @pulumi.getter(name="collationTimeZones")
    def collation_time_zones(self) -> Optional[Sequence['outputs.GetCollationTimeZonesCollationTimeZoneResult']]:
        return pulumi.get(self, "collation_time_zones")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")


class AwaitableGetCollationTimeZonesResult(GetCollationTimeZonesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCollationTimeZonesResult(
            collation_time_zones=self.collation_time_zones,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file)


def get_collation_time_zones(collation_time_zones: Optional[Sequence[pulumi.InputType['GetCollationTimeZonesCollationTimeZoneArgs']]] = None,
                             output_file: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCollationTimeZonesResult:
    """
    Operation to query the character set collations and time zones available for use in ApsaraDB RDS.

    > **NOTE:** Available in v1.198.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    zones = alicloud.rds.get_collation_time_zones(output_file="./classes.txt")
    pulumi.export("firstRdsCollationTimeZones", zones.collation_time_zones[0])
    ```


    :param Sequence[pulumi.InputType['GetCollationTimeZonesCollationTimeZoneArgs']] collation_time_zones: An array that consists of the character set collations and time zones that are available for
           use in ApsaraDB RDS.
    :param str output_file: File name where to save data source results (after running `pulumi up`).
    """
    __args__ = dict()
    __args__['collationTimeZones'] = collation_time_zones
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:rds/getCollationTimeZones:getCollationTimeZones', __args__, opts=opts, typ=GetCollationTimeZonesResult).value

    return AwaitableGetCollationTimeZonesResult(
        collation_time_zones=pulumi.get(__ret__, 'collation_time_zones'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'))


@_utilities.lift_output_func(get_collation_time_zones)
def get_collation_time_zones_output(collation_time_zones: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetCollationTimeZonesCollationTimeZoneArgs']]]]] = None,
                                    output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCollationTimeZonesResult]:
    """
    Operation to query the character set collations and time zones available for use in ApsaraDB RDS.

    > **NOTE:** Available in v1.198.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    zones = alicloud.rds.get_collation_time_zones(output_file="./classes.txt")
    pulumi.export("firstRdsCollationTimeZones", zones.collation_time_zones[0])
    ```


    :param Sequence[pulumi.InputType['GetCollationTimeZonesCollationTimeZoneArgs']] collation_time_zones: An array that consists of the character set collations and time zones that are available for
           use in ApsaraDB RDS.
    :param str output_file: File name where to save data source results (after running `pulumi up`).
    """
    ...
