# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetCrossRegionBackupsResult',
    'AwaitableGetCrossRegionBackupsResult',
    'get_cross_region_backups',
    'get_cross_region_backups_output',
]

@pulumi.output_type
class GetCrossRegionBackupsResult:
    """
    A collection of values returned by getCrossRegionBackups.
    """
    def __init__(__self__, backup_id=None, backups=None, cross_backup_id=None, cross_backup_region=None, db_instance_id=None, end_time=None, id=None, ids=None, output_file=None, resource_group_id=None, start_time=None):
        if backup_id and not isinstance(backup_id, str):
            raise TypeError("Expected argument 'backup_id' to be a str")
        pulumi.set(__self__, "backup_id", backup_id)
        if backups and not isinstance(backups, list):
            raise TypeError("Expected argument 'backups' to be a list")
        pulumi.set(__self__, "backups", backups)
        if cross_backup_id and not isinstance(cross_backup_id, str):
            raise TypeError("Expected argument 'cross_backup_id' to be a str")
        pulumi.set(__self__, "cross_backup_id", cross_backup_id)
        if cross_backup_region and not isinstance(cross_backup_region, str):
            raise TypeError("Expected argument 'cross_backup_region' to be a str")
        pulumi.set(__self__, "cross_backup_region", cross_backup_region)
        if db_instance_id and not isinstance(db_instance_id, str):
            raise TypeError("Expected argument 'db_instance_id' to be a str")
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        if end_time and not isinstance(end_time, str):
            raise TypeError("Expected argument 'end_time' to be a str")
        pulumi.set(__self__, "end_time", end_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if start_time and not isinstance(start_time, str):
            raise TypeError("Expected argument 'start_time' to be a str")
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[str]:
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter
    def backups(self) -> Sequence['outputs.GetCrossRegionBackupsBackupResult']:
        return pulumi.get(self, "backups")

    @property
    @pulumi.getter(name="crossBackupId")
    def cross_backup_id(self) -> Optional[str]:
        return pulumi.get(self, "cross_backup_id")

    @property
    @pulumi.getter(name="crossBackupRegion")
    def cross_backup_region(self) -> Optional[str]:
        return pulumi.get(self, "cross_backup_region")

    @property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> str:
        return pulumi.get(self, "db_instance_id")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[str]:
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        return pulumi.get(self, "start_time")


class AwaitableGetCrossRegionBackupsResult(GetCrossRegionBackupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCrossRegionBackupsResult(
            backup_id=self.backup_id,
            backups=self.backups,
            cross_backup_id=self.cross_backup_id,
            cross_backup_region=self.cross_backup_region,
            db_instance_id=self.db_instance_id,
            end_time=self.end_time,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            resource_group_id=self.resource_group_id,
            start_time=self.start_time)


def get_cross_region_backups(backup_id: Optional[str] = None,
                             cross_backup_id: Optional[str] = None,
                             cross_backup_region: Optional[str] = None,
                             db_instance_id: Optional[str] = None,
                             end_time: Optional[str] = None,
                             ids: Optional[Sequence[str]] = None,
                             output_file: Optional[str] = None,
                             resource_group_id: Optional[str] = None,
                             start_time: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCrossRegionBackupsResult:
    """
    This data source provides the Rds Parameter Groups of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.196.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    backups = alicloud.rds.get_cross_region_backups(db_instance_id="example_value",
        start_time="2022-12-01T00:00:00Z",
        end_time="2022-12-16T00:00:00Z")
    pulumi.export("firstRdsCrossRegionBackups", backups.backups[0].id)
    ```


    :param str backup_id: The ID of the cross-region data backup file.
    :param str cross_backup_id: The ID of the cross-region data backup file.
    :param str cross_backup_region: The ID of the destination region where the cross-region data backup file of the instance is stored.
    :param str db_instance_id: The db instance id.
    :param str end_time: The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
    :param Sequence[str] ids: A list of Cross Region Backup IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str resource_group_id: The ID of the resource group.
    :param str start_time: The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
    """
    __args__ = dict()
    __args__['backupId'] = backup_id
    __args__['crossBackupId'] = cross_backup_id
    __args__['crossBackupRegion'] = cross_backup_region
    __args__['dbInstanceId'] = db_instance_id
    __args__['endTime'] = end_time
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['startTime'] = start_time
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:rds/getCrossRegionBackups:getCrossRegionBackups', __args__, opts=opts, typ=GetCrossRegionBackupsResult).value

    return AwaitableGetCrossRegionBackupsResult(
        backup_id=pulumi.get(__ret__, 'backup_id'),
        backups=pulumi.get(__ret__, 'backups'),
        cross_backup_id=pulumi.get(__ret__, 'cross_backup_id'),
        cross_backup_region=pulumi.get(__ret__, 'cross_backup_region'),
        db_instance_id=pulumi.get(__ret__, 'db_instance_id'),
        end_time=pulumi.get(__ret__, 'end_time'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        start_time=pulumi.get(__ret__, 'start_time'))


@_utilities.lift_output_func(get_cross_region_backups)
def get_cross_region_backups_output(backup_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    cross_backup_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    cross_backup_region: Optional[pulumi.Input[Optional[str]]] = None,
                                    db_instance_id: Optional[pulumi.Input[str]] = None,
                                    end_time: Optional[pulumi.Input[Optional[str]]] = None,
                                    ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                    output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                    resource_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    start_time: Optional[pulumi.Input[Optional[str]]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCrossRegionBackupsResult]:
    """
    This data source provides the Rds Parameter Groups of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.196.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    backups = alicloud.rds.get_cross_region_backups(db_instance_id="example_value",
        start_time="2022-12-01T00:00:00Z",
        end_time="2022-12-16T00:00:00Z")
    pulumi.export("firstRdsCrossRegionBackups", backups.backups[0].id)
    ```


    :param str backup_id: The ID of the cross-region data backup file.
    :param str cross_backup_id: The ID of the cross-region data backup file.
    :param str cross_backup_region: The ID of the destination region where the cross-region data backup file of the instance is stored.
    :param str db_instance_id: The db instance id.
    :param str end_time: The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
    :param Sequence[str] ids: A list of Cross Region Backup IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str resource_group_id: The ID of the resource group.
    :param str start_time: The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
    """
    ...
