# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetRdsBackupsResult',
    'AwaitableGetRdsBackupsResult',
    'get_rds_backups',
    'get_rds_backups_output',
]

@pulumi.output_type
class GetRdsBackupsResult:
    """
    A collection of values returned by getRdsBackups.
    """
    def __init__(__self__, backup_mode=None, backup_status=None, backups=None, db_instance_id=None, end_time=None, id=None, ids=None, output_file=None, start_time=None):
        if backup_mode and not isinstance(backup_mode, str):
            raise TypeError("Expected argument 'backup_mode' to be a str")
        pulumi.set(__self__, "backup_mode", backup_mode)
        if backup_status and not isinstance(backup_status, str):
            raise TypeError("Expected argument 'backup_status' to be a str")
        pulumi.set(__self__, "backup_status", backup_status)
        if backups and not isinstance(backups, list):
            raise TypeError("Expected argument 'backups' to be a list")
        pulumi.set(__self__, "backups", backups)
        if db_instance_id and not isinstance(db_instance_id, str):
            raise TypeError("Expected argument 'db_instance_id' to be a str")
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        if end_time and not isinstance(end_time, str):
            raise TypeError("Expected argument 'end_time' to be a str")
        pulumi.set(__self__, "end_time", end_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if start_time and not isinstance(start_time, str):
            raise TypeError("Expected argument 'start_time' to be a str")
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="backupMode")
    def backup_mode(self) -> Optional[str]:
        return pulumi.get(self, "backup_mode")

    @property
    @pulumi.getter(name="backupStatus")
    def backup_status(self) -> Optional[str]:
        return pulumi.get(self, "backup_status")

    @property
    @pulumi.getter
    def backups(self) -> Sequence['outputs.GetRdsBackupsBackupResult']:
        return pulumi.get(self, "backups")

    @property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> str:
        return pulumi.get(self, "db_instance_id")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        return pulumi.get(self, "start_time")


class AwaitableGetRdsBackupsResult(GetRdsBackupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRdsBackupsResult(
            backup_mode=self.backup_mode,
            backup_status=self.backup_status,
            backups=self.backups,
            db_instance_id=self.db_instance_id,
            end_time=self.end_time,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            start_time=self.start_time)


def get_rds_backups(backup_mode: Optional[str] = None,
                    backup_status: Optional[str] = None,
                    db_instance_id: Optional[str] = None,
                    end_time: Optional[str] = None,
                    ids: Optional[Sequence[str]] = None,
                    output_file: Optional[str] = None,
                    start_time: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRdsBackupsResult:
    """
    This data source provides the Rds Backups of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.149.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.rds.get_rds_backups(db_instance_id="example_value")
    pulumi.export("firstRdsBackupId", example.backups[0].id)
    ```


    :param str backup_mode: BackupMode.
    :param str backup_status: Backup task status. **NOTE:** This parameter will only be returned when a task is executed. Value:
           * **NoStart**: Not started
           * **Checking**: check the backup
           * **Preparing**: Prepare a backup
           * **Waiting**: Waiting for backup
           * **Uploading**: Upload backup
           * **Finished**: Complete backup
           * **Failed**: backup Failed
    :param str db_instance_id: The db instance id.
    :param str end_time: The end time.
    :param Sequence[str] ids: A list of Backup IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str start_time: The start time.
    """
    __args__ = dict()
    __args__['backupMode'] = backup_mode
    __args__['backupStatus'] = backup_status
    __args__['dbInstanceId'] = db_instance_id
    __args__['endTime'] = end_time
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['startTime'] = start_time
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:rds/getRdsBackups:getRdsBackups', __args__, opts=opts, typ=GetRdsBackupsResult).value

    return AwaitableGetRdsBackupsResult(
        backup_mode=pulumi.get(__ret__, 'backup_mode'),
        backup_status=pulumi.get(__ret__, 'backup_status'),
        backups=pulumi.get(__ret__, 'backups'),
        db_instance_id=pulumi.get(__ret__, 'db_instance_id'),
        end_time=pulumi.get(__ret__, 'end_time'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        start_time=pulumi.get(__ret__, 'start_time'))


@_utilities.lift_output_func(get_rds_backups)
def get_rds_backups_output(backup_mode: Optional[pulumi.Input[Optional[str]]] = None,
                           backup_status: Optional[pulumi.Input[Optional[str]]] = None,
                           db_instance_id: Optional[pulumi.Input[str]] = None,
                           end_time: Optional[pulumi.Input[Optional[str]]] = None,
                           ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                           output_file: Optional[pulumi.Input[Optional[str]]] = None,
                           start_time: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRdsBackupsResult]:
    """
    This data source provides the Rds Backups of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.149.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.rds.get_rds_backups(db_instance_id="example_value")
    pulumi.export("firstRdsBackupId", example.backups[0].id)
    ```


    :param str backup_mode: BackupMode.
    :param str backup_status: Backup task status. **NOTE:** This parameter will only be returned when a task is executed. Value:
           * **NoStart**: Not started
           * **Checking**: check the backup
           * **Preparing**: Prepare a backup
           * **Waiting**: Waiting for backup
           * **Uploading**: Upload backup
           * **Finished**: Complete backup
           * **Failed**: backup Failed
    :param str db_instance_id: The db instance id.
    :param str end_time: The end time.
    :param Sequence[str] ids: A list of Backup IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str start_time: The start time.
    """
    ...
