# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DbInstanceEndpointNodeItem',
    'DdrInstanceParameter',
    'DdrInstancePgHbaConf',
    'InstanceBabelfishConfig',
    'InstanceParameter',
    'InstancePgHbaConf',
    'InstanceServerlessConfig',
    'RdsCloneDbInstanceParameter',
    'RdsCloneDbInstancePgHbaConf',
    'RdsCloneDbInstanceServerlessConfig',
    'RdsDbProxyReadOnlyInstanceWeight',
    'RdsParameterGroupParamDetail',
    'RdsUpgradeDbInstanceParameter',
    'RdsUpgradeDbInstancePgHbaConf',
    'ReadOnlyInstanceParameter',
    'GetAccountsAccountResult',
    'GetAccountsAccountDatabasePrivilegeResult',
    'GetCollationTimeZonesCollationTimeZoneResult',
    'GetCrossRegionBackupsBackupResult',
    'GetCrossRegionsRegionResult',
    'GetInstanceClassInfosInfoResult',
    'GetInstanceClassesInstanceClassResult',
    'GetInstanceClassesInstanceClassStorageRangeResult',
    'GetInstanceClassesInstanceClassZoneIdResult',
    'GetInstanceEnginesInstanceEngineResult',
    'GetInstanceEnginesInstanceEngineZoneIdResult',
    'GetInstancesInstanceResult',
    'GetInstancesInstanceHostInstanceInfoResult',
    'GetInstancesInstanceParameterResult',
    'GetModifyParameterLogsLogResult',
    'GetRdsBackupsBackupResult',
    'GetRdsParameterGroupsGroupResult',
    'GetRdsParameterGroupsGroupParamDetailResult',
    'GetSlotsSlotResult',
    'GetZonesZoneResult',
]

@pulumi.output_type
class DbInstanceEndpointNodeItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeId":
            suggest = "node_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbInstanceEndpointNodeItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbInstanceEndpointNodeItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbInstanceEndpointNodeItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_id: str,
                 weight: int):
        """
        :param str node_id: The ID of the node.
        :param int weight: The weight of the node. Read requests are distributed based on the weight.Valid values: 0 to 100.
        """
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        The ID of the node.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        The weight of the node. Read requests are distributed based on the weight.Valid values: 0 to 100.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class DdrInstanceParameter(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The parameter name.
        :param str value: The parameter value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The parameter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DdrInstancePgHbaConf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "priorityId":
            suggest = "priority_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DdrInstancePgHbaConf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DdrInstancePgHbaConf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DdrInstancePgHbaConf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 database: str,
                 method: str,
                 priority_id: int,
                 type: str,
                 user: str,
                 mask: Optional[str] = None,
                 option: Optional[str] = None):
        """
        :param str address: The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        :param str database: The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        :param str method: The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        :param int priority_id: The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        :param str type: The type of connection to the instance. Valid values:
               * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
               * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
               * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.
               
               > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        :param str user: The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        :param str mask: The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        :param str option: Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "priority_id", priority_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user", user)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)
        if option is not None:
            pulumi.set(__self__, "option", option)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def method(self) -> str:
        """
        The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter(name="priorityId")
    def priority_id(self) -> int:
        """
        The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        """
        return pulumi.get(self, "priority_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of connection to the instance. Valid values:
        * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
        * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
        * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.

        > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def mask(self) -> Optional[str]:
        """
        The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        """
        return pulumi.get(self, "mask")

    @property
    @pulumi.getter
    def option(self) -> Optional[str]:
        """
        Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        return pulumi.get(self, "option")


@pulumi.output_type
class InstanceBabelfishConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "babelfishEnabled":
            suggest = "babelfish_enabled"
        elif key == "masterUserPassword":
            suggest = "master_user_password"
        elif key == "masterUsername":
            suggest = "master_username"
        elif key == "migrationMode":
            suggest = "migration_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceBabelfishConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceBabelfishConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceBabelfishConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 babelfish_enabled: str,
                 master_user_password: str,
                 master_username: str,
                 migration_mode: str):
        """
        :param str babelfish_enabled: specifies whether to enable the Babelfish for the instance. If you set this parameter to **true**, you enable Babelfish for the instance. If you leave this parameter empty, you disable Babelfish for the instance.
        :param str master_user_password: The password of the administrator account. The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. It must be 8 to 32 characters in length. The password can contain any of the following characters:! @ # $ % ^ & * () _ + - =
        :param str master_username: The name of the administrator account. The name can contain lowercase letters, digits, and underscores (_). It must start with a letter and end with a letter or digit. It can be up to 63 characters in length and cannot start with pg.
        :param str migration_mode: The migration mode of the instance. Valid values: **single-db** and **multi-db**.
        """
        pulumi.set(__self__, "babelfish_enabled", babelfish_enabled)
        pulumi.set(__self__, "master_user_password", master_user_password)
        pulumi.set(__self__, "master_username", master_username)
        pulumi.set(__self__, "migration_mode", migration_mode)

    @property
    @pulumi.getter(name="babelfishEnabled")
    def babelfish_enabled(self) -> str:
        """
        specifies whether to enable the Babelfish for the instance. If you set this parameter to **true**, you enable Babelfish for the instance. If you leave this parameter empty, you disable Babelfish for the instance.
        """
        return pulumi.get(self, "babelfish_enabled")

    @property
    @pulumi.getter(name="masterUserPassword")
    def master_user_password(self) -> str:
        """
        The password of the administrator account. The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. It must be 8 to 32 characters in length. The password can contain any of the following characters:! @ # $ % ^ & * () _ + - =
        """
        return pulumi.get(self, "master_user_password")

    @property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> str:
        """
        The name of the administrator account. The name can contain lowercase letters, digits, and underscores (_). It must start with a letter and end with a letter or digit. It can be up to 63 characters in length and cannot start with pg.
        """
        return pulumi.get(self, "master_username")

    @property
    @pulumi.getter(name="migrationMode")
    def migration_mode(self) -> str:
        """
        The migration mode of the instance. Valid values: **single-db** and **multi-db**.
        """
        return pulumi.get(self, "migration_mode")


@pulumi.output_type
class InstanceParameter(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The parameter name.
        :param str value: The parameter value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The parameter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InstancePgHbaConf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "priorityId":
            suggest = "priority_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePgHbaConf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePgHbaConf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePgHbaConf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 database: str,
                 method: str,
                 priority_id: int,
                 type: str,
                 user: str,
                 mask: Optional[str] = None,
                 option: Optional[str] = None):
        """
        :param str address: The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        :param str database: The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        :param str method: The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        :param int priority_id: The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        :param str type: The type of connection to the instance. Valid values:
               * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
               * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
               * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.
               
               > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        :param str user: The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        :param str mask: The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        :param str option: Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "priority_id", priority_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user", user)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)
        if option is not None:
            pulumi.set(__self__, "option", option)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def method(self) -> str:
        """
        The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter(name="priorityId")
    def priority_id(self) -> int:
        """
        The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        """
        return pulumi.get(self, "priority_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of connection to the instance. Valid values:
        * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
        * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
        * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.

        > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def mask(self) -> Optional[str]:
        """
        The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        """
        return pulumi.get(self, "mask")

    @property
    @pulumi.getter
    def option(self) -> Optional[str]:
        """
        Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        return pulumi.get(self, "option")


@pulumi.output_type
class InstanceServerlessConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"
        elif key == "autoPause":
            suggest = "auto_pause"
        elif key == "switchForce":
            suggest = "switch_force"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceServerlessConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceServerlessConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceServerlessConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_capacity: float,
                 min_capacity: float,
                 auto_pause: Optional[bool] = None,
                 switch_force: Optional[bool] = None):
        """
        :param float max_capacity: The maximum number of RDS Capacity Units (RCUs). The value of this parameter must be greater than or equal to `min_capacity` and only supports passing integers. Valid values:
               - MySQL: 1~8
               - SQLServer: 2~8
               - PostgreSQL: 1~12
        :param float min_capacity: The minimum number of RCUs. The value of this parameter must be less than or equal to `max_capacity`. Valid values:
               - MySQL: 0.5~8
               - SQLServer: 2~8 \\(Supports integers only\\).
               - PostgreSQL: 0.5~12
        :param bool auto_pause: Specifies whether to enable the smart startup and stop feature for the serverless instance. Valid values:
               - true: enables the feature.
               - false: disables the feature. This is the default value.
               > - Only MySQL Serverless instances need to set this parameter. If there is no connection within 10 minutes, it will enter a paused state and automatically wake up when the connection enters.
        :param bool switch_force: Specifies whether to enable the forced scaling feature for the serverless instance. Valid values:
               - true: enables the feature.
               - false: disables the feature. This is the default value.
               > - Only MySQL Serverless instances need to set this parameter. After enabling this parameter, there will be a flash break within 1 minute when the instance is forced to expand or shrink. Please use it with caution according to the actual situation.
               > - The elastic scaling of an instance RCU usually takes effect immediately, but in some special circumstances (such as during large transaction execution), it is not possible to complete scaling immediately. In this case, this parameter can be enabled to force scaling.
        """
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "min_capacity", min_capacity)
        if auto_pause is not None:
            pulumi.set(__self__, "auto_pause", auto_pause)
        if switch_force is not None:
            pulumi.set(__self__, "switch_force", switch_force)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> float:
        """
        The maximum number of RDS Capacity Units (RCUs). The value of this parameter must be greater than or equal to `min_capacity` and only supports passing integers. Valid values:
        - MySQL: 1~8
        - SQLServer: 2~8
        - PostgreSQL: 1~12
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> float:
        """
        The minimum number of RCUs. The value of this parameter must be less than or equal to `max_capacity`. Valid values:
        - MySQL: 0.5~8
        - SQLServer: 2~8 \\(Supports integers only\\).
        - PostgreSQL: 0.5~12
        """
        return pulumi.get(self, "min_capacity")

    @property
    @pulumi.getter(name="autoPause")
    def auto_pause(self) -> Optional[bool]:
        """
        Specifies whether to enable the smart startup and stop feature for the serverless instance. Valid values:
        - true: enables the feature.
        - false: disables the feature. This is the default value.
        > - Only MySQL Serverless instances need to set this parameter. If there is no connection within 10 minutes, it will enter a paused state and automatically wake up when the connection enters.
        """
        return pulumi.get(self, "auto_pause")

    @property
    @pulumi.getter(name="switchForce")
    def switch_force(self) -> Optional[bool]:
        """
        Specifies whether to enable the forced scaling feature for the serverless instance. Valid values:
        - true: enables the feature.
        - false: disables the feature. This is the default value.
        > - Only MySQL Serverless instances need to set this parameter. After enabling this parameter, there will be a flash break within 1 minute when the instance is forced to expand or shrink. Please use it with caution according to the actual situation.
        > - The elastic scaling of an instance RCU usually takes effect immediately, but in some special circumstances (such as during large transaction execution), it is not possible to complete scaling immediately. In this case, this parameter can be enabled to force scaling.
        """
        return pulumi.get(self, "switch_force")


@pulumi.output_type
class RdsCloneDbInstanceParameter(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The parameters name.
        :param str value: The parameters value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The parameters name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The parameters value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RdsCloneDbInstancePgHbaConf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "priorityId":
            suggest = "priority_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RdsCloneDbInstancePgHbaConf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RdsCloneDbInstancePgHbaConf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RdsCloneDbInstancePgHbaConf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 database: str,
                 method: str,
                 priority_id: int,
                 type: str,
                 user: str,
                 mask: Optional[str] = None,
                 option: Optional[str] = None):
        """
        :param str address: The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        :param str database: The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        :param str method: The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        :param int priority_id: The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        :param str type: The type of connection to the instance. Valid values:
               * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
               * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
               * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.
               
               > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        :param str user: The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        :param str mask: The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        :param str option: Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "priority_id", priority_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user", user)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)
        if option is not None:
            pulumi.set(__self__, "option", option)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def method(self) -> str:
        """
        The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter(name="priorityId")
    def priority_id(self) -> int:
        """
        The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        """
        return pulumi.get(self, "priority_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of connection to the instance. Valid values:
        * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
        * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
        * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.

        > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def mask(self) -> Optional[str]:
        """
        The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        """
        return pulumi.get(self, "mask")

    @property
    @pulumi.getter
    def option(self) -> Optional[str]:
        """
        Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        return pulumi.get(self, "option")


@pulumi.output_type
class RdsCloneDbInstanceServerlessConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"
        elif key == "autoPause":
            suggest = "auto_pause"
        elif key == "switchForce":
            suggest = "switch_force"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RdsCloneDbInstanceServerlessConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RdsCloneDbInstanceServerlessConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RdsCloneDbInstanceServerlessConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_capacity: float,
                 min_capacity: float,
                 auto_pause: Optional[bool] = None,
                 switch_force: Optional[bool] = None):
        """
        :param float max_capacity: The maximum number of RDS Capacity Units (RCUs). The value of this parameter must be greater than or equal to `min_capacity` and only supports passing integers. Valid values:
               - MySQL: 1~8
               - SQLServer: 2~8
               - PostgreSQL: 1~12
        :param float min_capacity: The minimum number of RCUs. The value of this parameter must be less than or equal to `max_capacity`. Valid values:
               - MySQL: 0.5~8
               - SQLServer: 2~8 \\(Supports integers only\\).
               - PostgreSQL: 0.5~12
        :param bool auto_pause: Specifies whether to enable the smart startup and stop feature for the serverless instance. Valid values:
               - true: enables the feature.
               - false: disables the feature. This is the default value.
               > - Only MySQL Serverless instances need to set this parameter. If there is no connection within 10 minutes, it will enter a paused state and automatically wake up when the connection enters.
        :param bool switch_force: Specifies whether to enable the forced scaling feature for the serverless instance. Valid values:
               - true: enables the feature.
               - false: disables the feature. This is the default value.
               > - Only MySQL Serverless instances need to set this parameter. After enabling this parameter, there will be a flash break within 1 minute when the instance is forced to expand or shrink. Please use it with caution according to the actual situation.
               > - The elastic scaling of an instance RCU usually takes effect immediately, but in some special circumstances (such as during large transaction execution), it is not possible to complete scaling immediately. In this case, this parameter can be enabled to force scaling.
        """
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "min_capacity", min_capacity)
        if auto_pause is not None:
            pulumi.set(__self__, "auto_pause", auto_pause)
        if switch_force is not None:
            pulumi.set(__self__, "switch_force", switch_force)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> float:
        """
        The maximum number of RDS Capacity Units (RCUs). The value of this parameter must be greater than or equal to `min_capacity` and only supports passing integers. Valid values:
        - MySQL: 1~8
        - SQLServer: 2~8
        - PostgreSQL: 1~12
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> float:
        """
        The minimum number of RCUs. The value of this parameter must be less than or equal to `max_capacity`. Valid values:
        - MySQL: 0.5~8
        - SQLServer: 2~8 \\(Supports integers only\\).
        - PostgreSQL: 0.5~12
        """
        return pulumi.get(self, "min_capacity")

    @property
    @pulumi.getter(name="autoPause")
    def auto_pause(self) -> Optional[bool]:
        """
        Specifies whether to enable the smart startup and stop feature for the serverless instance. Valid values:
        - true: enables the feature.
        - false: disables the feature. This is the default value.
        > - Only MySQL Serverless instances need to set this parameter. If there is no connection within 10 minutes, it will enter a paused state and automatically wake up when the connection enters.
        """
        return pulumi.get(self, "auto_pause")

    @property
    @pulumi.getter(name="switchForce")
    def switch_force(self) -> Optional[bool]:
        """
        Specifies whether to enable the forced scaling feature for the serverless instance. Valid values:
        - true: enables the feature.
        - false: disables the feature. This is the default value.
        > - Only MySQL Serverless instances need to set this parameter. After enabling this parameter, there will be a flash break within 1 minute when the instance is forced to expand or shrink. Please use it with caution according to the actual situation.
        > - The elastic scaling of an instance RCU usually takes effect immediately, but in some special circumstances (such as during large transaction execution), it is not possible to complete scaling immediately. In this case, this parameter can be enabled to force scaling.
        """
        return pulumi.get(self, "switch_force")


@pulumi.output_type
class RdsDbProxyReadOnlyInstanceWeight(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RdsDbProxyReadOnlyInstanceWeight. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RdsDbProxyReadOnlyInstanceWeight.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RdsDbProxyReadOnlyInstanceWeight.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_id: str,
                 weight: str):
        """
        :param str instance_id: The Id of the instance and its read-only instances that can run database.
        :param str weight: Weight of instances that can run the database and their read-only instances. Read weights increase in increments of 100, and the maximum read weight is 10000.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The Id of the instance and its read-only instances that can run database.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def weight(self) -> str:
        """
        Weight of instances that can run the database and their read-only instances. Read weights increase in increments of 100, and the maximum read weight is 10000.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class RdsParameterGroupParamDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "paramName":
            suggest = "param_name"
        elif key == "paramValue":
            suggest = "param_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RdsParameterGroupParamDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RdsParameterGroupParamDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RdsParameterGroupParamDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 param_name: str,
                 param_value: str):
        """
        :param str param_name: The name of a parameter.
        :param str param_value: The value of a parameter.
        """
        pulumi.set(__self__, "param_name", param_name)
        pulumi.set(__self__, "param_value", param_value)

    @property
    @pulumi.getter(name="paramName")
    def param_name(self) -> str:
        """
        The name of a parameter.
        """
        return pulumi.get(self, "param_name")

    @property
    @pulumi.getter(name="paramValue")
    def param_value(self) -> str:
        """
        The value of a parameter.
        """
        return pulumi.get(self, "param_value")


@pulumi.output_type
class RdsUpgradeDbInstanceParameter(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The parameter name.
        :param str value: The parameter value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The parameter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RdsUpgradeDbInstancePgHbaConf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "priorityId":
            suggest = "priority_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RdsUpgradeDbInstancePgHbaConf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RdsUpgradeDbInstancePgHbaConf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RdsUpgradeDbInstancePgHbaConf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 database: str,
                 method: str,
                 priority_id: int,
                 type: str,
                 user: str,
                 mask: Optional[str] = None,
                 option: Optional[str] = None):
        """
        :param str address: The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        :param str database: The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        :param str method: The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        :param int priority_id: The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        :param str type: The type of connection to the instance. Valid values:
               * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
               * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
               * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.
               
               > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        :param str user: The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        :param str mask: The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        :param str option: Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "priority_id", priority_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user", user)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)
        if option is not None:
            pulumi.set(__self__, "option", option)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def method(self) -> str:
        """
        The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter(name="priorityId")
    def priority_id(self) -> int:
        """
        The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
        """
        return pulumi.get(self, "priority_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of connection to the instance. Valid values:
        * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
        * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
        * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.

        > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def mask(self) -> Optional[str]:
        """
        The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
        """
        return pulumi.get(self, "mask")

    @property
    @pulumi.getter
    def option(self) -> Optional[str]:
        """
        Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
        """
        return pulumi.get(self, "option")


@pulumi.output_type
class ReadOnlyInstanceParameter(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The parameter name.
        :param str value: The parameter value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The parameter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAccountsAccountResult(dict):
    def __init__(__self__, *,
                 account_description: str,
                 account_name: str,
                 account_type: str,
                 database_privileges: Sequence['outputs.GetAccountsAccountDatabasePrivilegeResult'],
                 id: str,
                 priv_exceeded: str,
                 status: str):
        """
        :param str account_description: Database description.
        :param str account_name: Name of database account.
        :param str account_type: Privilege type of account.
        :param Sequence['GetAccountsAccountDatabasePrivilegeArgs'] database_privileges: A list of database permissions the account has.
        :param str id: The ID of the Account.
        :param str priv_exceeded: Whether the maximum number of databases managed by the account is exceeded.
        :param str status: The status of the resource.
        """
        pulumi.set(__self__, "account_description", account_description)
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "account_type", account_type)
        pulumi.set(__self__, "database_privileges", database_privileges)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "priv_exceeded", priv_exceeded)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="accountDescription")
    def account_description(self) -> str:
        """
        Database description.
        """
        return pulumi.get(self, "account_description")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        Name of database account.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="accountType")
    def account_type(self) -> str:
        """
        Privilege type of account.
        """
        return pulumi.get(self, "account_type")

    @property
    @pulumi.getter(name="databasePrivileges")
    def database_privileges(self) -> Sequence['outputs.GetAccountsAccountDatabasePrivilegeResult']:
        """
        A list of database permissions the account has.
        """
        return pulumi.get(self, "database_privileges")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Account.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="privExceeded")
    def priv_exceeded(self) -> str:
        """
        Whether the maximum number of databases managed by the account is exceeded.
        """
        return pulumi.get(self, "priv_exceeded")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetAccountsAccountDatabasePrivilegeResult(dict):
    def __init__(__self__, *,
                 account_privilege: str,
                 account_privilege_detail: str,
                 db_name: str):
        """
        :param str account_privilege: The type of permission for the account.
        :param str account_privilege_detail: The specific permissions corresponding to the type of account permissions.
        :param str db_name: Database name.
        """
        pulumi.set(__self__, "account_privilege", account_privilege)
        pulumi.set(__self__, "account_privilege_detail", account_privilege_detail)
        pulumi.set(__self__, "db_name", db_name)

    @property
    @pulumi.getter(name="accountPrivilege")
    def account_privilege(self) -> str:
        """
        The type of permission for the account.
        """
        return pulumi.get(self, "account_privilege")

    @property
    @pulumi.getter(name="accountPrivilegeDetail")
    def account_privilege_detail(self) -> str:
        """
        The specific permissions corresponding to the type of account permissions.
        """
        return pulumi.get(self, "account_privilege_detail")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> str:
        """
        Database name.
        """
        return pulumi.get(self, "db_name")


@pulumi.output_type
class GetCollationTimeZonesCollationTimeZoneResult(dict):
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 standard_time_offset: Optional[str] = None,
                 time_zone: Optional[str] = None):
        """
        :param str description: The code of the instance type.
        :param str standard_time_offset: The offset of the UTC time. The offset is in the following format: (UTC+<i>HH:mm</i>).
        :param str time_zone: The time zone that is available for use in ApsaraDB RDS.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if standard_time_offset is not None:
            pulumi.set(__self__, "standard_time_offset", standard_time_offset)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The code of the instance type.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="standardTimeOffset")
    def standard_time_offset(self) -> Optional[str]:
        """
        The offset of the UTC time. The offset is in the following format: (UTC+<i>HH:mm</i>).
        """
        return pulumi.get(self, "standard_time_offset")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        The time zone that is available for use in ApsaraDB RDS.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class GetCrossRegionBackupsBackupResult(dict):
    def __init__(__self__, *,
                 backup_end_time: str,
                 backup_method: str,
                 backup_set_scale: str,
                 backup_set_status: int,
                 backup_start_time: str,
                 backup_type: str,
                 category: str,
                 consistent_time: str,
                 cross_backup_download_link: str,
                 cross_backup_id: str,
                 cross_backup_region: str,
                 cross_backup_set_file: str,
                 cross_backup_set_location: str,
                 cross_backup_set_size: int,
                 db_instance_storage_type: str,
                 engine: str,
                 engine_version: str,
                 id: str,
                 instance_id: int,
                 recovery_begin_time: str,
                 recovery_end_time: str,
                 restore_regions: Sequence[str]):
        """
        :param str backup_end_time: The time when the cross-region data backup file was generated.
        :param str backup_method: The method that is used to generate the cross-region data backup file. Valid values:
               `L` - logical backup.
               `P` - physical backup.
        :param str backup_set_scale: The level at which the cross-region data backup file is generated.
               `0` - instance-level backup.
               `1` - database-level backup.
        :param int backup_set_status: TThe status of the cross-region data backup. Valid values:
               `0` - The cross-region data backup is successful.
               `1` - The cross-region data backup failed.
        :param str backup_start_time: The time when the cross-region data backup started.
        :param str backup_type: The type of the cross-region data backup. Valid values:F: full data backup
               `F` - full data backup.
               `I` - incremental data backup.
        :param str category: The RDS edition of the instance. Valid values:
               `Basic` - Basic Edition.
               `HighAvailability` - High-availability Edition.
               `Finance` - Enterprise Edition. This edition is supported only by the China site (aliyun.com).
        :param str consistent_time: The point in time that is indicated by the data in the cross-region data backup file.
        :param str cross_backup_download_link: The external URL from which you can download the cross-region data backup file.
        :param str cross_backup_id: The ID of the cross-region data backup file.
        :param str cross_backup_region: The ID of the destination region where the cross-region data backup file of the instance is stored.
        :param str cross_backup_set_file: The name of the compressed package that contains the cross-region data backup file.
        :param str cross_backup_set_location: The location where the cross-region data backup file is stored.
        :param int cross_backup_set_size: The size of the cross-region data backup file. Unit: bytes.
        :param str db_instance_storage_type: The storage type.
        :param str engine: The engine of the database.
        :param str engine_version: The version of the database engine.
        :param str id: The ID of the cross-region data backup file.
        :param int instance_id: The ID of the instance. This parameter is used to determine whether the instance that generates the cross-region data backup file is a primary or secondary instance.
        :param str recovery_begin_time: The start time to which data can be restored. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param str recovery_end_time: The end time to which data can be restored. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param Sequence[str] restore_regions: An array that consists of the regions to which the cross-region data backup file can be restored.
        """
        pulumi.set(__self__, "backup_end_time", backup_end_time)
        pulumi.set(__self__, "backup_method", backup_method)
        pulumi.set(__self__, "backup_set_scale", backup_set_scale)
        pulumi.set(__self__, "backup_set_status", backup_set_status)
        pulumi.set(__self__, "backup_start_time", backup_start_time)
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "consistent_time", consistent_time)
        pulumi.set(__self__, "cross_backup_download_link", cross_backup_download_link)
        pulumi.set(__self__, "cross_backup_id", cross_backup_id)
        pulumi.set(__self__, "cross_backup_region", cross_backup_region)
        pulumi.set(__self__, "cross_backup_set_file", cross_backup_set_file)
        pulumi.set(__self__, "cross_backup_set_location", cross_backup_set_location)
        pulumi.set(__self__, "cross_backup_set_size", cross_backup_set_size)
        pulumi.set(__self__, "db_instance_storage_type", db_instance_storage_type)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "recovery_begin_time", recovery_begin_time)
        pulumi.set(__self__, "recovery_end_time", recovery_end_time)
        pulumi.set(__self__, "restore_regions", restore_regions)

    @property
    @pulumi.getter(name="backupEndTime")
    def backup_end_time(self) -> str:
        """
        The time when the cross-region data backup file was generated.
        """
        return pulumi.get(self, "backup_end_time")

    @property
    @pulumi.getter(name="backupMethod")
    def backup_method(self) -> str:
        """
        The method that is used to generate the cross-region data backup file. Valid values:
        `L` - logical backup.
        `P` - physical backup.
        """
        return pulumi.get(self, "backup_method")

    @property
    @pulumi.getter(name="backupSetScale")
    def backup_set_scale(self) -> str:
        """
        The level at which the cross-region data backup file is generated.
        `0` - instance-level backup.
        `1` - database-level backup.
        """
        return pulumi.get(self, "backup_set_scale")

    @property
    @pulumi.getter(name="backupSetStatus")
    def backup_set_status(self) -> int:
        """
        TThe status of the cross-region data backup. Valid values:
        `0` - The cross-region data backup is successful.
        `1` - The cross-region data backup failed.
        """
        return pulumi.get(self, "backup_set_status")

    @property
    @pulumi.getter(name="backupStartTime")
    def backup_start_time(self) -> str:
        """
        The time when the cross-region data backup started.
        """
        return pulumi.get(self, "backup_start_time")

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> str:
        """
        The type of the cross-region data backup. Valid values:F: full data backup
        `F` - full data backup.
        `I` - incremental data backup.
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        The RDS edition of the instance. Valid values:
        `Basic` - Basic Edition.
        `HighAvailability` - High-availability Edition.
        `Finance` - Enterprise Edition. This edition is supported only by the China site (aliyun.com).
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="consistentTime")
    def consistent_time(self) -> str:
        """
        The point in time that is indicated by the data in the cross-region data backup file.
        """
        return pulumi.get(self, "consistent_time")

    @property
    @pulumi.getter(name="crossBackupDownloadLink")
    def cross_backup_download_link(self) -> str:
        """
        The external URL from which you can download the cross-region data backup file.
        """
        return pulumi.get(self, "cross_backup_download_link")

    @property
    @pulumi.getter(name="crossBackupId")
    def cross_backup_id(self) -> str:
        """
        The ID of the cross-region data backup file.
        """
        return pulumi.get(self, "cross_backup_id")

    @property
    @pulumi.getter(name="crossBackupRegion")
    def cross_backup_region(self) -> str:
        """
        The ID of the destination region where the cross-region data backup file of the instance is stored.
        """
        return pulumi.get(self, "cross_backup_region")

    @property
    @pulumi.getter(name="crossBackupSetFile")
    def cross_backup_set_file(self) -> str:
        """
        The name of the compressed package that contains the cross-region data backup file.
        """
        return pulumi.get(self, "cross_backup_set_file")

    @property
    @pulumi.getter(name="crossBackupSetLocation")
    def cross_backup_set_location(self) -> str:
        """
        The location where the cross-region data backup file is stored.
        """
        return pulumi.get(self, "cross_backup_set_location")

    @property
    @pulumi.getter(name="crossBackupSetSize")
    def cross_backup_set_size(self) -> int:
        """
        The size of the cross-region data backup file. Unit: bytes.
        """
        return pulumi.get(self, "cross_backup_set_size")

    @property
    @pulumi.getter(name="dbInstanceStorageType")
    def db_instance_storage_type(self) -> str:
        """
        The storage type.
        """
        return pulumi.get(self, "db_instance_storage_type")

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        The engine of the database.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> str:
        """
        The version of the database engine.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the cross-region data backup file.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> int:
        """
        The ID of the instance. This parameter is used to determine whether the instance that generates the cross-region data backup file is a primary or secondary instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="recoveryBeginTime")
    def recovery_begin_time(self) -> str:
        """
        The start time to which data can be restored. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "recovery_begin_time")

    @property
    @pulumi.getter(name="recoveryEndTime")
    def recovery_end_time(self) -> str:
        """
        The end time to which data can be restored. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "recovery_end_time")

    @property
    @pulumi.getter(name="restoreRegions")
    def restore_regions(self) -> Sequence[str]:
        """
        An array that consists of the regions to which the cross-region data backup file can be restored.
        """
        return pulumi.get(self, "restore_regions")


@pulumi.output_type
class GetCrossRegionsRegionResult(dict):
    def __init__(__self__, *,
                 id: str):
        """
        :param str id: ID of the region.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the region.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetInstanceClassInfosInfoResult(dict):
    def __init__(__self__, *,
                 class_code: Optional[str] = None,
                 class_group: Optional[str] = None,
                 cpu: Optional[str] = None,
                 instruction_set_arch: Optional[str] = None,
                 max_connections: Optional[str] = None,
                 max_iombps: Optional[str] = None,
                 max_iops: Optional[str] = None,
                 memory_class: Optional[str] = None,
                 reference_price: Optional[str] = None):
        """
        :param str class_code: The code of the instance type.
        :param str class_group: The instance family of the instance.
        :param str cpu: The number of cores that are supported by the instance type. Unit: cores.
        :param str instruction_set_arch: The architecture of the instance type.
        :param str max_connections: The maximum number of connections that are supported by the instance type. Unit: connections.
        :param str max_iombps: The maximum I/O bandwidth that is supported by the instance type. Unit: Mbit/s.
        :param str max_iops: The maximum input/output operations per second (IOPS) that is supported by the instance type. Unit: operations per second.
        :param str memory_class: The memory capacity that is supported by the instance type. Unit: GB.
        :param str reference_price: The fee that you must pay for the instance type. Unit: cent (USD).
        """
        if class_code is not None:
            pulumi.set(__self__, "class_code", class_code)
        if class_group is not None:
            pulumi.set(__self__, "class_group", class_group)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if instruction_set_arch is not None:
            pulumi.set(__self__, "instruction_set_arch", instruction_set_arch)
        if max_connections is not None:
            pulumi.set(__self__, "max_connections", max_connections)
        if max_iombps is not None:
            pulumi.set(__self__, "max_iombps", max_iombps)
        if max_iops is not None:
            pulumi.set(__self__, "max_iops", max_iops)
        if memory_class is not None:
            pulumi.set(__self__, "memory_class", memory_class)
        if reference_price is not None:
            pulumi.set(__self__, "reference_price", reference_price)

    @property
    @pulumi.getter(name="classCode")
    def class_code(self) -> Optional[str]:
        """
        The code of the instance type.
        """
        return pulumi.get(self, "class_code")

    @property
    @pulumi.getter(name="classGroup")
    def class_group(self) -> Optional[str]:
        """
        The instance family of the instance.
        """
        return pulumi.get(self, "class_group")

    @property
    @pulumi.getter
    def cpu(self) -> Optional[str]:
        """
        The number of cores that are supported by the instance type. Unit: cores.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="instructionSetArch")
    def instruction_set_arch(self) -> Optional[str]:
        """
        The architecture of the instance type.
        """
        return pulumi.get(self, "instruction_set_arch")

    @property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> Optional[str]:
        """
        The maximum number of connections that are supported by the instance type. Unit: connections.
        """
        return pulumi.get(self, "max_connections")

    @property
    @pulumi.getter(name="maxIombps")
    def max_iombps(self) -> Optional[str]:
        """
        The maximum I/O bandwidth that is supported by the instance type. Unit: Mbit/s.
        """
        return pulumi.get(self, "max_iombps")

    @property
    @pulumi.getter(name="maxIops")
    def max_iops(self) -> Optional[str]:
        """
        The maximum input/output operations per second (IOPS) that is supported by the instance type. Unit: operations per second.
        """
        return pulumi.get(self, "max_iops")

    @property
    @pulumi.getter(name="memoryClass")
    def memory_class(self) -> Optional[str]:
        """
        The memory capacity that is supported by the instance type. Unit: GB.
        """
        return pulumi.get(self, "memory_class")

    @property
    @pulumi.getter(name="referencePrice")
    def reference_price(self) -> Optional[str]:
        """
        The fee that you must pay for the instance type. Unit: cent (USD).
        """
        return pulumi.get(self, "reference_price")


@pulumi.output_type
class GetInstanceClassesInstanceClassResult(dict):
    def __init__(__self__, *,
                 instance_class: str,
                 price: str,
                 storage_range: 'outputs.GetInstanceClassesInstanceClassStorageRangeResult',
                 zone_ids: Sequence['outputs.GetInstanceClassesInstanceClassZoneIdResult']):
        """
        :param str instance_class: DB Instance available class.
        :param 'GetInstanceClassesInstanceClassStorageRangeArgs' storage_range: DB Instance available storage range.
        :param Sequence['GetInstanceClassesInstanceClassZoneIdArgs'] zone_ids: A list of Zone to launch the DB instance.
        """
        pulumi.set(__self__, "instance_class", instance_class)
        pulumi.set(__self__, "price", price)
        pulumi.set(__self__, "storage_range", storage_range)
        pulumi.set(__self__, "zone_ids", zone_ids)

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> str:
        """
        DB Instance available class.
        """
        return pulumi.get(self, "instance_class")

    @property
    @pulumi.getter
    def price(self) -> str:
        return pulumi.get(self, "price")

    @property
    @pulumi.getter(name="storageRange")
    def storage_range(self) -> 'outputs.GetInstanceClassesInstanceClassStorageRangeResult':
        """
        DB Instance available storage range.
        """
        return pulumi.get(self, "storage_range")

    @property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> Sequence['outputs.GetInstanceClassesInstanceClassZoneIdResult']:
        """
        A list of Zone to launch the DB instance.
        """
        return pulumi.get(self, "zone_ids")


@pulumi.output_type
class GetInstanceClassesInstanceClassStorageRangeResult(dict):
    def __init__(__self__, *,
                 max: str,
                 min: str,
                 step: str):
        """
        :param str max: DB Instance available storage max value.
        :param str min: DB Instance available storage min value.
        :param str step: DB Instance available storage increase step.
        """
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)
        pulumi.set(__self__, "step", step)

    @property
    @pulumi.getter
    def max(self) -> str:
        """
        DB Instance available storage max value.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> str:
        """
        DB Instance available storage min value.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter
    def step(self) -> str:
        """
        DB Instance available storage increase step.
        """
        return pulumi.get(self, "step")


@pulumi.output_type
class GetInstanceClassesInstanceClassZoneIdResult(dict):
    def __init__(__self__, *,
                 id: str,
                 sub_zone_ids: Sequence[str]):
        """
        :param str id: The Zone to launch the DB instance
        :param Sequence[str] sub_zone_ids: A list of sub zone ids which in the id - e.g If `id` is `cn-beijing-MAZ5(a,b)`, `sub_zone_ids` will be `["cn-beijing-a", "cn-beijing-b"]`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "sub_zone_ids", sub_zone_ids)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Zone to launch the DB instance
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="subZoneIds")
    def sub_zone_ids(self) -> Sequence[str]:
        """
        A list of sub zone ids which in the id - e.g If `id` is `cn-beijing-MAZ5(a,b)`, `sub_zone_ids` will be `["cn-beijing-a", "cn-beijing-b"]`.
        """
        return pulumi.get(self, "sub_zone_ids")


@pulumi.output_type
class GetInstanceEnginesInstanceEngineResult(dict):
    def __init__(__self__, *,
                 category: str,
                 engine: str,
                 engine_version: str,
                 zone_ids: Sequence['outputs.GetInstanceEnginesInstanceEngineZoneIdResult']):
        """
        :param str category: DB Instance category. the value like [`Basic`, `HighAvailability`, `Finance`, `AlwaysOn`], [detail info](https://www.alibabacloud.com/help/doc-detail/69795.htm).
        :param str engine: Database type. Valid values: "MySQL", "SQLServer", "PostgreSQL", "MariaDB". If not set, it will match all of engines.
        :param str engine_version: Database version required by the user. Value options can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
        :param Sequence['GetInstanceEnginesInstanceEngineZoneIdArgs'] zone_ids: A list of Zone to launch the DB instance.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "zone_ids", zone_ids)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        DB Instance category. the value like [`Basic`, `HighAvailability`, `Finance`, `AlwaysOn`], [detail info](https://www.alibabacloud.com/help/doc-detail/69795.htm).
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        Database type. Valid values: "MySQL", "SQLServer", "PostgreSQL", "MariaDB". If not set, it will match all of engines.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> str:
        """
        Database version required by the user. Value options can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> Sequence['outputs.GetInstanceEnginesInstanceEngineZoneIdResult']:
        """
        A list of Zone to launch the DB instance.
        """
        return pulumi.get(self, "zone_ids")


@pulumi.output_type
class GetInstanceEnginesInstanceEngineZoneIdResult(dict):
    def __init__(__self__, *,
                 id: str,
                 sub_zone_ids: Sequence[str]):
        """
        :param str id: The Zone to launch the DB instance
        :param Sequence[str] sub_zone_ids: A list of sub zone ids which in the id - e.g If `id` is `cn-beijing-MAZ5(a,b)`, `sub_zone_ids` will be `["cn-beijing-a", "cn-beijing-b"]`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "sub_zone_ids", sub_zone_ids)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Zone to launch the DB instance
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="subZoneIds")
    def sub_zone_ids(self) -> Sequence[str]:
        """
        A list of sub zone ids which in the id - e.g If `id` is `cn-beijing-MAZ5(a,b)`, `sub_zone_ids` will be `["cn-beijing-a", "cn-beijing-b"]`.
        """
        return pulumi.get(self, "sub_zone_ids")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 acl: str,
                 availability_zone: str,
                 ca_type: str,
                 charge_type: str,
                 client_ca_cert: str,
                 client_ca_cert_expire_time: str,
                 client_cert_revocation_list: str,
                 connection_mode: str,
                 connection_string: str,
                 create_time: str,
                 creator: str,
                 db_instance_storage_type: str,
                 db_instance_type: str,
                 db_type: str,
                 delete_date: str,
                 deletion_protection: bool,
                 description: str,
                 encryption_key: str,
                 encryption_key_status: str,
                 engine: str,
                 engine_version: str,
                 expire_time: str,
                 guard_instance_id: str,
                 ha_mode: str,
                 host_instance_infos: Sequence['outputs.GetInstancesInstanceHostInstanceInfoResult'],
                 id: str,
                 instance_storage: int,
                 instance_type: str,
                 key_usage: str,
                 last_modify_status: str,
                 master_instance_id: str,
                 master_zone: str,
                 material_expire_time: str,
                 modify_status_reason: str,
                 name: str,
                 net_type: str,
                 origin: str,
                 parameters: Sequence['outputs.GetInstancesInstanceParameterResult'],
                 port: str,
                 readonly_instance_ids: Sequence[str],
                 region_id: str,
                 replication_acl: str,
                 require_update: str,
                 require_update_item: str,
                 require_update_reason: str,
                 server_ca_url: str,
                 server_cert: str,
                 server_key: str,
                 ssl_create_time: str,
                 ssl_enabled: str,
                 ssl_expire_time: str,
                 status: str,
                 sync_mode: str,
                 temp_instance_id: str,
                 vpc_id: str,
                 vswitch_id: str,
                 zone_id_slave_a: str,
                 zone_id_slave_b: str):
        """
        :param str acl: (Available in 1.124.1+) The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param str availability_zone: Availability zone.
        :param str ca_type: (Available in 1.124.1+) The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
               - aliyun: a cloud certificate
               - custom: a custom certificate
        :param str charge_type: Billing method. Value options: `Postpaid` for Pay-As-You-Go and `Prepaid` for subscription.
        :param str client_ca_cert: (Available in 1.124.1+) The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        :param str client_ca_cert_expire_time: (Available in 1.124.1+) The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with cloud disks. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC. This parameter is not supported now.
        :param str client_cert_revocation_list: (Available in 1.124.1+) The certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        :param str connection_mode: `Standard` for standard access mode and `Safe` for high security access mode.
        :param str connection_string: (Available in 1.70.3+) RDS database connection string.
        :param str create_time: Creation time of the instance.
        :param str creator: (Available in 1.124.3+) The creator of the encryption key.
        :param str db_instance_storage_type: (Available in 1.70.3+) The storage type of the instance.
        :param str db_instance_type: (Available in 1.197.0+) The type of instance.
        :param str db_type: `Primary` for primary instance, `Readonly` for read-only instance, `Guard` for disaster recovery instance, and `Temp` for temporary instance.
        :param str delete_date: (Available in 1.124.3+) The estimated time when the encryption key will be deleted. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param bool deletion_protection: (Available in 1.167.0+) Indicates whether the release protection feature is enabled for the instance. Valid values:
               * **true**: The release protection feature is enabled.
               * **false**: The release protection feature is disabled.
        :param str description: (Available in 1.124.3+) The description of the encryption key.
        :param str encryption_key: (Available in 1.124.3+) The ID of the encryption key.
        :param str encryption_key_status: (Available in 1.124.3+) The status of the encryption key. Valid values:
               - Enabled
               - Disabled
        :param str engine: Database type. Options are `MySQL`, `SQLServer`, `PostgreSQL`, `MariaDB`. If no value is specified, all types are returned.
        :param str engine_version: Database version.
        :param str expire_time: Expiration time. Pay-As-You-Go instances never expire.
        :param str guard_instance_id: If a disaster recovery instance is attached to the current instance, the ID of the disaster recovery instance applies.
        :param str ha_mode: (Available since v1.209.1) The high availability mode of the instance.
        :param Sequence['GetInstancesInstanceHostInstanceInfoArgs'] host_instance_infos: (Available since v1.209.1) An array that consists of the information of the primary and secondary instances.
        :param str id: The ID of the RDS instance.
        :param int instance_storage: (Available in 1.70.3+) User-defined DB instance storage space.
        :param str instance_type: Sizing of the RDS instance.
        :param str key_usage: (Available in 1.124.3+) The purpose of the encryption key.
        :param str last_modify_status: (Available in 1.124.1+) The status of the SSL link. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
               - success
               - setting
               - failed
        :param str master_instance_id: ID of the primary instance. If this parameter is not returned, the current instance is a primary instance.
        :param str master_zone: (Available in 1.101.0+) The master zone of the instance.
        :param str material_expire_time: (Available in 1.124.3+) The time when the encryption key expires. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param str modify_status_reason: (Available in 1.124.1+) The reason why the SSL link stays in the current state. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        :param str name: The name of the RDS instance.
        :param str net_type: `Internet` for public network or `Intranet` for private network.
        :param str origin: (Available in 1.124.3+) The source of the encryption key.
        :param Sequence['GetInstancesInstanceParameterArgs'] parameters: (Available in 1.135.0+) Parameter list.
        :param str port: (Available in 1.70.3+) RDS database connection port.
        :param Sequence[str] readonly_instance_ids: A list of IDs of read-only instances attached to the primary instance.
        :param str region_id: The region ID of the instance.
        :param str replication_acl: (Available in 1.124.1+) The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param str require_update: (Available in 1.124.1+) Indicates whether the server certificate needs to be updated.
               - Valid values for ApsaraDB RDS for MySQL and ApsaraDB RDS for SQL Server:
               - No
               - Yes
               - Valid values for ApsaraDB RDS for PostgreSQL:
               - 0: no
               - 1: yes
        :param str require_update_item: (Available in 1.124.1+) The server certificate that needs to be updated. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        :param str require_update_reason: (Available in 1.124.1+) The reason why the server certificate needs to be updated. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        :param str server_ca_url: (Available in 1.124.1+) The URL of the CA that issues the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        :param str server_cert: (Available in 1.124.1+) The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        :param str server_key: (Available in 1.124.1+) The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        :param str ssl_create_time: (Available in 1.124.1+) The time when the server certificate was created. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is valid only when the CAType parameter is set to aliyun.
        :param str ssl_enabled: (Available in 1.124.1+) Indicates whether SSL encryption is enabled. Valid values:
               - on: enabled
               - off: disabled
        :param str ssl_expire_time: (Available in 1.124.1+) The time when the server certificate expires. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param str status: Status of the instance.
        :param str sync_mode: (Available since v1.209.1) The data replication mode of the instance.
        :param str temp_instance_id: If a temporary instance is attached to the current instance, the ID of the temporary instance applies.
        :param str vpc_id: Used to retrieve instances belong to specified VPC.
        :param str vswitch_id: Used to retrieve instances belong to specified `vswitch` resources.
        :param str zone_id_slave_a: (Available in 1.101.0+) The region ID of the secondary instance if you create a secondary instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
        :param str zone_id_slave_b: (Available in 1.101.0+) The region ID of the log instance if you create a log instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
        """
        pulumi.set(__self__, "acl", acl)
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "ca_type", ca_type)
        pulumi.set(__self__, "charge_type", charge_type)
        pulumi.set(__self__, "client_ca_cert", client_ca_cert)
        pulumi.set(__self__, "client_ca_cert_expire_time", client_ca_cert_expire_time)
        pulumi.set(__self__, "client_cert_revocation_list", client_cert_revocation_list)
        pulumi.set(__self__, "connection_mode", connection_mode)
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "creator", creator)
        pulumi.set(__self__, "db_instance_storage_type", db_instance_storage_type)
        pulumi.set(__self__, "db_instance_type", db_instance_type)
        pulumi.set(__self__, "db_type", db_type)
        pulumi.set(__self__, "delete_date", delete_date)
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "encryption_key", encryption_key)
        pulumi.set(__self__, "encryption_key_status", encryption_key_status)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "guard_instance_id", guard_instance_id)
        pulumi.set(__self__, "ha_mode", ha_mode)
        pulumi.set(__self__, "host_instance_infos", host_instance_infos)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_storage", instance_storage)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "key_usage", key_usage)
        pulumi.set(__self__, "last_modify_status", last_modify_status)
        pulumi.set(__self__, "master_instance_id", master_instance_id)
        pulumi.set(__self__, "master_zone", master_zone)
        pulumi.set(__self__, "material_expire_time", material_expire_time)
        pulumi.set(__self__, "modify_status_reason", modify_status_reason)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "net_type", net_type)
        pulumi.set(__self__, "origin", origin)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "readonly_instance_ids", readonly_instance_ids)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "replication_acl", replication_acl)
        pulumi.set(__self__, "require_update", require_update)
        pulumi.set(__self__, "require_update_item", require_update_item)
        pulumi.set(__self__, "require_update_reason", require_update_reason)
        pulumi.set(__self__, "server_ca_url", server_ca_url)
        pulumi.set(__self__, "server_cert", server_cert)
        pulumi.set(__self__, "server_key", server_key)
        pulumi.set(__self__, "ssl_create_time", ssl_create_time)
        pulumi.set(__self__, "ssl_enabled", ssl_enabled)
        pulumi.set(__self__, "ssl_expire_time", ssl_expire_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "sync_mode", sync_mode)
        pulumi.set(__self__, "temp_instance_id", temp_instance_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id_slave_a", zone_id_slave_a)
        pulumi.set(__self__, "zone_id_slave_b", zone_id_slave_b)

    @property
    @pulumi.getter
    def acl(self) -> str:
        """
        (Available in 1.124.1+) The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Availability zone.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="caType")
    def ca_type(self) -> str:
        """
        (Available in 1.124.1+) The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
        - aliyun: a cloud certificate
        - custom: a custom certificate
        """
        return pulumi.get(self, "ca_type")

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> str:
        """
        Billing method. Value options: `Postpaid` for Pay-As-You-Go and `Prepaid` for subscription.
        """
        return pulumi.get(self, "charge_type")

    @property
    @pulumi.getter(name="clientCaCert")
    def client_ca_cert(self) -> str:
        """
        (Available in 1.124.1+) The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        """
        return pulumi.get(self, "client_ca_cert")

    @property
    @pulumi.getter(name="clientCaCertExpireTime")
    def client_ca_cert_expire_time(self) -> str:
        """
        (Available in 1.124.1+) The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with cloud disks. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC. This parameter is not supported now.
        """
        return pulumi.get(self, "client_ca_cert_expire_time")

    @property
    @pulumi.getter(name="clientCertRevocationList")
    def client_cert_revocation_list(self) -> str:
        """
        (Available in 1.124.1+) The certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        """
        return pulumi.get(self, "client_cert_revocation_list")

    @property
    @pulumi.getter(name="connectionMode")
    def connection_mode(self) -> str:
        """
        `Standard` for standard access mode and `Safe` for high security access mode.
        """
        return pulumi.get(self, "connection_mode")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> str:
        """
        (Available in 1.70.3+) RDS database connection string.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Creation time of the instance.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def creator(self) -> str:
        """
        (Available in 1.124.3+) The creator of the encryption key.
        """
        return pulumi.get(self, "creator")

    @property
    @pulumi.getter(name="dbInstanceStorageType")
    def db_instance_storage_type(self) -> str:
        """
        (Available in 1.70.3+) The storage type of the instance.
        """
        return pulumi.get(self, "db_instance_storage_type")

    @property
    @pulumi.getter(name="dbInstanceType")
    def db_instance_type(self) -> str:
        """
        (Available in 1.197.0+) The type of instance.
        """
        return pulumi.get(self, "db_instance_type")

    @property
    @pulumi.getter(name="dbType")
    def db_type(self) -> str:
        """
        `Primary` for primary instance, `Readonly` for read-only instance, `Guard` for disaster recovery instance, and `Temp` for temporary instance.
        """
        return pulumi.get(self, "db_type")

    @property
    @pulumi.getter(name="deleteDate")
    def delete_date(self) -> str:
        """
        (Available in 1.124.3+) The estimated time when the encryption key will be deleted. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "delete_date")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> bool:
        """
        (Available in 1.167.0+) Indicates whether the release protection feature is enabled for the instance. Valid values:
        * **true**: The release protection feature is enabled.
        * **false**: The release protection feature is disabled.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        (Available in 1.124.3+) The description of the encryption key.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> str:
        """
        (Available in 1.124.3+) The ID of the encryption key.
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter(name="encryptionKeyStatus")
    def encryption_key_status(self) -> str:
        """
        (Available in 1.124.3+) The status of the encryption key. Valid values:
        - Enabled
        - Disabled
        """
        return pulumi.get(self, "encryption_key_status")

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        Database type. Options are `MySQL`, `SQLServer`, `PostgreSQL`, `MariaDB`. If no value is specified, all types are returned.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> str:
        """
        Database version.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        Expiration time. Pay-As-You-Go instances never expire.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter(name="guardInstanceId")
    def guard_instance_id(self) -> str:
        """
        If a disaster recovery instance is attached to the current instance, the ID of the disaster recovery instance applies.
        """
        return pulumi.get(self, "guard_instance_id")

    @property
    @pulumi.getter(name="haMode")
    def ha_mode(self) -> str:
        """
        (Available since v1.209.1) The high availability mode of the instance.
        """
        return pulumi.get(self, "ha_mode")

    @property
    @pulumi.getter(name="hostInstanceInfos")
    def host_instance_infos(self) -> Sequence['outputs.GetInstancesInstanceHostInstanceInfoResult']:
        """
        (Available since v1.209.1) An array that consists of the information of the primary and secondary instances.
        """
        return pulumi.get(self, "host_instance_infos")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the RDS instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceStorage")
    def instance_storage(self) -> int:
        """
        (Available in 1.70.3+) User-defined DB instance storage space.
        """
        return pulumi.get(self, "instance_storage")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Sizing of the RDS instance.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> str:
        """
        (Available in 1.124.3+) The purpose of the encryption key.
        """
        return pulumi.get(self, "key_usage")

    @property
    @pulumi.getter(name="lastModifyStatus")
    def last_modify_status(self) -> str:
        """
        (Available in 1.124.1+) The status of the SSL link. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
        - success
        - setting
        - failed
        """
        return pulumi.get(self, "last_modify_status")

    @property
    @pulumi.getter(name="masterInstanceId")
    def master_instance_id(self) -> str:
        """
        ID of the primary instance. If this parameter is not returned, the current instance is a primary instance.
        """
        return pulumi.get(self, "master_instance_id")

    @property
    @pulumi.getter(name="masterZone")
    def master_zone(self) -> str:
        """
        (Available in 1.101.0+) The master zone of the instance.
        """
        return pulumi.get(self, "master_zone")

    @property
    @pulumi.getter(name="materialExpireTime")
    def material_expire_time(self) -> str:
        """
        (Available in 1.124.3+) The time when the encryption key expires. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "material_expire_time")

    @property
    @pulumi.getter(name="modifyStatusReason")
    def modify_status_reason(self) -> str:
        """
        (Available in 1.124.1+) The reason why the SSL link stays in the current state. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        """
        return pulumi.get(self, "modify_status_reason")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the RDS instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="netType")
    def net_type(self) -> str:
        """
        `Internet` for public network or `Intranet` for private network.
        """
        return pulumi.get(self, "net_type")

    @property
    @pulumi.getter
    def origin(self) -> str:
        """
        (Available in 1.124.3+) The source of the encryption key.
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GetInstancesInstanceParameterResult']:
        """
        (Available in 1.135.0+) Parameter list.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def port(self) -> str:
        """
        (Available in 1.70.3+) RDS database connection port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="readonlyInstanceIds")
    def readonly_instance_ids(self) -> Sequence[str]:
        """
        A list of IDs of read-only instances attached to the primary instance.
        """
        return pulumi.get(self, "readonly_instance_ids")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        The region ID of the instance.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="replicationAcl")
    def replication_acl(self) -> str:
        """
        (Available in 1.124.1+) The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        """
        return pulumi.get(self, "replication_acl")

    @property
    @pulumi.getter(name="requireUpdate")
    def require_update(self) -> str:
        """
        (Available in 1.124.1+) Indicates whether the server certificate needs to be updated.
        - Valid values for ApsaraDB RDS for MySQL and ApsaraDB RDS for SQL Server:
        - No
        - Yes
        - Valid values for ApsaraDB RDS for PostgreSQL:
        - 0: no
        - 1: yes
        """
        return pulumi.get(self, "require_update")

    @property
    @pulumi.getter(name="requireUpdateItem")
    def require_update_item(self) -> str:
        """
        (Available in 1.124.1+) The server certificate that needs to be updated. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        """
        return pulumi.get(self, "require_update_item")

    @property
    @pulumi.getter(name="requireUpdateReason")
    def require_update_reason(self) -> str:
        """
        (Available in 1.124.1+) The reason why the server certificate needs to be updated. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        """
        return pulumi.get(self, "require_update_reason")

    @property
    @pulumi.getter(name="serverCaUrl")
    def server_ca_url(self) -> str:
        """
        (Available in 1.124.1+) The URL of the CA that issues the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        """
        return pulumi.get(self, "server_ca_url")

    @property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> str:
        """
        (Available in 1.124.1+) The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        """
        return pulumi.get(self, "server_cert")

    @property
    @pulumi.getter(name="serverKey")
    def server_key(self) -> str:
        """
        (Available in 1.124.1+) The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
        """
        return pulumi.get(self, "server_key")

    @property
    @pulumi.getter(name="sslCreateTime")
    def ssl_create_time(self) -> str:
        """
        (Available in 1.124.1+) The time when the server certificate was created. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is valid only when the CAType parameter is set to aliyun.
        """
        return pulumi.get(self, "ssl_create_time")

    @property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> str:
        """
        (Available in 1.124.1+) Indicates whether SSL encryption is enabled. Valid values:
        - on: enabled
        - off: disabled
        """
        return pulumi.get(self, "ssl_enabled")

    @property
    @pulumi.getter(name="sslExpireTime")
    def ssl_expire_time(self) -> str:
        """
        (Available in 1.124.1+) The time when the server certificate expires. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "ssl_expire_time")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> str:
        """
        (Available since v1.209.1) The data replication mode of the instance.
        """
        return pulumi.get(self, "sync_mode")

    @property
    @pulumi.getter(name="tempInstanceId")
    def temp_instance_id(self) -> str:
        """
        If a temporary instance is attached to the current instance, the ID of the temporary instance applies.
        """
        return pulumi.get(self, "temp_instance_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        Used to retrieve instances belong to specified VPC.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        Used to retrieve instances belong to specified `vswitch` resources.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneIdSlaveA")
    def zone_id_slave_a(self) -> str:
        """
        (Available in 1.101.0+) The region ID of the secondary instance if you create a secondary instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
        """
        return pulumi.get(self, "zone_id_slave_a")

    @property
    @pulumi.getter(name="zoneIdSlaveB")
    def zone_id_slave_b(self) -> str:
        """
        (Available in 1.101.0+) The region ID of the log instance if you create a log instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
        """
        return pulumi.get(self, "zone_id_slave_b")


@pulumi.output_type
class GetInstancesInstanceHostInstanceInfoResult(dict):
    def __init__(__self__, *,
                 data_sync_time: str,
                 log_sync_time: str,
                 node_id: str,
                 node_type: str,
                 region_id: str,
                 sync_status: str,
                 zone_id: str):
        """
        :param str data_sync_time: The time when the secondary instance completed the synchronization of data from the primary instance. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param str log_sync_time: The time when the secondary instance received logs from the primary instance. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param str node_id: The ID of the instance.
        :param str node_type: The type of the node.
        :param str region_id: The region ID of the instance.
        :param str sync_status: The synchronization status.
        :param str zone_id: The ID of the zone.
        """
        pulumi.set(__self__, "data_sync_time", data_sync_time)
        pulumi.set(__self__, "log_sync_time", log_sync_time)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "node_type", node_type)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "sync_status", sync_status)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="dataSyncTime")
    def data_sync_time(self) -> str:
        """
        The time when the secondary instance completed the synchronization of data from the primary instance. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "data_sync_time")

    @property
    @pulumi.getter(name="logSyncTime")
    def log_sync_time(self) -> str:
        """
        The time when the secondary instance received logs from the primary instance. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "log_sync_time")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> str:
        """
        The type of the node.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        The region ID of the instance.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="syncStatus")
    def sync_status(self) -> str:
        """
        The synchronization status.
        """
        return pulumi.get(self, "sync_status")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The ID of the zone.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetInstancesInstanceParameterResult(dict):
    def __init__(__self__, *,
                 checking_code: str,
                 force_modify: str,
                 force_restart: str,
                 parameter_description: str,
                 parameter_name: str,
                 parameter_value: str):
        """
        :param str checking_code: The value range of the parameter.
        :param str force_modify: Indicates whether the parameter can be modified. Valid values: true | false
        :param str force_restart: Indicates whether the modified parameter takes effect only after a database restart. Valid values: true | false
        :param str parameter_description: The description of the parameter.
        :param str parameter_name: The name of the parameter.
        :param str parameter_value: The default value of the parameter.
        """
        pulumi.set(__self__, "checking_code", checking_code)
        pulumi.set(__self__, "force_modify", force_modify)
        pulumi.set(__self__, "force_restart", force_restart)
        pulumi.set(__self__, "parameter_description", parameter_description)
        pulumi.set(__self__, "parameter_name", parameter_name)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="checkingCode")
    def checking_code(self) -> str:
        """
        The value range of the parameter.
        """
        return pulumi.get(self, "checking_code")

    @property
    @pulumi.getter(name="forceModify")
    def force_modify(self) -> str:
        """
        Indicates whether the parameter can be modified. Valid values: true | false
        """
        return pulumi.get(self, "force_modify")

    @property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> str:
        """
        Indicates whether the modified parameter takes effect only after a database restart. Valid values: true | false
        """
        return pulumi.get(self, "force_restart")

    @property
    @pulumi.getter(name="parameterDescription")
    def parameter_description(self) -> str:
        """
        The description of the parameter.
        """
        return pulumi.get(self, "parameter_description")

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> str:
        """
        The name of the parameter.
        """
        return pulumi.get(self, "parameter_name")

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> str:
        """
        The default value of the parameter.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class GetModifyParameterLogsLogResult(dict):
    def __init__(__self__, *,
                 modify_time: str,
                 new_parameter_value: str,
                 old_parameter_value: str,
                 parameter_name: str,
                 status: str):
        """
        :param str modify_time: The time when the parameter was reconfigured. This value is a UNIX timestamp. Unit: milliseconds.
        :param str new_parameter_value: The new value of the parameter.
        :param str old_parameter_value: The original value of the parameter.
        :param str parameter_name: The name of the parameter.
        :param str status: The status of the new value specified for the parameter. Valid values:
               * **Applied**: The new value has taken effect.
               * **Syncing**: The new value is being applied and has not taken effect.
        """
        pulumi.set(__self__, "modify_time", modify_time)
        pulumi.set(__self__, "new_parameter_value", new_parameter_value)
        pulumi.set(__self__, "old_parameter_value", old_parameter_value)
        pulumi.set(__self__, "parameter_name", parameter_name)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> str:
        """
        The time when the parameter was reconfigured. This value is a UNIX timestamp. Unit: milliseconds.
        """
        return pulumi.get(self, "modify_time")

    @property
    @pulumi.getter(name="newParameterValue")
    def new_parameter_value(self) -> str:
        """
        The new value of the parameter.
        """
        return pulumi.get(self, "new_parameter_value")

    @property
    @pulumi.getter(name="oldParameterValue")
    def old_parameter_value(self) -> str:
        """
        The original value of the parameter.
        """
        return pulumi.get(self, "old_parameter_value")

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> str:
        """
        The name of the parameter.
        """
        return pulumi.get(self, "parameter_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the new value specified for the parameter. Valid values:
        * **Applied**: The new value has taken effect.
        * **Syncing**: The new value is being applied and has not taken effect.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetRdsBackupsBackupResult(dict):
    def __init__(__self__, *,
                 backup_download_url: str,
                 backup_end_time: str,
                 backup_id: str,
                 backup_initiator: str,
                 backup_intranet_download_url: str,
                 backup_method: str,
                 backup_mode: str,
                 backup_size: str,
                 backup_start_time: str,
                 backup_status: str,
                 backup_type: str,
                 consistent_time: str,
                 copy_only_backup: str,
                 db_instance_id: str,
                 encryption: str,
                 host_instance_id: str,
                 id: str,
                 is_avail: int,
                 meta_status: str,
                 storage_class: str,
                 store_status: str):
        """
        :param str backup_download_url: The backup download url.
        :param str backup_end_time: BackupEndTime.
        :param str backup_id: BackupId.
        :param str backup_initiator: The initiator of the backup task. Value:
               * **System**: automatically initiated by the System
               * **User**: manually initiated by the User.
        :param str backup_intranet_download_url: The backup intranet download url.
        :param str backup_method: BackupMethod.
        :param str backup_mode: BackupMode.
        :param str backup_size: BackupSize.
        :param str backup_start_time: BackupStartTime.
        :param str backup_status: Backup task status. **NOTE:** This parameter will only be returned when a task is executed. Value:
               * **NoStart**: Not started
               * **Checking**: check the backup
               * **Preparing**: Prepare a backup
               * **Waiting**: Waiting for backup
               * **Uploading**: Upload backup
               * **Finished**: Complete backup
               * **Failed**: backup Failed
        :param str backup_type: BackupType.
        :param str consistent_time: The consistency point of the backup set. The return value is a timestamp. **NOTE:** only MySQL 5.6 returns this parameter, and other versions return 0.
        :param str copy_only_backup: The backup mode is divided into the normal backup mode (full and incremental recovery is supported) and the replication-only mode (full recovery is supported only). **NOTE:** Only SQL Server returns this parameter. Valid values:
               * **0**: General Backup Mode
               * **1**: Copy only mode
        :param str db_instance_id: The db instance id.
        :param str encryption: The encrypted information of the backup set.
        :param str host_instance_id: HostInstanceID.
        :param str id: The ID of the Backup.
        :param int is_avail: Whether the backup set is available, the value is:
               * **0**: Not available
               * **1**: Available.
        :param str meta_status: The backup set status of the database table. **NOTE:** an empty string indicates that the backup set for database table recovery is not enabled. Valid values:
               * **OK**: normal.
               * **LARGE**: There are too many tables that cannot be used for database and table recovery.
               * **EMPTY**: The backup set that failed to be backed up.
        :param str storage_class: The storage medium for the backup set. Valid values:
               * **0**: Regular storage
               * **1**: Archive storage.
        :param str store_status: StoreStatus.
        """
        pulumi.set(__self__, "backup_download_url", backup_download_url)
        pulumi.set(__self__, "backup_end_time", backup_end_time)
        pulumi.set(__self__, "backup_id", backup_id)
        pulumi.set(__self__, "backup_initiator", backup_initiator)
        pulumi.set(__self__, "backup_intranet_download_url", backup_intranet_download_url)
        pulumi.set(__self__, "backup_method", backup_method)
        pulumi.set(__self__, "backup_mode", backup_mode)
        pulumi.set(__self__, "backup_size", backup_size)
        pulumi.set(__self__, "backup_start_time", backup_start_time)
        pulumi.set(__self__, "backup_status", backup_status)
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "consistent_time", consistent_time)
        pulumi.set(__self__, "copy_only_backup", copy_only_backup)
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "encryption", encryption)
        pulumi.set(__self__, "host_instance_id", host_instance_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_avail", is_avail)
        pulumi.set(__self__, "meta_status", meta_status)
        pulumi.set(__self__, "storage_class", storage_class)
        pulumi.set(__self__, "store_status", store_status)

    @property
    @pulumi.getter(name="backupDownloadUrl")
    def backup_download_url(self) -> str:
        """
        The backup download url.
        """
        return pulumi.get(self, "backup_download_url")

    @property
    @pulumi.getter(name="backupEndTime")
    def backup_end_time(self) -> str:
        """
        BackupEndTime.
        """
        return pulumi.get(self, "backup_end_time")

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> str:
        """
        BackupId.
        """
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter(name="backupInitiator")
    def backup_initiator(self) -> str:
        """
        The initiator of the backup task. Value:
        * **System**: automatically initiated by the System
        * **User**: manually initiated by the User.
        """
        return pulumi.get(self, "backup_initiator")

    @property
    @pulumi.getter(name="backupIntranetDownloadUrl")
    def backup_intranet_download_url(self) -> str:
        """
        The backup intranet download url.
        """
        return pulumi.get(self, "backup_intranet_download_url")

    @property
    @pulumi.getter(name="backupMethod")
    def backup_method(self) -> str:
        """
        BackupMethod.
        """
        return pulumi.get(self, "backup_method")

    @property
    @pulumi.getter(name="backupMode")
    def backup_mode(self) -> str:
        """
        BackupMode.
        """
        return pulumi.get(self, "backup_mode")

    @property
    @pulumi.getter(name="backupSize")
    def backup_size(self) -> str:
        """
        BackupSize.
        """
        return pulumi.get(self, "backup_size")

    @property
    @pulumi.getter(name="backupStartTime")
    def backup_start_time(self) -> str:
        """
        BackupStartTime.
        """
        return pulumi.get(self, "backup_start_time")

    @property
    @pulumi.getter(name="backupStatus")
    def backup_status(self) -> str:
        """
        Backup task status. **NOTE:** This parameter will only be returned when a task is executed. Value:
        * **NoStart**: Not started
        * **Checking**: check the backup
        * **Preparing**: Prepare a backup
        * **Waiting**: Waiting for backup
        * **Uploading**: Upload backup
        * **Finished**: Complete backup
        * **Failed**: backup Failed
        """
        return pulumi.get(self, "backup_status")

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> str:
        """
        BackupType.
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter(name="consistentTime")
    def consistent_time(self) -> str:
        """
        The consistency point of the backup set. The return value is a timestamp. **NOTE:** only MySQL 5.6 returns this parameter, and other versions return 0.
        """
        return pulumi.get(self, "consistent_time")

    @property
    @pulumi.getter(name="copyOnlyBackup")
    def copy_only_backup(self) -> str:
        """
        The backup mode is divided into the normal backup mode (full and incremental recovery is supported) and the replication-only mode (full recovery is supported only). **NOTE:** Only SQL Server returns this parameter. Valid values:
        * **0**: General Backup Mode
        * **1**: Copy only mode
        """
        return pulumi.get(self, "copy_only_backup")

    @property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> str:
        """
        The db instance id.
        """
        return pulumi.get(self, "db_instance_id")

    @property
    @pulumi.getter
    def encryption(self) -> str:
        """
        The encrypted information of the backup set.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="hostInstanceId")
    def host_instance_id(self) -> str:
        """
        HostInstanceID.
        """
        return pulumi.get(self, "host_instance_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Backup.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAvail")
    def is_avail(self) -> int:
        """
        Whether the backup set is available, the value is:
        * **0**: Not available
        * **1**: Available.
        """
        return pulumi.get(self, "is_avail")

    @property
    @pulumi.getter(name="metaStatus")
    def meta_status(self) -> str:
        """
        The backup set status of the database table. **NOTE:** an empty string indicates that the backup set for database table recovery is not enabled. Valid values:
        * **OK**: normal.
        * **LARGE**: There are too many tables that cannot be used for database and table recovery.
        * **EMPTY**: The backup set that failed to be backed up.
        """
        return pulumi.get(self, "meta_status")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        """
        The storage medium for the backup set. Valid values:
        * **0**: Regular storage
        * **1**: Archive storage.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter(name="storeStatus")
    def store_status(self) -> str:
        """
        StoreStatus.
        """
        return pulumi.get(self, "store_status")


@pulumi.output_type
class GetRdsParameterGroupsGroupResult(dict):
    def __init__(__self__, *,
                 engine: str,
                 engine_version: str,
                 force_restart: int,
                 id: str,
                 param_counts: int,
                 param_details: Sequence['outputs.GetRdsParameterGroupsGroupParamDetailResult'],
                 parameter_group_desc: str,
                 parameter_group_id: str,
                 parameter_group_name: str,
                 parameter_group_type: int):
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "force_restart", force_restart)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "param_counts", param_counts)
        pulumi.set(__self__, "param_details", param_details)
        pulumi.set(__self__, "parameter_group_desc", parameter_group_desc)
        pulumi.set(__self__, "parameter_group_id", parameter_group_id)
        pulumi.set(__self__, "parameter_group_name", parameter_group_name)
        pulumi.set(__self__, "parameter_group_type", parameter_group_type)

    @property
    @pulumi.getter
    def engine(self) -> str:
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> str:
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> int:
        return pulumi.get(self, "force_restart")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="paramCounts")
    def param_counts(self) -> int:
        return pulumi.get(self, "param_counts")

    @property
    @pulumi.getter(name="paramDetails")
    def param_details(self) -> Sequence['outputs.GetRdsParameterGroupsGroupParamDetailResult']:
        return pulumi.get(self, "param_details")

    @property
    @pulumi.getter(name="parameterGroupDesc")
    def parameter_group_desc(self) -> str:
        return pulumi.get(self, "parameter_group_desc")

    @property
    @pulumi.getter(name="parameterGroupId")
    def parameter_group_id(self) -> str:
        return pulumi.get(self, "parameter_group_id")

    @property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> str:
        return pulumi.get(self, "parameter_group_name")

    @property
    @pulumi.getter(name="parameterGroupType")
    def parameter_group_type(self) -> int:
        return pulumi.get(self, "parameter_group_type")


@pulumi.output_type
class GetRdsParameterGroupsGroupParamDetailResult(dict):
    def __init__(__self__, *,
                 param_name: str,
                 param_value: str):
        pulumi.set(__self__, "param_name", param_name)
        pulumi.set(__self__, "param_value", param_value)

    @property
    @pulumi.getter(name="paramName")
    def param_name(self) -> str:
        return pulumi.get(self, "param_name")

    @property
    @pulumi.getter(name="paramValue")
    def param_value(self) -> str:
        return pulumi.get(self, "param_value")


@pulumi.output_type
class GetSlotsSlotResult(dict):
    def __init__(__self__, *,
                 database: str,
                 plugin: str,
                 slot_name: str,
                 slot_status: str,
                 slot_type: str,
                 temporary: str,
                 wal_delay: str):
        """
        :param str database: The name of the database where Replication Slot is located.
        :param str plugin: The plugin used by Replication Slot.
        :param str slot_name: The Replication Slot name.
        :param str slot_status: The Replication Slot status.
        :param str slot_type: The Replication Slot type.
        :param str temporary: Is the Replication Slot temporary.
        :param str wal_delay: The amount of logs accumulated by Replication Slot.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "plugin", plugin)
        pulumi.set(__self__, "slot_name", slot_name)
        pulumi.set(__self__, "slot_status", slot_status)
        pulumi.set(__self__, "slot_type", slot_type)
        pulumi.set(__self__, "temporary", temporary)
        pulumi.set(__self__, "wal_delay", wal_delay)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The name of the database where Replication Slot is located.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def plugin(self) -> str:
        """
        The plugin used by Replication Slot.
        """
        return pulumi.get(self, "plugin")

    @property
    @pulumi.getter(name="slotName")
    def slot_name(self) -> str:
        """
        The Replication Slot name.
        """
        return pulumi.get(self, "slot_name")

    @property
    @pulumi.getter(name="slotStatus")
    def slot_status(self) -> str:
        """
        The Replication Slot status.
        """
        return pulumi.get(self, "slot_status")

    @property
    @pulumi.getter(name="slotType")
    def slot_type(self) -> str:
        """
        The Replication Slot type.
        """
        return pulumi.get(self, "slot_type")

    @property
    @pulumi.getter
    def temporary(self) -> str:
        """
        Is the Replication Slot temporary.
        """
        return pulumi.get(self, "temporary")

    @property
    @pulumi.getter(name="walDelay")
    def wal_delay(self) -> str:
        """
        The amount of logs accumulated by Replication Slot.
        """
        return pulumi.get(self, "wal_delay")


@pulumi.output_type
class GetZonesZoneResult(dict):
    def __init__(__self__, *,
                 id: str,
                 multi_zone_ids: Sequence[str]):
        """
        :param str id: ID of the zone.
        :param Sequence[str] multi_zone_ids: A list of zone ids in which the multi zone.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "multi_zone_ids", multi_zone_ids)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the zone.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="multiZoneIds")
    def multi_zone_ids(self) -> Sequence[str]:
        """
        A list of zone ids in which the multi zone.
        """
        return pulumi.get(self, "multi_zone_ids")


