# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReadOnlyInstanceArgs', 'ReadOnlyInstance']

@pulumi.input_type
class ReadOnlyInstanceArgs:
    def __init__(__self__, *,
                 engine_version: pulumi.Input[str],
                 instance_storage: pulumi.Input[int],
                 instance_type: pulumi.Input[str],
                 master_db_instance_id: pulumi.Input[str],
                 acl: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 ca_type: Optional[pulumi.Input[str]] = None,
                 client_ca_cert: Optional[pulumi.Input[str]] = None,
                 client_ca_enabled: Optional[pulumi.Input[int]] = None,
                 client_cert_revocation_list: Optional[pulumi.Input[str]] = None,
                 client_crl_enabled: Optional[pulumi.Input[int]] = None,
                 db_instance_ip_array_attribute: Optional[pulumi.Input[str]] = None,
                 db_instance_ip_array_name: Optional[pulumi.Input[str]] = None,
                 db_instance_storage_type: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 effective_time: Optional[pulumi.Input[str]] = None,
                 force_restart: Optional[pulumi.Input[bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 modify_mode: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ReadOnlyInstanceParameterArgs']]]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 replication_acl: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_ip_type: Optional[pulumi.Input[str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 server_cert: Optional[pulumi.Input[str]] = None,
                 server_key: Optional[pulumi.Input[str]] = None,
                 ssl_enabled: Optional[pulumi.Input[int]] = None,
                 switch_time: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_minor_version: Optional[pulumi.Input[str]] = None,
                 upgrade_db_instance_kernel_version: Optional[pulumi.Input[bool]] = None,
                 upgrade_time: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 whitelist_network_type: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ReadOnlyInstance resource.
        :param pulumi.Input[str] engine_version: Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
        :param pulumi.Input[int] instance_storage: User-defined DB instance storage space. Value range: [5, 2000] for MySQL/SQL Server HA dual node edition. Increase progressively at a rate of 5 GB. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
        :param pulumi.Input[str] instance_type: DB Instance type. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
        :param pulumi.Input[str] master_db_instance_id: ID of the master instance.
        :param pulumi.Input[str] acl: The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. It is valid only when `ssl_enabled  = 1`. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param pulumi.Input[bool] auto_renew: Whether to renewal a DB instance automatically or not. It is valid when instance_charge_type is `PrePaid`. Default to `false`.
        :param pulumi.Input[int] auto_renew_period: Auto-renewal period of an instance, in the unit of the month. It is valid when instance_charge_type is `PrePaid`. Valid value:[1~12], Default to 1.
        :param pulumi.Input[str] ca_type: The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. It is valid only when `ssl_enabled  = 1`. Value range:
               - aliyun: a cloud certificate
               - custom: a custom certificate
        :param pulumi.Input[str] client_ca_cert: The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        :param pulumi.Input[int] client_ca_enabled: Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. It is valid only when `ssl_enabled  = 1`. Valid values:
               - 1: enables the public key
               - 0: disables the public key
        :param pulumi.Input[str] client_cert_revocation_list: The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        :param pulumi.Input[int] client_crl_enabled: Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. It is valid only when `ssl_enabled  = 1`. Valid values:
               - 1: enables the CRL
               - 0: disables the CRL
        :param pulumi.Input[str] db_instance_ip_array_attribute: The attribute of the IP address whitelist. By default, this parameter is empty.
               
               > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
        :param pulumi.Input[str] db_instance_ip_array_name: The name of the IP address whitelist. Default value: Default.
               
               > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
        :param pulumi.Input[str] db_instance_storage_type: The storage type of the instance. Valid values:
               - local_ssd: specifies to use local SSDs. This value is recommended.
               - cloud_ssd: specifies to use standard SSDs.
               - cloud_essd: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
        :param pulumi.Input[bool] deletion_protection: The switch of delete protection. Valid values:
               - true: delete protect.
               - false: no delete protect.
        :param pulumi.Input[str] direction: The instance configuration type. Valid values:
               - Up
               - Down
               - TempUpgrade
               - Serverless
        :param pulumi.Input[str] effective_time: The method to change.  Default value: Immediate. Valid values:
               - Immediate: The change immediately takes effect.
               - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
        :param pulumi.Input[bool] force_restart: Set it to true to make some parameter efficient when modifying them. Default to false.
        :param pulumi.Input[str] instance_charge_type: Valid values are `Prepaid`, `Postpaid`, Default to `Postpaid`. The interval between the two conversion operations must be greater than 15 minutes. Only when this parameter is `Postpaid`, the instance can be released.
        :param pulumi.Input[str] instance_name: The name of DB instance. It a string of 2 to 256 characters.
        :param pulumi.Input[str] modify_mode: The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
               - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
               - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
               - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
        :param pulumi.Input[Sequence[pulumi.Input['ReadOnlyInstanceParameterArgs']]] parameters: Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm). See `parameters` below.
        :param pulumi.Input[int] period: The duration that you will buy DB instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
        :param pulumi.Input[str] replication_acl: The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. It is valid only when `ssl_enabled  = 1`. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
               > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
        :param pulumi.Input[str] resource_group_id: The ID of resource group which the DB read-only instance belongs.
        :param pulumi.Input[str] security_ip_type: The type of IP address in the IP address whitelist.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_ips: List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        :param pulumi.Input[str] server_cert: The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        :param pulumi.Input[str] server_key: The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        :param pulumi.Input[int] ssl_enabled: Specifies whether to enable or disable SSL encryption. Valid values:
               - 1: enables SSL encryption
               - 0: disables SSL encryption
        :param pulumi.Input[str] switch_time: The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `upgrade_db_instance_kernel_version = true`. The time must be in UTC.
               
               > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[str] target_minor_version: The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. It is valid only when `upgrade_db_instance_kernel_version = true`. You must specify the minor engine version in one of the following formats:
               - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
               - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
               - rds: The instance runs RDS Basic or High-availability Edition.
               - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
               - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
               - SQLServer: <Minor engine version>. Example: 15.0.4073.23.
               
               > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
        :param pulumi.Input[bool] upgrade_db_instance_kernel_version: Whether to upgrade a minor version of the kernel. Valid values:
               - true: upgrade
               - false: not to upgrade
        :param pulumi.Input[str] upgrade_time: The method to update the minor engine version. Default value: Immediate. It is valid only when `upgrade_db_instance_kernel_version = true`. Valid values:
               - Immediate: The minor engine version is immediately updated.
               - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
               - SpecifyTime: The minor engine version is updated at the point in time you specify.
        :param pulumi.Input[str] vswitch_id: The virtual switch ID to launch DB instances in one VPC.
        :param pulumi.Input[str] whitelist_network_type: The network type of the IP address whitelist. Default value: MIX. Valid values:
               - Classic: classic network in enhanced whitelist mode
               - VPC: virtual private cloud (VPC) in enhanced whitelist mode
               - MIX: standard whitelist mode
               > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
        :param pulumi.Input[str] zone_id: The Zone to launch the DB instance.
        """
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "instance_storage", instance_storage)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "master_db_instance_id", master_db_instance_id)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if ca_type is not None:
            pulumi.set(__self__, "ca_type", ca_type)
        if client_ca_cert is not None:
            pulumi.set(__self__, "client_ca_cert", client_ca_cert)
        if client_ca_enabled is not None:
            pulumi.set(__self__, "client_ca_enabled", client_ca_enabled)
        if client_cert_revocation_list is not None:
            pulumi.set(__self__, "client_cert_revocation_list", client_cert_revocation_list)
        if client_crl_enabled is not None:
            pulumi.set(__self__, "client_crl_enabled", client_crl_enabled)
        if db_instance_ip_array_attribute is not None:
            pulumi.set(__self__, "db_instance_ip_array_attribute", db_instance_ip_array_attribute)
        if db_instance_ip_array_name is not None:
            pulumi.set(__self__, "db_instance_ip_array_name", db_instance_ip_array_name)
        if db_instance_storage_type is not None:
            pulumi.set(__self__, "db_instance_storage_type", db_instance_storage_type)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if force_restart is not None:
            pulumi.set(__self__, "force_restart", force_restart)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if modify_mode is not None:
            pulumi.set(__self__, "modify_mode", modify_mode)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if replication_acl is not None:
            pulumi.set(__self__, "replication_acl", replication_acl)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_ip_type is not None:
            pulumi.set(__self__, "security_ip_type", security_ip_type)
        if security_ips is not None:
            pulumi.set(__self__, "security_ips", security_ips)
        if server_cert is not None:
            pulumi.set(__self__, "server_cert", server_cert)
        if server_key is not None:
            pulumi.set(__self__, "server_key", server_key)
        if ssl_enabled is not None:
            pulumi.set(__self__, "ssl_enabled", ssl_enabled)
        if switch_time is not None:
            pulumi.set(__self__, "switch_time", switch_time)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_minor_version is not None:
            pulumi.set(__self__, "target_minor_version", target_minor_version)
        if upgrade_db_instance_kernel_version is not None:
            pulumi.set(__self__, "upgrade_db_instance_kernel_version", upgrade_db_instance_kernel_version)
        if upgrade_time is not None:
            pulumi.set(__self__, "upgrade_time", upgrade_time)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if whitelist_network_type is not None:
            pulumi.set(__self__, "whitelist_network_type", whitelist_network_type)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Input[str]:
        """
        Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="instanceStorage")
    def instance_storage(self) -> pulumi.Input[int]:
        """
        User-defined DB instance storage space. Value range: [5, 2000] for MySQL/SQL Server HA dual node edition. Increase progressively at a rate of 5 GB. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
        """
        return pulumi.get(self, "instance_storage")

    @instance_storage.setter
    def instance_storage(self, value: pulumi.Input[int]):
        pulumi.set(self, "instance_storage", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        DB Instance type. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="masterDbInstanceId")
    def master_db_instance_id(self) -> pulumi.Input[str]:
        """
        ID of the master instance.
        """
        return pulumi.get(self, "master_db_instance_id")

    @master_db_instance_id.setter
    def master_db_instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "master_db_instance_id", value)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[str]]:
        """
        The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. It is valid only when `ssl_enabled  = 1`. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to renewal a DB instance automatically or not. It is valid when instance_charge_type is `PrePaid`. Default to `false`.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        Auto-renewal period of an instance, in the unit of the month. It is valid when instance_charge_type is `PrePaid`. Valid value:[1~12], Default to 1.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_period", value)

    @property
    @pulumi.getter(name="caType")
    def ca_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. It is valid only when `ssl_enabled  = 1`. Value range:
        - aliyun: a cloud certificate
        - custom: a custom certificate
        """
        return pulumi.get(self, "ca_type")

    @ca_type.setter
    def ca_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_type", value)

    @property
    @pulumi.getter(name="clientCaCert")
    def client_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        """
        return pulumi.get(self, "client_ca_cert")

    @client_ca_cert.setter
    def client_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_ca_cert", value)

    @property
    @pulumi.getter(name="clientCaEnabled")
    def client_ca_enabled(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. It is valid only when `ssl_enabled  = 1`. Valid values:
        - 1: enables the public key
        - 0: disables the public key
        """
        return pulumi.get(self, "client_ca_enabled")

    @client_ca_enabled.setter
    def client_ca_enabled(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "client_ca_enabled", value)

    @property
    @pulumi.getter(name="clientCertRevocationList")
    def client_cert_revocation_list(self) -> Optional[pulumi.Input[str]]:
        """
        The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        """
        return pulumi.get(self, "client_cert_revocation_list")

    @client_cert_revocation_list.setter
    def client_cert_revocation_list(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_cert_revocation_list", value)

    @property
    @pulumi.getter(name="clientCrlEnabled")
    def client_crl_enabled(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. It is valid only when `ssl_enabled  = 1`. Valid values:
        - 1: enables the CRL
        - 0: disables the CRL
        """
        return pulumi.get(self, "client_crl_enabled")

    @client_crl_enabled.setter
    def client_crl_enabled(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "client_crl_enabled", value)

    @property
    @pulumi.getter(name="dbInstanceIpArrayAttribute")
    def db_instance_ip_array_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        The attribute of the IP address whitelist. By default, this parameter is empty.

        > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
        """
        return pulumi.get(self, "db_instance_ip_array_attribute")

    @db_instance_ip_array_attribute.setter
    def db_instance_ip_array_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_instance_ip_array_attribute", value)

    @property
    @pulumi.getter(name="dbInstanceIpArrayName")
    def db_instance_ip_array_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the IP address whitelist. Default value: Default.

        > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
        """
        return pulumi.get(self, "db_instance_ip_array_name")

    @db_instance_ip_array_name.setter
    def db_instance_ip_array_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_instance_ip_array_name", value)

    @property
    @pulumi.getter(name="dbInstanceStorageType")
    def db_instance_storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        The storage type of the instance. Valid values:
        - local_ssd: specifies to use local SSDs. This value is recommended.
        - cloud_ssd: specifies to use standard SSDs.
        - cloud_essd: specifies to use enhanced SSDs (ESSDs).
        - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
        - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
        """
        return pulumi.get(self, "db_instance_storage_type")

    @db_instance_storage_type.setter
    def db_instance_storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_instance_storage_type", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        The switch of delete protection. Valid values:
        - true: delete protect.
        - false: no delete protect.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[str]]:
        """
        The instance configuration type. Valid values:
        - Up
        - Down
        - TempUpgrade
        - Serverless
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[pulumi.Input[str]]:
        """
        The method to change.  Default value: Immediate. Valid values:
        - Immediate: The change immediately takes effect.
        - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
        """
        return pulumi.get(self, "effective_time")

    @effective_time.setter
    def effective_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effective_time", value)

    @property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> Optional[pulumi.Input[bool]]:
        """
        Set it to true to make some parameter efficient when modifying them. Default to false.
        """
        return pulumi.get(self, "force_restart")

    @force_restart.setter
    def force_restart(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_restart", value)

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Valid values are `Prepaid`, `Postpaid`, Default to `Postpaid`. The interval between the two conversion operations must be greater than 15 minutes. Only when this parameter is `Postpaid`, the instance can be released.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_charge_type", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of DB instance. It a string of 2 to 256 characters.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="modifyMode")
    def modify_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
        - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
        - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
        - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
        """
        return pulumi.get(self, "modify_mode")

    @modify_mode.setter
    def modify_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modify_mode", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReadOnlyInstanceParameterArgs']]]]:
        """
        Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm). See `parameters` below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReadOnlyInstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The duration that you will buy DB instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="replicationAcl")
    def replication_acl(self) -> Optional[pulumi.Input[str]]:
        """
        The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. It is valid only when `ssl_enabled  = 1`. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
        """
        return pulumi.get(self, "replication_acl")

    @replication_acl.setter
    def replication_acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_acl", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of resource group which the DB read-only instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="securityIpType")
    def security_ip_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of IP address in the IP address whitelist.
        """
        return pulumi.get(self, "security_ip_type")

    @security_ip_type.setter
    def security_ip_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_ip_type", value)

    @property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        """
        return pulumi.get(self, "security_ips")

    @security_ips.setter
    def security_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_ips", value)

    @property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        """
        return pulumi.get(self, "server_cert")

    @server_cert.setter
    def server_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_cert", value)

    @property
    @pulumi.getter(name="serverKey")
    def server_key(self) -> Optional[pulumi.Input[str]]:
        """
        The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        """
        return pulumi.get(self, "server_key")

    @server_key.setter
    def server_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_key", value)

    @property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies whether to enable or disable SSL encryption. Valid values:
        - 1: enables SSL encryption
        - 0: disables SSL encryption
        """
        return pulumi.get(self, "ssl_enabled")

    @ssl_enabled.setter
    def ssl_enabled(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ssl_enabled", value)

    @property
    @pulumi.getter(name="switchTime")
    def switch_time(self) -> Optional[pulumi.Input[str]]:
        """
        The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `upgrade_db_instance_kernel_version = true`. The time must be in UTC.

        > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
        """
        return pulumi.get(self, "switch_time")

    @switch_time.setter
    def switch_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "switch_time", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetMinorVersion")
    def target_minor_version(self) -> Optional[pulumi.Input[str]]:
        """
        The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. It is valid only when `upgrade_db_instance_kernel_version = true`. You must specify the minor engine version in one of the following formats:
        - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
        - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
        - rds: The instance runs RDS Basic or High-availability Edition.
        - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
        - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
        - SQLServer: <Minor engine version>. Example: 15.0.4073.23.

        > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
        """
        return pulumi.get(self, "target_minor_version")

    @target_minor_version.setter
    def target_minor_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_minor_version", value)

    @property
    @pulumi.getter(name="upgradeDbInstanceKernelVersion")
    def upgrade_db_instance_kernel_version(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to upgrade a minor version of the kernel. Valid values:
        - true: upgrade
        - false: not to upgrade
        """
        return pulumi.get(self, "upgrade_db_instance_kernel_version")

    @upgrade_db_instance_kernel_version.setter
    def upgrade_db_instance_kernel_version(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "upgrade_db_instance_kernel_version", value)

    @property
    @pulumi.getter(name="upgradeTime")
    def upgrade_time(self) -> Optional[pulumi.Input[str]]:
        """
        The method to update the minor engine version. Default value: Immediate. It is valid only when `upgrade_db_instance_kernel_version = true`. Valid values:
        - Immediate: The minor engine version is immediately updated.
        - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
        - SpecifyTime: The minor engine version is updated at the point in time you specify.
        """
        return pulumi.get(self, "upgrade_time")

    @upgrade_time.setter
    def upgrade_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "upgrade_time", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The virtual switch ID to launch DB instances in one VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="whitelistNetworkType")
    def whitelist_network_type(self) -> Optional[pulumi.Input[str]]:
        """
        The network type of the IP address whitelist. Default value: MIX. Valid values:
        - Classic: classic network in enhanced whitelist mode
        - VPC: virtual private cloud (VPC) in enhanced whitelist mode
        - MIX: standard whitelist mode
        > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
        """
        return pulumi.get(self, "whitelist_network_type")

    @whitelist_network_type.setter
    def whitelist_network_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "whitelist_network_type", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Zone to launch the DB instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _ReadOnlyInstanceState:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 ca_type: Optional[pulumi.Input[str]] = None,
                 client_ca_cert: Optional[pulumi.Input[str]] = None,
                 client_ca_enabled: Optional[pulumi.Input[int]] = None,
                 client_cert_revocation_list: Optional[pulumi.Input[str]] = None,
                 client_crl_enabled: Optional[pulumi.Input[int]] = None,
                 connection_string: Optional[pulumi.Input[str]] = None,
                 db_instance_ip_array_attribute: Optional[pulumi.Input[str]] = None,
                 db_instance_ip_array_name: Optional[pulumi.Input[str]] = None,
                 db_instance_storage_type: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 effective_time: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 force_restart: Optional[pulumi.Input[bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_storage: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 master_db_instance_id: Optional[pulumi.Input[str]] = None,
                 modify_mode: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ReadOnlyInstanceParameterArgs']]]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 replication_acl: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_ip_type: Optional[pulumi.Input[str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 server_cert: Optional[pulumi.Input[str]] = None,
                 server_key: Optional[pulumi.Input[str]] = None,
                 ssl_enabled: Optional[pulumi.Input[int]] = None,
                 switch_time: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_minor_version: Optional[pulumi.Input[str]] = None,
                 upgrade_db_instance_kernel_version: Optional[pulumi.Input[bool]] = None,
                 upgrade_time: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 whitelist_network_type: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ReadOnlyInstance resources.
        :param pulumi.Input[str] acl: The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. It is valid only when `ssl_enabled  = 1`. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param pulumi.Input[bool] auto_renew: Whether to renewal a DB instance automatically or not. It is valid when instance_charge_type is `PrePaid`. Default to `false`.
        :param pulumi.Input[int] auto_renew_period: Auto-renewal period of an instance, in the unit of the month. It is valid when instance_charge_type is `PrePaid`. Valid value:[1~12], Default to 1.
        :param pulumi.Input[str] ca_type: The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. It is valid only when `ssl_enabled  = 1`. Value range:
               - aliyun: a cloud certificate
               - custom: a custom certificate
        :param pulumi.Input[str] client_ca_cert: The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        :param pulumi.Input[int] client_ca_enabled: Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. It is valid only when `ssl_enabled  = 1`. Valid values:
               - 1: enables the public key
               - 0: disables the public key
        :param pulumi.Input[str] client_cert_revocation_list: The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        :param pulumi.Input[int] client_crl_enabled: Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. It is valid only when `ssl_enabled  = 1`. Valid values:
               - 1: enables the CRL
               - 0: disables the CRL
        :param pulumi.Input[str] connection_string: RDS database connection string.
        :param pulumi.Input[str] db_instance_ip_array_attribute: The attribute of the IP address whitelist. By default, this parameter is empty.
               
               > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
        :param pulumi.Input[str] db_instance_ip_array_name: The name of the IP address whitelist. Default value: Default.
               
               > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
        :param pulumi.Input[str] db_instance_storage_type: The storage type of the instance. Valid values:
               - local_ssd: specifies to use local SSDs. This value is recommended.
               - cloud_ssd: specifies to use standard SSDs.
               - cloud_essd: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
        :param pulumi.Input[bool] deletion_protection: The switch of delete protection. Valid values:
               - true: delete protect.
               - false: no delete protect.
        :param pulumi.Input[str] direction: The instance configuration type. Valid values:
               - Up
               - Down
               - TempUpgrade
               - Serverless
        :param pulumi.Input[str] effective_time: The method to change.  Default value: Immediate. Valid values:
               - Immediate: The change immediately takes effect.
               - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
        :param pulumi.Input[str] engine: Database type.
        :param pulumi.Input[str] engine_version: Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
        :param pulumi.Input[bool] force_restart: Set it to true to make some parameter efficient when modifying them. Default to false.
        :param pulumi.Input[str] instance_charge_type: Valid values are `Prepaid`, `Postpaid`, Default to `Postpaid`. The interval between the two conversion operations must be greater than 15 minutes. Only when this parameter is `Postpaid`, the instance can be released.
        :param pulumi.Input[str] instance_name: The name of DB instance. It a string of 2 to 256 characters.
        :param pulumi.Input[int] instance_storage: User-defined DB instance storage space. Value range: [5, 2000] for MySQL/SQL Server HA dual node edition. Increase progressively at a rate of 5 GB. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
        :param pulumi.Input[str] instance_type: DB Instance type. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
        :param pulumi.Input[str] master_db_instance_id: ID of the master instance.
        :param pulumi.Input[str] modify_mode: The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
               - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
               - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
               - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
        :param pulumi.Input[Sequence[pulumi.Input['ReadOnlyInstanceParameterArgs']]] parameters: Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm). See `parameters` below.
        :param pulumi.Input[int] period: The duration that you will buy DB instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
        :param pulumi.Input[str] port: RDS database connection port.
        :param pulumi.Input[str] replication_acl: The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. It is valid only when `ssl_enabled  = 1`. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
               > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
        :param pulumi.Input[str] resource_group_id: The ID of resource group which the DB read-only instance belongs.
        :param pulumi.Input[str] security_ip_type: The type of IP address in the IP address whitelist.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_ips: List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        :param pulumi.Input[str] server_cert: The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        :param pulumi.Input[str] server_key: The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        :param pulumi.Input[int] ssl_enabled: Specifies whether to enable or disable SSL encryption. Valid values:
               - 1: enables SSL encryption
               - 0: disables SSL encryption
        :param pulumi.Input[str] switch_time: The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `upgrade_db_instance_kernel_version = true`. The time must be in UTC.
               
               > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[str] target_minor_version: The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. It is valid only when `upgrade_db_instance_kernel_version = true`. You must specify the minor engine version in one of the following formats:
               - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
               - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
               - rds: The instance runs RDS Basic or High-availability Edition.
               - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
               - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
               - SQLServer: <Minor engine version>. Example: 15.0.4073.23.
               
               > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
        :param pulumi.Input[bool] upgrade_db_instance_kernel_version: Whether to upgrade a minor version of the kernel. Valid values:
               - true: upgrade
               - false: not to upgrade
        :param pulumi.Input[str] upgrade_time: The method to update the minor engine version. Default value: Immediate. It is valid only when `upgrade_db_instance_kernel_version = true`. Valid values:
               - Immediate: The minor engine version is immediately updated.
               - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
               - SpecifyTime: The minor engine version is updated at the point in time you specify.
        :param pulumi.Input[str] vswitch_id: The virtual switch ID to launch DB instances in one VPC.
        :param pulumi.Input[str] whitelist_network_type: The network type of the IP address whitelist. Default value: MIX. Valid values:
               - Classic: classic network in enhanced whitelist mode
               - VPC: virtual private cloud (VPC) in enhanced whitelist mode
               - MIX: standard whitelist mode
               > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
        :param pulumi.Input[str] zone_id: The Zone to launch the DB instance.
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if ca_type is not None:
            pulumi.set(__self__, "ca_type", ca_type)
        if client_ca_cert is not None:
            pulumi.set(__self__, "client_ca_cert", client_ca_cert)
        if client_ca_enabled is not None:
            pulumi.set(__self__, "client_ca_enabled", client_ca_enabled)
        if client_cert_revocation_list is not None:
            pulumi.set(__self__, "client_cert_revocation_list", client_cert_revocation_list)
        if client_crl_enabled is not None:
            pulumi.set(__self__, "client_crl_enabled", client_crl_enabled)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if db_instance_ip_array_attribute is not None:
            pulumi.set(__self__, "db_instance_ip_array_attribute", db_instance_ip_array_attribute)
        if db_instance_ip_array_name is not None:
            pulumi.set(__self__, "db_instance_ip_array_name", db_instance_ip_array_name)
        if db_instance_storage_type is not None:
            pulumi.set(__self__, "db_instance_storage_type", db_instance_storage_type)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if force_restart is not None:
            pulumi.set(__self__, "force_restart", force_restart)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_storage is not None:
            pulumi.set(__self__, "instance_storage", instance_storage)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if master_db_instance_id is not None:
            pulumi.set(__self__, "master_db_instance_id", master_db_instance_id)
        if modify_mode is not None:
            pulumi.set(__self__, "modify_mode", modify_mode)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if replication_acl is not None:
            pulumi.set(__self__, "replication_acl", replication_acl)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_ip_type is not None:
            pulumi.set(__self__, "security_ip_type", security_ip_type)
        if security_ips is not None:
            pulumi.set(__self__, "security_ips", security_ips)
        if server_cert is not None:
            pulumi.set(__self__, "server_cert", server_cert)
        if server_key is not None:
            pulumi.set(__self__, "server_key", server_key)
        if ssl_enabled is not None:
            pulumi.set(__self__, "ssl_enabled", ssl_enabled)
        if switch_time is not None:
            pulumi.set(__self__, "switch_time", switch_time)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_minor_version is not None:
            pulumi.set(__self__, "target_minor_version", target_minor_version)
        if upgrade_db_instance_kernel_version is not None:
            pulumi.set(__self__, "upgrade_db_instance_kernel_version", upgrade_db_instance_kernel_version)
        if upgrade_time is not None:
            pulumi.set(__self__, "upgrade_time", upgrade_time)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if whitelist_network_type is not None:
            pulumi.set(__self__, "whitelist_network_type", whitelist_network_type)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[str]]:
        """
        The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. It is valid only when `ssl_enabled  = 1`. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to renewal a DB instance automatically or not. It is valid when instance_charge_type is `PrePaid`. Default to `false`.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        Auto-renewal period of an instance, in the unit of the month. It is valid when instance_charge_type is `PrePaid`. Valid value:[1~12], Default to 1.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_period", value)

    @property
    @pulumi.getter(name="caType")
    def ca_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. It is valid only when `ssl_enabled  = 1`. Value range:
        - aliyun: a cloud certificate
        - custom: a custom certificate
        """
        return pulumi.get(self, "ca_type")

    @ca_type.setter
    def ca_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_type", value)

    @property
    @pulumi.getter(name="clientCaCert")
    def client_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        """
        return pulumi.get(self, "client_ca_cert")

    @client_ca_cert.setter
    def client_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_ca_cert", value)

    @property
    @pulumi.getter(name="clientCaEnabled")
    def client_ca_enabled(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. It is valid only when `ssl_enabled  = 1`. Valid values:
        - 1: enables the public key
        - 0: disables the public key
        """
        return pulumi.get(self, "client_ca_enabled")

    @client_ca_enabled.setter
    def client_ca_enabled(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "client_ca_enabled", value)

    @property
    @pulumi.getter(name="clientCertRevocationList")
    def client_cert_revocation_list(self) -> Optional[pulumi.Input[str]]:
        """
        The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        """
        return pulumi.get(self, "client_cert_revocation_list")

    @client_cert_revocation_list.setter
    def client_cert_revocation_list(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_cert_revocation_list", value)

    @property
    @pulumi.getter(name="clientCrlEnabled")
    def client_crl_enabled(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. It is valid only when `ssl_enabled  = 1`. Valid values:
        - 1: enables the CRL
        - 0: disables the CRL
        """
        return pulumi.get(self, "client_crl_enabled")

    @client_crl_enabled.setter
    def client_crl_enabled(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "client_crl_enabled", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        RDS database connection string.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="dbInstanceIpArrayAttribute")
    def db_instance_ip_array_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        The attribute of the IP address whitelist. By default, this parameter is empty.

        > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
        """
        return pulumi.get(self, "db_instance_ip_array_attribute")

    @db_instance_ip_array_attribute.setter
    def db_instance_ip_array_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_instance_ip_array_attribute", value)

    @property
    @pulumi.getter(name="dbInstanceIpArrayName")
    def db_instance_ip_array_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the IP address whitelist. Default value: Default.

        > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
        """
        return pulumi.get(self, "db_instance_ip_array_name")

    @db_instance_ip_array_name.setter
    def db_instance_ip_array_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_instance_ip_array_name", value)

    @property
    @pulumi.getter(name="dbInstanceStorageType")
    def db_instance_storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        The storage type of the instance. Valid values:
        - local_ssd: specifies to use local SSDs. This value is recommended.
        - cloud_ssd: specifies to use standard SSDs.
        - cloud_essd: specifies to use enhanced SSDs (ESSDs).
        - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
        - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
        """
        return pulumi.get(self, "db_instance_storage_type")

    @db_instance_storage_type.setter
    def db_instance_storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_instance_storage_type", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        The switch of delete protection. Valid values:
        - true: delete protect.
        - false: no delete protect.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[str]]:
        """
        The instance configuration type. Valid values:
        - Up
        - Down
        - TempUpgrade
        - Serverless
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[pulumi.Input[str]]:
        """
        The method to change.  Default value: Immediate. Valid values:
        - Immediate: The change immediately takes effect.
        - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
        """
        return pulumi.get(self, "effective_time")

    @effective_time.setter
    def effective_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effective_time", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        """
        Database type.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> Optional[pulumi.Input[bool]]:
        """
        Set it to true to make some parameter efficient when modifying them. Default to false.
        """
        return pulumi.get(self, "force_restart")

    @force_restart.setter
    def force_restart(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_restart", value)

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Valid values are `Prepaid`, `Postpaid`, Default to `Postpaid`. The interval between the two conversion operations must be greater than 15 minutes. Only when this parameter is `Postpaid`, the instance can be released.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_charge_type", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of DB instance. It a string of 2 to 256 characters.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceStorage")
    def instance_storage(self) -> Optional[pulumi.Input[int]]:
        """
        User-defined DB instance storage space. Value range: [5, 2000] for MySQL/SQL Server HA dual node edition. Increase progressively at a rate of 5 GB. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
        """
        return pulumi.get(self, "instance_storage")

    @instance_storage.setter
    def instance_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_storage", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        DB Instance type. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="masterDbInstanceId")
    def master_db_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the master instance.
        """
        return pulumi.get(self, "master_db_instance_id")

    @master_db_instance_id.setter
    def master_db_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_db_instance_id", value)

    @property
    @pulumi.getter(name="modifyMode")
    def modify_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
        - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
        - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
        - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
        """
        return pulumi.get(self, "modify_mode")

    @modify_mode.setter
    def modify_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modify_mode", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReadOnlyInstanceParameterArgs']]]]:
        """
        Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm). See `parameters` below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReadOnlyInstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The duration that you will buy DB instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        RDS database connection port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="replicationAcl")
    def replication_acl(self) -> Optional[pulumi.Input[str]]:
        """
        The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. It is valid only when `ssl_enabled  = 1`. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
        """
        return pulumi.get(self, "replication_acl")

    @replication_acl.setter
    def replication_acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_acl", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of resource group which the DB read-only instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="securityIpType")
    def security_ip_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of IP address in the IP address whitelist.
        """
        return pulumi.get(self, "security_ip_type")

    @security_ip_type.setter
    def security_ip_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_ip_type", value)

    @property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        """
        return pulumi.get(self, "security_ips")

    @security_ips.setter
    def security_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_ips", value)

    @property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        """
        return pulumi.get(self, "server_cert")

    @server_cert.setter
    def server_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_cert", value)

    @property
    @pulumi.getter(name="serverKey")
    def server_key(self) -> Optional[pulumi.Input[str]]:
        """
        The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        """
        return pulumi.get(self, "server_key")

    @server_key.setter
    def server_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_key", value)

    @property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies whether to enable or disable SSL encryption. Valid values:
        - 1: enables SSL encryption
        - 0: disables SSL encryption
        """
        return pulumi.get(self, "ssl_enabled")

    @ssl_enabled.setter
    def ssl_enabled(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ssl_enabled", value)

    @property
    @pulumi.getter(name="switchTime")
    def switch_time(self) -> Optional[pulumi.Input[str]]:
        """
        The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `upgrade_db_instance_kernel_version = true`. The time must be in UTC.

        > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
        """
        return pulumi.get(self, "switch_time")

    @switch_time.setter
    def switch_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "switch_time", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetMinorVersion")
    def target_minor_version(self) -> Optional[pulumi.Input[str]]:
        """
        The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. It is valid only when `upgrade_db_instance_kernel_version = true`. You must specify the minor engine version in one of the following formats:
        - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
        - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
        - rds: The instance runs RDS Basic or High-availability Edition.
        - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
        - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
        - SQLServer: <Minor engine version>. Example: 15.0.4073.23.

        > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
        """
        return pulumi.get(self, "target_minor_version")

    @target_minor_version.setter
    def target_minor_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_minor_version", value)

    @property
    @pulumi.getter(name="upgradeDbInstanceKernelVersion")
    def upgrade_db_instance_kernel_version(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to upgrade a minor version of the kernel. Valid values:
        - true: upgrade
        - false: not to upgrade
        """
        return pulumi.get(self, "upgrade_db_instance_kernel_version")

    @upgrade_db_instance_kernel_version.setter
    def upgrade_db_instance_kernel_version(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "upgrade_db_instance_kernel_version", value)

    @property
    @pulumi.getter(name="upgradeTime")
    def upgrade_time(self) -> Optional[pulumi.Input[str]]:
        """
        The method to update the minor engine version. Default value: Immediate. It is valid only when `upgrade_db_instance_kernel_version = true`. Valid values:
        - Immediate: The minor engine version is immediately updated.
        - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
        - SpecifyTime: The minor engine version is updated at the point in time you specify.
        """
        return pulumi.get(self, "upgrade_time")

    @upgrade_time.setter
    def upgrade_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "upgrade_time", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The virtual switch ID to launch DB instances in one VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="whitelistNetworkType")
    def whitelist_network_type(self) -> Optional[pulumi.Input[str]]:
        """
        The network type of the IP address whitelist. Default value: MIX. Valid values:
        - Classic: classic network in enhanced whitelist mode
        - VPC: virtual private cloud (VPC) in enhanced whitelist mode
        - MIX: standard whitelist mode
        > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
        """
        return pulumi.get(self, "whitelist_network_type")

    @whitelist_network_type.setter
    def whitelist_network_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "whitelist_network_type", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Zone to launch the DB instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class ReadOnlyInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 ca_type: Optional[pulumi.Input[str]] = None,
                 client_ca_cert: Optional[pulumi.Input[str]] = None,
                 client_ca_enabled: Optional[pulumi.Input[int]] = None,
                 client_cert_revocation_list: Optional[pulumi.Input[str]] = None,
                 client_crl_enabled: Optional[pulumi.Input[int]] = None,
                 db_instance_ip_array_attribute: Optional[pulumi.Input[str]] = None,
                 db_instance_ip_array_name: Optional[pulumi.Input[str]] = None,
                 db_instance_storage_type: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 effective_time: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 force_restart: Optional[pulumi.Input[bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_storage: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 master_db_instance_id: Optional[pulumi.Input[str]] = None,
                 modify_mode: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReadOnlyInstanceParameterArgs']]]]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 replication_acl: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_ip_type: Optional[pulumi.Input[str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 server_cert: Optional[pulumi.Input[str]] = None,
                 server_key: Optional[pulumi.Input[str]] = None,
                 ssl_enabled: Optional[pulumi.Input[int]] = None,
                 switch_time: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_minor_version: Optional[pulumi.Input[str]] = None,
                 upgrade_db_instance_kernel_version: Optional[pulumi.Input[bool]] = None,
                 upgrade_time: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 whitelist_network_type: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an RDS readonly instance resource, see [What is DB Readonly Instance](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/api-rds-2014-08-15-createreadonlydbinstance).

        > **NOTE:** Available since v1.52.1.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        example_zones = alicloud.rds.get_zones(engine="MySQL",
            engine_version="5.6")
        example_network = alicloud.vpc.Network("exampleNetwork",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        example_switch = alicloud.vpc.Switch("exampleSwitch",
            vpc_id=example_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=example_zones.zones[0].id,
            vswitch_name=name)
        example_security_group = alicloud.ecs.SecurityGroup("exampleSecurityGroup", vpc_id=example_network.id)
        example_instance = alicloud.rds.Instance("exampleInstance",
            engine="MySQL",
            engine_version="5.6",
            instance_type="rds.mysql.t1.small",
            instance_storage=20,
            instance_charge_type="Postpaid",
            instance_name=name,
            vswitch_id=example_switch.id,
            security_ips=[
                "10.168.1.12",
                "100.69.7.112",
            ])
        example_read_only_instance = alicloud.rds.ReadOnlyInstance("exampleReadOnlyInstance",
            zone_id=example_instance.zone_id,
            master_db_instance_id=example_instance.id,
            engine_version=example_instance.engine_version,
            instance_storage=example_instance.instance_storage,
            instance_type=example_instance.instance_type,
            instance_name=f"{name}readonly",
            vswitch_id=example_switch.id)
        ```

        ## Import

        RDS readonly instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:rds/readOnlyInstance:ReadOnlyInstance example rm-abc12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] acl: The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. It is valid only when `ssl_enabled  = 1`. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param pulumi.Input[bool] auto_renew: Whether to renewal a DB instance automatically or not. It is valid when instance_charge_type is `PrePaid`. Default to `false`.
        :param pulumi.Input[int] auto_renew_period: Auto-renewal period of an instance, in the unit of the month. It is valid when instance_charge_type is `PrePaid`. Valid value:[1~12], Default to 1.
        :param pulumi.Input[str] ca_type: The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. It is valid only when `ssl_enabled  = 1`. Value range:
               - aliyun: a cloud certificate
               - custom: a custom certificate
        :param pulumi.Input[str] client_ca_cert: The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        :param pulumi.Input[int] client_ca_enabled: Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. It is valid only when `ssl_enabled  = 1`. Valid values:
               - 1: enables the public key
               - 0: disables the public key
        :param pulumi.Input[str] client_cert_revocation_list: The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        :param pulumi.Input[int] client_crl_enabled: Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. It is valid only when `ssl_enabled  = 1`. Valid values:
               - 1: enables the CRL
               - 0: disables the CRL
        :param pulumi.Input[str] db_instance_ip_array_attribute: The attribute of the IP address whitelist. By default, this parameter is empty.
               
               > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
        :param pulumi.Input[str] db_instance_ip_array_name: The name of the IP address whitelist. Default value: Default.
               
               > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
        :param pulumi.Input[str] db_instance_storage_type: The storage type of the instance. Valid values:
               - local_ssd: specifies to use local SSDs. This value is recommended.
               - cloud_ssd: specifies to use standard SSDs.
               - cloud_essd: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
        :param pulumi.Input[bool] deletion_protection: The switch of delete protection. Valid values:
               - true: delete protect.
               - false: no delete protect.
        :param pulumi.Input[str] direction: The instance configuration type. Valid values:
               - Up
               - Down
               - TempUpgrade
               - Serverless
        :param pulumi.Input[str] effective_time: The method to change.  Default value: Immediate. Valid values:
               - Immediate: The change immediately takes effect.
               - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
        :param pulumi.Input[str] engine_version: Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
        :param pulumi.Input[bool] force_restart: Set it to true to make some parameter efficient when modifying them. Default to false.
        :param pulumi.Input[str] instance_charge_type: Valid values are `Prepaid`, `Postpaid`, Default to `Postpaid`. The interval between the two conversion operations must be greater than 15 minutes. Only when this parameter is `Postpaid`, the instance can be released.
        :param pulumi.Input[str] instance_name: The name of DB instance. It a string of 2 to 256 characters.
        :param pulumi.Input[int] instance_storage: User-defined DB instance storage space. Value range: [5, 2000] for MySQL/SQL Server HA dual node edition. Increase progressively at a rate of 5 GB. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
        :param pulumi.Input[str] instance_type: DB Instance type. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
        :param pulumi.Input[str] master_db_instance_id: ID of the master instance.
        :param pulumi.Input[str] modify_mode: The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
               - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
               - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
               - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReadOnlyInstanceParameterArgs']]]] parameters: Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm). See `parameters` below.
        :param pulumi.Input[int] period: The duration that you will buy DB instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
        :param pulumi.Input[str] replication_acl: The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. It is valid only when `ssl_enabled  = 1`. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
               > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
        :param pulumi.Input[str] resource_group_id: The ID of resource group which the DB read-only instance belongs.
        :param pulumi.Input[str] security_ip_type: The type of IP address in the IP address whitelist.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_ips: List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        :param pulumi.Input[str] server_cert: The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        :param pulumi.Input[str] server_key: The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        :param pulumi.Input[int] ssl_enabled: Specifies whether to enable or disable SSL encryption. Valid values:
               - 1: enables SSL encryption
               - 0: disables SSL encryption
        :param pulumi.Input[str] switch_time: The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `upgrade_db_instance_kernel_version = true`. The time must be in UTC.
               
               > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[str] target_minor_version: The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. It is valid only when `upgrade_db_instance_kernel_version = true`. You must specify the minor engine version in one of the following formats:
               - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
               - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
               - rds: The instance runs RDS Basic or High-availability Edition.
               - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
               - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
               - SQLServer: <Minor engine version>. Example: 15.0.4073.23.
               
               > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
        :param pulumi.Input[bool] upgrade_db_instance_kernel_version: Whether to upgrade a minor version of the kernel. Valid values:
               - true: upgrade
               - false: not to upgrade
        :param pulumi.Input[str] upgrade_time: The method to update the minor engine version. Default value: Immediate. It is valid only when `upgrade_db_instance_kernel_version = true`. Valid values:
               - Immediate: The minor engine version is immediately updated.
               - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
               - SpecifyTime: The minor engine version is updated at the point in time you specify.
        :param pulumi.Input[str] vswitch_id: The virtual switch ID to launch DB instances in one VPC.
        :param pulumi.Input[str] whitelist_network_type: The network type of the IP address whitelist. Default value: MIX. Valid values:
               - Classic: classic network in enhanced whitelist mode
               - VPC: virtual private cloud (VPC) in enhanced whitelist mode
               - MIX: standard whitelist mode
               > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
        :param pulumi.Input[str] zone_id: The Zone to launch the DB instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReadOnlyInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an RDS readonly instance resource, see [What is DB Readonly Instance](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/api-rds-2014-08-15-createreadonlydbinstance).

        > **NOTE:** Available since v1.52.1.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        example_zones = alicloud.rds.get_zones(engine="MySQL",
            engine_version="5.6")
        example_network = alicloud.vpc.Network("exampleNetwork",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        example_switch = alicloud.vpc.Switch("exampleSwitch",
            vpc_id=example_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=example_zones.zones[0].id,
            vswitch_name=name)
        example_security_group = alicloud.ecs.SecurityGroup("exampleSecurityGroup", vpc_id=example_network.id)
        example_instance = alicloud.rds.Instance("exampleInstance",
            engine="MySQL",
            engine_version="5.6",
            instance_type="rds.mysql.t1.small",
            instance_storage=20,
            instance_charge_type="Postpaid",
            instance_name=name,
            vswitch_id=example_switch.id,
            security_ips=[
                "10.168.1.12",
                "100.69.7.112",
            ])
        example_read_only_instance = alicloud.rds.ReadOnlyInstance("exampleReadOnlyInstance",
            zone_id=example_instance.zone_id,
            master_db_instance_id=example_instance.id,
            engine_version=example_instance.engine_version,
            instance_storage=example_instance.instance_storage,
            instance_type=example_instance.instance_type,
            instance_name=f"{name}readonly",
            vswitch_id=example_switch.id)
        ```

        ## Import

        RDS readonly instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:rds/readOnlyInstance:ReadOnlyInstance example rm-abc12345678
        ```

        :param str resource_name: The name of the resource.
        :param ReadOnlyInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReadOnlyInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 ca_type: Optional[pulumi.Input[str]] = None,
                 client_ca_cert: Optional[pulumi.Input[str]] = None,
                 client_ca_enabled: Optional[pulumi.Input[int]] = None,
                 client_cert_revocation_list: Optional[pulumi.Input[str]] = None,
                 client_crl_enabled: Optional[pulumi.Input[int]] = None,
                 db_instance_ip_array_attribute: Optional[pulumi.Input[str]] = None,
                 db_instance_ip_array_name: Optional[pulumi.Input[str]] = None,
                 db_instance_storage_type: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 effective_time: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 force_restart: Optional[pulumi.Input[bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_storage: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 master_db_instance_id: Optional[pulumi.Input[str]] = None,
                 modify_mode: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReadOnlyInstanceParameterArgs']]]]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 replication_acl: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_ip_type: Optional[pulumi.Input[str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 server_cert: Optional[pulumi.Input[str]] = None,
                 server_key: Optional[pulumi.Input[str]] = None,
                 ssl_enabled: Optional[pulumi.Input[int]] = None,
                 switch_time: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_minor_version: Optional[pulumi.Input[str]] = None,
                 upgrade_db_instance_kernel_version: Optional[pulumi.Input[bool]] = None,
                 upgrade_time: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 whitelist_network_type: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReadOnlyInstanceArgs.__new__(ReadOnlyInstanceArgs)

            __props__.__dict__["acl"] = acl
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["auto_renew_period"] = auto_renew_period
            __props__.__dict__["ca_type"] = ca_type
            __props__.__dict__["client_ca_cert"] = client_ca_cert
            __props__.__dict__["client_ca_enabled"] = client_ca_enabled
            __props__.__dict__["client_cert_revocation_list"] = client_cert_revocation_list
            __props__.__dict__["client_crl_enabled"] = client_crl_enabled
            __props__.__dict__["db_instance_ip_array_attribute"] = db_instance_ip_array_attribute
            __props__.__dict__["db_instance_ip_array_name"] = db_instance_ip_array_name
            __props__.__dict__["db_instance_storage_type"] = db_instance_storage_type
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["direction"] = direction
            __props__.__dict__["effective_time"] = effective_time
            if engine_version is None and not opts.urn:
                raise TypeError("Missing required property 'engine_version'")
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["force_restart"] = force_restart
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            __props__.__dict__["instance_name"] = instance_name
            if instance_storage is None and not opts.urn:
                raise TypeError("Missing required property 'instance_storage'")
            __props__.__dict__["instance_storage"] = instance_storage
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            if master_db_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'master_db_instance_id'")
            __props__.__dict__["master_db_instance_id"] = master_db_instance_id
            __props__.__dict__["modify_mode"] = modify_mode
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["period"] = period
            __props__.__dict__["replication_acl"] = replication_acl
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["security_ip_type"] = security_ip_type
            __props__.__dict__["security_ips"] = security_ips
            __props__.__dict__["server_cert"] = server_cert
            __props__.__dict__["server_key"] = server_key
            __props__.__dict__["ssl_enabled"] = ssl_enabled
            __props__.__dict__["switch_time"] = switch_time
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_minor_version"] = target_minor_version
            __props__.__dict__["upgrade_db_instance_kernel_version"] = upgrade_db_instance_kernel_version
            __props__.__dict__["upgrade_time"] = upgrade_time
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["whitelist_network_type"] = whitelist_network_type
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["connection_string"] = None
            __props__.__dict__["engine"] = None
            __props__.__dict__["port"] = None
        super(ReadOnlyInstance, __self__).__init__(
            'alicloud:rds/readOnlyInstance:ReadOnlyInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[str]] = None,
            auto_renew: Optional[pulumi.Input[bool]] = None,
            auto_renew_period: Optional[pulumi.Input[int]] = None,
            ca_type: Optional[pulumi.Input[str]] = None,
            client_ca_cert: Optional[pulumi.Input[str]] = None,
            client_ca_enabled: Optional[pulumi.Input[int]] = None,
            client_cert_revocation_list: Optional[pulumi.Input[str]] = None,
            client_crl_enabled: Optional[pulumi.Input[int]] = None,
            connection_string: Optional[pulumi.Input[str]] = None,
            db_instance_ip_array_attribute: Optional[pulumi.Input[str]] = None,
            db_instance_ip_array_name: Optional[pulumi.Input[str]] = None,
            db_instance_storage_type: Optional[pulumi.Input[str]] = None,
            deletion_protection: Optional[pulumi.Input[bool]] = None,
            direction: Optional[pulumi.Input[str]] = None,
            effective_time: Optional[pulumi.Input[str]] = None,
            engine: Optional[pulumi.Input[str]] = None,
            engine_version: Optional[pulumi.Input[str]] = None,
            force_restart: Optional[pulumi.Input[bool]] = None,
            instance_charge_type: Optional[pulumi.Input[str]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            instance_storage: Optional[pulumi.Input[int]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            master_db_instance_id: Optional[pulumi.Input[str]] = None,
            modify_mode: Optional[pulumi.Input[str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReadOnlyInstanceParameterArgs']]]]] = None,
            period: Optional[pulumi.Input[int]] = None,
            port: Optional[pulumi.Input[str]] = None,
            replication_acl: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            security_ip_type: Optional[pulumi.Input[str]] = None,
            security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            server_cert: Optional[pulumi.Input[str]] = None,
            server_key: Optional[pulumi.Input[str]] = None,
            ssl_enabled: Optional[pulumi.Input[int]] = None,
            switch_time: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            target_minor_version: Optional[pulumi.Input[str]] = None,
            upgrade_db_instance_kernel_version: Optional[pulumi.Input[bool]] = None,
            upgrade_time: Optional[pulumi.Input[str]] = None,
            vswitch_id: Optional[pulumi.Input[str]] = None,
            whitelist_network_type: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'ReadOnlyInstance':
        """
        Get an existing ReadOnlyInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] acl: The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. It is valid only when `ssl_enabled  = 1`. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param pulumi.Input[bool] auto_renew: Whether to renewal a DB instance automatically or not. It is valid when instance_charge_type is `PrePaid`. Default to `false`.
        :param pulumi.Input[int] auto_renew_period: Auto-renewal period of an instance, in the unit of the month. It is valid when instance_charge_type is `PrePaid`. Valid value:[1~12], Default to 1.
        :param pulumi.Input[str] ca_type: The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. It is valid only when `ssl_enabled  = 1`. Value range:
               - aliyun: a cloud certificate
               - custom: a custom certificate
        :param pulumi.Input[str] client_ca_cert: The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        :param pulumi.Input[int] client_ca_enabled: Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. It is valid only when `ssl_enabled  = 1`. Valid values:
               - 1: enables the public key
               - 0: disables the public key
        :param pulumi.Input[str] client_cert_revocation_list: The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        :param pulumi.Input[int] client_crl_enabled: Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. It is valid only when `ssl_enabled  = 1`. Valid values:
               - 1: enables the CRL
               - 0: disables the CRL
        :param pulumi.Input[str] connection_string: RDS database connection string.
        :param pulumi.Input[str] db_instance_ip_array_attribute: The attribute of the IP address whitelist. By default, this parameter is empty.
               
               > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
        :param pulumi.Input[str] db_instance_ip_array_name: The name of the IP address whitelist. Default value: Default.
               
               > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
        :param pulumi.Input[str] db_instance_storage_type: The storage type of the instance. Valid values:
               - local_ssd: specifies to use local SSDs. This value is recommended.
               - cloud_ssd: specifies to use standard SSDs.
               - cloud_essd: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
        :param pulumi.Input[bool] deletion_protection: The switch of delete protection. Valid values:
               - true: delete protect.
               - false: no delete protect.
        :param pulumi.Input[str] direction: The instance configuration type. Valid values:
               - Up
               - Down
               - TempUpgrade
               - Serverless
        :param pulumi.Input[str] effective_time: The method to change.  Default value: Immediate. Valid values:
               - Immediate: The change immediately takes effect.
               - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
        :param pulumi.Input[str] engine: Database type.
        :param pulumi.Input[str] engine_version: Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
        :param pulumi.Input[bool] force_restart: Set it to true to make some parameter efficient when modifying them. Default to false.
        :param pulumi.Input[str] instance_charge_type: Valid values are `Prepaid`, `Postpaid`, Default to `Postpaid`. The interval between the two conversion operations must be greater than 15 minutes. Only when this parameter is `Postpaid`, the instance can be released.
        :param pulumi.Input[str] instance_name: The name of DB instance. It a string of 2 to 256 characters.
        :param pulumi.Input[int] instance_storage: User-defined DB instance storage space. Value range: [5, 2000] for MySQL/SQL Server HA dual node edition. Increase progressively at a rate of 5 GB. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
        :param pulumi.Input[str] instance_type: DB Instance type. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
        :param pulumi.Input[str] master_db_instance_id: ID of the master instance.
        :param pulumi.Input[str] modify_mode: The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
               - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
               - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
               - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReadOnlyInstanceParameterArgs']]]] parameters: Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm). See `parameters` below.
        :param pulumi.Input[int] period: The duration that you will buy DB instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
        :param pulumi.Input[str] port: RDS database connection port.
        :param pulumi.Input[str] replication_acl: The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. It is valid only when `ssl_enabled  = 1`. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
               > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
        :param pulumi.Input[str] resource_group_id: The ID of resource group which the DB read-only instance belongs.
        :param pulumi.Input[str] security_ip_type: The type of IP address in the IP address whitelist.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_ips: List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        :param pulumi.Input[str] server_cert: The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        :param pulumi.Input[str] server_key: The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        :param pulumi.Input[int] ssl_enabled: Specifies whether to enable or disable SSL encryption. Valid values:
               - 1: enables SSL encryption
               - 0: disables SSL encryption
        :param pulumi.Input[str] switch_time: The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `upgrade_db_instance_kernel_version = true`. The time must be in UTC.
               
               > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[str] target_minor_version: The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. It is valid only when `upgrade_db_instance_kernel_version = true`. You must specify the minor engine version in one of the following formats:
               - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
               - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
               - rds: The instance runs RDS Basic or High-availability Edition.
               - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
               - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
               - SQLServer: <Minor engine version>. Example: 15.0.4073.23.
               
               > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
        :param pulumi.Input[bool] upgrade_db_instance_kernel_version: Whether to upgrade a minor version of the kernel. Valid values:
               - true: upgrade
               - false: not to upgrade
        :param pulumi.Input[str] upgrade_time: The method to update the minor engine version. Default value: Immediate. It is valid only when `upgrade_db_instance_kernel_version = true`. Valid values:
               - Immediate: The minor engine version is immediately updated.
               - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
               - SpecifyTime: The minor engine version is updated at the point in time you specify.
        :param pulumi.Input[str] vswitch_id: The virtual switch ID to launch DB instances in one VPC.
        :param pulumi.Input[str] whitelist_network_type: The network type of the IP address whitelist. Default value: MIX. Valid values:
               - Classic: classic network in enhanced whitelist mode
               - VPC: virtual private cloud (VPC) in enhanced whitelist mode
               - MIX: standard whitelist mode
               > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
        :param pulumi.Input[str] zone_id: The Zone to launch the DB instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReadOnlyInstanceState.__new__(_ReadOnlyInstanceState)

        __props__.__dict__["acl"] = acl
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["auto_renew_period"] = auto_renew_period
        __props__.__dict__["ca_type"] = ca_type
        __props__.__dict__["client_ca_cert"] = client_ca_cert
        __props__.__dict__["client_ca_enabled"] = client_ca_enabled
        __props__.__dict__["client_cert_revocation_list"] = client_cert_revocation_list
        __props__.__dict__["client_crl_enabled"] = client_crl_enabled
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["db_instance_ip_array_attribute"] = db_instance_ip_array_attribute
        __props__.__dict__["db_instance_ip_array_name"] = db_instance_ip_array_name
        __props__.__dict__["db_instance_storage_type"] = db_instance_storage_type
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["direction"] = direction
        __props__.__dict__["effective_time"] = effective_time
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["force_restart"] = force_restart
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_storage"] = instance_storage
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["master_db_instance_id"] = master_db_instance_id
        __props__.__dict__["modify_mode"] = modify_mode
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["period"] = period
        __props__.__dict__["port"] = port
        __props__.__dict__["replication_acl"] = replication_acl
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["security_ip_type"] = security_ip_type
        __props__.__dict__["security_ips"] = security_ips
        __props__.__dict__["server_cert"] = server_cert
        __props__.__dict__["server_key"] = server_key
        __props__.__dict__["ssl_enabled"] = ssl_enabled
        __props__.__dict__["switch_time"] = switch_time
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_minor_version"] = target_minor_version
        __props__.__dict__["upgrade_db_instance_kernel_version"] = upgrade_db_instance_kernel_version
        __props__.__dict__["upgrade_time"] = upgrade_time
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["whitelist_network_type"] = whitelist_network_type
        __props__.__dict__["zone_id"] = zone_id
        return ReadOnlyInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output[str]:
        """
        The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. It is valid only when `ssl_enabled  = 1`. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to renewal a DB instance automatically or not. It is valid when instance_charge_type is `PrePaid`. Default to `false`.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> pulumi.Output[Optional[int]]:
        """
        Auto-renewal period of an instance, in the unit of the month. It is valid when instance_charge_type is `PrePaid`. Valid value:[1~12], Default to 1.
        """
        return pulumi.get(self, "auto_renew_period")

    @property
    @pulumi.getter(name="caType")
    def ca_type(self) -> pulumi.Output[str]:
        """
        The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. It is valid only when `ssl_enabled  = 1`. Value range:
        - aliyun: a cloud certificate
        - custom: a custom certificate
        """
        return pulumi.get(self, "ca_type")

    @property
    @pulumi.getter(name="clientCaCert")
    def client_ca_cert(self) -> pulumi.Output[Optional[str]]:
        """
        The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        """
        return pulumi.get(self, "client_ca_cert")

    @property
    @pulumi.getter(name="clientCaEnabled")
    def client_ca_enabled(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. It is valid only when `ssl_enabled  = 1`. Valid values:
        - 1: enables the public key
        - 0: disables the public key
        """
        return pulumi.get(self, "client_ca_enabled")

    @property
    @pulumi.getter(name="clientCertRevocationList")
    def client_cert_revocation_list(self) -> pulumi.Output[Optional[str]]:
        """
        The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        """
        return pulumi.get(self, "client_cert_revocation_list")

    @property
    @pulumi.getter(name="clientCrlEnabled")
    def client_crl_enabled(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. It is valid only when `ssl_enabled  = 1`. Valid values:
        - 1: enables the CRL
        - 0: disables the CRL
        """
        return pulumi.get(self, "client_crl_enabled")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[str]:
        """
        RDS database connection string.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="dbInstanceIpArrayAttribute")
    def db_instance_ip_array_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        The attribute of the IP address whitelist. By default, this parameter is empty.

        > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
        """
        return pulumi.get(self, "db_instance_ip_array_attribute")

    @property
    @pulumi.getter(name="dbInstanceIpArrayName")
    def db_instance_ip_array_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the IP address whitelist. Default value: Default.

        > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
        """
        return pulumi.get(self, "db_instance_ip_array_name")

    @property
    @pulumi.getter(name="dbInstanceStorageType")
    def db_instance_storage_type(self) -> pulumi.Output[str]:
        """
        The storage type of the instance. Valid values:
        - local_ssd: specifies to use local SSDs. This value is recommended.
        - cloud_ssd: specifies to use standard SSDs.
        - cloud_essd: specifies to use enhanced SSDs (ESSDs).
        - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
        - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
        """
        return pulumi.get(self, "db_instance_storage_type")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        The switch of delete protection. Valid values:
        - true: delete protect.
        - false: no delete protect.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Output[Optional[str]]:
        """
        The instance configuration type. Valid values:
        - Up
        - Down
        - TempUpgrade
        - Serverless
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> pulumi.Output[Optional[str]]:
        """
        The method to change.  Default value: Immediate. Valid values:
        - Immediate: The change immediately takes effect.
        - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
        """
        return pulumi.get(self, "effective_time")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[str]:
        """
        Database type.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[str]:
        """
        Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> pulumi.Output[Optional[bool]]:
        """
        Set it to true to make some parameter efficient when modifying them. Default to false.
        """
        return pulumi.get(self, "force_restart")

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> pulumi.Output[Optional[str]]:
        """
        Valid values are `Prepaid`, `Postpaid`, Default to `Postpaid`. The interval between the two conversion operations must be greater than 15 minutes. Only when this parameter is `Postpaid`, the instance can be released.
        """
        return pulumi.get(self, "instance_charge_type")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[str]:
        """
        The name of DB instance. It a string of 2 to 256 characters.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceStorage")
    def instance_storage(self) -> pulumi.Output[int]:
        """
        User-defined DB instance storage space. Value range: [5, 2000] for MySQL/SQL Server HA dual node edition. Increase progressively at a rate of 5 GB. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
        """
        return pulumi.get(self, "instance_storage")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        DB Instance type. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="masterDbInstanceId")
    def master_db_instance_id(self) -> pulumi.Output[str]:
        """
        ID of the master instance.
        """
        return pulumi.get(self, "master_db_instance_id")

    @property
    @pulumi.getter(name="modifyMode")
    def modify_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
        - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
        - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
        - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
        """
        return pulumi.get(self, "modify_mode")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Sequence['outputs.ReadOnlyInstanceParameter']]:
        """
        Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm). See `parameters` below.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        The duration that you will buy DB instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[str]:
        """
        RDS database connection port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="replicationAcl")
    def replication_acl(self) -> pulumi.Output[str]:
        """
        The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. It is valid only when `ssl_enabled  = 1`. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
        """
        return pulumi.get(self, "replication_acl")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The ID of resource group which the DB read-only instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="securityIpType")
    def security_ip_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of IP address in the IP address whitelist.
        """
        return pulumi.get(self, "security_ip_type")

    @property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> pulumi.Output[Sequence[str]]:
        """
        List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        """
        return pulumi.get(self, "security_ips")

    @property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> pulumi.Output[str]:
        """
        The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        """
        return pulumi.get(self, "server_cert")

    @property
    @pulumi.getter(name="serverKey")
    def server_key(self) -> pulumi.Output[str]:
        """
        The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. It is valid only when `ssl_enabled  = 1`.
        """
        return pulumi.get(self, "server_key")

    @property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> pulumi.Output[int]:
        """
        Specifies whether to enable or disable SSL encryption. Valid values:
        - 1: enables SSL encryption
        - 0: disables SSL encryption
        """
        return pulumi.get(self, "ssl_enabled")

    @property
    @pulumi.getter(name="switchTime")
    def switch_time(self) -> pulumi.Output[Optional[str]]:
        """
        The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `upgrade_db_instance_kernel_version = true`. The time must be in UTC.

        > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
        """
        return pulumi.get(self, "switch_time")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetMinorVersion")
    def target_minor_version(self) -> pulumi.Output[str]:
        """
        The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. It is valid only when `upgrade_db_instance_kernel_version = true`. You must specify the minor engine version in one of the following formats:
        - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
        - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
        - rds: The instance runs RDS Basic or High-availability Edition.
        - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
        - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
        - SQLServer: <Minor engine version>. Example: 15.0.4073.23.

        > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
        """
        return pulumi.get(self, "target_minor_version")

    @property
    @pulumi.getter(name="upgradeDbInstanceKernelVersion")
    def upgrade_db_instance_kernel_version(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to upgrade a minor version of the kernel. Valid values:
        - true: upgrade
        - false: not to upgrade
        """
        return pulumi.get(self, "upgrade_db_instance_kernel_version")

    @property
    @pulumi.getter(name="upgradeTime")
    def upgrade_time(self) -> pulumi.Output[Optional[str]]:
        """
        The method to update the minor engine version. Default value: Immediate. It is valid only when `upgrade_db_instance_kernel_version = true`. Valid values:
        - Immediate: The minor engine version is immediately updated.
        - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
        - SpecifyTime: The minor engine version is updated at the point in time you specify.
        """
        return pulumi.get(self, "upgrade_time")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[str]]:
        """
        The virtual switch ID to launch DB instances in one VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="whitelistNetworkType")
    def whitelist_network_type(self) -> pulumi.Output[Optional[str]]:
        """
        The network type of the IP address whitelist. Default value: MIX. Valid values:
        - Classic: classic network in enhanced whitelist mode
        - VPC: virtual private cloud (VPC) in enhanced whitelist mode
        - MIX: standard whitelist mode
        > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
        """
        return pulumi.get(self, "whitelist_network_type")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The Zone to launch the DB instance.
        """
        return pulumi.get(self, "zone_id")

