# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ResourceGroupRegionStatus',
    'GetAccountDeletionCheckTaskAbandonAbleCheckResult',
    'GetAccountDeletionCheckTaskNotAllowReasonResult',
    'GetAccountsAccountResult',
    'GetControlPoliciesPolicyResult',
    'GetControlPolicyAttachmentsAttachmentResult',
    'GetDelegatedAdministratorsAdministratorResult',
    'GetFoldersFolderResult',
    'GetHandshakesHandshakeResult',
    'GetPoliciesPolicyResult',
    'GetPolicyAttachmentsAttachmentResult',
    'GetPolicyVersionsVersionResult',
    'GetResourceDirectoriesDirectoryResult',
    'GetResourceGroupsGroupResult',
    'GetResourceGroupsGroupRegionStatusResult',
    'GetResourceSharesShareResult',
    'GetRolesRoleResult',
    'GetSharedResourcesResourceResult',
    'GetSharedTargetsTargetResult',
]

@pulumi.output_type
class ResourceGroupRegionStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionId":
            suggest = "region_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceGroupRegionStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceGroupRegionStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceGroupRegionStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region_id: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param str region_id: The region ID.
        :param str status: The status of the regional resource group.
        """
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[str]:
        """
        The region ID.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the regional resource group.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetAccountDeletionCheckTaskAbandonAbleCheckResult(dict):
    def __init__(__self__, *,
                 check_id: str,
                 check_name: str,
                 description: str):
        """
        :param str check_id: The ID of the check item.
        :param str check_name: The name of the cloud service to which the check item belongs.
        :param str description: The description of the check item.
        """
        pulumi.set(__self__, "check_id", check_id)
        pulumi.set(__self__, "check_name", check_name)
        pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="checkId")
    def check_id(self) -> str:
        """
        The ID of the check item.
        """
        return pulumi.get(self, "check_id")

    @property
    @pulumi.getter(name="checkName")
    def check_name(self) -> str:
        """
        The name of the cloud service to which the check item belongs.
        """
        return pulumi.get(self, "check_name")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the check item.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class GetAccountDeletionCheckTaskNotAllowReasonResult(dict):
    def __init__(__self__, *,
                 check_id: str,
                 check_name: str,
                 description: str):
        """
        :param str check_id: The ID of the check item.
        :param str check_name: The name of the cloud service to which the check item belongs.
        :param str description: The description of the check item.
        """
        pulumi.set(__self__, "check_id", check_id)
        pulumi.set(__self__, "check_name", check_name)
        pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="checkId")
    def check_id(self) -> str:
        """
        The ID of the check item.
        """
        return pulumi.get(self, "check_id")

    @property
    @pulumi.getter(name="checkName")
    def check_name(self) -> str:
        """
        The name of the cloud service to which the check item belongs.
        """
        return pulumi.get(self, "check_name")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the check item.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class GetAccountsAccountResult(dict):
    def __init__(__self__, *,
                 account_id: str,
                 account_name: str,
                 display_name: str,
                 folder_id: str,
                 id: str,
                 join_method: str,
                 join_time: str,
                 modify_time: str,
                 payer_account_id: str,
                 resource_directory_id: str,
                 status: str,
                 type: str):
        """
        :param str account_id: The ID of the account.
        :param str account_name: (Available in v1.125.0+) The Alibaba Cloud account name of the member account.
        :param str display_name: The name of the member account.
        :param str folder_id: The ID of the folder.
        :param str id: The ID of the resource.
        :param str join_method: The way in which the member account joined the resource directory.
        :param str join_time: The time when the member account joined the resource directory.
        :param str modify_time: The time when the member account was modified.
        :param str payer_account_id: (Available in v1.124.3+) Settlement account ID. If the value is empty, the current account will be used for settlement.
        :param str resource_directory_id: The ID of the resource directory.
        :param str status: The status of account, valid values: `CreateCancelled`, `CreateExpired`, `CreateFailed`, `CreateSuccess`, `CreateVerifying`, `InviteSuccess`, `PromoteCancelled`, `PromoteExpired`, `PromoteFailed`, `PromoteSuccess`, and `PromoteVerifying`.
        :param str type: The type of the member account.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "folder_id", folder_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "join_method", join_method)
        pulumi.set(__self__, "join_time", join_time)
        pulumi.set(__self__, "modify_time", modify_time)
        pulumi.set(__self__, "payer_account_id", payer_account_id)
        pulumi.set(__self__, "resource_directory_id", resource_directory_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The ID of the account.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        (Available in v1.125.0+) The Alibaba Cloud account name of the member account.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The name of the member account.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> str:
        """
        The ID of the folder.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="joinMethod")
    def join_method(self) -> str:
        """
        The way in which the member account joined the resource directory.
        """
        return pulumi.get(self, "join_method")

    @property
    @pulumi.getter(name="joinTime")
    def join_time(self) -> str:
        """
        The time when the member account joined the resource directory.
        """
        return pulumi.get(self, "join_time")

    @property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> str:
        """
        The time when the member account was modified.
        """
        return pulumi.get(self, "modify_time")

    @property
    @pulumi.getter(name="payerAccountId")
    def payer_account_id(self) -> str:
        """
        (Available in v1.124.3+) Settlement account ID. If the value is empty, the current account will be used for settlement.
        """
        return pulumi.get(self, "payer_account_id")

    @property
    @pulumi.getter(name="resourceDirectoryId")
    def resource_directory_id(self) -> str:
        """
        The ID of the resource directory.
        """
        return pulumi.get(self, "resource_directory_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of account, valid values: `CreateCancelled`, `CreateExpired`, `CreateFailed`, `CreateSuccess`, `CreateVerifying`, `InviteSuccess`, `PromoteCancelled`, `PromoteExpired`, `PromoteFailed`, `PromoteSuccess`, and `PromoteVerifying`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the member account.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetControlPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 attachment_count: int,
                 control_policy_name: str,
                 description: str,
                 effect_scope: str,
                 id: str,
                 policy_document: str,
                 policy_id: str,
                 policy_type: str):
        """
        :param int attachment_count: The count of policy attachment.
        :param str control_policy_name: The name of policy.
        :param str description: The description of policy.
        :param str effect_scope: The effect scope.
        :param str id: The ID of the Control Policy.
        :param str policy_document: The policy document.
        :param str policy_id: The ID of policy.
        :param str policy_type: The type of policy.
        """
        pulumi.set(__self__, "attachment_count", attachment_count)
        pulumi.set(__self__, "control_policy_name", control_policy_name)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "effect_scope", effect_scope)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "policy_document", policy_document)
        pulumi.set(__self__, "policy_id", policy_id)
        pulumi.set(__self__, "policy_type", policy_type)

    @property
    @pulumi.getter(name="attachmentCount")
    def attachment_count(self) -> int:
        """
        The count of policy attachment.
        """
        return pulumi.get(self, "attachment_count")

    @property
    @pulumi.getter(name="controlPolicyName")
    def control_policy_name(self) -> str:
        """
        The name of policy.
        """
        return pulumi.get(self, "control_policy_name")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectScope")
    def effect_scope(self) -> str:
        """
        The effect scope.
        """
        return pulumi.get(self, "effect_scope")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Control Policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> str:
        """
        The policy document.
        """
        return pulumi.get(self, "policy_document")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> str:
        """
        The ID of policy.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> str:
        """
        The type of policy.
        """
        return pulumi.get(self, "policy_type")


@pulumi.output_type
class GetControlPolicyAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 attach_date: str,
                 description: str,
                 id: str,
                 policy_id: str,
                 policy_name: str,
                 policy_type: str):
        """
        :param str attach_date: The attach date.
        :param str description: The description of policy.
        :param str id: The ID of the Control Policy Attachment.
        :param str policy_id: The ID of policy.
        :param str policy_name: The name of policy.
        :param str policy_type: The type of policy.
        """
        pulumi.set(__self__, "attach_date", attach_date)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "policy_id", policy_id)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "policy_type", policy_type)

    @property
    @pulumi.getter(name="attachDate")
    def attach_date(self) -> str:
        """
        The attach date.
        """
        return pulumi.get(self, "attach_date")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Control Policy Attachment.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> str:
        """
        The ID of policy.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> str:
        """
        The name of policy.
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> str:
        """
        The type of policy.
        """
        return pulumi.get(self, "policy_type")


@pulumi.output_type
class GetDelegatedAdministratorsAdministratorResult(dict):
    def __init__(__self__, *,
                 account_id: str,
                 delegation_enabled_time: str,
                 id: str,
                 service_principal: str):
        """
        :param str account_id: The ID of the member account.
        :param str delegation_enabled_time: The time when the member was specified as a delegated administrator account.
        :param str id: The ID of the Delegated Administrator.
        :param str service_principal: The identity of the trusted service.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "delegation_enabled_time", delegation_enabled_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "service_principal", service_principal)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The ID of the member account.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="delegationEnabledTime")
    def delegation_enabled_time(self) -> str:
        """
        The time when the member was specified as a delegated administrator account.
        """
        return pulumi.get(self, "delegation_enabled_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Delegated Administrator.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="servicePrincipal")
    def service_principal(self) -> str:
        """
        The identity of the trusted service.
        """
        return pulumi.get(self, "service_principal")


@pulumi.output_type
class GetFoldersFolderResult(dict):
    def __init__(__self__, *,
                 folder_id: str,
                 folder_name: str,
                 id: str,
                 parent_folder_id: str):
        """
        :param str folder_id: The ID of the folder.
        :param str folder_name: The name of the folder.
        :param str id: The ID of the folder.
        :param str parent_folder_id: The ID of the parent folder.
        """
        pulumi.set(__self__, "folder_id", folder_id)
        pulumi.set(__self__, "folder_name", folder_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "parent_folder_id", parent_folder_id)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> str:
        """
        The ID of the folder.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter(name="folderName")
    def folder_name(self) -> str:
        """
        The name of the folder.
        """
        return pulumi.get(self, "folder_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the folder.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="parentFolderId")
    def parent_folder_id(self) -> str:
        """
        The ID of the parent folder.
        """
        return pulumi.get(self, "parent_folder_id")


@pulumi.output_type
class GetHandshakesHandshakeResult(dict):
    def __init__(__self__, *,
                 expire_time: str,
                 handshake_id: str,
                 id: str,
                 invited_account_real_name: str,
                 master_account_id: str,
                 master_account_name: str,
                 master_account_real_name: str,
                 modify_time: str,
                 note: str,
                 resource_directory_id: str,
                 status: str,
                 target_entity: str,
                 target_type: str):
        """
        :param str expire_time: The time when the invitation expires.
        :param str handshake_id: The ID of the invitation.
        :param str id: The ID of the resource.
        :param str invited_account_real_name: (Available in v1.114.0+) The real name of the invited account.
        :param str master_account_id: The ID of the master account of the resource directory.
        :param str master_account_name: The name of the master account of the resource directory.
        :param str master_account_real_name: (Available in v1.114.0+) The real name of the master account of the resource directory.
        :param str modify_time: The time when the invitation was modified.
        :param str note: The invitation note.
        :param str resource_directory_id: The ID of the resource directory.
        :param str status: The status of handshake, valid values: `Accepted`, `Cancelled`, `Declined`, `Deleted`, `Expired` and `Pending`.
        :param str target_entity: The ID or logon email address of the invited account.
        :param str target_type: The type of the invited account.
        """
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "handshake_id", handshake_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "invited_account_real_name", invited_account_real_name)
        pulumi.set(__self__, "master_account_id", master_account_id)
        pulumi.set(__self__, "master_account_name", master_account_name)
        pulumi.set(__self__, "master_account_real_name", master_account_real_name)
        pulumi.set(__self__, "modify_time", modify_time)
        pulumi.set(__self__, "note", note)
        pulumi.set(__self__, "resource_directory_id", resource_directory_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "target_entity", target_entity)
        pulumi.set(__self__, "target_type", target_type)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        The time when the invitation expires.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter(name="handshakeId")
    def handshake_id(self) -> str:
        """
        The ID of the invitation.
        """
        return pulumi.get(self, "handshake_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="invitedAccountRealName")
    def invited_account_real_name(self) -> str:
        """
        (Available in v1.114.0+) The real name of the invited account.
        """
        return pulumi.get(self, "invited_account_real_name")

    @property
    @pulumi.getter(name="masterAccountId")
    def master_account_id(self) -> str:
        """
        The ID of the master account of the resource directory.
        """
        return pulumi.get(self, "master_account_id")

    @property
    @pulumi.getter(name="masterAccountName")
    def master_account_name(self) -> str:
        """
        The name of the master account of the resource directory.
        """
        return pulumi.get(self, "master_account_name")

    @property
    @pulumi.getter(name="masterAccountRealName")
    def master_account_real_name(self) -> str:
        """
        (Available in v1.114.0+) The real name of the master account of the resource directory.
        """
        return pulumi.get(self, "master_account_real_name")

    @property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> str:
        """
        The time when the invitation was modified.
        """
        return pulumi.get(self, "modify_time")

    @property
    @pulumi.getter
    def note(self) -> str:
        """
        The invitation note.
        """
        return pulumi.get(self, "note")

    @property
    @pulumi.getter(name="resourceDirectoryId")
    def resource_directory_id(self) -> str:
        """
        The ID of the resource directory.
        """
        return pulumi.get(self, "resource_directory_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of handshake, valid values: `Accepted`, `Cancelled`, `Declined`, `Deleted`, `Expired` and `Pending`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="targetEntity")
    def target_entity(self) -> str:
        """
        The ID or logon email address of the invited account.
        """
        return pulumi.get(self, "target_entity")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> str:
        """
        The type of the invited account.
        """
        return pulumi.get(self, "target_type")


@pulumi.output_type
class GetPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 attachment_count: int,
                 default_version: str,
                 description: str,
                 id: str,
                 policy_name: str,
                 policy_type: str,
                 update_date: str):
        """
        :param int attachment_count: The number of times the policy is referenced.
        :param str default_version: The default version of the policy.
        :param str description: The description of the policy.
        :param str id: The ID of the policy.
        :param str policy_name: The name of the policy.
        :param str policy_type: The type of the policy. If you do not specify this parameter, the system lists all types of policies. Valid values: `Custom` and `System`.
        :param str update_date: The time when the policy was updated.
        """
        pulumi.set(__self__, "attachment_count", attachment_count)
        pulumi.set(__self__, "default_version", default_version)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "policy_type", policy_type)
        pulumi.set(__self__, "update_date", update_date)

    @property
    @pulumi.getter(name="attachmentCount")
    def attachment_count(self) -> int:
        """
        The number of times the policy is referenced.
        """
        return pulumi.get(self, "attachment_count")

    @property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> str:
        """
        The default version of the policy.
        """
        return pulumi.get(self, "default_version")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> str:
        """
        The name of the policy.
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> str:
        """
        The type of the policy. If you do not specify this parameter, the system lists all types of policies. Valid values: `Custom` and `System`.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="updateDate")
    def update_date(self) -> str:
        """
        The time when the policy was updated.
        """
        return pulumi.get(self, "update_date")


@pulumi.output_type
class GetPolicyAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 attach_date: str,
                 description: str,
                 id: str,
                 policy_name: str,
                 policy_type: str,
                 principal_name: str,
                 principal_type: str,
                 resource_group_id: str):
        """
        :param str attach_date: The time when the policy was attached.
        :param str description: The description of the policy.
        :param str id: The ID of the Resource Manager Policy Attachment.
        :param str policy_name: The name of the policy. The name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
        :param str policy_type: The type of the policy. Valid values: `Custom` and `System`.
        :param str principal_name: The name of the object to which the policy is attached.
        :param str principal_type: The type of the object to which the policy is attached. If you do not specify this parameter, the system lists all types of objects. Valid values: `IMSUser`: RAM user, `IMSGroup`: RAM user group, `ServiceRole`: RAM role.
        :param str resource_group_id: The ID of the resource group or the ID of the Alibaba Cloud account to which the resource group belongs. If you do not specify this parameter, the system lists all policy attachment records under the current account.
        """
        pulumi.set(__self__, "attach_date", attach_date)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "policy_type", policy_type)
        pulumi.set(__self__, "principal_name", principal_name)
        pulumi.set(__self__, "principal_type", principal_type)
        pulumi.set(__self__, "resource_group_id", resource_group_id)

    @property
    @pulumi.getter(name="attachDate")
    def attach_date(self) -> str:
        """
        The time when the policy was attached.
        """
        return pulumi.get(self, "attach_date")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Resource Manager Policy Attachment.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> str:
        """
        The name of the policy. The name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> str:
        """
        The type of the policy. Valid values: `Custom` and `System`.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="principalName")
    def principal_name(self) -> str:
        """
        The name of the object to which the policy is attached.
        """
        return pulumi.get(self, "principal_name")

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> str:
        """
        The type of the object to which the policy is attached. If you do not specify this parameter, the system lists all types of objects. Valid values: `IMSUser`: RAM user, `IMSGroup`: RAM user group, `ServiceRole`: RAM role.
        """
        return pulumi.get(self, "principal_type")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The ID of the resource group or the ID of the Alibaba Cloud account to which the resource group belongs. If you do not specify this parameter, the system lists all policy attachment records under the current account.
        """
        return pulumi.get(self, "resource_group_id")


@pulumi.output_type
class GetPolicyVersionsVersionResult(dict):
    def __init__(__self__, *,
                 id: str,
                 is_default_version: bool,
                 policy_document: str,
                 version_id: str):
        """
        :param str id: The ID of the resource, the value is `<policy_name>`:`<version_id>`.
        :param bool is_default_version: Indicates whether the policy version is the default version.
        :param str policy_document: (Available in v1.114.0+) The policy document of the policy version.
        :param str version_id: The ID of the policy version.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_default_version", is_default_version)
        pulumi.set(__self__, "policy_document", policy_document)
        pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the resource, the value is `<policy_name>`:`<version_id>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefaultVersion")
    def is_default_version(self) -> bool:
        """
        Indicates whether the policy version is the default version.
        """
        return pulumi.get(self, "is_default_version")

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> str:
        """
        (Available in v1.114.0+) The policy document of the policy version.
        """
        return pulumi.get(self, "policy_document")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> str:
        """
        The ID of the policy version.
        """
        return pulumi.get(self, "version_id")


@pulumi.output_type
class GetResourceDirectoriesDirectoryResult(dict):
    def __init__(__self__, *,
                 id: str,
                 master_account_id: str,
                 master_account_name: str,
                 resource_directory_id: str,
                 root_folder_id: str,
                 status: str):
        """
        :param str id: The ID of resource directory.
        :param str master_account_id: The ID of the master account.
        :param str master_account_name: The name of the master account.
        :param str resource_directory_id: The ID of the resource directory.
        :param str root_folder_id: The ID of the root folder.
        :param str status: (Available in 1.120.0+.) The status of the control policy.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "master_account_id", master_account_id)
        pulumi.set(__self__, "master_account_name", master_account_name)
        pulumi.set(__self__, "resource_directory_id", resource_directory_id)
        pulumi.set(__self__, "root_folder_id", root_folder_id)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of resource directory.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="masterAccountId")
    def master_account_id(self) -> str:
        """
        The ID of the master account.
        """
        return pulumi.get(self, "master_account_id")

    @property
    @pulumi.getter(name="masterAccountName")
    def master_account_name(self) -> str:
        """
        The name of the master account.
        """
        return pulumi.get(self, "master_account_name")

    @property
    @pulumi.getter(name="resourceDirectoryId")
    def resource_directory_id(self) -> str:
        """
        The ID of the resource directory.
        """
        return pulumi.get(self, "resource_directory_id")

    @property
    @pulumi.getter(name="rootFolderId")
    def root_folder_id(self) -> str:
        """
        The ID of the root folder.
        """
        return pulumi.get(self, "root_folder_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        (Available in 1.120.0+.) The status of the control policy.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetResourceGroupsGroupResult(dict):
    def __init__(__self__, *,
                 account_id: str,
                 display_name: str,
                 id: str,
                 name: str,
                 region_statuses: Sequence['outputs.GetResourceGroupsGroupRegionStatusResult'],
                 resource_group_name: str,
                 status: str):
        """
        :param str account_id: The ID of the Alibaba Cloud account to which the resource group belongs.
        :param str display_name: The display name of the resource group.
        :param str id: The ID of the resource group.
        :param str name: The unique identifier of the resource group.
        :param Sequence['GetResourceGroupsGroupRegionStatusArgs'] region_statuses: (Available since v1.114.0) The status of the resource group in all regions.
        :param str resource_group_name: (Available since v1.114.0) The unique identifier of the resource group.
        :param str status: The status of the resource group. Valid values: `Creating`, `Deleted`, `Deleting`, `OK` and `PendingDelete`. **NOTE:** From version 1.114.0, `status` can be set to `Deleting`.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region_statuses", region_statuses)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The ID of the Alibaba Cloud account to which the resource group belongs.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the resource group.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique identifier of the resource group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="regionStatuses")
    def region_statuses(self) -> Sequence['outputs.GetResourceGroupsGroupRegionStatusResult']:
        """
        (Available since v1.114.0) The status of the resource group in all regions.
        """
        return pulumi.get(self, "region_statuses")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> str:
        """
        (Available since v1.114.0) The unique identifier of the resource group.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource group. Valid values: `Creating`, `Deleted`, `Deleting`, `OK` and `PendingDelete`. **NOTE:** From version 1.114.0, `status` can be set to `Deleting`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetResourceGroupsGroupRegionStatusResult(dict):
    def __init__(__self__, *,
                 region_id: str,
                 status: str):
        """
        :param str region_id: The region ID.
        :param str status: The status of the resource group. Valid values: `Creating`, `Deleted`, `Deleting`, `OK` and `PendingDelete`. **NOTE:** From version 1.114.0, `status` can be set to `Deleting`.
        """
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        The region ID.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource group. Valid values: `Creating`, `Deleted`, `Deleting`, `OK` and `PendingDelete`. **NOTE:** From version 1.114.0, `status` can be set to `Deleting`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetResourceSharesShareResult(dict):
    def __init__(__self__, *,
                 id: str,
                 resource_share_id: str,
                 resource_share_name: str,
                 resource_share_owner: str,
                 status: str):
        """
        :param str id: The ID of the Resource Share.
        :param str resource_share_id: The ID of the resource share.
        :param str resource_share_name: The name of resource share.
        :param str resource_share_owner: The owner of resource share.
        :param str status: The status of resource share.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_share_id", resource_share_id)
        pulumi.set(__self__, "resource_share_name", resource_share_name)
        pulumi.set(__self__, "resource_share_owner", resource_share_owner)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Resource Share.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceShareId")
    def resource_share_id(self) -> str:
        """
        The ID of the resource share.
        """
        return pulumi.get(self, "resource_share_id")

    @property
    @pulumi.getter(name="resourceShareName")
    def resource_share_name(self) -> str:
        """
        The name of resource share.
        """
        return pulumi.get(self, "resource_share_name")

    @property
    @pulumi.getter(name="resourceShareOwner")
    def resource_share_owner(self) -> str:
        """
        The owner of resource share.
        """
        return pulumi.get(self, "resource_share_owner")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of resource share.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetRolesRoleResult(dict):
    def __init__(__self__, *,
                 arn: str,
                 assume_role_policy_document: str,
                 description: str,
                 id: str,
                 max_session_duration: int,
                 role_id: str,
                 role_name: str,
                 update_date: str):
        """
        :param str arn: The Alibaba Cloud Resource Name (ARN) of the RAM role.
        :param str assume_role_policy_document: (Available in v1.114.0+) The assume role policy document.
        :param str description: The description of the RAM role.
        :param str id: The ID of the role.
        :param int max_session_duration: The maximum session duration of the RAM role.
        :param str role_id: The ID of the role.
        :param str role_name: The name of the role.
        :param str update_date: The time when the RAM role was updated.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "assume_role_policy_document", assume_role_policy_document)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "max_session_duration", max_session_duration)
        pulumi.set(__self__, "role_id", role_id)
        pulumi.set(__self__, "role_name", role_name)
        pulumi.set(__self__, "update_date", update_date)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        The Alibaba Cloud Resource Name (ARN) of the RAM role.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="assumeRolePolicyDocument")
    def assume_role_policy_document(self) -> str:
        """
        (Available in v1.114.0+) The assume role policy document.
        """
        return pulumi.get(self, "assume_role_policy_document")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the RAM role.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the role.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxSessionDuration")
    def max_session_duration(self) -> int:
        """
        The maximum session duration of the RAM role.
        """
        return pulumi.get(self, "max_session_duration")

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> str:
        """
        The ID of the role.
        """
        return pulumi.get(self, "role_id")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> str:
        """
        The name of the role.
        """
        return pulumi.get(self, "role_name")

    @property
    @pulumi.getter(name="updateDate")
    def update_date(self) -> str:
        """
        The time when the RAM role was updated.
        """
        return pulumi.get(self, "update_date")


@pulumi.output_type
class GetSharedResourcesResourceResult(dict):
    def __init__(__self__, *,
                 id: str,
                 resource_id: str,
                 resource_share_id: str,
                 resource_type: str,
                 status: str):
        """
        :param str id: The ID of the Shared Resource. It formats as `<resource_id>:<resource_type>`.
        :param str resource_id: The ID of the shared resource.
        :param str resource_share_id: The resource share ID of resource manager.
        :param str resource_type: The type of shared resource.
        :param str status: The status of share resource. Valid values: `Associated`, `Associating`, `Disassociated`, `Disassociating` and `Failed`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_share_id", resource_share_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Shared Resource. It formats as `<resource_id>:<resource_type>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The ID of the shared resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceShareId")
    def resource_share_id(self) -> str:
        """
        The resource share ID of resource manager.
        """
        return pulumi.get(self, "resource_share_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The type of shared resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of share resource. Valid values: `Associated`, `Associating`, `Disassociated`, `Disassociating` and `Failed`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetSharedTargetsTargetResult(dict):
    def __init__(__self__, *,
                 id: str,
                 resource_share_id: str,
                 status: str,
                 target_id: str):
        """
        :param str id: The ID of the Shared Target.
        :param str resource_share_id: The resource share ID of resource manager.
        :param str status: The status of share resource. Valid values: `Associated`, `Associating`, `Disassociated`, `Disassociating` and `Failed`.
        :param str target_id: The ID of the Shared Target.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_share_id", resource_share_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "target_id", target_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Shared Target.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceShareId")
    def resource_share_id(self) -> str:
        """
        The resource share ID of resource manager.
        """
        return pulumi.get(self, "resource_share_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of share resource. Valid values: `Associated`, `Associating`, `Disassociated`, `Disassociating` and `Failed`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        The ID of the Shared Target.
        """
        return pulumi.get(self, "target_id")


