# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ResourceShareArgs', 'ResourceShare']

@pulumi.input_type
class ResourceShareArgs:
    def __init__(__self__, *,
                 resource_share_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a ResourceShare resource.
        :param pulumi.Input[str] resource_share_name: The name of resource share.
        """
        pulumi.set(__self__, "resource_share_name", resource_share_name)

    @property
    @pulumi.getter(name="resourceShareName")
    def resource_share_name(self) -> pulumi.Input[str]:
        """
        The name of resource share.
        """
        return pulumi.get(self, "resource_share_name")

    @resource_share_name.setter
    def resource_share_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_share_name", value)


@pulumi.input_type
class _ResourceShareState:
    def __init__(__self__, *,
                 resource_share_name: Optional[pulumi.Input[str]] = None,
                 resource_share_owner: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ResourceShare resources.
        :param pulumi.Input[str] resource_share_name: The name of resource share.
        :param pulumi.Input[str] resource_share_owner: The owner of the Resource Share.
        :param pulumi.Input[str] status: The status of the Resource Share.
        """
        if resource_share_name is not None:
            pulumi.set(__self__, "resource_share_name", resource_share_name)
        if resource_share_owner is not None:
            pulumi.set(__self__, "resource_share_owner", resource_share_owner)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="resourceShareName")
    def resource_share_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of resource share.
        """
        return pulumi.get(self, "resource_share_name")

    @resource_share_name.setter
    def resource_share_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_share_name", value)

    @property
    @pulumi.getter(name="resourceShareOwner")
    def resource_share_owner(self) -> Optional[pulumi.Input[str]]:
        """
        The owner of the Resource Share.
        """
        return pulumi.get(self, "resource_share_owner")

    @resource_share_owner.setter
    def resource_share_owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_share_owner", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the Resource Share.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class ResourceShare(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_share_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Resource Manager Resource Share resource.

        For information about Resource Manager Resource Share and how to use it, see [What is Resource Share](https://www.alibabacloud.com/help/en/doc-detail/94475.htm).

        > **NOTE:** Available since v1.111.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        example = alicloud.resourcemanager.ResourceShare("example", resource_share_name=name)
        ```

        ## Import

        Resource Manager Resource Share can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:resourcemanager/resourceShare:ResourceShare example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] resource_share_name: The name of resource share.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResourceShareArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Resource Manager Resource Share resource.

        For information about Resource Manager Resource Share and how to use it, see [What is Resource Share](https://www.alibabacloud.com/help/en/doc-detail/94475.htm).

        > **NOTE:** Available since v1.111.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        example = alicloud.resourcemanager.ResourceShare("example", resource_share_name=name)
        ```

        ## Import

        Resource Manager Resource Share can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:resourcemanager/resourceShare:ResourceShare example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ResourceShareArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourceShareArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_share_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourceShareArgs.__new__(ResourceShareArgs)

            if resource_share_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_share_name'")
            __props__.__dict__["resource_share_name"] = resource_share_name
            __props__.__dict__["resource_share_owner"] = None
            __props__.__dict__["status"] = None
        super(ResourceShare, __self__).__init__(
            'alicloud:resourcemanager/resourceShare:ResourceShare',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            resource_share_name: Optional[pulumi.Input[str]] = None,
            resource_share_owner: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'ResourceShare':
        """
        Get an existing ResourceShare resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] resource_share_name: The name of resource share.
        :param pulumi.Input[str] resource_share_owner: The owner of the Resource Share.
        :param pulumi.Input[str] status: The status of the Resource Share.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourceShareState.__new__(_ResourceShareState)

        __props__.__dict__["resource_share_name"] = resource_share_name
        __props__.__dict__["resource_share_owner"] = resource_share_owner
        __props__.__dict__["status"] = status
        return ResourceShare(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="resourceShareName")
    def resource_share_name(self) -> pulumi.Output[str]:
        """
        The name of resource share.
        """
        return pulumi.get(self, "resource_share_name")

    @property
    @pulumi.getter(name="resourceShareOwner")
    def resource_share_owner(self) -> pulumi.Output[str]:
        """
        The owner of the Resource Share.
        """
        return pulumi.get(self, "resource_share_owner")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the Resource Share.
        """
        return pulumi.get(self, "status")

