# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConsumerGroupArgs', 'ConsumerGroup']

@pulumi.input_type
class ConsumerGroupArgs:
    def __init__(__self__, *,
                 consume_retry_policy: pulumi.Input['ConsumerGroupConsumeRetryPolicyArgs'],
                 consumer_group_id: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 delivery_order_type: Optional[pulumi.Input[str]] = None,
                 remark: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ConsumerGroup resource.
        :param pulumi.Input['ConsumerGroupConsumeRetryPolicyArgs'] consume_retry_policy: Consumption retry strategy. See `consume_retry_policy` below.
        :param pulumi.Input[str] consumer_group_id: The first ID of the resource.
        :param pulumi.Input[str] instance_id: Instance ID.
        :param pulumi.Input[str] delivery_order_type: Delivery order.
        :param pulumi.Input[str] remark: Custom remarks.
        """
        pulumi.set(__self__, "consume_retry_policy", consume_retry_policy)
        pulumi.set(__self__, "consumer_group_id", consumer_group_id)
        pulumi.set(__self__, "instance_id", instance_id)
        if delivery_order_type is not None:
            pulumi.set(__self__, "delivery_order_type", delivery_order_type)
        if remark is not None:
            pulumi.set(__self__, "remark", remark)

    @property
    @pulumi.getter(name="consumeRetryPolicy")
    def consume_retry_policy(self) -> pulumi.Input['ConsumerGroupConsumeRetryPolicyArgs']:
        """
        Consumption retry strategy. See `consume_retry_policy` below.
        """
        return pulumi.get(self, "consume_retry_policy")

    @consume_retry_policy.setter
    def consume_retry_policy(self, value: pulumi.Input['ConsumerGroupConsumeRetryPolicyArgs']):
        pulumi.set(self, "consume_retry_policy", value)

    @property
    @pulumi.getter(name="consumerGroupId")
    def consumer_group_id(self) -> pulumi.Input[str]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "consumer_group_id")

    @consumer_group_id.setter
    def consumer_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "consumer_group_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="deliveryOrderType")
    def delivery_order_type(self) -> Optional[pulumi.Input[str]]:
        """
        Delivery order.
        """
        return pulumi.get(self, "delivery_order_type")

    @delivery_order_type.setter
    def delivery_order_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delivery_order_type", value)

    @property
    @pulumi.getter
    def remark(self) -> Optional[pulumi.Input[str]]:
        """
        Custom remarks.
        """
        return pulumi.get(self, "remark")

    @remark.setter
    def remark(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remark", value)


@pulumi.input_type
class _ConsumerGroupState:
    def __init__(__self__, *,
                 consume_retry_policy: Optional[pulumi.Input['ConsumerGroupConsumeRetryPolicyArgs']] = None,
                 consumer_group_id: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 delivery_order_type: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 remark: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ConsumerGroup resources.
        :param pulumi.Input['ConsumerGroupConsumeRetryPolicyArgs'] consume_retry_policy: Consumption retry strategy. See `consume_retry_policy` below.
        :param pulumi.Input[str] consumer_group_id: The first ID of the resource.
        :param pulumi.Input[str] create_time: The creation time of the resource.
        :param pulumi.Input[str] delivery_order_type: Delivery order.
        :param pulumi.Input[str] instance_id: Instance ID.
        :param pulumi.Input[str] remark: Custom remarks.
        :param pulumi.Input[str] status: The status of the resource.
        """
        if consume_retry_policy is not None:
            pulumi.set(__self__, "consume_retry_policy", consume_retry_policy)
        if consumer_group_id is not None:
            pulumi.set(__self__, "consumer_group_id", consumer_group_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delivery_order_type is not None:
            pulumi.set(__self__, "delivery_order_type", delivery_order_type)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if remark is not None:
            pulumi.set(__self__, "remark", remark)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="consumeRetryPolicy")
    def consume_retry_policy(self) -> Optional[pulumi.Input['ConsumerGroupConsumeRetryPolicyArgs']]:
        """
        Consumption retry strategy. See `consume_retry_policy` below.
        """
        return pulumi.get(self, "consume_retry_policy")

    @consume_retry_policy.setter
    def consume_retry_policy(self, value: Optional[pulumi.Input['ConsumerGroupConsumeRetryPolicyArgs']]):
        pulumi.set(self, "consume_retry_policy", value)

    @property
    @pulumi.getter(name="consumerGroupId")
    def consumer_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "consumer_group_id")

    @consumer_group_id.setter
    def consumer_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_group_id", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deliveryOrderType")
    def delivery_order_type(self) -> Optional[pulumi.Input[str]]:
        """
        Delivery order.
        """
        return pulumi.get(self, "delivery_order_type")

    @delivery_order_type.setter
    def delivery_order_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delivery_order_type", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def remark(self) -> Optional[pulumi.Input[str]]:
        """
        Custom remarks.
        """
        return pulumi.get(self, "remark")

    @remark.setter
    def remark(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remark", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class ConsumerGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consume_retry_policy: Optional[pulumi.Input[pulumi.InputType['ConsumerGroupConsumeRetryPolicyArgs']]] = None,
                 consumer_group_id: Optional[pulumi.Input[str]] = None,
                 delivery_order_type: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 remark: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a RocketMQ Consumer Group resource.

        For information about RocketMQ Consumer Group and how to use it, see [What is Consumer Group](https://www.alibabacloud.com/help/en/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/developer-reference/api-rocketmq-2022-08-01-createconsumergroup).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        create_vpc = alicloud.vpc.Network("createVpc",
            description="example",
            cidr_block="172.16.0.0/12",
            vpc_name=name)
        create_vswitch = alicloud.vpc.Switch("createVswitch",
            description="example",
            vpc_id=create_vpc.id,
            zone_id=default_zones.zones[0].id,
            cidr_block="172.16.0.0/24",
            vswitch_name=name)
        create_instance = alicloud.rocketmq.RocketMQInstance("createInstance",
            auto_renew_period=1,
            product_info=alicloud.rocketmq.RocketMQInstanceProductInfoArgs(
                msg_process_spec="rmq.p2.4xlarge",
                send_receive_ratio=0.3,
                message_retention_time=70,
            ),
            network_info=alicloud.rocketmq.RocketMQInstanceNetworkInfoArgs(
                vpc_info=alicloud.rocketmq.RocketMQInstanceNetworkInfoVpcInfoArgs(
                    vpc_id=create_vpc.id,
                    vswitch_id=create_vswitch.id,
                ),
                internet_info=alicloud.rocketmq.RocketMQInstanceNetworkInfoInternetInfoArgs(
                    internet_spec="enable",
                    flow_out_type="payByBandwidth",
                    flow_out_bandwidth=30,
                ),
            ),
            period=1,
            sub_series_code="cluster_ha",
            remark="example",
            instance_name=name,
            service_code="rmq",
            series_code="professional",
            payment_type="PayAsYouGo",
            period_unit="Month")
        default_consumer_group = alicloud.rocketmq.ConsumerGroup("defaultConsumerGroup",
            consumer_group_id=name,
            instance_id=create_instance.id,
            consume_retry_policy=alicloud.rocketmq.ConsumerGroupConsumeRetryPolicyArgs(
                retry_policy="DefaultRetryPolicy",
                max_retry_times=10,
            ),
            delivery_order_type="Concurrently",
            remark="example")
        ```

        ## Import

        RocketMQ Consumer Group can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:rocketmq/consumerGroup:ConsumerGroup example <instance_id>:<consumer_group_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ConsumerGroupConsumeRetryPolicyArgs']] consume_retry_policy: Consumption retry strategy. See `consume_retry_policy` below.
        :param pulumi.Input[str] consumer_group_id: The first ID of the resource.
        :param pulumi.Input[str] delivery_order_type: Delivery order.
        :param pulumi.Input[str] instance_id: Instance ID.
        :param pulumi.Input[str] remark: Custom remarks.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConsumerGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a RocketMQ Consumer Group resource.

        For information about RocketMQ Consumer Group and how to use it, see [What is Consumer Group](https://www.alibabacloud.com/help/en/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/developer-reference/api-rocketmq-2022-08-01-createconsumergroup).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        create_vpc = alicloud.vpc.Network("createVpc",
            description="example",
            cidr_block="172.16.0.0/12",
            vpc_name=name)
        create_vswitch = alicloud.vpc.Switch("createVswitch",
            description="example",
            vpc_id=create_vpc.id,
            zone_id=default_zones.zones[0].id,
            cidr_block="172.16.0.0/24",
            vswitch_name=name)
        create_instance = alicloud.rocketmq.RocketMQInstance("createInstance",
            auto_renew_period=1,
            product_info=alicloud.rocketmq.RocketMQInstanceProductInfoArgs(
                msg_process_spec="rmq.p2.4xlarge",
                send_receive_ratio=0.3,
                message_retention_time=70,
            ),
            network_info=alicloud.rocketmq.RocketMQInstanceNetworkInfoArgs(
                vpc_info=alicloud.rocketmq.RocketMQInstanceNetworkInfoVpcInfoArgs(
                    vpc_id=create_vpc.id,
                    vswitch_id=create_vswitch.id,
                ),
                internet_info=alicloud.rocketmq.RocketMQInstanceNetworkInfoInternetInfoArgs(
                    internet_spec="enable",
                    flow_out_type="payByBandwidth",
                    flow_out_bandwidth=30,
                ),
            ),
            period=1,
            sub_series_code="cluster_ha",
            remark="example",
            instance_name=name,
            service_code="rmq",
            series_code="professional",
            payment_type="PayAsYouGo",
            period_unit="Month")
        default_consumer_group = alicloud.rocketmq.ConsumerGroup("defaultConsumerGroup",
            consumer_group_id=name,
            instance_id=create_instance.id,
            consume_retry_policy=alicloud.rocketmq.ConsumerGroupConsumeRetryPolicyArgs(
                retry_policy="DefaultRetryPolicy",
                max_retry_times=10,
            ),
            delivery_order_type="Concurrently",
            remark="example")
        ```

        ## Import

        RocketMQ Consumer Group can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:rocketmq/consumerGroup:ConsumerGroup example <instance_id>:<consumer_group_id>
        ```

        :param str resource_name: The name of the resource.
        :param ConsumerGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConsumerGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consume_retry_policy: Optional[pulumi.Input[pulumi.InputType['ConsumerGroupConsumeRetryPolicyArgs']]] = None,
                 consumer_group_id: Optional[pulumi.Input[str]] = None,
                 delivery_order_type: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 remark: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConsumerGroupArgs.__new__(ConsumerGroupArgs)

            if consume_retry_policy is None and not opts.urn:
                raise TypeError("Missing required property 'consume_retry_policy'")
            __props__.__dict__["consume_retry_policy"] = consume_retry_policy
            if consumer_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'consumer_group_id'")
            __props__.__dict__["consumer_group_id"] = consumer_group_id
            __props__.__dict__["delivery_order_type"] = delivery_order_type
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["remark"] = remark
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(ConsumerGroup, __self__).__init__(
            'alicloud:rocketmq/consumerGroup:ConsumerGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            consume_retry_policy: Optional[pulumi.Input[pulumi.InputType['ConsumerGroupConsumeRetryPolicyArgs']]] = None,
            consumer_group_id: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            delivery_order_type: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            remark: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'ConsumerGroup':
        """
        Get an existing ConsumerGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ConsumerGroupConsumeRetryPolicyArgs']] consume_retry_policy: Consumption retry strategy. See `consume_retry_policy` below.
        :param pulumi.Input[str] consumer_group_id: The first ID of the resource.
        :param pulumi.Input[str] create_time: The creation time of the resource.
        :param pulumi.Input[str] delivery_order_type: Delivery order.
        :param pulumi.Input[str] instance_id: Instance ID.
        :param pulumi.Input[str] remark: Custom remarks.
        :param pulumi.Input[str] status: The status of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConsumerGroupState.__new__(_ConsumerGroupState)

        __props__.__dict__["consume_retry_policy"] = consume_retry_policy
        __props__.__dict__["consumer_group_id"] = consumer_group_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delivery_order_type"] = delivery_order_type
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["remark"] = remark
        __props__.__dict__["status"] = status
        return ConsumerGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="consumeRetryPolicy")
    def consume_retry_policy(self) -> pulumi.Output['outputs.ConsumerGroupConsumeRetryPolicy']:
        """
        Consumption retry strategy. See `consume_retry_policy` below.
        """
        return pulumi.get(self, "consume_retry_policy")

    @property
    @pulumi.getter(name="consumerGroupId")
    def consumer_group_id(self) -> pulumi.Output[str]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "consumer_group_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deliveryOrderType")
    def delivery_order_type(self) -> pulumi.Output[Optional[str]]:
        """
        Delivery order.
        """
        return pulumi.get(self, "delivery_order_type")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Instance ID.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def remark(self) -> pulumi.Output[Optional[str]]:
        """
        Custom remarks.
        """
        return pulumi.get(self, "remark")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

